/* REXX installation script for PMCCopy */

call RxFuncAdd 'SysCls', 'RexxUtil', 'SysCls'
call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'

currentDirectory = directory()
programName = "\pmccopy.exe"
programPath = insert( currentDirectory, programName )
executable = insert( "EXENAME=", programPath )

/*Create a PMCCopy folder with program items on the desktop*/

classname='WPFolder'
title='POLAR TeamOS/2`s^PMCCopy '
location='<WP_DESKTOP>'
setup='OBJECTID=<PMCCOPY_FOLDER>;'|| ,
'ICONFILE='currentDirectory'\pmccopy.ico;'
result = SysCreateObject(classname, title, location, setup, 'R')

classname='WPProgram'
title='PMCCopy ver. 0.4'
location='<PMCCOPY_FOLDER>'
result = SysCreateObject(classname, title, location, executable, 'R')

classname='WPShadow'
title='PMCCopy^ReadMe'; objid=currentDirectory'\Readme' ; loc='<PMCCOPY_FOLDER>';
result=SysCreateObject(classname, title, loc, 'SHADOWID='objid';', 'F')
rc=syssetobjectdata(currentDirectory'\Readme','TITLE=Readme;')
If result=1 Then Say title' Object created'
Else  Say 'Not created, return code='result

call SysCls

say ""
say ""
Say " POLAR TeamOS/2 is pleased to give You:"
Say ""
Say ""
say "----------------------------------------------------------------"
say " PMCCopy - PM interface for CCopy for OS/2'. "
say " Kolbjoern Bekkelund. (C) 1997/98 - All Rights Reserved            "
say "----------------------------------------------------------------"
say ""
say " PMCCopy object successfully created on desktop..."
say ""
say " Start PMCCopy by double-clicking on the program object.        "
say " in the PMCCopy folder."
say ""
say "*****************************************************************"
say "* This program is  distributed as freeware."
say "* The included program, CCopy.exe, is shareware and must *"
say "*  be registered if you  continue  to  use it."
say "* Please  see the documentation for the complete details."
say "*****************************************************************"
say ""

