#define INCL_DOS

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/*
 * Public domain from M. Kimes
 *
 * Compiled with IBM CSet/2 as:
 *   ICC /G4 /O+ /Gs+ /W3 /Kb /Rn /B"/RUNFROMVDM" /B"/STACK:16384" mov.c
 */


VOID ShowHelp (APIRET rc) {

  static RESULTCODES rt;
  static CHAR        object[32],runme[CCHMAXPATH];

  sprintf(runme,"CMD.EXE /C HELP.CMD SYS%04u",rc);
  runme[strlen(runme) + 1] = 0;
  runme[7] = 0;
  DosExecPgm(object,sizeof(object),EXEC_SYNC,(PVOID)runme,NULL,&rt,(PSZ)runme);
}


INT to_upper (INT key) {

  if(key >= 'a' && key <= 'z')
    return ((key) + 'A' - 'a');
  return key;
}


BOOL stri_cmp (CHAR *a,CHAR *b) {

  while(*a && *b) {
    if(to_upper(*a) != to_upper(*b))
      return FALSE;
    a++;
    b++;
  }
  if(*a || *b)
    return FALSE;
  return TRUE;
}


int main (int argc,char *argv[]) {

  static CHAR        from[CCHMAXPATH * 2],to[CCHMAXPATH * 2];
  static BOOL        overwrite = FALSE;
  static FILESTATUS3 fs3f,fs3d;
  CHAR              *p;
  APIRET             rc;

  if(argc >= 2) {
    if(argc > 3) {
      if((*argv[3] == '/' || *argv[3] == '-') && to_upper(argv[3][1]) == 'O')
        overwrite = TRUE;
      else {
        printf("**\07Unknown third argument \"%s\" ignored.\n",argv[3]);
        DosSleep(1000L);
      }
    }
    p = argv[1];
    while(*p) {
      if(*p == '/')
        *p = '\\';
      p++;
    }
    if(argc > 2) {
      p = argv[2];
      while(*p) {
        if(*p == '/')
          *p = '\\';
        p++;
      }
    }
    rc = DosQueryPathInfo(argv[1],FIL_QUERYFULLNAME,from,sizeof(from));
    if(!rc) {
      if(argc > 2)
        rc = DosQueryPathInfo(argv[2],FIL_QUERYFULLNAME,to,sizeof(to));
      else
        rc = DosQueryPathInfo(".",FIL_QUERYFULLNAME,to,sizeof(to));
      if(!rc) {
        rc = DosQueryPathInfo(from,FIL_STANDARD,&fs3f,sizeof(fs3f));
        if(!rc) {
          rc = DosQueryPathInfo(to,FIL_STANDARD,&fs3d,sizeof(fs3d));
          if(!rc) {
            if(!(fs3f.attrFile & FILE_DIRECTORY) &&
               (fs3d.attrFile & FILE_DIRECTORY)) {
              p = strrchr(from,'\\');
              if(p && *(p + 1)) {
                p++;
                if(to[strlen(to) - 1] != '\\')
                  strcat(to,"\\");
                strcat(to,p);
              }
            }
          }
        }
        printf("MOVE%s %s -> %s\n",((overwrite) ? "OVER" : ""),from,to);
        if((!overwrite || stri_cmp(from,to)) &&
           to_upper(*from) == to_upper(*to)) {
          rc = DosMove(from,to);
          if(rc) {
            ShowHelp(rc);
            return rc;
          }
        }
        else {
          rc = DosCopy(from,to,((overwrite) ? DCPY_EXISTING : 0));
          if(rc) {
            ShowHelp(rc);
            return rc;
          }
          else if(!stri_cmp(from,to))
            DosDelete(from);
        }
      }
      else {
        ShowHelp(rc);
        return rc;
      }
    }
    else {
      ShowHelp(rc);
      return rc;
    }
  }
  else
    printf("\n Usage:  MOV source target [/o[verwrite]]\n"
           "\n Same basic format as OS/2's MOVE command except it can move between\n"
           " different drives and can allow overwriting.\n"
           "\nHector wuz here.\n");
  return 0;
}
