/* 
   Example.Cmd 

   This is an example of a Rexx program that you might write
   to use List Man (an OS/2 program) to create a list
   for use with PKZip (a DOS program) to use as input.

   This program will not work on your system if you don't
   have PKZip.  It is included as an example to show
   how to use List Man to create a list and pass the name
   of the list to another program.

   When you ask List Man to run a program, it creates a
   temporary file that contains the current list.  It
   then uses the OS/2 "Start" command to start the program
   you selected.  It passes the name of the temporary file
   containing the list to the program started.

   In this example, the program contains three statements.
   The first line:

      Parse Arg ListName

   is a Rexx statement to obtain the name of the temporary
   file containing the list.  The Rexx variable ListName will
   have the name of the file.

   The next line:

      "C:\PKZip\PKZip Test.Zip @" || ListName

   is passed by Rexx to OS/2 for processing.  The left part of
   the line between the quotes is the DOS command to run PKZip
   and some of its parameters.  Before passing the command to OS/2
   Rexx will replace the variable ListName with the name of the 
   list and concatenate it with the rest of the line creating a 
   valid PKZip command call.  The two vertical bars || mean 
   concatenate without an intervening blank, this is known as 
   abuttal.  If the name of the temporary list file was User.Lst, 
   the resultant command would look like this:

      C:\PKZip\PKZip Test.Zip @User.Lst

   The last line:

      Call VRDeleteFile ListName

   is a VXRexx Function used to delete the temporary file containing
   the list.

*/ 

   Parse Arg ListName

   "C:\PKZip\PKZip Test.Zip @" || ListName
   Call VRDeleteFile ListName 
