/*********************************************************************/
/*     REXX Function to determine partition file type                */
/*********************************************************************/
Parse Upper Arg partition .

/*********************************************************************/
/*           Initialize REXXUtil environment (if not present)        */
/*********************************************************************/
rxload = RxFuncQuery('SysLoadFuncs')
If rxload Then
   Do
      Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      Call sysloadfuncs
   End

/*********************************************************************/
/*   Attempt to create a subdirectory that won't work on a FAT vol   */
/*********************************************************************/
result = SysMkDir(partition'\'willonlyworkonHPFS)
Select

/*********************************************************************/
/*   If the function was successful, it must be HPFS.  Remove the    */
/*   directory we created.                                           */
/*********************************************************************/
   When result = 0 Then
      Do
         filetype = 'HPFS'
         Call SysRmDir(partition'\'willonlyworkonHPFS)
      End

/*********************************************************************/
/*   If the function indicates an illegal name, it must be FAT       */
/*********************************************************************/
   When result = 206 Then
      filetype = 'FAT'

/*********************************************************************/
/*    Otherwise it must be a CD-ROM.                                 */
/*********************************************************************/
   Otherwise
      filetype = 'CD-ROM'
End

/*********************************************************************/
/*      If we loaded REXXUtil, unload it, then exit, passing back    */
/*      the filetype to the calling routine.                         */
/*********************************************************************/
If rxload Then
   Call SysDropFuncs
Return filetype
