/* D:\Rexx\writeComments.Cmd
 * Friday December 27, 1996 9:04:10 pm
 * Ŀ
 *     Fred Peachman                             
 *     Brookfield, Ohio 44403                    
 *     av023@yfn2.ysu.edu -or- fpeachm@ibm.net   
 * 
 */
thisFile ='writeComments.Cmd'
_FileType = 'CMD'
debug = 0
call GlobalConstants
parse source . cmdType .
if cmdType = 'COMMAND' then do
  arg fileName
  if fileName = '?' | fileName = '' then do
    call showHelp
    return 0
    end
  end
else do
  fileName = arg(1)
  if fileName = '?' then do
    call showHelp
    return -1
    end
  if arg() <> 1 then do
    call showhelp
    say
    say '************************************************************'
    say thisfile': ERROR -'
    say '   'arg()' arguments were passed to' thisfile'.'
    say '   We were expecting one argument (a file name) only.' 
    say '************************************************************'
    say
    exit -1
    end
  end
fileName = strip(fileName)

WriteComments: 
    exists = SysFileTree(fileName, 'stem.') 
    if stem.0 = 0 then do
        say fileName 'does not exist!'
        return 0
        end
    drop stem. exists
    i = 0
    none = 0
    if queued() > 0 then do
      parse pull comments.codePage
      end
    do while queued()>0
      i = i + 1
      parse pull comments.i
      if cmdType='COMMAND' then say comments.i
      end
    comments.0 = i
    if comments.0 = 0 then do
      say 'No comments found for "'fileName'".'
      return 0
      end
    outstring = EAT_MVMT ||,
                revByte(d2x(comments.codePage, 4)) ||,
                revByte(d2x(comments.0, 4))

    outstring = x2c(outstring)

    do i = 1 to comments.0
        tmpstr = EAT_ASCII ||,
                    revByte(d2x(length(comments.i),4))
        outstring = outstring || x2c(tmpstr)
        tmpstr = comments.i
        outstring = outstring || tmpstr
        end
    ok = SysPutEA(fileName, EAttribute, outstring)
    return ok

GlobalConstants: 
/*  Note byte order of following EA's has been reversed from
    definitions in BSEDOS.H!
 */
EAT_ASCII    =   'FDFF'      /* length preceeded ASCII */
EAT_MVMT     =   'DFFF'      /* multi-valued, multi-typed field */
EAT_MVST     =   'DEFF'      /* multi-valued, single-typed field */
EA_type.1 = EAT_ASCII
EA_type.2 = EAT_MVMT
EA_Type.3 = EAT_MVST
EA_type.0 = 3

EA_Label.1 = 'EAT_ASCII'
EA_Label.2 = 'EAT_MVMT'
EA_Label.3 = 'EAT_MVST'
EA_Label.0 = EA_Type.0

EAttribute = '.COMMENTS'
return 0

/* Reverse the hi & low bytes in a 4-character hex string*/
revByte: procedure expose thisFile debug debugfile _FileType
    string = right(arg(1), 4, '0')
    return substr(string,3,2) || substr(string, 1, 2)

/* Reverse the hi & low chars  in a 2-byte binary string */
revChar:  procedure expose thisFile debug debugfile _FileType
    return substr(arg(1),2,1) || substr(arg(1), 1, 1)

/* Convert a binary string to decimal representation */
bintoDecimal: procedure expose thisFile debug debugfile _FileType
    string = arg(1)
    if length(string) > 4 then return 0
    if length(string) > 2 then longType = 1
    else longType = 0
    newvalue = 0
    do i = 0 to longType
        p = i*2 + 1
        if longType > 0 then do
            if  i = 0 then,
                newvalue = 65536 * c2d(revChar(substr(string, 1, 2)))
            else,
                newvalue = newvalue + c2d(revChar(substr(string, 3, 2)))
            end
        else,
            newvalue = newvalue + c2d(revChar(substr(string, 1, 2)))
        end
    return newvalue

/* decimalToHex(value(CommentsVar || '0'))   */
decimalToHex:
    if arg() = 0 then return ''
    decimal = arg(1)
    dec.1 = decimal % 65536  /* integer value is msbyte */
    dec.2 = decimal // 65536 /* remainder is lsbyte */
    output = ''
    do i = 1 to 2
        output = output || revByte(d2x(dec.i, 2))
        end
    return output   /* Use x2c(output) to convert to binary values */

/* Load REXX Utility Functions: */
addutils:
rc = RxFuncQuery('SysLoadFuncs') /* rc = 0 if already registered */
if rc <> 0 then do
    rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
    /*   RxFuncAdd: rc = 0 if successfully registered */
    if rc <> 0 then do
       say 'REXX Utility Functions have not been installed. This REXX file'
       say 'cannot run.'
       exit
       end  /* Do */
    rc = SysLoadFuncs()
    if cmdType = 'COMMAND' then say 'Rexx utility functions are now loaded.'
    return 0
    end
if cmdType = 'COMMAND' then say 'Rexx utility functions were already loaded.'
return 0

showHelp:
say
say thisFile
say
say '   pulls any file comments from REXX Queue and writes them to the'
say '   indicated file.  The first line of text read from the REXX'
say '   queue is the value for the current Code Page and should be,'
say '   by default, "0".'
say '   Succeeding lines of text are expected to contain the lines of'
say '   of text to be written to the file.'
say
say 'SYNTAX:'
say '   'thisfile '<fileName>'
say
say 'RETURNS:'  
say '   If called as a function, returns the return value from SysPutEA'
say '   REXX utility function.'
return 0

