/* D:\Rexx\pruneList.Cmd
 * Saturday December 28, 1996 11:41:02 am
 * Ŀ
 *     Fred Peachman                             
 *     Brookfield, Ohio 44403                    
 *     av023@yfn2.ysu.edu -or- fpeachm@ibm.net   
 * 
 */
thisFile ='pruneList.Cmd'
_FileType = 'CMD'
debug = 0
parse source . cmdType .
if cmdType = 'COMMAND' then do
  parse arg cmdLine
  if cmdLine = '?' | cmdLine = '' then do
    call showhelp
    exit -1
    end
  parse arg infile outfile
  end
else do
  infile = arg(1)
  outfile = arg(2)
  end
infile = strip(infile)
if infile = '' then do
  call showhelp
  say
  say '********************'
  say '   Enter the names of input and (optionally) output files'
  say
  exit -1
  end
outfile = strip(outfile)
if outfile = '' then outfile = infile
i = 0
do while lines(infile) > 0
  text = linein(infile)
  text = strip(text)
  if text = '' then iterate
  lead = left(text,1)
  if lead = ';' | lead='/' then iterate
  if stream(text, 'C', 'QUERY EXISTS') = '' then do
    i = i + 1
    file.i = text
    end
  end
file.0 = i
call lineout infile
if stream(outfile,'C','QUERY EXISTS') \= '' then do
  call sysFileDelete outfile
  end
do i = 1 to file.0
  call lineout outfile, file.i
  end
call lineout outfile    
return 0

addutils:
/* Load REXX Utility Functions: */
rc = RxFuncQuery('SysLoadFuncs') /* rc = 0 if already registered */
if rc <> 0 then do
    rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
    /*   RxFuncAdd: rc = 0 if successfully registered */
    if rc <> 0 then do
       say 'REXX Utility Functions have not been installed. This REXX file'
       say 'cannot run.'
       exit
       end  /* Do */
    rc = SysLoadFuncs()
    if cmdType = 'COMMAND' then say 'Rexx utility functions are now loaded.'
    return 0
    end
if cmdType = 'COMMAND' then say 'Rexx utility functions were already loaded.'
return 0

showHelp:
say
say thisfile
say 
say '   This REXX file will examine an ASCII text list of file names, and remove'
say '   the names of files that already exist in the current working directory. '
say '   It will create a new list containing names of files that DON''T exist - use'
say '   it as the list of files that you want to download during your next BBS'
say '   session.'
say
say 'SYNTAX:'
say '   'thisfile '<input file> [<output file>]'
say '   INPUT FILE is an ASCII text file that contains a list of file names,'
say '     one filename per line of text.'
say '   OUTPUT FILE is the name of a write file. If it exists, it will be'
say '     overwritten with new text containing a list of files from the'
say '     INPUT FILE list that do not exist in the current directory.'
say '   If OUTPUT FILE is not specified, INPUT FILE is overwritten with the'
say '     data for the OUTPUT FILE, i.e. INPUT FILE will contain the list of'
say '     files found NOT to exist currently.'
say '   Such a list can be regarded as the list of files that were not yet'
say '     downloaded from a BBS, i.e. this is the list of files to download'
say '     next time.'  
say
say 'RETURNS:'
say '   returns 0.'  
say
return 0
