/* D:\Rexx\os2shrfile.Cmd
 * Friday December 27, 1996 10:17:13 pm
 * Ŀ
 *     Fred Peachman                             
 *     Brookfield, Ohio 44403                    
 *     av023@yfn2.ysu.edu -or- fpeachm@ibm.net   
 * 
 */
thisFile ='os2shrfile.Cmd'
_FileType = 'CMD'
debug = 0
call addutils
name.1 = 'ALLFILED'
name.2 = 'ALLFILES'
name.3 = 'OS2NEW'
name.0 = 3

parse source . cmdtype .
if cmdtype = 'COMMAND' then do
  parse arg cmdLine
  if cmdLine = '?' then do
    call showHelp
    exit -1
    end
  fileName = cmdLine
  end
else do
  if arg() <> 1 then do
    say
    say '************************************************************'
    say thisfile': ERROR -'
    say '   'arg()' arguments were passed to' thisfile'.'
    say '   We were expecting one argument (a file name) only.' 
    say '   Typically the name of the file is "ALLFILED.TXT", with'
    say '   an appropriate PATH specification'.
    say '************************************************************'
    say
    exit -1
    end
  fileName = arg(1)
  end
fileName = strip(fileName)
filePath = ''
if fileName \= '' then do
  filePath = fSpec('drive', fileName) || fSpec('path',fileName)
  if filePath = '' then do    /* check for file in current dir */
    shrFile = stream(fileName, 'C', 'QUERY EXISTS')
    if shrFile = '' then do   /* check for directory of that name */
      call sysFileTree fileName, 'dir.', 'DO'
      if dir.0 > 0 then do
        filePath = dir.1'\'
        fileName = ''
        say 'Looking for BBS file list in directory '''filePath'''.'
        end
      drop dir.
      end
    drop shrFile
    end
  else do                     /* filePath is specified */
    if stream(fileName, 'C','QUERY EXISTS') = '' &,
      fSpec('path', fileName) = '' then do
      if fSpec('drive', fileName) \= '' then, 
        fileName = substr(fileName, length(fSpec('drive', fileName))+1)
      end
    else do
      ok = sysFileTree(fileName, 'dir.', 'OD')
      if dir.0 > 0 then do
        filePath = dir.1'\'
        fileName = ''
        end
      else do
        filePath = fSpec('drive', fileName) || fSpec('path', fileName)
        fileName = fSpec('name', fileName)
        end
      end
    end
  end
if fileName \= '' then do
  p = pos('.', fileName)
  if p \= 0 then do
    p = pos('.TXT', translate(fileName))
    if p = 0 then do
      name. = ''
      name.0 = 1
      name.1 = left(fileName, p-1)
      end
    else do
      retVal = stream(filePath || fileName, 'C','QUERY EXISTS')
      if retVal = '' then do
        say 'Cannot find file named '''filePath || fileName'''.'
        end
      return retVal
      end
    end
  else do
    name. = ''      
    name.0 = 1
    name.1 = fileName
    end
  end

newestZip = ''
do i = 1 to name.0
  zip.i = filePath || name.i || '.ZIP'
  if isZipFile(zip.i) then do
    if newestZip = '' then newestZip = zip.i
    else if \isOlderFile(zip.i, newestZip) then newestZip = zip.i
    end
  end
if newestZip \= '' then do
  result = unZipped(newestZip)
  if result \= '' then do
    if cmdType = 'COMMAND' then say result
    return result
    end
  end      

newestTxt = ''  
do i = 1 to name.0
  test = filePath || name.i
  if pos('.', name.i) = 0 then test = test'.TXT'
  if stream(test,'C','QUERY EXISTS') \= '' then do
    if newestTxt = '' then newestTxt = test
    else if isOlderFile(newestTxt, test) then newestTxt = test
    end
  end
if newestTxt \= '' then do
  if cmdType = 'COMMAND' then say newestTxt
  return newestTxt
  end
if cmdType = 'COMMAND' then say 'No suitable file was located.'   
return ''

/* find the zip file named, and unzip it if 
 * newer than text file of same name 
 */
unzipped: procedure expose debug
zipFile = arg(1)
p = pos('.', zipfile)
unZippedFile = left(zipfile,p) || "TXT"
if stream(unZippedFile,'C','QUERY EXISTS') \= '' then do
  if isOlderFile(ZipFile, UnZippedFile) then do
    if debug > 0 then say '"'ZipFile'" is older than',
                          '"'UnZippedFile'" so it was not unzipped.'
    return unZippedFile
    end
  end
tmp = ''
tmp = value('TMP',,'OS2ENVIRONMENT')
cmd = 'unzip -o' zipFile
fileName = fspec('name',zipFile)
p = pos('.',fileName)
fileName = left(fileName,p)
if tmp \= '' then do
  cmd = cmd '-d' tmp
  fileName = tmp'\'fileName'TXT'
  end
else fileName = fileName'TXT'
if debug > 0 then say cmd
'@'cmd
if rc \= 0 then return rc
retval = stream(fileName, 'C', 'QUERY EXISTS')
if retval \= '' then do
  if debug > 0 then say retVal 'unzipped from' zipFile
  /*  call sysFileDelete zipFile  */
  end
else if debug then say fileName 'was not created by unzipping' zipFile'.'
return retval

isZipFile: procedure expose debug
wholefile = arg(1)
file = fspec('name',wholefile)
p = pos('.', file)
ext = translate(strip(substr(file, p + 1)))
if ext = 'ZIP' & stream(wholeFile, 'C', 'QUERY EXISTS') \= '' then do
  if debug > 0 then say wholeFile 'is an existing ZIP file.'
  return 1
  end
if debug > 0 then say wholeFile 'is not an existing ZIP file.'
return 0

/* Load REXX Utility Functions: */
addutils:
rc = RxFuncQuery('SysLoadFuncs') /* rc = 0 if already registered */
if rc <> 0 then do
    rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
    /*   RxFuncAdd: rc = 0 if successfully registered */
    if rc <> 0 then do
       say 'REXX Utility Functions have not been installed. This REXX file'
       say 'cannot run.'
       exit
       end  /* Do */
    rc = SysLoadFuncs()
    return 0
    end
return 0

showHelp:
say
say thisfile
say
say 'SYNTAX:' thisFile '<fileName>'
say '   FILENAME is the name of an OS/2 ShareWare BBS list file, like'
say '   ALLFILED.TXT. It can also be the name of a directory wherein lies'
say '     one of the files ALLFILED.ZIP, ALLFILED.TXT, ALLFILES.ZIP,'
say '     ALLFILES.TXT, OS2NEW.ZIP, OS2NEW.TXT.'
say '   If the name of a directory is passed, then the following files are'
say '   sought in that directory:'
say '   1) ALLFILED.ZIP. It is unzipped, and ALLFILED.TXT is used as the'
say '     BBS list file - i.e. the full file spec of the unzipped ALLFILED.TXT'
say '     is returned.'
say '   2) ALLFILES.ZIP. Treated the same. The full fspec of the unzipped'
say '     ALLFILES.TXT file is returned.'
say '   3) OS2NEW.ZIP. Treated the same as #1 and #2.'
say '   3) Full fspec of unzipped *.TXT file is the name returned.'
say '   In all cases, the name returned is that of a file that does actually'
say '   exist, or '''' is returned.'
return ''

