/* D:\Rexx\getComments.Cmd
 * Friday December 27, 1996 8:59:19 pm
 * Ŀ
 *     Fred Peachman                             
 *     Brookfield, Ohio 44403                    
 *     av023@yfn2.ysu.edu -or- fpeachm@ibm.net   
 * 
 */
thisFile ='getComments.Cmd'
_FileType = 'CMD'
debug = 1
call GlobalConstants
haltMargin = 17
indent = 9
signal on halt

parse source . cmdType .
if cmdType = 'COMMAND' then do
  parse arg fileName
  if fileName = '?' | fileName = '' then do
    call showHelp
    return 0
    end
  if debug = 1 then debug = 2  /* debug output only when called from    */
  end                          /* the command line, not when called as  */
else do                        /* a function or subroutine.  debug = 2  */
  fileName = arg(1)
  if fileName = '?' then do
    call showHelp
    return -1
    end
  if arg() <> 1 then do
    call showhelp
    say
    say '************************************************************'
    say thisfile': ERROR -'
    say '   'arg()' arguments were passed to' thisfile'.'
    say '   We were expecting one argument (a file name) only.' 
    say '************************************************************'
    say
    exit -1
    end
  end
fileName = strip(fileName)

GetComments:
signal on halt name _halt_getComments
__tmp = ''
ok = SysGetEA(fileName, EAttribute, '__tmp')
if ok <> 0 then do
  say 'OS/2 Error [SYS'right(ok,4,'0')'] encountered while trying to read' fileName':'
  msg = sysGetMessage(ok)
  parse value msg with garbage ':' msg
  msg = strip(msg)
  if msg = '' then msg = strip(garbage)
  say strip(msg)
  return 0      
  end
if length(__tmp) = 0 then do
  if debug > 0 then do
    say
    say filename': ".COMMENTS" attribute not present.'
    end
  return 0
  end
count = 0
comments. = ''
if debug > 1 then do
  say
  say right('filename', indent)':' fileName
  end
call getType __tmp, 'comments.'
if comments.Label = 'EAT_ASCII' then do
/* We have a .COMMENTS attribute written as a long EAT_ASCII,
   with each line of the comment separated from the next by
   an '0A'x.
 */
  newEA = 3   /* offset of 2-byte length value, first byte in __tmp is 1 */
  newLength = binToDecimal(substr(__tmp, newEA, 2))
  if debug > 1 then do
    say
    say right('EAT_ASCII', indent)':' right(newLength,4,'0')
    end
  string = substr(__tmp, newEA+2, newLength)          /* value of EA */
  p = pos('0a'x, string)
  do while p > 0
    count = count+1
    comments.count = substr(string, 1, p-1)
    string = substr(string, p+1)
    p = pos('0a'x, string)
    end
  if string \= '' then do
    count = count+1
    comments.count = string
    end
  do while queued() > 0
    pull
    end
  if count > 0 then do 
    queue '0'
    do i = 1 to count
      if debug > 1 then say right('', indent+1) comments.i
      queue strip(comments.i)
      end
    end
  end
else if comments.Label = 'EAT_MVMT' then do
  comments.CodePage = binToDecimal(substr(__tmp, 3, 2))
  comments.0 = binToDecimal(substr(__tmp, 5, 2))
  if debug > 1 then do
    say right('EAT_MVMT',indent)':',
            comments.0 'lines, Code page =' comments.codePage
    say
    say left('flag', indent) 'bytes' 'text'
    say left('----', indent) '----- -------------------------------------------------'
    end
  newEA = 7
  do while count < comments.0
      count = count + 1
      call getType substr(__tmp, newEA, 2), 'comments.'count'.'
      newLength =  binToDecimal(substr(__tmp, newEA + 2, 2))
      comments.count = substr(__tmp, newEA+4,newLength)
      if debug > 1 then say right(comments.count.label, indent)':',
                            right(newLength,4,'0'),
                            comments.count 
      newEA = newEA + 4 + newLength
      end
  do while queued() > 0
    pull
    end
  if count > 0 then do 
    queue comments.codePage
    do i = 1 to count
      queue strip(comments.i)
      end
    end
  end

return count


getType:
/*  arg(1) contains the attribute value, the first two
    bytes of which identify the Extended Attribute Type,
    for example EAT_MVMT or EAT_ASCII.
    if the type is EAT_MVMT, then the label will be 
    determined to be 'EAT_MVMT' by this procedure.

    Example: you call getType __tmp, 'comments.'
    and __tmp contains the value from sysGetEa (REXXUTIL func);
    comments.type may be assigned the binary value of EAT_MVMT
    and
    comments.Label may be assigned the string 'EAT_MVMT',
    
    - if - the
    first two bytes of __tmp contain the binary value that is
    equivalent to EAT_MVMT.
 */
    string = C2X(left(arg(1),2))
    var = arg(2)

    do i = 1 to EA_type.0
        if string = EA_Type.i then do
            ok = value(var || 'type', EA_type.i)
            ok = value(var || 'Label', EA_Label.i)
            leave i
            end
        end
    return EA_type.i

/* Reverse the hi & low bytes in a 4-character hex string*/
revByte: procedure expose thisFile debug debugfile _FileType
    string = right(arg(1), 4, '0')
    return substr(string,3,2) || substr(string, 1, 2)

/* Reverse the hi & low chars  in a 2-byte binary string */
revChar:  procedure expose thisFile debug debugfile _FileType
    return substr(arg(1),2,1) || substr(arg(1), 1, 1)

/* Convert a binary string to decimal representation */
bintoDecimal: procedure expose thisFile debug debugfile _FileType
    string = arg(1)
    if length(string) > 4 then return 0
    if length(string) > 2 then longType = 1
    else longType = 0
    newvalue = 0
    do i = 0 to longType
        p = i*2 + 1
        if longType > 0 then do
            if  i = 0 then,
                newvalue = 65536 * c2d(revChar(substr(string, 1, 2)))
            else,
                newvalue = newvalue + c2d(revChar(substr(string, 3, 2)))
            end
        else,
            newvalue = newvalue + c2d(revChar(substr(string, 1, 2)))
        end
    return newvalue

/* decimalToHex(value(CommentsVar || '0'))   */
decimalToHex:
    if arg() = 0 then return ''
    decimal = arg(1)
    dec.1 = decimal % 65536  /* integer value is msbyte */
    dec.2 = decimal // 65536 /* remainder is lsbyte */
    output = ''
    do i = 1 to 2
        output = output || revByte(d2x(dec.i, 2))
        end
    return output   /* Use x2c(output) to convert to binary values */

GlobalConstants: 
/*  Note byte order of following EA's has been reversed from
    definitions in BSEDOS.H!
 */
EAT_ASCII    =   'FDFF'      /* length preceeded ASCII */
EAT_MVMT     =   'DFFF'      /* multi-valued, multi-typed field */
EAT_MVST     =   'DEFF'      /* multi-valued, single-typed field */
EA_type.1 = EAT_ASCII
EA_type.2 = EAT_MVMT
EA_Type.3 = EAT_MVST
EA_type.0 = 3

EA_Label.1 = 'EAT_ASCII'
EA_Label.2 = 'EAT_MVMT'
EA_Label.3 = 'EAT_MVST'
EA_Label.0 = EA_Type.0

EAttribute = '.COMMENTS'
return 0

halt:
call haltHeader SIGL, ''
exit 

_halt_getComments:
call haltHeader SIGL, 'getComments'
call haltReport '__tmp', __tmp
call haltReport 'fileName', fileName
call haltReport 'EAttribute', EAttribute
call haltReport 'newEA', newEA
call haltReport 'newLength', newLength
call haltReport 'count', count
call charout, 'press any key to continue'
ok = sysgetkey('NOECHO')
if dataType(count, 'N') = 1 then do j = 1 to count
  call haltReport 'comments.'j, comments.j
  end
exit

haltHeader:
stars = '**************************************************************'
title = '*'center("Program Halt -" thisfile":" arg(2), length(stars)-2)'*'
say stars
say title
say stars
call haltReport 'line 'arg(1), '"'strip(sourceLine(SIGL))'"'
return 0

haltReport:
say right(arg(1)':', haltMargin) arg2
return 0

/* Load REXX Utility Functions: */
addutils:
rc = RxFuncQuery('SysLoadFuncs') /* rc = 0 if already registered */
if rc <> 0 then do
    rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
    /*   RxFuncAdd: rc = 0 if successfully registered */
    if rc <> 0 then do
       say 'REXX Utility Functions have not been installed. This REXX file'
       say 'cannot run.'
       exit
       end  /* Do */
    rc = SysLoadFuncs()
    if cmdType = 'COMMAND' then say 'Rexx utility functions are now loaded.'
    return 0
    end
if cmdType = 'COMMAND' then say 'Rexx utility functions were already loaded.'
return 0

showHelp:
say
say thisFile
say
say '   writes any file comments to the REXX Queue that have been identified'
say '   for the indicated file. The first line of text written to the REXX'
say '   queue is the value for the current Code Page and is, by default, "0".'
say '   Succeeding lines of text contain the file''s COMMENTS attribute.'
say 
say '   Saturday March 29, 1997 11:56:59 pm: New!'
say '   I have updated this file to read .COMMENTS attributes that are anchored'
say '   by a solitary EAT_ASCII attribute type, as well as those that more'
say '   commonly are anchored by an EAT_MVMT and consist of multiple EAT_ASCII'
say '   data strings - F Peachman.'
say
say 'SYNTAX:'
say '   'thisfile '<fileName>'
say
say 'RETURNS:'  
say '   If called as a function, returns the number of lines of text found in'
say '   the file''s COMMENTS attribute. A return value of 0 means that the file'
say '   didn''t contain a COMMENTS attribute.'
return 0

