/* D:\Rexx\fromOS2ShareWare.Cmd
 * Saturday December 28, 1996 3:52:01 am
 * Ŀ
 *     Fred Peachman                             
 *     Brookfield, Ohio 44403                    
 *     fap@infonline.net  -or- fpeachm@ibm.net   
 * 
 *
 * Ŀ
 *     This file most typically is called from   
 *     addComments.Cmd. It can be used           
 *     "standAlone" if desired.                  
 *                                               
 *     getCommands.Cmd and writeComments.Cmd     
 *     are called from this file and must be     
 *     present however.                          
 * 
 */
thisFile ='fromOS2ShareWare'
_FileType = 'CMD'
debug = 0
ver = '1.00'
haltMargin = 17
call addutils
signal on HALT

parse source . cmdType .
if cmdType = 'COMMAND' then do
  parse arg cmdLine
  if cmdLine = '?' | cmdLine = '' then do
    call showhelp
    exit -1
    end
  parse arg downLoadDir bbsList
  end
else do
  downLoadDir = arg(1)
  bbsList = arg(2)  
  end
written = 0
downLoadDir = strip(downLoadDir)
bbsList = OS2ShrFile(bbsList)
if debug > 0 then do
  say thisfile': downloadDir =' downloadDir
  say thisfile': bbsList =' bbsList
  call sysgetkey 'NOECHO'
  end
if bbsList= '' then do
  say '     No BBS file list could be found. There is no purpose in'
  say '     running this program without one. Download a copy of'
  say '     ALLFILED.TXT from the OS/2 Shareware BBS and then run'
  say '     this program again.'
  say
  say '     Press any key to continue.'
  ok = sysGetKey('NOECHO')
  exit -1
  end
timeStamp = stream(bbsList, 'C', 'QUERY DATETIME') 
Title = 'Downloaded from the OS/2 Shareware BBS' timeStamp
i = 0
if debug > 0 then say 'Files to stamp with COMMENTS attributes:'
do while queued() > 0
  i = i + 1
  parse pull file.i
  if debug > 0 then say file.i
  end
file.0 = i
codePage = codePage()
if debug > 0 then say thisfile': codePage =' codePage
fileSection = 0
fileDescription. = ''
fileDescription.0 = 0
fileName = ''
labelLine = 0
k = 0
if translate(filespec('name',bbsList)) = 'OS2NEW.TXT' then,
  call os2newMethod        /* how we parse os2new.txt (no file areas)        */
else call allFiledMethod   /* how we parse allfiled.txt- both are subroutines*/
signal on halt
j = 0
undone. = ''
undone.0 = 0
do i = 1 to file.0
  if file.i \= '' then do
    j = j + 1
    undone.j = file.i
    end
  end
undone.0 = j
if undone.0 > 0 then do
  say 'Files unstamped:'
  do i = 1 to undone.0
    say undone.i
    end
  end
branded = 'branded with a COMMENTS attribute.'
if written = 1  then say '1 file was' branded
else Say written 'files were' branded
return 0    /* End of this program */

os2newMethod:
signal on halt name _halt_os2newMethod
Area = 'BBS file area not specified.'
do while lines(bbsList) > 0
  text = linein(bbsList)
  firstChar = left(text,1)
  select
    when firstChar = '' then do
      fileSection = 1
      fileName = ''
      k = 0
      fileDescription. = ''
      fileDescription.0 = 0
      end
    when firstChar = ' ' then do
      if fileSection = 1 then do
        if strip(text) = '' then do
          call checkFile                /* subroutine */
          fileSection = 0
          end            
        k = k + 1
        fileDescription.k = strip(text)
        end
      end
    otherwise do
      if fileSection = 1 then do
        if fileName \= '' then call checkFile
        parse value text with filename garbage
        fileName = strip(fileName)
        fileDescription. = ''
        fileDescription.1 = strip(left(text,29))
        fileDescription.2 = strip(substr(text,30))
        k = 2
        end
      end        
    end
  end
return 0

allFiledMethod:
signal on halt name _halt_allFiledMethod
do while lines(bbsList) > 0
  text = linein(bbsList)
  firstChar = left(text,1)
  select
    when firstChar = '' then do
      if fileSection = 1 then do
        if fileName \= '' then do
          call checkFile
          signal on halt name _halt_allFiledMethod
          end
        fileName = ''
        fileDescription. = ''
        fileDescription.0 = 0
        k = 0
        end
      fileSection = 0
      labelLine = 1
      end
    when firstChar = '' then do
      if labelLine = 4 then do
        labelLine = 0
        fileSection = 1
        fileName = ''
        k = 0
        fileDescription. = ''
        fileDescription.0 = 0
        end
      labelLine = labelLine + 1
      end
    when firstChar = ' ' then do
      if labelLine = 2 then do
        area = 'BBS Area: "'strip(text)'"'
        say area
        labelLine = labelLine + 1
        end
      else if fileSection = 1 then do
        k = k + 1
        fileDescription.k = strip(text)
        end
      end
    otherwise do
      if fileSection = 1 then do
        if fileName \= '' then  do
          call checkFile
          signal on halt name _halt_allFiledMethod
          end
        parse value text with filename garbage
        fileName = strip(fileName)
        fileDescription. = ''
        fileDescription.1 = strip(left(text,29))
        fileDescription.2 = strip(substr(text,30))
        k = 2
        end
      end        
    end
  end
return 0

/* See if filename is one of the files marked to be stamped with a 
 * COMMENTS file attribute. The list of such files is in the array 'file.'
 * The COMMENTS attribute is in array 'fileDescription.'
 */
checkFile:
signal on halt name _halt_checkFile
do z = 1 to file.0
  if filename = file.z then do
    call stampIt
    file.z = '' /* Make sure we never look at it again */
    return 0
    end
  end
return 0

/* ok filename is a file that needs to be stamped. Let's do it */  
stampIt:
signal on halt name _halt_stampIt
if downloadDir \= '' then filename = downLoadDir'\'filename
if debug > 0 then say '   stampit:' fileName
if getComments(fileName) \= 0 then do
  do while queued() > 0     /* Don't stamp the file if it is already */
    pull                    /* stamped.                              */
    end
  return 0
  end
queue codePage
queue Title
if debug >0 then say '   stampit:' Title
queue Area  
if debug >0 then say '   stampit:' Area
do x = 1 to k
  queue fileDescription.x
  if debug > 0 then say '   stampit:' fileDescription.x
  end
if writeComments(fileName) = 0 then do
  written = written + 1
  say '   comments added:' fileName
  end
return 0
  
addutils:
/* Load REXX Utility Functions: */
rc = RxFuncQuery('SysLoadFuncs') /* rc = 0 if already registered */
if rc <> 0 then do
    rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
    /*   RxFuncAdd: rc = 0 if successfully registered */
    if rc <> 0 then do
       say 'REXX Utility Functions have not been installed. This REXX file'
       say 'cannot run.'
       exit
       end  /* Do */
    rc = SysLoadFuncs()
    if cmdType = 'COMMAND' then say 'Rexx utility functions are now loaded.'
    return 0
    end
if cmdType = 'COMMAND' then say 'Rexx utility functions were already loaded.'
return 0

halt:
ok = haltHeader(SIGL, '')
exit

_halt_os2newMethod:
ok = haltHeader(SIGL, 'os2NewMethod')
exit

_halt_allFiledMethod:
ok = haltHeader(SIGL, 'allFiledMethod')
call haltReport 'bbsList', bbsList
call haltReport 'text', '"'strip(text)'"'
call haltReport 'firstChar', firstChar
call haltReport 'labelLine', '"'strip(labelLine)'"'
call haltReport 'fileSection', fileSection
call haltReport 'fileName', fileName
call haltReport 'k', k
if dataType(k,'N') = 1 then do i = 1 to k
  call haltReport 'fileDescription.'i, strip(fileDescription.i)
  end
exit

_halt_checkFile:
ok = haltHeader(SIGL, 'checkFile')
call haltReport 'fileName', fileName
call haltReport 'z', right(z, 4)
call haltReport 'file.0', right(file.0,4)
call haltReport 'file.'z, file.z
exit

_halt_stampIt:
ok = haltHeader(SIGL, 'stampIt')
exit

haltHeader:
stars = '**************************************************************'
title = '*'center("Program Halt -" thisfile":" arg(2), length(stars)-2)'*'
say stars
say title
say stars
call haltReport 'line 'arg(1), '"'strip(sourceLine(SIGL))'"'
return 0

haltReport:
say right(arg(1)':', haltMargin) arg2
return 0

showHelp:
say
say thisfile 'ver' ver
say
say '   Reads the BBS file list from the OS/2 Shareware BBS, and brands'
say '   COMMENTS attributes on those files whose names where queued into the'
say '   REXX Queue prior to calling this program.'
say '   Generally, this program is called by addComments.Cmd.'
say '   In turn, it calls OS2ShrFile.Cmd, getComments.Cmd & writeComments.Cmd.'
say
say 'SYNTAX:'
say '   'thisfile '<downloadDir> <bbsList>'
say
say '   downloadDir is the directory that contains the files downloaded from'
say '   the OS/2 Shareware BBS, and only needs to be specified if it is not'
say '   the current working directory.'
say '   bbsList is a filename passed to OS2ShrFile.Cmd, containing the name'
say '   of the BBS file list. It usually doesn''t need to specified, in which'
say '   case by default the program will look for ALLFILED.ZIP/TXT etc.'
say '   The BBS list file to use is determined by OS2ShrFile.Cmd.'
say
say 'RETURNS:'
say '   Returns 0.'
return 0
