/* D:\Rexx\fSpec.Cmd
 * Saturday March 29, 1997 7:53:57 pm
 * Ŀ
 *     Fred Peachman                             
 *     Brookfield, Ohio 44403                    
 *     fap@infonline.net  -or- fpeachm@ibm.net   
 * 
 */
thisFile ='fSpec'
parse source . cmdType .
if cmdType == 'COMMAND' then do
  parse arg cmdLine
  if cmdLine = '' then do
    call showHelp
    exit ''
    end
  parse value cmdLine with namePart FSpec
  end
else do
  namePart = arg(1)
  FSpec = arg(2)
  end
namePart = translate(strip(namePart))
FSpec = strip(FSpec)
p = pos(':', FSPec)
if p > 2  | p = 1 then do
  call showHelp
  say
  say '   '''translate(FSpec)'''is NOT a valid file specification.'
  exit ''
  end
if p = 0 then drive = ''
else drive = left(FSpec, 2)
rString = reverse(substr(FSPec,length(drive)+1))
p = pos('\', rString)
if p = 0 then do
  path = ''
  file = reverse(rString)
  end
else do
  file = reverse(left(rString,p-1))
  path = reverse(substr(rString, p))
  end
select
  when namePart = 'NAME' then retString = file
  when namePart = 'PATH' then retString = path
  when namePart = 'DRIVE' then retString = drive
  otherwise do
    call showHelp
    say
    say '   'namePart 'is not a valid argument.'
    say '   it should be one of ''NAME'',''PATH'',or ''DRIVE''.'
    exit ''
    end
  end
if cmdType = 'COMMAND' then say retString
return retString


showHelp:
say thisfile
say
say 'SYNTAX:'
say
say thisfile '<''DRIVE'' | ''PATH'' | ''NAME''> <fileName>'
say
say 'RETURNS:'
say '   -the path or filename part of a complete (or incomplete) file'
say '     specification.'
say
say '   Since the REXX function ''filespec'' doesn''t seem to work right '
say '   when returning path or name info on a string like ''d:fname'', '
say '   I use this REXX function as a workaround.'
say '   '
say '   If arg1 is ''NAME'', the filename part of the string is returned.'
say '   '
say '   If arg1 is ''PATH'', the path part of the string is returned.'
say
say '   If arg1 is ''DRIVE'', the drive portion will be returned.'
return 0
