/* D:\Rexx\addComments.Cmd
 * Saturday December 28, 1996 12:53:34 am
 * Ŀ
 *     Fred Peachman                             
 *     Brookfield, Ohio 44403                    
 *     av023@yfn2.ysu.edu -or- fpeachm@ibm.net   
 * 
 *
 * Ŀ
 *     External REXX files called:               
 *       fromOS2ShareWare.Cmd - which calls:     
 *          -getComments.Cmd                     
 *          -writeComments.Cmd                   
 *          -OS2ShrFile.Cmd                      
 *       pruneList.Cmd                           
 * 
 */ 
thisFile ='addComments'
ver = '1.02'
_FileType = 'CMD'
debug = 0
call addutils
parse source . cmdType .
if cmdType = 'COMMAND' then do
  parse arg cmdLine
  if cmdLine = '?' then do
    call showhelp
    exit -1
    end
  end
else do
  say 'Use' thisfile 'from the OS/2 command line only.'
  return 0
  end
call parseCmdLine(cmdLine)            /* parseCmdLine: subroutine */

/* Get the list of files that we (tried) to download.
                                             makeList: subroutine */
call makeList downLoadDir, listFile  /* returned in 'file.' variable */
if file.0 = 0 then do
  say 'No files exist that are in the list' listFile
  return 0
  end
call cleanQ                                 /* cleanQ: subroutine */
do i = 1 to file.0
  queue file.i
  end
call fromOS2ShareWare downLoadDir, bbsList
/* if outputList is '', then listFile will be overwritten */
if noOverWrite = 0 & listFile \= '' then,
  call pruneList listFile, outputList
return 0

makeList: procedure expose downloadDir file. debug sigl
/* get the list of filenames that we are interested in tagging with
 * the COMMENTS attributes. Return the list in the file. array variable.
 */
cwd = arg(1)      /* downLoadDir, the directory containing downloaded files */
list = arg(2)     /* listFile, typically the file named "download" */
file. = ''
file.0 = 0
mask = '*.*'
if cwd \= '' then mask = cwd'\'mask
if list = '' then do
  call sysFileTree mask, 'file.','FO'
  do i = 1 to file.0
    file.i = strip(translate(filespec('name', file.i)))
    end
  return file.0
  end
i = 0
do while lines(list) > 0
  text = linein(list)
  text = strip(text)
  newFile = text
  if cwd \= '' then newFile = cwd'\'newFile
  if stream(newFile, 'C', 'QUERY EXISTS') \= '' then do
    if getComments(newFile) = 0 then do
      i = i + 1
      file.i = text
      if debug > 0 then say 'file.'i '=' file.i
      end
    else call cleanQ
    end
  end
file.0 = i
call lineout list              /* this closes the file so it can be reused! */
return file.0    

parseCmdLine:
cmdLine = arg(1)
noOverWrite = 0
/* Get the download list file */
parse value cmdline with listfile '/'
dLDir = directory()
listfile = strip(listfile)
if listFile = '' then do
  noOverWrite = 1
  outputList = ''
  end
else do
  ok = sysFileTree(listFile, 'dir.', 'DO')
  if dir.0 > 0 then do
    dLDir = dir.1         /* if listFile is the name of a directory, then */
    drop dir.             /* we are really saying "look at all files in   */
    listFile = ''         /* this directory".                             */
    end
  if listFile \= '' then do
    if stream(listFile, 'C','QUERY EXISTS') = '' then do
      say 'List file ('''listFile''') doesn''t exist. Try again please...'
      exit -1
      end
    end
  end
if debug > 0 then do
  if listfile \= '' then say 'listFile ='''listfile'''.'
  else say 'No list file.'
  end
/* Get the download directory, if it isn't the cwd */
parse value translate(cmdline) with garbage '/D'downloadDir '/' garbage2
downloadDir = strip(downloadDir)
if downloadDir = '' then downLoadDir = dLDir
else do
  ok = sysFileTree(downLoadDir, 'stem.', 'OD')
  if stem.0 = 0 then do
    say DownloadDir 'doesn''t exist!'
    exit -1
    end
  end
drop dLDir
if debug > 0 then say 'DownloadDir = "'downloadDir'".'

/* Get the OS/2 Shareware BBS filelist, if different than
 * ALLFILED.ZIP, ALLFILED.TXT, ALLFILES.ZIP, or ALLFILES.TXT:
 */
parse value translate(cmdline) with garbage '/S' bbsList '/' garbage2
if debug > 0 then do
  if bbsList = '' then say 'bbsList = (null)'
  else say 'bbsList =' bbsList
  end

/* See if noOverWrite has been turned on */
if noOverWrite = 0 then do
  if pos('/N', translate(cmdLine)) > 0 then noOverwrite = 1
  end

/* See if there is an output name for an output file list */
outputList = ''
if noOverwrite = 0 then do
  parse value translate(cmdline) with garbage '/O'outputList '/' garbage2
  outputList = strip(outputList)
  if debug > 0 then do
    if outputList = '' then say 'outputList = '''''
    else say 'outputList =' outputList
    end
  end

if debug > 0 then say 'noOverWrite =' noOverWrite
return 0

cleanQ: procedure expose thisfile debug SIGL cmdType
i = 0
do while queued() > 0   /* clean the REXX queue */
  i = i + 1
  pull
  end
return i                /* returns number of lines that WERE in queue */

addutils: procedure expose cmdType debug SIGL thisfile
/* Load REXX Utility Functions: */
rc = RxFuncQuery('SysLoadFuncs') /* rc = 0 if already registered */
if rc <> 0 then do
    rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
    /*   RxFuncAdd: rc = 0 if successfully registered */
    if rc <> 0 then do
       say 'REXX Utility Functions have not been installed. This REXX file'
       say 'cannot run.'
       exit
       end  /* Do */
    rc = SysLoadFuncs()
    if cmdType = 'COMMAND' then say 'Rexx utility functions are now loaded.'
    return 0
    end
if cmdType = 'COMMAND' then say 'Rexx utility functions were already loaded.'
return 0

showHelp:
say
say 'Sunday March 30, 1997 12:01:31 am'
say thisfile 'ver' ver 
say '   Adds a COMMENTS file attribute to each file downloaded from the'
say '   OS/2 Shareware BBS. The comments come from the BBS'' file listing'
say '   found usually in the ASCII text file "ALLFILED.TXT" or "ALLFILES.TXT".'
say '   The program will check for a copy of ALLFILED.ZIP or ALLFILES.ZIP'
say '   that is newer than the corresponding TXT file, and unzip accordingly.'
say
say 'SYNTAX:'
say '   'thisfile '[download list][/d download dir][/s filename][/n | /o filename]'
say
say '   Download list is the list of files that were just downloaded from the'
say '   OS/2 ShareWare BBS. If no filename is provided for this, then all files'
say '   in the current working directory are examined, and the /n and /o'
say '   options are ignored. If a directory name is given, then all files in'
say '   the specified directory are examined.'
say '   Download dir is the directory that contains the downloaded files, if'
say '   different than the current working directory. N.B. This value will'
say '   overwrite any directory name specified with the download list parameter.'
say '   /s specifies a filename to use as the OS/2 ShareWare BBS file list.'
say '     "ALLFILED.ZIP/TXT", or "ALLFILES.ZIP/TXT" in the current working'
say '      directory are used by default, depending on dates. See'
say '     "os2ShrFile.Cmd" for details. Note: BBS''s "OS2NEW.TXT" is acceptable.'
say '   /n means "don''t construct a new download file list.'
say '   /o means write a new download file list to a file of name specified -'
say '     the default is to overwrite the file that is the download list.'
say 'RETURNS:'
say '   Returns the number of files that were "branded" with a COMMENTS attribute.'
say
return 0
