//Systray Icon Demo: Simple example in object Pascal
//
//Should be easy to port to another language
//Please send ports to cbratschi@datacomm.ch
Program AddIcon;

{$PMTYPE PM}
{$D FBCenter Systray Icon Demo (c) 1999 by Christoph Bratschi}

uses
 OS2Def,OS2Base,PMApp,FBCDef,OS2PMApi,Strings;

{$R AddIcon.RES}

const
 //Resource ID's
 id_MainWindow = 1000;
 id_Icon = 1000;
 //Button ID's
 id_Add    = 100;
 id_Modify = 101;
 id_Delete = 102;
 id_Entry  = 103;
 id_Entry2 = 104;
 id_Combo  = 105;
 //CallbackMessage
 cbm_NotifyIcon = wm_User+100;

type
 PIconWindow = ^TIconWindow;
 TIconWindow = object(TWindow)
  Icons : array[1..10]of HPointer;
  Button : array[1..3]of PButton;
  Static : array[1..3]of PStatic;
  Entry : array[1..2]of PEntryField;
  Combo : PComboBox;
  NotifyData : NotifyIconData;
  Constructor Init(aParent : PWindowsObject;aTitle : PChar);
  Destructor Done; virtual;
  Procedure SetupWindow; virtual;
  Procedure SaveWindow; virtual;
  Procedure SetTipIcon;
  Procedure IDAdd(var Msg : TMessage); virtual id_First + id_Add;
  Procedure IDModify(var Msg : TMessage); virtual id_First + id_Modify;
  Procedure IDDelete(var Msg : TMessage); virtual id_First + id_Delete;
  Procedure CBMNotifyIcon(var Msg : TMessage); virtual wm_First + cbm_NotifyIcon;
 end;

 PMyFrameWindow = ^TMyFrameWindow;
 TMyFrameWindow = object(TFrameWindow)
  Constructor Init(aParent : PWindowsObject;aTitle : PChar);
  Procedure InitClientWindow; virtual;
 end;

 PMyApplication = ^TMyApplication;
 TMyApplication = object(TApplication)
  Procedure InitMainWindow; virtual;
 end;

Function Shell_NotifyIcon(dwMessage : Longint;lpData : PNotifyIconData) : Bool; cdecl; external 'FBCHOOK' index id_ShellNotifyIcon;

{ TMyApplication }

Procedure TMyApplication.InitMainWindow;
 begin
  MainWindow := New(PMyFrameWindow,Init(nil,'Systray icon demo'));
end;

{ TMyFrameWindow }

Constructor TMyFrameWindow.Init(aParent : PWindowsObject;aTitle : PChar);
 begin
  inherited Init(aParent,aTitle);
  flCreate := flCreate and not fcf_ShellPosition or fcf_Icon;
  with Attr do
  begin
   ID := id_MainWindow;
   X := 100;
   Y := 100;
  end;
end;

Procedure TMyFrameWindow.InitClientWindow;
 begin
  ClientWnd := New(PIconWindow,Init(@Self,nil));
end;

{ TIconWindow }

Constructor TIconWindow.Init(aParent : PWindowsObject;aTitle : PChar);
 const
  BtnW = 100;
  BtnH = 35;
  StaticW = 80;
  StaticH = 25;
  EntryW = 100;
  EntryH = 25;
  ComboW = 100;
  ComboH = 100;
 begin
  inherited Init(aParent,aTitle);
  FillChar(NotifyData,SizeOf(NotifyData),0);
  with NotifyData do
  begin
   cbSize := SizeOf(NotifyData);
   uID := 1;
   uCallbackMessage := cbm_NotifyIcon;
   StrCopy(szTip,'Hello, I''m an icon');
  end;
  Icons[1] := WinLoadPointer(HWnd_Desktop,0,id_Icon);
  Icons[2] := WinQuerySysPointer(HWnd_Desktop,sptr_IconInformation,True);
  Icons[3] := WinQuerySysPointer(HWnd_Desktop,sptr_Arrow,True);
  Icons[4] := WinQuerySysPointer(HWnd_Desktop,sptr_Text,True);
  Icons[5] := WinQuerySysPointer(HWnd_Desktop,sptr_IconQuestion,True);
  Icons[6] := WinQuerySysPointer(HWnd_Desktop,sptr_IconError,True);
  Icons[7] := WinQuerySysPointer(HWnd_Desktop,sptr_IconWarning,True);
  Icons[8] := WinQuerySysPointer(HWnd_Desktop,sptr_Folder,True);
  Icons[9] := WinQuerySysPointer(HWnd_Desktop,sptr_Program,True);
  Icons[10] := WinQuerySysPointer(HWnd_Desktop,sptr_File,True);
  //Chaotic position calculation
  Button[1] := New(PButton,Init(@Self,id_Add,'Add',10,10+2*BtnH,BtnW,BtnH,True));
  Button[2] := New(PButton,Init(@Self,id_Modify,'Modify',10,10+BtnH,BtnW,BtnH,false));
  Button[3] := New(PButton,Init(@Self,id_Delete,'Delete',10,10,BtnW,BtnH,false));
   //Behind modify
  Static[1] := New(PStatic,Init(@Self,-1,'Text:',10+BtnW+10,10+BtnH+(BtnH-StaticH) div 2,StaticW,StaticH,-1));
  Entry[1] := New(PEntryField,Init(@Self,id_Entry,NotifyData.szTip,10+BtnW+10+StaticW+10,10+BtnH+(BtnH-EntryH) div 2,EntryW,EntryH,SizeOf(NotifyData.szTip)-1));
  Static[2] := New(PStatic,Init(@Self,-1,'Icon:',10+BtnW+10+StaticW+10+EntryW+10,10+BtnH+(BtnH-StaticH) div 2,StaticW,StaticH,-1));
  Combo := New(PComboBox,Init(@Self,id_Combo,10+BtnW+10+StaticW+19+EntryW+10+StaticW+10,10+BtnH+(BtnH-EntryH) div 2+EntryH-ComboH,ComboW,ComboH,cbs_DropDownList,-1));
   //behind delete
  Static[3] := New(PStatic,Init(@Self,-1,'Message:',10+BtnW+10,10+(BtnH-StaticH) div 2,StaticW,StaticH,-1));
  Entry[2] := New(PEntryField,Init(@Self,id_Entry2,nil,10+BtnW+10+StaticW+10,10+(BtnH-EntryH) div 2,EntryW,EntryH,-1));
  PMyFrameWindow(Parent)^.Attr.W := 10 + 10+BtnW+10+StaticW+19+EntryW+10+StaticW+10+ComboW+10;
  PMyFrameWindow(Parent)^.Attr.H := 30 + 10+3*BtnH+10;
end;

Destructor TIconWindow.Done;
 var
  x : LongInt;
 begin
  for x := 1 to 10 do if Icons[x] <> 0 then WinDestroyPointer(Icons[x]);
  inherited Done;
end;

Procedure TIconWindow.SetupWindow;
 begin
  inherited SetupWindow;
  NotifyData.HWnd := HWindow;
  Button[2]^.Disable;
  Button[3]^.Disable;
  with Combo^ do
  begin
   AddString('Default');
   AddString('Information');
   AddString('Arrow');
   AddString('Text');
   AddString('Question');
   AddString('Error');
   AddString('Warning');
   AddString('Folder');
   AddString('Program');
   AddString('File');
   SetSelIndex(0);
  end;
end;

Procedure TIconWindow.SaveWindow;
 begin
  Shell_NotifyIcon(nim_Delete,@NotifyData);
  inherited SaveWindow;
end;

Procedure TIconWindow.SetTipIcon;
 var
  Sel : LongInt;
 begin
  Sel := Combo^.GetSelIndex;
  if Sel = lit_None then Sel := 0;
  NotifyData.hIcon := Icons[Sel+1];
  Entry[1]^.GetText(NotifyData.szTip,SizeOf(NotifyData.szTip)-1);
end;

Procedure TIconWindow.IDAdd(var Msg : TMessage);
 begin
  NotifyData.uFlags := nif_Icon or nif_Tip or nif_Message;
  SetTipIcon;
  if Shell_NotifyIcon(nim_Add,@NotifyData) then
  begin
   Button[1]^.Disable;
   Button[2]^.Enable;
   Button[3]^.Enable;
  end else ShowString(HWindow,'Can''t add icon!');
end;

Procedure TIconWindow.IDModify(var Msg : TMessage);
 var
  OldTip : array[0..SizeOf(NotifyData.szTip)-1]of Char;
  OldIcon : HPointer;
 begin
  StrCopy(OldTip,NotifyData.szTip);
  OldIcon := NotifyData.hIcon;
  SetTipIcon;
  NotifyData.uFlags := 0;
  if StrComp(OldTip,NotifyData.szTip) <> 0 then NotifyData.uFlags := NotifyData.uFlags or nif_Tip;
  if OldIcon <> NotifyData.hIcon then NotifyData.uFlags := NotifyData.uFlags or nif_Icon;
  if NotifyData.uFlags = 0 then Exit;
  if not Shell_NotifyIcon(nim_Modify,@NotifyData) then ShowString(HWindow,'Can''t modify icon!');
end;

Procedure TIconWindow.IDDelete(var Msg : TMessage);
 begin
  if Shell_NotifyIcon(nim_Delete,@NotifyData) then
  begin
   Button[1]^.Enable;
   Button[2]^.Disable;
   Button[3]^.Disable;
  end else ShowString(HWindow,'Can''t delete icon!');
end;

Procedure TIconWindow.CBMNotifyIcon(var Msg : TMessage);
 var
  Char20 : array[0..20]of Char;
 begin
  Case Msg.Param1 of
   wm_Button1Down: Entry[2]^.SetText('wm_Button1Down');
   wm_Button1Up: Entry[2]^.SetText('wm_Button1Up');
   wm_Button1DblClk: Entry[2]^.SetText('wm_Button1DblClk');
   wm_ContextMenu: begin
                    Entry[2]^.SetText('wm_ContextMenu');
                    DosBeep(500,50);
                   end;
   else begin
         Str(Msg.Param1,Char20);
         Entry[2]^.SetText(Char20);
        end;
  end;
  Msg.Result := 1; //message handled
end;

var
 App : PMyApplication;

begin
 App := New(PMyApplication,Init('Tray Icon Demo'));
 App^.Run;
 Dispose(App,Done);
end.
