/*

  REXX Script to install E-Racer/2 and create a desktop folder

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

say "Installing..."

dir = directory() || '\'

say "Creating folder"
call SysCreateObject "WPFolder", "E-Racer/2", "<WP_DESKTOP>", "OBJECTID=<E2FOLDER>;ICONVIEW=ASPLACED,NORMAL;ALWAYSSORT=YES;ICONFONT=10.Helv;BACKGROUND=" || dir || "plaster.bmp,T;ICONFILE=" || dir || "idk.ICO", "replace"
call SysCreateObject "WPFolder", "Information", "<E2FOLDER>", "OBJECTID=<E2INFOFOLDER>;ICONVIEW=ASPLACED,NORMAL;ALWAYSSORT=YES;ICONFONT=8.Helv;BACKGROUND=" || dir || "plaster.bmp,T", "replace"
say "Creating program objects"

call SysCreateObject "WPProgram", "Why"  || d2c(10) || "Register?", "<E2INFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "REGISTER.TXT", "replace"
call SysCreateObject "WPProgram", "Short"  || d2c(10) || "Product"  || d2c(10) || "Description", "<E2INFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "FILE_ID.DIZ", "replace"
call SysCreateObject "WPProgram", "Readme" || d2c(10) || "Whats New?", "<E2INFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "README.TXT", "replace"
call SysCreateObject "WPProgram", "Order" || d2c(10) || "Form", "<E2INFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "ORDER.FRM", "replace"
call SysCreateObject "WPProgram", "Internationalization"  || d2c(10) || "Instructions", "<E2INFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "LANGUAGE.TXT", "replace"

call SysCreateObject "WPProgram", "IDK, Inc" || d2c(10) || "Online Users Manual", "<E2FOLDER>", "EXENAME=NETSCAPE.EXE;PARAMETERS=" || "http://www.idk-inc.com/dfindex.htm", "replace"

call SysCreateObject "WPProgram", "E-Racer/2", "<E2FOLDER>", "EXENAME=" || dir || "ERACER2.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
call SysCreateObject "WPProgram", "Purchase", "<E2FOLDER>", "EXENAME=" || dir || "PURCHASE.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
say "Installation completed - E-Racer/2"
