/**************************************************************** 
   DIRCOUNT.C - 4/16/94 Count number of bytes in a directory.

   Written by: Steve Warshaw
   Compiler:   WATCOM C/C++32
   Version:    1.0

   Purpose:    To count the number of bytes in the directory,
             including all subdirectories and their contents.

   Files on a directory are read. If they are not directories, the
  size of the files are accumulated. If a directory is encountered,
  its contents are read and the size of the files contained are accumulated.
   There is one routine to read directories, which is called recursively.
*****************************************************************/

#include <direct.h>               /*  Contains directory functions.   */
#include <math.h>                        /* Contains "ceil" function. */
#include <stdio.h>
#include <stdlib.h>  /*  Contains gcvt character conversion function. */
#include <string.h>         /*  Contains strcat and strcpy functions. */

/*********** Function Prototypes  ***********/
void ReadFilesOnDirectory (char *dirtosearch);
void InsertCommas (int directorysize);

int    dirsize = 0;         /* variable containing the accumulated sizes. */ 
char   fulldir[200];          /*  name of full current working directory. */
char   newstr[15];             /* new string containing reformatted size. */

void main (int argc, char *argv[])
 {

  if (argc != 2) {    /*  check if name of directory to be searched is supplied by user. */
    printf("\n\n This command should be entered in the following format:\n\n");
    printf("   DIRCOUNT [path:] Directory_Name[\\Subdirectory_name]...\n\n");
    return;  }

  strcpy(fulldir,strupr(argv[1]));   /*  convert to upper case. Just to look pretty when printing messages. */
  printf("\n\n Now Counting Size of Directory %s\n", argv[1] );
  ReadFilesOnDirectory (fulldir);        /*  Call routine to read the directory. */
  InsertCommas(dirsize);                 /* Size of directory should be formatted to make it easier to read. */
  printf("\n\nSize of directory %s is %s\n", argv[1], newstr);

  return;
 }
  
void ReadFilesOnDirectory (char *dirtosearch)
 {
  /**************************************************************************  
  This routine will open a directory and read through all the files contained
     in the directory. If a subdirectory is encountered, this routine will be
     called recursively, until all files in all subdirectories have been read.
   Size accumulation is also done in this routine.
   *************************************************************************/
  char          *dirname;       /* holds directory name; is passed to function   */ 
  char          prevdir[200];   /*  place holder when calling directories.       */
  DIR           *dirp;          /* declare a pointer to the directory structure. */
  struct dirent *direntp;       /* create structure to contain directory names.  */

  if ((dirp = opendir(dirtosearch)) == NULL)  
   {
    printf("\n\n %s Could Not Be Found. Please Review.\n", dirtosearch);
    exit(0);  
   }

  while (1) {
    direntp = readdir( dirp );
    if (direntp == NULL) break;  
    dirname = direntp->d_name;
    if (dirname[0] == '.') continue;  /*  bypass '.' and '..' directories.  */
    if (direntp->d_attr & _A_SUBDIR)  /* if this is a directory, call this routine with directory name. */
     {
      strcpy(prevdir, dirtosearch);   /*  save current file name; will need this when returning from function */
      strcat(fulldir, "\\");          /* Need backslash separator.   */
      strcat(fulldir, dirname);       /* append directory name to current directory. */
      ReadFilesOnDirectory (fulldir); /* call this function again, this time using subdirectory
                                         encountered within the directory you were just reading. */ 
      strcpy(fulldir, prevdir);       /* reset to directory being read before recursive function call */
     }                                
      else                            /*  if file is not a subdirectory, add its size to the running total. */  
      {  
       dirsize += direntp->d_size;
      }
  }
  closedir (dirp);
 
  return;                     }

void InsertCommas (int directorysize)
 {     
  /**************************************************************************************
     This process is in three steps. 1) Convert the numeric size to a character  
       string; 2) Make the size of the string a multiple of 3 (since every 3   
       characters have a comma following (except at end); 3) insert commas.    
   ***************************************************************************************/

  int   dirlen;                   /*  length of string that is being converted. */ 
  int   i, every3;        /*  "every3" keeps track to see if at the third char. */
  char  charsize[15];           /*  will contain formatted size (with commas).  */
  char  holdchar[] = " ";  /* need to hold each character in string for strcat. */
  float templen;           /* needed to hold a floating pt value from a divide. */

  gcvt(directorysize, 15, charsize);  /* convert numerical representation of size to a char
                                         because inserting commas is a character operation.  */
  templen = (( (float) (strlen(charsize) ) / 3 ));  /* cast as float so "ceil" has the modulus to work with. */
  dirlen = (ceil(templen)) * 3;       /* ceil will get next highest number; then number will be made a multiple of 3. */ 
  every3 = dirlen - strlen(charsize); /* if full length of dirlen < a multiple of 3, skip the difference before going into loop. */
  for (i = 0;  i < strlen(charsize);  i++)
   {
      every3++;        /* when every3 reaches 3, a comma is concatenated and every3 is initialized. */
      strset(holdchar, (charsize[i]));
      strcat(newstr, holdchar); 
      if ( (every3 == 3)  &&  (i != (strlen(charsize) - 1))  ) /* put comma every 3 positions, unless it is the last position. */
       {
        strcat(newstr, ",");
        every3 = 0;
       }
   }
                  
  return; 
 }

