/*********************************************************************/
/*                                                                   */
/* Convert Version 1.00                                              */
/*                                                                   */
/* Converts uppercase file names to lower case and visa versa        */
/* Written by :  John Ballment                                       */
/* Written on :  06 June, 1997                                       */
/*                                                                   */
/* I wrote this small application to convert files from uppercase    */
/* to lowercase after doing a project with a couple of friends who   */
/* where using Windows 95.                                           */
/*                                                                   */
/* Everytime they saved files onto thier disks, the filenames were   */
/* in uppercase, which made it hard to port onto my OS/2 system and  */
/* the UNIX system which the project was being designed for.         */
/*                                                                   */
/* The program command-line is as follows:                           */
/*                                                                   */
/*      convert -u/l <filename>                                      */
/*                                                                   */
/* -u = convert to uppercase (I wrote it to convert both ways)       */
/* -l = convert to lowercase                                         */
/* <filename> = a filename including wildcards like * and ?          */
/*                                                                   */
/* If you find the program useful please send a post card to:        */
/*                                                                   */
/*     John Ballment                                                 */
/*     98 Kilsay Cres                                                */
/*     Meadowbrook  Q  4131                                          */
/*     Australia, plant Earth, the Milky-Way solar system            */
/*                                                                   */
/* Please send any bug reports to:                                   */
/*                                                                   */
/*     n1237462@droid.fit.qut.edu.au                                 */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>
#include <string.h>

#define OK 0
#define FAILED 1
#define FilenameLength 256
#define FILENAME 2
#define CONVERT 1
#define PROGRAM 0

int main (int argc, char *argv[]) {

   char name[FilenameLength], *newname;
   char temp[FilenameLength], *tempname;
   int count;

   newname = name;
   tempname = temp;

   if (argc < 3) {
      printf("\n example usage is: %s <convert> <filename>\n", argv[PROGRAM]);
      return FAILED;
      }
   if ((strcmp(strlwr(argv[CONVERT]), "-u")) == OK)  {
      for (count = FILENAME; count <= argc - 1; count++) {
         tempname = tmpnam(NULL);
         if ((rename(argv[count], tempname)) != OK) {
            printf("\nCould not rename file %s to temporary filename %s\n", argv[count], tempname);
            return FAILED;
            }
         strcpy(newname, argv[count]);
         strupr(newname);
         if ((rename(tempname, newname)) != OK) {
            printf("\nCould not rename file %s to %s\n", argv[count], newname);
            return FAILED;
            }
         }
      }
   else if (strcmp(strlwr(argv[CONVERT]), "-l") == OK) {
      for (count = FILENAME; count <= argc - 1; count++) {
         tempname = tmpnam(NULL);
         if ((rename(argv[count], tempname)) != OK) {
            printf("\nCould not rename file %s to temporary filename %s\n", argv[count], tempname);
            return FAILED;
            }
         strcpy(newname, argv[count]);
         strlwr(newname);
         if ((rename(tempname, newname)) != OK) {
            printf("\nCould not rename file %s to %s\n", argv[count], newname);
            return FAILED;
            }
         }
      }
   else {
      printf("\nConvert must be either -l<ower> or -u<pper>\n");
      return FAILED;
      }
   return OK;
   }
