/***************************************************************************
 * rxGetOpt.Cmd 2.01 (14-Feb-1996 21:07:35)
 * Copyright 1995 Christopher J. Madsen
 *
 * Parse options specified on command line.
 ***************************************************************************/
PARSE SOURCE . called_as .

IF called_as = "COMMAND" THEN DO
  SAY 'RxGetOpt version 2.01 (14-Feb-1996)'
  SAY 'Copyright 1995 Christopher J. Madsen'
  SAY
  SAY 'RxGetOpt is free software; you can redistribute it and/or modify it'
  SAY 'under the terms of the GNU General Public License as published by'
  SAY 'the Free Software Foundation; either version 2 of the License, or'
  SAY '(at your option) any later version.'
  SAY
  SAY 'RxGetOpt is distributed in the hope that it will be useful, but'
  SAY 'WITHOUT ANY WARRANTY; without even the implied warranty of'
  SAY 'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU'
  SAY 'General Public License for more details.'
  SAY
  SAY 'You should have received a copy of the GNU General Public License'
  SAY 'along with this program; if not, write to the Free Software'
  SAY 'Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.'
  SAY
  SAY 'My Addresses:'
  SAY 'Internet: ac608@yfn.ysu.edu     USnail: Christopher J. Madsen'
  SAY '                                        3222 Darby Ln.'
  SAY '                                        Denton, TX  76207-1305'
  SAY
  SAY 'Error:  RxGetOpt must be called as a function from a REXX program.'
  EXIT
END /* if not called as function */

DROP called_as

/***************************************************************************
 * Global variables:
 ***************************************************************************/
optionChars = '-/'              /* Characters which signify options */
optionChar  = '-'               /* Preferred character to signify option */
quoteChars  = '"'''             /* Characters which quote arguments */

globalVars = 'argOptions commandLine forceUpper longOptions optionChar',
  'optionChars quoteChars'

/***************************************************************************
 * RxGetOpt options (case is significant):
 *
 * A  Allow options to appear anywhere in command line
 *    (default is options must come before any other arguments)
 * M  Preserve case of options (default is to force upper case)
 * U  Use only '-' for options (default is to let '-' or '/' start options)
 ***************************************************************************/
PARSE ARG commandLine, parseOptions, longOptions, argOptions

trailingOptions = (POS('A',parseOptions) > 0)

forceUpper = (POS('M',parseOptions) = 0)

IF POS('U',parseOptions) > 0 THEN
  optionChars = '-'

DROP parseOptions

/***************************************************************************
 * Main Loop:
 ***************************************************************************/
commandLine = STRIP(commandLine,'L') /* Strip leading blanks */
parsedOptions = ''
DO WHILE POS(LEFT(commandLine,1),optionChars) > 0
  PARSE VAR commandLine argument commandLine
  CALL handleOption
  commandLine = STRIP(commandLine,'L') /* Strip leading blanks */
END

IF trailingOptions THEN DO
  otherArguments = ''
  DO WHILE commandLine <> ''
    argument = nextArg()
    IF POS(LEFT(argument,1),optionChars) > 0 THEN
      CALL handleOption
    ELSE
      otherArguments = otherArguments argument
  END /* while commandLine is not empty */
  commandLine = STRIP(otherArguments,'L')
END /* if trailingOptions */

RETURN 0 STRIP(parsedOptions optionChar||optionChar commandLine)

/***************************************************************************
 * Possible return codes:
 *   0 No errors
 *   1 Missing argument (option that requires an argument did not find one)
 ***************************************************************************/

/***************************************************************************
 * Move an option onto the new command line:
 *
 * Input:
 *   argument must hold the option to be processed
 *   parsedOptions must hold any previously processed options
 * Output:
 *   parsedOptions holds the processed options
 ***************************************************************************/
handleOption: PROCEDURE EXPOSE argument parsedOptions (globalVars)
  IF LEFT(argument,1) = SUBSTR(argument,2,1) THEN DO
    /* Handle long option */
    optionName = SUBSTR(argument,3)
    IF optionName = '' THEN DO
      optionChars = ''          /* '--' marks end of options */
      RETURN
    END /* if option is '--' */
    IF POS('=',argument) > 0 THEN DO
      PARSE VAR optionName optionName '=' optArgument
      IF optArgument = '' THEN optArgument = '""'
      ELSE DO
        commandLine = optArgument' 'commandLine
        optArgument = nextArg()
      END /* else */
    END /* if argument contains '=' */
    ELSE optArgument = ''
    IF forceUpper THEN optionName = TRANSLATE(optionName)
    i = POS(':'optionName':',longOptions)
    IF i > 1 THEN DO
      optionName = SUBSTR(longOptions,i-1,1)
      parsedOptions = parsedOptions optionChar||optionName
    END /* if long option translates to a short option */
    ELSE DO
      parsedOptions = parsedOptions optionChar||optionChar||optionName
    END /* else long option cannot be translated to a short option */
    IF POS(':'optionName':',argOptions) > 0 THEN DO
      IF optArgument = '' THEN
        optArgument = nextArg()
      IF optArgument = '' THEN
        EXIT 1 'Option `'argument"' requires argument"
      parsedOptions = parsedOptions optArgument
    END /* if option takes an argument */
    ELSE IF optArgument <> '' THEN
      EXIT 1 'Option `'argument"' does not take an argument"
  END /* if it's a long option */
  ELSE /* Handle short option */
    DO i = 2 TO LENGTH(argument)
      optionName = SUBSTR(argument,i,1)
      IF forceUpper THEN optionName = TRANSLATE(optionName)
      parsedOptions = parsedOptions optionChar||optionName
      IF POS(':'optionName':',argOptions) > 0 THEN DO
        IF i = LENGTH(argument) THEN
          optArgument = nextArg()
        ELSE
          optArgument = SUBSTR(argument,i+1)
        IF optArgument = '' THEN
          EXIT 1 'Option `'optionChar||optionName"' requires argument"
        parsedOptions = parsedOptions optArgument
        LEAVE /* Option that takes argument must come last */
      END /* if option takes an argument */
    END /* for each option char */
RETURN /* handleOption */

/***************************************************************************
 * Read an argument from the command line:
 *
 * Input:
 *   The command line must be stored in commandLine
 * Output:
 *   Returns the argument.  If it was enclosed in quotation marks, the
 *     quotes are retained.
 *   The retrieved argument is removed from commandLine.
 ***************************************************************************/
nextArg: PROCEDURE EXPOSE (globalVars)
  IF POS(LEFT(commandLine,1),quoteChars) > 0 THEN DO
    /* Get a quoted argument */
    quoteChar = LEFT(commandLine,1)
    PARSE VAR commandLine (quoteChar) argument (quoteChar) commandLine
    argument = quoteChar||argument||quoteChar
  END /* if this is a quoted argument */
  ELSE
    PARSE VAR commandLine argument commandLine
  RETURN argument
/* end nextArg */
