/* */

'@echo off'
'cls'

SIGNAL ON FAILURE
SIGNAL ON ERROR

CALL RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"
CALL SysLoadFuncs

CurDir=DIRECTORY()
ViewPath=SysSearchPath('PATH','VIEW.EXE')
if ViewPath='' then
  do
     say ''
     say 'Error!  VIEW.EXE not found!  INF Files will use C:\OS2\VIEW.EXE...'
     ViewPath='C:\OS2\VIEW.EXE'
  end
EPath=SysSearchPath('PATH','E.EXE')
if EPath='' then
  do
     say ''
     say 'Error!  E.EXE not found!  Text Files will use C:\OS2\E.EXE...'
     ViewPath='C:\OS2\E.EXE'
  end

say ''
say '*********************************************'
say '*     Welcome to the Quoteman/2 install     *'
say '*********************************************'
say ''
say 'The install will create objects on your desktop using the'
say 'current directory.  If this is not what you want, move the'
say 'program file(s) to their destination directory and re-run'
say 'the install program.'
say ''
call charout,'Press any key to start Install or Q to quit...'
parse upper value SysGetKey('NOECHO') with key
if key='Q' then
  EXIT

say ''

classname='WPFolder'
title='QuoteMan/2'
location='<WP_DESKTOP>'
setup='CCVIEW=NO;ICONFILE='||CurDir||'\QUOTEFLD.ICO;OBJECTID=<QUOTE_FOLDER>;'
option='R'
call BldObj

classname='WPProgram'
title='QuoteMan/2'
location='<QUOTE_FOLDER>'
setup='EXENAME='||CurDir||'\QUOTEMAN.EXE;STARTUPDIR='||CurDir||';OBJECTID=<QUOTE_PROG>;'
option='R'
call BldObj

classname='WPProgram'
title='Quoteman/2'||'0A'x||'Configuration Tool'
location='<QUOTE_FOLDER>'
setup='EXENAME='||CurDir||'\QUOTECFG.EXE;STARTUPDIR='||CurDir||';OBJECTID=<QUOTE_CONFIG>;'
option='R'
call BldObj

classname='WPProgram'
title='Quoteman/2'||'0A'x||'Information'
location='<QUOTE_FOLDER>'
setup='EXENAME='||ViewPath||';ICONFILE='||CurDir||'\QUOTEINF.ICO;PARAMETERS=QUOTEMAN.INF;STARTUPDIR='||CurDir||';OBJECTID=<QUOTE_INFO>;'
option='R'
call BldObj

classname='WPProgram'
title='QuoteMan'||'0A'x||'Order Form'
location='<QUOTE_FOLDER>'
setup='EXENAME='||EPath||';PARAMETERS='||CurDir||'\ORDER.FRM;STARTUPDIR='||CurDir||';OBJECTID=<QUOTE_ORDERFRM>;'
option='R'
call BldObj

say ''
call charout,'Would you like to place QuoteMan/2 in your start-up folder also (Y/N)? '
parse upper value SysGetKey('NOECHO') with key
if key ='Y' then
  do
    classname='WPProgram'
    title='QuoteMan/2'
    location='<WP_START>'
    setup='EXENAME='||CurDir||'\QUOTEMAN.EXE;STARTUPDIR='||CurDir||';OBJECTID=<QUOTE_START>;'
    option='R'
    say ''
    call BldObj
  end

StartupDrive=SysSearchPath('PATH','CONFIG.SYS')
StartupDrive=FILESPEC("drive",StartupDrive)
if STREAM('VPREXX.DLL','C','QUERY EXISTS') \= '' then
do
  say ''
  say 'VPREXX.DLL must be present in a directory contained in the LIBPATH'
  say 'variable in config.sys.  I recommend '||StartupDrive||'\OS2\DLL'
  call charout,'Would you like to copy VPREXX.DLL to '||StartupDrive||'\OS2\DLL (Y/N)?'
  parse upper value SysGetKey('NOECHO') with key
  if key ='Y' then
    do
       say ''
       'COPY VPREXX.DLL '||StartupDrive||'\OS2\DLL > nul'
    end
  else
    do
       say ''
       say 'Okay, then remember to place VPREXX.DLL in a directory contained in your LIBPATH!'
    end
end

say ''
call charout,'Press any key to exit...'
key=SysGetKey('NOECHO')
EXIT

/* Build Object Procedure */
BldObj:
call charout ,'Building: 'title substr(classname,3,)

result = SysCreateObject(classname, title, location, setup, option)

If result=1 Then call charout ,' ...Created!'
else
  call charout ,' ...Not created! Return code='result
say ' '
Return

/*****************************************************************************/
 * Standard REXX program error handler
 *****************************************************************************/
ERROR:
    say ''
    SAY 'An error has occurred...'
    EXIT

FAILURE:
    say ''
    SAY 'An error has occurred...'
    EXIT

