/**********************************************
*   Linux X11 CPP file for MMMX Editor        *
*   Contains X11    specific functions        *
*   (Tested on i386 RedHat Linux 3.0+ X11R6)  *
***********************************************/
#include "mmm_x11.h"

//&<<&void SetSignalHandler(){
//&<<&void Terminate(int a) {
void Terminate(int a) {
   int r;
   puts("Now In Terminate(...)\n");
   _exit(-1);
}
//&>>&2 0 2 0
void SetSignalHandler(){
    signal(SIGSEGV ,Terminate );
    signal(SIGKILL ,Terminate );
    signal(SIGABRT ,Terminate );
    signal(SIGTERM ,Terminate );
    signal(SIGQUIT ,Terminate );
    signal(SIGALRM ,Terminate );
    signal(SIGHUP  ,Terminate );
    signal(SIGINT  ,Terminate );
    }
//&>>&9 0 9 0
//&<<&void XMemTest(int i,char *msg){
void XMemTest(int i,char *msg){
    if(i)return;
    puts(msg);
    exit(-1);
    }
//&>>&2 0 2 0
//&<<&static void SetWindowManagerHints(...)
static void SetWindowManagerHints(
                    Display     *prDisplay,
                    char        *psPrgClass,
                    char        *argv[],
                    int         argc,
                    Window      nWnd,
                    int         x,
                    int         y,
                    int         nWidth,
                    int         nHeight,
                    int         nMinWidth,
                    int         nMinHeight,
                    char        *psTitle,
                    char        *psIconTitle,
                    Pixmap      nIconPixmap
                    )
    {
    XSizeHints      rSizeHints;
    XWMHints        rWMHints;
    XClassHint      rClassHint;
    XTextProperty   prWindowName, prIconName;

    XMemTest( XStringListToTextProperty(&psTitle, 1, &prWindowName ) &&
              XStringListToTextProperty(&psIconTitle, 1, &prIconName ) ,
           "UE: No Memory!" );

    rSizeHints.flags=USPosition | USSize | PMinSize;
    rSizeHints.min_width  = nMinWidth;
    rSizeHints.min_height = nMinHeight;
    rSizeHints.x=x;
    rSizeHints.y=y;

    rWMHints.flags = StateHint | IconPixmapHint | InputHint;
    rWMHints.initial_state = NormalState;
    rWMHints.input = True;
    rWMHints.icon_pixmap = nIconPixmap;

    rClassHint.res_name = argv[0];
    rClassHint.res_class = psPrgClass;

    XSetWMProperties (prDisplay, nWnd, &prWindowName, &prIconName,
        argv, argc, &rSizeHints, &rWMHints, &rClassHint );

    }

//&>>&1A 0 11 24

//&<<&mmm_Screen::mmm_Screen(){}
mmm_Screen::mmm_Screen(){
//&<<&    #ifdef _ENABLE_LOGGING_
    #ifdef _ENABLE_LOGGING_
        DoLog("mmm_Screen::mmm_Screen(){}\n");
    #endif
//&>>&1 0 1 0
    SetSignalHandler();
//&<<&    prDisplay=XOpenDisplay(NULL);
    prDisplay=XOpenDisplay(NULL);
    XMemTest(prDisplay!=NULL,"cannot open display");
//&>>&1 0 1 5
    nScreenNum=DefaultScreen(prDisplay);
    nWnd=XCreateSimpleWindow( prDisplay,
                RootWindow(prDisplay,nScreenNum),
                WND_X, WND_Y, WND_WDT, WND_HGH, WND_BORDER_WDT,
                WhitePixel(prDisplay,nScreenNum),
                BlackPixel(prDisplay,nScreenNum) );
}
//&>>&4 0 4 0
//&<<&void mmm_Screen::InitColorMap(){
//&<<&long mmm_Init_ClrVal[0x10]={
long mmm_Init_ClrVal[0x10]={
     0x000000L,       /* _BLACK        , */
     0x2a0000L,       /* _BLUE         , */
     0x002a00L,       /* _GREEN        , */
     0x2a2a00L,       /* _CYAN         , */
     0x00002aL,       /* _RED          , */
     0x2a002aL,       /* _MAGENTA      , */
     0x00152aL,       /* _BROWN        , */
     0x2a2a2aL,       /* _WHITE        , */
     0x151515L,       /* _GRAY         , */
     0x3F1515L,       /* _LIGHTBLUE    , */
     0x153f15L,       /* _LIGHTGREEN   , */
     0x3f3f15L,       /* _LIGHTCYAN    , */
     0x15153fL,       /* _LIGHTRED     , */
     0x3f153fL,       /* _LIGHTMAGENTA , */
     0x153f3fL,       /* _YELLOW       , */
     0x3f3f3fL        /* _BRIGHTWHITE    */
    };
//&>>&1 0 1 7

void mmm_Screen::InitColorMap(){
    XColor rColor;
    int i;

    for(i=0;i<0x10;i++){
        rColor.red   = mmm_Init_ClrVal[i]       & 0xff;
        rColor.green = (mmm_Init_ClrVal[i]>>8)  & 0xff;
        rColor.blue  = (mmm_Init_ClrVal[i]>>16) & 0xff;
        rColor.flags=DoRed | DoGreen | DoBlue ;
        XAllocColor( prDisplay, DefaultColormap(prDisplay,nScreenNum) ,
                    &rColor );

        nPixel[i]=rColor.pixel;
        }
    }
//&>>&B 0 B 0
//&<<&void mmm_Screen::Init(int argc, char **argv);
void mmm_Screen::Init(int argc, char **argv){

    SetWindowManagerHints(prDisplay, PRG_CLASS, argv,argc, nWnd,
                WND_X, WND_Y, WND_WDT, WND_HGH, WND_MIN_WDT, WND_MIN_HGH,
                WND_TITLE, WND_ICON_TITLE, 0 );
    XMapWindow(prDisplay, nWnd);

//&<<&    prFontInfo=XLoadQueryFont( prDisplay, "-*-lucidatypewriter-*-17-*-m-*-" );
//    prFontInfo=XLoadQueryFont( prDisplay, "*-*--17-*-m-*" );
    prFontInfo=XLoadQueryFont( prDisplay, "*-lucidatypewriter-*-14-*-m-*" );
//    prFontInfo=XLoadQueryFont( prDisplay, "*--10-*-m-*" );
    XMemTest(prFontInfo!=0,"UE: cannot XLoadQueryFont");

    FontHeight=prFontInfo->max_bounds.ascent + prFontInfo->max_bounds.descent;
    FontWidth=prFontInfo->max_bounds.width;
    FontDescent=prFontInfo->max_bounds.descent+1;
//&>>&1 0 1 0

//    InitColorMap();

    ReadWindowParameters();

    XSelectInput(prDisplay, nWnd, ExposureMask | KeyPressMask );
    }
//&>>&3 0 3 0
//&<<&mmm_Screen::~mmm_Screen(){
mmm_Screen::~mmm_Screen(){
//&<<&    #ifdef _ENABLE_LOGGING_
    #ifdef _ENABLE_LOGGING_
        DoLog("mmm_Screen::~mmm_Screen(){\n");
    #endif
//&>>&3 0 3 4
    //if(prDisplay!=NULL)XCloseDisplay(prDisplay); // I don't understand why, but it causes SIGSEGV
//&<<&    #ifdef _ENABLE_LOGGING_
    #ifdef _ENABLE_LOGGING_
        DoLog("    }\n");
    #endif
//&>>&0 0 0 0
    }
//&>>&0 0 0 0
//&<<&void mmm_Screen::ReadWindowParameters(){
void mmm_Screen::ReadWindowParameters(){
    XWindowAttributes rXWindowAttributes;

    XGetWindowAttributes(prDisplay,
                            nWnd,
                            &rXWindowAttributes);

    WIDTH  = rXWindowAttributes.width  / FontWidth  ;
    HEIGHT = rXWindowAttributes.height / FontHeight ;
    }
//&>>&7 0 7 C
//&<<&void mmm_Screen::SetCursor(int x,int y,int attr){
void mmm_Screen::SetCursor(int x,int y,int attr){
    GC      prGC;
    prGC=XCreateGC(prDisplay, nWnd, 0, NULL );

    cursx=x;
    cursy=y;

    char pccr[2];
    pccr[0]=cur->GetCh(); pccr[1]=0;
    cold=pccr[0];

    cattrold=cur->pos->GetTextAttr();

    XSetForeground(prDisplay, prGC, (attr>>4)&0xf );
    XFillRectangle(prDisplay, nWnd, prGC,
        FontWidth*cursx, FontHeight*cursy+FontDescent ,
        FontWidth -1 , FontHeight -1 );

    XSetForeground(prDisplay, prGC, attr&0xf );
    XSetFont(prDisplay, prGC, prFontInfo->fid );
    XDrawString( prDisplay, nWnd, prGC, FontWidth*cursx, FontHeight + FontHeight*cursy ,
                pccr, 1 );

    XFreeGC(prDisplay, prGC);
    }
//&>>&10 0 10 13
//&<<&void mmm_Screen::ClrCursor();
void mmm_Screen::ClrCursor(){
    if(cursx<0 || cursy<0) return;
    GC      prGC;
    prGC=XCreateGC(prDisplay, nWnd, 0, NULL );

    char pccr[2];
    pccr[0]=cold; pccr[1]=0;

    XSetForeground(prDisplay, prGC, (cattrold>>4)&0xf );
    XFillRectangle(prDisplay, nWnd, prGC,
        FontWidth*cursx, FontHeight*cursy+FontDescent ,
        FontWidth -1 , FontHeight -1 );

    XSetForeground(prDisplay, prGC, cattrold&0xf );
    XSetFont(prDisplay, prGC, prFontInfo->fid );
    XDrawString( prDisplay, nWnd, prGC, FontWidth*cursx, FontHeight + FontHeight*cursy ,
                pccr, 1 );

    cursx=cursy=-1;
    XFreeGC(prDisplay, prGC);
    }
//&>>&B 0 B 25
//&<<&void SetTitle(char *dirn,char *name){
void SetTitle(char *dirn,char *name){
  XTextProperty prWindowName ;
  char tt[0x200];
  strcpy(tt,"mmmX : ");
  strcat(tt,name);
  strcat(tt,"  in  ");
  strcat(tt,dirn);
  char *tt1=tt;

  XMemTest(XStringListToTextProperty(&tt1, 1, &prWindowName )!=0,"Memory error");

  XSetWMName(mmm_screen.prDisplay, mmm_screen.nWnd, &prWindowName );
  XSetWMIconName(mmm_screen.prDisplay, mmm_screen.nWnd, &prWindowName );
}
//&>>&5 0 5 8

//&<<&void DrawLine(char *Str, int PosY, char Attr,int slen){
void DrawLine(char *Str, int PosY, char Attr,int slen){
    GC      prGC;

    prGC=XCreateGC(mmm_screen.prDisplay, mmm_screen.nWnd, 0, NULL );

    XSetForeground(mmm_screen.prDisplay, prGC, (Attr>>4)&0xf );
    XFillRectangle(mmm_screen.prDisplay, mmm_screen.nWnd, prGC,
        0 ,mmm_screen.FontHeight*PosY+mmm_screen.FontDescent+1,
        mmm_screen.WIDTH*mmm_screen.FontWidth,mmm_screen.FontHeight);

    XSetForeground(mmm_screen.prDisplay, prGC, Attr&0xf );
    XSetFont(mmm_screen.prDisplay, prGC, mmm_screen.prFontInfo->fid );

    XDrawString( mmm_screen.prDisplay, mmm_screen.nWnd, prGC, 0, mmm_screen.FontHeight*(PosY+1) ,
                Str, (strlen(Str)<mmm_screen.WIDTH)?strlen(Str):mmm_screen.WIDTH );

    XFreeGC(mmm_screen.prDisplay, prGC);
    }

//&>>&1 0 1 47

//&<<&mmm_KeyBoard::mmm_KeyBoard();
mmm_KeyBoard::mmm_KeyBoard(){
//&<<&    #ifdef _ENABLE_LOGGING_
    #ifdef _ENABLE_LOGGING_
        DoLog("mmm_KeyBoard::mmm_KeyBoard(){\n");
    #endif
//&>>&1 0 1 29
    InitKeyboardLayout();
    AltCase=InitDefaultAltCase();
//&<<&    #ifdef _ENABLE_LOGGING_
    #ifdef _ENABLE_LOGGING_
        DoLog("    }\n");
    #endif
//&>>&1 0 1 0
    }
//&>>&2 0 2 24
//&<<&mmm_KeyBoard::~mmm_KeyBoard();
mmm_KeyBoard::~mmm_KeyBoard(){
//&<<&    #ifdef _ENABLE_LOGGING_
    #ifdef _ENABLE_LOGGING_
        DoLog("mmm_KeyBoard::~mmm_KeyBoard(){}\n");
    #endif
//&>>&1 0 1 2E
}
//&>>&1 0 1 4
//&<<&void mmm_KeyBoard::InitKeyboardLayout();
void mmm_KeyBoard::InitKeyboardLayout(){
    int i,j;
    for(i=0;i<4;i++) for(j=0;j<128;j++) keys[i][j]='.';
    }
//&>>&2 0 2 21
//&<<&char *mmm_KeyBoard::InitDefaultAltCase(){
char *mmm_KeyBoard::InitDefaultAltCase(){
  char *AltCase=new char[256];
  for(int i=0;i<256;i++){
    AltCase[i]=
      i>='A' && i<='Z' ? i+('a'-'A') :
      i>='a' && i<='z' ? i-('a'-'A') :
      i;
  }
  return AltCase;
}
//&>>&6 0 6 0
//&<<&void mmm_KeyBoard::SetACode(int n){ 
void mmm_KeyBoard::SetACode(int n){
    acode=mmm_KBD.keys[n];
    }
//&>>&0 0 0 16
//&<<&int mmm_KeyBoard::GetScan(){
int mmm_KeyBoard::GetScan(){
    XEvent  rEvent;
    while(1){
        if( XEventsQueued(mmm_screen.prDisplay, QueuedAfterFlush)==0) View();
                                // screen is redrawed only if there is
                                // no events to be processed.
        XNextEvent(mmm_screen.prDisplay, &rEvent);
        switch(rEvent.type){
            case Expose:     // Resize, Move, Min, Max ...
                mmm_screen.ReadWindowParameters();
                Redr();
                break;
            case KeyPress:
                mmm_f_Shift=(rEvent.xkey.state&ShiftMask)     ?1:0;
                mmm_f_Alt  =(rEvent.xkey.state&AltMask)       ?1:0;
                mmm_f_Ctrl =(rEvent.xkey.state&ControlMask)   ?1:0;
                mmm_f_Caps =(rEvent.xkey.state&LockMask)      ?1:0;

                return rEvent.xkey.keycode;

            }
        }
    }
//&>>&0 0 0 0

//&<<&Keyboard Layouts 

char *mcode=mmm_KBD.keys[0],*acode=mmm_KBD.keys[2];

volatile int   mmm_f_E0=0;
volatile int   mmm_f_LeftShift=0,mmm_f_RightShift=0;
volatile int   mmm_f_LeftCtrl=0,mmm_f_RightCtrl=0;
volatile int   mmm_f_LeftAlt=0,mmm_f_RightAlt=0;
volatile int   mmm_f_Caps=0;
volatile int   mmm_f_FixShift=0,mmm_f_FixAlt=0;
volatile int   mmm_f_Shift=0,mmm_f_Alt=0,mmm_f_Ctrl=0;
//&>>&3 0 3 0

//&<<&void MkScan(int code);             

void MkScan(int code){
//&<<&    #ifdef _ENABLE_LOGGING_
    #ifdef _ENABLE_LOGGING_
        DoLog("MkScan(int code=%04x){\n",code);
    #endif
//&>>&1 0 1 0
    code|=(mmm_f_Shift<<0x8);
    code|=(mmm_f_Alt  <<0x9);
    code|=(mmm_f_Ctrl <<0xa);
    code|=(mmm_f_Caps <<0xb);
    if(code==0x709) MMMlib_ABORT(0x709);
    Command(code);
//&<<&    #ifdef _ENABLE_LOGGING_
    #ifdef _ENABLE_LOGGING_
        DoLog("    }\n");
    #endif
//&>>&1 0 1 19
}
//&>>&1 0 1 0

void Beep(){ XBell(mmm_screen.prDisplay, 100); }

//&<<&void __EXIT();
/*
   EXECUTER_FILENAME=

   e:
   cd \amstex
   commands
   %comspec
   c:
   cd \
   i:\astr\mmm.bat -1 e:\mmm.dir -2 e:\amstex\astex.tex
*/

//&<<&void PutCurDir(FILE *f){   // prints current drive & directory into FILE *f
void PutCurDir(FILE *f){
  char *cd=getcurdir();                        // current disk
  int lcd=strlen(cd);
  if(lcd>3 && cd[lcd-1]=='/') cd[--lcd]=0;
  fprintf(f,"cd %s\n",cd);
  delete cd;
}
//&>>&4 0 4 1

void __EXIT(){
//&<<&    #ifdef _ENABLE_LOGGING_
  #ifdef _ENABLE_LOGGING_
      DoLog("void __EXIT(){ \n");
  #endif
//&>>&1 0 1 6
    char *s;
    FILE *fRunScript,*filelist;

    s=MFileName(EXECUTER_FILENAME);
    fRunScript=fopen(s,"w"); MemTest(fRunScript!=0);
    delete s;

    PutCurDir(fRunScript);
    while(mmm_LineClipboard && mmm_LineClipboard->prev)
        mmm_LineClipboard=mmm_LineClipboard->prev;
    while(mmm_LineClipboard && mmm_LineClipboard->next){
        mmm_LineClipboard->Write(fRunScript,FILE_ASCII);
        mmm_LineClipboard=mmm_LineClipboard->next;
        }
    PutCurDir(fRunScript);
    fclose(fRunScript);

    s=MFileName("__mmm__.mmm");
    filelist=fopen(s,"w"); MemTest(filelist!=0);
    delete s;
    PerformExitingFromFiles(filelist);
    fclose(filelist);

    chmod(MFileName(EXECUTER_FILENAME), 0755 );
//&<<&    #ifdef _ENABLE_LOGGING_
  #ifdef _ENABLE_LOGGING_
      DoLog("    } exit(-1)...\n");
  #endif
//&>>&1 0 1 6
    system(MFileName(EXECUTER_FILENAME));
    exit(-1);
}
///// mmm_os2.err mmm_os2.err mmm_os2.err mmm_os2.err mmm_os2.err
//&>>&1E 0 F 0
void MMMlib_Console    (int ccode) {  }

//&<<&void File::MkWild();
void File::MkWild(){
  char str[0x100];
  DIR *cdir;
  struct dirent *dp;
  struct stat fI;
//&<<&  cdir=opendir("."); /////////read directories
  cdir=opendir(".");
  if(cdir==NULL){ NewLine("here must be directory\nbut sorry....")->LinkBefore(pos); }
  dp=readdir(cdir);
  while(dp!=0){
    stat(dp->d_name,&fI);
    if( (fI.st_mode&S_IFDIR) && strcmp(dp->d_name,".") ) {
        sprintf(str,"%s/%s",dp->d_name,buf);
        NewLine(str)->LinkBefore(pos);
        }
    dp=readdir(cdir);
    }
//&>>&0 0 0 0
//&<<&  cdir=opendir("."); ///////// read files
  cdir=opendir(".");
  if(cdir==NULL){ NewLine("here must be directory\nbut sorry....")->LinkBefore(pos); }
  dp=readdir(cdir);
  while(dp!=0){
    stat(dp->d_name,&fI);
    if(!(fI.st_mode & S_IFDIR)){
        sprintf(str,"%-25s %8ld <%2d> %02d:%02d:%02d",dp->d_name,
                 fI.st_size, fI.st_nlink,
                 (fI.st_mtime>>11)&15, (fI.st_mtime>>5)&63,  (fI.st_mtime&31)*2 );
        NewLine(str)->LinkBefore(pos);
        }
    dp=readdir(cdir);
    }
//&>>&D 0 D C
  while(pos->prev) pos=pos->prev;
}
//&>>&5 0 5 7
////// /home/machulsk/Xprog/*
//&>>&7 0 7 1C
