/*  rexx-program generating a Write&Set folder and
    program objects with Wordstar file association,
    pointing to WSformat and WSedit
    Author: Martin Vieregg, Germany, December 2002 */

Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

CurrentDir = directory()

rc = SysOpenObject("<WSAssocFolder>", ICON, TRUE)

if (rc = 1) then DO
  say "The Write&Set association folder already exists.";
  say "Do you want to delete all these WPS Objects ? (press Y or N) "
  pull Contin
  if  ((Contin = "N") | (Contin = "n")) then EXIT

  Call Destroy "<WSreadmeShadow>"
  Call Destroy "<WSwsformatShadow>"
  Call Destroy "<WSwsformatHelp>"
  Call Destroy "<WSwseditHelp>"
  Call Destroy "<WSlessonsShadow>"
  Call Destroy "<WSwsformat>"
  Call Destroy "<WSwseditform>"
  Call Destroy "<WSwseditunform>"
  Call Destroy "<WSAssocFolder>"
  "@pause"
  exit
END

say "Please enter the WSformat directory"
say "or RETURN if the directory is "CurrentDir"\WSformat"
pull WSformatDir
if (WSformatDir = "") then
  WSformatDir = CurrentDir"\WSformat"
say "Please enter the WSedit directory"
say "or RETURN if the directory is "CurrentDir"\WSedit"
pull WSeditDir
if (WSeditDir = "") then
  WSeditDir = CurrentDir"\WSedit"
say
say "The WSedit executable file is:"
"@dir "WSeditDir"\WSedit.exe /f"
say "The WSformat executable file is:"
"@dir "WSformatDir"\WSformat.exe /f"

  Call SysCreateObject "WPFolder", "Write&Set associations", "<WP_DESKTOP>",,
	"OBJECTID=<WSAssocFolder>;;"

  Call SysCreateObject "WPProgram", "WSedit unformatted", "<WSAssocFolder>",,
"OBJECTID=<WSwseditunform>;EXENAME="WSeditDir"\WSedit.EXE;ICONFILE="CurrentDir"\InstData\WSedit.ICO;ASSOCFILTER=*.WS;"

  Call SysCreateObject "WPProgram", "WSedit formatted", "<WSAssocFolder>",,
"OBJECTID=<WSwseditform>;EXENAME="WSeditDir"\WSedit.EXE;ICONFILE="CurrentDir"\InstData\formated.ICO;ASSOCFILTER=*.FMT,*.FUN,*.TOC,*.TAF;"

  Call SysCreateObject "WPProgram", "WSformat", "<WSAssocFolder>",,
"OBJECTID=<WSwsformat>;EXENAME="WSformatDir"\WSformat.EXE;ICONFILE="CurrentDir"\InstData\WSformat.ICO;ASSOCFILTER=*.WS,*.TXT;"

Call SysCreateObject "WPShadow", "WSformat", "<WP_DESKTOP>",,
	"OBJECTID=<WSwsformatShadow>;SHADOWID=<WSwsformat>;"

Call SysCreateObject "WPShadow", "readme.txt", "<WSAssocFolder>",,
	"OBJECTID=<WSreadmeShadow>;SHADOWID="CurrentDir"\readme.txt;"

Call SysCreateObject "WPProgram", "WSedit Help", "<WSAssocFolder>",,
"OBJECTID=<WSwseditHelp>;EXENAME=VIEW.EXE;PARAMETERS="WSeditDir"\wsedit-e.hlp;"

Call SysCreateObject "WPProgram", "WSformat Help", "<WSAssocFolder>",,
"OBJECTID=<WSwsformatHelp>;EXENAME=VIEW.EXE;PARAMETERS="WSformatDir"\wsfdocu.hlp;"

Call SysCreateObject "WPShadow", "Tutorial", "<WSAssocFolder>",,
	"OBJECTID=<WSlessonsShadow>;SHADOWID="CurrentDir"\Tutorial;"


"pause"

Call SysOpenObject "<WSAssocFolder>", ICON, TRUE

exit

Destroy:
if SysDestroyObject(ARG(1)) then DO
  say "deleting "ARG(1)" OK"
END
else DO
  say "deleting "ARG(1)" failed"
END
return