..This is the unformatted text of the documentation. You are encouraged to format and print the file.
..The file is also the source of the Winhelp file which part of the archive. It was
..created by Hypermake.
..Some dot commands refer to Hypermake only (.ID, .DP, .WA)
.. .IN and .IT (Index, Index turned) refer to Hypermake and WSformat index which is not described yet
.bt WSformat.bmp
.he sfE   WSformat 0.81 Documentation 
.fi Title.ws
.ti WSformat 0.81 Documentation
.<>
.1
Introduction

.if not WSformat
..this code can be interpreted by WSformat, but is for Hypermake only
.sfJ
 WSformat 0.81 Documentation
.sf
.end not WSformat

.in Introduction
.2
WSformat abstract

WSformat is a formatting and printing program for Wordstar (DOS) files. WSedit 
and WSformat together are a full-featured word processing suite, running under 
current operating systems, but based on the Wordstar DOS philosophy ('what you 
see is what you want' and not 'what you see is what you get'). Nevertheless, 
WSformat does have a provision for document preview.

Wordstar Compatiblity: WSformat accepts all Wordstar (DOS) files, but does not 
support all Wordstar DOS functions, i.e., those which were added after 
Wordstar Version 4. Instead, some extended functions (such as generating 
tables of contents or handling footnotes) are implemented in a 
WSformat-specific way. Basic Wordstar 5-7 'symmetrical sequences' are 
recognized (indentions, for example).

WSformat is Shareware and WSedit is Freeware.

WSformat supports hyphenation, the creation of end notes and footnotes, 
generation of tables of contents and indexes, line drawing, embedding graphics 
in text and allows conditional statements. In contrast to the older versions 
of DOS Wordstar, document preview and printing use functions provided by the 
Windows (or OS/2) operating systems. This means you have access to the 
printers and type fonts which are installed on the operating system.

The WSformat command syntax is very similar to that of Hypermake. From a WS 
file, Hypermake will generate an equivalent file in RTF, Winhelp, HTML, IBM 
Help or Microsoft HTML-Help format.

WSformat requires Windows 98, Windows NT 4, OS/2 Warp 3 or later.

.2
Word Processing with WSedit+WSformat

.ID P_PROCESSING
Word processing with WSedit+WSformat is very different from those Windows word 
processing programs such as Winword or StarOffice, and also differs in some 
respects from Wordstar for DOS. Word processing operations are closer to 
Latech than to Winword, for example. With WSformat, the task of 'text content 
editing' and that of 'typesetting' are sequention operations, rather than 
simultaneously.

For the moment, forget all you have learned about computer word processing and 
think about the time before the personal computer was invented, when your 
'word processor' was pen, scissors, cement, etc. The way to get a complex 
document involved some or all of the following steps:

Step 1:Writing a draft in longhand, often including notes that would not 
appear in the final publication;
Step 2:Typing the draft with a typewriter;
Step 3:Correcting the text by hand on the typewriter copy;
Step 4:Sending the typewritten manuscript to the typesetter.

In the first step there was no need to consider the layout - page size, 
margins, type faces. The author concentrated only on the contents... The four 
steps were performed step by step. Today when you prepare a document using 
Winword, the steps are all intermingled, effectively taking place 
simultaneously. Because of this mode of operation, Winword and its 
counterpart word processors are difficult to use. This design philosophy 
produces word processing programs that are big, slow, drain system resources, 
crash often, and in some cases are unable to produce the document the user 
requires.

By way of contrast, when documents are prepared with WSedit+WSformat, the four 
steps take place sequentially rather than concurrently.

Step 1:Editing Text is prepared as an (unformatted) 'raw' text file (a *.WS 
file) using WSedit (or Wordstar DOS). Such a text file will not 
include fixed margins. If you use WSedit, the margin of the displayed 
text margin depends only on the settings of the editing window and the 
screen font; it is otherwise not fixed at this stage.

When preparing documents on your computer, WSformat will only rarely be called 
upon to process the text. This is the reason why I have decided not to create 
a single program incorporating both functions.

Step 2:Starting WSformat, formatting the unformatted raw-text WS file to 
produce a formatted FMT file:

The WSformat 'format' function reads the raw-text WS file and writes 
an FMT file. It does not modify the WS file in any way. In the FMT file, which 
can be also viewed using WSedit or Wordstar (DOS), the right margin is now 
fixed, the page breaks are apparent, and words at the end of the line which 
require hyphenation are displayed accordingly.

Step 3:Minor changes by hand on the formatted FMT file

If you are not satisfied with some formatting details, you can make small 
changes to the FMT file. These include such things as incorrect hyphenations, 
and more importantly, page breaks which can be improved.

However, avoid making bigger changes to the FMT file; if these are considered 
necessary, it is more expedient to make the changes to the WS file and run 
WSformat again. Because WSformat formatting is extremely fast (about 100 pages 
per second, depending on your processor and the nature of the text), this does 
not represent a significant delay in production.

The WSformat preview feature helps in locating sections of the text where the 
printout can be improved. The printout in the Preview window mirrors exactly 
page printout.

Step 4:Printing the final version of the document

After making the final changes to the FMT file, select the physical or virtual 
printer installed on your computer and print your document. This is done the 
same way as it would be for other current word processors. Besides physical 
printers (laser or inkjet printers), it is possible to use 'virtual' printers 
(FAX and PDF creation programs). These also work on files produced with 
WSformat.

.2
Who should use WSformat?

The WSedit+WSformat word processing suite is useful for the following users:

Users of Wordstar (DOS)
Of course, all computer users who resist Winword and similar programs will 
find a new home with WSedit and WSformat. (I intend to support both of 
these programs in the long term, because I myself for various reasons find 
Winword and similar programs unproductive.)

Academics and other authors who have to prepare large and complex 
(scientific) documentation
Authors, students and others often fear using winword-like programs when 
generating large, complex documents. Many people have found themselves 
typing and re-typing such documents, due to the inherent instability (and 
the resulting crashes) when handling such documents. Because of the serial 
processing of WSformat, there is virtually no limit on file size. There are 
no problems in processing a document with hundreds of pages, thousands of 
footnotes, and dozens of bitmap graphics.

Note to Students: WSformat is available for a special, very low student fee. 


All people who do not like winword-like software
Those users who do not like winword-like word processing software are 
invited to switch to WSedit+WSformat. WSedit+WSformat is also a fast, 
easy-to-use and adequate software for writing even simple correspondence.

Companies who want to reduce software expenses
WSedit is free and WSformat is much cheaper than word processors such as 
Winword. Support by telephone or by E-Mail is simpler, because dot commands 
are transmitted within the document, instead of being forced to describe 
mouse controlled actions. ('On the top left, you see an icon with a wide 
border...') By using the 'embed file .fi' command, it is possible to 
observe standards throughout documents regardless of the author. For 
example, the company letterhead to be used in all WSformat files can be 
maintained centrally, and when it is necessary to change 'boilerplate' 
text, those changes will appear in all subsequent publications.

Limitations

WSformat does not support muli-column text editing and formatting. 
(Nevertheless, I plan multi-column printouts.) It is not intended for 
desktop-publishing of such things as newsletters, magazines, etc. It is not 
possible to include output from other applications, such as the way Winword 
does with Excel, Access and so on. Instead you have to generate a bitmap file 
from your spreadsheet, database or graphics program which can then be embedded 
into a text document produced by WSformat. When making changes to your 
spreadsheet, you have to update the bitmap file manually, something Winword 
will do automatically.

For technical writers (physicists and mathematicians, for example) Latex will 
also be found useful because WSformat has no specific provisions for handling 
mathematical formulas. With WSedit+WSformat, you have to generate a bitmap 
file of your formula.


.1
Installation and first steps

.ID P_INSTALLATION
.in Installation
.2
Installation of WSformat

Unzip the WSformat archive file to a directory of your choice, e.g. 
C:\Programs\WSformat.
Drop the WSformat.exe file onto your desktop to get a reference to the 
WSformat.exe file.

(An easy-to-use table installation program which will also generate file 
associations is planned for the 1.0 version.)

When starting WSformat the first time, some initialization procedures run 
automatically:

-A binary file WSformat.dta which retains user settings will be generated; 
it contains the data found in the settings notebook (settings - settings 
notebook)
-A simple text file fonts.ini will be generated. It stores the information 
about the fonts which are available on your system. It is recommended that 
you modify this file to fit your needs. (settings - font definition)
-The fonts.ini text file is converted to a binary file printername.dta 
which holds detailed font information before formatting or printing. When 
changes are made to fonts.ini, the printername.dta file is updated 
automatically and a small window 'registering fonts' appears.

It is also necessary to modify some entries in the settings notebook 
(settings - settings notebook):

To start WSedit or your preferred Wordstar editor from WSformat, select the 
Program page of the settings notebook and enter the full filename of the 
editor, e.g. C:\Programs\wsedit\wsedit.exe. If the file exists, the edit 
field turns green; otherwise it remains red.
Select the printer to which formatting refers to. This should be your 
favourite printer for printouts.

By default, hyphenation is turned off. If you want to turn hyphenation on, do 
the following:

Select the Hyphenation page in the settings notebook. For all languages 
other than German, click on 'external tex file' and select your language. 
Please note that some conventions of British and American English are 
different. The browser, which uses the Google search engine, is started and 
you are directed to download the file to the directory where WSformat.exe 
resides. Tex hyphenation files are small.
For German users, I recommend the internal german hyphenation plug-in 
which is better than the tex algorithm.

.2
Modifying WSedit settings

By default, WSedit 0.91 does not know some file extensions that WSformat uses. 
(This will be changed for the next update.) All of the new file extensions 
refer to the 'formatted file' type.

Start WSedit with a WS file
Type Ctrl-OO to access the settings
Press the 'new' button
Next to the 'new' button, enter the new file extensions FMT,FUN,TOC,TAF 
(divided by commas, no spaces)
Choose 'file' page, click on the 'Wordstar 4/5 formatted' radio button
In the 'description of file type' editing field, enter 'Wordstar 
formatted'
Choose 'wrap' page, click on the 'word wrapping - not at all' radio 
button
Choose 'hilight' page
Select 'syntax highlighting enabled'
Select 'WS formatted page break'
Select 'WS formatted floating background'
Press OK.

When using DOS Wordstar instead of WSedit, there's no need for 
modifications.

.2
Format and print this documentation

.it Documentation
The archive file contains the documentation in WS format (unformatted text) 
and in Help file format. You have got access to the Help file from the 
WSformat main window, Help menu item, or by pressing the yellow questionmark 
buttons. If you prefer a printed documentation, you are encouraged to print 
your docu.

Select the WS file

First select the file which you want to format and print, in this case 
WSFDOCU.WS. Click on the File menu item, and then choose select. You may 
also simply drop the WSFDOCU.WS file icon into the dropdown field on the 
WSformat main window.

Format the WS file

Simply press the format button. A new file, WSFDOCU.FMT, will be 
generated.

Edit the FMT file

If you really want to create a paper print, take a look at the WSFDOCU.FMT 
file. By default, after formatting the editor starts and selects the FMT file. 
Take a look at the page breaks which are represented in WSedit by a floating 
yellow background. If you want to improve some page breaks, do it and then 
save the FMT file.

Preview

You are also encouraged to preview the file; simply press the preview 
button. When saving the FMT file in the editor, the preview window is updated 
automatically. In the preview window, use the Pg dn and Pg up keys on your 
keyboard, or use the left and right mouse button. For example, to go to page 
20, hold down the left mouse button and drag the mouse to the right. Change 
the height and width of the Window. The preview scale depends on the window 
width.

Print the file

Select a printer by using the dropdown box in the WSformat main window. Press 
the Print button, or select File - Print pages from the menu. In this 
case, you can select single pages.

.1
WSformat user interface

Because WSformat is a text compiler, there are only a few windows which forms 
the user interface.

.dp#23
.2
Main Window

.ID P_MAIN
.it main window
The WSformat main window is the central command window for editing, 
formatting, and printing text; it is where you start jobs and open other 
windows. While merely editing text, you can operate on your WS files directly 
with your WSedit or Wordstar editor. While formatting and printing, start 
WSformat and leave the main window open. From there, you can also execute the 
editor on unformatted text.

Selecting a WS file

There are several ways of selecting a WS file.

Click on the File menu item, and then choose select. You will get a 
file dialog which is similar to those used in many other programs.
Drop the WS file on the WSformat icon on your desktop
Drop the WS file icon onto the dropdown field of the WSformat main 
window
Enter the WS file name after WSformat on the command line.

After successfully selecting a WS file, some of the five WSedit function 
buttons are enabled, depending on the existence of the corresponding FMT 
(formatted) file.

Formatting a WS file

Press the Format button or select the menu item Make - formatted file. 
Either choice is acceptable.

Editing files

To edit files from WSformat, the file name of your favourite editor has to be 
entered in Settings - settings notebook, page Program.

Selecting the button unformatted - edit starts the editor with the 
designated file (with the file extension WS); selecting formatted - edit 
starts a file with the extension FMT.

The menu items file - edit - unformatted and file - edit - formatted have 
the same effect as the corresponding buttons. If the FMT file does not exist, 
the buttons are disabled, while the menu items remain enabled.

..Arndt wsfdocu2.ws
The menu item File - close editors closes all Editor windows (for 
programmers: by sending WM_CLOSE messages) of the selected project file. This 
has the same effect as clicking to the 'Window Close' button of each editor 
window. Do not use this function with a DOS (Wordstar) editor. In this case, 
you are asked whether to interrupt the DOS application or not. If you press 
yes, all data in the DOS window will be lost.

Previewing formatted files

To open the preview window, press the Preview button or select File - 
Preview.

Printing formatted files

To select a printer, press the dropdown button and make your selection. To 
print the whole document, press the print button. To print only a section of 
the document, select the menu item File - Print pages. Note that you get the 
best result if the selected printer is also the printer where formatting 
refers to. You can reselect the 'reference printer' in the settings notebook, 
page Program.

While the print job is running, the print button turns into a stop 
printing button. Note that if you interrupt printing, a lot of data likely 
will have been sent to the printer queue. You can delete this data by opening 
your printer object.

Dropdown field and compile information

.in Dropdown field
In the middle of the WSformat main window, there's the dropdown field where 
you are able to drag and drop WS files. This will select the dropped WS 
file.

In the dropdown field, there are three lines, each with an LED. These display 
the current processing states of the three WSformat jobs:

When formatting a text, the progress of the operation is displayed on the 
first line. While formatting, the red LED glows.
While preview is activated and the preview window is shown, the yellow 
LED glows and the page number of the page currently displayed in the 
preview window is shown. The page number also appears in the title bar of 
the Preview window.
While a print job is running, the blue LED glows.

The WSformat print job is faster than the printer can print the results. The 
operating system buffers the data and sends it to the printer as requested, 
depending on the speed of the printer.

.in Multithreading
WSformat is a multi-threaded program. This means that even while WSformat 
is executing one a job, it is able to do another job concurrently. Besides the 
main thread - editing the settings notebook, for example - there are three 
threads which are represented by the red, yellow and blue LED: When the LED 
glows, the thread is running. This means that you can format a file while 
another file is still being printed, but you cannot print a file while another 
file is printed. While printing a file, you can select another file and format 
or preview this new document.

The extended compile jobs Make - Text and Footnote, Make - Content and 
Make - Index are also executed in the format thread.

You are not allowed to exit WSformat until all threads are finished. If 
WSformat does not end a thread - we don't hope that such a bug occurs - you 
have to kill the WSformat application (in Windows, press Ctrl-Alt-Del 
simultaneously and select WSformat to end the process). In any case, contact 
the author if the bug can be reproduced.

.wa verti 25
.2
Settings Notebook

.in Settings notebook
The data of the settings notebook is stored in the file WSformat.dta.

.3
Program page

.ID P_PROGRAM
In the entry field Full filename of the embedded editor, you can select the 
editor program to be executed when pressing the buttons edit unformatted and 
edit formatted on the WSformat main window. If you don't remember the file 
name, use the search button.

If the checkbox open editor after make is checked, WSformat automatically 
executes the editor with the generated file after finishing the task of 
formatting the text, generating the table of contents, or performing any 
similar operations.
You can restrict where WSformat is to search for files by supplying it with a 
list of directories. The directories are separated from one another by a 
semicolon ';'. Instead of typing the directory names directly, you can also 
use the search button. The directory where WSformat.exe resides is always 
searched, but only if the search in these directories has failed. The list of 
directories refers to the following files:

Formatted and unformatted files, by using the .FI command
Heading template files
Bitmap files, by using the .BM and .BT commands
file SILBAUSN.WS (internal German hyphenation)

Printer to which formatting refers is relevant only if you have installed 
more than one printer on your system. In such a case, selecting the active 
printer affects how WSformat will perform its calculations while formatting. 
If you select another printer for printing, the spaces between words can 
differ because of slight differences of printer font metrics. But neither 
line breaks nor page breaks are affected.

Auto correct file extension affects the main window of WSformat. If this 
setting is on, you can also drop FMT files into the dropdown window and the 
unformatted file will be given the extension WS. Deselect the checkbox if 
you:
Want to re-format a FMT file
Want to use extensions other than WS for the unformatted Wordstar file
want to preview or print files other than FMT or TAF files, for example, a 
TOC (table of contents) file.

Allow printing unformatted WS files can be useful if you have a text file 
with a table or graphics and no running text, and thus the text file will not 
need to be reflowed. Running text will not look as good as it would be with 
the formatted file. Normally, this setting should be turned off.

The program language is only English at this time. The German setting 
affects only some error and information messages. To translate WSformat to 
other languages, I need help from native speakers. Please contact me if you 
are interested in such an effort - you will receive a donation for your 
work.

Concern printing group box

Lower the Print job priority if user input slows down while running a print 
job.

Concerning Preview groupbox

When using preview you can also choose between positioning of each character 
and positioning only each word. Positioning only each word is faster, but it 
affects the word spacing, because WSformat can only select integer values of 
font sizes and then the spaces between words can differ. The default value is 
enabled.

.3
Format page

.ID P_FORMAT
On the format page, you can change settings concerning formatting rather than 
directly previewing or printing or setting margins. These settings are located 
on the Layout page.

Change hard spaces to soft spaces at the beginning of a line is useful if 
WordStar conventions using soft spaces have not been observed for text 
indention. Note that enabling this function will result in a wrong format if 
normal spaces have been used to indent the first line of a paragraph. The 
default value is disabled.

Reduce factor of spaces in wrapped lines ('gum factor') affects the width of 
the spaces between the words of a wrapped line. A gum factor of '1' means that 
on average the sum of the width of all spaces in a line is reduced about the 
width of one Courier 12 character (1/10 inch). A negative gum factor enlarges 
the average width of spaces. You can change this setting in your document by 
entering '.GU', followed by the value.

Stretch factor of tabs (soft spaces) applies only to proportional fonts. In 
a proportional font, there's no single width for every character; instead 
every character is assigned its own width. If text printed in a proportional 
font table is indented using soft spaces, there is the question to which scale 
the indention refers to. This scale is now defined by the 'tab stretch' (.TS) 
value. A value of 60 means the width of one soft space is equal to 60% of the 
widest character in the font, usually the capital 'W' in a Roman alphabet. If 
you want to be sure to keep two columns of a table from overlapping, try a 
value of 100. This applies even if the column contains only 'W's. Since this 
is highly unlikely, adequate values are from 50 to 60. When creating tables 
with a proportional font, it is strongly recommended to check carefully with 
Preview.

All .LH Line Height values refer to default normal font
let WSformat change the .LH values in the formatted file, dependent on the 
current font selected with .SF. This omits overprinting lines when using 
large fonts. See Line Height.


Default fonts

.it default font
Using fonts is described in an own chapter of this document. Fonts are 
represented by single letters (case-sensitive). In the file fonts.ini, font 
letters are assigned to the fonts available on your operating system. Single 
characters represent fonts with no attribute, adding ' means italic, " means 
bold, and & bold-italic. Note however that all these conventions can be 
redefined.

You can select default values for both the normal and alternate fonts. The 
selected font written with the selected font is displayed in the white field 
on the right.

.3
Hyphenation page

.ID P_HYPHENATION
Hyphenation is an important feature of a word processing program that must 
formatting text with a fixed right margin. The more hypenation points are 
correctly found, the better the final appearance of the document.

The default value of hyphenation is no hyphenation.

External Tex file

For all languages other than German, the external tex file setting is 
recommended. Use the Google search engine on the Internet to locate the tex 
hyphenation file (there is one available for almost every language). Once 
located, download it to your computer and then save it in or move it to your 
WSformat directory so that it will be available. These files are available for 
nearly every language. For additional information see the chapter on 
installation.

Tex hyphenation files are data-based text files which can be viewed with an 
ASCII editor that accepts the IBM-OEM codepage. If a word is not currently in 
the database, that word will not be hyphenated in your document. This will 
especially affect the hyphenation points of such complex substantives as 
'news-paper. The database stores the syllables with interspersed digits which 
represent the possible hyphenation points. An odd digit means 'hyphenation 
allowed,' while an even digit indicates 'hyphenation not allowed.' These may 
be considered indicators of 'fracture' points. Digits of larger values 
indicate a low probability of a hyphenation point; low value digits indicate 
'weak' and thus an increased likelihood. The factor Minimal rating refers to 
these digits. A minimal rating of 1 can result in a larger number of 
hyphenations; values of 3 and 5 reduce the frequency of hyphenations, and 
produce only very good hyphenations. A lower frequency of hyphenations can 
increase the average width of spaces between words. A rating of 2 is not 
different from a value of 1.

Internal german hyphenation algorithm

In the German language, hyphenation is very important because of complex 
substantives. The internal german hyphenation function is based on a 
phonetic assessment of a word, rather than on a reference to a stored data 
base. It can thus hyphenate words which occur in text only very seldom; proper 
names fall into this category. It locates more possible hyphenations (nearly 
all in fact) than the German TeX database. In the case of a few hyphenations, 
the results of the algorithm are ambiguous. In these cases, there is a query 
option (Rckfrage) where the user is called upon to make a judgment. Many of 
these queries are humorous funny, because the wrong hyphenation alters the 
meaning. It is possible that WSformat takes note of these corrected 
hyphenations, and stores them in the files DEULERN.DTA and GRIELERN.DTA which 
resides in the current directory (normally the directory where WSformat.exe is 
located in). The additional 'Ancient Greek' algorithm is useful for scientific 
documents where many words are derived from the Greek roots. This particularly 
applies to syllables beginning with ps, pt, rh, sc and some others. In most 
German (commercial, correspondence...) these syllables occur very seldom, and 
the default setting is set to disabled.

The minimum of not separated chars settings refer to all hyphenation 
algorithms. It's a matter of document ('house') style whether a hyphenation 
will leave only two characters of the word on a line. Higher values will 
reduce the number of hyphenations; useful values are 2, 3 or 4.

Do not hyphenate areas with capital letters depends on your own style 
requirements. Sometimes there are abbreviations with capital letters which 
must not be hyphenated. If your text contains sections in capital letters, you 
should disable this function. The default setting is enabled.

A manual hyphenation setting is also available. When a word must be 
hyphenated, a simple YES-NO-CANCEL dialog box is presented to the user for his 
decision.

You can change the hyphenation default setting by using the .HY command, see 
chapter Select Hyphenation.

To indicate that no attempt should be made to hyphenate it, type a leading ^PG 
character in front of the word.

.3
Layout page

.ID P_LAYOUT
On the settings notebook page Layout, you can set the default values of many 
dot commands which refer to the default page layout.

The scale of all vertical values is the default typewriter line height 
(.LH8) ('lines') and of the horizontal values the width of a Courier 12 font 
character ('columns').

The dot commands also accept inch values (.PL 8.5") or cm values (.PL 
23.0). To distinguish the line/column scale from cm scale, the latter always 
requires a decimal point or comma.

On the settings notebook, only the column/inches values can be set, but if you 
move the mouse over the entry fields, you will activate a bubble help which 
shows you the value in inches or cm, depending on the scale for bubble help 
radiobuttons.

Page Template let you restore and save other dot command settings referring 
the page layout. To define a new value, select one of the "Template" items, 
edit the combobox and change the dot command values. The last template you 
have chosen is the template WSformat refers to.

Write default dot commands to FMT file is useful if you want to send a 
formatted file to another WSformat user. All your dot command default settings 
are automatically written at the beginning of the formatted file.

The ASCII codepage holds single line and double line images, e.g. single  
(Alt-196) and double  (Alt-205). WSformat does not send the ASCII code of 
these 'characters' to the printer; instead it generates graphics. The Line 
drawing settings refers to the width of lines in 1/300 inch pixels. Useful 
values are from 2 to 10. Instead of a double line, WSformat creates a wide 
line.

It is permissible to use these characters in situations other than in .LI 
line drawing tables. The length of these lines in relation to text set in 
proportional fonts depends on the '.TS' tab stretch value: The length of one 
line character corresponds to one soft space.

Codepage has two settings. There are two code pages which are very similar, 
both known as the 'IBM codepage' or the 'OEM codepage.' The difference is in 
the line drawing characters, which are made up of both small and wide lines. 
Code page 850 lacks these combined line drawing characters, but instead 
contains additional accented characters for various languages.

An important consideration in Europe is the addition of Euro-character  which 
is available only on the 850 Code page. If you have selected code page 437, it 
will be a line-drawing character instead of the Euro symbol.

.3
Notes page

.ID P_NOTES
WSformat handles endnotes, footnotes and margin notes.


Settings referring to Format function

Width of left margin for margin notes is the default value of the '.MN{}n' 
dot command, where 'n' represents the maximal length of margin notes in 
characters.

..Arndt wsfdocu3.ws
When bringing text and notes on a page together (Make - text and footnotes), 
it is necessary that each footnote link in the text area be indicated with a 
marker. This marker is the internal character for assigning footnotes and is 
simply a character which is not used anywhere else in your document. The 
default value is ^PQ (ASCII value of 17 decimal).

To enter Wordstar Printer chars ^PA...^PZ, type a ^ (circumflex) character 
and then a capital letter.

There are different ways of showing footnote links. Footnote link text in 
text area defines how the footnote link is to appear. Acceptable conventions 
for footnote links are (1), [1], and ^T1^T (superscript). Remember that you 
can define a superscript font, see chapter fonts.

Footnote link text in footnote area is the counterpart at the beginning of a 
footnote. Note the use of leading spaces to represent indention.

If you want to insert a Return inside your footnote text, you need a 
character for RETURN in footnote text which will later be converted to a 
Return. Normal Returns in footnote text are filtered.


Settings referring to 'Making Text and Footnotes'

Number of empty lines between text area and footnotes defines the distance 
between the text block and the footnote block of a single page.

The last setting hold number of lines in a paragraph together refers to the 
Make - Text and footnote task. When creating a text and footnote file (TAF 
file), WSformat has to generate the Page breaks on its own. If you select a 
value of 2, WSformat holds the first two and the last two lines of a paragraph 
together; using a value of 1 deactivates this function. Enabling this function 
(values 2 or 3) is strongly recommended.

.3
Index page

.ID P_INDEX
The index page stores those settings which refer to the Make - contents 
and the Make - index function of WSformat.

Concerning content creation

When creating a table of contents (TOC) files, you can select whether or not 
to write page numbers.

With Highlight main headings enabled, main headings get bold toggles. 
Anyway, WSformat writes an empty line above a main heading.

Concerning index creation

Highlight weighted page numbers generates bold face page numbers for 
weighted index entries.

Sortiere... refers to a German 'umlaut' problem.


.2
Preview Window

.ID P_PREVIEW
To have access to the preview feature, first format your text. Then press the 
preview button or select File - Preview. The preview window opens and the 
yellow LED in the WSformat main window glows.

The title bar of the preview window now displays the current page number and 
the filename.

When saving the FMT file in the editor, the preview window is updated 
automatically. Changing settings in the settings notebook will also 
automatically force a preview update.

In the preview window, use the Pg dn and Pg up keys of your keyboard or 
the left and right mouse button. The left mouse button shows the next page, 
the right mouse button the previous page. To go to page 20, for example, hold 
down the left mouse button and drag the mouse to the right. Until the end of 
the file is reached, WSformat does not know the page length. On reaching the 
end, the number of pages is shown in the titlebar: '7 of 17' (pages).

Change the window with and height. The preview scale depends on the window 
width. If you make the window width large, a vertical scrollbar appears.

If you have a slow computer and a large document, previewing backwards 
requires some considerable time because WSformat must read the document again 
from the beginning. (Perhaps that will improve in a later version.)

.2
Print pages dialog

.ID P_PRINTPAGES
To print a document from the first to the last page, select a printer in the 
main window dropdown box and press the Print button.

To print selected pages of a document, click on File - print pages. This 
brings up a small dialog window. If you press OK without entering values for 
the first and last pages, the whole document will be printed.

You are allowed to enter several page numbers in the entry field, separating 
them by commas or spaces. To print several pages, enter the first and the last 
page numbers, separating them with a hyphen.

If you want to print from a specific page to the end of the document, select a 
number for the last page which exceeds the size of the document, e.g. 
18-999.

Enabling the Exclude pages checkbox means all pages will be printed, but now 
the pages shown in the entry field are instead omitted.

You can select the Number of copies which you want printed. The document is 
printed once from the first to the last page, and then the document is printed 
a second time from the beginning. That means the page order is in collated 
sequence, such as 1, 2, 3, 1, 2, 3, etc., and not as 1, 1, 2, 2, 3, 3.

Press OK to start printing and Cancel if you decide to terminate the 
job.

.2
Command line Arguments

.in Command line argument
The current WSformat program allows only one file name to be entered as an 
argument on the command line. Any additional arguments are ignored. If the 
filename contains spaces, type 'file name' or "file name". Do not omit the 
file extension.

I am planning to include support for full format and print control using 
command line arguments in a later version.

.dp#-
.1
Fonts

Using fonts with WSformat is very different from Wordstar, but similar to 
Hypermake. Fonts are selected by using specific dot commands.

In WSformat and Hypermake, fonts are represented by a font letter which is 
a shortcut for a specific font description. Font letters are case-sensitive, 
so you can use A to Z and a to z for a total of 52 letters.

.2
Storing font data

.in Fonts.ini
.in Printername.dta
The information about fonts is stored in two files: Fonts.ini and 
Printername.dta. Both files are located in the directory where WSformat.exe 
resides.

Fonts.ini is a text file which can be edited with any reliable ASCII editor, 
with WSedit, or by selecting Settings - Font definition in the WSformat main 
window.

Printername.dta is a binary file which stores the same information which is 
held in the Fonts.ini file. It stores additional information about the 
selected fonts, especially the pixel width of all characters. Because the font 
metrics slightly differ from printer to printer, every printer installed on 
your system gets such a file, e.g. 'HP Deskjet 600.dta'. After changing 
Fonts.ini, the Printername.dta file is updated automatically before processing 
the next format, preview or print job. When formatting or printing, WSFormat 
gets the information from this file and not from the operating system. This 
makes formatting and printing faster.

In the current WSformat version, formatting problems occur when these font 
data are involved. (I hope to correct these problems in future versions.) In 
this case, deleting the Printername.dta file forces recalculating all font 
data and the elimination of the problems.

.2
WSformat default fonts

.in Fonts.ini
Starting WSformat the first time causes a new Fonts.ini file to be 
generated. WSformat asks the operating system for the names of registered 
Times Roman, Helvetica and Courier fonts. Depending on this computer-specific 
query, WSformat generates a new Fonts.ini file. Please take a look at your 
Fonts.ini.

On many systems, the following fonts are listed:

.sfM
Font A = Times New Roman 8
Font B = Times New Roman 10
Font C = Times New Roman 12
Font D = Times New Roman 14
Font E = Helvetica 8
Font F = Helvetica 10
Font G = Helvetica 12
Font H = Helvetica 14
Font I = Helvetica 16
Font J = Helvetica 18
Font K = Courier New 8
Font L = Courier New 10
Font M = Courier New 12
.sf

The font letters from A to M are allocated in every WSformat installation. 
Use these fonts if you want to write a document to be sent to another WSformat 
user. This font selection covers all normal word processing purposes.

If you miss some fonts, enter your own definitions, using the font letters N 
to Z and a to z.

.2
Basic font selection in document

.in font selection
.it normal font
For selecting a font in your document, simply use the dot command

.SF (select font),

followed by the font letter. E.g.

.SFC

This selects the font 'Times New Roman 12,' because it is defined in the 
Fonts.ini file as:

.sfM
Font C = Times New Roman 12
.sf

Typing .SF without a parameter selects the default font which is set in 
the settings notebook, page format.


Alternate Font

.it alternate font
You can also define an alternate font

.AF (alternate font)

which is printed when a ^PA character appears at the beginning of a paragraph. 
The syntax is similar to the .SF font:

.AFC  (selects alternate font C)
.AF   (selects default alternate font).

Behind the ^PA printer character, the alternate font rests activated until the 
paragraphs ends with a Hard Return.

Subscript/Superscript font

It is useful to select a smaller font for subscript (^PV in pairs) and 
superscript (^PT in pairs) text:

.SSB
select subscript/superscript font selects e.g. font B (Times Roman 10). The 
default setting is the default font in the settings notebook, page 
format.

.2
Extended Fonts.ini functionality

.it extended font
If you are more ambitious in your treatment of fonts, you can define manually 
bold, italic and bold-italic fonts.

The default behaviour of WSformat is that you simply define a font by using 
.SF. When you then use the ^PB (bold) and ^PY (italic) toggles, you will get 
the same font in bold or italic styles respectively. You have the option to 
redefine the bold, italic and bold-italic fonts manually.

When interpreting a 'Font' line in the Fonts.ini file, not only is a single 
font defined, but the italic, bold and bold-italic fonts along with it:

.sfM
Font C = Times New Roman 12
Font C" = Times New Roman 12 bold
Font C' = Times New Roman 12 italic
Font C& = Times New Roman 12 bold italic
.sf

This default behavior can be turned off selectively by entering:

.sfM
AutoItalicBold = no
.sf

and can be turned on

.sfM
AutoItalicBold = yes
.sf

You can now define the bold, italic and bold-italic fonts by hand, or you can 
override these settings. Because the Fonts.ini file is interpreted 
sequentially, it is possible to repeat a font definition without turning off 
the 'AutoItalicBold' setting.

.sfM
Font C = Times New Roman 12
Font C" = Times New Roman 13 bold
.sf

That means italic and bold-italic of the C type face are defined 
conventionally, but the bold font is a slightly larger font (13 instead of 
12).

.2
Extended font selection in document

The .SF command changes the previously selected fonts for normal, bold, 
italic and italic-bold styles simultaneously. If you want to change a font 
attribute selectively, there are specific dot commands which can be used, such 
as the .SF command:

.SN   (select normal)
.SB   (select bold)
.SY   (select italic)
.SX   (select bold-italic)

.1
Basic text commands

'Basic text commands' refers to the formatting and printing commands - dot 
commands, printer (^P) characters - which are similar to Wordstar DOS. The 
next chapter 'Extended text commands' refers to advanced features such as 
graphics, footnotes or contents which are implemented in a WSformat specific 
way.

The majority of WSformat text commands are identical to those in Wordstar DOS, 
but a few are new or different from Wordstar DOS. They are marked with the 
following sign:


 Wordstar DOS user, please note!

Most word processing programs save formatting and printing information in a 
binary format. Wordstar DOS and WSformat store this information as readable 
text characters. There are two kinds of these commands:

 dot commands: A text line beginning with a dot (period), followed by two 
characters. Dot commands are not case-sensitive.

 printer chars: Characters with an ASCII value lower than decimal 32. In 
Wordstar DOS and WSedit such characters are entered by type Ctrl-P, followed 
by a letter.

.2
Syntax of dot commands

.in dot command
A dot command must be typed on a separate line and begin with a dot in the 
leftmost margin. If the dot is not located at the first column, it will not 
treated as a dot command and will instead be be printed as text. In most 
cases, the dot is followed by two characters which are not case-sensitive. 
Many dot commands require a following argument. For example:

.RM70

sets the right margin to the value 70. You are allowed to enter spaces between 
'RM' and the number.

In this documentation, I need to print dot commands without having them 
interpreted. The first character in a line is the bold toggle and the second 
the dot, thus isolating the latter from the right margin. A line so 
constructed will thus show the dot in the left margin, as the first character 
when it is printed, and it won't be interpreted.

In Wordstar, the default horizontal page measurement is characters and the 
default vertical measurement is lines. Both directions refer to old 
typewriter conventions. A character is considered to be as wide as a 'Courier 
12' character - the only font with which most typewriters were provided - and 
the line measurement is the default (narrow-spaced) line. WSformat assumes 
1/48' to be the unit of vertical pitch, so .LH8 indicates a line spacing of 
8/48' or 6 lines per inch).

All dot commands which allow character or line counts to indicate distances 
will also accept inches and cm values:

.RM 7.0"
.RM 17.8


 Note that the use of dot (decimal point) or " makes the difference: If 
the number contains a dot or a comma, it is treated as a measurement in 
centimeters or inches. The inch value is marked by the " character.

Comments

.in comments
A very useful dot command is 'dot dot'

..This won't be printed

This allows you easily to enter text which won't be printed in the finished 
document. In WSedit, these lines are shown on the editing screen in magenta.

.2
Printer command characters

.in Printer character
.in Printer char
In WSformat and Wordstar DOS, characters with an ASCII value lower than 
decimal 32 have got a specific meaning. These characters are not printed, but 
instead control the formatting and printing of the job.
In both Wordstar DOS and WSedit, you can enter a command to be sent to the 
printer by typing Ctrl-P (P for 'printer'), followed by a letter from A to Z. 
In the documentation, these commands are written ^PA... ^PZ.

printer chars not used in pairs

.tb6
^P@(Wordstar DOS) Text followed by this character is right-justified 
when printing
^PZ(WSedit) Text followed by this character is right-justified when 
printing
^PKText followed by this character is centered when printing

^PATurn on the alternate font until the next Hard Return
^PGThe following word is not hyphenated
^PObinding space: a line will not be divided a binding space

printer chars used in pairs (toggles)

.it printer char bold
.it printer char italic
.it printer char superscript
.it printer char subscript
^PBselect the bold font
^PS select underlined text
^PYselect the italic font

^PTSuperscript, e.g. square meter m2
^PVSubscript, e.g. CO2 will be polluted
.SSA
.cp2

 WSedit shows the ^PT 2 ^PT sequence simply as 2 which is part of the IBM 
Codepage, and ^PT 3 ^PT as 3. You can set the height and depth of the printout 
with the .SR command (default is .SR3) and the superscript/subscript font 
with the .SS command (select sub/superscript font), followed by a font 
letter.

.2
Text formatting commands

.3
Indentions

Hard and Soft Spaces, indentions

.in indention
.in Soft space
Wordstar DOS, WSedit and WSformat know two different kinds of Spaces: Soft 
spaces (in WSedit shown as 'snow characters') and normal 'hard' spaces. Soft 
spaces represent indentions and tabulations. While formatting, these soft 
spaces can vanish and then appear on another place.

.tb4
This is a sample showing soft spaces. To indent a line in WSedit, simply 
use the Tabulation (Tab) key, or press Ctrl-OG.
It is also possible first to enter text and then to indent by typing the 
Tab key, followed by the running text.
.tb10
.if WSformat
I have now selected Tabstop 10. This is a sample of the use of soft 
spaces. To indent a line in WSedit, simply use the Tab key, or press 
Ctrl-OG.
Note:It is possible to begin a line with non-indented text (in this case 
the word 'Note:'), and then to indent text by typing soft spaces.
.end WSformat

To reformat a paragraph in WSedit after changing the '.TB' tab stop position, 
type Ctrl-B. WSformat interprets the resulting soft spaces, not the '.TB' 
command.


The width of soft spaces (snow characters) can be defined with the .TS tab 
stretch command.

.TS60 (also .DE60 or .DE6)
sets the width of a soft space to 60% of the capital W of the current 
proportional font. When using a fixed font, this setting has no effect.

.3
Hard and Soft Returns

.it Soft Return
.it Hard Return
There are also two different kinds of Returns: lines can end with either a 
Soft or a Hard Return. In WSedit, this is shown by color patches in the 
rightmost column. Soft Returns vanish and appear on another place while 
formatting. Hard Returns remain fixed at the same place. Soft Returns are 
generated by the computer; Hard Returns by typing the Enter key on the 
keyboard.

.3
Turning formatting off and on

When typing tables, there is always the concern about destroying table 
formatting, because WSformat might treat the table as running text and reormat 
it. WSformat attempts to recognize the difference between tables or columns 
automatically, if more than 4 normal spaces occur, but sometimes this rule 
fails. In such instances, it is safer to turn off formatting explicitly:

.FM OFF Formatting disabled (also .BA, .AW OFF)
.FM ON Formatting enabled (also .BE, .AW ON)

Typing ^B in the WSedit editor will not have an effect after typing FM OFF 
or BA.

If you type .BA TOTAL at the beginning of a Wordstar document, neither 
WSedit nor WSformat will do any formatting whatever.

.3
Change the hyphenation algorithm

.in hyphenation
You have access to the hyphenation algorithm choice within your document like 
you have on the hyphenation page of your settings notebook. This is useful 
when editing multilingual documents.

.HY OFF
or
.HY NO
hyphenation off turns hyphenation of words off.

.HY ON
turns hyphenation on again and activates the algorithm which was valid before 
turning off hyphenation.

.HY GERMAN
turns the internal german hyphenation on, using the checkbox values of the 
settings notebook.

.HY TEX
turns the external tex hyphenation on, with the tex hyphenation file which was 
last selected.

.HY Languagename.TEX
turns the external tex hyphenation on and makes the tex file Languagename.tex 
current

.HY MANUAL
or
.HY HAND
queries all possible hyphenations. A simple YES-NO-CANCEL dialog box is 
presented to the user for his decision.

.3
Line Height, superscript roll

.in Line Height
.in superscript roll
.LH8
line height sets the line height to 8/48 inches. This is the default 
linespacing of a conventional typewriter. .LH12 means 150% of the default 
typewriter linespacing. .LH10. is a good choice for Times Roman 12 or 
Helvetica 12.

In the settings notebook on the format page, you will find the checkbox
all .LH Line Height values refer to default normal font

This has got two effects:
.tb4
all .LH commands gets changed in the FMT file, if you don't use the size of 
the default font, e.g. '12' for 'Times Roman 12'.
after selecting a new font with .SF, the line height is recalculated and 
in the FMT file, WSformat generates a new .LH entry behind the .SF 
command.

This setting omits that lines with large fonts are overprinted, but old 
Wordstar DOS user could get confused. The default setting is enabled.


.SR3
superscript/subscript roll defines the height of superscript text (using ^PT 
in pairs) or the depth of subscript text (^PV in pairs). The default value is 
3.

.3
Paragraph Width

.in Right Margin
.in Paragraph Width
.RM40
sets the width of the text block (right margin) to 40 (the measurement is in 
Courier 12 characters). The WSformat default value is 60 and can be modified 
in Settings - Settings notebook, page Page. The value does not correspond 
to the width of the right paper margin; you enter instead the width of your 
text (paragraph width).

.PO8
page offset is the left paper margin. This command affects only previewing 
and printing, but not formatting.

The width of a default sheet of paper is 83 characters. If your .PO page 
offset is 8 and the text block width (.RM 'right margin') is 60, then 83 - 
8 - 60 = 15 characters are left for the right paper margin.

.3
Paragraph orientation

.it Paragraph orientation
.in centered
Output centered

To center text, instead of typing ^PK in front of each line you can also use 
the appropriate dot commands:

.OC ON
.OC OFF

The default value is OFF.

.it Micro justification
Micro justification

You can also select whether text is to be set ragged right or justified:

.BL ON
Block on turns justification on (fixed right margin) using 'micro 
justification'
.BL OFF
Block off turns justification off (ragged right margin). ('Micro 
justification' is off.)

If the text is to be right justified (right margin is fixed - .BL ON), 
WSformat distributes the empty space remaining at the end of the line equally 
between all words. If the Printername.dta file which holds the character 
width of all characters and fonts which are used by the document is corrupted, 
micro justification will fail and the printed result will be unusable. In this 
case, delete the Printername.dta file; it will be re-created 
automatically.

By default, paragraphs are printed with fixed left and right margins (FMT 
formatted files), or with a fixed left and a ragged right margin (WS 
unformatted files).

The Wordstar commands .UJ and .OJ are also interpreted. However, you won't 
see justification in the editor. .FL (German 'flatter' = bouncing) and 
simply .BL (block) without parameters is also interpreted.


 Do not format double- and triple-spaced text (Wordstar .OJ ON). Only 
paragraphs of single-spaced text can be formatted.

.3
Auto indention

.it Auto Indention
.LM and .PM refer to the formatting process of WSformat. If you want to 
indent your text in a uniform way without reformatting in the editor by using 
'.TB' and Ctrl-B, you can use these two dot commands:

.LM6
left margin causes the text to begin in column 6; columns 1 through 5 will 
be occupied by soft spaces.

.PM8
paragraph margin is like the .LM command, but affects only the first line 
of each paragraph. In this case, the first line will be further indented.

To turn off automatic indention, set the default values .LM0 and .PM0.

.2
Page formatting commands

.3
New Page

.it New Page
.PA
forces the following text to the beginning a new page.

.CP10
conditional page keeps the following 10 lines together. If there is 
insufficient space on the page, a page break will be inserted at the location 
of the .CP command.

.3
Page margins

The following page margin commands are available. A table showing these dot 
commands with their default values is available on WSformat Settings - 
Settings notebook, page page.

.PL page length
.MT margin top
.MB margin bottom
.PO page offset (=left paper margin)
.RM right margin (=paragraph width)

and, to define the separations between header/footer lines and text:

.FM foot margin
.HM head margin.

The european A4 page size is 8.25" x 11.666" and the US Letter standard is 
8.5" x 11". So .PL66 is the length of a US Letter page, while .PL70 is 
the length of an european A4 page. See page templates on settings 
notebook, page Layout.

.3
Header and Footer Lines, Page Numbering

.in Header line
.in Footer line
To get a header line which repeats on each subsequent page, enter (for 
example) :

.HE My document, 1st Edition

You can place similar text at the bottom of the page (footer line):

.FO My document, 1st Edition


 You may then designate a font by combining the .HE Header and .SF Select 
Font commands:

.sfE
.HE My document, 1st Edition

or

.HEsfE My document, 1st Edition

which has no effect on the font selection of lines which follow.

To center a header or footer line, use the printer command character ^PK. To 
justify text right, use the WSedit ^PZ command (equivalent to Wordstar ^P@).

It is possible to define up to five Header or Footer lines:

.cp15
top of page
.H1
.H2
.H3
.H4
.H5 = .HE

... This is the text area ...

.F1 = .FO
.F2
.F3
.F4
.F5
end of page

Note that these lines can appear only if the .MT and .MB values (margin 
top and margin bottom) have been assigned values which are high enough to 
allocate the necessary space. Use Preview to test whether or not the header 
and footer lines appear.


 You can set the vertical pitch (line spacing) of the header and footer 
lines, comparable to the .LH dot command.

.HH Header Height
.FH Footer Height

The default value of these commands is 8 (= default Typewriter linespacing of 
6 lines per inch).

Page numbering

By default the page number in the footer line is centered:

.FO ^PK #

# will be replaced by the current page number when the document is printed.

You can change this default setting by entering your own footer and header 
commands.

.OP
To turn off printing of page numbers, use omit pages. This command let the 
footer line get void.
.PG (or .PN)
turns printing page numbers on again.

.PC30
page column prints the page number at column 30 and is retained for Wordstar 
compatibility, but will often produce unpredictable results when proportional 
fonts are used.

.PN15
page number immediately advances the page counter to the value of 15. This 
is no good practice, because it may result in the same page number occuring 
twice in the same document.

.3
Odd and even pages

.it Odd and even pages

 By default, the page number value has no effect to WSformat printing. If you 
want to write a book, the left page is always even (2, 4, 6), and the right 
page is odd (1, 3, 5). (If you don't believe it, take any book from your 
bookcase and make a spot check!)

.LR
Left-right causes WSformat to print all header/footer lines of left (even 
numbered) pages left-justified and all header/footer lines of right (odd 
numbered) pages right-justified.

You can treat right and left headers or footers separately:

.HER My Header text on the right side
.HEL My Header text on the left side

This can be also combined with the footers and with several header/footer 
lines:

.H4R My header text on the right side, line 1
.H5R My header text on the right side, line 2
.F1R My footer text on the right side, line 1
.F2RsfE My footer text on the right side, line 2, Font E

and so on.

.3
Paper orientation

.LA (also '.PR or=l')

.in Paper orientation
.in Landscape
.in Portrait
turns the printer orientation to landscape; the paper width is set larger 
than the paper height. The default setting is portrait. The dot commands 
referring to the page format do not change automatically. You have to select 
the suitable page template on the Layout page of the settings notebook 
before formatting. The .LA command only refers to printing.

.if os2
WSformat for OS/2 does not support changing the paper orientation. Instead, a 
message info box appears while printing. You have to use the settings notebook 
of the printer object instead.
.end

.2
Embedding files

.it Embedding files
Embedding files

.FI Filename
File is a very powerful command. The contents of the file Filename are 
inserted at the position where the .FI command is located. This command is 
interpreted while formatting but not while printing.

The file extension makes a great difference.

.FI Filename.ws
.FI Filename.fmt

If the file extension is WS, WSformat interprets the file as an unformatted 
file and while formatting, full dot command interpretation and formatting are 
used. If the file extension is not WS, the contents of the file are simply 
copied to the formatted file.

Save and Remember current formatting values

.in save values
.in remember values
When using the .FI embed file command, it can be useful to save and 
remember current values of dot command settings.

.S:FONTS
.R:FONTS
saves and remembers all current font data (normal, alternate, bold, 
italic, bold-italic).

.S:LINEHEIGHT
.R:LINEHEIGHT
saves and remembers the current state of the .LH command.

.1
Extended text commands

The extended text commands provide extended word processing facilities; these 
are implemented in a WSformat specific way. For Wordstar DOS users, the 
information in this chapter will be completely new.

.2
Embedding graphics

.in Graphic
.in Bitmap
.in GIF
.in JPEG
A provision for embedding graphics was lacking in Wordstar DOS. In a graphical 
environment, it is no longer difficult to handle graphics; their support in 
WSformat is fully compatible with Hypermake syntax.

The graphics commands only support Windows Bitmap (BMP) files. GIF and JPEG 
support is planned for a future version.

WSformat offers two simple ways of embedding graphics.

To embed a graphic in your document, simply enter

.BM Filename.bmp

The files are searched in all directories which are listed on the Program 
page of Settings - Settings notebook.

The .BM command is interpreted both while formatting and while printing. 
While formatting, WSformat calculates the width and height of your graphic. 
The default behavior of WSformat is that the graphics file is stretched 
horizontally and vertically until the width matches the paragraph width 
(depending on the .RM command). The height of the graphic is calculated and 
WSformat enters empty lines into the FMT file:

.cp13

(running text above the graphic)
.CP7






.BM Filename.bmp
(running text below the graphic)


When previewing or printing, the graphics file is shown.

If you want the width of the graphics width to be different from the paragraph 
width, you can modify the size of the graphic by entering

.BW 80

bitmap width before typing the .BM command. A value of 80 means that the 
width is 80% of the paragraph width. The graphic will be printed centered, 
with a margin of 10% on the left and 10% on the right side. The default value 
of .BW is 100. This command also influences formatting. The smaller this 
value, the fewer empty lines WSformat will insert.


Bitmap text

The .BM command is not appropriate if you want to embed a graphic in running 
text. Instead, use:

.BTX Filename.bmp

X represents a bitmap character, an arbitrary character which will not 
otherwise appear in the text. This character will be replaced in your text by 
the bitmap 'filename.' Note that bitmaps can be higher than characters, so you 
should select one that will not cause overprinting of characters on the line 
above. Block chars like  (Alt-219),  (Alt-220),  (Alt-223) are useful 
bitmap chars (DOS/IBM codepage).

Text Bitmaps are already interpretated while formatting. WSformat treats such 
bitmaps as characters and calculates the width of the bitmap to let the right 
margin justified.

The scale of the .BT graphics is 300 bits per inch, which means that a 
graphics file with a 300 pixel width gets a 1 inch (2,54 cm) width on your 
printout. You can change this value by entering:

.GS
graphics scale. Place this command above your .BT command.

You are allowed to define up to 20 bitmap chars simultaneously.

To deactivate a character-bitmap definition, enter:

.BTX

without specifying a filename. The actual character will then be printed, 
rather than the bitmap.

.2
Line drawing

.in line characters
.in line drawing
The IBM codepage contains some characters which represent lines instead of 
letters. You can use combinations of these characters to draw boxes.

WSformat does not send line characters to the printer directly. Instead, it 
sends bitmap images of the characters to be printed. The main reason for doing 
this are that line drawing characters must be printed only at the default line 
height .LH8. To draw an unbroken vertical line, line drawing characters are 
converted to commands like 'draw a line from coordinate X to coordinate Y.'

You are encouraged to use these line drawing characters in running text  e.g. 
as a dash (Alt-196, narrow lines) 
.tb4
or for lists (Alt-205, wide lines).

Characters which represent double lines are shown as wide lines in preview and 
on printout. You can set the width of the narrow and wide lines in the 
settings notebook, page Layout.

Block characters  (Alt-219),  (Alt-220),  (Alt-223) and - only 437 codepage 
- Alt-221 and Alt-222 are also sent as bitmap graphics. Here as an example is 
a large exclamation mark

 which is made by using such block characters.


Creating Boxes

As creating boxes is usually a tedious job, a dot command has been defined to 
facilitate line drawing. The following example illustrates its use.

.sfM
.cp12
 .LIXY

      X                           X

            Operating systems

      Y                 Y                X            X
            Novell         IBM              Hardware
      Y       Y                          X            X
          DOS   Netware    OS/2
      X                           X
 .LI
.sf

The result will be: (view FMT file or make preview)

.LIXY
.cp12

      X                           X

            Operating systems

      Y                 Y                X            X
             Novell        IBM              Hardware
      Y       Y                          X            X
         DOS    Netware    OS/2
      X                           X
.LI

.afB
In the dot command .LIXYZ, X represents an arbitrary character marking the 
corners of the box, Y a partition of the box. Z, placed in front of X or Y, 
generates double lines (wide lines). A combination of single and double lines 
requires the Codepage 437 selection (Page Layout in the settings 
notebook).

The Z char in the .LIXYZ command for producing double lines has to be a 
^P-character like ^PE or ^PR. When using the ^OD toggle in Wordstar DOS, you 
can make the ^P-characters invisible to check the correct orientation of the 
box. (In WSedit 0.9, this functionality is missing yet, so after entering a ^P 
character, the X chars are no more in the same column.)

WSformat supports proportional fonts in line drawings. The .TS tab stretch 
command is very important in this case. You can specify the width of your 
boxes with the .TS command. If this produces overlapping columns, enlarge 
the .TS command value (default is 60).

.WA hori 30
.2
Chapters, headings, table of contents

.in heading
..in contents
.in chapters
.it table of contents
WSedit, WSformat and Hypermake provide easy-to-use support for headings and 
tables of contents.

.3
Heading commands in your source text

You can arrange your text with heading levels, as you would in a technical 
document:

first heading
    first sub-heading
    second sub-heading
         first sub-sub-heading
         second sub-sub-heading
    third sub-heading
second heading

In the WSedit/WSformat/Hypermake format, the headings are designated in the 
following manner:

.sfM
 .1
 first heading

 .2
 first sub-heading

 .2
 second sub-heading

 .3
 first sub sub-heading

 .3
 second sub sub-heading

 .2
 third sub-heading

 .1
 second heading
.sf

On the line immediately following the dot command for the heading level, you 
enter the heading text. Heading text can be longer than one line, but must not 
extend beyond a single paragraph: a Hard Return marks the end of the 
heading.

In your printout, your document is structured like this:

1. first heading
     1.1 first sub heading
     1.2 second sub heading
          1.2.1 first sub sub heading
          1.2.2 second sub sub heading
     1.3 third sub heading
2. second heading

WSformat handles up to 9 heading levels, but Hypermake is limited to only 6 
heading levels. WSformat also supports other conventions for enumerations 
(letters, roman numerals, as well as others).

.3
Headings and WSedit

WSedit provides support for headings and tables of contents, expressed in 
WSformat / Hypermake syntax.

First, headings are highlighted in green, if the heading checkbox is checked 
on the Highlt page of the WSedit settings notebook (press ^OO).

Second, to help navigating in your unformatted text, WSedit has a contents 
window. ^OC opens the contents window. ^OI also opens the contents window and 
then jumps to the chapter where the text cursor is currently located. 

.3
Formatting a text with headings

When formatting a source text which contains heading commands, these commands 
are converted to commands for font selection, line spacing and page breaks. 
Previewing and printing the file will display headings in their final correct 
form.

The way these dot commands are to be converted to other commands is defined in 
the headings template file. This file can be viewed by selecting settings - 
headings template in the WSformat main window. This shows the file 
HEADINGS.WS which is located in the directory where WSformat.exe resides. The 
file is self-explanatory. Instead of the word 'heading,' WSformat subsitutes 
the heading text you have specified.

You are at liberty to modify this file. If you want to use other heading 
files, first make a copy of HEADINGS.WS and then modify the copy. Simply place 
your HEADINGS.WS file in the directory where your document files are located, 
or substitute another filename, e.g. MYHEADING.WS, and then include the dot 
command

.HF MyHeading.ws

heading file before entering the first .1 command.

.P# 3.2.5
sets the current content numbering. You have to enter decimal notation here. 
Use e.g. .P#5 at the beginning if you have got a separate document 
containing chapter 5 and 6.

.3
Non-decimal classification

Some people prefer other ways of enumerating headings. Today, although decimal 
classification is a standard, WSformat also supports other forms of 
enumerations:

1.1 Decimal classification without last dot
1.1. Decimal classification with last dot

I. Roman nnumerals (up to 38 = XXXVIII)
A. Capital letters
1. Customary (arabic) numerals
a. lowercase letters
aa. double lowercase letters
[alpha character]. Ancient greek characters (bu only those in codepage 437, 
Alpha = Alt-224, etc.)

Instead of typing a dot behind the character, a right parenthesis ')'--is also 
possible, thus: 1)

In the headings template file, you can define any or all of these styles of 
enumeration.

.3
Writing out a table of contents file from your formatted file

After finishing your FMT formatted file and fixing all page breaks, WSformat 
helps you prepare a properly numbered table of contents.

In the unformatted file enter, for example, something like:

.sfM
 .PA
 Contents of this document

 .ci7
 .. (later, place the table of contents file here)
 .PA
 .PA
.sf

There are two aspects to consider:

.in Contents Indention
.CI
contents indention sets the tab stops while formatting the table of contents 
file, comparable to the Wordstar/WSedit .TB command. The value has to be the 
maximum number of characters of your deepest heading enumeration plus 2. 
E. g. if you have selected decimal classification and use headings up to level 
3, the width of the heading enumeration does not exceed 5: 

.sfM
123456789
1.1.1 TextTextText
.sf

In this case, a .CI value of 7 or more fits your purpose.

The other aspect to consider is how many pages the table of contents will 
occupy. Because the table is printed before the running text begins, the 
length of the table influences the page numbering of your document. You will 
therefore have to estimate the length of the table (in pages) and then enter 
several .PA page break commands, so the first page of your running text 
will get the final page number after inserting the contents. If your first 
trial fails, edit the FMT file and enlarge or reduce the number of .PA 
commands. Please remember that you have to enter at least one empty line 
between two .PA commands.

After inserting the .CI command and .PA page breaks as described above, do 
the following to embed a table of contents file in your formatted file:

Select Make - Content in the WSformat main window. The extension of the 
contents file is TOC.
Now open the formatted file which has remained unchanged while executing 
Make - Content.
Remember the page number of the first page of your running text.
Delete the .PA commands you have inserted previously.
Copy the contents of the TOC file to the location you previously 
allocated.
Locate the first page of your running text again and see what page number 
WSformat has assigned to it. If the number has changed, leave the formatted 
file without saving any changes, re-open it, delete or insert a .PA 
command, and repeat the procedure.

From a technical point of view, the Make - Content function operates 
independently of the headings function, explained above. It does only 
interpret formatted files which no longer contain any heading commands. So you 
can also use Make - Content if you have entered your headings manually. 
WSformat takes a careful look to the beginning of each paragraph of your 
formatted file and decides whether or not to copy this file into the table of 
contents file. If there is any uncertainty, the line is nevertheless copied to 
the table of contents file. It is always advisable to take a close look at the 
table of contents file and delete any lines which are not headings.

The criteria are: after reading spaces and printer characters at the beginning 
of a paragraph, the first acceptable characters have to be 
one or two normal (arabic) digits or latin numberals up to XXXVIII, 
followed by a dot or a close-parenthesis ')'
one or two upper- or lower-case letters, followed by a close-parenthesis 
')'
a single captial letter, followed by a dot.

.tb30
Unrecognized Recognized
123. 12.
345) 34)
7  7.
IL. XXXVIII.
IV  IV)
B   B.
ab. ab)
aac) ac)
.tb4

Because a TAF file (text and footnotes) will usually contain many paragraphs 
beginning with a number followed by ')' - the footnote paragraphs - all 
lines in TAF files with a number and ')' are not copied to the Table of 
Contents file.

In the settings notebook, page index, you can specify whether to write 
page numbers or not, and whether or not to highlight main headings in 
boldface. In any case, an empty line is inserted before writing a main 
heading. The first heading type which occurs in the formatted file will be 
considered the 'main heading.' This can differ from the .1 command in the 
unformatted file.

.WA hori 30
.2
Footnotes, End Notes, Margin Notes

.in footnote
.in end note
.in margin note
WSformat supports footnotes in an easy and uncomplicated way.

If you prepare a file using Wordstar DOS 5-7, load such a file with footnotes 
or end notes into WSedit, and then save the file, these notes are converted to 
WSformat and Hypermake format.

Because WSedit and WSformat does not support multi-column text, there is a 
special implementation for creating margin notes. Margin notes are very 
short text (e.g. 3 or 5 characters long) which appear in the left margin 
area.

.3
Writing footnotes or end notes in your unformatted file

.in Footnote
.it footnote character
Generating Footnotes or end notes with Hypermake is very simple. For example, 
footnote text can be quoted in brackets like [This will be the content of the 
footnote] after entering the dot command footnote usage:

.sfM
 .FU[]
.sf

Other useful footnote bracket pairs are { }, < > or  (Alt-220)  (Alt-223). 


In WSedit, you can highlight these specific characters (^OO settings notebook, 
hightlt page, entryfield spec. chars).

You can add a font selection to the footnote dot command:

.sfM
 .FU[]sfB
.sf

This will select font B for your footnotes or end notes.

To select a line height for your footnotes or end notes, add LH followed by 
your preferred value:

.sfM
 .FU[]sfXlh7
.sf

The order of SF and LH makes no difference.

While formatting, WSformat creates

 an FMT file where the notes text has disappeared and instead a footnote link 
appears
 an FUN file (.FU Notes file) which contains the text for all notes.

You can modify the appearance of your footnote links in the settings 
notebook, page notes.

.3
Handling end notes

To embed the .FU notes file at the end of your document, you can manually 
copy the FUN file to the end of the FMT file, or you leave this job to 
WSformat:

.FI *.FUN

Place this command exactly as it appears above (type the '*' sign, not the 
filename) at the end of your unformatted file. This will cause the 
contents of the FUN file to appear in the FMT file. You cannot enter 
additional notes text in your running text after typing this .FI command.

.3
Getting real footnotes

Up to yet, you have only a separate file containing the text of your 
footnotes.

Make - Text and Footnote merges an FMT (formatted text) with an FUN file 
(notes text) file. The result is a TAF file which combines Text and 
Footnotes.

When merging text and footnotes together, WSformat has to make page breaks by 
itself. There is no way anymore to optimize the page break by hand in the 
formatted file.

In the notes page of the settings notebook, you can define that e.g. the 2 
first and the 2 last lines of a paragraph are always hold together. This omits 
a result where the first or the last line of a paragraphs rests alone on a 
page.

However, this function is not adequate to produce proper page breaks. You 
frequently have to use the .PA page break and especially .CP 
conditional page break. All tables, enumerations and so on have to be 
prefixed by .CP commands to omit page breaks. The more .CP commands you 
use in your unformatted file, the fewer formatting runs you need to produce a 
satisfactory final TAF file.

WSformat inserts the page breaks in the TAF file one line ahead of where they 
are necessary. You are therefore both permitted and encouraged to make minor 
changes in your TAF file by moving the last line on a page of your running 
text (Wordstar DOS and WSedit ^Y and ^U) to the beginning of the next page, or 
to do the converse.

.3
Margin Notes

Margin notes are short notes which occur in the indented left margin of the 
formatted file. When insertion of margin notes is activated, all formatted 
text will be indented. The usage is similar to the footnote / end note command 
of WSformat.

Instead of .FU, you enter .MN margin notes (or .BV German 
"Blattverweise").

.MN<>3
Here is an example of a margin note, as it would occur in the indented left 
margin of your text. To insert such a note, you would mark<007> this line.

To see what the result would be, take a look at the FMT file!

.MN<>3
This is a sample for a margin note. Margin notes occur in the left indention 
area of your text. Now I mark<007> this line.
.MN

The characters < and > bracket the text of a margin note. '5' sets the 
maximum length of margin notes (in number of characters) to 3. That means 
that the space allocated for the margin is sufficient to accommodate when 
printing margin notes with a length of 3 characters: the first character of 
the paragraph appears in column 5, and the number of soft spaces which are 
inserted is 4.

In the settings notebook, page Notes you can set a default value for the 
length of margin notes. A numeric value in the .MN command overrides this 
default value.

When using margin notes, the paragraph width is increased, while the right 
margin gets less.

If you want to specify a font attribute (bold, italic) for your margin notes, 
you can extend the .MN command by entering ^P, followed by the appropriate 
Printer command character:

.MN<>3^Y^Y
sets the margin notes' font attribute to italic.

.MN
without parameters turns off the margin notes function.

Margin notes and error messages

It is not possible to print two margin notes on one line. Another limitation 
is that the length of the margin notes may not exceed the numeric value 
entered in the .MN command, because the space in the margin would be 
insufficient to accommodate it. 

.2
Index

In the next version of WSformat I will explain the Index function and make 
some changes to the WSformat code that relates to handling the index. The 
index commands in your source text are identical to the Hypermake syntax. The 
.IN and .IT commands in this document refer to this function, but it is 
also possible to mark words or expressions in running text (not used in this 
document).

.2
Conditional statements

.in if condition
.in conditional statement
With conditional statements, you can create slightly different variations of 
the FMT files, derived from the same source text. If you insert these commands 
in the FMT file manually, these commands will not be interpreted during 
previewing and printing, because only the format function recognizes these 
commands.

There are three dot commands:

.sfM
 .IF CONDITION
 .ELSE
 .END
.sf

The condition statements are not case-sensitive. Note that The ELSE command 
need not be included.

This means text between these commands is interpreted only if the condition is 
set (is true). They are set in the WSformat main window, if entry field. You 
may enter more than one condition, which must be separated by spaces.

The condition WSFORMAT is always set. Use this condition to distinguish text 
designated for Hypermake or for WSformat. The OS/2 version of WSformat also 
sets the condition OS2.

WSformat also supports the following expressions:

.sfM
 .IF NOT COND
 .IF COND1 AND COND2
 .IF COND1 OR COND2
.sf

I regret that more sophisticated if-conditions grouped with parentheses are 
not supported.

The Wordstar command .EI end if can be used instead of the .END 
command.

.1
Dot command summary

This chapter will be available for the next version.

.1
FAQ

.in FAQ
I will place questions I get from you here.

.WA verti 25
.1
About

.ID P_ABOUT
.2
Registration

.ID P_REGISTRATION
.in WSformat
.in Registration
.in price
.in fee
WSformat is Shareware, but this refers only to the formatting function. If 
you format documents often, you are asked to register. You are allowed to send 
WSformat to friends or to a publishing house for printing your formatted 
document. The registration key rests on your computer. WSedit is Freeware.

The normal registration fee is 120 Dollar or 120 EUR. The student 
registration fee is only 30$ or 30 EUR.

The key is valid for all 1.X versions and for all supported operating 
systems.

When ordering more than one licenses, you will get a 40% discount for every 
additional license (non-student licenses).

.URL http://www.bmtmicro.com
.in BMT Micro
.LOCAL
You can register this software by sending a Mail to BMT Micro, see 
BMTORDER.TXT. If you want to get the student price, please send a copy of your 
Student ID to BMT Micro.

If you contact BMT Micro, I will get informed by E-Mail. Then I send you the 
registration key. This process takes 1-2 days.

If you have got a bank account in an Euro country, you can transfer the money 
to my bank account in Germany Dresdner Bank Ottobrunn, german bank code 700 
800 00, account Nr. 075 64 62 400. In this case send me your Student ID via 
postal mail or fia FAX to Germany.

.2
Disclaimer

WSformat is provided as is and comes with no warranty of any kind, either 
expressed or implied. In no event will the author be liable for any damages 
resulting from the use of this software.

.2
Author

.in Author
Martin Vieregg, 37. I've studied economics. My main job is working in my own 
consulting company. Our special subject is public transport, especially 
railways and airports. The title of my doctoral (PhD) thesis was 'increasing 
efficiency of railway long-distance passenger traffic'.

.in Contacting the author
.in E-Mail
E-Mail address: Martin@vr-transport.de

Homepage of my Freeware- and Shareware programs:

http://www.hypermake.com


Postal Address:

Dr. Martin Vieregg
Emdenstr. 11
D-81735 Munich
(Germany)


Fax Number: 0049-89-26023656

.2
Versions and future plans

.in program versions
WSformat 0.81

The first published version of WSformat. While the planned WSformat 
functionality is not implemented completely, I will use version number 0.8X. 
0.9X will be the beta-test version numbers.

If you have bug reports and ideas for new functionality, please E-Mail me!

Future versions

There are a lot of things to to in the next month.

Jobs I plan for the next weeks:

Index functionality (documentation and modifications)
Dot command summary in documentation
faster preview on big documents when browsing a document back
more graphics file formats (GIF and JPG).
multi-colum support for preview and printing

Up to version 1.0, I will improve help functionality and write sophisticated 
communication between WSedit and WSformat (e.g. jump from Preview back to FMT 
or WS file and search the same location) or bubble help of dot command syntax 
in the WSedit window, based on WSformat data. Because these changes also 
affects WSedit, I will also publish new WSedit versions.

Perhaps I will publish a smaller Freeware EXE version with print functionality 
only (WS-Print).

After publishing WSformat, 1.0, I want to publish a Linux version and 
translate WSformat into German. To translate WSformat to other languages, I 
need help from native speakers. Please contact me if you are interested in 
such an effort - you will receive a donation for your work.

For Hypermake, I have written RTF import and export. If there are enough 
WSformat registrations, I will implement RTF export (two algorithms, one for 
unformatted files and one for formatted files) if you think it will be 
necessary.

Last but not least, I'm thinking about a substitute format for the WS file 
format. Hypermake already interpretes ANSI text with dot commands, and for 
WSedit and WSformat I plan this, too. But the concrete format definition has 
to be considered very well. Perhaps I only implement this option for 
unformatted files, and not for formatted files.

.2
History

.in History
In the late 80's, I published a Worstar DOS extension program 'StarExtender' 
in german language which had hyphenation, footnote, Line drawing, index and 
proportional printing support. WSformat is based on this program which is 
very-well tested for a lot of years. This is the reason that the basic format 
functionality works very well even WSformat is beta state software. Because 
the formatting and printing kernel is optimized for old computers from the 
80's, today WSformat is extremely fast.

.2
Bug report

.in bugs
Here I will place bug reports.

.2
Download Location

An easy way for uploading is my Homepage

http://www.hypermake.com

In the Internet, the versions for all platforms are available on 
ftp://ftp.bmtmicro.com/bmtmicro/

Filenames:
OS/2-eCS version: wsf-os2.zip
Win95/98/ME/NT/Win2000/XP version: wsf-win.zip

Archive file names with version number (e.g. wsf-100.zip) are usually the 
Windows version.

.2
Trademarks

IBM and OS/2 is a registered trademark of International Business Machines 
Corp.
WordStar is a trademark of The Learning Company.
Windows is a trademark of Microsoft.

.2
Other progs

Other programs I have written, both Windows 95/98/ME/NT/2000/XP and OS/2 
(Linux versions for some programs are planned)

.in Hypermake
Hypermake:
A Hypertext compiler which creates HTML files, Winhelp MS HTML-Help and OS/2 
Help from WSformat source files. The WSformat help file is created from this 
docu by Hypermake. Automatic linking, window arrangement, helptables, 
footnotes, tables and other features. Shareware if source file > 20 kB.

.in WSedit
WSedit:
Wordstar (DOS)-compaitble editor: Reading and writing Wordstar (DOS) files, 
ASCII IBM and ISO codepage. Supports Wordstar Ctrl key commands and CUA 
commands. Syntax-highlightning, Translation, spell checking, function key 
macro recorder and a lot of other features. WSedit handles very large ASCII 
files. Freeware.

pmCalc: a "pocket" calculator automatic clipboard functionality, programmers 
and scientific functions, Regression. There's a separate input and output 
field, the formula you type rests in the input field. (Shareware)

TinyAlarm:
A simple countdown with a slider from 1 to 60, an alarm by entering alarm time 
and a chime. System shutdown. Freeware.

cd-shortcut:
instead of whole directory names you enter only substrings. Searching through 
several drives and opening OS/2 WPS folders. Freeware.

Simple Zipshell:
Packing and unpacking ZIP files by using the graphical desktop. Freeware.

Clear:
(only OS/2) Uses also Info-Zip and let you backup your data e.g. on floppies. 
You can enter filenames like *.BAK which are not copied, directories which are 
skipped. Then you can enter filenames with a specific age which are deleted. 
Freeware.

For more information, screenshots and downloads, visit my Homepage

http://www.hypermake.com

end of document