/* rexx */
/* Trace TFF file list utility */
/* R.J.Moore 4 May 1996 */
/* version 1.0 */
say ";TFFLST: TRACE .TFF file list utility version 1.1"
say ";Author: Richard Moore - 27th July 98"
say ';Copyright (C) 1995, IBM UK Ltd.'
say ""

!.=""
arg !.0tfffile d .

if d="DEBUG" then !.0dbg=(0=0)
else !.0dbg=(0=1)

if !.0tfffile="" then do
   say "TFFLST tff_file"
   exit 4
end  /* Do */

if right(!.0tfffile,4)=".TFF" then !.0tfffile=!.0tfffile|| ".TFF"

!.0tffopen=0=1
signal on halt name haltexit

!.0rxcc=rxfuncadd("SysFileTree","REXXUTIL","SysFileTree")
call SysFileTree !.0tfffile,"x","F"
if x.0=0 then do
   say "File" !.0tfffile "not found"
   if !.0rxcc=0 then call rxfuncdrop "SysFileTree"
   exit 4
end  /* Do */
if !.0rxcc=0 then call rxfuncdrop "SysFileTree"

x=tffhdr()
if x<>0 then signal haltexit

do i=1 to !.0tff_rec_count
   x=tffindx(i)
   if x<>0 then signal haltexit
end /* do */

do i=1 to !.0tff_rec_count
   x=tffrecord(i)
   if x<>0 then signal haltexit
end /* do */

do i=1 to !.0tff_rec_count
   x=tffprint(i)
   if x<>0 then signal haltexit
end /* do */


haltexit: if !.0tffopen then x=lineout(!.0tfffile) /* close tfffile */

exit 0

tffhdr: procedure expose !.

/* deal with tff header */

!.0tff_signature=getbyte(0,3)
if !.0tff_signature<>"TFF" then do
   say "Invalid TFF file"
   return 1
end /* do */

!.0tff_major_code=c2d(getword(4))
!.0tff_rec_count=c2d(getword(6))
!.0tff_index_offset=c2d(getdword(8))

if !.0dbg then do
   say "major" !.0tff_major_code
   say "rec count" !.0tff_rec_count
   say "index offset 0x"d2x(!.0tff_index_offset)
end /* do */

parse var !.0tfffile name "."  .
say 'MODNAME='name
say 'MAJOR=0x'd2x(!.0tff_major_code) ';' !.0tff_major_code
say ' '

return 0

tffindx: procedure expose !.
 
/* deal with the index portion */
arg i

!.0tff.i.0minor_code=c2x(getword(!.0tff_index_offset))
!.0tff.i.0rec_len=c2d(getword(!.0tff_index_offset+2))
!.0tff.i.0offset=c2d(getdword(!.0tff_index_offset+4))

!.0tff_index_offset=!.0tff_index_offset+8

if !.0dbg then do
   say "minor" !.0tff.i.0minor_code
   say "rec length" !.0tff.i.0rec_len
   say "rec offset 0x"d2x(!.0tff.i.0offset)
end /* do */


return 0


tffrecord: procedure expose !.
 
/* deal with the minor tp record */
arg i

x=getbyte(!.0tff.i.0offset)
do while x<>"0"x
   if !.0dbg then say x
   !.0tff.i.0desc=!.0tff.i.0desc || x
   !.0tff.i.0offset=!.0tff.i.0offset+1
   x=getbyte(!.0tff.i.0offset)
end /* do */

if !.0dbg then say "----------------------------------------------------------"

!.0tff.i.0offset=!.0tff.i.0offset+1
x=getbyte(!.0tff.i.0offset)
if x="0"x then j=0 
else j=1
do while x<>"0"x
   if !.0dbg then say x
   if x="1"x then x="%"
   if x="a"x then do
      !.0tff.i.0offset=!.0tff.i.0offset+1
      x=getbyte(!.0tff.i.0offset)
      if x<>"0"x then j=j+1
      iterate
   end /* do */
   if x="d"x then do
      !.0tff.i.0offset=!.0tff.i.0offset+1
      x=getbyte(!.0tff.i.0offset)
      iterate
   end /* do */
   !.0tff.i.0fmt.j=!.0tff.i.0fmt.j || x
   !.0tff.i.0offset=!.0tff.i.0offset+1
   x=getbyte(!.0tff.i.0offset)
end /* do */
!.0tff.i.0fmt.0=j

if !.0dbg then say "----------------------------------------------------------"

return 0     


tffprint: procedure expose !.
 
/* format each minor .TFF record */
arg i

say '/* start TP 0x'!.0tff.i.0minor_code '('x2d(!.0tff.i.0minor_code)') */'
say ' '
say 'TRACE MINOR=0x'!.0tff.i.0minor_code',' 
say '      TP=@STATIC,'
if !.0tff.i.0fmt.0>0 then do
   say '      DESC="'!.0tff.i.0desc'",'
   do j=1 to !.0tff.i.0fmt.0 -1
      say '      FMT="'!.0tff.i.0fmt.j'",'
   end /* do */
   say '      FMT="'!.0tff.i.0fmt.j'"'
end /* do */
else do
   SAY '      DESC="'!.0tff.i.0desc'"'
end /* do */
say ' '
say '/* end TP 0x'!.0tff.i.0minor_code '('x2d(!.0tff.i.0minor_code)') */'
say ' '

return 0


x=getbyte(!.0tff.i.0offset)
do while x<>"0"x
   !.0tff.i.0fmt=!.0tff.i.0fmt || x
   !.0tff.i.0offset=!.0tff.i.0offset+1
   x=getbyte(!.0tff.i.0offset)
end /* do */

return 0     


getbyte: procedure expose !.
/* read one or more bytes from the .tff file from given offset */

parse arg offset,length
if length="" then length=1
return charin(!.0tfffile,offset+1,length)

getword: procedure expose !.
/* read a word from the .tff file from given offset */

parse arg offset
x=charin(!.0tfffile,offset+1,2)
return translate("12",x,"21")

getdword: procedure expose !.
/* read a double word from the .tff file from given offset */

parse arg offset
x=charin(!.0tfffile,offset+1,4)
return translate("1234",x,"4321")
