:userdoc.
.*--------------------------------------------------
.*
.* This IPF file was created with Rtf2Ipf v1.0
.*
.*--------------------------------------------------
:title.RTF2IPF Reference
:h1.RTF2IPF Overview
:p.
:font facename=default.This section describes some background information
that may be useful when determining if RTF2IPF is the right utility for
you&per.
:p.
:h2.Purpose of RTF2IPF
:p.
:font facename=default.This utility has been created as the result of my
desire to maintain both printed and on-line documentation for an internally
developed utility at work from a single document&per.  The general goal
of the RTF2IPF&per.EXE program is to take a word processing document saved
as Rich Text Format and re-tag the file with the IPFC compiler tags to
allow the creation of an OS/2 &per.INF file&per.  RTF2IPF is currently
a command line DOS program (sorry but I run DOS/Windows at home where this
was developed) that should be able to integrate well to a development make
file&per.  
:p.
:font facename=default.Although this utility is being distributed as 'Freeware'
I would like to know what you think of it&per.  After trying it please
send me a note to my CIS ID (74101,413) and let me know what you think&per.
 I hope my efforts will be useful for you too&per.
:p.
:h2.What you need to use RTF2IPF
:p.
:font facename=default.All you need to use RTF2IPF is a word processor
capable of saving its document (styles included) in Rich Text Format (RTF)&per.
 All of my testing has been with Ami Pro v2&per.0 for Windows and Ami Pro
v3&per.0 for OS/2&per.  The document you are receiving was created using
Ami Pro v2&per.0 for Windows&per.  Any word processor that can save it's
documents in RTF format should work&per.  If you use a different word processor
and develop a style sheet that you find useful please send it to me (see
the section Obtaining support for how to reach me) and I will include it
in the next version to be uploaded&per.  To compile your on-line document
you will need the OS/2 IPFC help compiler&per.
:p.
:h2.Disclaimers
:p.
:font facename=default.RTF2IPF is really still a work in process&per. 
As you read through here you will see several places where I mention that
a feature is planned or where I will even solicit your ideas about how
a feature should be implemented&per.  As a result of this utility still
evolving, the current version uploaded here still has some debug code compiled
in&per.  As such it is possible that you may run into an assertion or other
bugs&per.  Although I believe everything to be correct I cannot guarantee
it&per.  If you do have a problem or a suggestion, please contact me and
I will see what I can do to fix it&per.
:p.
:h1.Creating The Documentation in your Word Processor
:p.
:font facename=default.This section describes how to prepare you documentation
in your favorite word processor&per.
:p.
:h2.Styles
:p.
:font facename=default.RTF2IPF is dependent upon your word processor correctly
identifying style information in the RTF file when you save your document&per.
 The styles are used to identify how the text in your document should be
tagged for the IPFC compiler&per.  The most important use of styles is
to identify which 'paragraphs' in your document are intended to be used
as headings in the &per.INF file&per.  Since the IPFC compiler requires
that you make an orderly progression through the heading levels it is imperative
that you are very diligent in setting up a style sheet that mimics the
progression of styles that the IPFC compiler will accept&per.  You must
always keep in mind how the styles will affect your on-line document&per.
:p.
:font facename=default.For example, this document was created using the
Ami Pro style sheet supplied with RTF2IPF&per.  Some of the styles present
in the document and their uses are as follows&colon.
:p.
:font facename=default.:hp2.Heading 1
:p.
:ehp2.:font facename=default.The top level headings in the document&per.
 The 'paragraph' Creating The Documentation in your Word Processor is a
Heading 1 style&per.  That style always gets tagged with the IPFC tags
'&colon.h1&per.'
:p.
:font facename=default.:hp2.Heading 2
:p.
:ehp2.:font facename=default.This is the second level heading in the document&per.
 The 'paragraph' Styles is marked as a Heading 2 style&per.  That style
always gets tagged with the IPFC tags '&colon.h2&per.'
:p.
:font facename=default.:hp2.Subhead
:p.
:ehp2.:font facename=default.The Subhead style is used how a style is traditionally
used in a word processing document&per.  It is simply used to re-use common
formatting attributes, in this case bold text and a larger point size&per.
 The Subhead style was used for the Heading 1, Heading 2, and Subhead headings
within the Styles heading&per.
:p.
:h2.Text attributes
:p.
:font facename=default.Where possible, RTF2IPF tries to emulate common
text formatting characteristics within the constraints of IPFC&per.  Currently,
the only attribute supported is :hp2.Bold:ehp2.&per.  In the near future I hope
to have it supporting italics, underline, as well as all of the combinations
of these attributes&per.  Please try not to use different colors for your
text as my current thoughts are to use the RTF color tags in defining hyper-links
to other topics&per.
:p.
:h2.Paragraph formatting
:p.
:font facename=default.The current version of RTF2IPF does not provide
any paragraph formatting beyond the standard word wrap capabilities provided
by IPFC&per.  Although IPFC does allow for some formatting it is beyond
the scope of the current version of RTF2IPF&per.
:p.
:h2.Tables
:p.
:font facename=default.Tables are currently unsupported by RTF2IPF but
are currently very high on the list for planned enhancements (I need them
too!)&per.  The 'results are unpredictable' for what will happen if you
give RTF2IPF a table to process&per.
:p.
:h1.RTF2IPF Project Files
:p.
:font facename=default.This section describes the RTF2IPF project files&per.

:p.
:h2.Overview
:p.
:font facename=default.The RTF2IPF project files contain information for
RTF2IPF to use when converting the RTF tagged file to an IPF tagged file&per.
 The file is an ASCII text file that take the format of&colon.
:p.
:xmp.
Keyword=Value
Keyword=Value


:exmp.
:font facename=default.By convention the RTF2IPF project files have an
&per.IPJ extension&per.
:p.
:h2.Keywords
:p.
:font facename=default.Each of the valid keywords are described in their
own section below&per.  Although the keywords are shown in mixed case they
are processed in a case insensitive manner&per.
:p.
:h3.ExampleStyle
:p.
:font facename=default.:hp2.Purpose
:p.
:ehp2.:font facename=default.The ExampleStyle keyword is used to define
the style to be interpreted as example tagged information&per.  The ExampleStyle
keyword is required if you need the '&colon.xmp&per.' tag to be created
in the &per.IPF file&per.
:p.
:font facename=default.:hp2.Syntax
:p.
:ehp2.:xmp.
ExampleStyle=<stylename>


:exmp.
:font facename=default.:hp2.Parameters
:p.
:ehp2.:font facename=default.:hp2.stylename:ehp2. - The name of the style to
be tagged as '&colon.xmp&per.' in the IPF file&per.
:p.
:h3.HeadingNStyle
:p.
:font facename=default.:hp2.Purpose
:p.
:ehp2.:font facename=default.The HeadingNStyle keyword is used to define
the style to be interpreted as heading level N&per.  Currently N can take
the value of 1 - 3&per.  At least the Heading1Style keyword is required&per.
:p.
:font facename=default.:hp2.Syntax
:p.
:ehp2.:xmp.
HeadingNStyle=<stylename>


:exmp.
:font facename=default.:hp2.Parameters
:p.
:ehp2.:font facename=default.:hp2.stylename:ehp2. - The name of the style to
use for the heading level N in the &per.IPF file&per.
:p.
:h3.IpfFile
:p.
:font facename=default.:hp2.Purpose
:p.
:ehp2.:font facename=default.The IpfFile keyword is used to define the
IPF output file to be created&per.  This keyword is required&per.
:p.
:font facename=default.:hp2.Syntax
:p.
:ehp2.:xmp.
IpfFile=<filename>


:exmp.
:font facename=default.:hp2.Parameters
:p.
:ehp2.:font facename=default.:hp2.filename:ehp2. - The name of the file to be
created containing the IPF tagged source for the help file&per.  The file
name follows standard naming rules that allow the name to be a fully qualified
or relative path name&per.
:p.
:h3.IpfTitle
:p.
:font facename=default.:hp2.Purpose
:p.
:ehp2.:font facename=default.The IpfTitle keyword is used to define the
title for the &per.INF file to be created&per.  This keyword is required&per.
:p.
:font facename=default.:hp2.Syntax
:p.
:ehp2.:xmp.
IpfTitle=<title>


:exmp.
:font facename=default.:hp2.Parameters
:p.
:ehp2.:font facename=default.:hp2.title:ehp2. - The title for the &per.INF file
to be created&per.
:p.
:h3.RtfFile
:p.
:font facename=default.:hp2.Purpose
:p.
:ehp2.:font facename=default.The RtfFile keyword is used to define the
RTF input file&per.  This keyword is required&per.
:p.
:font facename=default.:hp2.Syntax
:p.
:ehp2.:xmp.
RtfFile<filename>


:exmp.
:font facename=default.:hp2.Parameters
:p.
:ehp2.:font facename=default.:hp2.filename:ehp2. - The name of the file containing
the RTF source for the help file&per.  The file name follows standard naming
rules that allow the name to be a fully qualified or relative path name&per.
:p.
:h2.Example &per.IPJ file
:p.
:font facename=default.The following is the &per.IPF file used to create
this document&per.
:p.
:xmp.
RtfFile=rtf2ipf&per.rtf
IpfFile=rtf2ipf&per.ipf 
IpfTitle=RTF2IPF Reference 
Heading1Style=Heading 1 
Heading2Style=Heading 2 
Heading3Style=Heading 3 
ExampleStyle=example

:exmp.
:font facename=default.
:p.
:h1.Running RTF2IPF
:p.
:font facename=default.Running RTF2IPF is very simple&per.  The program
is invoked from the DOS (or OS/2) command line as follows&colon.
:p.
:xmp.
RTF2IPF <project file>


:exmp.
:font facename=default.There are no options just a project file on the
command line&per.  RTF2IPF will print a banner line and print a progress
'&per.' at approximately every 500 characters added to the &per.IPF file
until complete&per.
:p.
:h1.Obtaining support
:p.
:font facename=default.If you have a suggestion or problem please send
a description along with the &per.IPJ and &per.RTF files and the date on
the RTF2IPF&per.EXE file to&colon.
:p.
:font facename=default.Mark Ault
:p.
:font facename=default.74101,413 (Comp-U-Serve)
:p.
:h1.Planned Enhancements
:p.
:font facename=default.:hp2.Character Formatting
:p.
:ehp2.:font facename=default.As mentioned earlier, one of the first enhancements
on tap for this utility is the ability to use text properties other than
normal and bold&per.  Italics and underline will be added along with the
various combinations&per.
:p.
:font facename=default.:hp2.Tables
:p.
:ehp2.:font facename=default.Currently this utility is un-tested with tables&per.
 Table support is planned for the next version I will post&per.
:p.
:font facename=default.:hp2.Hyper-Links
:p.
:ehp2.:font facename=default.The ability to create hyper-links from one
of the &per.INF panels to another panel in the same document&per.  Currently
I am planning on using a color tag to identify where the hyper-links occur&per.
 If you have any suggestions of a different way to tag it in the word processor
please let me know&per.
:p.
:font facename=default.:hp2.Multiple RTF input files
:p.
:ehp2.:font facename=default.As some documents get larger it can be convenient
to break them into several smaller documents&per.  When this is done it
requires you to combine the documents as one and save the one RTF file
for Rtf2Ipf to process&per.  It would be more convenient to use several
RTF files for each of the pieces of the original document&per.
:p.
:font facename=default.:hp2.Re-work the &per.IPJ project files
:p.
:ehp2.:font facename=default.Possible enhancements include adding comments,
an include directive, getting file names from the command line instead,
and getting the title from the document information section of the RTF
file&per.
:p.

:euserdoc.
