/***************************************************************************
 *                                                                         *
 * REXXEDIT.CMD - A simple text editor, written completely in REXX.        *
 *                                                                         *
 * Craig Morrison 15 July 1994, released into the Public Domain this day.  *
 *                                                                         *
 * REXXEdit can handle a file of any size, subject to available memory.    *
 * One big restriction is the line size, lines are limited to 78 or so     *
 * characters in length. I didn't feel like going through the trouble of   *
 * handling the horizontal scrolling.                                      *
 *                                                                         *
 * REXXEdit *is* a bit slow at scrolling, but it doesn't do too bad of a   *
 * job of keeping up. I could have written an add-on DLL to take care of   *
 * it, but this was an exercise in REXX using just those tools available   *
 * from the basic REXX installation of OS/2. Call me a purist.. ;-)        *
 *                                                                         *
 * You'll have to snoop through the code to find out what functions are    *
 * available. Most of the common editor functions are present. All the     *
 * standard navigation keys work.                                          *
 *                                                                         *
 * The line lengths of this file itself have been kept in the range that   *
 * REXXEdit can handle. You can use REXXEdit to modify the code.           *
 *                                                                         *
 * Here's the basic philosophy behind REXXEdit:                            *
 *                                                                         *
 *    If you want it, add it, you've got the source code.                  *
 *                                                                         *
 *  Changes:                                                               *
 *                                                                         *
 *  Person       Date        Changes                                       *
 *      *
 * C. Morrison  15 Jul 94   First release.                                 *
 *                                                                         *
 ***************************************************************************/
'@echo off'

Parse Upper Arg textfile .

Call rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

fKey = x2c('00')
hfKey = x2c('e0')
escKey = x2c('1b')
enter = x2c('0d')
lfeed = x2c('0a')
bSpace = d2c(8)
CTRLj = d2c(10)
CTRLy = d2c(25)
CTRLn = d2c(14)
CTRLx = d2c(24)
CTRLh = d2c(9)
fkUp = 'H'
fkDown = 'P'
fkLeft = 'K'
fkRight = 'M'
fkHome = 'G'
fkEnd = 'O'
fkPgUp = 'I'
fkPgDn = 'Q'
fkIns = 'R'
fkDel = 'S'
fkCHome = 'w'
fkCEnd = 'u'
fkCPgDn = 'v'
fkCPgUp = ''
fkCLeft = 's'
fkCRight = 't'
fkF2 = '<'
fkF3 = '='
fkF4 = '>'
fRow = 1
fCol = 1
Row = fRow
Col = fCol
lRow = 23
lCol = 78
fVisRow = 1
linePos = 1
lineRow = 1
Changes = 0
InsMode = 1
TabSize = 4
Title = ' REXXEdit v1.0 '
GetOut = ' ESC or F3 to Quit, F2 saves '
spacestr = Copies(' ', lCol)
Footer = ' '||Copies('', lCol)
Banner = OverLay(Title, Footer, Trunc((lCol + 2 - Length(Title)) / 2))
Footer = OverLay(GetOut, Footer, Trunc((lCol + 2 - Length(GetOut)) / 2))

Text.0 = 1
Text.1 = ''

if textfile <> '' Then Do
    if Stream(textfile, 'c', 'query exists') <> '' Then Do
        Say 'One moment, reading 'textfile'...'
        index = 1
        Do Until Lines(textfile) = 0
            Text.index = LineIn(textfile)
            if Length(Text.index) >= lCol Then Do
                txt = Text.index
                Text.index = GetOneLine(lCol, txt)
                index = index + 1
                txt = Space(DelWord(txt, 1, Words(txt)), 1)
                Do While Length(txt) \= 0
                    wText = GetOneLine(lCol, txt)
                    Text.index = wText
                    txt = Space(DelWord(txt, 1, Words(wText)), 1)
                    index = index + 1
                End
            End
            Else
                index = index + 1
        End
        ok = Stream(textfile, 'c', 'close')
        Text.0 = index - 1
    End
End

Call SysCls
Call SysCurPos lRow + 1, fCol - 1
Call CharOut , Footer
Call SysCurPos fRow - 1, fCol - 1
Call CharOut , Banner
Call SysCurPos Row, Col
Call DisplayStats
Call DisplayScreenful fVisRow

Do Until inkey = escKey
    inkey = GetKey()
    Select
        When inkey = fKey Then Call DoFuncKey GetKey()
        When inkey = enter Then Call DoReturnKey
        When inkey = bSpace Then Call DoBackSpace
        Otherwise
            If c2d(inkey) > 31 Then Call WriteOutChar(inkey)
            Else Call DoControlKey inkey
    End
End

GetOuttaDodge:

Call SysCls
if Changes = 1 Then Do
    if textfile = '' Then Do
        Say
        Say 'Filename to save changes under (enter to discard)?'
        Pull textfile .
        if textfile <> '' Then YesNo = 'Y'
    End
    Else Do
        Say
        Say textfile' has been modified.'
        Say 'Save the changes (Y or N)?'
        Pull YesNo .
    End
    if (YesNo = 'Y') | (YesNo = '') Then Do
        Call FileSave
    End
End

Exit

FileSave:

    if textfile <> '' Then Do
        if Stream(textfile, 'c', 'query exists') <> '' Then Do
            'DEL 'textfile
            Do index = 1 to Text.0
                Text.index = Strip(Text.index, 'T')
                Call LineOut textfile, Text.index
            End
            ok = Stream(textfile, 'c', 'close')
            Changes = 0
        End
        Else
            Call Beep 100, 250
    End

Return

DoBackSpace:

    If Col > fCol Then Do
        Col = Col - 1
        linePos = linePos - 1
        rStr = Right(Text.lineRow, Length(Text.lineRow) - linePos)
        nStr = Overlay(rStr, Text.lineRow, linePos)
        Text.lineRow = Left(nStr, Length(nStr) - 1)
        Call SysCurState 'OFF'
        Call SysCurPos Row, Col
        Call CharOut , rStr
        if Length(Text.lineRow) < lCol Then
            Call Charout ,,
                Left(spacestr, Length(spacestr) - Length(Text.lineRow))
        Call SysCurPos Row, Col
        Call SysCurState 'ON'
        Changes = 1
    End

Return

DoReturnKey:

    If Row < lRow Then Do
        Row = Row + 1
        lineRow = lineRow + 1
    End
    Else Do
        lineRow = lineRow + 1
        fVisRow = fVisRow + 1
        Call DisplayScreenful fVisRow
    End

    If lineRow > Text.0 Then Do
        Text.lineRow = ''
        Text.0 = lineRow
        Changes = 1
    End
    Else Do
        i = Text.0 + 1
        Do Until i = lineRow
            ni = i - 1
            Text.i = Text.ni
            i = i - 1
        End
        Text.lineRow = ''
        Text.0 = Text.0 + 1
        Call DisplayScreenful fVisRow
        Changes = 1
    End

    Col = fCol
    linePos = fCol
    Call SysCurPos Row, Col

Return

WriteOutChar:

    Parse Arg key

    If Col < lCol Then Do
        Text.lineRow = AddCharToString(key, Text.lineRow, linePos)
        Call CharOut , key
        Col = Col + 1
        linePos = linePos + 1
    End

Return

GetKey:

    k = SysGetKey('NOECHO')
    If k = hfKey Then k = fKey

return k

DoControlKey:

    Parse Arg key

    Select
        When key = CTRLh Then Do
                nTab = ((linePos % TabSize) + 1) * TabSize
                if nTab < lCol Then Do
                    nTab = (nTab - linePos) + 1
                    Do nt = 1 to nTab
                        Call WriteOutChar ' '
                    End
                End
            End
        When key = CTRLy Then Do
                if lineRow < Text.0 Then Do
                    Do i = lineRow To Text.0
                        ni = i + 1
                        Text.i = Text.ni
                    End
                    Text.0 = Text.0 - 1
                    Call DisplayScreenful fVisRow
                    Changes = 1
                End
            End
        When key = CTRLn Then Do
                i = Text.0 + 1
                Do Until i = lineRow
                    ni = i - 1
                    Text.i = Text.ni
                    i = i - 1
                End
                Text.lineRow = ''
                Text.0 = Text.0 + 1
                Call DisplayScreenful fVisRow
                Changes = 1
            End
        When key = CTRLx Then Do
                if linePos <= Length(Text.lineRow) Then Do
                    i = Text.0 + 1
                    Do Until i = lineRow
                        ni = i - 1
                        Text.i = Text.ni
                        i = i - 1
                    End
                    Text.0 = Text.0 + 1
                    li = lineRow + 1
                    Text.li = Text.lineRow
                    if linePos <> 1 Then
                        Text.lineRow = Left(Text.lineRow, linePos - 1)
                    Else
                        Text.lineRow = ''
                    Text.li = Right(Text.li,,
                                    (Length(Text.li) - linePos) + 1)
                    Call DisplayScreenful fVisRow
                    Changes = 1
                End
            End
        When key = CTRLj Then Do
                if lineRow + 1 <= Text.0 Then Do
                    lr = lineRow + 1
                    tmp = Text.lineRow||' '||Text.lr
                    if Length(tmp) < lCol Then Do
                        Text.lineRow = tmp
                        Do i = lr To Text.0
                            ni = i + 1
                            Text.i = Text.ni
                        End
                        Text.0 = Text.0 - 1
                    End
                    Else Do
                        wi = lCol - 1
                        Do While SubStr(tmp, wi, 1) <> ' '
                            wi = wi - 1
                            if wi = 0 Then Leave
                        End
                        if wi = 0 Then wi = lCol - 1
                        Text.lineRow = Left(tmp, wi)
                        Text.lr = Right(tmp, Length(tmp)-wi)
                    End
                    Call DisplayScreenful fVisRow
                    Changes = 1
                End
            End
        Otherwise
            Nop
    End
    if linePos > Length(Text.lineRow) + 1 Then Do
        linePos = Length(Text.lineRow) + 1
        if linePos = 0 Then linePos = fCol
        Col = linePos
    End

    Call SysCurPos Row, Col

return

DoFuncKey:

    Parse Arg funcKey

    Parse Value SysCurPos() With Row Col

    Select
        When funcKey = fkCLeft Then Do
                if Words(Text.lineRow) > 0 Then Do
                    wpos = Words(Text.lineRow)
                    if wpos > 1 Then Do
                        fword = WordIndex(Text.lineRow, 1)
                        Do wi = 1 To wpos
                            i = WordIndex(Text.lineRow, wi)
                            if i < linePos Then
                                if i > fword Then fword = i
                        End
                        linePos = fword
                    End
                    Else Do
                        linePos = WordIndex(Text.lineRow, 1)
                    End
                    Col = linePos
                End
            End
        When funcKey = fkCRight Then Do
                if Words(Text.lineRow) > 1 Then Do
                    wpos = Words(Text.lineRow)
                    fword = WordIndex(Text.lineRow, wpos)
                    Do wi = 1 To wpos
                        i = WordIndex(Text.lineRow, wi)
                        if i > linePos Then
                            if i < fword Then fword = i
                    End
                    linePos = fword
                    Col = linePos
                End
            End
        When funcKey = fkIns Then Do
                if InsMode = 1 Then
                    InsMode = 0
                Else
                    InsMode = 1
                Call DisplayStats
            End
        When funcKey = fkDel Then Do
            if linePos <= Length(Text.lineRow) Then Do
                if linePos < Length(Text.lineRow) Then Do
                    rStr = Right(Text.lineRow,,
                                 Length(Text.lineRow) - linePos)
                    nStr = Overlay(rStr, Text.lineRow, linePos)
                End
                Else Do
                    rStr = ''
                    nStr = Text.lineRow;
                End
                Text.lineRow = Left(nStr, Length(nStr) - 1)
                Call SysCurState 'OFF'
                Call SysCurPos Row, Col
                Call CharOut , rStr
                if Length(Text.lineRow) < lCol Then
                    Call Charout ,,
                       Left(spacestr,,
                            Length(spacestr) - Length(Text.lineRow))
                Call SysCurPos Row, Col
                Call SysCurState 'ON'
                Changes = 1
            End
        End
        When funcKey = fkUp Then Do
                if Row > fRow Then Do
                    Row = Row - 1
                    lineRow = lineRow - 1
                End
                Else if fVisRow > 1 Then Do
                    lineRow = lineRow - 1
                    fVisRow = fVisRow - 1
                    Call DisplayScreenful fVisRow
                End
            End
        When funcKey = fkDown Then Do
                if Row < lRow Then Do
                    if lineRow < Text.0 Then Do
                        Row = Row + 1
                        lineRow = lineRow + 1
                    End
                End
                Else Do
                    if lineRow < Text.0 Then Do
                        lineRow = lineRow + 1
                        fVisRow = fVisRow + 1
                        Call DisplayScreenful fVisRow
                    End
                End
            End
        When funcKey = fkLeft Then Do
                if Col > fCol Then Do
                    Col = Col - 1
                    linePos = linePos - 1
                End
            End
        When funcKey = fkRight Then Do
                if Col < lCol Then Do
                    If linePos < Length(Text.lineRow) + 1 Then Do
                        Col = Col + 1
                        linePos = linePos + 1
                    End
                End
            End
        When funcKey = fkHome Then Do
                Col = fCol
                linePos = Col
            End
        When funcKey = fkEnd Then Do
                Col = lCol
                linePos = Col
            End
        When funcKey = fkPgUp Then Do
                if fVisRow - 23 > 0 Then Do
                    Row = fRow
                    fVisRow = fVisRow - 23
                    lineRow = fVisRow
                    Call DisplayScreenful fVisRow
                End
                Else Do
                    Row = fRow
                    fVisRow = Row
                    lineRow = fVisRow
                    Call DisplayScreenful fVisRow
                End
            End
        When funcKey = fkPgDn Then Do
                if fVisRow + 23 < = Text.0 Then Do
                    Row = fRow
                    fVisRow = fVisRow + 23
                    lineRow = fVisRow
                    Call DisplayScreenful fVisRow
                End
            End
        When funcKey = fkCHome Then Do
                fVisRow = fRow
                Row = fRow
                lineRow = fVisRow
                Call DisplayScreenful fVisRow
            End
        When funcKey = fkCEnd Then Do
                if Text.0 - 22 > 0 Then Do
                    fVisRow = Text.0 - 22
                    lineRow = fVisRow + 22
                    Row = lRow
                    Call DisplayScreenful fVisRow
                End
            End
        When funcKey = fkCPgUp Then Do
                lineRow = fVisRow
                Row = fRow
            End
        When funcKey = fkCPgDn Then Do
                if fVisRow + 22 <= Text.0 Then Do
                    lineRow = fVisRow + 22
                    Row = lRow
                End
            End
        When funcKey = fkF3 Then Signal GetOuttaDodge
        When funcKey = fkF2 Then Call FileSave
        OtherWise
            Nop
    End
    if linePos > Length(Text.lineRow) + 1 Then Do
        linePos = Length(Text.lineRow) + 1
        if linePos = 0 Then linePos = fCol
        Col = linePos
    End

    Call SysCurPos Row, Col

Return

AddCharToString:
    Procedure Expose InsMode fCol lCol Changes

    Parse Arg key, text, position

    Select
        When position > Length(text) Then Do
                text = text||key
                Changes = 1
            End
        When InsMode = 1 Then
            Do
                If position = 1 Then Do
                    lStr = ''
                    rStr = text
                End
                Else Do
                    lStr = Left(text, position - 1)
                    rStr = DelStr(text, 1, Length(lStr))
                End
                text = lStr||key||rStr
                if Length(text) >= lCol Then
                    text = Left(text, lCol-1)
                Call SysCurState 'OFF'
                Parse Value SysCurPos() With oRow oCol
                Call SysCurPos oRow, fCol
                Call CharOut , text
                Call SysCurPos oRow, oCol
                Call SysCurState 'ON'
                Changes = 1
            End
        When InsMode = 0 Then Do
                text = OverLay(key, text, position)
                Changes = 1
            End
        Otherwise
            Nop
    End

return text

DisplayScreenful:

    Parse Arg fv

    if fv + 23 > Text.0 Then top = (Text.0 - fv)
    Else top = 22

    iRow = 1
    oText = ''
    Do li = fv to top + fv
        oText = oText||' '||OverLay(Text.li, spacestr, 1)||enter||lfeed
        iRow = iRow + 1
    End
    if iRow <= lRow Then Do
        iRow = (lRow - iRow) + 1
        oText = oText||Copies(' '||spacestr||enter||lfeed, iRow)
    End
    Call SysCurState 'OFF'
    Call SysCurPos fRow, fCol - 1
    Call CharOut , oText
    Call SysCurPos Row, Col
    Call SysCurState 'ON'

return

DisplayStats:

    stats = ''

    Parse Value SysCurPos() With oRow oCol
    Call SysCurState 'OFF'
    Call SysCurPos lRow + 1, fCol
    if InsMode = 1 Then
        stats = stats||' INS '
    Else
        stats = stats||''
    Call CharOut , stats
    Call SysCurPos oRow, oCol
    Call SysCurState 'ON'

return

GetOneLine:

    Parse Arg llen, inText

    cText = ''
    Do While Length(cText' 'Word(inText, 1)) < llen
        cText = cText' 'Word(inText, 1)
        inText = DelWord(inText, 1, 1)
        If inText = '' Then Leave
    End

    if cText = '' Then Do
        cText = Left(inText, llen)
    End

Return Space(cText, 1)
