;----------------------------------------------------------------------------
;     MODULE NAME:   PUSHPOPM.H
;
;         $Author:   Dennis_Bareis  $
;       $Revision:   1.2  $
;           $Date:   13 Nov 1999 13:39:46  $
;        $Logfile:   E:/DB/PVCS.IT/OS2/PPWIZARD/PUSHPOPM.H_V  $
;
;     DESCRIPTION:   This is a header file for saving and restoring MACRO
;                    values.
;
;                    This is useful where you need to "protect" the value
;                    from a header file you are including.  Fairly rare
;                    requirement, but handy when you need it.
;
;         EXAMPLE:   #define     XXXX    Some value
;                    <$MacroPush Macro='XXXX'>           ;;Save it
;                    #include    "File"                  ;;Header may change value
;                    <$MacroPop  Macro='XXXX'>           ;;Restore it
;----------------------------------------------------------------------------


;--- Only include once ----------------------------------
#ifndef VERSION_PUSHPOPM_H
   ;--- Define the version number of this header file ---
   #define   VERSION_PUSHPOPM_H    99.289

   ;--- Include nesting validation code -----------------
   #include "nestchk.h"
   <$NestingInit Id="PUSHPOPM" DESC="PUSHPOPM.H stack macro tag">

   ;--- Push Macro --------------------------------------
   #define MacroPush                                                    \
           <$NestingInc Id="PUSHPOPM">                                 -\
           #evaluate    ''          ^MacroPush = MacroGet('{$Macro}')^ -\
           #RexxVar     'MacroPush'  PUSH

   ;--- Pop Macro ---------------------------------------
   #define MacroPop                                  \
           <$NestingDec Id="PUSHPOPM">              -\
           #RexxVar     'MacroPush'  POP            -\
           #evaluate+   '{$Macro}'  'MacroPush'
#endif
