;----------------------------------------------------------------------------
;     MODULE NAME:   PPWSORT.H
;
;         $Author:   Dennis_Bareis  $
;       $Revision:   1.2  $
;           $Date:   02 Oct 1999 18:40:58  $
;        $Logfile:   E:/DB/PVCS.IT/OS2/PPWIZARD/PPWSORT.H_V  $
;
;     DESCRIPTION:   PPWIZARD has a "SortArray()" routine which can be used
;                    to sort a single array.  It does have some flexability
;                    in how it compares entries.
;
;                    This header file would be used to handle sort
;                    requirements that are not possible using "SortArray()".
;
;                    This header allows you to:
;
;                         * Imbed the sort routine between PPWIZARD commands.
;
;                         * Imbed the sort routine between rexx     commands.
;
;                         * Sort more than one array at a time, for example
;                           you may have multiple arrays storing associated
;                           information that should all be sorted together.
;
;                         * Do any sort of compare, no matter how complex.
;
;
;                     EXAMPLE1 - Inline Rexx code (use "SortArray" for inline
;                                PPWIZARD code). Array 'A' is being sorted.
;                     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;                     ArrayName = arg(1);      ;;Caller passed "A"
;                     <$GenRexx2Sort                                                                                      \
;                          COUNT=^_valueG(ArrayName || '.0')^                                                             \
;                        GREATER=^SrtGreater = _valueG(ArrayName || '.SrtIndex1') >> _valueG(ArrayName || '.SrtIndex2')^  \
;                           SWAP=^SrtTemp = _valueG(ArrayName || '.SrtIndex1');                                          -\
;                                 call _valueS ArrayName || '.SrtIndex1', _valueG(ArrayName || '.SrtIndex2');            -\
;                                 call _valueS ArrayName || '.SrtIndex2', SrtTemp                                        -\
;                                ^                                                                                       -\
;                     >
;
;                     Note ">>" being used in the compare, if the data being
;                     sorted is numeric use '>' instead (or else)!!!!!!
;
;                     EXAMPLE2 - Exactly same as Example 1
;                                hardcoded - can't handle other arrays).
;                     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;                     ArrayName = translate(arg(1));      ;;Caller passed "A" (handle possible value() bug!)
;                     <$GenRexx2Sort1ArrayIndirect NamedIn="ArrayName">
;
;                     EXAMPLE3 - In this case the name of the array ("A" is
;                                hardcoded - can't handle other arrays).
;                     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;                     <$GenRexx2Sort1Array ARRAY="A">
;
;----------------------------------------------------------------------------


;--- Only include once ------------------------------------------------------
#ifndef VERSION_PPWSORT_H


;--- Define the version number of this header file --------------------------
#define   VERSION_PPWSORT_H    99.269
#require  99.269


;--- For use within PPWIZARD for immediate sorting of array (PPWIZARD Command!) ---
#define SortArray    \
        #evaluate '' ^<$GenRexx2Sort COUNT={$COUNT} GREATER={$GREATER} SWAP={$SWAP}>^

;--- Generates the rexx code to perform sorting (sort one "NAMED" array) ----
#define GenRexx2Sort1Array                                        \
        <$GenRexx2Sort                                            \
             COUNT=^{$Count="{$Array}.0"}^                        \
            PREFIX=^{$Prefix="Srt"}^                              \
           GREATER=^SrtGreater = {$Array}.SrtIndex1 {$Compare=">"} {$Array}.SrtIndex2^  \
              SWAP=^SrtTemp = {$Array}.SrtIndex1;                -\
                    {$Array}.SrtIndex1 = {$Array}.SrtIndex2;     -\
                    {$Array}.SrtIndex2 = SrtTemp                 -\
                   ^                                             -\
        >

;--- Generates the rexx code to perform sorting (sort 2 "NAMED" arrays) -----
#define GenRexx2Sort2Arrays                                                    \
        <$GenRexx2Sort                                                         \
             COUNT=^{$Count="{$Array1}.0"}^                                    \
            PREFIX=^{$Prefix="Srt"}^                                           \
           GREATER=^{$Prefix}Greater = {$Array1}.{$Prefix}Index1 {$Compare=">"} {$Array1}.{$Prefix}Index2^ \
              SWAP=^{$Prefix}Temp = {$Array1}.{$Prefix}Index1;                -\
                    {$Array1}.{$Prefix}Index1 = {$Array1}.{$Prefix}Index2;    -\
                    {$Array1}.{$Prefix}Index2 = {$Prefix}Temp;                -\
                    {$Prefix}Temp = {$Array2}.{$Prefix}Index1;                -\
                    {$Array2}.{$Prefix}Index1 = {$Array2}.{$Prefix}Index2;    -\
                    {$Array2}.{$Prefix}Index2 = {$Prefix}Temp                 -\
                   ^                                                          -\
        >


;--- Generates the rexx code to perform sorting (array name not hard coded) -
#define GenRexx2Sort1ArrayIndirect                                                                             \
        <$GenRexx2Sort                                                                                         \
             COUNT=^{$Count="_valueG({$NamedIn} || '.0')"}^                                                    \
            PREFIX=^{$Prefix="SRT"}^                                                                           \
           GREATER=^{$Prefix}Greater = _valueG({$NamedIn} || '.{$Prefix}INDEX1') {$Compare=">"} _valueG({$NamedIn} || '.{$Prefix}INDEX2')^  \
              SWAP=^{$Prefix}Temp = _valueG({$NamedIn} || '.{$Prefix}INDEX1');                                -\
                    call _valueS {$NamedIn} || '.{$Prefix}INDEX1', _valueG({$NamedIn} || '.{$Prefix}INDEX2'); -\
                    call _valueS {$NamedIn} || '.{$Prefix}INDEX2', {$Prefix}Temp                              -\
                   ^                                                                                          -\
        >

;--- Generates the rexx code to perform sorting (GENERIC) -------------------
#DefineRexx GenRexx2Sort
           {$Prefix="SRT"}M = 1
           {$Prefix}Count   = {$COUNT};
           do  while (9 * {$Prefix}M + 4) < {$Prefix}Count
               {$Prefix}M = {$Prefix}M * 3 + 1
           end /* do while */
           do  while {$Prefix}M > 0
               {$Prefix}K = {$Prefix}Count - {$Prefix}M
               do  {$Prefix}J = 1 to {$Prefix}K
                   {$Prefix}Index1 = {$Prefix}J
                   do while {$Prefix}Index1 > 0
                       ;--- Work out what to compare it with ----------------
                       {$Prefix}Index2 = {$Prefix}Index1 + {$Prefix}M;

                       ;--- User user supplied logic to check for greater ---
                       {$Greater};

                       ;--- Swap if required --------------------------------
                       if {$Prefix}Greater then
                       do
                           {$Swap};
                       end;
                       else
                           leave;

                       ;--- Prepare for the next loop -----------------------
                       {$Prefix}Index1 = {$Prefix}Index1 - {$Prefix}M

                   end /* do while {$Prefix}Index1 > 0 */
               end     /* do {$Prefix}J = 1 to {$Prefix}K */
               {$Prefix}M = {$Prefix}M % 3
           end         /* while {$Prefix}M > 0 */
#DefineRexx




#ifdef   CommentBlock  /* (Saturday 07/08/1999, 20:32:20, by Dennis_Bareis) */
**+--------------------------------------------------------------------------
**|;--- Generates the rexx code to perform sorting (GENERIC) -------------------
**|#DefineRexx GenRexx2Sort
**|        {$Prefix="Srt"}Count    = {$COUNT};
**|        {$Prefix}Distance = {$Prefix}Count % 2;
**|        do  while {$Prefix}Distance > 0
**|            do  until {$Prefix}Finished;      /* start of mini-bubblesort loop */
**|                {$Prefix}Finished = 1;
**|                do  {$Prefix}Index1 = 1 to {$Prefix}Count - {$Prefix}Distance
**|                    ;--- We now compare and swap items {$Prefix}Index1 and {$Prefix}Index1+{$Prefix}Distance ---
**|                    {$Prefix}Index2 = {$Prefix}Index1 + {$Prefix}Distance;
**|
**|                    ;--- User user supplied logic to check for greater ---
**|                    {$GREATER};
**|
**|                    ;--- Swap if required --------------------------------
**|                    if {$Prefix}Greater then
**|                    do
**|                        ;--- User user supplied logic to swap items ------
**|                        {$Swap};
**|                        {$Prefix}Finished = 0;
**|                    end;
**|                end;
**|            end;                       /* end of mini-bubblesort loop */
**|            {$Prefix}Distance = {$Prefix}Distance % 2;
**|        end;
**|#DefineRexx
**+--------------------------------------------------------------------------
#endif                 /* (Saturday 07/08/1999, 20:32:20, by Dennis_Bareis) */


#endif





