;----------------------------------------------------------------------------
;     MODULE NAME:   FILEINFO.H
;
;         $Author:   Dennis_Bareis  $
;       $Revision:   1.1  $
;           $Date:   03 Jan 2000 09:17:48  $
;        $Logfile:   E:/DB/PVCS.IT/OS2/PPWIZARD/FILEINFO.H_V  $
;
;     DESCRIPTION:   This header allows you to easily verify the existance
;                    of a local file, and assuming you have a foolproof way
;                    of transferring changes to your ISP's server (that is
;                    you have automated the process using a product such as
;                    "sitecopy") then this will have validated the existance
;                    on the server as well (at the very least you have not
;                    miskeyed the name of the download etc).
;
;                    The header makes NO assumptions about the position on
;                    the server versus its position on the local filesystem.
;                    If the relative position on the local filesystem (to the
;                    current directory) was the same as the relative position
;                    on the server from the generated html then a path need
;                    not be specified.  If you do need to specify a path it
;                    can either be with the file (and can therefore handle
;                    more than one local path) or you can make use of the
;                    default path definition ("FILEINFO_DEFAULT_PATH").
;                    If the path definition is supplied it must end with a
;                    slash.
;
;                    If all your file information is to be generated in a
;                    different font (or bold, italic etc) then you can make
;                    use of the "FONT" related definitions, by default they
;                    are only suitable for html generation and make the font
;                    slightly smaller.  You can also create empty values if
;                    you don't wish the font to change.  You could create
;                    your own "front end" such as this one (for html):
;
;                         #define  BoldSizeOfFile <B><$SizeOfFile {$?}></B>
;
;                    Note that there are 2 levels of default, the #define
;                    values set the default for all the macros while the
;                    "SFONT" and "EFONT" parameters can be used to specify
;                    the complete start and end font tags on an individual
;                    use.
;----------------------------------------------------------------------------


;--- Start of Header (include only once) ------------------------------------
#ifndef VERSION_FILEINFO_H
        #define   VERSION_FILEINFO_H    99.358
        #require  99.311


;--- Defaults ---------------------------------------------------------------
#ifndef    FILEINFO_DEFAULT_PATH
           #define FILEINFO_DEFAULT_PATH           ;;No path by default (note filename can contain all or partial path)
#endif
#ifndef    FILEINFO_FONT
           #define FILEINFO_FONT  <FONT SIZE="-1"> ;;Can be empty for no font change!
#endif
#ifndef    FILEINFO_/FONT
           #define FILEINFO_/FONT </FONT>          ;;Can be empty for no font change!
#endif
#ifndef    FILEINFO_AM
           #define FILEINFO_AM    am               ;;Change to whatever you wish
#endif
#ifndef    FILEINFO_PM
           #define FILEINFO_PM    pm               ;;Change to whatever you wish
#endif


;--- Code to validate and format file information ---------------------------
#DefineRexx RexxVerifyLocalInputFile
            ;--- Allow specification of file with relative url dir ----------
            #if '<?OpSys>' = 'UNIX'
                LocalFile = "{$PATH='<$FILEINFO_DEFAULT_PATH>'}{$File}";
            #elseif
                LocalFile = ReplaceString("{$PATH='<$FILEINFO_DEFAULT_PATH>'}{$File}", "/", "\");
            #endif

            ;--- Make sure the file exists ----------------------------------
            if stream(LocalFile, "c", "query exists") = '' then
               Error('The file "' || LocalFile || '" does not exist!');

            ;--- Mark as input dependancy -----------------------------------
            call AddInputFileToDependancyList LocalFile;
#DefineRexx
#DefineRexx RexxSizeOfFile
            RxFileSize    = stream(LocalFile, "c", "query size");
            RxFileSizeCma = AddCommasToDecimalNumber(RxFileSize);
#DefineRexx
#DefineRexx RexxDateOfFile
            ;--- Get file date/time -----------------------------------------
            RxFileStamp   = GetFileTimeStamp(LocalFile);

            ;--- Format the date (3 NOV 1999) -------------------------------
            RxFileDay     = substr(RxFileStamp, 7, 2) + 0; ;;Remove leading '0'
            RxFileMonth   = substr(RxFileStamp, 5, 2);
           ;RxFileYear    = substr(RxFileStamp, 1, 4);    ;;4 digit
            RxFileYear    = substr(RxFileStamp, 3, 2);    ;;2 digit
            RxFileMon     = word('Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec', RxFileMonth);
            RxFileTime    = RxFileDay || ' ' || RxFileMon || ' ' || RxFileYear;
#DefineRexx
#DefineRexx RexxTimeOfFile
            ;--- Get file date/time -----------------------------------------
            RxFileStamp   = GetFileTimeStamp(LocalFile);

            ;--- Format the date (3 NOV 1999) -------------------------------
            RxFileHour    = substr(RxFileStamp, 9,  2) + 0; ;;Remove leading '0'
            RxFileMinute  = substr(RxFileStamp, 11, 2);
            if RxFileHour < 12 then
               RxAmPm = '<$FILEINFO_AM>';
            else
               RxAmPm = '<$FILEINFO_PM>';
            if RxFileHour > 12 then
               RxFileHour = RxFileHour - 12;
            RxFileTime    = RxFileHour || ':' || RxFileMinute || RxAmPm;
#DefineRexx

;--- Specialized macros -----------------------------------------------------
#define   SizeOfFile                                                           \
          #evaluate+  ^^ ^<$RexxVerifyLocalInputFile {$?}>;<$RexxSizeOfFile>^ -\
          {$SFONT=^<$FILEINFO_FONT>^}                                         -\
                {$Before=""}<??RxFileSizeCma> bytes{$After=""}                -\
          {$EFONT=^<$FILEINFO_/FONT>^}
#define   DateOfFile                                                           \
          #evaluate+  ^^ ^<$RexxVerifyLocalInputFile {$?}>;<$RexxDateOfFile>^ -\
          {$SFONT=^<$FILEINFO_FONT>^}                                         -\
                {$Before=""}<??RxFileTime>{$After=""}                         -\
          {$EFONT=^<$FILEINFO_/FONT>^}
#define   TimeOfFile                                                           \
          #evaluate+  ^^ ^<$RexxVerifyLocalInputFile {$?}>;<$RexxTimeOfFile>^ -\
          {$SFONT=^<$FILEINFO_FONT>^}                                         -\
                {$Before=""}<??RxFileTime>{$After=""}                         -\
          {$EFONT=^<$FILEINFO_/FONT>^}

;--- Information in (brackets) ----------------------------------------------
#define   (SizeOfFile) <$SizeOfFile {$?} BEFORE="(" AFTER=")">
#define   (DateOfFile) <$DateOfFile {$?} BEFORE="(" AFTER=")">


;--- End of Header ----------------------------------------------------------
#endif



