diff -urP /mule-1.1/etc/emacsclient.c ./etc/emacsclient.c
--- /mule-1.1/etc/emacsclient.c	Fri May 28 22:55:08 1993
+++ ./etc/emacsclient.c	Tue Mar 15 06:42:12 1994
@@ -33,7 +33,92 @@
 #undef close
 #endif
 
+#if defined (OS2)
 
+#define INCL_DOS
+#include <os2.h>
+#include <stdio.h>
+#include <stdlib.h>
+
+static void error (ULONG rc, const char *fun)
+{
+    (void)fprintf (stderr, "%s failed, rc=%lu\n", fun, rc) ;
+    exit (1);
+}
+
+#define ERROR(fun) if (rc != 0) error (rc, fun)
+
+int main (int argc, char *argv[])
+{
+    int		i, done ;
+    ULONG	rc, len ;
+    HQUEUE	hq_client, hq_server ;
+    PID		owner_pid ;
+    REQUESTDATA request ;
+    BYTE	priority ;
+    PVOID	data ;
+    char	string[1024], *p ;
+
+    _wildcard (&argc, &argv) ;
+    if (argc < 2) {
+	(void)fprintf (stderr, "Usage: %s filename\n", argv[0]) ;
+	return 1 ;
+    }
+    (void)sprintf (string, "/queues/emacs/clients/%d", (int)getpid ()) ;
+    rc = DosCreateQueue (&hq_client, QUE_FIFO | QUE_CONVERT_ADDRESS, string) ;
+    ERROR ("DosCreateQueue") ;
+    rc = DosOpenQueue (&owner_pid, &hq_server, "/queues/emacs/server") ;
+    ERROR ("DosOpenQueue") ;
+    len = 2 ;
+    for (i = 1; i < argc; i++) {
+	if (argv[i][0] == '+')
+	    strcpy (string, argv[i]) ;
+	else
+	    _abspath (string, argv[i], sizeof (string)) ;
+	len += strlen (string) + 1 ;
+    }
+    rc = DosAllocSharedMem (&data, 0, len,
+			  PAG_COMMIT | OBJ_GIVEABLE | PAG_READ | PAG_WRITE) ;
+    ERROR ("DosAllocSharedMem") ;
+    rc = DosGiveSharedMem (data, owner_pid, PAG_READ) ;
+    ERROR ("DosGiveSharedMem") ;
+    p = data ;
+    for (i = 1; i < argc; ++i) {
+	if (argv[i][0] == '+')
+	    strcpy (string, argv[i]) ;
+	else
+	    _abspath (string, argv[i], sizeof (string)) ;
+	(void)strcpy (p, string) ;
+	p += strlen (string) ;
+	*p++ = ' ' ;
+    }
+    *p++ = '\n' ;
+    *p = 0 ;
+    rc = DosWriteQueue (hq_server, 0, len, data, 0) ;
+    ERROR ("DosWriteQueue") ;
+    rc = DosFreeMem (data) ;
+    ERROR ("DosFreeMem") ;
+
+    (void)printf ("Waiting for Emacs...") ;
+    (void)fflush (stdout) ;
+    do {
+	rc = DosReadQueue (hq_client, &request, &len, &data, 0,
+			   DCWW_WAIT, &priority, 0) ;
+	ERROR ("DosReadQueue") ;
+	(void)fputs (data, stdout) ;
+	done = (memcmp ("Close:", data, 6) == 0) ;
+	rc = DosFreeMem (data) ;
+	ERROR ("DosFreeMem") ;
+    } while (!done) ;
+    rc = DosCloseQueue (hq_server) ;
+    ERROR ("DosCloseQueue") ;
+    rc = DosCloseQueue (hq_client) ;
+    ERROR ("DosCloseQueue") ;
+    return 0 ;
+}
+
+#else /* not OS2 */
+
 #if !defined(BSD) && !defined(HAVE_SYSVIPC) && !defined(HAVE_SOCKETS)
 #include <stdio.h>
 
@@ -287,3 +372,5 @@
 #endif /* HAVE_SYSVIPC */
 
 #endif /* BSD or HAVE_SYSVIPC */
+
+#endif /* OS2 */
diff -urP /mule-1.1/etc/env.c ./etc/env.c
--- /mule-1.1/etc/env.c	Wed Apr 15 21:36:20 1992
+++ ./etc/env.c	Sat Sep 25 13:05:26 1993
@@ -82,6 +82,10 @@
 
 */
 
+#ifdef OS2
+#include <signal.h>
+#endif
+
 #ifdef EMACS
 #define NO_SHORTNAMES
 #include "../src/config.h"
@@ -90,7 +94,12 @@
 #include <stdio.h>
 #include <errno.h>
 
+#ifdef OS2
+#include <process.h>
+#include <fcntl.h>
+#else
 extern int execvp ();
+#endif
 extern char *index ();
 
 char *xmalloc (), *xrealloc ();
@@ -105,6 +114,20 @@
 void setenv ();
 void fatal ();
 
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+
+static int child = -1;
+
+static void handler (int sig)
+    {
+    if (child >= 0)
+        kill (-child, sig);
+    signal (sig, SIG_ACK);
+    }
+#endif
+/* end of patch */
+
 main (argc, argv, envp)
      register int argc;
      register char **argv;
@@ -112,6 +135,11 @@
 {
   register char *tem;
 
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  setmode(0, O_BINARY);
+  setmode(1, O_BINARY);
+  signal (SIGINT, handler);
+#endif
   progname = argv[0];
   argc--;
   argv++;
@@ -201,7 +229,18 @@
       extern char *sys_errlist[];
 
       environ = nenv;
+#ifdef OS2
+/* Wait for subprocess to keep this process alive */
+/* Otherwise, Emacs would think the program ended when env ended */
+      child = spawnvp (P_NOWAIT, *argv, (const char * const *)argv);
+      if (child >= 0)
+	{
+	  wait (0);
+	  exit (0);
+	}
+#else
       (void) execvp (*argv, argv);
+#endif
 
       fprintf (stderr, "%s: Cannot execute \"%s\"",
 	       progname, *argv);
diff -urP /mule-1.1/etc/killtree.c ./etc/killtree.c
--- /mule-1.1/etc/killtree.c
+++ ./etc/killtree.c	Mon Sep 27 19:06:06 1993
@@ -0,0 +1,148 @@
+/* Communication subprocess for GNU Emacs acting as server.
+   Copyright (C) 1986, 1987, 1993 Free Software Foundation, Inc.
+
+This file is part of GNU Emacs.
+
+GNU Emacs is free software; you can redistribute it and/or modify
+it under the terms of the GNU General Public License as published by
+the Free Software Foundation; either version 1, or (at your option)
+any later version.
+
+GNU Emacs is distributed in the hope that it will be useful,
+but WITHOUT ANY WARRANTY; without even the implied warranty of
+MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+GNU General Public License for more details.
+
+You should have received a copy of the GNU General Public License
+along with GNU Emacs; see the file COPYING.  If not, write to
+the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
+
+#define	INCL_DOS
+#include <os2.h>
+#include <stdio.h>
+#include <stdlib.h>
+#include <process.h>
+
+#define	PROC_COUNT	1024
+
+/* #define DEBUG	1 */
+
+char		TempFileName[512] ;
+unsigned char	Buf[2048] ;
+FILE		*in ;
+PID		KillPid ;
+PID		KillProcessTable[512] ;
+int		KillProcessTablePoint = 0 ;
+PID		Pid[PROC_COUNT] ;
+PID		Child[PROC_COUNT] ;
+int		ProcessCount = 0 ;
+
+
+
+/****************************************/
+/*					*/
+/*	qvZXID		*/
+/*					*/
+/* pid	evZXID			*/
+/*					*/
+/****************************************/
+ScanChild( PID pid )
+{
+    int		loop ;
+
+    for ( loop = 0 ; loop < ProcessCount; ++loop ) {
+	if ( pid == Child[loop] ) {
+	    KillProcessTable[KillProcessTablePoint++] = Pid[loop] ;
+	    ScanChild( Pid[loop] ) ;
+	}
+    }
+}
+
+/****************************************/
+/*					*/
+/*@vZXIDe|u\|gf	*/
+/*					*/
+/****************************************/
+int PidSort( PID *pid1, PID *pid2 )
+{
+    if ( *pid1 > *pid2 )
+	return -1 ;
+    if ( *pid1 < *pid2 )
+	return 1 ;
+    return 0 ;
+}
+
+/********************************************************/
+/*							*/
+/*		C				*/
+/*							*/
+/* 3Ԗڂ̈ "-c" tƎqvZX݂̂E	*/
+/*							*/
+/********************************************************/
+main( int argc, char **argv )
+{
+    PID		pid, child ;
+    int		loop ;
+    ULONG	ret ;
+    int		childonly ;
+    char	*tmp ;
+
+    if ( argc < 3 )
+	DosExit( EXIT_PROCESS, 1 ) ;
+
+    if ( argc == 3 ) {
+	if ( strcmp( argv[2], "-c" ) == 0 )
+	    childonly = 1 ;
+	else
+	    childonly = 0 ;
+    }
+    if ( ( tmp = getenv( "TMPDIR" ) ) == NULL )
+	if ( ( tmp = getenv( "TMP" ) ) == NULL )
+	    if ( ( tmp = getenv( "TMEP" ) ) == NULL )
+		tmp = "./" ;
+    strcpy( TempFileName, tmp ) ;
+    loop = strlen( TempFileName ) ; 
+    if ( !(TempFileName[loop-1] == '/' || TempFileName[loop-1] == '\\') )
+	strcat( TempFileName, "/" ) ;
+    strcat( TempFileName, "killtree.tmp" ) ;
+
+    sscanf( argv[1], "%d", &KillPid ) ;
+#ifdef DEBUG
+    printf( "kill process = %d (0x%x)\n", KillPid, KillPid ) ;
+    fflush(stdout);
+    printf( "%s\n", TempFileName ) ;
+    fflush(stdout);
+#endif
+    sprintf( Buf, "pstat/c > %s", TempFileName ) ;
+    system( Buf ) ;
+    in = fopen( TempFileName, "r" ) ;
+
+    /* ^Cgǂݔ΂ */
+    for ( loop = 0; loop < 5; ++loop )
+	fgets( Buf, 2048, in ) ;
+
+    /* vZXe|u쐬 */
+    while ( ( fgets( Buf, 2048, in ) ) != 0 ) {
+	if ( Buf[1] == ' ' )
+	    continue ;
+	sscanf( Buf, "%x %x", &Pid[ProcessCount], &Child[ProcessCount] ) ;
+	++ProcessCount ;
+    }
+    fclose( in ) ;
+    unlink( TempFileName ) ;
+
+    if ( childonly ) {
+	KillProcessTablePoint = 0 ;
+    } else {
+	KillProcessTable[0] = KillPid ;
+	KillProcessTablePoint = 1 ;
+    }
+    ScanChild( KillPid ) ;
+    qsort(KillProcessTable, KillProcessTablePoint, sizeof( PID ), PidSort ) ;
+    for ( loop = 0; loop < KillProcessTablePoint; ++loop ) {
+#ifdef DEBUG
+	printf( "%d ", KillProcessTable[loop] ) ;
+#endif
+	DosKillProcess( DKP_PROCESS, KillProcessTable[loop] ) ;
+    }
+}
diff -urP /mule-1.1/etc/make-docfile.c ./etc/make-docfile.c
--- /mule-1.1/etc/make-docfile.c	Wed Apr 15 21:36:10 1992
+++ ./etc/make-docfile.c	Sat Sep 25 07:06:48 1993
@@ -48,12 +48,20 @@
   i = 1;
   if (argc > i + 1 && !strcmp (argv[i], "-o"))
     {
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+      outfile = fopen (argv[i + 1], "wb");
+#else
       outfile = fopen (argv[i + 1], "w");
+#endif
       i += 2;
     }
   if (argc > i + 1 && !strcmp (argv[i], "-a"))
     {
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+      outfile = fopen (argv[i + 1], "ab");
+#else
       outfile = fopen (argv[i + 1], "a");
+#endif
       i += 2;
     }
 
@@ -282,6 +290,11 @@
   register char *p;
   int defvarflag;
 
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  if (strstr(filename, ".elc") != 0 )
+    infile = fopen (filename, "rb");
+  else
+#endif
   infile = fopen (filename, "r");
   if (infile == NULL)
     {
diff -urP /mule-1.1/etc/Makefile.os2 ./etc/Makefile.os2
--- /mule-1.1/etc/Makefile.os2
+++ ./etc/Makefile.os2	Sun Nov 21 14:34:14 1993
@@ -0,0 +1,187 @@
+# For Solaris2. Needed for emacsclient
+#  LOADLIBES= -lsocket -lnsl -lelf
+# For Xenix.  Needed for movemail
+#  LOADLIBES= -lx
+# For Mips.  Needed for who knows what.
+#  CFLAGS = -g -systype bsd43
+
+# 92.3.31  modified for Mule Ver.0.9.2 by K.Handa <handa@etl.go.jp>
+#	Sun console feature added.
+# 92.6.26  modified for Mule Ver.0.9.5 by K.Handa <handa@etl.go.jp>
+#	bdftoscf uses BDF files defined by macro BDF_FILES in this file.
+# 92.6.26  modified for Mule Ver.0.9.5
+#		by T.Shimokawa <toshi@isl.rdc.toshiba.co.jp>
+#	font.scf is created by calling "./bdftoscf".
+# 92.8.6   modified for Mule Ver.0.9.6
+#		by S.Kobayashi <koba@keisu-s.t.u-tokyo.ac.jp>
+#	font.scf is removed under the target clean and distclean.
+# 92.10.14 modified for Mule Ver.0.9.6 by K.Handa <handa@etl.go.jp>
+#	font.scf is now not used, and bdfstaff and m2ps are added.
+# 92.10.30 modified for Mule Ver.0.9.6 by K.Handa <handa@etl.go.jp>
+#	Name change --  bdfstaff->bdf
+# 92.10.30 modified for Mule Ver.0.9.7 by K.Handa <handa@etl.go.jp>
+#	Change of the way to compile bdf.c.
+# 93.2.10  modified for Mule Ver.0.9.7.1 by K.Handa <handa@etl.go.jp>
+#	'distclean' should clean all.
+# 93.5.7  modified for Mule Ver.0.9.8 by K.Handa <handa@etl.go.jp>
+#	Support HEBREW and BIG5.
+#	bdf.o depends on ../src/codeconv.h.
+# 93.6.25 modified for Mule Ver.0.9.8 by K.Handa <handa@etl.go.jp>
+#	Name change: charsets -> charset.
+# 93.6.27  modified for Mule Ver.0.9.8 by K.Handa <handa@etl.go.jp>
+#	m2ps depends on config.h and mule.h, compiled with ${LOADLIBS}
+# 93.7.17  modified for Mule Ver.0.9.8
+#			by Koaunghi Un <zraun01@hpserv.zdv.uni-tuebingen.de>
+#	For Linux, /bin/sed -> sed.
+# 93.7.27  modified for Mule Ver.0.9.8 by T.Saneto <sanewo@pdp.crl.sony.co.jp>
+#	No need of ${LOADLIBS} for bdf.o.
+
+CC=gcc
+CFLAGS= -g -DOS2
+
+EXECUTABLES = test-distrib.exe etags.exe ctags.exe wakeup.exe \
+	make-docfile.exe digest-doc.exe sorted-doc.exe \
+	movemail.exe cvtmail.exe sendmailuupc.exe yow.exe env.exe \
+	server.exe emacsclient.exe killtree.exe
+#	m2ps.exe
+
+all: ${EXECUTABLES}
+
+clean:
+	-rm -f ${EXECUTABLES} core
+
+distclean:
+	-rm -f ${EXECUTABLES} *~ \#* DOC* core bdf.o mule.1 m2ps.1 charset CHARSETS
+
+# This justs verifies that the non-ASCII characters
+# in the file `testfile' have no been clobbered by
+# whatever means were used to copy and distribute Emacs.
+# If they were clobbered, all the .elc files were clobbered too.
+test-distrib.exe: test-distrib.c
+	$(CC) -o test-distrib.exe test-distrib.c
+	./test-distrib
+
+etags.exe: etags.c
+	$(CC) -o etags.exe ${CFLAGS} -DETAGS etags.c $(LOADLIBES)
+
+ctags.exe: etags.c
+	$(CC) -o ctags.exe ${CFLAGS} -DCTAGS etags.c $(LOADLIBES)
+
+wakeup.exe: wakeup.c
+	$(CC) -o wakeup.exe ${CFLAGS} wakeup.c $(LOADLIBES)
+
+make-docfile.exe: make-docfile.c
+	$(CC) -o make-docfile.exe ${CFLAGS} make-docfile.c $(LOADLIBES)
+
+digest-doc.exe: digest-doc.c
+	$(CC) -o digest-doc.exe ${CFLAGS} digest-doc.c $(LOADLIBES)
+
+sorted-doc.exe: sorted-doc.c
+	$(CC) -o sorted-doc.exe ${CFLAGS} sorted-doc.c $(LOADLIBES)
+
+movemail.exe: movemailuupc.c ../src/config.h
+	$(CC) -o movemail.exe ${CFLAGS} movemailuupc.c $(LOADLIBES)
+
+cvtmail.exe: cvtmail.c
+#	@echo Can't create cvtmail.exe !!!
+#	$(CC) -o cvtmail ${CFLAGS} cvtmail.c $(LOADLIBES)
+
+#fakemail.exe: fakemail.c ../src/config.h
+#	@echo Can't create fakemail.exe !!!
+#	$(CC) -o fakemail.exe ${CFLAGS} fakemail.c $(LOADLIBES)
+
+sendmailuupc.exe: sendmailuupc.c
+	$(CC) -o sendmailuupc.exe ${CFLAGS} sendmailuupc.c $(LOADLIBES)
+
+yow.exe: yow.c ../src/paths.h
+	$(CC) -o yow.exe ${CFLAGS} yow.c $(LOADLIBES)
+
+# this is silly -- just use emacs to edit this file!
+# (in any case this program doesn't preserve alphabetical ordering,
+#  which is why I'm removing it)
+#addyow: addyow.c
+#	$(CC) -o addyow ${CFLAGS} addyow.c
+
+env.exe: env.c ../src/config.h
+	$(CC) -o env.exe -DEMACS ${CFLAGS} env.c $(LOADLIBES)
+
+server.exe: server.c ../src/config.h
+	$(CC) -o server.exe ${CFLAGS} server.c $(LOADLIBES)
+
+emacsclient.exe: emacsclient.c ../src/config.h
+	$(CC) -o emacsclient.exe ${CFLAGS} emacsclient.c $(LOADLIBES)
+
+killtree.exe: killtree.c
+	$(CC) -o killtree.exe ${CFLAGS} killtree.c $(LOADLIBES)
+
+# This one is NOT included in EXECUTABLES.
+# See ../src/ymakefile.
+emacstool: emacstool.c
+	$(CC) -o emacstool ${CFLAGS} emacstool.c -lsuntool -lsunwindow -lpixrect $(LOADLIBES)
+
+nemacstool: emacstool.c
+	$(CC) -o nemacstool ${CFLAGS} -DJLE emacstool.c -lsuntool -lmle -lsunwindow -lpixrect $(LOADLIBES)	# For SUN Japanese Language Environment
+
+xvetool: emacstool.c
+	$(CC) -o xvetool ${CFLAGS} -DXVIEW         emacstool.c -lxview -lolgx -lX -I$(OPENWINHOME)/include -L$(OPENWINHOME)/lib $(LOADLIBES)
+
+xveterm: emacstool.c
+	$(CC) -o xveterm ${CFLAGS} -DXVIEW -DTTERM emacstool.c -lxview -lolgx -lX -I$(OPENWINHOME)/include -L$(OPENWINHOME)/lib $(LOADLIBES)
+
+# 92.6.26, 92.10.14 by K.Handa
+XV11R5 = /usr/share/src/X.V11R5
+BDF_PATH = -DBDF_PATH=\"${XV11R5}/mit/fonts/bdf/misc,${XV11R5}/contrib/clients/cxterm/fonts,/usr/share/fonts/X11/ETL,/usr/share/fonts/X11/cxterm\"
+# Each one-byte font may have encoding information as
+#	bdf_file_name:encoding
+# where encoding is 0 or 1 and defaults to 0.
+# You also can specify or override the following definitions
+# by manually editing 'CHARSETS'.
+ASCII = etl24-latin1.bdf:0
+LATIN1 = etl24-latin1.bdf:1
+LATIN2 = etl24-latin2.bdf:1
+LATIN3 = etl24-latin3.bdf:1
+LATIN4 = etl24-latin4.bdf:1
+GREEK = etl24-greek.bdf:1
+HEBREW = etl24-hebrew.bdf:1
+KANA = 12x24rk.bdf:1
+ROMAN = 12x24rk.bdf:0
+CYRILLIC = etl24-cyrillic.bdf:1
+LATIN5 = etl24-latin5.bdf:1
+CHINESE = cclib24st.bdf
+JAPANESE = jiskan24.bdf
+KOREAN = hanglm24.bdf
+BIG5 = taipei24.bdf:1
+SISHENG = etl24-sisheng.bdf:0
+THAI = etl24-thai.bdf:1
+
+SED_SCRIPT =\
+	-e "/LC:BYTES:/s/\(.*\)/\1[:BDF-FILE[:ENCODING]]/" \
+	-e "/ASCII$$/s/\(.*\)/\1:${ASCII}/" \
+	-e "/Latin-1$$/s/\(.*\)/\1:${LATIN1}/" \
+	-e "/Latin-2$$/s/\(.*\)/\1:${LATIN2}/" \
+	-e "/Latin-3$$/s/\(.*\)/\1:${LATIN3}/" \
+	-e "/Latin-4$$/s/\(.*\)/\1:${LATIN4}/" \
+	-e "/Greek$$/s/\(.*\)/\1:${GREEK}/" \
+	-e "/Hebrew$$/s/\(.*\)/\1:${HEBREW}/" \
+	-e "/Katakana$$/s/\(.*\)/\1:${KANA}/" \
+	-e "/Roman$$/s/\(.*\)/\1:${ROMAN}/" \
+	-e "/Cyrillic$$/s/\(.*\)/\1:${CYRILLIC}/" \
+	-e "/Latin-5$$/s/\(.*\)/\1:${LATIN5}/" \
+	-e "/Chinese$$/s/\(.*\)/\1:${CHINESE}/" \
+	-e "/Japanese$$/s/\(.*\)/\1:${JAPANESE}/" \
+	-e "/Korean$$/s/\(.*\)/\1:${KOREAN}/" \
+	-e "/Big5/s/\(.*\)/\1:${BIG5}/" \
+	-e "/ZhuYin$$/s/\(.*\)/\1:${SISHENG}/" \
+	-e "/TSCII$$/s/\(.*\)/\1:${THAI}/"
+
+CHARSETS: charset
+	sed ${SED_SCRIPT} < charset > CHARSETS
+
+bdf.o: bdf.c bdf.h Makefile\
+	../src/config.h ../src/mule.h ../src/paths.h ../src/codeconv.h
+	$(CC) -c ${CFLAGS} bdf.c ${BDF_PATH}
+
+#m2ps: bdf.h m2ps.c bdf.o ../src/config.h ../src/mule.h ../src/paths.h
+#	-$(CC) -o m2ps ${CFLAGS} m2ps.c bdf.o ${LOADLIBES}
+
+# end of patch
diff -urP /mule-1.1/etc/movemailuupc.c ./etc/movemailuupc.c
--- /mule-1.1/etc/movemailuupc.c
+++ ./etc/movemailuupc.c	Tue Jan 18 16:51:24 1994
@@ -0,0 +1,839 @@
+/* movemail foo bar -- move file foo to file bar,
+   locking file foo the way /bin/mail respects.
+   Copyright (C) 1986 Free Software Foundation, Inc.
+
+This file is part of GNU Emacs.
+
+GNU Emacs is free software; you can redistribute it and/or modify
+it under the terms of the GNU General Public License as published by
+the Free Software Foundation; either version 1, or (at your option)
+any later version.
+
+GNU Emacs is distributed in the hope that it will be useful,
+but WITHOUT ANY WARRANTY; without even the implied warranty of
+MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+GNU General Public License for more details.
+
+You should have received a copy of the GNU General Public License
+along with GNU Emacs; see the file COPYING.  If not, write to
+the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
+
+/* Important notice: defining MAIL_USE_FLOCK *will cause loss of mail*
+   if you do it on a system that does not normally use flock as its way of
+   interlocking access to inbox files.  The setting of MAIL_USE_FLOCK
+   *must agree* with the system's own conventions.
+   It is not a choice that is up to you.
+
+   So, if your system uses lock files rather than flock, then the only way
+   you can get proper operation is to enable movemail to write lockfiles there.
+   This means you must either give that directory access modes
+   that permit everyone to write lockfiles in it, or you must make movemail
+   a setuid or setgid program.  */
+
+/*
+ * Modified January, 1986 by Michael R. Gretzinger (Project Athena)
+ *
+ * Added POP (Post Office Protocol) service.  When compiled -DPOP
+ * movemail will accept input filename arguments of the form
+ * "po:username".  This will cause movemail to open a connection to
+ * a pop server running on $MAILHOST (environment variable).  Movemail
+ * must be setuid to root in order to work with POP.
+ * 
+ * New module: popmail.c
+ * Modified routines:
+ *	main - added code within #ifdef MAIL_USE_POP; added setuid (getuid ())
+ *		after POP code. 
+ * New routines in movemail.c:
+ *	get_errmsg - return pointer to system error message
+ *
+ */
+
+#include <sys/types.h>
+#include <sys/stat.h>
+#include <sys/file.h>
+#include <errno.h>
+#define NO_SHORTNAMES   /* Tell config not to load remap.h */
+#include "../src/config.h"
+
+#ifdef USG
+#include <fcntl.h>
+#include <unistd.h>
+#ifndef F_OK
+#define F_OK 0
+#define X_OK 1
+#define W_OK 2
+#define R_OK 4
+#endif
+#endif /* USG */
+
+#ifdef XENIX
+#include <sys/locking.h>
+#endif
+
+#ifdef MAIL_USE_MMDF
+extern int lk_open (), lk_close ();
+#endif
+
+/* Cancel substitutions made by config.h for Emacs.  */
+#undef open
+#undef read
+#undef write
+#undef close
+
+#ifdef OS2
+#include <stdio.h>
+#endif
+
+char *concat ();
+extern int errno;
+
+/* Nonzero means this is name of a lock file to delete on fatal error.  */
+char *delete_lockname;
+
+main (argc, argv)
+     int argc;
+     char **argv;
+{
+  char *inname, *outname;
+  int indesc, outdesc;
+  char buf[1024];
+  int nread;
+#ifdef OS2
+  FILE *infp, *outfp ;
+#endif
+
+#ifndef MAIL_USE_FLOCK
+  struct stat st;
+  long now;
+  int tem;
+  char *lockname, *p;
+  char *tempname;
+  int desc;
+#endif /* not MAIL_USE_FLOCK */
+
+  delete_lockname = 0;
+
+  if (argc < 3)
+    fatal ("two arguments required");
+
+  inname = argv[1];
+  outname = argv[2];
+
+#ifdef MAIL_USE_MMDF
+  mmdf_init (argv[0]);
+#endif
+
+  /* Check access to output file.  */
+  if (access (outname, F_OK) == 0 && access (outname, W_OK) != 0)
+    pfatal_with_name (outname);
+
+#ifndef OS2
+  /* Also check that outname's directory is writeable to the real uid.  */
+  {
+    char *buf = (char *) malloc (strlen (outname) + 1);
+    char *p, q;
+    strcpy (buf, outname);
+    p = buf + strlen (buf);
+    while (p > buf && p[-1] != '/')
+      *--p = 0;
+    if (p == buf)
+      *p++ = '.';
+
+    printf( "buf = %s\n",buf);
+
+    if (access (buf, W_OK) != 0)
+      pfatal_with_name (buf);
+    free (buf);
+  }
+#endif
+
+#ifdef MAIL_USE_POP
+  if (!bcmp (inname, "po:", 3))
+    {
+      int status; char *user;
+
+      user = (char *) rindex (inname, ':') + 1;
+      status = popmail (user, outname);
+      exit (status);
+    }
+
+  setuid (getuid ());
+#endif /* MAIL_USE_POP */
+
+  /* Check access to input file.  */
+  if (access (inname, R_OK | W_OK) != 0)
+    pfatal_with_name (inname);
+
+#ifndef MAIL_USE_MMDF
+#ifndef MAIL_USE_FLOCK
+  /* Use a lock file named /usr/spool/mail/$USER.lock:
+     If it exists, the mail file is locked.  */
+  /* Note: this locking mechanism is *required* by the mailer
+     (on systems which use it) to prevent loss of mail.
+
+     On systems that use a lock file, extracting the mail without locking
+     WILL occasionally cause loss of mail due to timing errors!
+
+     So, if creation of the lock file fails
+     due to access permission on /usr/spool/mail,
+     you simply MUST change the permission
+     and/or make movemail a setgid program
+     so it can create lock files properly.
+
+     You might also wish to verify that your system is one
+     which uses lock files for this purpose.  Some systems use other methods.
+
+     If your system uses the `flock' system call for mail locking,
+     define MAIL_USE_FLOCK in config.h or the s-*.h file
+     and recompile movemail.  If the s- file for your system
+     should define MAIL_USE_FLOCK but does not, send a bug report
+     to bug-gnu-emacs@prep.ai.mit.edu so we can fix it.  */
+
+  lockname = concat (inname, ".lock", "");
+  tempname = (char *) xmalloc (strlen (inname) + 20);
+  strcpy (tempname, inname);
+  p = tempname + strlen (tempname);
+  while (p != tempname && p[-1] != '/')
+    p--;
+  *p = 0;
+  strcpy (p, "EXXXXXX");
+  mktemp (tempname);
+  unlink (tempname);
+
+  while (1)
+    {
+      /* Create the lock file, but not under the lock file name.  */
+      /* Give up if cannot do that.  */
+      desc = open (tempname, O_WRONLY | O_CREAT, 0666);
+      if (desc < 0)
+        pfatal_with_name ("lock file--see source file etc/movemail.c");
+      close (desc);
+
+      /*osamu debug
+      tem = link (tempname, lockname);*/
+      unlink (tempname);
+      if (tem >= 0)
+	break;
+      sleep (1);
+
+      /* If lock file is a minute old, unlock it.  */
+      if (stat (lockname, &st) >= 0)
+	{
+	  now = time (0);
+	  if (st.st_ctime < now - 60)
+	    unlink (lockname);
+	}
+    }
+
+  delete_lockname = lockname;
+#endif /* not MAIL_USE_FLOCK */
+
+#ifndef OS2
+#ifdef MAIL_USE_FLOCK
+  indesc = open (inname, O_RDWR);
+#else /* if not MAIL_USE_FLOCK */
+  indesc = open (inname, O_RDONLY);
+#endif /* not MAIL_USE_FLOCK */
+#else /* OS2 */
+  infp = fopen (inname, "r");
+  if (infp == NULL )
+    pfatal_with_name (inname);
+#endif /* OS2 */
+#else /* MAIL_USE_MMDF */
+  indesc = lk_open (inname, O_RDONLY, 0, 0, 10);
+#endif /* MAIL_USE_MMDF */
+#ifndef OS2
+  if (indesc < 0)
+    pfatal_with_name (inname);
+#endif
+
+#if defined (BSD) || defined (XENIX)
+  /* In case movemail is setuid to root, make sure the user can
+     read the output file.  */
+  /* This is desirable for all systems
+     but I don't want to assume all have the umask system call */
+  umask (umask (0) & 0333);
+#endif /* BSD or Xenix */
+
+#ifndef OS2
+  outdesc = open (outname, O_WRONLY | O_CREAT | O_EXCL, 0666);
+  if (outdesc < 0)
+    pfatal_with_name (outname);
+#else
+  outfp = fopen (outname, "wb" ) ;
+  if (outfp == NULL)
+    pfatal_with_name (outname);
+#endif /* OS2 */
+
+#ifdef MAIL_USE_FLOCK
+#ifdef XENIX
+  if (locking (indesc, LK_RLCK, 0L) < 0) pfatal_with_name (inname);
+#else
+  if (flock (indesc, LOCK_EX) < 0) pfatal_with_name (inname);
+#endif
+#endif /* MAIL_USE_FLOCK */
+
+#ifdef OS2
+  fgets( buf, sizeof(buf), infp ) ; /* skip start line */
+  while ( fgets( buf, sizeof(buf), infp ) != NULL ) {
+      if ( *buf == (char)0x01 )
+	  strcpy( buf,"\n" ) ;
+      if ( strncmp( buf, "From ", 5 ) == 0 ) {
+	  char	from[8] ;
+	  char	name[64] ;
+	  char	youbi[8] ;
+	  char	hi[8] ;
+	  char	tuki[8] ;
+	  char	nen[8] ;
+	  char	time[16] ;
+/*
+From ibmpc-request@yinu.co.jp Fri, 22 Oct 1993 09:30:50 JST remote from yinugw
+From cla@yinu.co.jp           Sat Oct 16 17:32:47 1993
+*/
+	  sscanf( buf, "%s %s %s %s %s %s %s"
+		 , from
+		 , name
+		 , youbi
+		 , hi
+		 , tuki
+		 , nen
+		 , time
+		 ) ;
+	  youbi[strlen( youbi ) -1] = '\0' ;
+	  sprintf( buf, "%s %s %s %s %s %s %s\n"
+		 , from
+		 , name
+		 , youbi
+		 , tuki
+		 , hi
+		 , time
+		 , nen
+		 ) ;
+      }
+#ifdef DEBUG
+      printf( "%s", buf ) ;
+#endif
+      if ( fputs( buf, outfp ) ) {
+	  int saved_errno = errno;
+	  unlink (outname);
+	  errno = saved_errno;
+	  pfatal_with_name (outname);
+      }
+  }
+  fputs( "\n", outfp ) ;
+#else
+  while (1)
+    {
+      nread = read (indesc, buf, sizeof buf);
+      if (nread != write (outdesc, buf, nread))
+	{
+	  int saved_errno = errno;
+	  unlink (outname);
+	  errno = saved_errno;
+	  pfatal_with_name (outname);
+	}
+      if (nread < sizeof buf)
+	break;
+    }
+#endif
+
+#ifdef BSD
+  if (fsync (outdesc) < 0)
+    pfatal_and_delete (outname);
+#endif
+
+#ifndef OS2
+  /* Check to make sure no errors before we zap the inbox.  */
+  if (close (outdesc) != 0)
+    pfatal_and_delete (outname);
+#else /* OS2 */
+  if (fclose (outfp) != 0)
+    pfatal_and_delete (outname);
+#endif
+
+#ifdef MAIL_USE_FLOCK
+#if defined (STRIDE) || defined (XENIX)
+  /* Stride, xenix have file locking, but no ftruncate.  This mess will do. */
+  close (open (inname, O_CREAT | O_TRUNC | O_RDWR, 0666));
+#else
+  ftruncate (indesc, 0L);
+#endif /* STRIDE or XENIX */
+#endif /* MAIL_USE_FLOCK */
+
+#ifdef MAIL_USE_MMDF
+  lk_close (indesc, 0, 0, 0);
+#else
+#ifdef OS2
+  fclose( infp ) ;
+#else
+  close (indesc);
+#endif
+#endif
+
+#ifndef MAIL_USE_FLOCK
+  /* Delete the input file; if we can't, at least get rid of its contents.  */
+  if (unlink (inname) < 0)
+    if (errno != ENOENT)
+      creat (inname, 0666);
+#ifndef MAIL_USE_MMDF
+  unlink (lockname);
+#endif /* not MAIL_USE_MMDF */
+#endif /* not MAIL_USE_FLOCK */
+  exit (0);
+}
+
+/* Print error message and exit.  */
+
+fatal (s1, s2)
+     char *s1, *s2;
+{
+  if (delete_lockname)
+    unlink (delete_lockname);
+  error (s1, s2);
+  exit (1);
+}
+
+/* Print error message.  `s1' is printf control string, `s2' is arg for it. */
+
+error (s1, s2, s3)
+     char *s1, *s2, *s3;
+{
+  printf ("movemail: ");
+  printf (s1, s2, s3);
+  printf ("\n");
+}
+
+pfatal_with_name (name)
+     char *name;
+{
+  extern int errno, sys_nerr;
+  extern char *sys_errlist[];
+  char *s;
+
+  if (errno < sys_nerr)
+    s = concat ("", sys_errlist[errno], " for %s");
+  else
+    s = "cannot open %s";
+  fatal (s, name);
+}
+
+pfatal_and_delete (name)
+     char *name;
+{
+  extern int errno, sys_nerr;
+  extern char *sys_errlist[];
+  char *s;
+
+  if (errno < sys_nerr)
+    s = concat ("", sys_errlist[errno], " for %s");
+  else
+    s = "cannot open %s";
+
+  unlink (name);
+  fatal (s, name);
+}
+
+/* Return a newly-allocated string whose contents concatenate those of s1, s2, s3.  */
+
+char *
+concat (s1, s2, s3)
+     char *s1, *s2, *s3;
+{
+  int len1 = strlen (s1), len2 = strlen (s2), len3 = strlen (s3);
+  char *result = (char *) xmalloc (len1 + len2 + len3 + 1);
+
+  strcpy (result, s1);
+  strcpy (result + len1, s2);
+  strcpy (result + len1 + len2, s3);
+  *(result + len1 + len2 + len3) = 0;
+
+  return result;
+}
+
+/* Like malloc but get fatal error if memory is exhausted.  */
+
+int
+xmalloc (size)
+     int size;
+{
+  int result = malloc (size);
+  if (!result)
+    fatal ("virtual memory exhausted", 0);
+  return result;
+}
+
+/* This is the guts of the interface to the Post Office Protocol.  */
+
+#ifdef MAIL_USE_POP
+
+#include <sys/socket.h>
+#include <netinet/in.h>
+#include <netdb.h>
+#include <stdio.h>
+#include <pwd.h>
+
+#ifdef USG
+#include <fcntl.h>
+/* Cancel substitutions made by config.h for Emacs.  */
+#undef open
+#undef read
+#undef write
+#undef close
+#endif /* USG */
+
+#define NOTOK (-1)
+#define OK 0
+#define DONE 1
+
+char *progname;
+FILE *sfi;
+FILE *sfo;
+char Errmsg[80];
+
+static int debug = 0;
+
+char *get_errmsg ();
+char *getenv ();
+int mbx_write ();
+
+popmail (user, outfile)
+     char *user;
+     char *outfile;
+{
+  char *host;
+  int nmsgs, nbytes;
+  char response[128];
+  register int i;
+  int mbfi;
+  FILE *mbf;
+  struct passwd *pw = (struct passwd *) getpwuid (getuid ());
+  if (pw == NULL)
+    fatal ("cannot determine user name");
+
+  host = getenv ("MAILHOST");
+  if (host == NULL)
+    {
+      fatal ("no MAILHOST defined");
+    }
+
+  if (pop_init (host) == NOTOK)
+    {
+      fatal (Errmsg);
+    }
+
+  if (getline (response, sizeof response, sfi) != OK)
+    {
+      fatal (response);
+    }
+
+  if (pop_command ("USER %s", user) == NOTOK
+      || pop_command ("RPOP %s", pw->pw_name) == NOTOK)
+    {
+      pop_command ("QUIT");
+      fatal (Errmsg);
+    }
+
+  if (pop_stat (&nmsgs, &nbytes) == NOTOK)
+    {
+      pop_command ("QUIT");
+      fatal (Errmsg);
+    }
+
+  if (!nmsgs)
+    {
+      pop_command ("QUIT");
+      return 0;
+    }
+
+  mbfi = open (outfile, O_WRONLY | O_CREAT | O_EXCL, 0666);
+  if (mbfi < 0)
+    {
+      pop_command ("QUIT");
+      pfatal_and_delete (outfile);
+    }
+  fchown (mbfi, getuid (), -1);
+
+  if ((mbf = fdopen (mbfi, "w")) == NULL)
+    {
+      pop_command ("QUIT");
+      pfatal_and_delete (outfile);
+    }
+
+  for (i = 1; i <= nmsgs; i++)
+    {
+      mbx_delimit_begin (mbf);
+      if (pop_retr (i, mbx_write, mbf) != OK)
+	{
+	  pop_command ("QUIT");
+	  close (mbfi);
+	  unlink (outfile);
+	  fatal (Errmsg);
+	}
+      mbx_delimit_end (mbf);
+      fflush (mbf);
+    }
+
+  if (fsync (mbfi) < 0)
+    {
+      pop_command ("QUIT");
+      pfatal_and_delete (outfile);
+    }
+
+  if (close (mbfi) == -1)
+    {
+      pop_command ("QUIT");
+      pfatal_and_delete (outfile);
+    }
+
+  for (i = 1; i <= nmsgs; i++)
+    {
+      if (pop_command ("DELE %d", i) == NOTOK)
+	{
+	  /* Better to ignore this failure.  */
+	}
+    }
+
+  pop_command ("QUIT");
+  return (0);
+}
+
+pop_init (host)
+     char *host;
+{
+  register struct hostent *hp;
+  register struct servent *sp;
+  int lport = IPPORT_RESERVED - 1;
+  struct sockaddr_in sin;
+  register int s;
+
+  hp = gethostbyname (host);
+  if (hp == NULL)
+    {
+      sprintf (Errmsg, "MAILHOST unknown: %s", host);
+      return NOTOK;
+    }
+
+  sp = getservbyname ("pop", "tcp");
+  if (sp == 0)
+    {
+      strcpy (Errmsg, "tcp/pop: unknown service");
+      return NOTOK;
+    }
+
+  sin.sin_family = hp->h_addrtype;
+  bcopy (hp->h_addr, (char *)&sin.sin_addr, hp->h_length);
+  sin.sin_port = sp->s_port;
+  s = rresvport (&lport);
+  if (s < 0)
+    {
+      sprintf (Errmsg, "error creating socket: %s", get_errmsg ());
+      return NOTOK;
+    }
+
+  if (connect (s, (char *)&sin, sizeof sin) < 0)
+    {
+      sprintf (Errmsg, "error during connect: %s", get_errmsg ());
+      close (s);
+      return NOTOK;
+    }
+
+  sfi = fdopen (s, "r");
+  sfo = fdopen (s, "w");
+  if (sfi == NULL || sfo == NULL)
+    {
+      sprintf (Errmsg, "error in fdopen: %s", get_errmsg ());
+      close (s);
+      return NOTOK;
+    }
+
+  return OK;
+}
+
+pop_command (fmt, a, b, c, d)
+     char *fmt;
+{
+  char buf[128];
+  char errmsg[64];
+
+  sprintf (buf, fmt, a, b, c, d);
+
+  if (debug) fprintf (stderr, "---> %s\n", buf);
+  if (putline (buf, Errmsg, sfo) == NOTOK) return NOTOK;
+
+  if (getline (buf, sizeof buf, sfi) != OK)
+    {
+      strcpy (Errmsg, buf);
+      return NOTOK;
+    }
+
+  if (debug)
+    fprintf (stderr, "<--- %s\n", buf);
+  if (*buf != '+')
+    {
+      strcpy (Errmsg, buf);
+      return NOTOK;
+    }
+  else
+    {
+      return OK;
+    }
+}
+
+    
+pop_stat (nmsgs, nbytes)
+     int *nmsgs, *nbytes;
+{
+  char buf[128];
+
+  if (debug)
+    fprintf (stderr, "---> STAT\n");
+  if (putline ("STAT", Errmsg, sfo) == NOTOK)
+    return NOTOK;
+
+  if (getline (buf, sizeof buf, sfi) != OK)
+    {
+      strcpy (Errmsg, buf);
+      return NOTOK;
+    }
+
+  if (debug) fprintf (stderr, "<--- %s\n", buf);
+  if (*buf != '+')
+    {
+      strcpy (Errmsg, buf);
+      return NOTOK;
+    }
+  else
+    {
+      sscanf (buf, "+OK %d %d", nmsgs, nbytes);
+      return OK;
+    }
+}
+
+pop_retr (msgno, action, arg)
+     int (*action)();
+{
+  char buf[128];
+
+  sprintf (buf, "RETR %d", msgno);
+  if (debug) fprintf (stderr, "%s\n", buf);
+  if (putline (buf, Errmsg, sfo) == NOTOK) return NOTOK;
+
+  if (getline (buf, sizeof buf, sfi) != OK)
+    {
+      strcpy (Errmsg, buf);
+      return NOTOK;
+    }
+
+  while (1)
+    {
+      switch (multiline (buf, sizeof buf, sfi))
+	{
+	case OK:
+	  (*action)(buf, arg);
+	  break;
+	case DONE:
+	  return OK;
+	case NOTOK:
+	  strcpy (Errmsg, buf);
+	  return NOTOK;
+	}
+    }
+}
+
+getline (buf, n, f)
+     char *buf;
+     register int n;
+     FILE *f;
+{
+  register char *p;
+  int c;
+
+  p = buf;
+  while (--n > 0 && (c = fgetc (f)) != EOF)
+    if ((*p++ = c) == '\n') break;
+
+  if (ferror (f))
+    {
+      strcpy (buf, "error on connection");
+      return NOTOK;
+    }
+
+  if (c == EOF && p == buf)
+    {
+      strcpy (buf, "connection closed by foreign host");
+      return DONE;
+    }
+
+  *p = NULL;
+  if (*--p == '\n') *p = NULL;
+  if (*--p == '\r') *p = NULL;
+  return OK;
+}
+
+multiline (buf, n, f)
+     char *buf;
+     register int n;
+     FILE *f;
+{
+  if (getline (buf, n, f) != OK)
+    return NOTOK;
+  if (*buf == '.')
+    {
+      if (*(buf+1) == NULL)
+	return DONE;
+      else
+	strcpy (buf, buf+1);
+    }
+  return OK;
+}
+
+char *
+get_errmsg ()
+{
+  extern int errno, sys_nerr;
+  extern char *sys_errlist[];
+  char *s;
+
+  if (errno < sys_nerr)
+    s = sys_errlist[errno];
+  else
+    s = "unknown error";
+  return (s);
+}
+
+putline (buf, err, f)
+     char *buf;
+     char *err;
+     FILE *f;
+{
+  fprintf (f, "%s\r\n", buf);
+  fflush (f);
+  if (ferror (f))
+    {
+      strcpy (err, "lost connection");
+      return NOTOK;
+    }
+  return OK;
+}
+
+mbx_write (line, mbf)
+     char *line;
+     FILE *mbf;
+{
+  fputs (line, mbf);
+  fputc (0x0a, mbf);
+}
+
+mbx_delimit_begin (mbf)
+     FILE *mbf;
+{
+  fputs ("\f\n0, unseen,,\n", mbf);
+}
+
+mbx_delimit_end (mbf)
+     FILE *mbf;
+{
+  putc ('\037', mbf);
+}
+
+#endif /* MAIL_USE_POP */
diff -urP /mule-1.1/etc/sendmailuupc.c ./etc/sendmailuupc.c
--- /mule-1.1/etc/sendmailuupc.c
+++ ./etc/sendmailuupc.c	Mon Jan 24 15:46:56 1994
@@ -0,0 +1,417 @@
+/*
+  uupcp sendmail ǂ	by O.Sasaki 1993.11
+
+  {fakemail𐳎ɃT|[gׂȂ̂낤
+  uupc mail̕T|[gׂɕʏƂB
+
+  ȂA蔲vOŁAȉ̖_
+
+  1. [AhX̓hC`݂̂ƂĂB(UUCP`ł͓Ȃ)
+
+  2. [AhX̓tl[ŋLqĂƎvĂB
+     ̐lԂ}VuupcgƂ͎vȂ̂ŃhC
+     AhX𖳎B[Jɂ̓hCt΃[͑B
+
+  3. [AhX̋LɌŒ蒷zgĂB
+
+*/
+
+#include <stdio.h>
+#include <stdlib.h>
+#include <string.h>
+#include <ctype.h>
+#include <time.h>
+
+#define BUFFER_SIZE 256
+#define HEADER_SIZE 2048
+
+typedef struct {
+    char *name ;
+    char **value ;
+} CONFIGDATA ;
+
+
+char	wbuf[BUFFER_SIZE] ;	/* ėp[Nobt@			*/
+char	ToMail[HEADER_SIZE] ;	/* M҃[AhX			*/
+char	CcMail[HEADER_SIZE] ;	/* Rs[M҃[AhX		*/
+char	BccMail[HEADER_SIZE] ;	/* \Rs[M҃[AhX	*/
+char	Header[HEADER_SIZE*2] ;	/* [AhXȊÕwb_[		*/
+char	Subject[BUFFER_SIZE] ;	/* bZ[Wobt@		*/
+
+char	*UupcName = NULL ;	/* M҃tl[			*/
+char	*UupcMailbox = NULL ;	/* C{bNX			*/
+char	*UupcHomeDir = NULL ;	/* z[fBNg[			*/
+char	*UupcFileSent = NULL ;	/* MOۑt@C		*/
+char	*UupcOrganization =NULL;/* gDAc̖				*/
+char	*UupcReplyto = NULL ;	/* vCAhXw			*/
+char	*UupcDomain = NULL ;	/* thC			*/
+char	*UupcFromDomain = NULL ;/* CMhC			*/
+char	*UupcMailExt = NULL ;	/* Ct@Cgq			*/
+char	*UupcSignature = NULL ;	/* tt@C			*/
+int	UupcAutoSign ;		/* t@Ct̗L			*/
+
+CONFIGDATA	Conf[] = {
+    { "name",		&UupcName		} ,
+    { "mailbox",	&UupcMailbox		} ,
+    { "home",		&UupcHomeDir		} ,
+    { "filesent",	&UupcFileSent		} ,
+    { "organization",	&UupcOrganization	} ,
+    { "replyto",	&UupcReplyto		} ,
+    { "domain",		&UupcDomain		} ,
+    { "fromdomain",	&UupcFromDomain		} ,
+    { "mailext",	&UupcMailExt		} ,
+    { "signature",	&UupcSignature		} ,
+    { NULL, NULL }
+} ;
+
+
+/********************************************************/
+/*							*/
+/*	UUPCݒǂݎ菈			*/
+/*							*/
+/* sendmailŕKvȐݒ荀ڂǂݍ݊eϐɕۑ	*/
+/*							*/
+/********************************************************/
+void GetConfigData( char *rcname )
+{
+    char	*fname, *pos ;
+    FILE	*fp ;
+    int		lp, find ;
+    char	tmp[BUFFER_SIZE] ;
+
+    fname = getenv( rcname ) ;
+    fp = fopen( fname, "r" ) ;
+    while ( fgets( tmp, BUFFER_SIZE, fp ) != NULL ) {
+	/* Rgs̓XLbv */
+	if ( *tmp == '#' )
+	    continue ;
+
+	/* 擪̋󔒂AsȂXLbv */
+	pos = tmp ;
+	while ( isspace( *pos ) ) ++pos ;
+	if ( *pos == '\0' )
+	    continue ;
+	strcpy( wbuf, pos ) ;
+
+	/* I̋󔒂폜 */
+	pos = strstr( wbuf, "\n" ) ;
+	while ( isspace( *pos ) ) --pos ;
+	*(++pos) = '\0' ;
+
+	/* RtBOʎq؂o */
+	strcpy( tmp, wbuf ) ;
+	if ( ( pos = strstr( tmp, "=" ) ) == NULL )
+	    continue ;
+	*pos = '\0' ;
+	strcpy( wbuf, wbuf + ( pos - tmp ) + 1 ) ;
+
+	/* RtBOʎq */
+	for ( pos = tmp ; *pos ; ++pos )
+	    *pos = ( char )tolower( *pos ) ;
+
+	if ( strstr( tmp, "options" ) == tmp ) {
+	    /* IvVw莯ʎq */
+	    for ( pos = wbuf ; *pos ; ++pos )
+		*pos = ( char )tolower( *pos ) ;
+
+	    /* tt@C̗L`FbN */
+	    if ( strstr( wbuf, "autosign" ) != NULL ) {
+		if ( strstr( wbuf, "noautosign" ) != NULL ) {
+		    UupcAutoSign = 0 ; /* tt@CwȂ */
+		} else {
+		    UupcAutoSign = 1 ; /* tt@Cw肠 */
+		}
+	    }
+	    continue ;
+	}
+	
+	lp = find = 0 ;
+	while ( Conf[lp].name != NULL ) {
+	    if ( strstr( tmp, Conf[lp].name ) == tmp ) {
+		find = lp + 1 ;
+		break ;
+	    }
+	    ++lp ;
+	}
+	if ( !find )
+	    continue ;
+	--find ;
+
+	if ( *Conf[find].value == NULL ) {
+	    *Conf[find].value = malloc( strlen( wbuf ) + 1 ) ;
+	} else {
+	    *Conf[find].value = realloc( *Conf[find].value,
+					strlen( wbuf ) + 1 ) ;
+	}
+	strcpy( Conf[find].value[0], wbuf ) ;
+    }
+}
+
+
+/********************************************************/
+/*							*/
+/*	[wb_[L[[h؂o		*/
+/*							*/
+/* ̓obt@ɃL[[hꍇ̓L[[h	*/
+/* ؂A啶ϊobt@̃AhXԂB	*/
+/*							*/
+/* ̓obt@̐擪Xy[X^ȕꍇ͌ps	*/
+/* ȂA̓obt@̃AhX̂܂ܕԂB	*/
+/*							*/
+/* ̓obt@s̏ꍇ[wb_IƌȂA	*/
+/* NULLAhXԂB					*/
+/*							*/
+/********************************************************/
+char *get_keyword ( char *field )
+{
+    static char keyword[BUFFER_SIZE];
+    register char *ptr;
+    register char c;
+
+    ptr = keyword ;
+    c = *field++;
+    if ( c == '\0' )
+	return ( (char *) NULL ) ;
+    if ( isspace( c ) )
+	return ( field-1 ) ;
+    *ptr++ = toupper( c ) ;
+    while ( ( ( c = *field++ ) != ':' ) && ( !( isspace( c ) ) ) )
+	*ptr++ = toupper( c ) ;
+    *ptr = '\0' ;
+    while ( isspace( c ) )
+	c = *field++ ;
+    if ( c != ':' )
+	return ( (char *) NULL ) ;
+    return keyword ;
+}
+
+/********************************************************/
+/*							*/
+/*	 [AhX؂o			*/
+/*							*/
+/* buf ɂSẴ[AhX Mail֑	*/
+/*							*/
+/********************************************************/
+void AppendName( char *Mail, char *buf )
+{
+    char	tmp[BUFFER_SIZE] ;
+    char	*pos ;
+
+    for ( ;; ) {
+	if ( ( pos = strstr( buf, "<" ) ) != NULL ) {
+	    /* VM̃vC̏ꍇ (vm-strip-reply-headers nil ) */
+	    if ( pos != buf ) {
+		/* AhXÕl[ʒuRs[ */
+		strcpy( tmp, buf ) ;
+	    } else {
+		/* AhX̂݃Rs[ */
+		strcpy( tmp, pos ) ;
+	    }
+	    buf = strstr( pos, ">" ) ;
+	    while ( *buf == '>' || *buf == ',' || *buf == ' ' )
+		++buf ;
+	    pos = strstr( tmp, ">" ) ;
+	    *(++pos) = '\0' ;
+	} else if ( ( pos = strstr( buf, "@" ) ) != NULL ) {
+	    /* rmail VM(vm-strip-reply-headers t )Ȃǂ
+	       <>ň͂ĂȂAhX̏ꍇ */
+	    buf = pos + 1 ;
+	    for ( ; !(isspace( *pos ) || ( *pos == ',' )) ; --pos ) ;
+	    ++pos ;
+	    sscanf( pos, "%s", tmp ) ;
+	} else {
+	    /* t[AhXƂďI */
+	    return ;
+	}
+	/* tmp 𑫂 */
+	strcat( Mail, " " ) ;
+	strcat( Mail, tmp ) ;
+	strcat( Mail, "\n" ) ;
+    }
+}
+
+/********************************************************/
+/*							*/
+/*	wb_[f[^͏				*/
+/*							*/
+/********************************************************/
+void GetHeaderData( void )
+{
+    int		oldmode = 0 ;
+    char	*key ;
+
+    *ToMail = *CcMail = *BccMail = *Header = '\0' ;
+    while ( fgets( wbuf, BUFFER_SIZE, stdin ) != NULL ) {
+	wbuf[ strlen( wbuf ) -1] = '\0' ;
+	if ( ( key = get_keyword ( wbuf ) ) == NULL )
+	    break ;
+
+	if ( key == wbuf ) {
+	    /* ps̏ꍇ */
+	    switch ( oldmode ) {
+	    case 1: AppendName( ToMail, wbuf ) ; break ;
+	    case 2: AppendName( CcMail, wbuf ) ; break ;
+	    case 3: AppendName( BccMail, wbuf ) ; break ;
+	    default:
+		strcat( Header, wbuf ) ;
+		strcat( Header, "\n" ) ;
+		break ;
+	    }
+	    continue ;
+	}
+	if ( strcmp( key, "TO" ) == 0 ) {
+	    AppendName( ToMail, wbuf + 3 ) ;
+	    oldmode = 1 ;
+	} else if ( strcmp( key, "CC"  ) == 0 ) {
+	    AppendName( CcMail, wbuf + 3 ) ;
+	    oldmode  = 2 ;
+	} else if ( strcmp( key, "BCC"  ) == 0 ) {
+	    AppendName( BccMail, wbuf + 4 ) ;
+	    oldmode  = 3 ;
+	} else if ( strcmp( key , "SUBJECT" ) == 0 ) {
+	    strcpy( Subject, &wbuf[9] ) ;
+	    oldmode = 0 ;
+	} else {
+	    strcat( Header, wbuf ) ;
+	    strcat( Header, "\n" ) ;
+	    oldmode = 0 ;
+	}
+    }
+}
+
+/********************************************************/
+/*							*/
+/*	t@CpX				*/
+/*							*/
+/********************************************************/
+void MakeFilePath( char *buf, char *dir, char *name, char *ext )
+{
+    strcpy( buf, dir ) ;
+    if ( buf[strlen( buf ) -1] != '/' )
+	strcat( buf, "/" ) ;
+    strcat( buf, name ) ;
+    if ( ext ) {
+	strcat( buf, "." ) ;
+	strcat( buf, ext ) ;
+    }
+}
+
+/********************************************************/
+/*							*/
+/*	f[^o͏					*/
+/*							*/
+/********************************************************/
+void PutData( char *format, char *buf, FILE *outfp, FILE *resent )
+{
+    fprintf( outfp, format, buf ) ;
+    if ( resent )
+	fprintf( resent, format, buf ) ;
+}
+
+/********************************************************/
+/*							*/
+/*	wb_[f[^o͏				*/
+/*							*/
+/********************************************************/
+void PutHeaderData( FILE *outfp, FILE *resent )
+{
+    time_t	tim ;
+
+    time( &tim );
+    strftime( wbuf, BUFFER_SIZE, "%a, %d %b %Y %H:%M:%S %Z", localtime(&tim)) ;
+    PutData( "Date: %s\n", wbuf, outfp, resent ) ;
+
+    sprintf( wbuf, "From: \"%s\" <%s@%s>",
+	    UupcName, UupcMailbox, UupcFromDomain ) ;
+    PutData( "%s\n", wbuf, outfp, resent ) ;
+
+    PutData( "To:%s", ToMail, outfp, resent ) ;
+    if ( *CcMail  ) PutData( "Cc:%s", CcMail, outfp, resent ) ;
+    if ( *BccMail ) PutData( "Bcc:%s", BccMail, outfp, resent ) ;
+    if ( *Header  ) PutData( "%s", Header, outfp, resent ) ;
+
+    if ( UupcOrganization ) {
+	PutData( "Organization: %s\n", UupcOrganization, outfp, resent ) ;
+    }
+
+    if ( UupcReplyto ) {
+	if ( strpbrk( UupcReplyto, "!@" ) == NULL )
+	    sprintf( wbuf, "\"%s\" <%s@%s>",
+		    UupcName, UupcReplyto , UupcFromDomain ) ;
+	else
+	    sprintf( wbuf, "\"%s\" <%s>", UupcName, UupcReplyto ) ;
+	PutData( "Reply-To: %s\n", wbuf, outfp, resent ) ;
+    }
+
+    PutData( "Subject: %s\n\n", Subject, outfp, resent ) ;
+}
+
+/********************************************************/
+/*							*/
+/*		C				*/
+/*							*/
+/********************************************************/
+main( int argc, char *argv[] )
+{
+    FILE	*outfp, *resent, *sign ;
+    int		lp ;
+
+    /* UUPC荞 */
+    GetConfigData( "UUPCSYSRC" ) ;
+    GetConfigData( "UUPCUSRRC" ) ;
+    if ( UupcFromDomain == NULL ) {
+	UupcFromDomain = malloc( strlen( UupcDomain ) + 1 ) ;
+	strcpy( UupcFromDomain, UupcDomain ) ;
+    }
+
+    GetHeaderData( ) ;
+
+    /* MOt@CI[v */
+    if ( UupcFileSent ) {
+	MakeFilePath( wbuf, UupcHomeDir, UupcFileSent, UupcMailExt ) ;
+	resent = fopen( wbuf, "a" ) ;
+	fprintf( resent, "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\n" ) ;
+    } else
+	resent = NULL ;
+
+    /* uupc mail ̕W̓oCvI[v */
+    if ( ( outfp = popen( "rmail -t", "w" ) ) == ((FILE *) NULL)) {
+	printf( "sendmailuupc: " ) ;
+	printf( "cannot open pipe to real mailer\n" ) ;
+	if ( resent )
+	    fclose( resent ) ;
+	exit( 1 ) ;
+    }
+
+    PutHeaderData( outfp, resent ) ;
+
+    /* ۂɑf[^𕡎ʂ */
+    while ( fgets( wbuf, BUFFER_SIZE, stdin ) != NULL )
+	PutData( "%s", wbuf, outfp, resent ) ;
+
+    /* ttBOAtt@C݂ꍇ̂݃t@Ct */
+    if ( UupcAutoSign && UupcSignature ) {
+	MakeFilePath( wbuf, UupcHomeDir, UupcSignature, NULL ) ;
+	if ( ( sign = fopen( wbuf, "r" ) ) != NULL ) {
+	    PutData( "%s\n", "--", outfp, resent ) ;
+	    while ( fgets( wbuf, BUFFER_SIZE, sign ) != NULL )
+		PutData( "%s", wbuf, outfp, resent ) ;
+	    fclose( sign ) ;
+	}
+    }
+
+    pclose( outfp ) ;
+    if ( resent )
+	fclose( resent ) ;
+
+    /* UUPCۑGAJ */
+    lp = 0 ;
+    while ( Conf[lp].name != NULL ) {
+	if ( *Conf[lp].value != NULL ) {
+	    printf( "%08x\n", *Conf[lp].value ) ;
+	    free( *Conf[lp].value ) ;
+	}
+	++lp ;
+    }
+    return 0 ;
+}
diff -urP /mule-1.1/etc/server.c ./etc/server.c
--- /mule-1.1/etc/server.c	Mon Mar 14 14:45:32 1994
+++ ./etc/server.c	Tue Mar 15 06:41:32 1994
@@ -50,6 +50,86 @@
 #undef open
 #undef close
 
+/* 93.8.20 by O.Sasaki */
+#if defined (OS2)
+
+#define INCL_DOS
+#include <os2.h>
+#include <stdio.h>
+#include <process.h>
+
+static void error (ULONG rc, const char *fun)
+{
+    (void)fprintf (stderr, "%s failed, rc=%lu\n", fun, rc) ;
+    exit (1) ;
+}
+
+#define ERROR(fun) if (rc != 0) error (rc, fun)
+
+int main (int argc, char *argv[])
+{
+    HQUEUE	hq_server, hq_client ;
+    ULONG	rc, len ;
+    PID		owner_pid ;
+    PVOID	data ;
+    REQUESTDATA request ;
+    BYTE	priority ;
+    char	buffer[1024], name[512], *p ;
+    long	client_pid ;
+
+    if (argc == 1) {
+	if (spawnl (P_NOWAIT, argv[0], argv[0], "-r", NULL) < 0) {
+	    perror ("spawn") ;
+	    return 1 ;
+	}
+	for (;;) {
+	    if (fgets (buffer, sizeof (buffer), stdin) == 0)
+		return 0 ;
+	    p = buffer ;
+	    while (*p != 0 && !(*p >= '0' && *p <= '9'))
+		++p ;
+	    client_pid = strtol (p, NULL, 10) ;
+	    (void)sprintf (name, "/queues/emacs/clients/%ld", client_pid) ;
+	    rc = DosOpenQueue (&owner_pid, &hq_client, name) ;
+	    if (rc == 0) {
+		len = strlen (buffer) + 1 ;
+		rc = DosAllocSharedMem (&data, 0, len,
+					PAG_COMMIT | OBJ_GIVEABLE | PAG_READ
+					| PAG_WRITE) ;
+		ERROR ("DosAllocSharedMem") ;
+		rc = DosGiveSharedMem (data, client_pid, PAG_READ) ;
+		ERROR ("DosGiveSharedMem") ;
+		(void)memcpy (data, buffer, len) ;
+		rc = DosWriteQueue (hq_client, 0, len, data, 0) ;
+		ERROR ("DosWriteQueue") ;
+		rc = DosFreeMem (data) ;
+		ERROR ("DosFreeMem") ;
+		rc = DosCloseQueue (hq_client) ;
+		ERROR ("DosCloseQueue") ;
+	    }
+	}
+    } else if (argc == 2 && strcmp (argv[1], "-r") == 0) {
+	rc = DosCreateQueue (&hq_server, QUE_FIFO | QUE_CONVERT_ADDRESS,
+			     "/queues/emacs/server") ;
+	ERROR ("DosCreateQueue") ;
+	for (;;) {
+	    rc = DosReadQueue (hq_server, &request, &len, &data, 0,
+			       DCWW_WAIT, &priority, 0) ;
+	    ERROR ("DosReadQueue") ;
+	    (void)printf ("Client: %d ", (int)request.pid) ;
+	    (void)fputs (data, stdout) ;
+	    (void)fflush (stdout) ;
+	    rc = DosFreeMem (data) ;
+	    ERROR ("DosFreeMem") ;
+	}
+    } else {
+	(void)fprintf (stderr, "Usage: %s\n", argv[0]) ;
+	return 1 ;
+    }
+}
+
+#else /* not OS2 */
+
 #if !defined(BSD) && !defined(HAVE_SYSVIPC) && !defined(HAVE_SOCKETS)
 #include <stdio.h>
 
@@ -340,4 +420,4 @@
 
 #endif /* BSD && IPC */
 
-
+#endif /* OS2 */
diff -urP /mule-1.1/lisp/compile.el ./lisp/compile.el
--- /mule-1.1/lisp/compile.el	Thu Jun 03 19:20:04 1993
+++ ./lisp/compile.el	Thu Sep 30 08:35:48 1993
@@ -113,7 +113,7 @@
   (setq compilation-process
 	(start-process "compilation" "*compilation*"
 		       shell-file-name
-		       "-c" (concat "exec " command)))
+		       "/s" "/c" command))
   (with-output-to-temp-buffer "*compilation*"
     (princ "cd ")
     (princ default-directory)
@@ -184,13 +184,13 @@
   "Kill the process made by the \\[compile] command."
   (interactive)
   (if compilation-process
-      (interrupt-process compilation-process)))
+      (os2-kill-process compilation-process)))
 
 (defun kill-grep ()
   "Kill the process made by the \\[grep] command."
   (interactive)
   (if compilation-process
-      (interrupt-process compilation-process)))
+      (os2-kill-process compilation-process)))
 
 (defun next-error (&optional argp)
   "Visit next compilation error message and corresponding source code.
diff -urP /mule-1.1/lisp/gdb.el ./lisp/gdb.el
--- /mule-1.1/lisp/gdb.el	Mon Mar 14 14:43:54 1994
+++ ./lisp/gdb.el	Wed Mar 23 07:58:36 1994
@@ -41,7 +41,7 @@
 
 ;; You may easily create additional commands and bindings to interact
 ;; with the display.  For example to put the gdb command next on \M-n
-;; (def-gdb next "\M-n")
+;; (def-gdb next "\en")
 
 ;; This causes the emacs command gdb-next to be defined, and runs
 ;; gdb-display-frame after the command.
@@ -89,14 +89,14 @@
 		(list 'gdb-call cstr))
 	  (list 'define-key 'gdb-mode-map key  (list 'quote fun)))))
 
-(def-gdb "step"   "\M-s" "Step one source line with display")
-(def-gdb "stepi"  "\M-i" "Step one instruction with display")
-(def-gdb "next"   "\M-n" "Step one source line (skip functions)")
-(def-gdb "cont"   "\M-c" "Continue with display")
+(def-gdb "step"   "\es" "Step one source line with display")
+(def-gdb "stepi"  "\ei" "Step one instruction with display")
+(def-gdb "next"   "\en" "Step one source line (skip functions)")
+(def-gdb "cont"   "\ec" "Continue with display")
 
 (def-gdb "finish" "\C-c\C-f" "Finish executing current function")
-(def-gdb "up"     "\M-u"   "Go up N stack frames (numeric arg) with display")
-(def-gdb "down"   "\M-d"   "Go down N stack frames (numeric arg) with display")
+(def-gdb "up"     "\eu"   "Go up N stack frames (numeric arg) with display")
+(def-gdb "down"   "\ed"   "Go down N stack frames (numeric arg) with display")
 
 (defun gdb-mode ()
   "Major mode for interacting with an inferior Gdb process.
@@ -193,9 +193,9 @@
 	  (let ((end (string-match "\n" string)))
 	    (if end
 		(progn
-		  (let* ((first-colon (string-match ":" string 2))
+		  (let* ((first-colon (string-match ";" string 2))
 			 (second-colon
-			  (string-match ":" string (1+ first-colon))))
+			  (string-match ";" string (1+ first-colon))))
 		    (setq gdb-last-frame
 			  (cons (substring string 2 first-colon)
 				(string-to-int
diff -urP /mule-1.1/lisp/loadup.el ./lisp/loadup.el
--- /mule-1.1/lisp/loadup.el	Mon Mar 14 14:44:00 1994
+++ ./lisp/loadup.el	Tue Mar 15 11:02:06 1994
@@ -144,6 +144,15 @@
 (if (load "site-load" t)
     (garbage-collect))
 
+;; 93.8.24 by O.Sasaki
+(if (eq system-type 'OS/2)
+    (progn
+      (load "os2")
+      (garbage-collect)
+      (load "os2-keys")
+      (garbage-collect)))
+;; end of patch
+
 (load "version.el")  ;Don't get confused if someone compiled version.el by mistake.
 
 ;; Note: all compiled Lisp files loaded above this point
@@ -196,6 +205,11 @@
 	    (message "Dumping data as file xemacs")
 	    (dump-emacs "xemacs" "temacs")
 	    (kill-emacs))
+	(if (eq system-type 'OS/2)	;93.8.17 by O.Sasaki
+	    (progn
+	      (message "Dumping data as file xemacs")
+	      (dump-emacs "xemacs" "temacs")
+	      (kill-emacs))
 	(if (fboundp 'dump-emacs-data)
 	    ;; Handle the IBM RS/6000, and perhaps eventually other machines.
 	    (progn
@@ -221,7 +235,7 @@
 				 "-"
 				 (substring name (match-end 0)))))
 	    (add-name-to-file "xemacs" name t))
-	  (kill-emacs)))))
+	  (kill-emacs))))))
 
 ;; Avoid error if user loads some more libraries now.
 (setq purify-flag nil)
diff -urP /mule-1.1/lisp/os2-keys.el ./lisp/os2-keys.el
--- /mule-1.1/lisp/os2-keys.el
+++ ./lisp/os2-keys.el	Sun Dec 19 11:41:14 1993
@@ -0,0 +1,353 @@
+;
+; os2-keys.el
+;
+(provide 'os2-keys)
+
+(defvar ext-map nil
+  "Keymap used for extended scan codes.")
+(setq ext-map (make-keymap))
+
+(defvar os2-map nil
+  "Keymap used for os2 key definitions which are prefixed by F9.")
+(setq os2-map (make-sparse-keymap))
+
+(define-key ext-map "\002" 'set-mark-command)	    ; C-SPC
+(define-key ext-map "\003" 'set-mark-command)	    ; C-@
+(define-key ext-map "\040" 'os2-dup-line)	    ; A-d
+(define-key ext-map "\041" 'find-file)		    ; A-f
+(define-key ext-map "\042" 'goto-line)	            ; A-g
+(define-key ext-map "\056" 'os2-copy-region)        ; A-c
+(define-key ext-map "\046" 'os2-copy-line-as-kill)  ; A-l
+(define-key ext-map "\062" 'os2-match-paren)        ; A-m
+(define-key ext-map "\030" 'open-rectangle)	    ; A-o
+(define-key ext-map "\021" 'os2-kill-word)	    ; A-w
+(define-key ext-map "\016" 'undo)		    ; A-BS
+(define-key ext-map "<" 'os2-switch-to-nth-buffer)  ; F2
+(define-key ext-map "=" 'os2-search-forward)	    ; F3
+(define-key ext-map ">" 'os2-search-backward)	    ; F4
+(define-key ext-map "?" 'os2-fill-paragraph)        ; F5
+(define-key ext-map "@" 'other-window)		    ; F6
+(define-key ext-map "A" 'undefined)		    ; F7
+(define-key ext-map "B" 'undefined)		    ; F8
+(define-key ext-map "C" os2-map)		    ; F9
+(define-key ext-map "D" 'undefined)		    ; F10
+(define-key ext-map "E" 'undefined)		    ;
+(define-key ext-map "F" 'undefined)		    ;
+(define-key ext-map "G" 'beginning-of-line)	    ; HOME
+(define-key ext-map "H" 'previous-line)		    ; UP
+(define-key ext-map "I" 'scroll-down)		    ; PAGEUP
+(define-key ext-map "J" 'undefined)		    ;
+(define-key ext-map "K" 'backward-char)		    ; LEFT
+(define-key ext-map "L" 'goto-line)		    ; CENTER
+(define-key ext-map "M" 'forward-char)		    ; RIGHT
+(define-key ext-map "N" 'undefined)		    ;
+(define-key ext-map "O" 'end-of-line)		    ; END
+(define-key ext-map "P" 'next-line)		    ; DOWN
+(define-key ext-map "Q" 'scroll-up)		    ; PAGEDOWN
+(define-key ext-map "R" 'overwrite-mode)	    ; INSERT
+(define-key ext-map "S" 'delete-char)		    ; DELETE
+(define-key ext-map "T" 'describe-key)		    ; S-F1
+(define-key ext-map "U" 'os2-buffer-list)	    ; S-F2
+(define-key ext-map "V" 'next-error)		    ; S-F3
+(define-key ext-map "W" 'undefined)		    ; S-F4
+(define-key ext-map "X" 'undefined)		    ; S-F5
+(define-key ext-map "Y" 'undefined)		    ; S-F6
+(define-key ext-map "Z" 'undefined)		    ; S-F7
+(define-key ext-map "_" 'os2-find-file-at-point)    ; C-F2
+(define-key ext-map "s" 'os2-backward-to-word)	    ; C-LEFT
+(define-key ext-map "t" 'os2-forward-to-word)	    ; C-RIGHT
+(define-key ext-map "u" 'kill-line)		    ; C-END
+(define-key ext-map "v" 'os2-end-of-buffer)	    ; C-PAGEDOWN
+(define-key ext-map "w" 'os2-kill-left-line)	    ; C-HOME
+(define-key ext-map "\200" 'undefined)              ; A-9
+(define-key ext-map "\204" 'os2-beginning-of-buffer) ; C-PAGEUP
+(define-key ext-map "\205" 'call-last-kbd-macro)    ; F11
+(define-key ext-map "\206" 'set-mark-command)	    ; F12
+(define-key ext-map "\207" 'expand-abbrev)          ; S-F11
+(define-key ext-map "\215" 'os2-scroll-line-down)   ; C-UP
+(define-key ext-map "\216" 'undefined)              ; C-NUM-
+(define-key ext-map "\217" 'undefined)              ; C-CENTER
+(define-key ext-map "\220" 'undefined)              ; C-NUM+
+(define-key ext-map "\221" 'os2-scroll-line-up)	    ; C-DOWN
+(define-key ext-map "\222" 'undefined)              ; C-INSERT
+(define-key ext-map "\231" 'os2-scroll-other-window) ; A-PAGEUP
+(define-key ext-map "\233" 'scroll-right)	    ; A-LEFT
+(define-key ext-map "\235" 'scroll-left)	    ; A-RIGHT
+(define-key ext-map "\241" 'scroll-other-window)    ; A-PAGEDOWN
+(define-key ext-map "\245" 'undefined)              ; A-TAB
+
+(define-key os2-map "c" 'compile)	            ; F9 c
+(define-key os2-map "i" 'os2-reinitialize)	    ; F9 i
+(define-key os2-map "j" 'just-one-space)            ; F9 j
+(define-key os2-map "v" 'os2-buffer-file-name)      ; F9 v
+
+(global-set-key "\e " 'set-mark-command)
+(global-set-key "\0" ext-map)
+
+;
+; The following definitions avoid the insertion of unexpected
+; characters into the buffer if the scan code prefix (C-@) is not a
+; valid key. Otherwise, "C-X RIGHT", for instance, would be
+; interpreted as C-X C-@, which is undefined, followed by "M" which
+; would be inserted into the buffer.
+;
+(define-key ctl-x-map "\0" (make-sparse-keymap))
+(define-key ctl-x-4-map "\0" (make-sparse-keymap))
+(define-key esc-map "\0" (make-sparse-keymap))
+(define-key mode-specific-map "\0" (make-sparse-keymap))
+(define-key help-map "\0" (make-sparse-keymap))
+(define-key os2-map "\0" (make-sparse-keymap))
+
+(defun os2-forward-to-word (arg)
+  "Move forward until encountering the beginning of a word.
+With argument, do this that many times."
+  (interactive "p")
+  (or (re-search-forward "\\W\\b" nil t arg)
+      (goto-char (point-max))))
+
+(defun os2-backward-to-word (arg)
+  "Move backward until encountering the beginning of a word.
+With argument, do this that many times."
+  (interactive "p")
+  (backward-char)
+  (if (re-search-backward "\\W\\b" nil t arg) (goto-char (match-end 0))
+      (goto-char (point-min))))
+
+(defun os2-kill-left-line nil
+  "Kill from the beginning of the line to point."
+  (interactive "*")
+  (kill-line 0))
+
+(defun os2-end-of-buffer nil
+  "Move to end of the buffer without setting mark."
+  (interactive)
+  (goto-char (point-max)))
+
+(defun os2-beginning-of-buffer nil
+  "Move to the beginning of the buffer without setting mark."
+  (interactive)
+  (goto-char (point-min)))
+
+(defun os2-reinitialize ()
+  "Load \"~/.emacs, os2-keys.el and os2-misc.el\".
+This is used to load new versions of these files while debugging."
+  (interactive)
+  (load "~/.emacs")
+  (load "os2-keys")
+  (load "os2-misc" t))
+
+(defun os2-scroll-line-up (arg)
+  "Scroll up by one line.
+With argument, do this that many times."
+  (interactive "p")
+  (scroll-up arg))
+
+(defun os2-scroll-line-down (arg)
+  "Scroll down by one line.
+With argument, do this that many times."
+  (interactive "p")
+  (scroll-down arg))
+
+(defun os2-buffer-file-name ()
+  "Display the name of the file visited in current buffer."
+  (interactive)
+  (message "%s" (cond (buffer-file-name) (t "Not visiting a file"))))
+
+(defun os2-copy-line-as-kill (arg)
+  "Copy line as kill.
+With argument, copy that many lines."
+  (interactive "p")
+  (let ((s (point)))
+    (beginning-of-line)
+    (let ((b (point)))
+      (forward-line arg)
+      (copy-region-as-kill b (point)))
+    (goto-char s)))
+
+(defun os2-dup-line (arg)
+  "Duplicate current line.
+Set mark to the beginning of the new line.
+With argument, do this that many times."
+  (interactive "*p")
+  (setq last-command 'identity) ; Don't append to kill ring
+  (let ((s (point)))
+    (beginning-of-line)
+    (let ((b (point)))
+      (forward-line)
+      (if (not (eq (preceding-char) ?\n)) (insert ?\n))
+      (copy-region-as-kill b (point))
+    (while (> arg 0)
+      (yank)
+      (setq arg (1- arg)))
+    (goto-char s))))
+
+(defun os2-kill-word (arg)
+  "Delete characters until encountering the beginning of a word.
+With argument, do this that many times."
+  (interactive "*p")
+  (let ((b (point)))
+     (os2-forward-to-word arg)
+     (kill-region b (point))))
+
+(defvar os2-search-string nil
+  "Search string for os2-search-forward and os2-search-backward.")
+
+(defvar os2-search-re nil
+  "Non-nil means use regular expression for os2-search-forward and -backward.")
+
+(defun os2-search-forward (&optional arg)
+  "Search forward for a string.
+If prefixed by \\[universal-argument], ask for search string.
+If prefixed by \\[universal-argument] \\[universal-argument], use regular expression."
+  (interactive "P")
+  (os2-search-fb arg 'search-forward 're-search-forward))
+
+(defun os2-search-backward (&optional arg)
+  "Search backward for a string.
+If prefixed by \\[universal-argument], ask for search string.
+If prefixed by \\[universal-argument] \\[universal-argument], use
+regular expression."
+  (interactive "P")
+  (os2-search-fb arg 'search-backward 're-search-backward))
+
+(defun os2-search-fb (arg fun re-fun)
+  "Search forward or backward for a string.
+If the first argument is nil, ask for the string.
+The second argument is search-forward or search-backward.
+The third argument is re-search-forward or re-search-backward."
+  (if (or arg (not os2-search-string))
+     (progn
+       (setq os2-search-re 
+	     (and (listp arg) (numberp (car arg)) (>= (car arg) 16)))
+       (setq os2-search-string
+          (read-from-minibuffer
+             (if os2-search-re "Re-Search forward: " "Search forward: ")
+             os2-search-string))))
+  (funcall (if os2-search-re re-fun fun) os2-search-string))
+
+(defun os2-switch-to-nth-buffer (arg)
+  "Switch to the ARG'th buffer.
+If a numeric prefix argument is not given, the next buffer is
+selected. When using this function successively, the top ARG+1 buffers
+are rotated."
+  (interactive "p")
+  (let* ((bufs (buffer-list))
+         (len (length bufs))
+         (idx 0) buffer name (more t))
+    (while (and (>= arg 0) (< idx len) more)
+      (setq buffer (nth idx bufs))
+      (setq name (buffer-name buffer))
+      (if (/= (string-to-char name) ? )
+          (if (zerop arg)
+              (setq more nil)
+            (setq arg (1- arg))))
+      (setq idx (1+ idx)))
+    (if more
+        (error "Invalid buffer number"))
+    (switch-to-buffer buffer)))
+
+(defun os2-match-paren (arg)
+  "Go to the matching parenthesis if on parenthesis.
+This function uses the syntax table."
+  (interactive "p")
+  (cond ((looking-at "\\s\(") (forward-list 1) (backward-char 1))
+	((looking-at "\\s\)") (forward-char 1) (backward-list 1))))
+
+(defun os2-buffer-list ()
+  "Display a list of names of existing buffers.
+Inserts it in buffer *Buffer List* and selects that.
+Note that buffers with names starting with spaces are omitted."
+  (interactive)
+  (list-buffers)
+  (select-window (get-buffer-window "*Buffer List*"))
+  (list-buffers))                                   ; update for *Buffer List*
+
+(defun os2-copy-region ()
+  "Copy region to point."
+  (interactive)
+  (copy-region-as-kill (point) (mark))
+  (yank))
+
+
+(defun os2-fill-paragraph (arg)
+  "Fill paragraph at or before point using em's notion of a paragraph.
+Prefix arg means justify as well.
+Paragraphs are separated by blank lines. The indentation of the first line
+is used for indenting the entire paragraph. If there are two consecutive
+blanks in the first line of the paragraphs, everything to the left of these
+blanks is left as-is and the paragraph is indented to the first non-blank
+character after the first two consecutive blanks of the first line."
+  (interactive "P")
+  (save-excursion
+    (let (fill-prefix start end join column)
+      (while (looking-at "^$")
+          (forward-line -1))
+      (re-search-backward "^$" (point-min) 0)
+      (if (looking-at "^$")
+          (forward-char))
+      (setq start (point))
+      (re-search-forward "^$" (point-max) 0)
+      (or (bolp) (newline 1))
+      (setq end (point-marker))
+      (goto-char start)
+      (if (looking-at "^ *[^ \n]*  ")
+          (progn (re-search-forward "^ *[^ \n]*   *")
+                 (setq column (current-column))
+                 (split-line)
+                 (setq join (point))
+                 (forward-line 1)
+                 (setq start (point))
+                 (forward-char column)
+                 (setq fill-prefix
+                       (if (zerop column) nil
+                         (make-string column ? )))
+                 (while (and (zerop (forward-line 1))
+                             (< (point) (marker-position end)))
+                   (backward-to-indentation 0)
+                   (cond ((> (current-column) column)
+                          (delete-region (+ (point) column
+                                            (- (current-column))) (point)))
+                         ((< (current-column) column)
+                          (insert-char ?  (- column (current-column))))))
+                 (fill-region-as-paragraph start
+                                           (marker-position end) arg)
+                 (delete-region join (+ start column)))
+        (fill-region-as-paragraph (point) (marker-position end) arg)))))
+
+
+(defun os2-extract-file-name (at-point)
+  "Return the file name around or before point.
+If AT-POINT is not nil, the file names starts at point, that is, characters
+before point are ignored."
+  (let (start end)
+    (save-excursion
+      (if at-point
+          (setq start (point))
+        (if (looking-at "[][\0- ()<>\\\"|;=*?]")
+            (re-search-backward "[^][\0- :()<>\\\"|;=*?]" (point-min) 0))
+        (cond ((bobp) (setq start (point-min)))
+              (t (re-search-backward "[][\0- :()<>\\\"|;=*?]" (point-min) 0)
+                 (if (and (looking-at ":") (not (bobp)))
+                     (progn
+                       (goto-char (1- (point)))
+                       (if (looking-at "[A-Za-z]:")
+                           (setq start (point))
+                         (setq start (+ 2 (point)))))
+                   (if (bobp)
+                       (setq start (point))
+                     (setq start (1+ (point))))))))
+      (goto-char start)
+      (if (looking-at "\\([A-Za-z]:\\|\\)[^][\0- :()<>\\\"|;=*?]*")
+          (setq end (match-end 0)))
+      (and start end  (> end start) (buffer-substring start end)))))
+
+(defun os2-find-file-at-point (arg)
+  "Find file whose name is around or before point.
+With prefix argument find file whose name starts at point."
+  (interactive "P")
+  (find-file (os2-extract-file-name arg)))
+
+(defun os2-scroll-other-window (arg)
+  "Scroll up other page."
+  (interactive "p")
+  (scroll-other-window '-))
diff -urP /mule-1.1/lisp/os2.el ./lisp/os2.el
--- /mule-1.1/lisp/os2.el
+++ ./lisp/os2.el	Wed Mar 16 13:37:16 1994
@@ -0,0 +1,283 @@
+;;
+;; os2.el -- Patches for OS/2
+;;
+(provide 'os2)
+
+(defun replace-char-in-string (str c1 c2)
+  "Replace character C1 in string STR with character C2 and return STR.
+This function does *not* copy the string."
+  (let ((indx 0) (len (length str)) chr)
+    (while (< indx len)
+      (setq chr (aref str indx))
+      (if (eq chr c1)
+          (aset str indx c2))
+      (setq indx (1+ indx)))
+    str))
+
+(defun make-legal-file-name (fn)
+  "Turn FN into a legal file name and return the modified copy of the string.
+The characters * and ? will be replaced with _."
+  (setq fn (copy-sequence fn))
+  (replace-char-in-string fn ?* ?_)
+  (replace-char-in-string fn ?? ?_))
+
+;;
+;; Changes:
+;; - replace * and ? with _
+;; - on FAT file system, append # to extension
+;;
+(defun make-auto-save-file-name ()
+  "Return file name to use for auto-saves of current buffer.
+Does not consider auto-save-visited-file-name; that is checked
+before calling this function.
+This has been redefined for customization.
+See also auto-save-file-name-p."
+  (let ((tem
+	 (if buffer-file-name
+	     (concat (file-name-directory buffer-file-name)
+		     "#"
+		     (file-name-nondirectory buffer-file-name)
+		     "#")
+	   (expand-file-name (concat "#%" (make-legal-file-name 
+					   (buffer-name)) "#")))))
+    (cond ((valid-file-name-p tem) tem)
+	  (buffer-file-name
+	   (add-to-fat-file-name "#" buffer-file-name "#"))
+	  (t (expand-file-name (add-to-fat-file-name "#%"
+				(make-legal-file-name (buffer-name)) "#"))))))
+
+
+;;
+;; Requires patched Emacs: valid-file-name-p
+;;
+(defun make-backup-file-name (file)
+  "Create the non-numeric backup file name for FILE.
+This is a separate function so you can redefine it for customization."
+  (let (backup)
+    (or
+     (progn (setq backup (concat file "~")) (valid-file-name-p backup))
+     (setq backup (add-to-fat-file-name nil file "~")))
+    backup))
+
+(defun split-file-name (name)
+  "Split NAME into directory part, base name part and extension.
+Return a list containing three elements. If a part is empty, the list element
+is nil."
+  (let* ((dir (file-name-directory name))
+	 (file (file-name-nondirectory name))
+	 (pos (string-match "\\.[^.]*$" file))
+	 (base (if pos (substring file 0 pos) file))
+	 (ext (if pos (substring file pos) nil)))
+    (list dir base ext)))
+
+(defun add-to-fat-file-name (prefix file suffix)
+  "Concatenate PREFIX, FILE and SUFFIX, then make it FAT compatible.
+It is assumed that FILE is already compatible with the FAT file system."
+  (let* ((split (split-file-name file))
+	 (base (concat prefix (nth 1 split)))
+	 (ext (nth 2 split))
+	 (ext-len (length ext))
+	 (suffix-len (length suffix)))
+    (if (> (length base) 8)
+	(setq base (substring base 0 8)))
+    (while (and (> suffix-len 0) (eq (elt suffix 0) ?.))
+      (setq suffix-len (1- suffix-len))
+      (setq suffix (substring suffix 1)))
+    (if (> suffix-len 3) (progn (setq suffix-len 3) (setq suffix (substring suffix 0 3))))
+    (if (zerop suffix-len)
+	file
+      (cond ((null ext) (setq ext (concat "." suffix)))
+	    ((<= (+ ext-len suffix-len) 4)
+	     (setq ext (concat ext suffix)))
+	    (t (setq ext (concat "." (substring ext 1
+						(- 4 suffix-len)) suffix))))
+      (concat (car split) base ext))))
+
+(setq completion-ignored-extensions
+      (append completion-ignored-extensions
+	      (list ".com" ".exe" ".dll" ".obj" ".bak" ".zip" ".arj" ".lzh"
+		    ".ico" ".zoo" ".Z" ".gz")))
+
+(setq meta-flag t)
+(setq default-ctl-arrow 1)
+
+
+;
+; Display names of special keys -- requires patched GNU Emacs
+;
+(defun key-description (keys)
+  "Return a pretty description of key-sequence KEYS.
+Control characters turn into \"C-foo\" sequences, meta into \"M-foo\"
+the names of PC function keys are inserted,
+spaces are put between sequence elements, etc."
+  (let ((result "") (add "") (index 0) (len (length keys)) char new)
+    (while (< index len)
+      (setq char (elt keys index))
+      (setq index (1+ index))
+      (cond
+       ;;--------required for Emacs without 8-bit keymaps---------
+       ;; ((and (zerop char) (< (1+ index) len)
+       ;; (= (elt keys index) 27)
+       ;;	  (setq new (aref pc-function-keys
+       ;;			  (+ (elt keys (1+ index)) 128))))
+       ;;   (setq index (+ index 2)))
+       ((and (zerop char) (< index len)
+             (setq new (aref pc-function-keys (elt keys index))))
+        (setq index (1+ index)))
+       (t (setq new (single-key-description char))))
+      (setq result (concat result add new))
+      (setq add " "))
+    result))
+
+(defvar pc-function-keys (make-vector 256 nil)
+  "Array containing descriptions of the PC function keys.")
+
+(aset pc-function-keys	 1 "A-ESC")
+(aset pc-function-keys   3 "C-2")
+(aset pc-function-keys	14 "A-BS")
+(aset pc-function-keys	15 "BTAB")
+(aset pc-function-keys	16 "A-q")
+(aset pc-function-keys	17 "A-w")
+(aset pc-function-keys	18 "A-e")
+(aset pc-function-keys	19 "A-r")
+(aset pc-function-keys	20 "A-t")
+(aset pc-function-keys	21 "A-y")
+(aset pc-function-keys	22 "A-u")
+(aset pc-function-keys	23 "A-i")
+(aset pc-function-keys	24 "A-o")
+(aset pc-function-keys	25 "A-p")
+(aset pc-function-keys	27 "A-[")
+(aset pc-function-keys	28 "A-]")
+(aset pc-function-keys	29 "A-RET")
+(aset pc-function-keys	30 "A-a")
+(aset pc-function-keys	31 "A-s")
+(aset pc-function-keys	32 "A-d")
+(aset pc-function-keys	33 "A-f")
+(aset pc-function-keys	34 "A-g")
+(aset pc-function-keys	35 "A-h")
+(aset pc-function-keys	36 "A-j")
+(aset pc-function-keys	37 "A-k")
+(aset pc-function-keys	38 "A-l")
+(aset pc-function-keys	39 "A-;")
+(aset pc-function-keys	40 "A-`")
+(aset pc-function-keys	43 "A-\\")
+(aset pc-function-keys	44 "A-z")
+(aset pc-function-keys	45 "A-x")
+(aset pc-function-keys	46 "A-c")
+(aset pc-function-keys	47 "A-v")
+(aset pc-function-keys	48 "A-b")
+(aset pc-function-keys	49 "A-n")
+(aset pc-function-keys	50 "A-m")
+(aset pc-function-keys	51 "A-,")
+(aset pc-function-keys	52 "A-.")
+(aset pc-function-keys	53 "A-/")
+(aset pc-function-keys	55 "A-NUM*")
+(aset pc-function-keys	59 "F1")
+(aset pc-function-keys	60 "F2")
+(aset pc-function-keys	61 "F3")
+(aset pc-function-keys	62 "F4")
+(aset pc-function-keys	63 "F5")
+(aset pc-function-keys	64 "F6")
+(aset pc-function-keys	65 "F7")
+(aset pc-function-keys	66 "F8")
+(aset pc-function-keys	67 "F9")
+(aset pc-function-keys	68 "F10")
+(aset pc-function-keys	71 "HOME")
+(aset pc-function-keys	72 "UP")
+(aset pc-function-keys	73 "PAGEUP")
+(aset pc-function-keys	74 "A-NUM-")
+(aset pc-function-keys	75 "LEFT")
+(aset pc-function-keys	76 "CENTER")
+(aset pc-function-keys	77 "RIGHT")
+(aset pc-function-keys	78 "A-NUM+")
+(aset pc-function-keys	79 "END")
+(aset pc-function-keys	80 "DOWN")
+(aset pc-function-keys	81 "PAGEDOWN")
+(aset pc-function-keys	82 "INSERT")
+(aset pc-function-keys	83 "DELETE")
+(aset pc-function-keys	84 "S-F1")
+(aset pc-function-keys	85 "S-F2")
+(aset pc-function-keys	86 "S-F3")
+(aset pc-function-keys	87 "S-F4")
+(aset pc-function-keys	88 "S-F5")
+(aset pc-function-keys	89 "S-F6")
+(aset pc-function-keys	90 "S-F7")
+(aset pc-function-keys	91 "S-F8")
+(aset pc-function-keys	92 "S-F9")
+(aset pc-function-keys	93 "S-F10")
+(aset pc-function-keys	94 "C-F1")
+(aset pc-function-keys	95 "C-F2")
+(aset pc-function-keys	96 "C-F3")
+(aset pc-function-keys	97 "C-F4")
+(aset pc-function-keys	98 "C-F5")
+(aset pc-function-keys	99 "C-F6")
+(aset pc-function-keys 100 "C-F7")
+(aset pc-function-keys 101 "C-F8")
+(aset pc-function-keys 102 "C-F9")
+(aset pc-function-keys 103 "C-F10")
+(aset pc-function-keys 104 "A-F1")
+(aset pc-function-keys 105 "A-F2")
+(aset pc-function-keys 106 "A-F3")
+(aset pc-function-keys 107 "A-F4")
+(aset pc-function-keys 108 "A-F5")
+(aset pc-function-keys 109 "A-F6")
+(aset pc-function-keys 110 "A-F7")
+(aset pc-function-keys 111 "A-F8")
+(aset pc-function-keys 112 "A-F9")
+(aset pc-function-keys 113 "A-F10")
+(aset pc-function-keys 114 "C-PRTSC")
+(aset pc-function-keys 115 "C-LEFT")
+(aset pc-function-keys 116 "C-RIGHT")
+(aset pc-function-keys 117 "C-END")
+(aset pc-function-keys 118 "C-PAGEDOWN")
+(aset pc-function-keys 119 "C-HOME")
+(aset pc-function-keys 120 "A-1")
+(aset pc-function-keys 121 "A-2")
+(aset pc-function-keys 122 "A-3")
+(aset pc-function-keys 123 "A-4")
+(aset pc-function-keys 124 "A-5")
+(aset pc-function-keys 125 "A-6")
+(aset pc-function-keys 126 "A-7")
+(aset pc-function-keys 127 "A-8")
+(aset pc-function-keys 128 "A-9")
+(aset pc-function-keys 132 "C-PAGEUP")
+(aset pc-function-keys 133 "F11")
+(aset pc-function-keys 134 "F12")
+(aset pc-function-keys 135 "S-F11")
+(aset pc-function-keys 136 "S-F12")
+(aset pc-function-keys 137 "C-F11")
+(aset pc-function-keys 138 "C-F12")
+(aset pc-function-keys 139 "A-F11")
+(aset pc-function-keys 140 "A-F12")
+(aset pc-function-keys 141 "C-UP")
+(aset pc-function-keys 142 "C-NUM-")
+(aset pc-function-keys 143 "C-CENTER")
+(aset pc-function-keys 144 "C-NUM+")
+(aset pc-function-keys 145 "C-DOWN")
+(aset pc-function-keys 146 "C-INSERT")
+(aset pc-function-keys 147 "C-DELETE")
+(aset pc-function-keys 148 "C-TAB")
+(aset pc-function-keys 149 "C-NUM/")
+(aset pc-function-keys 150 "C-NUM*")
+(aset pc-function-keys 151 "A-HOME")
+(aset pc-function-keys 152 "A-UP")
+(aset pc-function-keys 153 "A-PAGEUP")
+(aset pc-function-keys 155 "A-LEFT")
+(aset pc-function-keys 157 "A-RIGHT")
+(aset pc-function-keys 159 "A-END")
+(aset pc-function-keys 160 "A-DOWN")
+(aset pc-function-keys 161 "A-PAGEDOWN")
+(aset pc-function-keys 162 "A-INSERT")
+(aset pc-function-keys 163 "A-DELETE")
+(aset pc-function-keys 164 "A-NUM/")
+(aset pc-function-keys 165 "A-TAB")
+(aset pc-function-keys 166 "A-ENTER")
+;;
+
+(setq shell-prompt-pattern "^\\[.*\\] *")
+(setq shell-file-name "cmd")
+(setq null-filename "nul")
+(setq shell-command-option "\/c")
+(set-default-file-coding-system *sjis*dos)
+(set-display-coding-system *sjis*)
+(set-keyboard-coding-system *sjis*)
diff -urP /mule-1.1/lisp/picture.el ./lisp/picture.el
--- /mule-1.1/lisp/picture.el	Mon Mar 14 14:44:08 1994
+++ ./lisp/picture.el	Wed Mar 23 17:23:18 1994
@@ -211,7 +211,8 @@
 Do \\[command-apropos]  picture-movement  to see those commands."
   (interactive "p")
   (while (> arg 0)			; 89.9.7 by K.Handa
-    (picture-insert-string (make-string arg last-input-char))))
+    (picture-insert-string (make-string arg last-input-char))
+    (setq arg 0)))			; 94.3.23 by O.Sasaki
 
 ;;; 89.9.7  by K.Handa
 (defun picture-insert-after-hook (begin end)
diff -urP /mule-1.1/lisp/shell.el ./lisp/shell.el
--- /mule-1.1/lisp/shell.el	Tue May 25 22:42:42 1993
+++ ./lisp/shell.el	Mon Sep 27 16:47:06 1993
@@ -132,7 +132,7 @@
   (let* ((prog (or explicit-shell-file-name
 		   (getenv "ESHELL")
 		   (getenv "SHELL")
-		   "/bin/sh"))		     
+		   "cmd"))		     
 	 (name (file-name-nondirectory prog)))
     (switch-to-buffer
      (apply 'make-shell "shell" prog
@@ -141,7 +141,7 @@
 	    (let ((symbol (intern-soft (concat "explicit-" name "-args"))))
 	      (if (and symbol (boundp symbol))
 		  (symbol-value symbol)
-		'("-i")))))))
+		'("/q" "/s")))))))
 
 (defun make-shell (name program &optional startfile &rest switches)
   (let ((buffer (get-buffer-create (concat "*" name "*")))
@@ -156,15 +156,16 @@
 	(if proc (delete-process proc))
 	(setq proc (apply 'start-process name buffer
 			  (concat exec-directory "env")
-			  (format "TERMCAP=emacs:co#%d:tc=unknown:"
+			  (format "TERMCAP=/emx/etc/termcap.dat"
 				  (screen-width))
-			  "TERM=emacs"
+			  "TERM=mono"
 			  "EMACS=t"
+                          "PROMPT=[$p]"
 			  "-"
 			  (or program explicit-shell-file-name
 			      (getenv "ESHELL")
 			      (getenv "SHELL")
-			      "/bin/sh")
+			      "cmd")
 			  switches))
 	(cond (startfile
 	       ;;This is guaranteed to wait long enough
@@ -237,13 +238,13 @@
 
 (defun shell-set-directory ()
   (cond ((and (looking-at shell-popd-regexp)
-	      (memq (char-after (match-end 0)) '(?\; ?\n)))
+	      (memq (char-after (match-end 0)) '(?\& ?\n)))
 	 (if shell-directory-stack
 	     (progn
 	       (cd (car shell-directory-stack))
 	       (setq shell-directory-stack (cdr shell-directory-stack)))))
 	((looking-at shell-pushd-regexp)
-	 (cond ((memq (char-after (match-end 0)) '(?\; ?\n))
+	 (cond ((memq (char-after (match-end 0)) '(?\& ?\n))
 		(if shell-directory-stack
 		    (let ((old default-directory))
 		      (cd (car shell-directory-stack))
@@ -260,14 +261,14 @@
 				  (buffer-substring
 				    (point)
 				    (progn
-				      (skip-chars-forward "^\n \t;")
+				      (skip-chars-forward "^\n \t&")
 				      (point)))))))
 		      (progn
 			(setq shell-directory-stack
 			      (cons default-directory shell-directory-stack))
 			(cd dir)))))))
 	((looking-at shell-cd-regexp)
-	 (cond ((memq (char-after (match-end 0)) '(?\; ?\n))
+	 (cond ((memq (char-after (match-end 0)) '(?\& ?\n))
 		(cd (getenv "HOME")))
 	       ((memq (char-after (match-end 0)) '(?\  ?\t))
 		(let (dir)
@@ -280,7 +281,7 @@
 				  (buffer-substring
 				    (point)
 				    (progn
-				      (skip-chars-forward "^\n \t;")
+				      (skip-chars-forward "^\n \t&")
 				      (point)))))))
 		      (cd dir))))))))
   
diff -urP /mule-1.1/lisp/x-mouse.el ./lisp/x-mouse.el
--- /mule-1.1/lisp/x-mouse.el	Thu May 27 03:21:30 1993
+++ ./lisp/x-mouse.el	Mon Mar 28 19:35:16 1994
@@ -1,4 +1,4 @@
-;; Mouse support for X window system.
+;; Mouse support for OS/2 PM window system.
 ;; Copyright (C) 1985, 1987 Free Software Foundation, Inc.
 
 ;; This file is part of GNU Emacs.
@@ -32,69 +32,69 @@
 (defvar x-cut-text-attribute 'inverse
   "*Charcater attribute to show the region of cut text.") ;92.10.19 by K.Handa
 
-(defconst x-button-right (char-to-string 0))
-(defconst x-button-middle (char-to-string 1))
-(defconst x-button-left (char-to-string 2))
-
-(defconst x-button-right-up (char-to-string 4))
-(defconst x-button-middle-up (char-to-string 5))
-(defconst x-button-left-up (char-to-string 6))
-
-(defconst x-button-s-right (char-to-string 16))
-(defconst x-button-s-middle (char-to-string 17))
-(defconst x-button-s-left (char-to-string 18))
-
-(defconst x-button-s-right-up (char-to-string 20))
-(defconst x-button-s-middle-up (char-to-string 21))
-(defconst x-button-s-left-up (char-to-string 22))
-
-(defconst x-button-m-right (char-to-string 32))
-(defconst x-button-m-middle (char-to-string 33))
-(defconst x-button-m-left (char-to-string 34))
-
-(defconst x-button-m-right-up (char-to-string 36))
-(defconst x-button-m-middle-up (char-to-string 37))
-(defconst x-button-m-left-up (char-to-string 38))
-
-(defconst x-button-c-right (char-to-string 64))
-(defconst x-button-c-middle (char-to-string 65))
-(defconst x-button-c-left (char-to-string 66))
-
-(defconst x-button-c-right-up (char-to-string 68))
-(defconst x-button-c-middle-up (char-to-string 69))
-(defconst x-button-c-left-up (char-to-string 70))
-
-(defconst x-button-m-s-right (char-to-string 48))
-(defconst x-button-m-s-middle (char-to-string 49))
-(defconst x-button-m-s-left (char-to-string 50))
-
-(defconst x-button-m-s-right-up (char-to-string 52))
-(defconst x-button-m-s-middle-up (char-to-string 53))
-(defconst x-button-m-s-left-up (char-to-string 54))
-
-(defconst x-button-c-s-right (char-to-string 80))
-(defconst x-button-c-s-middle (char-to-string 81))
-(defconst x-button-c-s-left (char-to-string 82))
-
-(defconst x-button-c-s-right-up (char-to-string 84))
-(defconst x-button-c-s-middle-up (char-to-string 85))
-(defconst x-button-c-s-left-up (char-to-string 86))
-
-(defconst x-button-c-m-right (char-to-string 96))
-(defconst x-button-c-m-middle (char-to-string 97))
-(defconst x-button-c-m-left (char-to-string 98))
-
-(defconst x-button-c-m-right-up (char-to-string 100))
-(defconst x-button-c-m-middle-up (char-to-string 101))
-(defconst x-button-c-m-left-up (char-to-string 102))
-
-(defconst x-button-c-m-s-right (char-to-string 112))
-(defconst x-button-c-m-s-middle (char-to-string 113))
-(defconst x-button-c-m-s-left (char-to-string 114))
-
-(defconst x-button-c-m-s-right-up (char-to-string 116))
-(defconst x-button-c-m-s-middle-up (char-to-string 117))
-(defconst x-button-c-m-s-left-up (char-to-string 118))
+(defconst x-button-left (char-to-string 1))
+(defconst x-button-middle (char-to-string 2))
+(defconst x-button-right (char-to-string 3))
+
+(defconst x-button-left-up (char-to-string 5))
+(defconst x-button-middle-up (char-to-string 6))
+(defconst x-button-right-up (char-to-string 7))
+
+(defconst x-button-s-left (char-to-string 33))
+(defconst x-button-s-middle (char-to-string 34))
+(defconst x-button-s-right (char-to-string 35))
+
+(defconst x-button-s-left-up (char-to-string 37))
+(defconst x-button-s-middle-up (char-to-string 38))
+(defconst x-button-s-right-up (char-to-string 39))
+
+(defconst x-button-m-left (char-to-string 129))
+(defconst x-button-m-middle (char-to-string 130))
+(defconst x-button-m-right (char-to-string 131))
+
+(defconst x-button-m-left-up (char-to-string 133))
+(defconst x-button-m-middle-up (char-to-string 134))
+(defconst x-button-m-right-up (char-to-string 135))
+
+(defconst x-button-c-left (char-to-string 65))
+(defconst x-button-c-middle (char-to-string 66))
+(defconst x-button-c-right (char-to-string 67))
+
+(defconst x-button-c-left-up (char-to-string 69))
+(defconst x-button-c-middle-up (char-to-string 70))
+(defconst x-button-c-right-up (char-to-string 71))
+
+(defconst x-button-m-s-left (char-to-string 161))
+(defconst x-button-m-s-middle (char-to-string 162))
+(defconst x-button-m-s-right (char-to-string 163))
+
+(defconst x-button-m-s-left-up (char-to-string 165))
+(defconst x-button-m-s-middle-up (char-to-string 166))
+(defconst x-button-m-s-right-up (char-to-string 167))
+
+(defconst x-button-c-s-left (char-to-string 97))
+(defconst x-button-c-s-middle (char-to-string 98))
+(defconst x-button-c-s-right (char-to-string 99))
+
+(defconst x-button-c-s-left-up (char-to-string 101))
+(defconst x-button-c-s-middle-up (char-to-string 102))
+(defconst x-button-c-s-right-up (char-to-string 103))
+
+(defconst x-button-c-m-left (char-to-string 193))
+(defconst x-button-c-m-middle (char-to-string 194))
+(defconst x-button-c-m-right (char-to-string 195))
+
+(defconst x-button-c-m-left-up (char-to-string 197))
+(defconst x-button-c-m-middle-up (char-to-string 198))
+(defconst x-button-c-m-right-up (char-to-string 199))
+
+(defconst x-button-c-m-s-left (char-to-string 225))
+(defconst x-button-c-m-s-middle (char-to-string 226))
+(defconst x-button-c-m-s-right (char-to-string 227))
+
+(defconst x-button-c-m-s-left-up (char-to-string 229))
+(defconst x-button-c-m-s-middle-up (char-to-string 230))
+(defconst x-button-c-m-s-right-up (char-to-string 231))
 
 (defvar x-process-mouse-hook nil
   "Hook to run after each mouse event is processed.  Should take two
@@ -161,6 +161,11 @@
   (if (x-mouse-select arg)
       (split-window-vertically nil)))
 
+(defun pm-mouse-select-and-split-h (arg)
+  "Select Emacs window mouse is on, then split it horizontally in half."
+  (if (x-mouse-select arg)
+      (split-window-horizontally nil)))
+
 (defun x-mouse-set-point (arg)
   "Select Emacs window mouse is on, and move point to mouse position."
   (let* ((relative-coordinate (x-mouse-select arg))
@@ -245,19 +250,33 @@
 (defun x-buffer-menu (arg)
   "Pop up a menu of buffers for selection with the mouse."
   (let ((menu
-	 (list "Buffer Menu"
+	 (list "obt@ j["
 	       (cons "Select Buffer"
 		     (let ((tail (buffer-list))
+			   (maxbuf 0)
 			   head)
 		       (while tail
+			 (or (eq ?\ (aref (buffer-name (car tail)) 0))
+			     (setq maxbuf
+				   (max maxbuf
+					(length (buffer-name (car tail))))))
+			 (setq tail (cdr tail)))
+		       (setq tail (buffer-list))
+		       (while tail
 			 (let ((elt (car tail)))
 			   (if (not (string-match "^ "
 						  (buffer-name elt)))
 			       (setq head (cons
 					   (cons
 					    (format
-					     "%14s   %s"
+					     (format "%%%ds %%s%%s %%s"
+						     maxbuf)
 					     (buffer-name elt)
+					     (if (buffer-modified-p elt)
+						 "*" " ")
+					     (save-excursion
+					       (set-buffer elt)
+					       (if buffer-read-only "%" " "))
 					     (or (buffer-file-name elt) ""))
 					    elt)
 					   head))))
@@ -270,71 +289,180 @@
   (let ((selection
 	 (x-popup-menu
 	  arg
-	  '("Help" ("Is there a command that..."
-		    ("Command apropos" . command-apropos)
-		    ("Apropos" . apropos))
-		   ("Key Commands <==> Functions"
-		    ("List all keystroke commands" . describe-bindings)
-		    ("Describe key briefly" . describe-key-briefly)
-		    ("Describe key verbose" . describe-key)
-		    ("Describe Lisp function" . describe-function)
-		    ("Where is this command" . where-is))
-		   ("Manual and tutorial"
-		    ("Info system" . info)
-		    ("Invoke Emacs tutorial" . help-with-tutorial))
-		   ("Odds and ends"
-		    ("Last 100 Keystrokes" . view-lossage)
-		    ("Describe syntax table" . describe-syntax))
-		   ("Modes"
-		    ("Describe current major mode" . describe-mode)
-		    ("List all keystroke commands" . describe-bindings))
-		   ("Administrivia"
-		    ("View Emacs news" . view-emacs-news)
-		    ("View the GNU Emacs license" . describe-copying)
-		    ("Describe distribution" . describe-distribution)
-		    ("Describe (non)warranty" . describe-no-warranty))))))
+	  '("wv"
+	    (""
+	     ("񌟍(R}ĥ)" . command-apropos)
+	     ("񌟍" . apropos))
+	    ("L[`A֐"
+	     ("SL[ER}h\" . describe-bindings)
+	     ("L[`ˊ֐\" . describe-key-briefly)
+	     ("L[`ːƊ֐\" . describe-key)
+	     ("֐ː\" . describe-function)
+	     ("֐˃L[`" . where-is))
+	    ("}jA"
+	     ("InfovO" . info)
+	     ("Mule`[gA" . help-with-tutorial-for-mule)
+	     ("Emacs`[gA" . help-with-tutorial))
+	    ("Odds and ends"
+	     ("͗" . view-lossage)
+	     ("\e[u" . describe-syntax))
+	    ("[h"
+	     ("[h" . describe-mode)
+	     ("SL[ER}h" . describe-bindings))
+	    ("^c"
+	     ("j[X" . view-emacs-news)
+	     ("쌠" . describe-copying)
+	     ("zz" . describe-distribution)
+	     ("ۏ" . describe-no-warranty))))))
     (and selection (call-interactively selection))))
 
+(defun pm-select-font (arg)
+  "PMMulẽtHg؂芷"
+  (let ((selection
+	 (x-popup-menu
+	  arg
+	  '("tHgI"
+	    ("MINCHO"
+	     ("6pt"	"6.MINCHO")
+	     ("8pt"	"8.MINCHO")
+	     ("10pt"	"10.MINCHO")
+	     ("11pt"	"11.MINCHO")
+	     ("12pt"	"12.MINCHO")
+	     ("14pt"	"14.MINCHO")
+;	     ("17pt"	"17.MINCHO")
+;	     ("18pt"	"18.MINCHO")
+;	     ("19pt"	"19.MINCHO")
+	     )
+	    ("MINCHO System"
+	     ("6pt"	"6.MINCHO System")
+	     ("8pt"	"8.MINCHO System")
+	     ("10pt"	"10.MINCHO System")
+	     ("11pt"	"11.MINCHO System")
+	     ("12pt"	"12.MINCHO System")
+	     ("14pt"	"14.MINCHO System")
+;	     ("17pt"	"17.MINCHO System")
+;	     ("18pt"	"18.MINCHO System")
+;	     ("19pt"	"19.MINCHO System")
+	     )
+	    ("MINCHO Terminal"
+	     ("6pt"	"6.MINCHO Terminal")
+	     ("8pt"	"8.MINCHO Terminal"))
+	    ("GOTHIC"
+	     ("6pt"	"6.GOTHIC")
+	     ("8pt"	"8.GOTHIC")
+	     ("10pt"	"10.GOTHIC")
+	     ("11pt"	"11.GOTHIC")
+	     ("12pt"	"12.GOTHIC")
+	     ("14pt"	"14.GOTHIC")
+;	     ("17pt"	"17.GOTHIC")
+;	     ("18pt"	"18.GOTHIC")
+;	     ("19pt"	"19.GOTHIC")
+	     )
+	    ("GOTHIC System"
+	     ("6pt"	"6.GOTHIC System")
+	     ("8pt"	"8.GOTHIC System")
+	     ("10pt"	"10.GOTHIC System")
+	     ("11pt"	"11.GOTHIC System")
+	     ("12pt"	"12.GOTHIC System")
+	     ("14pt"	"14.GOTHIC System")
+;	     ("17pt"	"17.GOTHIC System")
+;	     ("18pt"	"18.GOTHIC System")
+;	     ("19pt"	"19.GOTHIC System")
+	     )
+	    ("GOTHIC Terminal"
+	     ("6pt"	"6.GOTHIC Terminal")
+	     ("8pt"	"8.GOTHIC Terminal"))
+	    ("Courier"
+	     ("8pt"	"8.Courier")
+	     ("10pt"	"10.Courier")
+	     ("12pt"	"12.Courier"))
+	    ("System Monospaced"
+	     ("8pt"	"8.System Monospaced")
+	     ("10pt"	"10.System Monospaced"))
+;	    ("outline test font"
+;	     ("24pt"	"24.GOTHIC HeiseiKakuGothic-W5-H-78")
+;	     ("48pt"	"48.GOTHIC HeiseiKakuGothic-W5-H-78"))
+	    ))))
+    (and selection (pm-set-font (car selection)))))
+
 ; Prevent beeps on button-up.  If the button isn't bound to anything, it
 ; will beep on button-down.
-(define-key mouse-map x-button-right-up 'x-mouse-ignore)
-(define-key mouse-map x-button-middle-up 'x-mouse-ignore)
 (define-key mouse-map x-button-left-up 'x-mouse-ignore)
-(define-key mouse-map x-button-s-right-up 'x-mouse-ignore)
-(define-key mouse-map x-button-s-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-right-up 'x-mouse-ignore)
 (define-key mouse-map x-button-s-left-up 'x-mouse-ignore)
-(define-key mouse-map x-button-m-right-up 'x-mouse-ignore)
-(define-key mouse-map x-button-m-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-s-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-s-right-up 'x-mouse-ignore)
 (define-key mouse-map x-button-m-left-up 'x-mouse-ignore)
-(define-key mouse-map x-button-c-right-up 'x-mouse-ignore)
-(define-key mouse-map x-button-c-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-m-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-m-right-up 'x-mouse-ignore)
 (define-key mouse-map x-button-c-left-up 'x-mouse-ignore)
-(define-key mouse-map x-button-m-s-right-up 'x-mouse-ignore)
-(define-key mouse-map x-button-m-s-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-c-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-c-right-up 'x-mouse-ignore)
 (define-key mouse-map x-button-m-s-left-up 'x-mouse-ignore)
-(define-key mouse-map x-button-c-s-right-up 'x-mouse-ignore)
-(define-key mouse-map x-button-c-s-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-m-s-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-m-s-right-up 'x-mouse-ignore)
 (define-key mouse-map x-button-c-s-left-up 'x-mouse-ignore)
-(define-key mouse-map x-button-c-m-right-up 'x-mouse-ignore)
-(define-key mouse-map x-button-c-m-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-c-s-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-c-s-right-up 'x-mouse-ignore)
 (define-key mouse-map x-button-c-m-left-up 'x-mouse-ignore)
-(define-key mouse-map x-button-c-m-s-right-up 'x-mouse-ignore)
-(define-key mouse-map x-button-c-m-s-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-c-m-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-c-m-right-up 'x-mouse-ignore)
 (define-key mouse-map x-button-c-m-s-left-up 'x-mouse-ignore)
+(define-key mouse-map x-button-c-m-s-middle-up 'x-mouse-ignore)
+(define-key mouse-map x-button-c-m-s-right-up 'x-mouse-ignore)
+
+(define-key mouse-map x-button-c-left 'x-buffer-menu)
+(define-key mouse-map x-button-c-middle 'x-help)
+(define-key mouse-map x-button-c-right 'pm-select-font)
 
-(define-key mouse-map x-button-c-s-left 'x-buffer-menu)
-(define-key mouse-map x-button-c-s-middle 'x-help)
-(define-key mouse-map x-button-c-s-right 'x-mouse-keep-one-window)
+(define-key mouse-map x-button-s-left 'x-cut-and-wipe-text)
 (define-key mouse-map x-button-s-middle 'x-cut-text)
 (define-key mouse-map x-button-s-right 'x-paste-text)
-(define-key mouse-map x-button-c-middle 'x-cut-and-wipe-text)
-(define-key mouse-map x-button-c-right 'x-mouse-select-and-split)
 
-(if (= window-system-version 10)
-    (progn
-      (define-key mouse-map x-button-right 'x-mouse-select)
-      (define-key mouse-map x-button-left 'x-mouse-set-mark)
-      (define-key mouse-map x-button-middle 'x-mouse-set-point))
-  (define-key mouse-map x-button-right 'x-cut-text)
-  (define-key mouse-map x-button-left 'x-mouse-set-point)
-  (define-key mouse-map x-button-middle 'x-paste-text))
+(define-key mouse-map x-button-m-left 'x-mouse-select-and-split)
+(define-key mouse-map x-button-m-middle 'pm-mouse-select-and-split-h)
+(define-key mouse-map x-button-m-right 'x-mouse-keep-one-window)
+
+(define-key mouse-map x-button-left 'x-mouse-set-point)
+(define-key mouse-map x-button-middle 'x-mouse-set-mark)
+(define-key mouse-map x-button-right 'x-mouse-select)
+
+;(define-key mouse-map x-button-c-s-left 'x-buffer-menu)
+;(define-key mouse-map x-button-c-s-middle 'x-help)
+;(define-key mouse-map x-button-c-s-right 'x-mouse-keep-one-window)
+;(define-key mouse-map x-button-s-middle 'x-cut-text)
+;(define-key mouse-map x-button-s-right 'x-paste-text)
+;(define-key mouse-map x-button-c-middle 'x-cut-and-wipe-text)
+;(define-key mouse-map x-button-c-right 'x-mouse-select-and-split)
+
+;(if (= window-system-version 10)
+;    (progn
+;      (define-key mouse-map x-button-right 'x-mouse-select)
+;      (define-key mouse-map x-button-left 'x-mouse-set-mark)
+;      (define-key mouse-map x-button-middle 'x-mouse-set-point))
+;  (define-key mouse-map x-button-right 'x-cut-text)
+;  (define-key mouse-map x-button-left 'x-mouse-set-point)
+;  (define-key mouse-map x-button-middle 'x-paste-text))
+
+;;;;; test
+(defun pm-test-font-list (arg)
+  "list font test"
+  ( let ((font (pm-list-fonts "*")))
+  (with-output-to-temp-buffer "*Font Table*"
+    (while font
+      (princ (car font))
+      (princ "\n")
+      (setq font (cdr font))))))
+
+(defun pm-test-get-config (arg)
+  "list config test"
+  ( let ((conf (pm-get-config)))
+  (with-output-to-temp-buffer "*Config Table*"
+    (while conf
+      (princ (car conf))
+      (princ "\n")
+      (setq conf (cdr conf))))))
+
+(define-key mouse-map x-button-c-s-left 'pm-test-font-list)
+(define-key mouse-map x-button-c-s-middle 'pm-test-get-config)
diff -urP /mule-1.1/src/buffer.c ./src/buffer.c
--- /mule-1.1/src/buffer.c	Mon Mar 14 14:45:58 1994
+++ ./src/buffer.c	Tue Mar 15 01:30:02 1994
@@ -1254,7 +1254,11 @@
   char buf[MAXPATHLEN+1];
 
   Fset_buffer (Fget_buffer_create (build_string ("*scratch*")));
+#ifdef OS2	/* 93.8.20 O.Sasaki */
+  if (_getcwd2(buf, MAXPATHLEN) == 0 || strlwr (buf) == 0)
+#else
   if (getwd (buf) == 0)
+#endif
     fatal ("`getwd' failed: %s.\n", buf);
 
 #ifndef VMS
diff -urP /mule-1.1/src/callint.c ./src/callint.c
--- /mule-1.1/src/callint.c	Wed May 26 23:02:16 1993
+++ ./src/callint.c	Tue Mar 15 01:32:26 1994
@@ -361,8 +361,12 @@
 
 	case 'k':		/* Key sequence (string) */
 	  args[i] = Fread_key_sequence (build_string (prompt));
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+          visargs[i] = call1 (Qkey_description, args[i]);
+#else
 	  teml = args[i];
 	  visargs[i] = Fkey_description (teml);
+#endif
 	  break;
 
 	case 'm':		/* Value of mark.  Does not do I/O.  */
diff -urP /mule-1.1/src/callproc.c ./src/callproc.c
--- /mule-1.1/src/callproc.c	Mon Mar 14 14:45:58 1994
+++ ./src/callproc.c	Tue Mar 15 05:44:22 1994
@@ -54,6 +54,14 @@
 
 #include "config.h"
 
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+#include <stdio.h>
+#include <process.h>
+extern char *_getcwd2();
+#endif
+/* end of patch */
+
 #define PRIO_PROCESS 0
 #include <sys/file.h>
 #ifdef USG5
@@ -199,8 +207,8 @@
 #ifdef VMS
     args[1] = build_string ("NLA0:");
 #else
-/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida, 93.8.20 O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
     args[1] = build_string ("nul");
 #else
     args[1] = build_string ("/dev/null");
@@ -249,8 +257,12 @@
 #if defined(MSDOS) || defined(WIN32)
   openp (Vexec_path, args[0], ".exe:.com:.bat:", &path, 1);
 #else
+#ifdef OS2 /* 91.8.20 by O.Sasaki */
+  openp (Vexec_path, args[0], ".exe:.com:.bat:.cmd:", &path, 1);
+#else
   openp (Vexec_path, args[0], "", &path, 1);
 #endif
+#endif /* OS2 */
 /* end of patch */
   if (NULL (path))
     {
@@ -268,7 +280,11 @@
 #ifdef WIN32 /* 93.2.17 by M.Higashida */
     fd[1] = open ("nul", O_WRONLY), fd[0] = -1;
 #else /* not WIN32 */
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+    fd[1] = open ("nul", 0), fd[0] = -1;
+#else /* not OS2 */
     fd[1] = open ("/dev/null", O_WRONLY), fd[0] = -1;
+#endif /* not OS2 */
 #endif /* not WIN32 */
 #endif /* not VMS */
   else
@@ -357,12 +373,19 @@
     if (pid == 0)
       {
 	if (fd[0] >= 0)
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+	  setmode (fd[0], O_TEXT);
+#else
 	  close (fd[0]);
+#endif
 #ifdef USG
 #ifdef HAVE_PTYS
 	setpgrp ();
 #endif
 #endif
+#ifdef OS2 /* 93.8.20 By O.Sasaki */
+        pid =
+#endif
 	child_setup (filefd, fd1, fd1, new_argv, env);
       }
 #endif /* not WIN32 */
@@ -391,6 +414,9 @@
 #ifndef subprocesses
       wait_without_blocking ();
 #endif subprocesses
+#ifdef OS2 /* 93.11.13 by O.Sasaki */
+      wait_for_termination (pid);
+#endif
       return Qnil;
     }
 
@@ -786,14 +812,23 @@
      register char **new_argv;
      char **env;
 {
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+  int saved_in, saved_out, saved_err;
+  char *org_cwd = 0;
+  char org_cwd_buf[512];
+#endif
+/* end of patch */
   register int pid = getpid();
 
   setpriority (PRIO_PROCESS, pid, 0);
 
+#ifndef OS2 /* 93.8.20 by O.Sasaki */
 #ifdef subprocesses
   /* Close Emacs's descriptors that this process should not have.  */
   close_process_descs ();
 #endif
+#endif
 
   /* Note that use of alloca is always safe here.  It's obvious for systems
      that do not have true vfork or that have true (stack) alloca.
@@ -809,9 +844,19 @@
       i = XSTRING (current_buffer->directory)->size;
       temp = (unsigned char *) alloca (i + 2);
       bcopy (XSTRING (current_buffer->directory)->data, temp, i);
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+      if (i > 1 && (temp[i-1] == '/' || temp[i-1] == '\\') && temp[i-2] != ':')
+        --i;
+      temp[i] = 0;
+      org_cwd = _getcwd2 (org_cwd_buf, sizeof (org_cwd_buf));
+      _chdir2 (temp);
+#else
       if (temp[i - 1] != '/') temp[i++] = '/';
       temp[i] = 0;
       chdir (temp);
+#endif
+/* end of patch */
     }
 
 #ifndef MAINTAIN_ENVIRONMENT
@@ -840,6 +885,13 @@
     *new_env = 0;
   }
 #endif /* Not MAINTAIN_ENVIRONMENT */
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+  saved_in = dup (0); fcntl (saved_in, F_SETFD, 1);
+  saved_out = dup (1); fcntl (saved_out, F_SETFD, 1);
+  saved_err = dup (2); fcntl (saved_err, F_SETFD, 1);
+#endif
+/* end of patch */
 
   close (0);
   close (1);
@@ -852,6 +904,13 @@
   close (out);
   close (err);
 
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+  /* Close Emacs's descriptors that this process should not have.  */
+  close_process_descs ();
+#endif
+/* end of patch */
+
 #ifdef USG
 #ifndef HAVE_PTYS
   setpgrp ();			/* No arguments but equivalent in this case */
@@ -868,12 +927,26 @@
   /* execvp does not accept an environment arg so the only way
      to pass this environment is to set environ.  Our caller
      is responsible for restoring the ambient value of environ.  */
+/* 93.8.20 by O.Sasaki */
+#ifndef OS2
   environ = env;
   execvp (new_argv[0], new_argv);
 
   write (1, "Couldn't exec the program ", 26);
   write (1, new_argv[0], strlen (new_argv[0]));
   _exit (1);
+#else
+  pid = spawnvpe (P_SESSION | P_MINIMIZE | P_BACKGROUND,
+                  new_argv[0], (const char * const *)new_argv,
+                  (const char * const *)env);
+  dup2 (saved_in, 0); close (saved_in);
+  dup2 (saved_out, 1); close (saved_out);
+  dup2 (saved_err, 2); close (saved_err);
+  if (org_cwd != 0)
+    _chdir2 (org_cwd);
+  return pid;
+#endif
+/* end of patch */
 }
 
 #endif /* not WIN32 */
@@ -888,8 +961,8 @@
   Lisp_Object execdir;
 
   /* Turn PATH_EXEC into a path.  Don't look at environment.  */
-/* 91.11.13 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.11.13 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   Vexec_path = decode_env_path ("EMACSEXECPATH", PATH_EXEC);
 #else
   Vexec_path = decode_env_path (0, PATH_EXEC);
@@ -907,22 +980,30 @@
     }
 
   sh = (char *) egetenv ("SHELL");
-/* 91.10.16 by S.Hirano, 93.6.1 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.6.1 by M.Higashida, 93.8.23 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   if (!sh) sh = egetenv("COMSPEC");
   {
     char *tem;
     if (sh)
       {
 	tem = (char *) alloca (strlen (sh) + 1);
+#ifdef OS2
+	sh = (char *)dostounix_filename (strcpy (tem, sh));
+#else
 	sh = dostounix_filename (strcpy (tem, sh));
+#endif
       }
   }
+#ifdef OS2
+  Vshell_file_name = build_string (sh ? sh : "/os2/cmd.exe");
+#else /* not OS2 */
 #ifdef WIN32
   Vshell_file_name = build_string (sh ? sh : "/winnt/system32/cmd.exe");
 #else /* MSDOS */
   Vshell_file_name = build_string (sh ? sh : "/command.com");
 #endif /* MSDOS */
+#endif /* OS2 */
 #else
   Vshell_file_name = build_string (sh ? sh : "/bin/sh");
 #endif
diff -urP /mule-1.1/src/dired.c ./src/dired.c
--- /mule-1.1/src/dired.c	Mon Mar 14 14:46:02 1994
+++ ./src/dired.c	Tue Mar 15 02:22:52 1994
@@ -463,14 +463,15 @@
   if (lstat (XSTRING (filename)->data, &s) < 0)
     return Qnil;
 
-/* 91.10.20, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.20, 93.2.17 by M.Higashida, 93.8.23 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   {
     char *tmpnam = XSTRING (Ffile_name_nondirectory (filename))->data;
     int l = strlen(tmpnam)+1;
     
     if (l > 5 && (strcmp (&tmpnam[l-5], ".com") == 0 ||
 		  strcmp (&tmpnam[l-5], ".exe") == 0 ||
+                  strcmp (&tmpnam[l-5], ".cmd") == 0 || /* 93.8.23 O.Sasaki */
 		  strcmp (&tmpnam[l-5], ".bat") == 0))
       {
 	s.st_mode |= S_IEXEC;
diff -urP /mule-1.1/src/dispnew.c ./src/dispnew.c
--- /mule-1.1/src/dispnew.c	Mon Mar 14 14:44:32 1994
+++ ./src/dispnew.c	Tue Mar 15 02:27:14 1994
@@ -809,7 +809,11 @@
   register struct display_line *l, *lnew;
   register int i;
   int pause;
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  int preempt_count = 20;
+#else
   int preempt_count = baud_rate / 2400 + 1;
+#endif
   extern input_pending;
 
   if (screen_height == 0) abort (); /* Some bug zeros some core */
@@ -1790,6 +1794,9 @@
 #ifdef WIN32
   extern Lisp_Object Vwin32term;
 #endif
+#ifdef OS2PM /* 93.12.14 by O.Sasaki */
+  extern Lisp_Object Vos2pmterm;
+#endif
 #ifdef HAVE_X_WINDOWS
   Vxterm = Qnil;
 #endif
@@ -1802,6 +1809,9 @@
 #ifdef WIN32
   Vwin32term = Qnil;
 #endif
+#ifdef OS2PM /* 93.12.14 by O.Sasaki */
+  Vos2pmterm = Qnil;
+#endif
 /* end of patch */
 
   Vwindow_system = Qnil;
@@ -1857,6 +1867,13 @@
       Vwindow_system = intern ("win32");
       goto term_init_done;
 #endif /* WIN32 */
+#ifdef OS2PM /* 93.12.14 by O.Sasaki */
+      os2pm_term_init ();
+      Vos2pmterm = Qt;
+      Vwindow_system = intern ("os2pm");
+      Vwindow_system_version = intern ("2X"); /* 93.12.16 by O.Sasaki */
+      goto term_init_done;
+#endif /* OS2PM */
       ;
     }
 /* end of patch */
diff -urP /mule-1.1/src/doc.c ./src/doc.c
--- /mule-1.1/src/doc.c	Wed Jun 02 09:33:24 1993
+++ ./src/doc.c	Tue Mar 15 02:38:18 1994
@@ -37,7 +37,7 @@
 #define NULL(x)  (XFASTINT (x) == XFASTINT (Qnil))
 #endif
 
-#ifdef USG5
+#if defined(USG5) || defined(OS2) /* 93.8.20 by O.Sasaki */
 #include <fcntl.h>
 #endif
 
@@ -308,17 +308,29 @@
   int idx;
   int bsize;
   unsigned char *new;
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  Lisp_Object tem;
+#else
   register Lisp_Object tem;
+#endif
   Lisp_Object keymap;
   unsigned char *start;
   int length;
   struct gcpro gcpro1; 
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  struct gcpro gcpro2;
+  struct gcpro gcpro3;
+#endif /* not OS2 */
 
   if (NULL (str))
     return Qnil;
 
   CHECK_STRING (str, 0);
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  GCPRO3 (str, tem, keymap)
+#else
   GCPRO1 (str);
+#endif
 
   keymap = current_buffer->keymap;
 
@@ -364,7 +376,13 @@
 	    }
 	  else
 	    {			/* function is on a key */
-	      tem = Fkey_description (tem);
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+              tem = call1 (Qkey_description, tem);
+#else
+              tem = Fkey_description (tem);
+#endif
+/* end of patch */
 	      goto subst_string;
 	    }
 	}
diff -urP /mule-1.1/src/editfns.c ./src/editfns.c
--- /mule-1.1/src/editfns.c	Mon Mar 14 14:46:02 1994
+++ ./src/editfns.c	Tue Mar 15 02:38:52 1994
@@ -116,6 +116,9 @@
       user_name = pw ? pw->pw_name : "unknown";
     }
   Vuser_name = build_string (user_name);
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  Vuser_real_name = build_string (user_name);
+#endif
 
   /* If the user name claimed in the environment vars differs from
      the real uid, use the claimed name to find the full name.  */
diff -urP /mule-1.1/src/emacs.c ./src/emacs.c
--- /mule-1.1/src/emacs.c	Mon Mar 14 14:44:32 1994
+++ ./src/emacs.c	Tue Mar 15 03:08:50 1994
@@ -131,6 +131,9 @@
 #endif
 #endif
 #endif
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+#include <sys/stat.h>
+#endif
 /* end of patch */
 
 #ifndef O_RDWR
@@ -190,6 +193,10 @@
 /* Nonzero if handling a fatal error already */
 int fatal_error_in_progress;
 
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+void ctrl_break_signal();
+#endif
+
 /* Handle bus errors, illegal instruction, etc. */
 fatal_error_signal (sig)
      int sig;
@@ -276,10 +283,13 @@
 #ifdef WIN32
 char **environ;
 #endif
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+extern char **environ;
+#endif
 /* end of patch */
 
-/* 92.11.4 by M.Higashida */
-#if defined(MSDOS) && defined(EMX)
+/* 92.11.4 by M.Higashida, 93.8.17 by O.Sasaki */
+#if (defined(MSDOS) && defined(EMX)) || defined(OS2)
 /* Setup all of files be input/output'ed with binary translation mdoe. */
 asm ("	.text");
 asm ("L_setbinmode:");
@@ -289,6 +299,7 @@
 #endif
 /* end of patch */
 
+#ifndef OS2     /* 93.8.17 O.Sasaki */
 /* We don't include crtbegin.o and crtend.o in the link,
    so these functions and variables might be missed.
    Provide dummy definitions to avoid error.
@@ -307,6 +318,7 @@
 {}
 #endif /* not ORDINARY_LINK */
 #endif /* __GNUC__ */
+#endif /* OS2 */
 
 #ifdef NeXT
 #include <mach/mach.h>
@@ -368,6 +380,9 @@
 #ifdef WIN32
   environ = envp;
 #endif
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  environ = envp;
+#endif
 /* end of patch */
 
 #ifdef USG_SHARED_LIBRARIES
@@ -436,8 +451,8 @@
       open (argv[skip_args], O_RDWR, 2 );
       dup (0);
       fprintf (stderr, "Using %s\n", argv[skip_args]);
-/* 92.3.31 by K.Handa, 92.10.21 by M.Higashida */
-#if defined (HAVE_X_WINDOWS) || defined (HAVE_SUN_CONSOLE) || (defined(MSDOS) && defined(HAVE_VGA_ADAPTER)) || defined (WIN32)
+/* 92.3.31 by K.Handa, 92.10.21 by M.Higashida, 93.12.14 by O.Sasaki */
+#if defined (HAVE_X_WINDOWS) || defined (HAVE_SUN_CONSOLE) || (defined(MSDOS) && defined(HAVE_VGA_ADAPTER)) || defined (WIN32) || defined (OS2PM)
       inhibit_window_system = 1;	/* -t => -nw */
 #endif
     }
@@ -481,6 +496,12 @@
 #ifdef WIN32
   inhibit_window_system = -1;
 #endif
+#ifdef OS2PM                    /* 93.12.14 by O.Sasaki */
+  if (skip_args + 1 < argc && (!strcmp (argv[skip_args + 1], "-w"))) {
+      inhibit_window_system = -1;
+      skip_args++;
+  }
+#endif
 /* end of patch */
   if (skip_args + 1 < argc
       && (!strcmp (argv[skip_args + 1], "-nw")))
@@ -510,6 +531,14 @@
   _tzset ();
 #endif
 
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+/* In batch mode, screen output should be normal, else binary */
+  if (! noninteractive)
+    setmode(1, O_BINARY);
+#endif
+/* end of patch */
+
   if (
 #ifndef CANNOT_DUMP
       ! noninteractive || initialized
@@ -536,7 +565,9 @@
       signal (SIGQUIT, fatal_error_signal);
       signal (SIGILL, fatal_error_signal);
       signal (SIGTRAP, fatal_error_signal);
+#ifndef OS2 /* 93.8.17 by O.Sasaki */
       signal (SIGIOT, fatal_error_signal);
+#endif
 #ifdef SIGEMT
       signal (SIGEMT, fatal_error_signal);
 #endif
@@ -552,6 +583,9 @@
       signal (SIGXFSZ, fatal_error_signal);
 #endif SIGXFSZ
 #endif /* not MSDOS and GO32 */
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+      signal (SIGBREAK, ctrl_break_signal);
+#endif /* OS2 */
 /* end of patch */
 
 #ifdef AIX
@@ -716,6 +750,9 @@
 #ifdef WIN32
       syms_of_win32term ();
 #endif
+#ifdef OS2PM			/* 93.12.14 by O.Sasaki */
+      syms_of_os2pmterm ();
+#endif
       syms_of_mc ();
       syms_of_ccl ();		/* 93.5.14 by K.Handa */
 #ifdef WNN4
@@ -898,8 +935,8 @@
 #ifndef SYSTEM_MALLOC
   malloc_init (&my_edata, malloc_warning);
 #endif
-/* 92.11.4 by M.Higashida */
-#if defined(MSDOS) && defined(EMX)
+/* 92.11.4 by M.Higashida, 93.8.20 O.Sasaki */
+#if (defined(MSDOS) && defined(EMX)) || defined(OS2)
   {
     int fd = open (XSTRING (intoname)->data,
                    O_WRONLY|O_CREAT|O_TRUNC, S_IREAD|S_IWRITE);
@@ -910,10 +947,10 @@
       close (fd);
     }
   }
-#else /* not MSDOS and EMX */
+#else /* not MSDOS and EMX or not OS2 */
   unexec (XSTRING (intoname)->data,
 	  !EQ (symname, Qnil) ? XSTRING (symname)->data : 0, &my_edata, 0, 0);
-#endif /* not MSDOS and EMX */
+#endif /* not MSDOS and EMX or not OS2 */
 /* end of patch */
 #endif /* not VMS */
 
@@ -929,12 +966,12 @@
 #ifdef VMS
 #define SEPCHAR ','
 #else
-/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
 #define SEPCHAR ';'
 #else
 #define SEPCHAR ':'
-#endif /* MSDOS or WIN32 */
+#endif /* MSDOS or WIN32 or OS2 */
 /* end of patch */
 #endif
 
@@ -953,8 +990,8 @@
     path = 0;
   if (!path)
     path = defalt;
-/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   dostounix_filename(path);
 #endif
 /* end of patch */
diff -urP /mule-1.1/src/fileio.c ./src/fileio.c
--- /mule-1.1/src/fileio.c	Mon Mar 14 14:46:04 1994
+++ ./src/fileio.c	Tue Mar 15 09:19:46 1994
@@ -167,6 +167,10 @@
 #ifdef WIN32
 #include <sys/param.h>
 #endif
+#ifdef OS2 /* 93.8.20 O.Sasaki */
+#include <fcntl.h>
+#include <sys/param.h>
+#endif
 /* end of patch */
 
 #ifndef O_WRONLY
@@ -232,10 +236,10 @@
 #ifdef VMS
 	 && p[-1] != ':' && p[-1] != ']' && p[-1] != '>'
 #endif /* VMS */
-/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   	 && p[-1] != ':'
-#endif /* MSDOS or WIN32 */
+#endif /* MSDOS or WIN32 or OS2 */
 /* end of patch */
 	 ) p--;
 
@@ -264,10 +268,10 @@
 #ifdef VMS
 	 && p[-1] != ':' && p[-1] != ']' && p[-1] != '>'
 #endif /* VMS */
-/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   	 && p[-1] != ':'
-#endif /* MSDOS or WIN32 */
+#endif /* MSDOS or WIN32 or OS2 */
 /* end of patch */
 	 ) p--;
 
@@ -341,10 +345,10 @@
     }
 #else /* not VMS */
   /* For Unix syntax, Append a slash if necessary */
-/* 91.10.20, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.20, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
     if (out[size] != ':')
-#endif /* MSDOS or WIN32 */
+#endif /* MSDOS or WIN32 or OS2 */
   if (out[size] != '/')
     strcat (out, "/");
 #endif /* not VMS */
@@ -507,12 +511,12 @@
   /* Process as Unix format: just remove any final slash.
      But leave "/" unchanged; do not change it to "".  */
   strcpy (dst, src);
-/* 91.10.20, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.20, 93.2.17 by M.Higashida, 93.8.20 O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
     if (slen > 1 && dst[slen] == '/' && dst[slen - 1] != ':')
-#else /* not MSDOS nor WIN32 */
+#else /* not MSDOS nor WIN32 nor OS2 */
     if (dst[slen] == '/' && slen > 0)
-#endif /* not MSDOS nor WIN32 */
+#endif /* not MSDOS nor WIN32 nor OS2 */
 /* end of patch */
     dst[slen] = 0;
   return 1;
@@ -552,6 +556,25 @@
      Lisp_Object prefix;
 {
   Lisp_Object val;
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+  char *p, *q;
+  int i;
+
+  CHECK_STRING (prefix, 0);
+  p = q = XSTRING (prefix)->data;
+  while (*p != 0)
+      {
+      if (*p == '/' || *p == ':' || *p == '\\')
+          q = p+1;
+      ++p;
+      }
+  p = XSTRING (prefix)->data;
+  i = q - p;
+  if (XSTRING (prefix)->size - i > 2)
+      prefix = make_string (XSTRING (prefix)->data, i + 2);
+#endif
+/* end of patch */
   val = concat2 (prefix, build_string ("XXXXXX"));
   mktemp (XSTRING (val)->data);
   return val;
@@ -582,8 +605,8 @@
   int lbrack = 0, rbrack = 0;
   int dots = 0;
 #endif /* VMS */
-/* 91.10.20, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.20, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   int drive = -1;
 #endif
 /* end of patch */
@@ -597,8 +620,8 @@
 
   nm = XSTRING (name)->data;
   
-/* 91.10.20, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.20, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   /* first of all, strip dirive name. */
   if (nm[1] == ':')
     {
@@ -607,6 +630,11 @@
     }
 #endif
 /* end of patch */
+/* 93.10.15 by O.Sasaki */
+#ifdef OS2
+  dostounix_filename (nm);
+#endif
+/* end of patch */
 
   /* If nm is absolute, flush ...// and detect /./ and /../.
      If no /./ or /../ we can return right away. */
@@ -715,12 +743,12 @@
 	  if (index (nm, '/'))
 	    return build_string (sys_translate_unix (nm));
 #endif /* VMS */
-/* 91.10.20, 93.2.17 by M.Higashida */
-#if !(defined(MSDOS) || defined(WIN32))
+/* 91.10.20, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if !(defined(MSDOS) || defined(WIN32) || defined(OS2))
 	  if (nm == XSTRING (name)->data)
 	    return name;
 	  return build_string (nm);
-#endif /* not MSDOS nor WIN32 */
+#endif /* not MSDOS nor WIN32 nor OS2 */
 /* end of patch */
 	}
     }
@@ -739,8 +767,8 @@
 	{
 	  /* Handle ~ on its own.  */
 	  newdir = (unsigned char *) egetenv ("HOME");
-/* 91.10.16 by S.Hirano, 93.2.25 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.25 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
 	  if (newdir)
 	    dostounix_filename (newdir);
 #endif
@@ -748,8 +776,8 @@
 	}
       else
 	{
-/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida */
-#if !(defined(MSDOS) || defined(WIN32))
+/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if !(defined(MSDOS) || defined(WIN32) || defined(OS2))
 	  /* Handle ~ followed by user name.  */
 	  unsigned char *user = nm + 1;
 	  /* Find end of name.  */
@@ -773,7 +801,7 @@
 
 	  /* Discard the user name from NM.  */
 	  nm += len;
-#endif /* not MSDOS nor WIN32 */
+#endif /* not MSDOS nor WIN32 nor OS2 */
 /* end of patch */
 	}
 
@@ -797,8 +825,8 @@
       if (NULL (defalt))
 	defalt = current_buffer->directory;
       CHECK_STRING (defalt, 1);
-/* 91.11.22, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.11.22, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
       if (drive < 0)
 	{
 	  if (XSTRING (defalt)->data[1] == ':')
@@ -828,17 +856,18 @@
 		setdisk (cur_drive);
 	      }
 #else
-#ifdef EMX
+#if defined(EMX) || defined (OS2) /* 93.8.20 by O.Sasaki */
 	    {
               char *tmp = (char *) alloca (MAXPATHLEN + 1);
               char target_drive[] = "X:";
 
               *target_drive = drive + 'a';
-              newdir = _fullpath (tmp, target_drive, MAXPATHLEN);
+              newdir = (unsigned char *)_fullpath (tmp,
+						   target_drive, MAXPATHLEN);
             }
 #else
 you lose!
-#endif /* not EMX */
+#endif /* not EMX nor OS2 */
 #endif /* not GO32 nor WIN32 */
 /* end of patch */
 	}
@@ -848,8 +877,8 @@
 /* end of patch */
     }
 
-/* 91.10.22, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.22, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   /* ..., and again strip drive name. */
   if (newdir && newdir[1] == ':')
     {
@@ -878,14 +907,14 @@
   /* Now concatenate the directory and name to new space in the stack frame */
 
   tlen += strlen (nm) + 1;
-/* 91.10.20, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.20, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   /* These codes are scouted from Human68k version. Thanks. */
   target = (unsigned char *) alloca (tlen + 2);  /* add reserved space for drive name. */
   target += 2;
-#else /* not MSDOS nor WIN32 */
+#else /* not MSDOS nor WIN32 nor OS2 */
   target = (unsigned char *) alloca (tlen);
-#endif /* not MSDOS nor WIN32 */
+#endif /* not MSDOS nor WIN32 nor OS2 */
 /* end of patch */
   *target = 0;
 
@@ -994,8 +1023,8 @@
 #endif /* not VMS */
     }
 
-/* 91.10.20, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.20, 93.2.17 by M.Higashida, 93.8.20 by O,Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   /* at last, set drive name. */
   if (target[1] != ':')
     {
@@ -1057,8 +1086,9 @@
 	  nm = p;
 	  substituted = 1;
 	}
-/* 91.10.16 by S.Hirano, 93.2.17, 93.5.30 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17, 93.5.30 by M.Higashida,
+   93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
       if (p != nm && p[-1] == '/' && p[0] && p[1] == ':') {
 	nm = p;
 	substituted = 1;
@@ -1195,8 +1225,9 @@
 	 )
 	&& p != nm && p[-1] == '/')
       xnm = p;
-/* 91.10.16 by S.Hirano, 93.2.17, 93.5.30 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17, 93.5.30 by M.Higashida
+   93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
     else if (p != xnm && p[-1] == '/' && p[0] && p[1] == ':')
       xnm = p;
 #endif
@@ -1234,19 +1265,19 @@
   if (XSTRING (abspath)->size > 1
       && XSTRING (abspath)->data[XSTRING (abspath)->size - 1] == '/')
     {
-/* 91.10.20, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.20, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
       if (strcmp (XSTRING (abspath)->data + 1, ":/") != 0)
 	{
 	  if (EQ (abspath, filename))
 	    abspath = Fcopy_sequence (abspath);
 	  XSTRING (abspath)->data[XSTRING (abspath)->size - 1] = 0;
 	}
-#else /* not MSDOS nor WIN32 */
+#else /* not MSDOS nor WIN32 nor OS2 */
       if (EQ (abspath, filename))
 	abspath = Fcopy_sequence (abspath);
       XSTRING (abspath)->data[XSTRING (abspath)->size - 1] = 0;
-#endif /* not MSDOS nor WIN32 */
+#endif /* not MSDOS nor WIN32 nor OS2 */
 /* end of patch */
     }
 #endif
@@ -1365,8 +1396,8 @@
 #ifdef APOLLO
       if (!egetenv ("USE_DOMAIN_ACLS"))
 #endif
-/* 92.10.5, 93.2.17 by M.Higashida */
-#if !(defined(MSDOS) || defined(WIN32))
+/* 92.10.5, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if !(defined(MSDOS) || defined(WIN32) || defined(OS2))
       chmod (XSTRING (newname)->data, st.st_mode & 07777);
 #endif
 /* end of patch */
@@ -1470,8 +1501,8 @@
     barf_or_query_if_file_exists (newname, "make it a new name",
 				  XTYPE (ok_if_already_exists) == Lisp_Int);
   unlink (XSTRING (newname)->data);
-/* 92.11.4, 93.2.25 by M.Higashida */
-#if defined(MSDOS) && defined(EMX) /* not correct! */
+/* 92.11.4, 93.2.25 by M.Higashida,93.8.20 by O.Sasaki */
+#if (defined(MSDOS) && defined(EMX)) || defined(OS2) /* not correct! */
   if (0 > rename (XSTRING (filename)->data, XSTRING (newname)->data))
 #else
 #ifdef WIN32
@@ -1619,10 +1650,10 @@
       || (*ptr == '[' && (ptr[1] != '-' || (ptr[2] != '.' && ptr[2] != ']'))
 	  && ptr[1] != '.')
 #endif /* VMS */
-/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
       || (ptr[1] == ':' && ptr[2] == '/')
-#endif /* MSDOS or WIN32 */
+#endif /* MSDOS or WIN32 or OS2 */
 /* end of patch */
       )
     return Qt;
@@ -1658,6 +1689,21 @@
 
   CHECK_STRING (filename, 0);
   abspath = Fexpand_file_name (filename, Qnil);
+/* 93.8.23 by O.Sasaki */
+#ifdef OS2
+    {
+        int             len = XSTRING (abspath)->size - 1 ;
+        unsigned char   *name, *pnt ;
+
+        pnt = XSTRING (abspath)->data ;
+        if ( pnt[len] == '/' || pnt[len] =='\\' ) {
+            name = ( unsigned char *)alloca( len + 2 ) ;
+            strcpy( name, pnt ) ;
+            name[len] = 0 ;
+            return (access (name, 4) >= 0) ? Qt : Qnil;
+        }
+    }
+#endif
   return (access (XSTRING (abspath)->data, 4) >= 0) ? Qt : Qnil;
 }
 
@@ -1719,11 +1765,11 @@
   if (!NULL (dir))
     dir = Fdirectory_file_name (dir);
 #endif /* VMS */
-/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida,93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   if (!NULL (dir))
     dir = Fdirectory_file_name (dir);
-#endif /* MSDOS or WIN32 */
+#endif /* MSDOS or WIN32 or OS2 */
 /* end of patch */
   return (access (!NULL (dir) ? (char *) XSTRING (dir)->data : "", 2) >= 0
 	  ? Qt : Qnil);
@@ -1773,11 +1819,11 @@
   CHECK_NUMBER (mode, 1);
 
 #ifndef APOLLO
-/* 92.10.5, 93.2.17 by M.Higashida */
-#if !defined(MSDOS) && !defined(WIN32)
+/* 92.10.5, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if !defined(MSDOS) && !defined(WIN32) && !defined(OS2)
   if (chmod (XSTRING (abspath)->data, XINT (mode)) < 0)
     report_file_error ("Doing chmod", Fcons (abspath, Qnil));
-#endif /* not MSDOS nor WIN32 */
+#endif /* not MSDOS nor WIN32 nor OS2 */
 /* end of patch */
 #else /* APOLLO */
   if (!egetenv ("USE_DOMAIN_ACLS"))
@@ -2193,12 +2239,13 @@
 	  desc = creat (fn, 0666);
       }
 #else /* not VMS */
-/* 91.10.16 by S.Hirano, 92.11.1, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 92.11.1, 93.2.17 by M.Higashida
+   93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   desc = creat (fn, S_IREAD|S_IWRITE);
-#else /* not MSDOS nor WIN32 */
+#else /* not MSDOS nor WIN32 nor OS2 */
   desc = creat (fn, 0666);
-#endif /* not MSDOS nor MSDOS */
+#endif /* not MSDOS nor WIN32 nor OS2 */
 /* end of patch */
 #endif /* not VMS */
 
@@ -2270,7 +2317,8 @@
 	}
     }
 
-/* 91.10.20, 93.2.17 by M.Higashida */
+/* 91.10.20, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#ifndef OS2
 #ifndef WIN32
 #ifndef MSDOS
 #ifndef USG
@@ -2285,6 +2333,7 @@
 #endif
 #endif
 #endif
+#endif
 /* end of patch */
 
 #if 0
@@ -2705,8 +2754,8 @@
 
   /* If dir starts with user's homedir, change that to ~. */
   homedir = (char *) egetenv ("HOME");
-/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   if (homedir != 0)
 	dostounix_filename (homedir);
 #endif
diff -urP /mule-1.1/src/keyboard.c ./src/keyboard.c
--- /mule-1.1/src/keyboard.c	Mon Mar 14 14:46:08 1994
+++ ./src/keyboard.c	Thu Mar 17 11:19:24 1994
@@ -898,6 +898,9 @@
 #ifdef BSD4_1
   sigunhold (SIGALRM);
 #endif
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  signal(SIGALRM, SIG_ACK);
+#endif
 
   errno = old_errno;
 }
@@ -2216,8 +2219,8 @@
   signal (SIGINT, interrupt_signal);
   signal (SIGQUIT, interrupt_signal);
 #endif /* USG */
-/* 92.11.4 by M.Higashida */
-#if defined(MSDOS) && defined(EMX)
+/* 92.11.4 by M.Higashida, 93.8.20 by O.Sasaki */
+#if (defined(MSDOS) && defined(EMX)) || defined(OS2)
   signal (SIGINT, SIG_ACK);
 #endif
 /* end of patch */
@@ -2249,8 +2252,13 @@
       /* Perhaps should really fork an inferior shell?
 	 But that would not provide any way to get back
 	 to the original shell, ever.  */
+#ifdef OS2 /* 93.8.25 by O.Sasaki */
+      printf ("No support for stopping a process on this operating system;\r\n");
+      printf ("you can continue or abort.\r\n");
+#else /* not OS2 */
       printf ("No support for stopping a process on this operating system;\n");
       printf ("you can continue or abort.\n");
+#endif /* not OS2 */
 #endif /* not VMS */
 #endif /* not SIGTSTP */
       printf ("Auto-save? (y or n) ");
@@ -2267,7 +2275,11 @@
       if (((c = getchar ()) & ~040) == 'Y')
 	abort ();
       while (c != '\n') c = getchar ();
+#ifdef OS2 /* 93.8.25 by O.Sasaki */
+      printf ("Continuing...\r\n");
+#else
       printf ("Continuing...\n");
+#endif
       fflush (stdout);
       init_sys_modes ();
     }
diff -urP /mule-1.1/src/keymap.c ./src/keymap.c
--- /mule-1.1/src/keymap.c	Thu Jul 08 17:23:56 1993
+++ ./src/keymap.c	Tue Mar 15 04:35:24 1994
@@ -44,6 +44,11 @@
 #ifdef HAVE_X_WINDOWS
 Lisp_Object MouseMap;		/* Keymap for mouse commands */
 #endif /* HAVE_X_WINDOWS */
+/* 93.12.20 by O.Sasaki */
+#ifdef OS2PM
+Lisp_Object MouseMap;		/* Keymap for mouse commands */
+#endif /* OS2PM */
+/* end of patch */
 
 Lisp_Object global_map;
 
@@ -306,7 +311,9 @@
   register int c;
   register Lisp_Object tem;
   register Lisp_Object cmd;
+#ifndef OS2 /* 93.8.27 by O.Sasaki */
   int metized = 0;
+#endif
 
   keymap = get_keymap (keymap);
 
@@ -318,6 +325,9 @@
   while (1)
     {
       c = XSTRING (key)->data[idx];
+#ifdef OS2	/* 93.8.27 by O.Sasaki */
+      idx++;
+#else /* not OS2 */
       /* 91.10.29, 92.3.23 by K.Handa */
       if (c >= 0200 && !metized && NULL (nonmeta))
 	{
@@ -330,6 +340,7 @@
 	  metized = 0;
 	  idx++;
 	}
+#endif /* not OS2 */
 
       if (idx == XSTRING (key)->size)
 	return store_in_keymap (keymap, c, def);
@@ -367,7 +378,9 @@
   register Lisp_Object tem;
   register Lisp_Object cmd;
   register int c;
+#ifndef OS2 /* 93.8.27 by O.Sasaki */
   int metized = 0;
+#endif
 
   keymap = get_keymap (keymap);
 
@@ -700,12 +713,14 @@
      register unsigned int c;
      register char *p;
 {
+#ifndef OS2	/* 93.8.27 by O.Sasaki */
   if (c >= 0200)
     {
       *p++ = 'M';
       *p++ = '-';
       c -= 0200;
     }
+#endif
   if (c < 040)
     {
       if (c == 033)
@@ -784,12 +799,14 @@
   if (MC_CHAR_P(c)) {		/* 88.5.28, 91.10.29 by K.Handa */
     p += CHARtoSTR (c, p);
   } else {			/* 91.11.17 by K.Handa */
+#ifndef OS2	/* 93.8.27 by O.Sasaki */
   if (c >= 0200)
     {
       *p++ = 'M';
       *p++ = '-';
       c -= 0200;
     }
+#endif
   if (c < 040)
     {
       *p++ = '^';
@@ -857,7 +874,11 @@
       /* If the MAP is a vector, I increments and eventually reaches 0200.
 	 Otherwise I remains 0; MAP is cdr'd and eventually becomes nil.  */
 
+#ifdef OS2	/* 93.8.27 by O.Sasaki */
+      while (!NULL (map) && i < 0400)
+#else
       while (!NULL (map) && i < 0200)
+#endif
 	{
 	  register Lisp_Object elt, dummy;
 
@@ -1080,7 +1101,12 @@
   register Lisp_Object keysdesc;
 
   if (!NULL (string) && XSTRING (string)->size > 0)
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+    keysdesc = string;
+#else
     keysdesc = concat2 (Fkey_description (string), build_string (" "));
+#endif
   else
     keysdesc = Qnil;
 
@@ -1138,10 +1164,16 @@
 	}
 
       GCPRO2 (elt_prefix, tem2);
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+      insert1 (call1 (Qkey_description,
+		      concat2 (elt_prefix, Fchar_to_string (tem1))));
+#else /* not OS2 */
       if (!NULL (elt_prefix))
 	insert1 (elt_prefix);
 
       insert1 (Fsingle_key_description (tem1));
+#endif /* not OS2 */
+/* end of patch */
 
       (*elt_describer) (tem2);
       UNGCPRO;
@@ -1198,11 +1230,19 @@
 	  first = 0;
 	}
 
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+      XFASTINT (dummy) = i;
+      insert1 (call1 (Qkey_description,
+		      concat2 (elt_prefix, Fchar_to_string (dummy))));
+#else /* not OS2 */
       if (!NULL (elt_prefix))
 	insert1 (elt_prefix);
 
       XFASTINT (dummy) = i;
       insert1 (Fsingle_key_description (dummy));
+#endif /* not OS2 */
+/* end of patch */
 
       while (i + 1 < size
 	     && (tem2 = get_keyelt (XVECTOR (vector)->contents[i+1]),
@@ -1212,11 +1252,19 @@
       if (i != XINT (dummy))
 	{
 	  insert (" .. ", 4);
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+	  XFASTINT (dummy) = i;
+	  insert1 (call1 (Qkey_description,
+			  concat2 (elt_prefix, Fchar_to_string (dummy))));
+#else /* not OS2 */
 	  if (!NULL (elt_prefix))
 	    insert1 (elt_prefix);
 
 	  XFASTINT (dummy) = i;
 	  insert1 (Fsingle_key_description (dummy));
+#endif /* not OS2 */
+/* end of patch */
 	}
 
       (*elt_describer) (tem1);
@@ -1350,6 +1398,13 @@
   MouseMap = tem;
   Fset (intern ("mouse-map"), tem);
 #endif /* HAVE_X_WINDOWS */
+/* 93.12.20 by O.Sasaki */
+#ifdef OS2PM
+  tem = Fmake_keymap ();
+  MouseMap = tem;
+  Fset (intern ("mouse-map"), tem);
+#endif /* OS2PM */
+/* end of patch */
 
   tem = Fmake_keymap ();
   Vglobal_map = tem;
diff -urP /mule-1.1/src/linkos2.rf ./src/linkos2.rf
--- /mule-1.1/src/linkos2.rf
+++ ./src/linkos2.rf	Tue Mar 22 11:26:30 1994
@@ -0,0 +1,51 @@
+abbrev.o
+alloc.o
+buffer.o
+bytecode.o
+callint.o
+callproc.o
+casefiddle.o
+category.o
+ccl.o
+cm.o
+cmds.o
+codeconv.o
+data.o
+dired.o
+dispnew.o
+doc.o
+doprnt.o
+editfns.o
+emacs.o
+eval.o
+fileio.o
+filelock.o
+filemode.o
+fns.o
+indent.o
+insdel.o
+keyboard.o
+keymap.o
+lastfile.o
+lread.o
+macros.o
+marker.o
+minibuf.o
+mocklisp.o
+mule.o
+os2.o
+pmterm.o
+print.o
+process.o
+regex.o
+scroll.o
+search.o
+syntax.o
+sysdep.o
+term.o
+termcap.o
+tparam.o
+undo.o
+unexec.o
+window.o
+xdisp.o
diff -urP /mule-1.1/src/lisp.h ./src/lisp.h
--- /mule-1.1/src/lisp.h	Mon Mar 14 14:46:08 1994
+++ ./src/lisp.h	Tue Mar 15 04:37:16 1994
@@ -996,6 +996,9 @@
 extern Lisp_Object Fwhere_is_internal ();
 extern Lisp_Object access_keymap (), store_in_keymap ();
 extern Lisp_Object get_keyelt (), get_keymap();
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+extern Lisp_Object Qkey_description;
+#endif
 
 /* defined in indent.c */
 extern Lisp_Object Fvertical_motion (), Findent_to (), Fcurrent_column ();
diff -urP /mule-1.1/src/lread.c ./src/lread.c
--- /mule-1.1/src/lread.c	Mon Mar 14 14:46:10 1994
+++ ./src/lread.c	Tue Mar 15 04:40:16 1994
@@ -293,8 +293,8 @@
 #ifdef VMS
 	  || index (s, ':')
 #endif /* VMS */
-/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
 	  || (s[1] == ':' && s[2] == '/')
 #endif
 /* end of patch */
@@ -1334,8 +1334,8 @@
     normal_path = Vload_path;
   else
 #endif
-/* 91.11.12, 93.2.17 M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.11.12, 93.2.17 M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
     normal_path = decode_env_path ("EMACSLOADPATH", normal);
 #else
     normal_path = decode_env_path (0, normal);
diff -urP /mule-1.1/src/m-os2.h ./src/m-os2.h
--- /mule-1.1/src/m-os2.h
+++ ./src/m-os2.h	Sat Apr 04 12:50:08 1992
@@ -0,0 +1,173 @@
+/* m- file for intel 386.
+   Copyright (C) 1987 Free Software Foundation, Inc.
+
+This file is part of GNU Emacs.
+
+GNU Emacs is free software; you can redistribute it and/or modify
+it under the terms of the GNU General Public License as published by
+the Free Software Foundation; either version 1, or (at your option)
+any later version.
+
+GNU Emacs is distributed in the hope that it will be useful,
+but WITHOUT ANY WARRANTY; without even the implied warranty of
+MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+GNU General Public License for more details.
+
+You should have received a copy of the GNU General Public License
+along with GNU Emacs; see the file COPYING.  If not, write to
+the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
+
+
+/* The following three symbols give information on
+ the size of various data types.  */
+
+#define SHORTBITS 16		/* Number of bits in a short */
+
+#define INTBITS 32		/* Number of bits in an int */
+
+#define LONGBITS 32		/* Number of bits in a long */
+
+/* i386 is not big-endian: lowest numbered byte is least significant. */
+
+/* #undef BIG_ENDIAN */
+
+/* Define NO_ARG_ARRAY if you cannot take the address of the first of a
+ * group of arguments and treat it as an array of the arguments.  */
+
+/* #define NO_ARG_ARRAY */
+
+/* Define WORD_MACHINE if addresses and such have
+ * to be corrected before they can be used as byte counts.  */
+
+/* #define WORD_MACHINE */
+
+/* Define how to take a char and sign-extend into an int.
+   On machines where char is signed, this is a no-op.  */
+
+#define SIGN_EXTEND_CHAR(c) (c)
+
+/* Now define a symbol for the cpu type, if your compiler
+   does not define it automatically:
+   Ones defined so far include vax, m68000, ns16000, pyramid,
+   orion, tahoe, APOLLO and many others */
+
+#define INTEL386
+
+/* Use type int rather than a union, to represent Lisp_Object */
+
+#define NO_UNION_TYPE
+
+/* crt0.c, if it is used, should use the i386-bsd style of entry.
+   with no extra dummy args.  On USG and XENIX,
+   NO_REMAP says this isn't used. */
+
+#define CRT0_DUMMIES bogus_fp,
+
+/* crt0.c should define a symbol `start' and do .globl with a dot.  */
+
+#define DOT_GLOBAL_START
+
+#ifdef XENIX
+/* Data type of load average, as read out of kmem.  */
+#define LOAD_AVE_TYPE short
+
+/* Convert that into an integer that is 100 for a load average of 1.0  */
+#define LOAD_AVE_CVT(x) (((double) (x)) * 100.0 / FSCALE)
+  
+#define FSCALE 256.0         /* determined by experimentation...  */
+#endif
+
+#ifdef USG5_4 /* Older USG systems do not support the load average.  */
+/* Data type of load average, as read out of kmem.  */
+
+#define LOAD_AVE_TYPE long
+
+/* Convert that into an integer that is 100 for a load average of 1.0  */
+/* This is totally uncalibrated. */
+
+#define LOAD_AVE_CVT(x) ((int) (((double) (x)) * 100.0 / FSCALE))
+#define FSCALE 256.0
+#endif
+
+/* Define CANNOT_DUMP on machines where unexec does not work.
+   Then the function dump-emacs will not be defined
+   and temacs will do (load "loadup") automatically unless told otherwise.  */
+
+/* #define CANNOT_DUMP */
+
+/* Define VIRT_ADDR_VARIES if the virtual addresses of
+   pure and impure space as loaded can vary, and even their
+   relative order cannot be relied on.
+
+   Otherwise Emacs assumes that text space precedes data space,
+   numerically.  */
+
+/* #define VIRT_ADDR_VARIES */
+
+#ifdef XENIX
+#define VALBITS 26
+#define GCTYPEBITS 5
+
+/* Define NO_REMAP if memory segmentation makes it not work well
+   to change the boundary between the text section and data section
+   when Emacs is dumped.  If you define this, the preloaded Lisp
+   code will not be sharable; but that's better than failing completely.  */
+
+#define NO_REMAP
+
+#define STACK_DIRECTION -1
+
+/* Since cannot purify, use standard Xenix 386 startup code. */
+
+#define START_FILES	/lib/386/Sseg.o pre-crt0.o /lib/386/Scrt0.o
+
+/* These really use terminfo.  */
+
+/* #define LIBS_TERMCAP /lib/386/Slibcurses.a  \
+   /lib/386/Slibtinfo.a /lib/386/Slibx.a
+*/
+/* Standard libraries for this machine.  Since `-l' doesn't work in `ld'.  */
+/* '__fltused' is unresolved w/o Slibcfp.a */
+#define LIB_STANDARD /lib/386/Slibcfp.a /lib/386/Slibc.a
+#else /* not XENIX */
+
+#ifdef USG
+#ifndef LIB_STANDARD
+#if defined (__GNUC__) || defined (C_ALLOCA)
+#define	LIB_STANDARD -lc
+#else
+#define LIB_STANDARD -lPW -lc
+#endif
+#endif /* no LIB_STANDARD */
+#ifndef C_ALLOCA
+#define HAVE_ALLOCA
+#endif
+#define NO_REMAP 
+#define TEXT_START 0
+#endif /* USG */
+#endif /* not XENIX */
+
+#ifdef BSD
+#define HAVE_ALLOCA
+#endif /* BSD */
+
+/* If compiling with GCC, let GCC implement alloca.  */
+#if defined(__GNUC__) && !defined(alloca)
+#define alloca(n) __builtin_alloca(n)
+#define HAVE_ALLOCA
+#endif
+
+#ifdef __STDC__
+#ifndef DONT_DEFINE_SIGNAL
+/* Cast the function argument to avoid warnings.  */
+#define signal(sig, func) (signal (sig, (void (*) (int)) (func)))
+#endif
+#endif
+
+#ifdef USG5_4
+#define DATA_SEG_BITS 0x08000000
+#endif
+
+#ifdef OS2
+#define START_FILES /emx/lib/crt0.o
+#endif
diff -urP /mule-1.1/src/Makefile.os2 ./src/Makefile.os2
--- /mule-1.1/src/Makefile.os2
+++ ./src/Makefile.os2	Wed Mar 23 07:17:06 1994
@@ -0,0 +1,166 @@
+dot = .
+lispdir = $(dot)$(dot)/lisp/
+etcdir = $(dot)$(dot)/etc/
+emxbindir = e:/emx/bin/
+.SUFFIXES: .c .o .s
+.c.o:
+	$(CC) $(CFLAGS) -c $<
+CD=cd
+MAKE=make
+CC = gcc
+STARTFILES = 
+LD = ld
+CFLAGS= -g -Demacs  $(MCPATH_FLAGS)
+GNULIB_VAR = 
+MULE_H = mule.h
+CC_H = codeconv.h
+MULE_OBJ_BASE = mule.o codeconv.o category.o ccl.o
+MULE_ELC_BASE = \
+	${lispdir}mule.elc ${lispdir}mule-util.elc ${lispdir}attribute.elc \
+	${lispdir}kinsoku.elc ${lispdir}quail.elc ${lispdir}regexp.elc \
+	${lispdir}keyboard.elc ${lispdir}ccl.elc ${lispdir}worddef.elc
+MULE_LIB_BASE =
+#MCPATH_FLAGS =
+#MCPATH_H = mcpath.h
+#MCPATH_OBJ = mcpath.o
+MULE_ELC_EXT = ${lispdir}os2.elc ${lispdir}os2-keys.elc
+MULE_OBJ = $(MULE_OBJ_BASE) $(MULE_OBJ_EXT)
+MULE_ELC  = $(MULE_ELC_BASE) $(MULE_ELC_EXT)
+MULE_LIB = $(MULE_LIB_BASE) $(MULE_LIB_EXT)
+MULE_ELC_PATCHED = $(MULE_ELC) \
+	${lispdir}bytecomp.elc ${lispdir}debug.elc ${lispdir}files.elc \
+	${lispdir}fill.elc ${lispdir}info.elc ${lispdir}isearch.elc \
+	${lispdir}picture.elc ${lispdir}startup.elc ${lispdir}replace.elc \
+	${lispdir}rmail.elc ${lispdir}simple.elc ${lispdir}texinfmt.elc \
+	${lispdir}dired.elc ${lispdir}macros.elc ${lispdir}man.elc \
+	${lispdir}sendmail.elc ${lispdir}dabbrev.elc \
+	${lispdir}prolog.elc ${lispdir}compile.elc
+obj=    dispnew.o scroll.o xdisp.o window.o \
+	term.o cm.o \
+	emacs.o keyboard.o macros.o keymap.o sysdep.o \
+	buffer.o filelock.o insdel.o marker.o \
+	minibuf.o fileio.o dired.o filemode.o \
+	cmds.o casefiddle.o indent.o search.o regex.o undo.o \
+	alloc.o data.o doc.o editfns.o callint.o \
+	eval.o fns.o print.o lread.o \
+	abbrev.o syntax.o unexec.o mocklisp.o bytecode.o \
+	process.o callproc.o $(environobj) \
+	doprnt.o \
+	os2.o pmterm.o \
+	$(MULE_OBJ) $(MCPATH_OBJ)
+termcapobj = termcap.o tparam.o
+otherobj= $(termcapobj) lastfile.o
+lisp=	${lispdir}simple.elc ${lispdir}help.elc \
+	${lispdir}files.elc ${lispdir}window.elc \
+	${lispdir}indent.elc ${lispdir}loaddefs.el ${lispdir}paths.el \
+	${lispdir}startup.elc ${lispdir}lisp.elc \
+	${lispdir}page.elc ${lispdir}register.elc \
+	${lispdir}paragraphs.elc ${lispdir}lisp-mode.elc \
+	${lispdir}text-mode.elc ${lispdir}fill.elc \
+	${lispdir}c-mode.elc ${lispdir}isearch.elc \
+	${lispdir}replace.elc ${lispdir}abbrev.elc \
+	${lispdir}buff-menu.elc ${lispdir}subr.elc \
+	${lispdir}mule-conf.el ${lispdir}mule-init.el \
+	$(MULE_ELC)
+#all: xemacs.exe  ${etcdir}CHARSETS
+all: xemacs.exe pmmule.exe
+execprefix=
+.SUFFIXES: .elc .el
+.el.elc:
+	$(execprefix)temacs.exe -batch -l ${lispdir}mule-inst.el ${lispdir} ${lisp} ${MUEL_ELC_PATCHD}
+xemacs.exe: temacs.exe ${etcdir}DOC ${lisp}
+#	$(execprefix)temacs -batch -l inc-vers
+	emxbind -x temacs.exe temacs
+	$(execprefix)temacs.exe -batch -l loadup.el dump
+	emxbind -cxemacs ${emxbindir}emxl temacs xemacs
+	- del temacs
+	- del xemacs
+${etcdir}DOC: ${etcdir}make-docfile.exe ${obj} ${lisp}
+	rm -f ${etcdir}DOC
+	${etcdir}make-docfile -o ${etcdir}DOC ${obj} 
+	${etcdir}make-docfile -a ${etcdir}DOC ${lisp} ${lispdir}version.el
+${etcdir}make-docfile.exe:
+#	${CD} ${etcdir};${MAKE} ${MFLAGS} make-docfile.exe
+	${CD} ..\\etc & ${MAKE} CC=$(CC) ${MFLAGS} make-docfile.exe
+temacs.exe: $(SUPPORTDOS) ${obj} ${otherobj} os2.o pmterm.o
+#	ls -1 *.o >linkos2.rf
+	$(CC) -o temacs.exe @linkos2.rf
+CPP = $(CC) -E
+paths.h: paths.h-dist
+	echo paths.h needs to be set up from paths.h-dist
+	exit 1
+config.h: config.h-dist
+	echo config.h needs to be set up from config.h-dist
+	exit 1
+mconfig.h: mconfig.h-dist
+	echo mconfig.h needs to be set up from mconfig.h-dist
+	exit 1
+abbrev.o : abbrev.c buffer.h commands.h config.h 
+buffer.o : buffer.c syntax.h buffer.h commands.h window.h config.h $(MULE_H)
+callint.o : callint.c window.h commands.h buffer.h config.h 
+callproc.o : callproc.c paths.h buffer.h commands.h config.h $(MULE_H) \
+	       $(CC_H) $(MCPATH_H)
+casefiddle.o : casefiddle.c syntax.h commands.h buffer.h config.h 
+category.o : category.h category.c $(MULE_H)
+ccl.o : ccl.c codeconv.h
+cm.o : cm.c cm.h termhooks.h config.h
+cmds.o : cmds.c syntax.h buffer.h commands.h config.h $(MULE_H)
+codeconv.o: codeconv.c $(MULE_H) $(CC_H)
+dired.o : dired.c commands.h buffer.h config.h regex.h $(MCPATH_H)
+dispnew.o : dispnew.c commands.h window.h buffer.h dispextern.h termchar.h \
+	termopts.h cm.h config.h lisp.h $(MULE_H)
+doc.o : doc.c buffer.h config.h paths.h
+doprnt.o : doprnt.c
+editfns.o : editfns.c window.h buffer.h config.h $(MULE_H)
+emacs.o : emacs.c commands.h config.h $(MULE_H) mconfig.h
+fileio.o : fileio.c window.h buffer.h config.h $(MULE_H) $(CC_H) $(MCPATH_H)
+filelock.o : filelock.c buffer.h paths.h config.h  $(MCPATH_H)
+filemode.o : filemode.c 
+indent.o : indent.c window.h indent.h buffer.h config.h termchar.h termopts.h $(MULE_H)
+insdel.o : insdel.c window.h buffer.h config.h 
+keyboard.o : keyboard.c termchar.h termhooks.h termopts.h buffer.h commands.h window.h macros.h config.h $(MULE_H)
+keymap.o : keymap.c buffer.h commands.h config.h $(MULE_H)
+lastfile.o : lastfile.c 
+macros.o : macros.c window.h buffer.h commands.h macros.h config.h
+malloc.o : malloc.c config.h
+marker.o : marker.c buffer.h config.h 
+minibuf.o : minibuf.c syntax.h window.h buffer.h commands.h config.h 
+mocklisp.o : mocklisp.c buffer.h config.h
+mule.o : mule.c mule.h config.h mconfig.h $(MULE_H) $(CC_H)
+process.o : process.c process.h buffer.h window.h termhooks.h termopts.h commands.h dispextern.h config.h $(MULE_H) $(CC_H) $(MCPATH_H)
+regex.o : regex.c syntax.h buffer.h config.h regex.h $(MULE_H)
+scroll.o : scroll.c termchar.h config.h dispextern.h termhooks.h
+search.o : search.c regex.h commands.h buffer.h syntax.h config.h $(MULE_H)
+syntax.o : syntax.c syntax.h buffer.h commands.h config.h $(MULE_H)
+sysdep.o : sysdep.c config.h dispextern.h termhooks.h termchar.h termopts.h window.h $(MCPATH_H)
+term.o : term.c termchar.h termhooks.h termopts.h config.h cm.h $(MULE_H) $(CC_H)
+termcap.o : termcap.c config.h
+terminfo.o : terminfo.c config.h
+tparam.o : tparam.c config.h
+undo.o : undo.c buffer.h commands.h config.h 
+unexec.o : config.h getpagesize.h mconfig.h puresize.h $(MCPATH_H)
+window.o : window.c indent.h commands.h window.h buffer.h config.h termchar.h
+xdisp.o : xdisp.c macros.h commands.h indent.h buffer.h dispextern.h termchar.h window.h config.h $(MULE_H)
+alloc.o : alloc.c window.h buffer.h config.h mconfig.h puresize.h
+bytecode.o : bytecode.c buffer.h config.h 
+data.o : data.c buffer.h config.h 
+eval.o : eval.c commands.h config.h
+fns.o : fns.c buffer.h commands.h config.h
+print.o : print.c process.h window.h buffer.h dispextern.h termchar.h config.h 
+lread.o : lread.c buffer.h paths.h config.h $(MULE_H) $(MCPATH_H)
+${etcdir}emacstool: ${etcdir}emacstool.c
+	cd ${etcdir}; ${MAKE} ${MFLAGS} emacstool
+${etcdir}bdf.o: config.h paths.h $(MULE_H) \
+		${etcdir}bdf.h ${etcdir}bdf.c ${etcdir}Makefile
+	${CD} ${etcdir}; ${MAKE} ${MFLAGS} bdf.o
+#${etcdir}charset: xemacs
+#	$(etcdir)env EMACSLOADPATH=${lispdir} $(execprefix)xemacs -batch -l $(lispdir)mule-inst.el `pwd`/${etcdir}charset
+#${etcdir}CHARSETS: ${etcdir}charset ${etcdir}Makefile
+#	${CD} ${etcdir}; ${MAKE} ${MFLAGS} CHARSETS
+os2.o : os2.c config.h
+pmterm.o : pmterm.c config.h pmmule.h
+#pmmule.o: pmmule.c pmmule.h
+pmmule.res: pmmule.rc mule.ico
+	rc -r pmmule
+pmmule.exe: pmmule.c pmmule.h pmmule.def pmmule.res
+	$(CC) -O pmmule.c pmmule.def pmmule.res -o pmmule.exe
diff -urP /mule-1.1/src/mconfig.h-dist ./src/mconfig.h-dist
--- /mule-1.1/src/mconfig.h-dist	Mon Mar 14 14:44:36 1994
+++ ./src/mconfig.h-dist	Tue Mar 15 06:48:18 1994
@@ -101,6 +101,14 @@
 #undef CANNA
 #undef CANNA2
 #endif
+
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+#undef EGG
+#undef WNN4
+#undef SJ3
+#undef CANNA
+#undef CANNA2
+#endif
 /* end of patch */
 
 /* 93.5.12 by T.Enami */
diff -urP /mule-1.1/src/os2.c ./src/os2.c
--- /mule-1.1/src/os2.c
+++ ./src/os2.c	Mon Sep 27 18:29:34 1993
@@ -0,0 +1,156 @@
+/* OS/2 specific functions for GNU Emacs for OS/2
+   Copyright (C) 1992 Free Software Foundation, Inc.
+
+This file is part of GNU Emacs.
+
+GNU Emacs is free software; you can redistribute it and/or modify
+it under the terms of the GNU General Public License as published by
+the Free Software Foundation; either version 1, or (at your option)
+any later version.
+
+GNU Emacs is distributed in the hope that it will be useful,
+but WITHOUT ANY WARRANTY; without even the implied warranty of
+MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+GNU General Public License for more details.
+
+You should have received a copy of the GNU General Public License
+along with GNU Emacs; see the file COPYING.  If not, write to
+the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
+
+#define	INCL_DOS
+#include <os2.h>
+#include <stdlib.h>
+#include <signal.h>
+#include <fcntl.h>
+#include <process.h>
+#include "config.h"
+#undef NULL
+#include "lisp.h"
+#include "process.h"
+
+/* Look at ctrl-break-action for explanation. */
+int Vctrl_break_action;
+
+void ctrl_break_signal()
+{
+    signal(SIGBREAK, SIG_ACK);
+
+    switch (Vctrl_break_action) {
+    case 0: break;
+    case 1: Vquit_flag = Qt; raise(SIGINT); break;
+    case 2: exit(1); break;
+    case 3: abort(); break;
+    default: break;
+    }
+}
+
+int 
+getdisk () 
+{ 
+    return (int) (_getdrive () - 'A'); 
+}
+     
+DEFUN ("valid-file-name-p", Fvalid_file_name_p, Svalid_file_name_p,
+  1, 1, 0,
+  "Return t if STRING is a valid file name.\n\
+This function tries to open the file and looks at the error code.\n\
+This is a special feature of GNU Emacs for OS/2.")
+  (str)
+    Lisp_Object str;
+{
+    struct Lisp_String *p;
+    int i;
+
+    CHECK_STRING (str, 0);
+    p = XSTRING (str);
+    i = open (p->data, O_RDONLY);
+    if (i >= 0) {
+	close (i);
+	return (Qt);
+    }
+    i = _syserrno ();
+    return (i != 15 && i != 123 && i != 206 ? Qt : Qnil);
+}
+
+#if 0
+DEFUN ("check-file-system-hpfs", Fcheck_file_system_hpfs,
+       Scheck_file_system_hpfs, 1, 1, 0,
+  "Retrun DRIVE File system type hpfs")
+  (drv)
+    Lisp_Object drv;
+{
+    char	drvtype[16] ;
+
+    _filesys (XSTRING(drv)->data, drvtype, sizeof(drvtype));
+    if ( strcmp( drvtype, "HPFS" ) == 0 )
+	return Qt ;
+    return Qnil ;
+}
+#endif /* 0 */
+
+DEFUN ("os2-kill-process", Fos2_kill_process, Sos2_kill_process, 0, 2, 0,
+  "Interrupt process PROCESS.  May be process or name of one.\n\
+Nil or no arg means current buffer's process.\n\
+Second arg CURRENT-GROUP non-nil means send signal to\n\
+the current process-group of the process's controlling terminal\n\
+rather than to the process's own process group.\n\
+If the process is a shell, this means interrupt current subjob\n\
+rather than the shell.")
+  (process, current_group)
+     Lisp_Object process, current_group;
+{
+    extern Lisp_Object	Vprocess_alist;
+    Lisp_Object		proc;
+    struct Lisp_Process *p;
+    char		killproc[] ="killtree.exe" ;
+    char		*name ;
+    char		*pid ;
+
+    /* proc = get_process (process); ̓WJ */
+    if (XTYPE (process) == Lisp_Process) {
+	proc = process;
+    } else {
+	CHECK_STRING (process, 0);
+	proc = Fcdr (Fassoc (process, Vprocess_alist));
+    }
+    p = XPROCESS (proc);
+
+    if (!EQ (p->childp, Qt))
+	error ("Process %s is not a subprocess", XSTRING (p->name)->data);
+    if (!XFASTINT (p->infd))
+	error ("Process %s is not active", XSTRING (p->name)->data);
+
+    if (NULL (p->pty_flag))
+	current_group = Qnil;
+
+    flush_pending_output (XFASTINT (p->infd));
+
+    name = (char *) alloca (16 + XSTRING (Vexec_directory)->size + 1);
+    pid  = (char *) alloca (16);
+    sprintf (name, "%s%s", XSTRING (Vexec_directory)->data, killproc );
+    sprintf (pid, "%d", XFASTINT (p->pid));
+    spawnl ( P_WAIT, name, killproc, pid, "-c", 0 ) ;
+    return process;
+}
+
+syms_of_os2()
+{
+  
+  DEFVAR_INT("ctrl-break-action", &Vctrl_break_action,
+     "Determines the behavior of Emacs after Ctrl-Break has been pressed.\n\
+Available only under OS/2.\n\
+0 : Do nothing, just return C-@.\n\
+1 : Like C-g C-g, termination with request.\n\
+2 : Terminate program immediatly without request.\n\
+3 : Force an abnormal program termination (dump core) without request.\n\
+The default value is 1.
+It is strongly recommended not to use a value of 2 or higher
+since you may loose data after hitting Ctrl-Break !");
+  Vctrl_break_action = 1;
+
+  defsubr (&Svalid_file_name_p);
+#if 0
+  defsubr (&Scheck_file_system_hpfs);
+#endif
+  defsubr (&Sos2_kill_process);
+}
diff -urP /mule-1.1/src/pmmule.c ./src/pmmule.c
--- /mule-1.1/src/pmmule.c
+++ ./src/pmmule.c	Fri Mar 25 18:49:10 1994
@@ -0,0 +1,2469 @@
+/* pmMule.c -- OS/2 Presentation Manager interface for GNU Emacs.
+   Copyright (C) 1993 Osamu Sasaki
+
+This file is part of GNU Emacs.
+
+GNU Emacs is free software; you can redistribute it and/or modify
+it under the terms of the GNU General Public License as published by
+the Free Software Foundation; either version 1, or (at your option)
+any later version.
+
+GNU Emacs is distributed in the hope that it will be useful,
+but WITHOUT ANY WARRANTY; without even the implied warranty of
+MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+GNU General Public License for more details.
+
+You should have received a copy of the GNU General Public License
+along with GNU Emacs; see the file COPYING.  If not, write to
+the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
+
+#define INCL_DOS
+#define INCL_WIN
+#define INCL_GPI
+#define INCL_DEV
+#define INCL_NLS
+#define INCL_DOSDEVIOCTL
+#define INCL_KBD
+#include <os2.h>
+#include <stdio.h>
+#include <stdlib.h>
+#include <stdarg.h>
+#include <string.h>
+#include <signal.h>
+#include "pmmule.h"
+#ifdef DEBUGSNAP
+#include "debuglib.h"
+#endif
+
+
+/* #define USE_OUTLINE_FONT */
+
+#define UWM_POPUPMENU   ( WM_USER+1) /* Create a popup menu */
+
+/* See termhooks.h */
+
+#define DOWN_MODIFIER		0x00
+#define UP_MODIFIER             0x04
+#define SHIFT_MODIFIER		0x20
+#define CTRL_MODIFIER		0x40
+#define ALT_MODIFIER		0x80
+
+#define IDM_POPUP               100
+#define IDM_FUNCMENU		1
+#define SELECT_FONT_ID		1
+
+typedef struct {
+    int  size ;
+    int  sel ;
+    char name[FACESIZE] ;
+} FONTSPEC ;
+
+typedef struct {
+    int  panes ;
+    int  lines ;
+    int  x ;
+    int  y ;
+    int  title_size ;
+    int  button ;
+    char *data ;
+} MENUDATA ;
+
+typedef struct {
+    HWND	Frame ;
+    HWND	Client ;
+    HPS		Ps ;
+    int		Start ;
+    int		Len ;
+} PECICTABLE ;
+
+
+HAB	hab ;			/* OS/2 PM̃AJ[ubNnh	*/
+HMQ	hmq ;			/* bZ[WL[nh		*/
+SWP	swpScreen ;		/* \XN[TCY			*/
+int	InPipe ;		/* Mule{̂̕Wo̓pCv		*/
+int	OutPipe ;		/* Mule{̂ւ̕W̓pCv		*/
+int	OutdataPipe ;		/* Mule{̂ւ̃f[^]pCv		*/
+HPOINTER hptrCursor ;		/* Mouse Pointer text			*/
+
+HWND	PmHwndFrame ;		/* PM Mule t[nh		*/
+HWND	PmHwndClient ;		/* PM Mule NCAgnh		*/
+HPS	PmHpsClient ;		/* PM Mule v[[e[V Xy[X	*/
+LONG	PmCxClient ;		/* \ʉhbgTCY		*/
+LONG	PmCyClient ;		/* \ʏchbgTCY		*/
+LONG	PmCxChar ;		/* \hbgTCY		*/
+LONG	PmCyChar ;		/* \chbgTCY		*/
+LONG	PmCyDesc ;		/* \őfBZ^hbgTCY	*/
+int	PmCursorX ;		/* J[\ʒu(sNZWn)	*/
+int	PmCursorY ;		/* J[\cʒu(sNZWn)	*/
+int	PmCursorOn ;		/* J[\\(!=0ƕ\)	*/
+int	PmCursorType ;		/* J[\`				*/
+int	PmCursorBlink ;		/* J[\uNtO		*/
+int	PmWidth ;		/* \GATCY(Wn)	*/
+int	PmHeight ;		/* \GAcTCY(Wn)	*/
+int	PmLeft ;		/* \GAJnʒu			*/
+int	PmTop ;			/* \GAJnʒu			*/
+HWND	PmHwndPopupMenu ;	/* |bvAbvj[nh		*/
+int	PmPopupMenuMin ;	/* |bvAbvj[ŏID	*/
+int	PmPopupMenuMax ;	/* |bvAbvj[ő區ID	*/
+int	PmPopupSubMenuMin ;	/* Tuj[JnID			*/
+int	PmPopupSubMenuMax ;	/* Tuj[IID			*/
+ULONG	*PmPopupMenuItems ;	/* I Lisp_Objects e[u	*/
+FONTSPEC PmFont ;		/* gptHgf[^e[u		*/
+FONTSPEC PmOldFont ;		/* gptHgf[^e[u		*/
+FATTRS	NowFontAttrs ;		/* ݎgptHg}gNX		*/
+
+#ifdef	USE_OUTLINE_FONT
+int	PmOutline ;		/* AEgCtHggp̗L	*/
+#endif
+
+int	PmDisableShortcuts ;	/* VXeL[LtO (L=FALSE)	*/
+char	PmButtons[3] ;		/* }EX{^Ro[g}bv		*/
+COLOR	PmCurrentColor ;	/* \F				*/
+COLOR	PmCurrentBackcolor ;	/* wiF				*/
+COLOR	PmHighlightColor ;	/* nCCg\F			*/
+COLOR	PmHighlightBackcolor ;	/* nCCgwiF			*/
+int	PmFunctionKeyMenu ;	/* t@NV@\j[\tO	*/
+int	PmFunctionRows ;	/* t@NV@\j[\s	*/
+PUCHAR	PmFuncMenuData[12] ;	/* t@NVj[\f[^	*/
+RECTL	PmFuncMenuRect[12] ;	/* t@NVj[\ʒu	*/
+POINTL	PmFuncMenuCharOffset ;	/* t@NVbZ[W\ʒu	*/
+
+/* Window class names. */
+char	szClientClass[] = "pmmule.client" ;
+char	szPecicClientClass[] = "pmmule.pecic" ;
+
+ULONG	*menu_items ;		/* Where to store the next menu event.	*/
+
+int	MenuSelect = FALSE ;	/* j[ItO			*/
+LONG	cyMenu ;		/* j[ڂ̍			*/
+LONG	cxSysChar ;		/* VXeȗhbgTCY	*/
+LONG	cySysChar ;		/* VXeȗchbgTCY	*/
+LONG	cxBorder ;		/* VXe{[_[TCY		*/
+LONG	cyBorder ;		/* VXe{[_[cTCY		*/
+LONG	cxSizeBorder ;		/* VXeTCY{[_[TCY	*/
+LONG	cxRes ;			/* VXetHg𑜓xTCY	*/
+
+int	MulePid ;		/* Mule{̂̃vZXID			*/
+int	QuitChar = 0x07 ;	/* L[荞݃R[h(ȗl C-g)	*/
+int	terminating = TRUE ;	/* Mule{̂ւ̒ʐM֎~tO		*/
+
+HWND	PmHwndPecic ;		/* {L[ԊǗEBhEnh	*/
+
+PFNWP	OrgPecicFrameWndProc ;	/* t[Cxg		*/
+HPS	PmHpsPecic ;		/* PM Mule v[[e[V Xy[X	*/
+int	PecicMode ;		/* {̓EBhE[h		*/
+PECICTABLE	Pecic[32] ;	/* {͗pEBhEnh	*/
+int	PecicWndCount = 0 ;	/* {͗pEBhE		*/
+UCHAR	PecicText[256] ;	/* {̓eLXgf[^		*/
+UCHAR	PecicAttr[256] ;	/* {͑e[^			*/
+int	PecicLength = 0 ;	/* {̓f[^			*/
+int	PecicCurPos = 0 ;	/* {̓J[\ʒu		*/
+int	PecicCurType = 0 ;	/* {̓J[\`		*/
+int	PecicCurBase = 0 ;	/* {̓J[\ʒuEBhE	*/
+int	PecicCurOffset = 0 ;	/* {̓J[\Έʒu		*/
+
+UCHAR	*FuncDefMenu[12] = {
+    "F1", "F2", "F3", "F4",
+    "F5", "F6", "F7", "F8",
+    "F9", "F10", "F11", "F12",
+} ;
+
+/* Prototypes for functions which are used before defined. */
+void compute_func_menu( void ) ;
+void display_func_menu( void ) ;
+void ConvPecicPos( PPOINTL ptl ) ;
+void PecicCreateWindow( void ) ;
+void PecicDestroyWindow( void ) ;
+void PecicMoveWindow( void ) ;
+
+
+#define CONV_BUTTON( c ) ( ( c ) >= '1' && ( c ) <= '3' ? ( c ) - '0' : 0 )
+#define MAKE_X( x ) ( ( x ) * PmCxChar )
+#define MAKE_Y( y ) ( PmCyClient + PmCyDesc - ( ( y ) + 1 ) * PmCyChar )
+
+
+/********************************************************/
+/*							*/
+/*	G[bZ[W\			*/
+/*							*/
+/********************************************************/
+void error( const char *msg )
+{
+    WinMessageBox( HWND_DESKTOP, HWND_DESKTOP, msg, "PM Mule error", 0,
+		   MB_MOVEABLE | MB_OK | MB_ICONEXCLAMATION ) ;
+    DosExit( EXIT_PROCESS, 1 ) ;
+}
+
+/********************************************************/
+/*							*/
+/*	[m(OS/2t@NVgp)		*/
+/*							*/
+/********************************************************/
+void *MemAlloc( ULONG size )
+{
+    ULONG	rc ;
+    void	*p ;
+
+    if ( size == 0 )
+	return ( NULL ) ;
+    rc = DosAllocMem( ( PVOID )&p, size, PAG_COMMIT | PAG_READ | PAG_WRITE ) ;
+    if ( rc != 0 )
+	error( "Out of memory." ) ;
+    return( p ) ;
+}
+
+/********************************************************/
+/*							*/
+/*	[J(OS/2t@NVgp)		*/
+/*							*/
+/********************************************************/
+void MemFree( void *p )
+{
+    if ( p != NULL )
+	DosFreeMem( p ) ;
+}
+
+/********************************************************/
+/*							*/
+/*	Mule{̂փpCvgăf[^]		*/
+/*							*/
+/********************************************************/
+void Send( int fd, const void *src, size_t size )
+{
+    const	char *s ;
+    ULONG	n ;
+
+    if ( terminating )
+	return ;
+    s = src ;
+    while ( size ) {
+	if ( DosWrite( fd, s, size, &n ) != 0 || n == 0 )
+	    error( "Cannot write to pipe" ) ;
+	size -= n ;
+	s += n ;
+    }
+}
+
+/********************************************************/
+/*							*/
+/*	Mule{̂̕W͂PMCxgf[^]	*/
+/*							*/
+/********************************************************/
+void SendEvent( const pm_event *src )
+{
+    Send( OutPipe, src, sizeof( pm_event ) ) ;
+}
+
+/********************************************************/
+/*							*/
+/*	Mule{̂փf[^ubN]			*/
+/*							*/
+/********************************************************/
+void SendOutdata( const void *src, unsigned size )
+{
+    Send( OutdataPipe, src, size ) ;
+}
+
+/********************************************************/
+/*							*/
+/*	OS/2`̃tHg`ɕϊ	*/
+/*							*/
+/********************************************************/
+int parse_font_spec( FONTSPEC *dst, const unsigned char *str )
+{
+    int		i ;
+
+    dst->size = 0 ;
+    dst->sel = 0 ;
+    dst->name[0] = 0 ;
+    while ( *str >= '0' && *str <= '9' ) {
+	dst->size = dst->size * 10 + ( *str - '0' ) ;
+	++str ;
+    }
+    dst->size *= 10 ;
+    if ( dst->size == 0 )
+	return FALSE ;
+    for ( ; ; ) {
+	if ( strncmp( str, ".bold", 5 ) == 0 ) {
+	    dst->sel |= FM_SEL_BOLD ;
+	    str += 5 ;
+	} else if ( strncmp( str, ".italic", 7 ) == 0 ) {
+	    dst->sel |= FM_SEL_ITALIC ;
+	    str += 7 ;
+	} else if ( *str == '.' ) {
+	    ++str ;
+	    break ;
+	} else
+	    return FALSE ;
+    }
+    if ( *str == 0 )
+	return FALSE ;
+    _strncpy( dst->name, str, sizeof( dst->name ) ) ;
+    return TRUE ;
+}
+
+/********************************************************/
+/*							*/
+/*	wtHg(`)VXeɓo^	*/
+/*							*/
+/********************************************************/
+int select_font_internal( void )
+{
+    ULONG		fonts, temp, i ;
+    PFONTMETRICS	pfm ;
+#ifdef USE_OUTLINE_FONT
+    USHORT		size ;
+    FIXED		font_cbox ;
+    SIZEF		cbox ;
+#endif
+
+    temp = 0 ;
+    fonts = GpiQueryFonts( PmHpsClient, QF_PUBLIC | QF_PRIVATE,
+			  PmFont.name,
+			  &temp, sizeof( FONTMETRICS ), NULL ) ;
+    pfm = MemAlloc( fonts * sizeof( FONTMETRICS ) ) ;
+    GpiQueryFonts( PmHpsClient, QF_PUBLIC | QF_PRIVATE,
+		  PmFont.name,
+		  &fonts, sizeof( FONTMETRICS ), pfm ) ;
+
+    for ( i = 0; i < fonts; ++i ) {
+	if ( !( pfm[i].fsType & FM_TYPE_FIXED ) )
+	    continue ;
+#ifndef USE_OUTLINE_FONT
+	if ( pfm[i].fsDefn & FM_DEFN_OUTLINE )
+	    continue ;
+	if ( pfm[i].sNominalPointSize == PmFont.size ) {
+#else
+	if ( pfm[i].sNominalPointSize == PmFont.size ||
+	    ( pfm[i].fsDefn & FM_DEFN_OUTLINE ) ) {
+#endif
+	    /* tHgo^ */
+	    NowFontAttrs.usRecordLength  = sizeof( NowFontAttrs ) ;
+	    NowFontAttrs.fsSelection     = PmFont.sel ;
+	    NowFontAttrs.lMatch          = pfm[i].lMatch ;
+	    strcpy( NowFontAttrs.szFacename, pfm[i].szFacename ) ;
+	    NowFontAttrs.idRegistry      = pfm[i].idRegistry ;
+	    NowFontAttrs.usCodePage      = pfm[i].usCodePage ;
+	    NowFontAttrs.lMaxBaselineExt = pfm[i].lMaxBaselineExt ;
+	    NowFontAttrs.lAveCharWidth   = pfm[i].lAveCharWidth ;
+	    NowFontAttrs.fsType          = 0 ;
+	    NowFontAttrs.fsFontUse       = 0 ;
+	    if ( GpiCreateLogFont( PmHpsClient, NULL, SELECT_FONT_ID,
+				  &NowFontAttrs ) == GPI_ERROR )
+		continue ;	
+	    GpiSetCharSet( PmHpsClient, SELECT_FONT_ID ) ;
+#ifdef USE_OUTLINE_FONT
+	    if ( pfm[i].fsDefn & FM_DEFN_OUTLINE ) {
+		PmOutline = TRUE ;
+		size = ( USHORT )( ( double )PmFont.size * ( double )cxRes
+				  / 720.0 + 0.5 ) ;
+		font_cbox = MAKEFIXED( size, 0 ) ;
+		cbox.cx = cbox.cy = font_cbox ;
+		GpiSetCharBox( PmHpsClient, &cbox ) ;
+	    } else {
+		PmOutline = FALSE ;
+	    }
+#endif
+	    /* {̓EBhEύX */
+	    for ( i = 0; i < PecicWndCount; ++i ) {
+		GpiCreateLogFont( Pecic[i].Ps, NULL, SELECT_FONT_ID,
+				 &NowFontAttrs ) ;
+		GpiSetCharSet( Pecic[i].Ps, SELECT_FONT_ID ) ;
+#ifdef USE_OUTLINE_FONT
+		if ( PmOutline ) {
+		    GpiSetCharBox( Pecic[i].Ps, &cbox) ;
+		}
+#endif
+	    }
+	    MemFree( pfm ) ;
+	    return TRUE ;
+	}
+    }
+    MemFree( pfm ) ;
+    return FALSE ;
+}
+
+/********************************************************/
+/*							*/
+/*	PMŎgptHgw肷			*/
+/*							*/
+/********************************************************/
+void set_default_font( void )
+{
+    FONTMETRICS		fm ;
+
+    if ( !select_font_internal( ) ) {
+	PmFont = PmOldFont ;
+	select_font_internal( ) ;
+    }
+    GpiQueryFontMetrics( PmHpsClient, ( LONG )sizeof( fm ), &fm ) ;
+    PmCxChar = fm.lMaxCharInc ;
+    PmCyChar = fm.lMaxBaselineExt ;
+    PmCyDesc = fm.lMaxDescender ;
+}
+
+/********************************************************/
+/*							*/
+/*	EBhETCYƕ\ʒuݒ肷		*/
+/*							*/
+/********************************************************/
+void set_size( int first )
+{
+    RECTL	rcl ;
+    SWP		swp ;
+    POINTL	ptl ;
+    ULONG	options ;
+
+
+    options = SWP_SIZE | SWP_SHOW ;
+    if ( first )
+	options |= SWP_ZORDER ;
+    else
+	options |= SWP_MOVE ;
+
+    /* ݂̃EBhETCY&ʒuVTCY&ʒuČvZ
+       TCY肷 */
+    WinQueryWindowPos( PmHwndClient, &swp ) ;
+    ptl.x = swp.x ;                /* Upper left-hand corner */
+    ptl.y = swp.y + swp.cy ;
+    WinMapWindowPoints( PmHwndFrame, HWND_DESKTOP, &ptl, 1 ) ;
+    rcl.xLeft = ptl.x ;
+    rcl.xRight = rcl.xLeft + PmWidth * PmCxChar ;
+    rcl.yTop = ptl.y ;
+    if ( PmFunctionKeyMenu )
+	rcl.yBottom = rcl.yTop - ( PmHeight + PmFunctionRows ) * PmCyChar ;
+    else
+	rcl.yBottom = rcl.yTop - PmHeight * PmCyChar ;
+    WinCalcFrameRect( PmHwndFrame, &rcl, FALSE ) ;
+
+    /* EBhE\ۂ̃XN[Oɏo悤ȏꍇ̓EBhE
+       \悤Ɉʒuړ */
+    if ( rcl.yTop > swpScreen.cy ) {
+	LONG offset = rcl.yTop - swpScreen.cy ;
+	rcl.yBottom -= offset ;
+	rcl.yTop -= offset ;
+	options |= SWP_MOVE ;
+    }
+    WinSetWindowPos( PmHwndFrame, HWND_TOP, rcl.xLeft, rcl.yBottom,
+		    rcl.xRight - rcl.xLeft, rcl.yTop - rcl.yBottom, options ) ;
+}
+
+/********************************************************/
+/*							*/
+/* L[̓R[h{̂ɑM			*/
+/*							*/
+/********************************************************/
+void SendKey( pm_key_type type, int code, int rep )
+{
+    pm_event	pme ;
+    int		i ;
+
+    if ( type == PMK_ASCII && code == QuitChar )
+	kill( MulePid, SIGINT ) ;
+    else {
+	pme.key.header.type = PME_KEY ;
+	pme.key.type = type ;
+	pme.key.code = code ;
+	for ( i = 0; i < rep; ++i )
+	    SendEvent( &pme ) ;
+    }
+}
+
+/********************************************************/
+/*							*/
+/* PMNCAgɃJ[\𐶐			*/
+/*							*/
+/********************************************************/
+void create_cursor( int size )
+{
+    LONG	cx, cy ;
+    ULONG	flags ;
+
+    if ( PecicLength )
+	return ;
+
+    if ( PmCxChar != 0 && PmCyChar != 0 ) {
+	cx = PmCxChar ;
+	if ( size )
+	    cx <<= 1 ;
+	cy = PmCyChar ;
+	flags = CURSOR_SOLID ;
+	switch ( PmCursorType ) {
+        case CURSORTYPE_BAR:
+	    cx = 0 ;
+	    break ;
+        case CURSORTYPE_FRAME:
+	    flags = CURSOR_FRAME ;
+	    break ;
+        case CURSORTYPE_UNDERLINE:
+	    cy = 0 ;
+	    break ;
+        case CURSORTYPE_HALFTONE:
+	    flags = CURSOR_HALFTONE ;
+	    break ;
+        case CURSORTYPE_BOX:
+	    break ;
+        }
+	if ( PmCursorBlink )
+	    flags |= CURSOR_FLASH ;
+	WinCreateCursor( PmHwndClient,
+			 PmCursorX, PmCursorY,
+			 cx, cy,
+			 flags, NULL ) ;
+	if ( PmCursorOn )
+	    WinShowCursor( PmHwndClient, TRUE ) ;
+    }
+}
+
+/********************************************************/
+/*							*/
+/* PM MuleEBhEɃtH[JXꍇ̂		*/
+/* J[\\					*/
+/*							*/
+/********************************************************/
+void set_cursor( void )
+{
+    if ( PmHwndClient == WinQueryFocus( HWND_DESKTOP ) ) {
+	WinDestroyCursor( PmHwndClient ) ;
+	create_cursor( 0 ) ;
+    }
+}
+
+/********************************************************/
+/*							*/
+/*@j[EBhE𐶐(SUBEBhE܂)	*/
+/*							*/
+/********************************************************/
+HWND create_menu_handle( HWND hwndParent, HWND hwndOwner, ULONG id )
+{
+    return ( WinCreateWindow( hwndParent, WC_MENU, "", 0, 0, 0, 0, 0,
+			     hwndOwner, HWND_TOP, id, NULL, NULL ) ) ;
+}
+
+/********************************************************/
+/*							*/
+/* j[ڂݒ(})				*/
+/*							*/
+/********************************************************/
+void create_pane( HWND hwndMenu, char **ptr,
+		 char *title, int title_size )
+{
+    MENUITEM		mi ;
+    pm_menu_pane	pmp ;
+    pm_menu_line	pml ;
+    char		buf[512], *p ;
+    int			j, len ;
+
+    p = *ptr ;
+    memcpy( &pmp, p, sizeof( pmp ) ) ;
+    p += sizeof( pmp ) ;
+    len = pmp.size ;
+    if ( title != NULL && title_size > 0 ) {
+	if ( len >= title_size )
+	    len = title_size - 1 ;
+	memcpy( title, p, len ) ;
+	title[len] = 0 ;
+    }
+    p += pmp.size ;
+    for ( j = 0; j < pmp.lines; ++j ) {
+	memcpy( &pml, p, sizeof( pml ) ) ;
+	p += sizeof( pml ) ;
+	len = pml.size ;
+	if ( len >= sizeof( buf ) )
+	    len = sizeof( buf ) - 1 ;
+	memcpy( buf, p, len ) ;
+	p += pml.size ;
+	buf[len] = 0 ;
+	*menu_items++ = pml.item ;
+	mi.iPosition = MIT_END ;
+	mi.afStyle = MIS_TEXT ;
+	mi.afAttribute = (pml.enable ? 0 : MIA_DISABLED) ;
+	mi.hwndSubMenu = NULL ;
+	mi.hItem = 0 ;
+	mi.id = PmPopupMenuMax++ ;
+	WinSendMsg( hwndMenu, MM_INSERTITEM, MPFROMP( &mi ), MPFROMP( buf ) ) ;
+    }
+    *ptr = p ;
+}
+
+/********************************************************/
+/*							*/
+/*@Cj[O[v𐶐			*/
+/*							*/
+/********************************************************/
+void create_menu( HWND hwndMenu, HWND hwndOwner, int panes, char **p )
+{
+    MENUITEM	mi ;
+    char	buf[512] ;
+    int		i ;
+
+    if ( panes == 1 )
+	create_pane( hwndMenu, p, NULL, 0 ) ;
+    else
+	for ( i = 0; i < panes; ++i ) {
+	    if ( ( ( pm_menu_pane *)*p )->size == 0 )
+		create_pane( hwndMenu, p, NULL, 0 ) ;
+	    else {
+		mi.hwndSubMenu = create_menu_handle( hwndMenu, hwndOwner, 0 ) ;
+		mi.afStyle = MIS_SUBMENU | MIS_TEXT ;
+		create_pane( mi.hwndSubMenu, p, buf, sizeof( buf ) ) ;
+		mi.iPosition = MIT_END ;
+		mi.afAttribute = 0 ;
+		mi.hItem = 0 ;
+		mi.id = PmPopupSubMenuMax++ ;
+		WinSendMsg( hwndMenu, MM_INSERTITEM, MPFROMP( &mi ),
+			    MPFROMP( buf ) ) ;
+	    }
+	}
+}
+
+/********************************************************/
+/*							*/
+/*@|bvAbvj[𐶐			*/
+/*							*/
+/********************************************************/
+HWND create_popup_menu( int panes, int lines, char *p, int Titlelen )
+{
+    HWND	hwnd ;
+    MENUITEM	mi ;
+    char	buf[512] ;
+
+    hwnd = create_menu_handle( PmHwndClient, PmHwndClient, 0 ) ;
+    PmPopupSubMenuMin = PmPopupSubMenuMax = IDM_POPUP + 1000 ;
+
+    /* j[Ŝ̃^Cg𐶐 */
+    memcpy( buf, p, Titlelen ) ;
+    buf[Titlelen] = 0 ;
+    strcat( buf,"@" ) ;
+    mi.iPosition = MIT_END ;
+    mi.afAttribute = 0 ;
+    mi.hwndSubMenu = NULL ;
+    mi.hItem = 0 ;
+    mi.id = PmPopupSubMenuMax++ ;
+    mi.afStyle = MIS_SEPARATOR ;
+    WinSendMsg( hwnd, MM_INSERTITEM, MPFROMP( &mi ), MPFROMP( buf ) ) ;
+    mi.id = PmPopupSubMenuMax++ ;
+    mi.afStyle = MIS_TEXT | MIS_STATIC ;
+    WinSendMsg( hwnd, MM_INSERTITEM, MPFROMP( &mi ), MPFROMP( buf ) ) ;
+    mi.id = PmPopupSubMenuMax++ ;
+    mi.afStyle = MIS_SEPARATOR ;
+    WinSendMsg( hwnd, MM_INSERTITEM, MPFROMP( &mi ), MPFROMP( buf ) ) ;
+    p += Titlelen ;
+
+    PmPopupMenuItems = MemAlloc( lines * sizeof( *PmPopupMenuItems ) ) ;
+    PmPopupMenuMin = PmPopupMenuMax = IDM_POPUP ;
+    menu_items = PmPopupMenuItems ;
+    create_menu( hwnd, PmHwndClient, panes, &p ) ;
+    menu_items = NULL ;
+    return hwnd ;
+}
+
+/********************************************************/
+/*							*/
+/* }EXCxgƃL[{[hԂŃCxg𐶐	*/
+/*							*/
+/********************************************************/
+int mouse_button( HWND hwnd, MPARAM mp1, MPARAM mp2, int button,
+                         int modifier )
+{
+    pm_event	pme ;
+    int		key ;
+
+    if ( hwnd == WinQueryFocus( HWND_DESKTOP ) ) {
+	pme.button.header.type = PME_BUTTON ;
+	pme.button.button = PmButtons[button] ;
+	key = ( int )SHORT2FROMMP( mp2 ) ;
+	if ( key & KC_ALT )	pme.button.button |= ALT_MODIFIER ;
+	if ( key & KC_CTRL )	pme.button.button |= CTRL_MODIFIER ;
+	if ( key & KC_SHIFT )	pme.button.button |= SHIFT_MODIFIER ;
+	pme.button.button |= modifier ;
+	pme.button.x = ( USHORT )SHORT1FROMMP( mp1 ) / PmCxChar ;
+	pme.button.y = ( PmCyClient - ( USHORT )SHORT2FROMMP( mp1 ) )
+	    / PmCyChar ;
+	if ( pme.button.x < 0 ) pme.button.x = 0 ;
+	if ( pme.button.y < 0 ) pme.button.y = 0 ;
+	pme.button.timestamp = WinQueryMsgTime( hab ) ;
+	SendEvent( &pme ) ;
+	return TRUE ;
+    }
+    /* Continue processing -- make window active */
+    return FALSE ;
+}
+
+static char VKeyTable[][4] = {
+    {	0x49,	0x49,	0x84,	0x99	},	/* VK_PAGEUP      */
+    {	0x51,	0x51,	0x76,	0xA1	},	/* VK_PAGEDOWN    */
+    {	0x4F,	0x4F,	0x75,	0x9F	},	/* VK_END         */
+    {	0x47,	0x47,	0x77,	0x97	},	/* VK_HOME        */
+    {	0x4B,	0x4B,	0x73,	0x9B	},	/* VK_LEFT        */
+    {	0x48,	0x48,	0x8D,	0x98	},	/* VK_UP          */
+    {	0x4D,	0x4D,	0x74,	0x9D	},	/* VK_RIGHT       */
+    {	0x50,	0x50,	0x91,	0xA0	},	/* VK_DOWN        */
+    {	0x00,	0x00,	0x00,	0x00	},	/* VK_PRINTSCRN   */
+    {	0x52,	0x04,	0x92,	0xA2	},	/* VK_INSERT      */
+    {	0x53,	0x05,	0x93,	0xA3	},	/* VK_DELETE      */
+    {	0x00,	0x00,	0x00,	0x00	},	/* VK_SCRLLOCK    */
+    {	0x00,	0x00,	0x00,	0x00	},	/* VK_NUMLOCK     */
+    {	0x0A,	0x0A,	0x0A,	0x1C	},	/* VK_ENTER       */
+    {	0x00,	0x00,	0x00,	0x00	},	/* VK_SYSRQ       */
+    {	0x3B,	0x54,	0x5E,	0x68	},	/* VK_F1          */
+    {	0x3C,	0x55,	0x5F,	0x69	},	/* VK_F2          */
+    {	0x3D,	0x56,	0x60,	0x6A	},	/* VK_F3          */
+    {	0x3E,	0x57,	0x61,	0x6B	},	/* VK_F4          */
+    {	0x3F,	0x58,	0x62,	0x6C	},	/* VK_F5          */
+    {	0x40,	0x59,	0x63,	0x6D	},	/* VK_F6          */
+    {	0x41,	0x5A,	0x64,	0x6E	},	/* VK_F7          */
+    {	0x42,	0x5B,	0x65,	0x6F	},	/* VK_F8          */
+    {	0x43,	0x5C,	0x66,	0x70	},	/* VK_F9          */
+    {	0x45,	0x5D,	0x67,	0x71	},	/* VK_F10         */
+    {	0x85,	0x87,	0x89,	0x8B	},	/* VK_F11         */
+    {	0x86,	0x88,	0x8A,	0x8C	},	/* VK_F12         */
+} ;
+
+/********************************************************/
+/*							*/
+/* PM MulẽCNCAgEBhE		*/
+/*							*/
+/********************************************************/
+MRESULT ClientWndProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
+{
+    HPS		hps ;
+    HDC		hdc ;
+    RECTL	rcl ;
+    POINTL	ptl ;
+    SIZEL	sizel ;
+    SWP		swp ;
+    ULONG	menu_item, options, cmd ;
+    unsigned	fsflags, usch, usvk, usrep, ussc ;
+    pm_event	pme ;
+    MENUDATA	*md ;
+    int		i ;
+
+    switch ( msg ) {
+    case WM_CREATE:
+	PmHwndPopupMenu = NULLHANDLE ;
+	hdc = WinOpenWindowDC( hwnd ) ;
+	DevQueryCaps( hdc, CAPS_GRAPHICS_CHAR_WIDTH, 1, &cxSysChar ) ;
+	DevQueryCaps( hdc, CAPS_GRAPHICS_CHAR_HEIGHT, 1, &cySysChar ) ;
+	DevQueryCaps( hdc, CAPS_HORIZONTAL_FONT_RES, 1, &cxRes ) ;
+
+	sizel.cx = sizel.cy = 0 ;
+	PmHpsClient = GpiCreatePS( hab, hdc, &sizel,
+				    PU_PELS | GPIT_MICRO | GPIA_ASSOC ) ;
+
+	GpiSetBackMix( PmHpsClient, BM_OVERPAINT ) ;
+
+	/* Switch color table to RGB mode.	*/
+	GpiCreateLogColorTable( PmHpsClient, LCOL_PURECOLOR, LCOLF_RGB,
+				0, 0, NULL ) ;
+
+	hptrCursor = WinLoadPointer( HWND_DESKTOP, ( HMODULE )0L, 2 ) ;
+
+	/* 莞̃tHgw (VXeftHgtHggp) */
+	PmFont.size = ( ( 720 / cxRes ) + 1 ) * 10 ;
+	PmFont.sel = 0 ;
+	strcpy( PmFont.name, "GOTHIC" ) ;
+	PmOldFont = PmFont ;
+	set_default_font( ) ;
+	return 0 ;
+
+    case WM_DESTROY:
+	GpiDestroyPS( PmHpsClient ) ;
+	if ( PecicMode )
+	    PecicDestroyWindow( ) ;
+	break ;
+
+    case WM_PAINT:
+	hps = WinBeginPaint( hwnd, PmHpsClient, &rcl ) ;
+	WinFillRect( hps, &rcl, PmCurrentBackcolor ) ;
+	if ( rcl.yBottom <= MAKE_Y( PmHeight - 1 ) - PmCyDesc - 1 ) 
+	    display_func_menu( ) ;
+	WinEndPaint( hps ) ;
+
+	/* Send a redraw event to Emacs.  The minimal bounding rectangle
+	   for the update region is sent along with the event.  */
+	pme.paint.header.type = PME_PAINT ;
+	pme.paint.x0 = rcl.xLeft  / PmCxChar ;
+	pme.paint.x1 = rcl.xRight / PmCxChar ;
+	pme.paint.y0 = ( PmCyClient - rcl.yTop )    / PmCyChar ;
+	pme.paint.y1 = ( PmCyClient - rcl.yBottom ) / PmCyChar ;
+	SendEvent( &pme ) ;
+	return 0 ;
+
+    case WM_CLOSE:
+	SendKey( PMK_ASCII, 'X' & 0x1f, 1 ) ;
+	SendKey( PMK_ASCII, 'C' & 0x1f, 1 ) ;
+	return 0 ;
+
+    case WM_CHAR:
+	/* EMXtermioƓR[ȟn̂邽߁AtermioŌołȂ
+	   gݍ킹͖ */
+
+	fsflags = ( USHORT )SHORT1FROMMP( mp1 ) ;
+
+	/* L[AbvCxg͖ */
+	if ( fsflags & KC_KEYUP )
+	    return 0 ;
+
+	usrep = CHAR3FROMMP( mp1 ) ;
+	ussc  = CHAR4FROMMP( mp1 ) ;
+	usch  = ( USHORT )SHORT1FROMMP( mp2 ) ;
+	usvk  = ( USHORT )SHORT2FROMMP( mp2 ) ;
+
+	/* gL[P̂̏ꍇ̓^[ */
+	switch ( usvk ) {
+	case VK_NUMLOCK:
+	case VK_CAPSLOCK:
+	case VK_SHIFT:
+	case VK_ALT:
+	case VK_CTRL:
+	    return 0 ;
+	}
+
+	/* _CNgR[h͂`FbN */
+	if ( ( fsflags & ( KC_ALT | KC_SCANCODE ) )
+	    == ( KC_ALT | KC_SCANCODE ) ) {
+	    switch ( ussc ) {
+	    case 0x47: case 0x48: case 0x49:   /* 7 8 9 */
+	    case 0x4b: case 0x4c: case 0x4d:   /* 4 5 6 */
+	    case 0x4f: case 0x50: case 0x51:   /* 1 2 3 */
+	    case 0x52:                         /* 0     */
+		/* eL[̏ꍇ̓_CNg͂ł */
+		return 0 ;
+	    }
+	}
+
+	/* zL[ */
+	if ( fsflags & KC_VIRTUALKEY ) {
+	    switch ( usvk ) {
+	    case VK_ESC:
+		SendKey( PMK_ASCII, 0x1b, usrep ) ;
+		return 0 ;
+
+	    case VK_BACKSPACE:
+		if ( fsflags & KC_ALT ) {
+		    for ( i = 0; i < usrep; ++i ) {
+			SendKey( PMK_ASCII, 0, 1 ) ;
+			SendKey( PMK_ASCII, 0x0e, 1 ) ;
+		    }
+		} else
+		    SendKey( PMK_ASCII, 0x7f, usrep ) ;
+		return 0 ;
+
+	    case VK_NEWLINE:
+	    case VK_ENTER:
+		/* Rg[L[p̏ꍇ LFDL[ƂăR[gԂ */
+		if ( fsflags & KC_CTRL )
+		    SendKey( PMK_ASCII, 0x0a, usrep ) ;
+		else
+		    SendKey( PMK_ASCII, 0x0d, usrep ) ;
+		return 0 ;
+
+	    case VK_SPACE:
+		if ( ( fsflags & ( KC_CTRL | KC_ALT ) ) == 0 ) {
+		    SendKey( PMK_ASCII, 0x20, usrep ) ;
+		    return 0 ;
+		}
+		for ( i = 0; i < usrep; ++i ) {
+		    SendKey( PMK_ASCII, 0, 1 ) ;
+		    if ( ( fsflags & KC_CTRL ) == KC_CTRL )
+			SendKey( PMK_ASCII, 0x02, 1 ) ;
+		    else
+			SendKey( PMK_ASCII, 0x39, 1 ) ;
+		}
+		return 0 ;
+	    } /* end of switch */
+
+	    if ( usvk >= VK_PAGEUP && usvk <= VK_F12
+		&& !( fsflags & KC_CHAR ) ) {
+		for ( i = 0; i < usrep; ++i ) {
+		    SendKey( PMK_ASCII, 0, 1 ) ;
+		    if ( fsflags & KC_ALT ) {
+			SendKey( PMK_ASCII, VKeyTable[usvk-VK_PAGEUP][3], 1 ) ;
+		    } else if ( fsflags & KC_CTRL ) {
+			SendKey( PMK_ASCII, VKeyTable[usvk-VK_PAGEUP][2], 1 ) ;
+		    } else if ( fsflags & KC_SHIFT ) {
+			SendKey( PMK_ASCII, VKeyTable[usvk-VK_PAGEUP][1], 1 ) ;
+		    } else
+			SendKey( PMK_ASCII, VKeyTable[usvk-VK_PAGEUP][0], 1 ) ;
+		}
+		return 0 ;
+            }
+	}
+
+	/* ͂̂ */
+	if (fsflags & KC_CHAR) {
+	    if ( usch > 0xff )
+		SendKey( PMK_KANJI, usch, usrep ) ;
+	    else		    
+		SendKey( PMK_ASCII, usch, usrep ) ;
+	    return 0 ;
+        }
+
+	/* CTRL+ʃL[̏ */
+	if ( fsflags & KC_CTRL ) {
+	    if ( usch >= 0x40 && usch <= 0x7f ) {
+		if ( usch == 0x40 ) {
+		    /* C-@ */
+		    for ( i = 0; i < usrep; ++i ) {
+			SendKey( PMK_ASCII, 0, 1 ) ;
+			SendKey( PMK_ASCII, 0x03, 1 ) ;
+		    }
+		} else {
+		    SendKey( PMK_ASCII, usch & 0x1f, usrep ) ;
+		}
+	    } else if ( ( usch & 0xff ) != 0 ) {
+		SendKey( PMK_ASCII, usch, usrep ) ;
+            }
+	    return 0 ;
+        }
+
+	/* ALT+ʃL[̏ */
+	if ( fsflags & KC_ALT ) {
+	    if ( ussc >= 0x02 && ussc <= 0x0d )
+		/* ALT+1`ALT+= */
+		ussc += 0x76 ;
+	    else if ( ussc == 0x92 )
+		/* AXL[""L[ */
+		ussc = 0xb3 ;
+	    for ( i = 0; i < usrep; ++i ) {
+		SendKey( PMK_ASCII, 0, 1 ) ;
+		SendKey( PMK_ASCII, ussc, 1 ) ;
+	    }
+	    return 0 ;
+	}
+
+	/* eL[Rg[L[̎5 */
+	if ( ussc == 0x4c ) {
+	    for ( i = 0; i < usrep; ++i ) {
+		SendKey( PMK_ASCII, 0, 1 ) ;
+		SendKey( PMK_ASCII, ussc, 1 ) ;
+	    }
+	    return 0 ;
+	}
+
+	/* {tgGhLbN̊gꍇ */
+	if ( fsflags & KC_VIRTUALKEY ) {
+	    SendKey( PMK_VIRTUAL, usvk, usrep ) ;
+	    switch ( usvk ) {
+	    case VK_DBE_IMEACTIVATE:
+		PecicMode = 1 ;
+		PecicCreateWindow( ) ;
+		return 0 ;
+
+	    case VK_DBE_IMEDEACTIVATE:
+		PecicMode = 0 ;
+		PecicDestroyWindow( ) ;
+		return 0 ;
+	    default:
+		return 0 ;
+	    }
+	}
+	return 0 ;
+
+    case WM_TRANSLATEACCEL:
+
+	/* Examine accelerator table.  We ignore the accelerator table
+	   if the shortcuts frame parameter is nil.  By ignoring the
+	   accelerator table, we receive WM_CHAR messages for F1, F10,
+	   A-f4, A-space etc. */
+
+	if ( PmDisableShortcuts )
+	    return FALSE ;
+	break ;
+
+    case WM_COMMAND:
+	cmd = COMMANDMSG( &msg )->cmd ;
+	/* |bvAbvj[̃Cxg */
+	if ( COMMANDMSG( &msg )->source == CMDSRC_MENU
+	    && cmd >= PmPopupMenuMin
+	    && cmd < PmPopupMenuMax ) {
+	    /* IꂽڔԍMule{̂ɑ */
+	    menu_item = PmPopupMenuItems[cmd - PmPopupMenuMin];
+	    SendOutdata( &menu_item, sizeof( menu_item ) ) ;
+	    return 0 ;
+        }
+
+	switch ( cmd ) {
+	case IDM_FUNCMENU:
+	    WinSetFocus( HWND_DESKTOP, PmHwndClient ) ;
+	    return 0 ;
+	}
+
+	break ;
+
+    case WM_MENUEND:
+	/* |bvAbvj[Iꍇ̂ݏ */
+	if ( HWNDFROMMP( mp2 ) == PmHwndPopupMenu ) {
+	    /* j[IAڑIĂ邩`FbNAI
+	       Ȃꍇ IƂMule{̂ɍڔԍ𑗂 */
+	    if ( !MenuSelect ) {
+		menu_item = 0 ;
+		SendOutdata( &menu_item, sizeof( menu_item ) ) ;
+            }
+        }
+	return 0 ;
+
+    case WM_MENUSELECT:
+	/* |bvAbvj[Iꂽꍇ̓tOZbgB
+	   ۂ̑Iڂ̔ԍ]̓|bvAbvj[Ă瑗
+	   WM_COMMANDōsB*/
+
+	if ( SHORT2FROMMP( mp1 ) ) {
+	    cmd = SHORT1FROMMP( mp1 ) ;
+	    if ( cmd >= PmPopupMenuMin
+		&& cmd < PmPopupMenuMax )
+		MenuSelect = TRUE ;
+        }
+	break ;
+
+    case WM_BUTTON1DOWN:
+	if ( mouse_button( hwnd, mp1, mp2, 0, DOWN_MODIFIER ) )
+	    return ( MRESULT )TRUE ;
+	break ;
+
+    case WM_BUTTON1UP:
+	if ( mouse_button( hwnd, mp1, mp2, 0, UP_MODIFIER ) )
+	    return ( MRESULT )TRUE ;
+	break ;
+
+    case WM_BUTTON2DOWN:
+	if ( mouse_button( hwnd, mp1, mp2, 1, DOWN_MODIFIER ) )
+	    return ( MRESULT )TRUE ;
+	break ;
+
+    case WM_BUTTON2UP:
+	if ( mouse_button( hwnd, mp1, mp2, 1, UP_MODIFIER ) )
+	    return ( MRESULT )TRUE ;
+	break ;
+
+    case WM_BUTTON3DOWN:
+	if ( mouse_button( hwnd, mp1, mp2, 2, DOWN_MODIFIER ) )
+	    return ( MRESULT )TRUE ;
+	break ;
+
+    case WM_BUTTON3UP:
+	if ( mouse_button( hwnd, mp1, mp2, 2, UP_MODIFIER ) )
+	    return ( MRESULT )TRUE ;
+	break ;
+
+    case WM_BUTTON1DBLCLK:
+    case WM_BUTTON2DBLCLK:
+    case WM_BUTTON3DBLCLK:
+	/* _uNbN̓_ECxgĈ莞ԓɂx
+	   {^_Eꂽ_Ŕs邽߁A{̂1x_E
+	   Cxg]Ă_uNbNCxg]Ă܂B
+	   ǂACfBAߌݖĂB*/
+	break ;
+
+    case WM_SIZE:
+
+	/* The size of the window has changed.  Store the new size and
+	   recreate the cursor.  The cursor must be recreated to install
+	   the new clipping rectangle.  While minimizing the window,
+	   this message is ignored. */
+
+	PmCxClient = SHORT1FROMMP( mp2 ) ;
+	PmCyClient = SHORT2FROMMP( mp2 ) ;
+	set_cursor( ) ;
+
+	/* ύXTCYMule{̂ɒm点 */
+	pme.size.header.type = PME_SIZE ;
+	pme.size.width = PmCxClient / PmCxChar ;
+	pme.size.height = PmCyClient / PmCyChar ;
+	if ( PmFunctionKeyMenu )
+	    pme.size.height -= PmFunctionRows ;
+	if ( pme.size.width  < 0 ) pme.size.width = 0 ;
+	if ( pme.size.height < 0 ) pme.size.height = 0 ;
+	PmWidth = pme.size.width ;
+	PmHeight = pme.size.height ;
+	SendEvent( &pme ) ;
+
+	/* t@NVj[TCYČvZ */
+	compute_func_menu( ) ;
+
+	/* {̓EBhEڂ̍Đݒ */
+	PecicComputeWindow( ) ;
+
+	/* ő剻Â߂break ͂AWM_MOVE@\s */
+    case WM_MOVE:
+	WinQueryWindowPos( PmHwndClient, &swp ) ;
+	ptl.x = swp.x ;
+	ptl.y = swp.y ;
+	WinMapWindowPoints( PmHwndFrame, HWND_DESKTOP, &ptl, 1 ) ;
+	PmTop = swpScreen.cy - 1 - ( ptl.y + swp.cy ) ;
+	PmLeft = ptl.x ;
+
+	/* {PecicEBhEɈړ */
+	PecicMoveWindow( ) ;
+	return 0 ;
+
+    case WM_SETFOCUS:
+
+	/* Create the cursor when receiving the input focus, destroy the
+	   cursor when loosing the input focus. */
+	if ( SHORT1FROMMP( mp2 ) )
+	    create_cursor( 0 ) ;
+	else
+	    WinDestroyCursor( hwnd ) ;
+	return 0 ;
+
+    case WM_QUERYCONVERTPOS:
+        /* {̓X|bg(m[}[h)ϊʒuPecicvZX֕Ԃ */
+	( ( PRECTL )mp1 )->xLeft   = PmCursorX ;
+	( ( PRECTL )mp1 )->yBottom = PmCursorY ;
+	( ( PRECTL )mp1 )->xRight  = 0L ;
+	( ( PRECTL )mp1 )->yTop    = 0L ;
+	return( MRFROMLONG( TRUE ) ) ;
+
+    case UWM_POPUPMENU:
+	md = ( MENUDATA * )mp2 ;
+	PmHwndPopupMenu = create_popup_menu( md->panes, md->lines,
+					      md->data, md->title_size ) ;
+	options = ( PU_MOUSEBUTTON1 | PU_MOUSEBUTTON2 | PU_MOUSEBUTTON3
+		   | PU_KEYBOARD | PU_HCONSTRAIN | PU_VCONSTRAIN ) ;
+	if ( md->button >= 1 && md->button <= 3 )
+	    for ( i = 0; i < 3; ++i )
+		if ( PmButtons[i] == md->button )
+		    switch ( i ) {
+		    case 0: options |= PU_MOUSEBUTTON1DOWN ; break ;
+		    case 1: options |= PU_MOUSEBUTTON2DOWN ; break ;
+		    case 2: options |= PU_MOUSEBUTTON3DOWN ; break ;
+		    }
+	MenuSelect = FALSE ;
+	WinPopupMenu( PmHwndFrame, hwnd, PmHwndPopupMenu,
+		      md->x, md->y, 0, options ) ;
+	return 0 ;
+    }
+    return WinDefWindowProc( hwnd, msg, mp1, mp2 ) ;
+}
+
+/********************************************************/
+/*							*/
+/* Mule{̂̏o̓f[^󂯎			*/
+/*							*/
+/********************************************************/
+void receive( void *dst, ULONG size )
+{
+    char	*d ;
+    ULONG	n ;
+
+    d = dst ;
+    while ( size != 0 ) {
+	if ( DosRead( InPipe, d, size, &n ) != 0 || n == 0 )
+	    error( "Cannot read from pipe" ) ;
+	size -= n ;
+	d += n ;
+    }
+}
+
+/********************************************************/
+/*							*/
+/*@EBhE\ʒuݒ肷			*/
+/*							*/
+/********************************************************/
+void set_pos( int left, int top )
+{
+    SWP		swp ;
+    RECTL	rcl ;
+  
+    WinQueryWindowPos( PmHwndClient, &swp ) ;
+    if ( left != DONT_MOVE ) {
+	if ( left >= 0 )
+	    swp.x = left ;
+	else
+	    swp.x = swpScreen.cx - swp.cx + left ;
+    }
+    if ( top != DONT_MOVE ) {
+	if ( top >= 0 )
+	    swp.y = swpScreen.cy - 1 - ( top + swp.cy ) ;
+	else
+	    swp.y = - top ;
+    }
+    rcl.xLeft   = swp.x ;
+    rcl.xRight  = swp.x + swp.cx ;
+    rcl.yBottom = swp.y ;
+    rcl.yTop    = swp.y + swp.cy ;
+    WinCalcFrameRect( PmHwndFrame, &rcl, FALSE ) ;
+    swp.x = rcl.xLeft ;
+    swp.y = rcl.yBottom ;
+
+    WinSetWindowPos( PmHwndFrame, HWND_TOP,
+		     swp.x, swp.y, 0, 0, SWP_MOVE ) ;
+    PmLeft = rcl.xLeft ;
+    PmTop  = rcl.yTop ;
+}
+
+/********************************************************/
+/*							*/
+/* ݂̃}EX|WVMule{̂ɑM		*/
+/*							*/
+/********************************************************/
+void get_mousepos( void )
+{
+    HWND	hwnd ;
+    POINTL	ptl ;
+    int		i ;
+    pmd_mousepos result ;
+
+    result.frame = 0 ;
+    result.x = 0 ;
+    result.y = 0 ;
+    WinQueryPointerPos( HWND_DESKTOP, &ptl ) ;
+    hwnd = WinWindowFromPoint( HWND_DESKTOP, &ptl, TRUE ) ;
+    if ( hwnd != NULLHANDLE ) {
+	WinMapWindowPoints( HWND_DESKTOP, PmHwndClient, &ptl, 1 ) ;
+	result.x = ptl.x / PmCxChar ;
+	result.y = ( PmCyClient - ptl.y ) / PmCyChar ;
+	if ( result.x < 0 ) result.x = 0 ;
+	if ( result.y < 0 ) result.y = 0 ;
+    }
+    SendOutdata( &result, sizeof( result ) ) ;
+}
+
+UCHAR *config_buffer = NULL ;
+
+/********************************************************/
+/*							*/
+/* PMMule̊g@\ꗗMule{̂ɓ]		*/
+/*							*/
+/********************************************************/
+void get_config (void)
+{
+    pmd_config		answer ;
+    UCHAR		*p ;
+    int			len, size ;
+    UCHAR		tmp[32] ;
+
+    size = 0 ;
+    config_buffer = p = MemAlloc( 80 * 20 ) ;
+    answer.count = 13 ;
+
+    len = sprintf( p+1, "          : %d ", PmWidth ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    len = sprintf( p+1, "         c : %d s", PmHeight ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    len = sprintf( p+1, "   \\Jnʒu : %d (hbg)", PmTop ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    len = sprintf( p+1, "   \\Jnʒu : %d (hbg)", PmLeft ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    len = sprintf( p+1, "       \\F : %3d %3d %3d (RGB)",
+		  ( PmCurrentColor >> 16 ) & 0xff,
+		  ( PmCurrentColor >> 8 ) & 0xff, 
+		  PmCurrentColor & 0xff ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    len = sprintf( p+1, "       wiF : %3d %3d %3d (RGB)",
+		  ( PmCurrentBackcolor >> 16 ) & 0xff,
+		  ( PmCurrentBackcolor >> 8 ) & 0xff,
+		  PmCurrentBackcolor & 0xff ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    len = sprintf( p+1, "   \\F : %3d %3d %3d (RGB)",
+		  ( PmHighlightColor >> 16 ) & 0xff,
+		  ( PmHighlightColor >> 8 ) & 0xff,
+		  PmHighlightColor & 0xff ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    len = sprintf( p+1, "   wiF : %3d %3d %3d (RGB)",
+		  ( PmHighlightBackcolor >> 16 ) & 0xff,
+		  ( PmHighlightBackcolor >> 8 ) & 0xff,
+		  PmHighlightBackcolor & 0xff ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    switch ( PmCursorType ) {
+    case CURSORTYPE_BOX:	strcpy( tmp, "box" ) ;		break ;
+    case CURSORTYPE_BAR:	strcpy( tmp, "bar" ) ;		break ;
+    case CURSORTYPE_FRAME:	strcpy( tmp, "frame" ) ;	break ;
+    case CURSORTYPE_UNDERLINE:	strcpy( tmp, "underline" ) ;	break ;
+    case CURSORTYPE_HALFTONE:	strcpy( tmp, "halftone" ) ;	break ;
+    }
+    len = sprintf( p+1, "     J[\\` : %s", tmp ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    len = sprintf( p+1, "     J[\\_ : %s",
+		  PmCursorBlink ? "yes" : "no" ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    len = sprintf( p+1, "   zbgL[z : %s",
+		  PmDisableShortcuts ? "yes" : "no" ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    len = sprintf( p+1, " }EX{^w : %c%c%c",
+	    PmButtons[0] + '0',
+	    PmButtons[1] + '0',
+	    PmButtons[2] + '0' ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    len = sprintf( p+1, "     gptHg : %d.%s",
+		  PmFont.size / 10,
+		  PmFont.name ) ;
+    *p = ( UCHAR )len++ ; size += len ; p += len ;
+
+    answer.size = size ;
+    SendOutdata( &answer, sizeof( answer ) ) ;
+    SendOutdata( config_buffer, answer.size ) ;
+    MemFree( config_buffer ) ;
+}
+
+/********************************************************/
+/*							*/
+/* Nbv{[he[^肾A{̂֓]	*/
+/*							*/
+/********************************************************/
+void get_clipboard (int get_text)
+{
+    ULONG	size, ulData ;
+    PCH		str ;
+    int		opened ;
+
+    size = 0 ;
+    opened = WinOpenClipbrd( hab ) ;
+    if ( opened ) {
+	ulData = WinQueryClipbrdData( hab, CF_TEXT ) ;
+	if ( ulData != 0 ) {
+	    str = ( PCH )ulData ;
+	    size = strlen( str ) ;
+        }
+    }
+    SendOutdata( &size, sizeof( size ) ) ;
+    if ( size != 0 && get_text )
+	SendOutdata( str, size ) ;
+    if ( opened )
+	WinCloseClipbrd( hab ) ;
+}
+
+/********************************************************/
+/*							*/
+/* Nbv{[hɃf[^Zbg			*/
+/*							*/
+/********************************************************/
+void put_clipboard (unsigned long size)
+{
+    char *buf ;
+
+    DosAllocSharedMem( ( PVOID )&buf, NULL, size + 1,
+		       PAG_COMMIT | PAG_READ | PAG_WRITE | OBJ_GIVEABLE ) ;
+    receive( buf, size ) ;
+    buf[size] = 0 ;
+    if ( WinOpenClipbrd( hab ) ) {
+	WinEmptyClipbrd( hab ) ;
+	WinSetClipbrdData( hab, ( ULONG )buf, CF_TEXT, CFI_POINTER ) ;
+	WinCloseClipbrd( hab ) ;
+    }
+}
+
+/********************************************************/
+/*							*/
+/* ̓p^[ƈvtHgԂ		*/
+/*							*/
+/********************************************************/
+int font_match (const UCHAR *pattern, const UCHAR *name)
+{
+    for (;;) {
+	switch ( *pattern ) {
+	case 0:
+	    return ( *name == 0 ) ;
+	case '?':
+	    ++pattern ;
+	    if ( *name == 0 )
+		return 0 ;
+	    ++name ;
+	    break ;
+	case '*':
+	    while ( *pattern == '*' )
+		++pattern ;
+	    if ( *pattern == 0 )
+		return 1 ;
+	    while ( *name != 0 ) {
+		if ( font_match( pattern, name ) )
+		    return 1 ;
+		++name ;
+	    }
+	    return 0 ;
+	default:
+	    if ( *pattern != *name )
+		return 0 ;
+	    ++pattern ;
+	    ++name ;
+	    break ;
+	}
+    }
+}
+
+
+/* Buffer for pm-list-fonts. */
+
+UCHAR *fontlist_buffer = NULL ;
+ULONG fontlist_size = 0 ;
+ULONG fontlist_used = 0 ;
+
+#define LISTFONT_NAME   0x01    /* Name is known */
+#define LISTFONT_SIZE   0x02    /* Size is known */
+
+/********************************************************/
+/*							*/
+/* wp^[ɈvtHgXgɉ	*/
+/*							*/
+/********************************************************/
+void list_one_font( pmd_fontlist *answer, PFONTMETRICS pfm,
+			   int size, const UCHAR *pattern, int flags )
+{
+    ULONG	len ;
+    UCHAR	*p ;
+
+    if ( fontlist_used + 256 > fontlist_size ) {
+	fontlist_size += 0x10000 ;
+	p = MemAlloc( fontlist_size ) ;
+	memcpy( p, fontlist_buffer, fontlist_used ) ;
+	MemFree( fontlist_buffer ) ;
+	fontlist_buffer = p ;
+    }
+    p = fontlist_buffer + fontlist_used ;
+    len = sprintf( p+1, "%d", ( size + 5 ) / 10 ) ;
+    len += sprintf( p+1+len, ".%s", pfm->szFacename ) ;
+    if ( font_match( pattern, p + 1 ) ) {
+	*p = ( UCHAR )len ;
+	fontlist_used += 1 + len ;
+	++answer->count ;
+    }
+}
+
+
+/********************************************************/
+/*							*/
+/* p^[ɈvSẴtHgꗗ𐶐	*/
+/*							*/
+/********************************************************/
+void fontlist( const UCHAR *pattern )
+{
+    pmd_fontlist	answer ;
+    ULONG		fonts, temp, i ;
+    PFONTMETRICS	pfm ;
+    int			size, flags ;
+    FONTSPEC		spec ;
+
+    temp = 0 ;
+    fonts = GpiQueryFonts( PmHpsClient, QF_PUBLIC | QF_PRIVATE, NULL,
+			   &temp, sizeof( FONTMETRICS ), NULL ) ;
+    pfm = MemAlloc( fonts * sizeof( FONTMETRICS ) ) ;
+    GpiQueryFonts( PmHpsClient, QF_PUBLIC | QF_PRIVATE, NULL,
+		   &fonts, sizeof( FONTMETRICS ), pfm ) ;
+    answer.count = 0 ;
+    fontlist_used = 0 ;
+    flags = 0 ;
+    if ( parse_font_spec( &spec, pattern ) ) {
+	flags |= LISTFONT_SIZE ;
+	if ( strpbrk( spec.name, "?*" ) == NULL )
+	    flags |= LISTFONT_NAME ;
+    }
+    for ( i = 0; i < fonts; ++i ) {
+	if ( !( pfm[i].fsType & FM_TYPE_FIXED ) )
+	    continue ;
+#ifndef USE_OUTLINE_FONT
+	if ( pfm[i].fsDefn & FM_DEFN_OUTLINE )
+	    continue ;
+#endif
+	if ( !( flags & LISTFONT_NAME ) ||
+	    strcmp( pfm[i].szFacename, spec.name ) == 0 ) {
+#ifdef USE_OUTLINE_FONT
+	    if ( pfm[i].fsDefn & FM_DEFN_OUTLINE )
+		list_one_font( &answer, pfm + i,
+			      0, pattern,
+			      flags ) ;
+	    else
+#endif
+		list_one_font( &answer, pfm + i,
+			      pfm[i].sNominalPointSize, pattern,
+			      flags ) ;
+	}
+    }
+    answer.size = fontlist_used ;
+    SendOutdata( &answer, sizeof( answer ) ) ;
+    SendOutdata( fontlist_buffer, answer.size ) ;
+    MemFree( pfm ) ;
+    MemFree( fontlist_buffer ) ;
+    fontlist_buffer = NULL ;
+    fontlist_size = fontlist_used = 0 ;
+}
+
+/********************************************************/
+/*							*/
+/* tHgVXeɓo^				*/
+/*							*/
+/********************************************************/
+void setfont( const UCHAR *fontname )
+{
+    PmOldFont = PmFont ;
+    parse_font_spec( &PmFont, fontname ) ;
+    set_default_font( ) ;
+    set_cursor( ) ;
+    set_size( FALSE ) ;
+    WinInvalidateRect( PmHwndClient, NULL, FALSE ) ;
+}
+
+#define isKANJI(c) \
+  ((unsigned char)(c) & 0x80 \
+   && ((unsigned char)(c) < 0xA0 || (unsigned char)(c) >= 0xE0))
+
+#define	BASESPACE	3
+
+/********************************************************/
+/*							*/
+/* t@NVj[\ʒuvZ		*/
+/*							*/
+/********************************************************/
+void compute_func_menu( void )
+{
+    int			total, onesize, spacesize ;
+    int			dispchar ;
+    int			lp ;
+    RECTL		rcl ;
+
+    /* NCAgTCYɂAœKj[ʒuvZB
+       12t@NV\sŒ[hbgł邾œK
+       ʒuɗ悤ɔB*/
+    onesize = ( PmCxClient - BASESPACE * 15 ) / 12 ;
+    spacesize = ( PmCxClient - onesize * 12 ) / 15 ;
+    total = spacesize * 15 + onesize * 12 ;
+    dispchar = onesize / PmCxChar ;
+    PmFuncMenuCharOffset.x = ( onesize - ( dispchar -1 ) * PmCxChar ) / 2 ;
+
+    /* t@NV\x[XWvZ */
+    rcl.xLeft    = spacesize + ( PmCxClient - total ) / 2 ;
+    rcl.yBottom  = PmCyChar / 3 - 1 ;
+    rcl.yTop     = ( MAKE_Y( PmHeight - 1 ) - PmCyDesc ) - PmCyChar / 3 - 1 ;
+
+    PmFuncMenuCharOffset.y = ( (rcl.yTop-rcl.yBottom + 1)
+			      -( PmCyChar * ( PmFunctionRows -1) ) ) / 2;
+
+    /* t@NVԍɔʒuvZ */
+    for ( lp = 0 ; lp < 12; ++lp ) {
+	rcl.xRight = rcl.xLeft + onesize - 1 ;
+	PmFuncMenuRect[lp] = rcl ;
+	rcl.xLeft += onesize + spacesize ;
+	if ( lp % 4 == 3 ) {
+	    rcl.xLeft += spacesize ;
+	}
+    }
+}
+
+/********************************************************/
+/*							*/
+/* t@NVj[\			*/
+/*							*/
+/********************************************************/
+void display_func_menu( void )
+{
+    int			lp, len, lp2, kanji ;
+    POINTL		ptl ;
+    RECTL		rcl ;
+
+
+    if ( !PmFunctionKeyMenu )
+	return ;
+
+    if ( PmCursorOn )
+	WinShowCursor( PmHwndClient, FALSE ) ;
+
+    rcl.xLeft =
+	rcl.yBottom = 0 ;
+    rcl.xRight = PmCxClient ;
+    rcl.yTop = MAKE_Y( PmHeight - 1 ) - PmCyDesc - 1 ;
+    WinFillRect( PmHpsClient, &rcl, 0x00bfbfbf ) ;
+    GpiSetColor( PmHpsClient, 0x007f7f7f ) ;
+    ptl.x = rcl.xLeft + 1 ;
+    ptl.y = rcl.yBottom + 1 ;
+    GpiMove( PmHpsClient, &ptl ) ;
+    ptl.y = rcl.yTop - 2 ;
+    GpiLine( PmHpsClient, &ptl ) ;
+    ptl.x = rcl.xRight - 2 ;
+    GpiLine( PmHpsClient, &ptl ) ;
+    GpiSetColor( PmHpsClient, RGB_WHITE ) ;
+    ptl.y = rcl.yBottom + 1 ;
+    GpiLine( PmHpsClient, &ptl ) ;
+    ptl.x = rcl.xLeft + 2 ;
+    GpiLine( PmHpsClient, &ptl ) ;
+
+#if 0
+    GpiSetBackColor( PmHpsClient, PmHighlightBackcolor ) ;
+#endif
+    GpiSetBackColor( PmHpsClient, 0x00bfbfbf ) ;
+
+    for ( lp = 0 ; lp < 12; ++lp ) {
+	GpiSetColor( PmHpsClient, RGB_WHITE ) ;
+	ptl.x = PmFuncMenuRect[lp].xLeft ;
+	ptl.y = PmFuncMenuRect[lp].yBottom ;
+	GpiMove( PmHpsClient, &ptl ) ;
+	ptl.y = PmFuncMenuRect[lp].yTop ;
+	GpiLine( PmHpsClient, &ptl ) ;
+	ptl.x = PmFuncMenuRect[lp].xRight ;
+	GpiLine( PmHpsClient, &ptl ) ;
+	GpiSetColor( PmHpsClient, 0x007f7f7f ) ;
+	ptl.y = PmFuncMenuRect[lp].yBottom ;
+	GpiLine( PmHpsClient, &ptl ) ;
+	ptl.x = PmFuncMenuRect[lp].xLeft + 1 ;
+	GpiLine( PmHpsClient, &ptl ) ;
+
+#if 0
+	GpiSetColor( PmHpsClient, PmHighlightColor ) ;
+#endif
+	GpiSetColor( PmHpsClient, RGB_BLACK ) ;
+
+	rcl = PmFuncMenuRect[lp] ;
+	rcl.xRight  -= PmFuncMenuCharOffset.x ;
+	rcl.yBottom += 1 ;
+	rcl.yTop    -= 1 ;
+
+	ptl.x = rcl.xLeft + PmFuncMenuCharOffset.x ;
+	ptl.y = rcl.yBottom + PmCyChar * ( PmFunctionRows - 2 )
+	    + PmFuncMenuCharOffset.y + PmCyDesc;
+
+	GpiCharStringPosAt( PmHpsClient, &ptl, &rcl,
+			   CHS_CLIP,
+			   strlen( PmFuncMenuData[lp] ),
+			   PmFuncMenuData[lp],
+			   NULL ) ;
+    }
+    if ( PmCursorOn )
+	WinShowCursor( PmHwndClient, TRUE ) ;
+}
+
+/********************************************************/
+/*							*/
+/* {MulẽCxgǂݍ			*/
+/*							*/
+/********************************************************/
+void pipe_thread( ULONG arg )
+{
+    HMQ			hmq ;
+    POINTL		ptl, aptl[3] ;
+    RECTL		rcl, rcl2 ;
+    COLOR		foreground, background;
+    pm_request		pmr ;
+    pm_event		pme ;
+    MENUDATA 		md ;
+    char		buf[512], *p ;
+    pm_popup_menu	popupmenu ;
+
+
+    hmq = WinCreateMsgQueue( hab, 0 ) ;
+    for (;;) {
+	receive( &pmr, sizeof( pmr ) ) ;
+#ifdef REC_DEBUG
+	sprintf( buf, "PMR %s", pmr_msg[pmr.header.type] ) ;
+	WinMessageBox( HWND_DESKTOP, HWND_DESKTOP, buf, "debug", 0,
+		       MB_MOVEABLE | MB_OK | MB_ICONEXCLAMATION ) ;
+#endif
+	switch ( pmr.header.type ) {
+        case PMR_DESTROY:
+	    terminating = TRUE ;
+	    WinPostMsg( PmHwndClient, WM_CLOSE, 0L, 0L ) ;
+	    DosExit( EXIT_THREAD, 0 ) ;
+
+        case PMR_CURSOR:
+	    /* Turn on or off cursor ; change cursor position. */
+
+	    PmCursorX = MAKE_X( pmr.cursor.x ) ;
+	    PmCursorY = MAKE_Y( pmr.cursor.y ) - PmCyDesc ;
+	    PmCursorOn = pmr.cursor.on ;
+
+	    if ( PmHwndClient == WinQueryFocus( HWND_DESKTOP ) ) {
+		if ( PmCursorOn )
+		    create_cursor( pmr.cursor.size ) ;
+		else
+		    WinDestroyCursor( PmHwndClient ) ;
+            }
+
+	    /* {PecicEBhEړ */
+	    PecicMoveWindow( ) ;
+	    break ;
+
+        case PMR_OUTCHARS:
+	    receive( buf, pmr.outchars.count ) ;
+	    if ( pmr.outchars.y >= PmHeight )
+		break ;
+
+	    if ( PmCursorOn )
+		WinShowCursor( PmHwndClient, FALSE ) ;
+
+	    ptl.x = MAKE_X( pmr.outchars.x ) ;
+	    ptl.y = MAKE_Y( pmr.outchars.y ) ;
+
+	    if ( pmr.outchars.highlight ) {
+		GpiSetColor( PmHpsClient, PmHighlightColor ) ;
+		GpiSetBackColor( PmHpsClient, PmHighlightBackcolor ) ;
+	    } else {
+		GpiSetColor( PmHpsClient, PmCurrentColor ) ;
+		GpiSetBackColor( PmHpsClient, PmCurrentBackcolor ) ;
+	    }
+#ifdef USE_OUTLINE_FONT
+	    if ( PmOutline ) {
+		rcl.xLeft   = ptl.x ;
+		rcl.yBottom = ptl.y - PmCyDesc ;
+		rcl.xRight  = rcl.xLeft + pmr.outchars.count * PmCxChar ;
+		rcl.yTop    = rcl.yBottom + PmCyChar - 1 ;
+		WinFillRect( PmHpsClient, &rcl, PmCurrentBackcolor ) ;
+		--rcl.xRight ; --rcl.yTop ;
+		GpiCharStringPosAt( PmHpsClient, &ptl, &rcl,
+				   CHS_CLIP,
+				   pmr.outchars.count, buf,
+				   NULL ) ;
+	    } else
+#endif
+		{
+		    GpiCharStringAt( PmHpsClient, &ptl,
+				pmr.outchars.count, buf ) ;
+		}
+
+	    if ( PmCursorOn )
+		WinShowCursor( PmHwndClient, TRUE ) ;
+	    break ;
+
+        case PMR_CLEAR:
+	    if ( PmCursorOn )
+		WinShowCursor( PmHwndClient, FALSE ) ;
+
+	    rcl.xLeft = 0 ;
+	    if ( PmFunctionKeyMenu )
+		rcl.yBottom = MAKE_Y( PmHeight - 1 ) - PmCyDesc ;
+	    else
+		rcl.yBottom = 0 ;
+	    rcl.xRight  = PmCxClient ;
+	    rcl.yTop    = PmCyClient ;
+	    WinFillRect( PmHpsClient, &rcl, PmCurrentBackcolor ) ;
+	    if ( PmCursorOn )
+		WinShowCursor( PmHwndClient, TRUE ) ;
+	    break ;
+
+        case PMR_CLREOL:
+	    if ( PmCursorOn )
+		WinShowCursor( PmHwndClient, FALSE ) ;
+
+	    rcl.xLeft = MAKE_X( pmr.clreol.x0 ) ;
+	    rcl.xRight = MAKE_X( pmr.clreol.x1 ) ;
+	    rcl.yBottom = MAKE_Y( pmr.clreol.y ) - PmCyDesc ;
+	    rcl.yTop = rcl.yBottom + PmCyChar ;
+	    WinFillRect( PmHpsClient, &rcl, PmCurrentBackcolor ) ;
+	    if ( PmCursorOn )
+		WinShowCursor( PmHwndClient, TRUE ) ;
+	    break ;
+
+        case PMR_LINES:
+	    if ( PmCursorOn )
+		WinShowCursor( PmHwndClient, FALSE ) ;
+
+	    aptl[0].x = aptl[2].x = rcl.xLeft = 0 ;
+	    aptl[1].x  = rcl.xRight = PmCxClient ;
+	    if ( pmr.lines.count > 0 ) {
+		aptl[0].y = MAKE_Y( pmr.lines.max_y ) ;
+		aptl[1].y = MAKE_Y( pmr.lines.y + pmr.lines.count ) ;
+		aptl[2].y = MAKE_Y( pmr.lines.max_y - pmr.lines.count ) ;
+		rcl.yBottom = MAKE_Y( pmr.lines.y + pmr.lines.count ) ;
+		rcl.yTop = MAKE_Y( pmr.lines.y ) ;
+            } else {
+		aptl[0].y = MAKE_Y( pmr.lines.max_y + pmr.lines.count ) ;
+		aptl[1].y = MAKE_Y( pmr.lines.y ) ;
+		aptl[2].y = MAKE_Y( pmr.lines.max_y ) ;
+		rcl.yBottom = MAKE_Y( pmr.lines.y ) ;
+		rcl.yTop = MAKE_Y( pmr.lines.max_y + pmr.lines.count ) ;
+            }{
+		int	tmp = PmCyChar - PmCyDesc ;
+		aptl[0].y += tmp ;
+		aptl[1].y += tmp ;
+		aptl[2].y += tmp ;
+		rcl.yBottom += tmp ;
+		rcl.yTop += tmp ;
+	    }
+	    GpiBitBlt( PmHpsClient, PmHpsClient,
+		      3, aptl, ROP_SRCCOPY, BBO_IGNORE ) ;
+
+	    /* Clear the lines uncovered. */
+
+	    WinFillRect( PmHpsClient, &rcl, PmCurrentBackcolor ) ;
+	    if ( PmCursorOn )
+		WinShowCursor( PmHwndClient, TRUE ) ;
+	    break ;
+
+        case PMR_BELL:
+	    if ( pmr.bell.visible ) {
+		rcl.xLeft   =
+		rcl.yBottom = 0 ;
+		rcl.xRight  = PmCxClient ;
+		rcl.yTop    = PmCyClient ;
+		WinInvertRect( PmHpsClient, &rcl ) ;
+		DosSleep( 100 ) ;
+		WinInvertRect( PmHpsClient, &rcl ) ;
+            } else
+		WinAlarm( HWND_DESKTOP, WA_WARNING ) ;
+	    break ;
+
+        case PMR_POPUPMENU:
+	    receive( &popupmenu, sizeof( popupmenu ) ) ;
+	    if ( popupmenu.size <= sizeof( buf ) )
+		p = buf ;
+	    else
+		p = MemAlloc( popupmenu.size ) ;
+	    receive( p, popupmenu.size ) ;
+	    md.panes = popupmenu.panes ;
+	    md.lines = popupmenu.lines ;
+	    md.button = popupmenu.button ;
+#ifdef POPUPMENUCHARPOS
+	    md.x = MAKE_X( popupmenu.x ) ;
+	    md.y = MAKE_Y( popupmenu.y ) ;
+#else
+	    WinQueryPointerPos( HWND_DESKTOP, &ptl ) ;
+	    WinMapWindowPoints( HWND_DESKTOP, PmHwndClient, &ptl, 1 ) ;
+	    md.x = ( int )ptl.x ;
+	    md.y = ( int )(ptl.y + cyMenu / 2 ) ;
+#endif
+	    md.data = p ;
+	    md.title_size = popupmenu.title_size ;
+	    WinSendMsg (PmHwndClient, UWM_POPUPMENU, 0L, MPFROMP( &md ) ) ;
+	    if ( p != buf )
+		MemFree( p ) ;
+	    break ;
+
+        case PMR_POPUPMENUDESTROY:
+	    {
+		int		lp ;
+
+		for ( lp = PmPopupMenuMax -1; lp >= PmPopupMenuMin; --lp ) {
+		    WinSendMsg( PmHwndPopupMenu, MM_DELETEITEM,
+			       MPFROM2SHORT( lp, TRUE ), NULL ) ;
+		}
+		for ( lp=PmPopupSubMenuMax -1; lp >= PmPopupSubMenuMin; --lp ){
+		    WinSendMsg( PmHwndPopupMenu, MM_DELETEITEM,
+			       MPFROM2SHORT( lp, TRUE ), NULL ) ;
+		}
+	    }
+
+	    MemFree( PmPopupMenuItems ) ;
+	    PmPopupMenuItems = NULL ;
+	    WinDestroyWindow( PmHwndPopupMenu ) ;
+	    PmHwndPopupMenu = NULLHANDLE ;
+	    break ;
+
+        case PMR_PASTE:
+	    get_clipboard( pmr.paste.get_text ) ;
+	    break ;
+
+        case PMR_CUT:
+	    put_clipboard( pmr.cut.size ) ;
+	    break ;
+
+        case PMR_QUITCHAR:
+	    QuitChar = pmr.quitchar.quitchar ;
+	    break ;
+
+        case PMR_TITLENAME:
+	    receive( buf, pmr.titlename.count ) ;
+	    buf[pmr.titlename.count] = 0 ;
+	    WinSetWindowText( PmHwndFrame, buf ) ;
+	    break ;
+
+        case PMR_SETSIZE:
+	    PmWidth = pmr.setsize.width ;
+	    PmHeight = pmr.setsize.height ;
+	    set_size( FALSE ) ;
+	    break ;
+
+        case PMR_SETPOS:
+	    set_pos( pmr.setpos.left, pmr.setpos.top ) ;
+	    break ;
+
+	case PMR_SETCOLOR:
+	    if ( pmr.setcolor.fore != COLOR_NONE )
+		PmCurrentColor = pmr.setcolor.fore ;
+	    if ( pmr.setcolor.back != COLOR_NONE )
+		PmCurrentBackcolor = pmr.setcolor.back ;
+	    WinInvalidateRect( PmHwndClient, NULL, FALSE ) ;
+	    break ;
+
+	case PMR_SETHICOLOR:
+	    if ( pmr.setcolor.fore != COLOR_NONE )
+		PmHighlightColor = pmr.setcolor.fore ;
+	    if ( pmr.setcolor.back != COLOR_NONE )
+		PmHighlightBackcolor = pmr.setcolor.back ;
+	    WinInvalidateRect( PmHwndClient, NULL, FALSE ) ;
+	    break ;
+
+	case PMR_CURSORTYPE:
+	    if ( pmr.cursortype.type != 0 )
+		PmCursorType = pmr.cursortype.type ;
+	    if ( pmr.cursortype.blink != 0 )
+		PmCursorBlink = ( pmr.cursortype.blink == PMR_TRUE ) ;
+	    break ;
+
+	case PMR_SHORTCUT:
+	    if ( pmr.shortcut.shortcut != 0 )
+		PmDisableShortcuts
+		    = (pmr.shortcut.shortcut == PMR_TRUE) ;
+	    break ;
+
+	case PMR_MOUSE:
+	    PmButtons[0] = CONV_BUTTON( pmr.mouse.button[0] ) ;
+	    PmButtons[1] = CONV_BUTTON( pmr.mouse.button[1] ) ;
+	    PmButtons[2] = CONV_BUTTON( pmr.mouse.button[2] ) ;
+	    break ;
+
+        case PMR_SETFONT:
+	    receive( buf, pmr.setfont.fontname_length ) ;
+	    buf[pmr.setfont.fontname_length] = 0 ;
+	    setfont( buf ) ;
+	    break ;
+
+	case PMR_FUNCMENU:
+	    if ( pmr.funcmenu.display == PMR_TRUE ) {
+		if ( PmFunctionKeyMenu )
+		    break ;
+		PmFunctionKeyMenu = TRUE ;
+		PmHeight -= PmFunctionRows ;
+		if ( PmHeight < 1 ) PmHeight = PmFunctionRows + 1 ;
+	    } else {
+		if ( !PmFunctionKeyMenu )
+		    break ;
+		PmFunctionKeyMenu = FALSE ;
+		PmHeight += PmFunctionRows ;
+	    }		
+	    pme.size.header.type = PME_SIZE ;
+	    pme.size.width = PmWidth ;
+	    pme.size.height = PmHeight ;
+	    SendEvent( &pme ) ;
+
+	    compute_func_menu( ) ;
+	    display_func_menu( ) ;
+
+	    break ;
+
+	case PMR_FUNCMENUMSG:
+	    receive( buf, pmr.funcmenumsg.funcmenu_length ) ;
+	    buf[pmr.funcmenumsg.funcmenu_length] = 0 ;
+	    {
+		int	lp = 0, rows ;
+		UCHAR	*pnt = buf;
+		UCHAR	tmpbuf[64], *ptmp ;
+
+		ptmp = tmpbuf ;
+		rows = 2 ;
+		while ( lp < 12 ) {
+		    if ( *pnt == '\r' ) {
+#ifdef MULTILINE
+			if ( ++rows > PmFunctionRows )
+			    PmFunctionRows = rows ;
+#endif
+			++pnt ;
+			continue ;
+		    }
+		    if ( *pnt == '\t' || *pnt == '\0' ) {
+			*ptmp = '\0' ;
+			MemFree( PmFuncMenuData[lp] ) ;
+			PmFuncMenuData[lp] = MemAlloc( strlen( tmpbuf ) + 1 ) ;
+			strcpy( PmFuncMenuData[lp], tmpbuf ) ;
+			++lp ;
+			++pnt ;
+			ptmp = tmpbuf ;
+			rows = 2 ;
+			continue ;
+		    }
+		    *ptmp++ = *pnt++ ;
+		}
+		compute_func_menu( ) ;
+		display_func_menu( ) ;
+	    }
+	    break ;
+
+        case PMR_FONTLIST:
+	    receive( buf, pmr.fontlist.pattern_length ) ;
+	    buf[pmr.fontlist.pattern_length] = 0 ;
+	    fontlist( buf ) ;
+	    break ;
+
+        case PMR_CONFIG:
+	    get_config( ) ;
+	    break ;
+
+        case PMR_MOUSEPOS:
+	    get_mousepos( ) ;
+	    break ;
+
+        case PMR_SUSPEND:
+	    /* PMłł݂͌悢@̂ŃTXyh͂łȂ */
+	    break ;
+
+        case PMR_PAINTEND:
+	    {
+		int	lp ;
+		for ( lp = 0; lp < PecicComputeWindow( ); ++lp )
+		    WinInvalidateRect( Pecic[lp].Client, NULL, FALSE ) ;
+	    }
+	    break ;
+        default:
+	    error( "Unknown message type" ) ;
+        }
+    }
+}
+
+/********************************************************/
+/*							*/
+/* PM Mulȅ					*/
+/*							*/
+/********************************************************/
+void initialize( void )
+{
+    int		lp, len ;
+
+    /* Obtain the height of the menu. */
+    cyMenu = WinQuerySysValue( HWND_DESKTOP, SV_CYMENU ) ;
+    cxBorder = WinQuerySysValue( HWND_DESKTOP, SV_CXBORDER ) ;
+    cyBorder = WinQuerySysValue( HWND_DESKTOP, SV_CYBORDER ) ;
+    cxSizeBorder = WinQuerySysValue( HWND_DESKTOP, SV_CXSIZEBORDER ) ;
+
+    /* Obtain the size of the screen. */
+    WinQueryWindowPos( HWND_DESKTOP, &swpScreen ) ;
+
+    /* EBhE{Rg[ݒ */
+    PmWidth = 80 ;
+    PmHeight = 25 ;
+    PmCurrentColor = RGB_BLACK ;
+    PmCurrentBackcolor = RGB_WHITE ;
+    PmHighlightColor = RGB_WHITE ;
+    PmHighlightBackcolor = RGB_BLUE ;
+    PmCursorOn = FALSE ;
+    PmCursorType = CURSORTYPE_BOX ;
+    PmCursorBlink = TRUE ;
+    PmDisableShortcuts = FALSE ;
+    PmPopupMenuItems = NULL ;
+    PmCursorX =
+    PmCursorY =
+    PmPopupMenuMin =
+    PmPopupMenuMax =
+    PmCxChar =
+    PmCyChar = 0 ;
+    PmButtons[0] = 1 ;
+    PmButtons[1] = 3 ;
+    PmButtons[2] = 2 ;
+    PmFunctionKeyMenu = FALSE ;
+    PmFunctionRows = 2 ;
+
+    for ( lp = 0; lp < 12; ++lp ) {
+	len = strlen( FuncDefMenu[lp] ) ;
+	PmFuncMenuData[lp] = MemAlloc( len + 1 ) ;
+	strcpy( PmFuncMenuData[lp], FuncDefMenu[lp] ) ;
+    }
+    *PecicText = '\0' ;
+}
+
+/********************************************************/
+/*							*/
+/* {̓EBhE𐶐			*/
+/*							*/
+/********************************************************/
+void PecicCreateWindow( void )
+{
+    ULONG	flFrameFlags = FCF_BORDER | FCF_NOBYTEALIGN ;
+    HWND	frame, client ;
+
+    frame = WinCreateStdWindow( PmHwndFrame
+			       , WS_DISABLED
+			       , &flFrameFlags
+			       , szPecicClientClass
+			       , "pecic"
+			       , 0L
+			       , 0, 0
+			       , &client
+			       ) ;
+
+    WinSetWindowPos( frame, HWND_TOP,
+		    0, 0, 0, 0,
+		    SWP_SIZE | SWP_MOVE |
+		    SWP_SHOW | SWP_ZORDER ) ;
+    Pecic[PecicWndCount].Frame = frame ;
+    Pecic[PecicWndCount].Client = client ;
+    ++PecicWndCount ;
+}
+
+/********************************************************/
+/*							*/
+/* {̓EBhEj			*/
+/*							*/
+/********************************************************/
+void PecicDestroyWindow( void )
+{
+    int		lp ;
+
+    for ( lp = 0; lp < PecicWndCount; ++lp )
+	WinDestroyWindow( Pecic[lp].Frame ) ;
+    PecicWndCount = 0 ;
+}
+
+/********************************************************/
+/*							*/
+/* {̓EBhE̕\ʒuvZ		*/
+/*							*/
+/********************************************************/
+int PecicComputeWindow( void )
+{
+    int		startx ;
+    int		wnds ;
+    int		pos, offset, len ;
+
+    /* }`EBhEbZ[W */
+    for ( pos = 0; pos < PecicWndCount; ++pos )
+	Pecic[pos].Len = -1 ;
+
+    if ( !PecicLength )
+	return 0 ;
+
+    PecicCurBase = -1 ;
+    startx = PmCursorX / PmCxChar ;
+    wnds = len = Pecic[0].Start = 0 ;
+    for ( pos = 0; pos < PecicLength -1; ) {
+	if ( isKANJI( PecicText[pos] ) ) {
+	    offset = 2 ;
+	} else
+	    offset = 1 ;
+	if ( ( startx + offset ) > PmWidth ) {
+	    /* \̈z */
+	    Pecic[wnds].Len = len ;
+	    ++wnds ;
+	    Pecic[wnds].Start = pos ;
+	    startx = len = 0 ;
+	}
+	/* ڈʒuJ[\ʒuƓꍇ̓J[\ʒuf[^ݒ */
+	if ( pos == PecicCurPos ) {
+	    PecicCurBase   = wnds ;
+	    PecicCurOffset = len ;
+	}
+	pos += offset ;
+	startx += offset ;
+	len += offset ;
+	Pecic[wnds].Len = len ;
+    }
+
+    /* J[\ŌɗLꍇ */
+    if ( PecicCurBase == -1 ) {
+	PecicCurBase   = wnds ;
+	PecicCurOffset = len ;
+    }	
+    if ( wnds + 1 > PecicWndCount ) {
+	/* ݐĂEBhEzꍇ́Az
+	   ŐB*/
+	for ( pos = PecicWndCount; pos <= wnds; ++pos )
+	    PecicCreateWindow( ) ;
+    }
+    return ( wnds + 1 ) ;
+}
+
+/********************************************************/
+/*							*/
+/* {̓EBhE			*/
+/*							*/
+/********************************************************/
+int PecicSearchWindow( HWND hwnd )
+{
+    int		lp ;
+
+    for ( lp = 0; lp < PecicWndCount; ++lp ) {
+	if ( Pecic[lp].Client == hwnd )
+	    return lp ;
+    }
+}
+
+/********************************************************/
+/*							*/
+/* {̓EBhENCAgC		*/
+/*							*/
+/********************************************************/
+MRESULT PecicClientWndProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
+{
+    HPS		hps ;
+    HDC		hdc ;
+    RECTL	rcl ;
+    POINTL	ptl ;
+    SIZEL	sizel ;
+#ifdef USE_OUTLINE_FONT
+    USHORT	size ;
+    FIXED	font_cbox ;
+    SIZEF	cbox ;
+#endif
+
+    int		wnd ;
+    PUCHAR	Text ;
+    PUCHAR	Attr ;
+    int		dsplen ;
+    USHORT	hi, low ;
+
+    switch ( msg ) {
+    case WM_CREATE:
+	hdc = WinOpenWindowDC( hwnd ) ;
+	sizel.cx = sizel.cy = 0 ;
+	hps = GpiCreatePS( hab, hdc, &sizel,
+			  PU_PELS | GPIT_MICRO | GPIA_ASSOC ) ;
+	GpiSetBackMix( hps, BM_OVERPAINT ) ;
+	GpiCreateLogColorTable( hps, LCOL_PURECOLOR, LCOLF_RGB,
+				0, 0, NULL ) ;
+
+	GpiCreateLogFont( hps, NULL, SELECT_FONT_ID, &NowFontAttrs ) ;
+	GpiSetCharSet( hps, SELECT_FONT_ID ) ;
+#ifdef USE_OUTLINE_FONT
+	if ( PmOutline ) {
+	    size = ( USHORT )( ( double )PmFont.size * ( double )cxRes
+			      / 720.0 + 0.5 ) ;
+	    font_cbox = MAKEFIXED( size, 0 ) ;
+	    cbox.cx = cbox.cy = font_cbox ;
+	    GpiSetCharBox( hps, &cbox ) ;
+	}
+#endif
+	Pecic[PecicWndCount].Ps = hps ;
+	return 0 ;
+
+    case WM_DESTROY:
+	GpiDestroyPS( Pecic[PecicSearchWindow( hwnd )].Ps ) ;
+	break ;
+
+    case WM_PAINT:
+	wnd = PecicSearchWindow( hwnd ) ;
+	hps = WinBeginPaint( hwnd, Pecic[wnd].Ps, &rcl ) ;
+	Text = &PecicText[Pecic[wnd].Start] ;
+	Attr = &PecicAttr[Pecic[wnd].Start] ;
+	dsplen = Pecic[wnd].Len ;
+	ptl.x = 0 ;
+	ptl.y = PmCyDesc ;
+	GpiMove( hps, &ptl ) ;
+	while ( dsplen ) {
+	    if ( *Attr & 1 ) {
+		GpiSetColor( hps, RGB_BLACK ) ;
+		GpiSetBackColor( hps, RGB_YELLOW );
+	    } else {
+		GpiSetColor( hps, RGB_WHITE ) ;
+		GpiSetBackColor( hps, RGB_BLUE );
+	    }
+	    if ( isKANJI( *Text ) ) {
+		GpiCharString( hps, 2L, Text ) ;
+		dsplen -= 2 ;
+		Text += 2 ;
+		Attr += 2 ;
+	    } else {
+		GpiCharString( hps, 1L, Text ) ;
+		--dsplen ;
+		++Text ;
+		++Attr ;
+	    }
+	}
+	WinEndPaint( hps ) ;
+
+	if ( PecicCurBase == wnd ) {
+	    /* J[\ʒu] */
+	    rcl.yBottom = 0L ;
+	    if ( PecicCurType )
+		rcl.yTop = PmCyChar / 2 ;
+	    else
+		rcl.yTop = PmCyChar / 4 ;
+	    rcl.xLeft  = PecicCurOffset * PmCxChar ;
+	    rcl.xRight = rcl.xLeft + PmCxChar ; 
+	    if ( isKANJI( PecicText[PecicCurPos] ) )
+		rcl.xRight += PmCxChar ;
+
+	    /* J[\Ōɂꍇ͏߂ */
+	    if ( PecicLength - 1 == PecicCurPos )
+		rcl.xLeft  -= PmCxChar / 3 ;
+	    WinInvertRect( Pecic[wnd].Ps, &rcl ) ;
+	}
+	return 0 ;
+    case WM_QUERYFOCUSCHAIN:
+	return NULL ;
+
+    case WM_SETFOCUS:
+	WinSetFocus( HWND_DESKTOP, PmHwndClient ) ;
+	break ;
+    }
+    return WinDefWindowProc( hwnd, msg, mp1, mp2 ) ;
+}
+
+/********************************************************/
+/*							*/
+/* {EBhE\ʒuJ[\ʒuvZ	*/
+/*							*/
+/********************************************************/
+void ConvPecicPos( PPOINTL ptl )
+{
+    ptl->x = PmCursorX - cxBorder ;
+    ptl->y = PmCursorY - cyBorder ;
+    WinMapWindowPoints( PmHwndClient, PmHwndFrame, ptl, 1 ) ;
+}
+
+/********************************************************/
+/*							*/
+/* {̓EBhEړ			*/
+/*							*/
+/********************************************************/
+void PecicMoveWindow( void )
+{
+    SWP		swp[32] ;
+    POINTL	ptl ;
+    int		lp ;
+
+    /* f[^̗L閳֌WȂSẴEBhEړB
+       f[^݂ȂEBhEcxUCY0ȉƂȂ莩I
+       \ƂȂB*/
+    ConvPecicPos( &ptl ) ;
+    for ( lp = 0; lp < PecicWndCount; ++lp ) {
+	swp[lp].hwnd = Pecic[lp].Frame ;
+	swp[lp].hwndInsertBehind = HWND_TOP ;
+	swp[lp].x  = ptl.x ;
+	swp[lp].y  = ptl.y ;
+	swp[lp].cx = Pecic[lp].Len * PmCxChar + cxBorder * 2 ;
+	swp[lp].cy = PmCyChar + cyBorder * 2 ;
+	swp[lp].fl = SWP_SIZE | SWP_MOVE | SWP_ZORDER ;
+	ptl.x = cxSizeBorder ;
+	ptl.y -= PmCyChar + cyBorder * 2 ;
+    }
+    WinSetMultWindowPos( hab, swp, PecicWndCount ) ;
+}
+
+/********************************************************/
+/*							*/
+/* {̓t[EBhERg[		*/
+/*							*/
+/********************************************************/
+MRESULT PecicFrameWndProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
+{
+    PPECICDATA	pPecic ;
+    POINTL	ptl ;
+    LPKKCPARAMS	kkparam ;
+    int		wnd, lp ;
+    USHORT	hi, low ;
+
+    switch (msg) {
+    case WM_SETWINDOWPARAMS:
+        pPecic = ( ( PWNDPARAMS )mp1 )->pCtlData ;
+        if ( pPecic->wpmctlflag != DBE_KSF_TEXT )
+	    return( MRFROMLONG( TRUE ) ) ;
+
+	PecicLength = pPecic->textlength ;
+	strcpy( PecicText, pPecic->lpTextString ) ;
+	strncpy( PecicAttr, pPecic->lpAttrString, PecicLength ) ;
+	PecicCurPos = pPecic->CursorPos ;
+	PecicCurType = pPecic->CursorAttr ;
+
+	wnd = PecicComputeWindow( ) ;
+
+	if ( PecicLength )
+	    WinDestroyCursor( PmHwndClient ) ;
+	else
+	    create_cursor( 0 ) ;
+
+	PecicMoveWindow( ) ;
+
+	for ( lp = 0; lp < wnd; ++lp )
+	    WinInvalidateRect( Pecic[lp].Client, NULL, FALSE ) ;
+        return( MRFROMLONG( TRUE ) ) ;
+
+    case WM_DBE_KKCPARAMS:
+	/* KKC̕\ʒuPecic̃J[\ʒű߂Ɏčs */
+	kkparam = PVOIDFROMMP( mp1 ) ;
+	ConvPecicPos( &ptl ) ;
+	ptl.x += ( PecicCurPos -1 ) * PmCxChar ;
+	((POINTL *)kkparam->lpKKCData)->x = ptl.x ;
+	((POINTL *)kkparam->lpKKCData)->y = ptl.y ;
+	break ;
+    }
+    return OrgPecicFrameWndProc( hwnd, msg, mp1, mp2 ) ;
+}
+
+/********************************************************/
+/*							*/
+/* C						*/
+/*							*/
+/********************************************************/
+int main( int argc, char *argv[] )
+{
+    ULONG	flFrameFlags ;
+    QMSG	qmsg ;
+    TID		tid ;
+    int		lp ;
+
+    /* Parse the command line. */
+
+    ++argv ;
+    --argc ;
+    if ( argc != 4 )
+	return 1 ;
+    MulePid     = atoi( *argv++ ) ;
+    InPipe      = atoi( *argv++ ) ;
+    OutPipe     = atoi( *argv++ ) ;
+    OutdataPipe = atoi( *argv ) ;
+
+    /* Initialize the Presentation Manager and create a message queue
+       for this thread, the PM thread. */
+
+    hab = WinInitialize( 0 ) ;
+    hmq = WinCreateMsgQueue( hab, 0 ) ;
+
+#ifdef DEBUGSNAP
+    if ( DebugSnapOpen( ) ) {
+	WinDestroyMsgQueue( hmq ) ;
+	WinTerminate( hab ) ;
+	return -1 ;
+    }
+#endif
+
+    initialize( ) ;
+
+    /* Register window classes. */
+
+    WinRegisterClass( hab, szClientClass, ClientWndProc,
+		      CS_SIZEREDRAW | CS_MOVENOTIFY /* | CS_SAVEBITS */
+		     , 0 ) ;
+
+    WinRegisterClass( hab, szPecicClientClass, PecicClientWndProc,
+		     CS_SIZEREDRAW | CS_SYNCPAINT
+		     , 0 ) ;
+
+    flFrameFlags = ( FCF_TITLEBAR     | FCF_SYSMENU  | FCF_ICON |
+		    FCF_SIZEBORDER    | FCF_MINMAX   |
+		    FCF_SHELLPOSITION | FCF_TASKLIST | FCF_DBE_APPSTAT ) ;
+
+    PmHwndFrame = WinCreateStdWindow( HWND_DESKTOP
+				     , 0
+				     , &flFrameFlags, szClientClass
+				     , "PM Mule (Gnu Emacs 18.59)"
+				     , 0L, 0, 1
+				     , &PmHwndClient ) ;
+    set_size( TRUE ) ;
+
+    OrgPecicFrameWndProc = WinSubclassWindow( WinWindowFromID( PmHwndFrame,
+							      FID_DBE_PECIC ),
+					     ( PFNWP )PecicFrameWndProc ) ;
+
+
+    display_func_menu( ) ;
+
+    /* EBhE܂ł̃Cxgz */
+    while( WinPeekMsg( hab, &qmsg, NULL, WM_CHAR, WM_MOUSEFIRST, PM_REMOVE ) )
+	WinDispatchMsg( hab, &qmsg ) ;
+
+    terminating = FALSE ;
+
+    DosCreateThread( &tid, pipe_thread, 0, 2, 0x8000 ) ;
+
+    while ( WinGetMsg( hab, &qmsg, 0L, 0, 0 ) )
+	WinDispatchMsg( hab, &qmsg ) ;
+
+    WinDestroyWindow( PmHwndFrame ) ;
+    WinDestroyMsgQueue( hmq ) ;
+    WinTerminate( hab ) ;
+
+    for ( lp = 0; lp < 12; ++lp )
+	MemFree( PmFuncMenuData[lp] ) ;
+
+#ifdef DEBUGSNAP
+    DebugSnapClose( ) ;
+#endif
+    return 0 ;
+}
diff -urP /mule-1.1/src/pmmule.def ./src/pmmule.def
--- /mule-1.1/src/pmmule.def
+++ ./src/pmmule.def	Thu Dec 23 19:58:56 1993
@@ -0,0 +1,21 @@
+; pmmule.def -- module definition file for pmmule
+;
+; This file is part of GNU Emacs.
+;
+; GNU Emacs is free software; you can redistribute it and/or modify
+; it under the terms of the GNU General Public License as published by
+; the Free Software Foundation; either version 1, or (at your option)
+; any later version.
+;
+; GNU Emacs is distributed in the hope that it will be useful,
+; but WITHOUT ANY WARRANTY; without even the implied warranty of
+; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+; GNU General Public License for more details.
+;
+; You should have received a copy of the GNU General Public License
+; along with GNU Emacs; see the file COPYING.  If not, write to
+; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
+
+NAME		PMMULE	WINDOWAPI
+DESCRIPTION	'Presentation Manager Interface for GNU Emacs'
+STACKSIZE	32768
diff -urP /mule-1.1/src/pmmule.h ./src/pmmule.h
--- /mule-1.1/src/pmmule.h
+++ ./src/pmmule.h	Wed Jan 26 05:18:02 1994
@@ -0,0 +1,603 @@
+/* pmemacs.h
+   Copyright (C) 1993 Osamu Sasaki
+
+This file is part of GNU Emacs.
+
+GNU Emacs is free software; you can redistribute it and/or modify
+it under the terms of the GNU General Public License as published by
+the Free Software Foundation; either version 1, or (at your option)
+any later version.
+
+GNU Emacs is distributed in the hope that it will be useful,
+but WITHOUT ANY WARRANTY; without even the implied warranty of
+MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+GNU General Public License for more details.
+
+You should have received a copy of the GNU General Public License
+along with GNU Emacs; see the file COPYING.  If not, write to
+the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
+
+/* Requests */
+
+typedef enum
+{
+    PMR_DESTROY,		/* PM Mule ICxg			*/
+    PMR_CURSOR,			/* J[\ړ & \/\		*/
+    PMR_OUTCHARS,		/* \			*/
+    PMR_CLEAR,			/* SʃNA			*/
+    PMR_CLREOL,			/* sNA			*/
+    PMR_LINES,			/* s} & s폜			*/
+    PMR_BELL,			/* x				*/
+    PMR_POPUPMENU,		/* |bvAbvj[\		*/
+    PMR_PASTE,			/* Nbv{[heLXgʏ	*/
+    PMR_CUT,			/* Nbv{[hփeLXg]	*/
+    PMR_QUITCHAR,		/* L[荞݃R[hw菈		*/
+
+    PMR_TITLENAME,		/* EBhE^Cgݒ菈		*/
+    PMR_SETSIZE,		/* EBhETCYw菈		*/
+    PMR_SETPOS,			/* EBhE\ʒuw菈		*/
+    PMR_SETCOLOR,		/* \J[w菈		*/
+    PMR_SETHICOLOR,		/* \J[w菈		*/
+    PMR_CURSORTYPE,		/* J[\^Cvw菈		*/
+    PMR_SHORTCUT,		/* PMVXeL[L/w菈	*/
+    PMR_MOUSE,			/* }EX{^ԍw菈		*/
+    PMR_SETFONT,		/* \tHgw菈			*/
+
+    PMR_FUNCMENU,		/* t@NV@\\		*/
+    PMR_FUNCMENUMSG,		/* t@NV@\\bZ[W	*/
+
+    PMR_FONTLIST,		/* VXeo^tHgꗗ\	*/
+    PMR_CONFIG,			/* EBhEݒl		*/
+    PMR_MOUSEPOS,		/* }EXʒul			*/
+
+    PMR_SUSPEND,		/* MulẽTXyh			*/
+
+    PMR_POPUPMENUDESTROY,	/* |bvAbvj[jCxg	*/
+    PMR_PAINTEND,		/* hEICxg			*/
+} pm_request_type ;
+
+typedef struct {
+    pm_request_type type ;
+} pmr_header ;
+
+typedef struct {
+    pmr_header header ;
+    short x, y, size, on ;
+} pmr_cursor ;
+
+typedef struct {
+    pmr_header header ;
+    short x, y, highlight, count  ;
+} pmr_outchars ;
+
+typedef struct {
+    pmr_header header ;
+    short x0, x1, y ;
+} pmr_clreol ;
+
+typedef struct {
+    pmr_header header ;
+    short y, max_y ;
+    short count ;                    /* Insert this many lines if positive */
+} pmr_lines ;
+
+typedef struct {
+    pmr_header header ;
+    short visible ;
+} pmr_bell ;
+
+typedef struct {
+    pmr_header header ;
+    short get_text ;
+} pmr_paste ;
+
+typedef struct {
+    pmr_header header ;
+    unsigned long size ;           /* Size of data to follow */
+} pmr_cut ;
+
+typedef struct {
+    pmr_header header ;
+    short quitchar ;                 /* The quit character */
+} pmr_quitchar ;
+
+typedef struct {
+    pmr_header header ;
+    short count ;
+} pmr_titlename ;
+
+typedef struct {
+    pmr_header header ;
+    short width, height ;
+} pmr_setsize ;
+
+typedef struct {
+    pmr_header header ;
+    short top, left ;
+} pmr_setpos ;
+
+typedef struct {
+    pmr_header header ;
+    unsigned long fore, back ;
+} pmr_setcolor ;
+
+typedef struct {
+    pmr_header header ;
+    short type ;
+    short blink ;
+} pmr_cursortype ;
+
+typedef struct {
+    pmr_header header ;
+    short shortcut ;
+} pmr_shortcut ;
+
+typedef struct {
+    pmr_header header ;
+    char button[3] ;
+} pmr_mouse ;
+
+typedef struct {
+    pmr_header header ;
+    short fontname_length ;          /* Length of string to follow */
+} pmr_setfont ;
+
+typedef struct {
+    pmr_header header ;
+    short display ;
+} pmr_funcmenu ;
+
+typedef struct {
+    pmr_header header ;
+    short funcmenu_length ;
+} pmr_funcmenumsg ;
+
+typedef struct {
+    pmr_header header ;
+    short pattern_length ;           /* Length of string to follow */
+} pmr_fontlist ;
+
+
+typedef union
+{
+    pmr_header		header ;
+    pmr_cursor		cursor ;
+    pmr_outchars	outchars ;
+    pmr_clreol		clreol ;
+    pmr_lines		lines ;
+    pmr_bell		bell ;
+#if 0
+    pmr_popupmenu popupmenu ;
+#endif
+    pmr_paste		paste ;
+    pmr_cut		cut ;
+    pmr_quitchar	quitchar ;
+    pmr_titlename	titlename ;
+    pmr_setsize		setsize ;
+    pmr_setpos		setpos ;
+    pmr_setcolor	setcolor ;
+    pmr_cursortype	cursortype ;
+    pmr_shortcut	shortcut ;
+    pmr_mouse		mouse ;
+    pmr_setfont		setfont ;
+    pmr_funcmenu	funcmenu ;
+    pmr_funcmenumsg	funcmenumsg ;
+    pmr_fontlist	fontlist ;
+} pm_request ;
+
+/* Additional data for PMR_POPUPMENU, PMR_MENUBAR and PMR_MENU. */
+
+typedef struct {
+    int panes, lines ;
+    int button ;
+    int x, y ;
+    int title_size ;               /* Length of title */
+    int size ;                     /* Size of data to follow */
+} pm_popup_menu ;
+
+typedef struct
+{
+    int lines ;
+    int size ;                     /* Length of string to follow */
+} pm_menu_pane ;
+
+typedef struct
+{
+    unsigned long item ;
+    int enable ;                   /* Menu entry enabled */
+    int size ;                     /* Length of string to follow */
+} pm_menu_line ;
+
+/* PMR_CONFIGŎgp}N	*/
+
+#define CURSORTYPE_BOX          1
+#define CURSORTYPE_BAR          2
+#define CURSORTYPE_FRAME        3
+#define CURSORTYPE_UNDERLINE    4
+#define CURSORTYPE_HALFTONE     5
+
+#define COLOR_NONE              (0xff000000)
+#define DONT_MOVE               (-999999)
+
+#define PMR_FALSE               1
+#define PMR_TRUE                2
+
+typedef struct
+{
+    int width ;
+    int height ;
+    int top ;
+    int left ;
+    int foreground_color ;
+    int background_color ;
+    int hi_foreground_color ;
+    int hi_background_color ;
+    int cursor_type ;
+    int cursor_blink ;
+    int disable_shortcuts ;
+    char buttons[3] ;
+    char font_name[100] ;
+} pm_config ;
+
+
+/* Events */
+
+typedef enum
+{
+    PME_PAINT,			/* ĕ`Cxg			*/
+    PME_KEY,			/* L[̓Cxg			*/
+    PME_BUTTON,			/* }CX{^Cxg			*/
+    PME_SIZE,			/* EBhETCYύXCxg		*/
+    PME_DEBUG,			/* fobNbZ[W\		*/
+} pm_event_type ;
+
+typedef enum
+{
+    PMK_ASCII,
+    PMK_KANJI,
+    PMK_VIRTUAL,
+#if 0
+    PMK_SYMBOL,
+#endif
+} pm_key_type ;
+
+typedef struct
+{
+    pm_event_type type ;
+} pme_header ;
+
+typedef struct
+{
+    pme_header header ;
+    int x0, x1, y0, y1 ;
+} pme_paint ;
+
+typedef struct
+{
+    pme_header header ;
+    pm_key_type type ;
+    int code ;
+} pme_key ;
+
+typedef struct
+{
+    pme_header header ;
+    int width, height ;
+} pme_size ;
+
+typedef struct
+{
+    pme_header header ;
+    int button, x, y ;
+    unsigned long timestamp ;
+} pme_button ;
+
+typedef struct
+{
+    pme_header header ;
+    int len ;
+} pme_debug ;
+
+
+typedef union
+{
+    pme_header header ;
+    pme_paint paint ;
+    pme_key key ;
+    pme_size size ;
+    pme_button button ;
+    pme_debug debug ;
+} pm_event ;
+
+/* Out-of-band data */
+
+typedef struct {
+    unsigned long frame ;
+    int x, y ;
+} pmd_mousepos ;
+
+typedef struct {
+    int size, count ;
+} pmd_fontlist ;
+
+typedef struct {
+    int size, count ;
+} pmd_config ;
+
+#if 0
+typedef struct {
+    int top, left ;
+} pmd_framepos ;
+#endif
+
+
+/************************************************************************/
+/*									*/
+/* {nr^Qp NLS CN[hݒ				*/
+/*									*/
+/************************************************************************/
+#pragma pack(1)
+
+/* KC_ flags definition of WM_CHAR */
+
+#define KC_DBE_INTERIMCHAR	KC_DBCSRSRVD2
+
+/* resource ID offset for bi-lingual system resources (menu & string) */
+
+#define RID_DBE_OFFSET		0x1000
+#define STR_DBE_OFFSET		0x1000
+
+/*
+ * definition of Virtual key values for DBCS
+ */
+#define VK_DBE_FIRST	0x080
+#define VK_DBE_LAST	0x0ff
+
+#define VK_DBE_IMEFIRST		VK_DBE_FIRST + 0x1f
+#define VK_DBE_IMELAST		VK_DBE_LAST
+
+/* for codepage 932 */
+
+#define VK_DBE_ALPHANUMERIC	0x80 /* VK_DBE_FIRST + 0x00 */
+#define VK_DBE_KATAKANA		0x81 /* VK_DBE_FIRST + 0x01 */
+#define VK_DBE_HIRAGANA		0x82 /* VK_DBE_FIRST + 0x02 */
+#define VK_DBE_SBCSCHAR		0x83 /* VK_DBE_FIRST + 0x03 */
+#define VK_DBE_DBCSCHAR		0x84 /* VK_DBE_FIRST + 0x04 */
+#define VK_DBE_SBCSDBCSCHAR	0x85 /* VK_DBE_FIRST + 0x05 */
+#define VK_DBE_ROMAN		0x86 /* VK_DBE_FIRST + 0x06 */
+
+/* for codepage 934 */
+
+#define VK_DBE_HANJA		0x87 /* VK_DBE_FIRST + 0x07 */
+#define VK_DBE_HANGEUL		0x88 /* VK_DBE_FIRST + 0x08 */
+#define VK_DBE_JAMO		0x89 /* VK_DBE_FIRST + 0x09 */
+
+/* for codepage 936 */
+
+#define VK_DBE_HANZI		0x8A /* VK_DBE_FIRST + 0x0A */
+
+/* for codepage 938 */
+
+#define VK_DBE_TSANGJYE		0x8C /* VK_DBE_FIRST + 0x0C */
+#define VK_DBE_PHONETIC		0x8D /* VK_DBE_FIRST + 0x0D */
+
+#define VK_DBE_KANJI		0xa0 /* VK_DBE_IMEFIRST + 0x00 */
+#define VK_DBE_IMEACTIVATE	0xa0 /* VK_DBE_IMEFIRST + 0x00 */
+#define VK_DBE_CONV		0xa1 /* VK_DBE_IMEFIRST + 0x01 */
+#define VK_DBE_NOCONV		0xa2 /* VK_DBE_IMEFIRST + 0x02 */
+#define VK_DBE_TANGO		0xa3 /* VK_DBE_IMEFIRST + 0x03 */
+#define VK_DBE_WORDREGISTER	0xa3 /* VK_DBE_IMEFIRST + 0x03 */
+#define VK_DBE_IMEDIALOG	0xa4 /* VK_DBE_IMEFIRST + 0x04 */
+#define VK_DBE_IME_MBSELECTED	0xa5 /* VK_DBE_IMEFIRST + 0x05 */
+#define VK_DBE_IME_LBSELECTED	0xa6 /* VK_DBE_IMEFIRST + 0x06 */
+#define VK_DBE_CODEINPUT	0xa7 /* VK_DBE_IMEFIRST + 0x07 */
+#define VK_DBE_ALLCANDIDATE	0xa8 /* VK_DBE_IMEFIRST + 0x08 */
+#define VK_DBE_PREVCANDIDATE	0xa9 /* VK_DBE_IMEFIRST + 0x09 */
+#define VK_DBE_IMEDEACTIVATE	0xaa /* VK_DBE_IMEFIRST + 0x0a */
+#define VK_DBE_IME_WORDREGISTED	0xab /* VK_DBE_IMEFIRST + 0x0b */
+#define VK_DBE_IMECONTROL	0xac /* VK_DBE_IMEFIRST + 0x0c */
+#define VK_DBE_IME_FREEPS	0xad /* VK_DBE_IMEFIRST + 0x0d */
+#define VK_DBE_IMEMODEEXIT	0xae /* VK_DBE_IMEFIRST + 0x0e */
+
+/* Window Class definitoin for DBCS */
+
+#define WC_DBE_KBDSTAT		((PSZ)0xffff0011L)
+#define WC_DBE_PECIC		((PSZ)0xffff0012L)
+#define WC_DBE_APPSTAT		((PSZ)0xffff0010L)
+
+/* Double byte character set messages */
+
+#define WM_DBCSFIRST		0x00b0
+#define WM_DBCSLAST		0x00cf
+#define WM_QUERYCONVERTPOS	0x00b0 /* WM_DBCSFIRST */
+#define WM_DBE_NOTIFYSETCP	0x00cf /* WM_DBCEFIRST+1f */
+#define WM_DBE_SETAPPLSTAT	0x00b6
+#define WM_QUERYCURRENTFONT	0x00b8
+#define WM_DBE_SHLDNOTIFYSETCP	0x00bb /* LIFEGAME */
+#define WM_DBE_KKCPARAMS	0x00bc /* KKC Parameters */
+
+/* WM_QUERYCONVERTPOS return value */
+
+#define QCP_VERTICAL		0x0002
+
+
+/* DBCS unique statndsrd Frame Create Flag */
+
+#define FCF_DBE_STATAREA	0x80000000L
+
+
+/* WM_SETWINDOWPARAM ctldata of DBCS status area */
+
+typedef struct _KEYSTSDATA {
+    unsigned long	wpmctlflag ;
+    unsigned long	textlength ;
+    unsigned char	*lpTextString ;
+    unsigned char	*lpAttrString ;
+    unsigned char	*lpRomanString ;
+} KEYSTSDATA, *PKEYSTSDATA ;
+
+typedef struct _WPMCTLPARAMS {
+    unsigned long	wpmctlflag ;
+    unsigned long	textlength ;
+    unsigned char	*lpTextString ;
+    unsigned char	*lpAttrString ;
+} WPMCTLPARAMS, *PWPMCTLPARAMS ;
+
+/* wpmctlflag value definition */
+
+#define DBE_KSF_ALPHANUMERIC		0x0001
+#define DBE_KSF_KATAKANA		0x0002
+#define DBE_KSF_HIRAGANA		0x0004
+#define DBE_KSF_CAPS			0x0008
+#define DBE_KSF_ROMAN			0x0010
+#define DBE_KSF_HANKAKU			0x0020
+#define DBE_KSF_ZENKAKU			0x0040
+#define DBE_KSF_SBCS			DBE_KSF_HANKAKU
+#define DBE_KSF_DBCS			DBE_KSF_ZENKAKU
+#define DBE_KSF_UPPER			0x0080
+#define DBE_KSF_LOWER			0x0100
+#define DBE_KSF_TEXT			0x0200
+#define DBE_KSF_NOROMAN			0x0400
+#define DBE_KSF_DISABLEONTHESPOT	0x0800
+#define DBE_KSF_ROMANTEXT		0x1000
+
+/* For Code Page 934(Korea) wpmctlflag value definition  */
+
+#define DBE_KSF_JAMO			0x0002
+#define DBE_KSF_HANGEUL			0x0004
+
+/* For Code Page 938(Taiwan) wpmctlflag value definition  */
+
+#define DBE_KSF_PHONETIC		0x0002
+#define DBE_KSF_TSANGJYE		0x0004
+
+
+/* WM_SETWINDOWPARAM ctldata of Pecic control */
+
+typedef struct _PECICDATA {
+    unsigned long	wpmctlflag ;
+    unsigned long	textlength ;
+    unsigned char	*lpTextString ;
+    unsigned char	*lpAttrString ;
+    unsigned long	CursorPos ;
+    unsigned long	CursorAttr ;
+} PECICDATA, * PPECICDATA ;
+
+/* wndparams definition of WM_DBE_APPLSTAT */
+
+#define DBE_WPM_APPLSTAT_VISIBILITY   0x0004
+
+/* ctldata of DBE_WPM_APPLSTAT_VISIBLITY */
+
+#define DBE_AS_APPLTOP		0x0001
+#define DBE_AS_KBDTOP		0x0002
+#define DBE_AS_PECICTOP		0x0004
+#define DBE_AS_APPLBOTTOM	0x0008
+
+
+/** WM_DBE_KKCPARAMS definition **/
+/* mp1(lpkkcparams) */
+
+typedef struct _KKCPARAMS {
+    unsigned long	lenKKCParams ;
+    unsigned long	fRequest ;
+    unsigned long	fKKCParams ;
+    void		*lpKKCData ;
+    unsigned long	Reserved ;
+} KKCPARAMS, * LPKKCPARAMS ;
+
+/* fRequest */
+#define DBE_KKCPARAMS_SET		0x0001
+#define DBE_KKCPARAMS_QUERY		0x0002
+
+/* fKKCParams */
+#define DBE_KKCPARAMS_PHYSICALATTRIBUTE	0x0001
+#define DBE_KKCPARAMS_PECICCURSORPOS	0x0002
+
+/* Level format for ColorLookUpTable */
+
+typedef struct _LEVEL {
+    unsigned char	attri1 ; /** 1st Attribute         **/
+    unsigned char	attri2 ; /** 2nd Attribute         **/
+} LEVEL , *PLEVEL ;
+
+/* Color Look Up Table format */
+
+typedef struct _COLORLOOKUPTBL {
+    unsigned long	nAttr ;			/** number of Attribute   **/
+    LEVEL	PhysicalLevel[32] ;	/** struct of Levels      **/
+} COLORLOOKUPTBL, * LPCOLORLOOKUPTBL ;
+
+
+/** WinDBCSIMEControl() Definition & Prototype **/
+
+#define DBE_IMCTL_QUERY		0x0001
+#define DBE_IMCTL_SET		0x0002
+
+typedef struct _IMEMODE {
+    unsigned long	lenIMEMODE ;
+    unsigned long	fIMEMode ;
+    unsigned long	hIME ;		/* query mode only valid */
+    unsigned long	hModIME ;	/* query mode only valid */
+} IMEMODE, *PIMEMODE ;
+
+/* definition of fIMEMode */
+#define DBE_IMCTL_IMEENABLE		0x0001
+#define DBE_IMCTL_IMEDISABLE		0x0002
+#define DBE_IMCTL_IMEMODE		0x0004
+#define DBE_IMCTL_NOTIMEMODE		0x0008
+#define DBE_IMCTL_INHERIT_PFRAME	0x0100
+#define DBE_IMCTL_INTERIMREQUEST	0x8000
+
+
+/* WinDBCSModeControl parameters definitions */
+/* type */
+
+#define DBE_MCTL_QUERY		0x0001
+#define DBE_MCTL_SET		0x0002
+
+/* arg */
+#define DBE_MCTL_INPUTMODEREQUEST 0x0001
+#define DBE_MCTL_JAPANREQ	0x0001 /* migration */
+
+/* parm - MCTL_JAPAN */
+#define DBE_MCTL_ALPHANUMERIC	0x0001
+#define DBE_MCTL_KATAKANA	0x0002
+#define DBE_MCTL_HIRAGANA	0x0004
+#define DBE_MCTL_SBCSCHAR	0x0008
+#define DBE_MCTL_DBCSCHAR	0x0010
+#define DBE_MCTL_ROMAN		0x0020
+#define DBE_MCTL_NOROMAN	0x0040
+
+#define DBE_MCTL_KKCREQ		0x1000
+#define DBE_MCTL_CP932REQ	0x0001
+#define DBE_MCTL_KKCENABLE	0x1000
+#define DBE_MCTL_KKCDISABLE	0x2000
+#define DBE_MCTL_HANKAKU	0x0008
+#define DBE_MCTL_ZENKAKU	0x0010
+
+/* parm - MCTL_KOREA */
+#define DBE_MCTL_JAMO		0x0002
+#define DBE_MCTL_HANGEUL	0x0004
+#define DBE_MCTL_INTERIMREQUEST 0x0080
+
+/* parm - MCTL_TCHINESE */
+#define DBE_MCTL_PHONETIC	0x0002
+#define DBE_MCTL_TSANGJYE	0x0004
+
+/* for MDI support */
+#define DBE_MCTL_INHERIT_PFRAME 0x0100
+
+/* Font Driver Description structure  */
+
+typedef struct _FD_DESC {
+    unsigned long	flType ;
+    char		xstr64Desc[64] ;
+} FD_DESC , * PFD_DESC ;
+
+/* fd_type definition */
+
+#define DBE_FD_DESC_SYSTEM	0x0001
+#define DBE_FD_DESC_PUBLIC	0x0002
+#define DBE_FD_DESC_PRIVATE	0x0004
+#pragma pack(4)
diff -urP /mule-1.1/src/pmmule.rc ./src/pmmule.rc
--- /mule-1.1/src/pmmule.rc
+++ ./src/pmmule.rc	Wed Mar 23 07:17:20 1994
@@ -0,0 +1,20 @@
+/* pmemacs.rc -- resource definition file for pmmule.exe
+   Copyright (C) 1993 O.Sasaki
+
+This file is part of GNU Emacs.
+
+GNU Emacs is free software; you can redistribute it and/or modify
+it under the terms of the GNU General Public License as published by
+the Free Software Foundation; either version 1, or (at your option)
+any later version.
+
+GNU Emacs is distributed in the hope that it will be useful,
+but WITHOUT ANY WARRANTY; without even the implied warranty of
+MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+GNU General Public License for more details.
+
+You should have received a copy of the GNU General Public License
+along with GNU Emacs; see the file COPYING.  If not, write to
+the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
+
+ICON 1 mule.ico
diff -urP /mule-1.1/src/pmterm.c ./src/pmterm.c
--- /mule-1.1/src/pmterm.c
+++ ./src/pmterm.c	Mon Mar 28 21:05:50 1994
@@ -0,0 +1,1578 @@
+/* PM Communication module for the OS/2 Presentation Manager
+   Copyright (C) 1993 Osamu Sasaki
+
+This file is part of GNU Emacs.
+
+GNU Emacs is free software; you can redistribute it and/or modify
+it under the terms of the GNU General Public License as published by
+the Free Software Foundation; either version 1, or (at your option)
+any later version.
+
+GNU Emacs is distributed in the hope that it will be useful,
+but WITHOUT ANY WARRANTY; without even the implied warranty of
+MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+GNU General Public License for more details.
+
+You should have received a copy of the GNU General Public License
+along with GNU Emacs; see the file COPYING.  If not, write to
+the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
+
+
+/*#define PMDEBUG*/
+
+#include <stdio.h>
+#include <stdlib.h>
+#include <fcntl.h>
+#include <process.h>
+#include <sys/ioctl.h>
+
+#include "config.h"
+#include "lisp.h"
+
+#include "dispextern.h"
+#include "termhooks.h"
+
+#include "termopts.h"
+#include "termchar.h"
+#include "mule.h"
+#include "codeconv.h"
+#include "window.h"
+
+#include "pmmule.h"
+
+#define min( a, b ) ( ( a ) < ( b ) ? ( a ) : ( b ) )
+#define max( a, b ) ( ( a ) > ( b ) ? ( a ) : ( b ) )
+
+extern int quit_char ;
+extern struct Lisp_Vector *MouseMap ;
+
+
+int		PmPid = -1 ;	/* PM MulẽvZXID			*/
+int		PmSessionStart = 0 ; /* PMEBhEJntO		*/
+Lisp_Object	Vos2pmterm ;	/* PMEBhE[htO		*/
+Lisp_Object	Vx_mouse_pos ;	/* }EXʒu				*/
+Lisp_Object	Vx_mouse_item ; /* }EXCxg			*/
+Lisp_Object	Vsuspend_emacs_hook ; /* PMŎs̃TXyhtbN	*/
+
+
+static int	MouseItem = 0 ;	/* PM}EXCxg			*/
+
+
+static int curs_x ;		/* XJgJ[\ʒu		*/
+static int curs_y ;		/* YJgJ[\ʒu		*/
+
+static int OutPipe ;		/* PMłɓnWo͂̃nh		*/
+static int DataPipe ;		/* PMł̃f[^̓nh		*/
+
+static int highlight ;		/* nCCg[htO		*/
+
+static int flexlines ;
+
+static int InUpdate ;		/* many of functions here may be invoked
+				 * even if no update in progress ; when
+				 * no update is in progress the action
+				 * can be slightly different */
+
+
+/************************************************************************/
+/*									*/
+/*									*/
+/*		PM MuleEBhEvZXʐMQ			*/
+/*									*/
+/*									*/
+/************************************************************************/
+
+static void pm_send( const void *src, unsigned size )
+{
+    const char	*s ;
+    int		n ;
+
+    s = src ;
+    while ( size ) {
+	n = write( OutPipe, s, size ) ;
+	if ( n == -1 || n == 0 )
+	    fatal( "Cannot send message to PM Mule." ) ;
+	size -= n ;
+	s += n ;
+    }
+}
+
+static void receive( int fd, void *dst, size_t size )
+{
+    char	*d ;
+    int		n ;
+
+    d = dst ;
+    while ( size != 0 ) {
+	n = read( fd, d, size ) ;
+	if ( n == -1 || n == 0 )
+	    fatal( "Failed to receive data from PM Mule." ) ;
+	size -= n ;
+	d += n ;
+    }
+}
+
+static void pm_receive_data( void *dst, unsigned size )
+{
+    receive( DataPipe, dst, size ) ;
+}
+
+/************************************************************************/
+/*									*/
+/*									*/
+/*		PM^[~iRg[Q				*/
+/*									*/
+/*									*/
+/************************************************************************/
+
+static void pm_display_cursor( int on )
+{
+    pm_request pmr ;
+
+    pmr.cursor.header.type = PMR_CURSOR ;
+    pmr.cursor.x = curs_x ;
+    pmr.cursor.y = curs_y ;
+#if 0
+    pmr.cursor.size = ( MTRX_LC( current_screen->contents[curs_y][curs_x] )
+		       == 0x92 && curs_x < current_screen->used[curs_y] ) ;
+#endif
+    pmr.cursor.size = (( current_screen->contents[curs_y][curs_x] & 0x920000 )
+		       == 0x920000 && curs_x < current_screen->used[curs_y] );
+    pmr.cursor.on = on ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+}
+
+static dump_chars( active_screen, numcols, tempX, tempY, tempHL )
+register struct matrix *active_screen ;
+register int numcols ;
+register int tempX, tempY, tempHL ;
+{
+    pm_request	pmr,*pmrp ;
+    char	*buf ;
+    int		lp ;
+    char	*start2 ;
+    int		len2 ;
+
+    if ( numcols <= 0 )
+	return ;
+
+    if ( numcols - 1 + tempX > screen_width )
+	numcols = screen_width - tempX + 1 ;
+
+    if ( tempX < 0 || tempX >= screen_width ||
+	tempY < 0 || tempY >= screen_height )
+	return ;
+
+    while ( tempX > 0 && active_screen->contents[tempY][tempX] & MTRX_REST )
+	--tempX, ++numcols ;
+
+    start2 = get_conversion_buffer( numcols, LINECODE ) ;
+    len2  = linecode_conversion( numcols,
+				 &active_screen->contents[tempY][tempX],
+				 start2 ) ;
+    buf = alloca( sizeof( pmr ) + len2 ) ;
+    pmrp =( pm_request * )buf ;
+    buf += sizeof( pmr ) ;
+    for ( lp = 0; lp < len2; ++lp )
+	*buf++ = *start2++ ;
+    pmrp->outchars.header.type = PMR_OUTCHARS ;
+    pmrp->outchars.x = tempX ;
+    pmrp->outchars.y = tempY ;
+    pmrp->outchars.highlight = tempHL ;
+    pmrp->outchars.count = len2 ;
+    pm_send( pmrp, sizeof( pmr ) + len2 ) ;
+}
+
+static void dump_rectangle( int left, int top, int right, int bottom )
+{
+    int		cols, rows, y, cursor_flag, i ;
+    pm_request	pmr ;
+
+    if ( right < 0 )	return ;
+    if ( bottom < 0 )	return ;
+    if ( left >= screen_width )	return ;
+    if ( top >= screen_height )	return ;
+
+    /* Clip the rectangle to what can be visible.  */
+    if ( left < 0 )	left = 0 ;
+    if ( top < 0 )	top = 0 ;
+    if ( right >= screen_width )
+	right = screen_width - 1 ;
+    if ( bottom >= screen_height )
+	bottom = screen_height - 1 ;
+
+    /* Get size in chars of the rectangle.  */
+    cols = 1 + right - left ;
+    rows = 1 + bottom - top ;
+
+    /* If rectangle has zero area, return.  */
+    if ( rows <= 0 ) return ;
+    if ( cols <= 0 ) return ;
+
+#if 0
+    cursor_flag =( f->phys_cursor_x >= 0 ) ;
+#endif
+    pm_display_cursor( 0 ) ;
+
+    for ( y = top; y <= bottom; ++y ) {
+	if ( y < 0 || y >= screen_height || 
+	    !current_screen->enable[y] ||
+	    left+1 > current_screen->used[y] )
+	    continue ;
+	dump_chars( current_screen,
+		    min( cols, current_screen->used[y]-left ),
+		    left, y, current_screen->highlight[y] ) ;
+    }
+    pmr.header.type = PMR_PAINTEND ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+
+#if 0
+    if ( cursor_flag )
+#endif
+	pm_display_cursor( 1 ) ;
+}
+
+static int PM_read_socket( int sd, char *bufp, int numchars )
+{
+    int		count = 0 ;
+    pm_event	pme ;
+    int		nread ;
+    Lisp_Object tail, frame ;
+
+    if ( numchars <= 0 )
+	abort( ) ;
+    if ( ioctl( 0, FIONREAD, &nread ) < 0 || nread < sizeof( pme ) )
+	return 0 ;
+    receive( 0, &pme, sizeof( pme ) ) ;
+
+    switch( pme.header.type ) {
+    case PME_PAINT:
+	dump_rectangle( pme.paint.x0, pme.paint.y0,
+			pme.paint.x1, pme.paint.y1 ) ;
+	break ;
+
+    case PME_KEY:
+	/* A key has been pressed. */
+
+	switch( pme.key.type ) {
+	case PMK_ASCII:
+	    *bufp = pme.key.code ;
+	    ++count ;
+	    ++bufp ;
+	    --numchars ;
+	    break ;
+	case PMK_KANJI:
+	    *bufp++ = pme.key.code % 256 ;
+	    *bufp++ = pme.key.code / 256 ;
+	    count += 2 ;
+	    numchars -= 2 ;
+	    break ;
+	case PMK_VIRTUAL:
+#ifdef PMDEBUG
+	    fprintf( stderr,"PMK_VIRTUAL:code=%04x (", pme.key.code ) ;
+
+	    switch ( pme.key.code ) {
+	    case VK_DBE_FIRST:
+		fprintf( stderr, "VK_DBE_FIRST or VK_DBE_ALPHANUMERIC)\n" ) ;
+		break ;
+	    case VK_DBE_LAST:
+		fprintf( stderr, "VK_DBE_LAST or VK_DBE_IMELAST)\n" ) ;
+		break ;
+	    case VK_DBE_IMEFIRST:
+		fprintf( stderr, "VK_DBE_IMEFIRST)\n" ) ;
+		break ;
+	    case VK_DBE_KATAKANA:
+		fprintf( stderr, "VK_DBE_KATAKANA)\n" ) ;
+		break ;
+	    case VK_DBE_HIRAGANA:
+		fprintf( stderr, "VK_DBE_HIRAGANA)\n" ) ;
+		break ;
+	    case VK_DBE_SBCSCHAR:
+		fprintf( stderr, "VK_DBE_SBCSCHAR)\n" ) ;
+		break ;
+	    case VK_DBE_DBCSCHAR:
+		fprintf( stderr, "VK_DBE_DBCSCHAR)\n" ) ;
+		break ;
+	    case VK_DBE_SBCSDBCSCHAR:
+		fprintf( stderr, "VK_DBE_SBCSDBCSCHAR)\n" ) ;
+		break ;
+	    case VK_DBE_ROMAN:
+		fprintf( stderr, "VK_DBE_ROMAN)\n" ) ;
+		break ;
+	    case VK_DBE_HANJA:
+		fprintf( stderr, "VK_DBE_HANJA)\n" ) ;
+		break ;
+	    case VK_DBE_HANGEUL:
+		fprintf( stderr, "VK_DBE_HANGEUL)\n" ) ;
+		break ;
+	    case VK_DBE_JAMO:
+		fprintf( stderr, "VK_DBE_JAMO)\n" ) ;
+		break ;
+	    case VK_DBE_HANZI:
+		fprintf( stderr, "VK_DBE_HANZI)\n" ) ;
+		break ;
+	    case VK_DBE_TSANGJYE:
+		fprintf( stderr, "VK_DBE_TSANGJYE)\n" ) ;
+		break ;
+	    case VK_DBE_PHONETIC:
+		fprintf( stderr, "VK_DBE_PHONETIC)\n" ) ;
+		break ;
+	    case VK_DBE_IMEACTIVATE:
+		fprintf( stderr, "VK_DBE_KANJI or VK_DBE_IMEACTIVATE)\n" ) ;
+		break ;
+	    case VK_DBE_CONV:
+		fprintf( stderr, "VK_DBE_CONV)\n" ) ;
+		break ;
+	    case VK_DBE_NOCONV:
+		fprintf( stderr, "VK_DBE_NOCONV)\n" ) ;
+		break ;
+	    case VK_DBE_TANGO:
+		fprintf( stderr, "VK_DBE_TANGO or VK_DBE_WORDREGISTER)\n" ) ;
+		break ;
+	    case VK_DBE_IMEDIALOG:
+		fprintf( stderr, "VK_DBE_IMEDIALOG)\n" ) ;
+		break ;
+	    case VK_DBE_IME_MBSELECTED:
+		fprintf( stderr, "VK_DBE_IME_MBSELECTED)\n" ) ;
+		break ;
+	    case VK_DBE_IME_LBSELECTED:
+		fprintf( stderr, "VK_DBE_IME_LBSELECTED)\n" ) ;
+		break ;
+	    case VK_DBE_CODEINPUT:
+		fprintf( stderr, "VK_DBE_CODEINPUT)\n" ) ;
+		break ;
+	    case VK_DBE_ALLCANDIDATE:
+		fprintf( stderr, "VK_DBE_ALLCANDIDATE)\n" ) ;
+		break ;
+	    case VK_DBE_PREVCANDIDATE:
+		fprintf( stderr, "VK_DBE_PREVCANDIDATE)\n" ) ;
+		break ;
+	    case VK_DBE_IMEDEACTIVATE:
+		fprintf( stderr, "VK_DBE_IMEDEACTIVATE)\n" ) ;
+		break ;
+	    case VK_DBE_IME_WORDREGISTED:
+		fprintf( stderr, "VK_DBE_IME_WORDREGISTED)\n" ) ;
+		break ;
+	    case VK_DBE_IMECONTROL:
+		fprintf( stderr, "VK_DBE_IMECONTROL)\n" ) ;
+		break ;
+	    case VK_DBE_IME_FREEPS:
+		fprintf( stderr, "VK_DBE_IME_FREEPS)\n" ) ;
+		break ;
+	    case VK_DBE_IMEMODEEXIT:
+		fprintf( stderr, "VK_DBE_IMEMODEEXIT)\n" ) ;
+		break ;
+	    default:
+		fprintf( stderr, "?????)\n" ) ;
+	    }
+#endif
+	    break ;
+
+	default:
+	    abort( ) ;
+	}
+	break ;
+      
+    case PME_BUTTON:
+	Vx_mouse_pos = Fcons( pme.button.x, Fcons( pme.button.y, Qnil ) ) ;
+	MouseItem = pme.button.button ;
+	*bufp++ = 'X' & 0x1f ;
+	*bufp++ = 0 ;
+	count += 2 ;
+	numchars -= 2 ;
+	break ;
+
+    case PME_SIZE:
+	/* The size of the frame has been changed by the user.  Adjust
+	   frame and set new size. */
+
+	if ( pme.size.width != screen_width
+	    || pme.size.height != screen_height )
+#if 0
+	    change_screen_size( pme.size.height, pme.size.width,
+				0, !waiting_for_input, 1 ) ;
+#else
+	    change_screen_size( pme.size.height, pme.size.width,
+				0, 0, 1 ) ;
+#endif
+	break ;
+
+    case PME_DEBUG:
+	{
+	    unsigned char	buf[200] ;
+	    pm_receive_data( buf, pme.debug.len ) ;
+	    fprintf( stderr, "%s\n", buf ) ;
+	}
+	break ;
+
+    default:
+	fatal( "Bad event type %d from PM Mule.", pme.header.type ) ;
+    }
+    return count ;
+}
+
+static PM_clear_screen( void )
+{
+    pm_request pmr ;
+
+    curs_x = 0 ;
+    curs_y = 0 ;
+    pmr.header.type = PMR_CLEAR ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+}
+
+static PM_set_terminal_modes( void )
+{
+    pm_request pmr ;
+
+    InUpdate = 0 ;
+    pmr.quitchar.header.type = PMR_QUITCHAR ;
+    pmr.quitchar.quitchar = quit_char ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+}
+
+static int PM_move_cursor( int row, int col )
+{
+    curs_x = col ;
+    curs_y = row ;
+    if ( InUpdate == 0 )
+	pm_display_cursor( 1 ) ;
+}
+
+static PM_set_terminal_window( int n )
+{
+    if ( n <= 0 || n > screen_height )
+	flexlines = screen_height ;
+    else
+	flexlines = n ;
+}
+
+static PM_ins_del_lines( int vpos, int n )
+{
+    pm_request pmr ;
+
+    if ( vpos >= flexlines )
+	return ;
+    pmr.lines.header.type = PMR_LINES ;
+    pmr.lines.y = vpos ;
+    pmr.lines.max_y = flexlines ;
+    pmr.lines.count = n ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+}
+
+static PM_update_begin( VOID )
+{
+    InUpdate = 1 ;
+    flexlines = screen_height ;
+    highlight = 0 ;
+    pm_display_cursor( 0 ) ;
+}
+
+static PM_update_end( VOID )
+{
+    InUpdate = 0 ;
+    pm_display_cursor( 1 ) ;
+}
+
+static PM_clear_end_of_line( int first_unused )
+{
+  pm_request pmr ;
+
+  if ( curs_y < 0 || curs_y >= screen_height )
+    return ;
+  if ( first_unused <= 0 )
+    return ;
+  if ( first_unused >= screen_width )
+    first_unused = screen_width ;
+
+  pmr.clreol.header.type = PMR_CLREOL ;
+  pmr.clreol.y = curs_y ;
+  pmr.clreol.x0 = curs_x ;
+  pmr.clreol.x1 = first_unused ;
+  pm_send( &pmr, sizeof( pmr ) ) ;
+}
+
+static PM_reassert_line_highlight( int new, int vpos )
+{
+    highlight = new ;
+}
+
+static PM_change_line_highlight( int new_highlight, int vpos,
+                                 int first_unused_hpos )
+{
+    highlight = new_highlight ;
+    PM_move_cursor( vpos, 0 ) ;
+    PM_clear_end_of_line( screen_width ) ;
+}
+
+static PM_ring_bell( )
+{
+    pm_request pmr ;
+
+    pmr.bell.header.type = PMR_BELL ;
+    pmr.bell.visible = visible_bell ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+}
+
+static int PM_output_chars( unsigned int *start, int len )
+{
+    pm_request	pmr,*pmrp ;
+    char	*buf ;
+    int		lp ;
+    char	*start2 = get_conversion_buffer( len, LINECODE ) ;
+    int		len2 = linecode_conversion( len, start, start2 ) ;
+
+#if 0
+    pm_display_cursor( 0 ) ;
+#endif
+
+    buf = alloca( sizeof( pmr ) + len2 ) ;
+    pmrp =( pm_request * )buf ;
+    buf += sizeof( pmr ) ;
+    memcpy( buf, start2, len2 ) ;
+    pmrp->outchars.header.type = PMR_OUTCHARS ;
+    pmrp->outchars.x = curs_x ;
+    pmrp->outchars.y = curs_y ;
+    pmrp->outchars.highlight = highlight ;
+    pmrp->outchars.count = len2 ;
+    pm_send( pmrp, sizeof( pmr ) + len2 ) ;
+    if ( !InUpdate )
+	PM_move_cursor( curs_y, curs_x+len2 ) ;
+}
+
+void os2pm_term_init( void )
+{
+    int			i, in_pipe[2], out_pipe[2], data_pipe[2] ;
+    char		arg1[12], arg2[12], arg3[12], arg4[12] ;
+    pm_request		pmr ;
+    extern Lisp_Object	Vkill_emacs_hook ;
+    Lisp_Object		tmp ;
+
+    for ( i = 0; i < 64; ++i )
+	fcntl( i, F_SETFD, 1 ) ;
+
+    sprintf( arg1, "%d", getpid( ) ) ;
+
+    if ( pipe( out_pipe ) != 0 )
+	fatal( "Cannot open pipe for PM Mule." ) ;
+    fcntl( out_pipe[1], F_SETFD, 1 ) ; /* Don't pass write end to child */
+    OutPipe = out_pipe[1] ;
+    setmode( OutPipe, O_BINARY ) ;
+    sprintf( arg2, "%d", out_pipe[0] ) ;
+
+    if ( pipe( in_pipe ) != 0 )
+	fatal( "Cannot open pipe for PM Mule." ) ;
+    dup2( in_pipe[0], 0 ) ;         /* Replace stdin with pipe */
+    close( in_pipe[0] ) ;
+    fcntl( 0, F_SETFD, 1 ) ;        /* Don't pass read end to child */
+    setmode( 0, O_BINARY ) ;
+    sprintf( arg3, "%d", in_pipe[1] ) ;
+
+    if ( pipe( data_pipe ) != 0 )
+	fatal( "Cannot open pipe for PM Mule." ) ;
+    DataPipe = data_pipe[0] ;
+    fcntl( DataPipe, F_SETFD, 1 ) ; /* Don't pass read end to child */
+    setmode( DataPipe, O_BINARY ) ;
+    sprintf( arg4, "%d", data_pipe[1] ) ;
+
+    PmPid = spawnlp( P_SESSION | P_FOREGROUND,
+		      "pmmule.exe", "pmmule.exe",
+		      arg1, arg2, arg3, arg4, 0 ) ;
+
+    if ( PmPid == -1 )
+	fatal( "Cannot start PM Mule." ) ;
+
+    close( out_pipe[0] ) ;
+    close( in_pipe[1] ) ;
+    close( data_pipe[1] ) ;
+    PmSessionStart = 1 ;
+
+    clear_screen_hook		 = PM_clear_screen ;
+    clear_end_of_line_hook	 = PM_clear_end_of_line ;
+    ins_del_lines_hook		 = PM_ins_del_lines ;
+    set_terminal_window_hook	 = PM_set_terminal_window ;
+    change_line_highlight_hook	 = PM_change_line_highlight ;
+    reassert_line_highlight_hook = PM_reassert_line_highlight ;
+    ring_bell_hook		 = PM_ring_bell ;
+    set_terminal_modes_hook	 = PM_set_terminal_modes ;
+    update_begin_hook		 = PM_update_begin ;
+    update_end_hook		 = PM_update_end ;
+    move_cursor_hook		 = PM_move_cursor ;
+    read_socket_hook		 = PM_read_socket ;
+    output_chars_hook		 = PM_output_chars ;
+
+    visible_bell = 1;
+    scroll_region_ok = 0 ;		/* we won't scroll partial frames */
+    char_ins_del_ok = 0 ;		/* just as fast to write the line */
+    line_ins_del_ok = 1 ;		/* use GpiBitBlt */
+    fast_clear_end_of_line = 1 ;	/* PM does this well */
+    memory_below_screen = 0 ;		/* we don't remember what scrolls 
+					   off the bottom */
+    dont_calculate_costs = 1 ;
+
+    baud_rate = 38400 ;
+
+    screen_width = 80 ;
+    screen_height = 25 ;
+
+    /* ItbNZbg */
+    Vkill_emacs_hook = intern( "pm-kill-emacs" ) ;
+
+    /* TXyhtbNZbg */
+    Vsuspend_emacs_hook = intern( "suspend-hook" ) ;
+    XSYMBOL( Vsuspend_emacs_hook )->value = intern( "pm-suspend" ) ;
+}
+
+
+/************************************************************************/
+/************************************************************************/
+/************************************************************************/
+/************************************************************************/
+
+static void check_pmterm( )
+{
+  if ( NULL( Vos2pmterm ) )
+    error( "Terminal does not understand PM protocol." ) ;
+}
+
+
+/************************************************************************/
+/*									*/
+/*									*/
+/*		}EXCxgQ					*/
+/*									*/
+/*									*/
+/************************************************************************/
+
+DEFUN( "x-mouse-events", Fx_mouse_events, Sx_mouse_events, 0, 0, 0,
+  "Return number of pending mouse events from PM window system." )
+ ( )
+{
+    register Lisp_Object tem ;
+
+    check_pmterm( ) ;
+    if ( MouseItem )
+	XSET( tem, Lisp_Int, 1 ) ;
+    else
+	XSET( tem, Lisp_Int, 0 ) ;
+    return tem ;
+}
+
+DEFUN( "x-proc-mouse-event", Fx_proc_mouse_event, Sx_proc_mouse_event,
+  0, 0, 0,
+  "Pulls a mouse event out of the mouse event buffer and dispatches\n\
+the appropriate function to act upon this event." )
+ ( )
+{
+    register Lisp_Object Mouse_Cmd, ret ;
+
+    check_pmterm( ) ;
+    Vx_mouse_item = make_number( MouseItem ) ;
+    Mouse_Cmd = get_keyelt( access_keymap( MouseMap, MouseItem ) ) ;
+    if ( NULL( Mouse_Cmd ) ) {
+	Vx_mouse_pos = Qnil ;
+	ret = Qnil ;
+    } else {
+	ret = call1( Mouse_Cmd, Vx_mouse_pos ) ;
+    }
+    MouseItem = 0 ;
+    return ret ;
+}
+
+DEFUN( "x-get-mouse-p", Fx_get_mouse_p, Sx_get_mouse_p,
+       0, 0, 0,
+       "Return the current mouse position." )
+( )
+{
+    pmd_mousepos result ;
+    pm_request pmr ;
+
+    pmr.header.type = PMR_MOUSEPOS ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    pm_receive_data( &result, sizeof( result ) ) ;
+    return( Fcons( result.x, Fcons( result.y, Qnil ) ) ) ;
+}
+
+DEFUN( "coordinates-in-window-p", Fcoordinates_in_window_p,
+  Scoordinates_in_window_p, 2, 2, 0,
+  "Return non-nil if POSITIONS( a list,( SCREEN-X SCREEN-Y ) ) is in WINDOW.\n\
+Returned value is list of positions expressed\n\
+relative to window upper left corner." )
+ ( coordinate, window )
+     register Lisp_Object coordinate, window ;
+{
+    register Lisp_Object xcoord, ycoord ;
+	
+    if ( !CONSP( coordinate ) )
+	wrong_type_argument( Qlistp, coordinate ) ;
+    CHECK_WINDOW( window, 2 ) ;
+    xcoord = Fcar( coordinate ) ;
+    ycoord = Fcar( Fcdr( coordinate ) ) ;
+    CHECK_NUMBER( xcoord, 0 ) ;
+    CHECK_NUMBER( ycoord, 1 ) ;
+    if ( ( XINT( xcoord ) < XINT( XWINDOW( window )->left ) ) ||
+	( XINT( xcoord ) >=( XINT( XWINDOW( window )->left ) +
+			   XINT( XWINDOW( window )->width ) ) ) )
+	{
+	    return Qnil ;
+	} 
+    XFASTINT( xcoord ) -= XFASTINT( XWINDOW( window )->left ) ;
+    if ( XINT( ycoord ) ==( screen_height - 1 ) )
+	return Qnil ;
+    if ( ( XINT( ycoord ) < XINT( XWINDOW( window )->top ) ) ||
+	( XINT( ycoord ) >=( XINT( XWINDOW( window )->top ) +
+			   XINT( XWINDOW( window )->height ) ) - 1 ) )
+	{
+	    return Qnil ;
+	}
+    XFASTINT( ycoord ) -= XFASTINT( XWINDOW( window )->top ) ;
+    return Fcons( xcoord, Fcons( ycoord, Qnil ) ) ;
+}
+
+
+/************************************************************************/
+/*									*/
+/*									*/
+/*		|bvAbvj[Q				*/
+/*									*/
+/*									*/
+/************************************************************************/
+
+#define NUL 0
+
+Lisp_Object PmPopupMenu( x, y, line_list, pane_list,
+			 line_cnt, pane_cnt, item_list, title, error )
+int		x, y ;
+char		**line_list[] ;	/* list of strings for items */
+char		*pane_list[] ;	/* list of pane titles */
+char		*title ;
+int		pane_cnt ;	/* total number of panes */
+Lisp_Object	*item_list[] ;	/* All items */
+int		line_cnt[] ;	/* Lines in each pane */
+char		**error ;	/* Error returned */
+{
+    int last, panes, selidx, lpane, status ;
+    int lines, sofar ;
+    int total_size ;
+    Lisp_Object entry ;
+    pm_request pmr ;
+    pm_popup_menu popupmenu ;
+    pm_menu_pane pmp ;
+    pm_menu_line pml ;
+    char *buf, *p ;
+
+    *error =( char * ) 0 ;		/* Initialize error pointer to null */
+
+    if ( title == 0 )
+	title = "untitled" ;
+
+    total_size = strlen( title ) ;
+    for ( panes = 0, lines = 0; panes < pane_cnt;
+	  lines += line_cnt[panes], ++panes ) {
+	total_size += sizeof( pmp ) + strlen( pane_list[panes] ) ;
+	for ( selidx = 0; selidx < line_cnt[panes]; ++selidx )
+	    total_size += sizeof( pml ) + strlen( line_list[panes][selidx] ) ;
+    }
+
+    buf = p = alloca( total_size ) ;
+
+    pmr.header.type = PMR_POPUPMENU ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    popupmenu.panes = pane_cnt ;
+    popupmenu.lines = lines ;
+    popupmenu.button =( MouseItem & 3 ) ;
+    popupmenu.x = x ;
+    popupmenu.y = y ;
+    popupmenu.title_size = strlen( title ) ;
+    popupmenu.size = total_size ;
+    pm_send( &popupmenu, sizeof( popupmenu ) ) ;
+    strcpy( p, title ) ; p += strlen( title ) ;
+
+    for ( panes = 0, sofar = 0; panes < pane_cnt;
+	  sofar += line_cnt[panes], ++panes ) {
+	pmp.lines = line_cnt[panes] ;
+	pmp.size = strlen( pane_list[panes] ) ;
+	memcpy( p, &pmp, sizeof( pmp ) ) ; p += sizeof( pmp ) ;
+	strcpy( p, pane_list[panes] ) ; p += strlen( pane_list[panes] ) ;
+	for ( selidx = 0; selidx < line_cnt[panes]; ++selidx ) {
+	    pml.item =( unsigned long )( ( panes << 16 ) |( selidx + 1 ) ) ;
+	    pml.enable = 1 ;
+	    pml.size = strlen( line_list[panes][selidx] ) ;
+	    memcpy( p, &pml, sizeof( pml ) ) ; p += sizeof( pml ) ;
+	    strcpy( p, line_list[panes][selidx] ) ;
+	    p += strlen( line_list[panes][selidx] ) ;
+	}
+    }
+    pm_send( buf, total_size ) ;
+
+    pm_receive_data( &entry, sizeof( entry ) ) ;
+    if ( entry == 0 )
+	entry = Qnil ;
+    else {
+	panes = entry >> 16 ;
+	selidx =( entry & 0xffff ) - 1 ;
+	entry = item_list[panes][selidx] ;
+    }
+    pmr.header.type = PMR_POPUPMENUDESTROY ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return( entry ) ;
+}
+
+list_of_panes( vector, panes, names, items, menu )
+Lisp_Object	***vector ;	/* RETURN all menu objects */
+char		***panes ;	/* RETURN pane names */
+char		****names ;	/* RETURN all line names */
+int		**items ;	/* RETURN number of items per pane */
+Lisp_Object	menu ;
+{
+    Lisp_Object tail, item, item1 ;
+    int i, len ;
+    coding_type code ;
+  
+    CODE_TYPE_SET( &code, SJIS ) ;
+    CODE_CNTL( &code ) |= CC_END ;
+
+    if ( XTYPE( menu ) != Lisp_Cons )
+	menu = wrong_type_argument( Qlistp, menu ) ;
+  
+    i= XFASTINT( Flength( menu,1 ) ) ;
+
+    *vector =( Lisp_Object ** ) malloc( i * sizeof( Lisp_Object * ) ) ;
+    *panes =( char ** ) malloc( i * sizeof( char * ) ) ;
+    *items =( int * ) malloc( i * sizeof( int ) ) ;
+    *names =( char *** ) malloc( i * sizeof( char ** ) ) ;
+
+    for ( i = 0, tail = menu; !NULL( tail ); tail = Fcdr( tail ), ++i ) {
+	item = Fcdr( Fcar( tail ) ) ;
+	if ( XTYPE( item ) != Lisp_Cons )
+	   ( void ) wrong_type_argument( Qlistp, item ) ;
+	item1 = Fcar( Fcar( tail ) ) ;
+	CHECK_STRING( item1, 1 ) ;
+	len = XSTRING( item1 )->size + 1 ;
+	( *panes )[i] =( unsigned char * ) malloc( CONV_BUF_SIZE( len, SJIS ) ) ;
+	len = decode( &code,
+		    ( char * ) XSTRING( item1 )->data,
+		    ( *panes )[i],
+		     len ) ;
+	( *items )[i] = list_of_items( ( *vector )+i,( *names )+i, item ) ;
+    }
+    return i ;
+}
+
+list_of_items( vector,names,pane )  /* get list from emacs and put to vector */
+Lisp_Object	**vector ;	/* RETURN menu "objects" */
+char		***names ;	/* RETURN line names */
+Lisp_Object	pane ;
+{
+    Lisp_Object tail, item, item1 ;
+    int i, len ;
+    coding_type code ;
+
+    CODE_TYPE_SET( &code, SJIS ) ;
+    CODE_CNTL( &code ) |= CC_END ;
+
+    if ( XTYPE( pane ) != Lisp_Cons )
+	pane = wrong_type_argument( Qlistp, pane ) ;
+  
+    i= XFASTINT( Flength( pane,1 ) ) ;
+
+    *vector =( Lisp_Object * ) malloc( i * sizeof( Lisp_Object ) ) ;
+    *names =( char ** ) malloc( i * sizeof( char * ) ) ;
+
+    for ( i = 0, tail = pane; !NULL( tail ); tail = Fcdr( tail ), ++i ) {
+	item = Fcar( tail ) ;
+	if ( XTYPE( item ) != Lisp_Cons )
+	   ( void ) wrong_type_argument( Qlistp, item ) ;
+	( *vector )[i] =  Fcdr( item ) ;
+	item1 = Fcar( item ) ;
+	CHECK_STRING( item1, 1 ) ;
+	len = XSTRING( item1 )->size + 1 ;
+	( *names )[i] =( char * ) malloc( CONV_BUF_SIZE( len, SJIS ) ) ;
+	len = decode( &code,
+		    ( char * )XSTRING( item1 )->data,
+		    ( *names )[i],
+		     len ) ;
+    }
+    return i ;
+}
+
+DEFUN( "x-popup-menu",Fx_popup_menu, Sx_popup_menu, 1, 2, 0,
+       "Interface to XMenu library ; permits creation and use of\n\
+deck-of-cards pop-up menus.\n\
+\n\
+ARG is a position specification ; it is a list of( Xoffset, Yoffset )\n\
+from the top-left corner of the editor window.  Note that this offset\n\
+is relative to the center of the first line in the first pane of the\n\
+menu, not the top left of the menu as a whole.\n\
+\n\
+MENU is a specifier for a menu.  It is a list of the form\n\
+( title pane1 pane2... ), and each pane is a list of form\n\
+( title( line item )... ).  Each line should be a string, and item should\n\
+be the return value for that line( i. e. if it is selected." )
+      ( arg,menu )
+     Lisp_Object arg,menu ;
+{
+    int		number_of_panes ;
+    Lisp_Object	XMenu_return ;
+    int		XMenu_xpos,XMenu_ypos ;
+    char	**menus ;
+    char	***names ;
+    Lisp_Object	**obj_list ;
+    int		*items ;
+    char	*title ;
+    char	*error_name ;
+    Lisp_Object	ltitle, selection ;
+    int		i, j ;
+    coding_type code ;
+
+    check_pmterm( ) ;
+    if ( Vx_mouse_pos != Qnil ) {
+	XMenu_xpos = Fcar( Vx_mouse_pos ) ;
+	XMenu_ypos = Fcar( Fcdr( Vx_mouse_pos ) ) ;
+    } else {
+	XMenu_xpos = 0 ;
+	XMenu_ypos = 0 ;
+    }
+
+    CODE_TYPE_SET( &code, SJIS ) ;
+    CODE_CNTL( &code ) |= CC_END ;
+
+    ltitle = Fcar( menu ) ;
+    CHECK_STRING( ltitle,1 ) ;
+
+    i = strlen( ( char * )XSTRING( ltitle )->data ) + 1 ;
+    title =( char * ) malloc( CONV_BUF_SIZE( i, SJIS ) ) ;
+    i = decode( &code,( char * )XSTRING( ltitle )->data, title, i ) ;
+
+    number_of_panes=list_of_panes( &obj_list, &menus, &names, &items,
+				  Fcdr( menu ) ) ;
+
+#ifdef PMDEBUG
+    fprintf( stderr,"Title= \"%s\"\n", title ) ;
+    fprintf( stderr,"Panes= %d\n", number_of_panes ) ;
+    for ( i=0; i < number_of_panes; ++i ) {
+	fprintf( stderr,"Pane %d lines %d title \"%s\"\n",
+		 i, items[i], menus[i] ) ;
+	for ( j = 0; j < items[i]; ++j ) {
+	    fprintf( stderr,"    Item %d \"%s\"\n", j, names[i][j] ) ;
+	}
+    }
+#endif
+    selection = PmPopupMenu( XMenu_xpos, XMenu_ypos, names, menus,
+			     items, number_of_panes, obj_list, title,
+			     &error_name ) ;
+#ifdef PMDEBUG
+    fprintf( stderr,"selection = %x\n",selection ) ;
+#endif
+    if ( selection != NUL ) {
+	/* selected something */
+	XMenu_return = selection ;
+    } else {
+	/* nothing selected */
+	XMenu_return = Qnil ;
+    }
+    /* now free up the strings */
+    for ( i = 0; i < number_of_panes; ++i ) {
+	free( menus[i] ) ;
+	for ( j = 0; j < items[i]; ++j )
+	    free( names[i][j] ) ;
+	free( names[i] ) ;
+	free( obj_list[i] ) ;
+    }
+    free( menus ) ;
+    free( obj_list ) ;
+    free( names ) ;
+    free( items ) ;
+    free( title ) ;
+    if ( error_name ) error( error_name ) ;
+    return XMenu_return ;
+}
+
+
+/************************************************************************/
+/*									*/
+/*									*/
+/*		Nbv{[hQ					*/
+/*									*/
+/*									*/
+/************************************************************************/
+
+DEFUN( "x-store-cut-buffer", Fx_store_cut_buffer, Sx_store_cut_buffer,
+  1, 1, 0,
+  "Store contents of STRING into the clipboard of the PM window system." )
+ ( string )
+     Lisp_Object string ;
+{
+    pm_request	pmr ;
+    int		len ;
+    char	*buf ;
+    coding_type	code ;
+
+    CHECK_STRING( string, 0 ) ;
+    CODE_TYPE_SET( &code, SJIS ) ;
+    CODE_CNTL( &code ) |= CC_END ;
+
+    len = XSTRING( string )->size + 1 ;
+    buf = ( char * ) alloca( CONV_BUF_SIZE( len, SJIS ) ) ;
+    len = decode( &code, ( char * )XSTRING( string )->data, buf , len ) ;
+    pmr.cut.header.type = PMR_CUT ;
+    pmr.cut.size = len ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    pm_send( buf, len ) ;
+    return Qnil ;
+}
+
+DEFUN( "x-get-cut-buffer", Fx_get_cut_buffer, Sx_get_cut_buffer, 0, 0, 0,
+  "Return contents of clipboard of the PM window system, as a string." )
+ ( )
+{
+    pm_request	pmr ;
+    int		size ;
+    char	*buf, *sendbuf ;
+    coding_type	code ;
+    Lisp_Object	dummy ;
+
+    pmr.paste.header.type = PMR_PASTE ;
+    pmr.paste.get_text = 1 ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    pm_receive_data( &size, sizeof( size ) ) ;
+    buf = alloca( size ) ;
+    pm_receive_data( buf, size ) ;
+    CODE_TYPE_SET( &code, SJIS ) ;
+    CODE_CHAR_SET( &code, 0 ) ;
+    CODE_FORM( &code ) = CODE_EOL_CRLF ;
+    CODE_CNTL( &code ) |= CC_END ;
+    sendbuf = ( char * ) alloca( CONV_BUF_SIZE( size, ITNCODE ) ) ;
+    size = encode( &code, buf, sendbuf, size, &dummy) ;
+    return make_string( sendbuf, size ) ;
+}
+
+
+/************************************************************************/
+/*									*/
+/*									*/
+/*		olłlptbNQ				*/
+/*									*/
+/*									*/
+/************************************************************************/
+
+DEFUN( "pm-kill-emacs", Fpm_kill_emacs, Spm_kill_emacs, 0, 0, 0,
+  "Kill PM Mule process and pipe handle closed." )
+ ( )
+{
+    pm_request pmr ;
+
+    pmr.header.type = PMR_DESTROY ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    PmSessionStart = 0 ;
+    close( OutPipe ) ;
+    close( DataPipe ) ;
+    close( 0 ) ;
+}
+
+DEFUN( "pm-suspend", Fpm_suspend, Spm_suspend, 0, 0, 0,
+  "Suspend PM window system." )
+ ( )
+{
+    pm_request pmr ;
+
+    /* ݎ邢@ĂȂǁA芸A
+       Cxg͑Ă */
+    pmr.header.type = PMR_SUSPEND ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    message1( "Suspending an Mule running under PM isn't a good idea" ) ;
+    return Qt ;
+}
+
+/************************************************************************/
+/*									*/
+/*									*/
+/*		tHg֘AQ					*/
+/*									*/
+/*									*/
+/************************************************************************/
+
+DEFUN( "pm-list-fonts", Fpm_list_fonts, Spm_list_fonts, 1, 1, 0,
+       "Return a list of the names of available fonts matching PATTERN.\n\
+\n\
+PATTERN is a string, perhaps with wildcard characters ;\n\
+  the * character matches any substring, and\n\
+  the ? character matches any single character.\n\
+  PATTERN is case-insensitive.\n\
+\n\
+The return value is a list of strings, suitable as arguments to\n\
+pm-set-font.\n\
+\n\
+The list does not include fonts Emacs can't use( i.e.  proportional\n\
+fonts ), even if they match PATTERN." )
+   ( pattern )
+    Lisp_Object pattern ;
+{
+    pm_request		pmr ;
+    pmd_fontlist	answer ;
+    unsigned char	*buf ;
+    Lisp_Object		*list ;
+    int			lp, len ;
+
+    check_pmterm( ) ;
+    len = XSTRING( pattern )->size ;
+    if ( len > 511 ) len = 511 ;
+    pmr.fontlist.header.type = PMR_FONTLIST ;
+    pmr.fontlist.pattern_length = len ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    pm_send( XSTRING( pattern )->data, len ) ;
+    pm_receive_data( &answer, sizeof( answer ) ) ;
+    buf = alloca( answer.size ) ;
+    pm_receive_data( buf, answer.size ) ;
+    list = alloca( answer.count * sizeof( Lisp_Object ) ) ;
+    for ( lp = 0; lp < answer.count; ++lp ) {
+	len = *buf++ ;
+	list[lp] = make_string( buf, len ) ;
+	buf += len ;
+    }
+    return Flist( lp, list ) ;
+}
+
+DEFUN( "pm-set-font", Fpm_set_font, Spm_set_font, 1, 1, "sFont Name: ",
+      "At initialization sets the font to be used for the PM window." )
+   ( fontname )
+    Lisp_Object fontname ;
+{
+    pm_request pmr ;
+    pmd_fontlist answer ;
+    unsigned char *buf, *p ;
+    Lisp_Object *list ;
+    int i, len, n, count ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( fontname, 0 ) ;
+    len = XSTRING( fontname )->size ;
+    if ( len > 511 ) len = 511 ;
+
+    pmr.setfont.header.type = PMR_SETFONT ;
+    pmr.setfont.fontname_length = len ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    pm_send( XSTRING( fontname )->data, len ) ;
+    return Qt ;
+}
+
+
+/************************************************************************/
+/*									*/
+/*									*/
+/*		t[Rg[ݒ菈Q				*/
+/*									*/
+/*									*/
+/************************************************************************/
+
+static int ConvertColor( Lisp_Object dat )
+{
+    char	*col ;
+    int		red, blue, green ;
+
+    col =( char * ) alloca( XSTRING( dat )->size + 1 ) ;
+    bcopy( XSTRING( dat )->data, col, XSTRING( dat )->size + 1 ) ;
+    col[XSTRING( dat )->size] = 0 ;
+    sscanf( col, "%d %d %d", &red, &green, &blue ) ;
+    return ( ( red << 16 ) | ( green << 8 ) | blue ) ;
+}
+
+DEFUN( "pm-set-foreground-color", Fpm_set_foreground_color,
+       Spm_set_foreground_color, 1, 1, "sSet foregroud color: ",
+       "Set foreground ( text ) color to COLOR." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg,1 ) ;
+    pmr.setcolor.header.type    = PMR_SETCOLOR ;
+    pmr.setcolor.fore = ConvertColor( arg ) ;
+    pmr.setcolor.back = COLOR_NONE ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return Qt ;
+}
+
+DEFUN( "pm-set-background-color", Fpm_set_background_color,
+       Spm_set_background_color, 1, 1, "sSet background color: ",
+       "Set background ( text ) color to COLOR." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg,1 ) ;
+    pmr.setcolor.header.type = PMR_SETCOLOR ;
+    pmr.setcolor.fore = COLOR_NONE ;
+    pmr.setcolor.back = ConvertColor( arg ) ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return Qt ;
+}
+
+DEFUN( "pm-set-highlight-foreground-color", Fpm_set_highlight_foreground_color,
+       Spm_set_highlight_foreground_color, 1, 1,
+      "sSet highlight foregroud color: ",
+       "Set foreground ( highlight text ) color to COLOR." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg,1 ) ;
+    pmr.setcolor.header.type    = PMR_SETHICOLOR ;
+    pmr.setcolor.fore = ConvertColor( arg ) ;
+    pmr.setcolor.back = COLOR_NONE ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return Qt ;
+}
+
+DEFUN( "pm-set-highlight-background-color", Fpm_set_highlight_background_color,
+       Spm_set_highlight_background_color, 1, 1,
+      "sSet highlight background color: ",
+       "Set background color to COLOR." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg,1 ) ;
+    pmr.setcolor.header.type    = PMR_SETHICOLOR ;
+    pmr.setcolor.fore = COLOR_NONE ;
+    pmr.setcolor.back = ConvertColor( arg ) ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return Qt ;
+}
+
+DEFUN( "pm-set-cursor-type", Fpm_set_cursor_type,
+       Spm_set_cursor_type, 1, 1, "sSet cursor type: ",
+       "Set cursor type.\n\
+TYPE Pattern is box, bar, frame, underline, and halftone." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+    char	*cursor_type ;
+    int		type ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg,1 ) ;
+
+    cursor_type =( char * ) alloca( XSTRING( arg )->size + 1 ) ;
+    bcopy( XSTRING( arg )->data, cursor_type, XSTRING( arg )->size + 1 ) ;
+    cursor_type[XSTRING( arg )->size] = 0 ;
+    if ( strcmp( cursor_type, "box" ) == 0 ) {
+	type = CURSORTYPE_BOX ;
+    } else if ( strcmp( cursor_type, "bar" ) == 0 ) {
+	type = CURSORTYPE_BAR ;
+    } else if ( strcmp( cursor_type, "frame" ) == 0 ) {
+	type = CURSORTYPE_FRAME ;
+    } else if ( strcmp( cursor_type, "underline" ) == 0 ) {
+	type = CURSORTYPE_UNDERLINE ;
+    } else if ( strcmp( cursor_type, "halftone" ) == 0 ) {
+	type = CURSORTYPE_HALFTONE ;
+    } else {
+	error( "cursor type undefin" ) ;
+	return Qnil ;
+    }
+    pmr.cursortype.header.type = PMR_CURSORTYPE ;
+    pmr.cursortype.type  = type ;
+    pmr.cursortype.blink = 0 ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return Qt ;
+}
+	
+DEFUN( "pm-set-cursor-blink", Fpm_set_cursor_blink,
+       Spm_set_cursor_blink, 1, 1, "sSet cursor blink: ",
+       "Set cursor blink flag." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+    char	*cursor_type ;
+    int		type ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg,1 ) ;
+
+    cursor_type =( char * ) alloca( XSTRING( arg )->size + 1 ) ;
+    bcopy( XSTRING( arg )->data, cursor_type, XSTRING( arg )->size + 1 ) ;
+    cursor_type[XSTRING( arg )->size] = 0 ;
+    if ( strcmp( cursor_type, "yes" ) == 0 ) {
+	type = PMR_TRUE ;
+    } else {
+	type = PMR_FALSE ;
+    }
+    pmr.cursortype.header.type = PMR_CURSORTYPE ;
+    pmr.cursortype.type = 0 ;
+    pmr.cursortype.blink = type ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return Qt ;
+}
+	
+DEFUN( "pm-set-mouse-button-alias", Fpm_set_mouse_button_alias,
+       Spm_set_mouse_button_alias, 1, 1,
+      "sSet mouse button alias: ",
+       "Set mouse button event alias." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg, 1 ) ;
+    pmr.mouse.header.type = PMR_MOUSE ;
+    strncpy( pmr.mouse.button, XSTRING( arg )->data, 3 ) ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return Qt ;
+}
+
+DEFUN( "pm-set-window-pos", Fpm_set_window_pos,
+       Spm_set_window_pos, 1, 1,
+      "sSet window left & top position: ",
+       "Set window left & top position." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+    char	*dat ;
+    int		left, top ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg, 1 ) ;
+
+    dat =( char * ) alloca( XSTRING( arg )->size + 1 ) ;
+    bcopy( XSTRING( arg )->data, dat, XSTRING( arg )->size + 1 ) ;
+    dat[XSTRING( arg )->size] = 0 ;
+    sscanf( dat,"%d %d", &left, &top ) ;
+    pmr.setpos.header.type = PMR_SETPOS ;
+    pmr.setpos.left = left ;
+    pmr.setpos.top  = top ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return Qt ;
+}
+
+DEFUN( "pm-set-window-size", Fpm_set_window_size,
+       Spm_set_window_size, 1, 1,
+      "sSet window size: ",
+       "Set window size." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+    char	*dat ;
+    int		width, height ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg, 1 ) ;
+
+    dat =( char * ) alloca( XSTRING( arg )->size + 1 ) ;
+    bcopy( XSTRING( arg )->data, dat, XSTRING( arg )->size + 1 ) ;
+    dat[XSTRING( arg )->size] = 0 ;
+    sscanf( dat,"%d %d", &width, &height ) ;
+    if ( width < 1 )	width = 1 ;
+    if ( height < 1 )	height = 1 ;
+    pmr.setsize.header.type = PMR_SETSIZE ;
+    pmr.setsize.width = width ;
+    pmr.setsize.height = height ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return Qt ;
+}
+
+DEFUN( "pm-set-title-name", Fpm_set_title_name,
+       Spm_set_title_name, 1, 1,
+      "sSet window title name: ",
+       "Set window title name." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+    char	*dat ;
+    int		len ;
+    coding_type code ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg, 1 ) ;
+
+    CODE_TYPE_SET( &code, SJIS ) ;
+    CODE_CNTL( &code ) |= CC_END ;
+    len = XSTRING( arg )->size + 1 ;
+    dat = ( char * ) alloca( CONV_BUF_SIZE( len, SJIS ) ) ;
+    len = decode( &code, ( char * )XSTRING( arg )->data, dat , len ) ;
+    pmr.titlename.header.type = PMR_TITLENAME ;
+    pmr.titlename.count = len ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    pm_send( dat, len ) ;
+    return Qt ;
+}
+
+DEFUN( "pm-get-config", Fpm_get_config,
+       Spm_get_config, 0, 0, 0,
+       "Get PM window configration." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request		pmr ;
+    pmd_config		config ;
+    unsigned char	*buf, *convbuf ;
+    Lisp_Object		*list ;
+    int			lp, len, convlen ;
+    coding_type		code ;
+    Lisp_Object		dummy ;
+
+    CODE_TYPE_SET( &code, SJIS ) ;
+    CODE_CHAR_SET( &code, 0 ) ;
+    CODE_FORM( &code ) = CODE_EOL_CRLF ;
+    CODE_CNTL( &code ) |= CC_END ;
+    pmr.header.type = PMR_CONFIG ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    pm_receive_data( &config, sizeof( config ) ) ;
+    buf = alloca( config.size ) ;
+    pm_receive_data( buf, config.size ) ;
+    list = alloca( config.count * sizeof( Lisp_Object ) ) ;
+    for ( lp = 0; lp < config.count; ++lp ) {
+	len = *buf++ ;
+	convbuf = get_conversion_buffer( len, SJIS ) ;
+	convlen = encode( &code, buf, convbuf, len, &dummy) ;
+	list[lp] = make_string( convbuf, convlen ) ;
+	buf += len ;
+    }
+    return Flist( lp, list ) ;
+}
+
+DEFUN( "pm-set-function-menu", Fpm_set_function_menu,
+       Spm_set_function_menu, 1, 1, "sSet function key menu display: ",
+       "Set function menu display flag." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+    char	*function_menu ;
+    int		type ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg,1 ) ;
+
+    function_menu =( char * ) alloca( XSTRING( arg )->size + 1 ) ;
+    bcopy( XSTRING( arg )->data, function_menu, XSTRING( arg )->size + 1 ) ;
+    function_menu[XSTRING( arg )->size] = 0 ;
+
+    if ( strcmp( function_menu, "yes" ) == 0 )
+	type = PMR_TRUE ;
+    else
+	type = PMR_FALSE ;
+    pmr.funcmenu.header.type = PMR_FUNCMENU ;
+    pmr.funcmenu.display = type ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return Qt ;
+}
+	
+DEFUN( "pm-set-function-menu-item", Fpm_set_function_menu_item,
+      Spm_set_function_menu_item, 1, 1,
+      "sSet function key menu iterm: ",
+      "Set function menu iterm." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+    char	*dat ;
+    int		len ;
+    coding_type code ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg, 1 ) ;
+
+    CODE_TYPE_SET( &code, SJIS ) ;
+    CODE_CNTL( &code ) |= CC_END ;
+    len = XSTRING( arg )->size + 1 ;
+    dat = ( char * ) alloca( CONV_BUF_SIZE( len, SJIS ) ) ;
+    len = decode( &code, ( char * )XSTRING( arg )->data, dat , len ) ;
+    pmr.funcmenumsg.header.type = PMR_FUNCMENUMSG ;
+    pmr.funcmenumsg.funcmenu_length = len ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    pm_send( dat, len ) ;
+    return Qt ;
+}
+
+DEFUN( "pm-set-shortcut", Fpm_set_shortcut,
+       Spm_set_shortcut, 1, 1, "sSet short cut: ",
+       "Set system key short cut mode." )
+ ( arg )
+     Lisp_Object arg ;
+{
+    pm_request	pmr ;
+    char	*shortcut ;
+    int		type ;
+
+    check_pmterm( ) ;
+    CHECK_STRING( arg,1 ) ;
+
+    shortcut =( char * ) alloca( XSTRING( arg )->size + 1 ) ;
+    bcopy( XSTRING( arg )->data, shortcut, XSTRING( arg )->size + 1 ) ;
+    shortcut[XSTRING( arg )->size] = 0 ;
+
+    if ( strcmp( shortcut, "yes" ) == 0 )
+	type = PMR_TRUE ;
+    else
+	type = PMR_FALSE ;
+    pmr.funcmenu.header.type = PMR_SHORTCUT ;
+    pmr.shortcut.shortcut = type ;
+    pm_send( &pmr, sizeof( pmr ) ) ;
+    return Qt ;
+}
+
+/************************************************************************/
+/************************************************************************/
+/************************************************************************/
+/************************************************************************/
+syms_of_os2pmterm( )
+{
+    /* If not dumping, init_display ran before us, so don't override it.  */
+    DEFVAR_LISP( "x-mouse-item", &Vx_mouse_item,
+	 "Encoded representation of last mouse click, corresponding to\n\
+numerical entries in x-mouse-map." ) ;
+    Vx_mouse_item = Qnil ;
+
+    DEFVAR_LISP( "x-mouse-pos", &Vx_mouse_pos,
+		 "Current x-y position of mouse by row, column as specified by font." ) ;
+    Vx_mouse_pos = Qnil ;
+
+    DEFVAR_LISP( "PMTERM", &Vos2pmterm, "" ) ;
+
+    defsubr( &Sx_mouse_events ) ;
+    defsubr( &Sx_proc_mouse_event ) ;
+    defsubr( &Sx_get_mouse_p ) ;
+    defsubr( &Scoordinates_in_window_p ) ;
+    defsubr( &Sx_popup_menu ) ;
+    defsubr( &Sx_store_cut_buffer ) ;
+    defsubr( &Sx_get_cut_buffer ) ;
+
+    defsubr( &Spm_kill_emacs ) ;
+    defsubr( &Spm_suspend ) ;
+    defsubr( &Spm_list_fonts ) ;
+    defsubr( &Spm_set_font ) ;
+
+    defsubr( &Spm_set_foreground_color ) ;
+    defsubr( &Spm_set_background_color ) ;
+    defsubr( &Spm_set_highlight_foreground_color ) ;
+    defsubr( &Spm_set_highlight_background_color ) ;
+    defsubr( &Spm_set_cursor_type ) ;
+    defsubr( &Spm_set_cursor_blink ) ;
+    defsubr( &Spm_set_window_pos ) ;
+    defsubr( &Spm_set_window_size ) ;
+    defsubr( &Spm_set_title_name ) ;
+
+    defsubr( &Spm_set_mouse_button_alias ) ;
+    defsubr( &Spm_get_config ) ;
+    defsubr( &Spm_set_function_menu ) ;
+    defsubr( &Spm_set_function_menu_item ) ;
+    defsubr( &Spm_set_shortcut ) ;
+
+#ifdef CANNOT_DUMP
+    if ( noninteractive )
+#endif
+	Vos2pmterm = Qnil ;
+}
diff -urP /mule-1.1/src/process.c ./src/process.c
--- /mule-1.1/src/process.c	Mon Mar 14 14:46:14 1994
+++ ./src/process.c	Tue Mar 15 05:05:28 1994
@@ -117,6 +117,12 @@
 #define EWOULDBLOCK 1035
 #endif
 
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+#include <fcntl.h>
+#endif
+/* end of patch */
+
 #ifdef NEED_BSDTTY
 #include <sys/bsdtty.h>
 #endif
@@ -274,7 +280,8 @@
 extern sys_nerr;
 extern char *sys_errlist[];
 
-#if !defined(BSD4_1) && !defined(WIN32) /* 93.2.17 by M.Higashida */
+/* 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if !defined(BSD4_1) && !defined(WIN32) && !defined(OS2)
 extern char *sys_siglist[];
 #else
 char *sys_siglist[] =
@@ -1107,7 +1114,13 @@
   if (new_argv[0][0] != '/')
     {
       tem = Qnil;
+/* 93.8.23 by O.Sasaki */
+#ifdef OS2
+      openp (Vexec_path, program, ".exe:.com:", &tem, 1);
+#else
       openp (Vexec_path, program, "", &tem, 1);
+#endif
+/* end of patch */
       if (NULL (tem))
 	report_file_error ("Searching for program", Fcons (program, Qnil));
       new_argv[0] = XSTRING (tem)->data;
@@ -1492,6 +1505,12 @@
       if (temp < 0) goto io_failure;
       outchannel = sv[1];
       forkin = sv[0];
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+      setmode (inchannel, O_TEXT);
+      setmode (outchannel, O_TEXT);
+#endif
+/* end of patch */
     }
 #endif /* not SKTPAIR */
 
@@ -1681,6 +1700,11 @@
 #endif /* SIGCHLD */
 	if (pty_flag)
 	  child_setup_tty (xforkout);
+/* 93.8.20 by O.Sasaki */
+#ifdef OS2
+        pid =
+#endif
+/* end of patch */
 	child_setup (xforkin, xforkout, xforkout, new_argv, env);
       }
     environ = save_environ;
@@ -1980,6 +2004,10 @@
 close_process_descs ()
 {
   int i;
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  for (i = 3; i < MAXDESC; ++i)
+    fcntl (i, F_SETFD, 1);
+#else
   for (i = 0; i < MAXDESC; i++)
     {
       Lisp_Object process;
@@ -1997,6 +2025,8 @@
 	    close (XFASTINT (XPROCESS (process)->subtty));
 	}
     }
+#endif	/* not OS2 */
+/* end of patch */
 }
 
 DEFUN ("accept-process-output", Faccept_process_output, Saccept_process_output,
@@ -2074,7 +2104,11 @@
   if (time_limit)
     {
 #ifdef HAVE_TIMEVAL
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+      gettimeofday (&end_time, 0);
+#else
       gettimeofday (&end_time, &garbage);
+#endif
       end_time.tv_sec += time_limit;
 #else /* not HAVE_TIMEVAL */
       time (&end_time);
@@ -2149,8 +2183,11 @@
       else if (time_limit)
 	{
 #ifdef HAVE_TIMEVAL
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+	  gettimeofday (&timeout, 0);
+#else
 	  gettimeofday (&timeout, &garbage);
-
+#endif
 	  /* In effect, timeout = end_time - timeout.
 	     Break if result would be negative.  */
 	  if (timeval_subtract (&timeout, end_time, timeout))
@@ -2551,6 +2588,9 @@
   register struct Lisp_Process *p = XPROCESS (proc);
   register int opoint;
 
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  fcntl (channel, F_SETFL, O_NDELAY);
+#endif
   if (proc_buffered_char[channel] < 0)
 #ifdef WIN32 /* 93.2.17 by M.Higashida */
     if (channel < 32)
@@ -3280,6 +3320,11 @@
       errno = old_errno;
       return;
 #endif /* USG, but not HPUX with WNOHANG */
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+      signal (signo, SIG_ACK);
+      errno = old_errno;
+      return;
+#endif
     }
 #endif /* not WIN32 */
 }
diff -urP /mule-1.1/src/s-os2.h ./src/s-os2.h
--- /mule-1.1/src/s-os2.h
+++ ./src/s-os2.h	Tue Dec 14 13:33:30 1993
@@ -0,0 +1,149 @@
+/* Definitions file for GNU Emacs running on IBM's OS/2 2.x
+   Copyright (C) 1987 Free Software Foundation, Inc.
+
+This file is part of GNU Emacs.
+
+GNU Emacs is free software; you can redistribute it and/or modify
+it under the terms of the GNU General Public License as published by
+the Free Software Foundation; either version 1, or (at your option)
+any later version.
+
+GNU Emacs is distributed in the hope that it will be useful,
+but WITHOUT ANY WARRANTY; without even the implied warranty of
+MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+GNU General Public License for more details.
+
+You should have received a copy of the GNU General Public License
+along with GNU Emacs; see the file COPYING.  If not, write to
+the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
+
+
+/*
+ *	Define symbols to identify the version of Unix this is.
+ *	Define all the symbols that apply correctly.
+ */
+
+#ifndef OS2       /* avoid problem if OS2 is defined on gcc command line */
+#define OS2
+#endif
+
+#ifndef OS2PM
+#define OS2PM
+#endif
+
+/* SYSTEM_TYPE should indicate the kind of system you are using.
+ It sets the Lisp variable system-type.  */
+
+#define SYSTEM_TYPE "OS/2"
+
+/* nomultiplejobs should be defined if your system's shell
+ does not have "job control" (the ability to stop a program,
+ run some other program, then continue the first one).  */
+
+#define NOMULTIPLEJOBS
+
+/* Default is to set interrupt_input to 0: don't do input buffering within Emacs */
+
+/* #define INTERRUPT_INPUT */
+
+/*
+ *	Define HAVE_TERMIO if the system provides sysV-style ioctls
+ *	for terminal control.
+ */
+
+#define HAVE_TERMIO
+
+/*
+ *	Define HAVE_TIMEVAL if the system supports the BSD style clock values.
+ *	Look in <sys/time.h> for a timeval structure.
+ */
+
+#define HAVE_TIMEVAL
+ 
+/*
+ *	Define HAVE_SELECT if the system supports the `select' system call.
+ */
+
+#define HAVE_SELECT
+
+/* Define HAVE_SOCKETS if system supports 4.2-compatible sockets.  */
+
+/* #define HAVE_SOCKETS */
+
+/*
+ *	Define NONSYSTEM_DIR_LIBRARY to make Emacs emulate
+ *      The 4.2 opendir, etc., library functions.
+ */
+
+/* #define NONSYSTEM_DIR_LIBRARY */
+
+/*
+ * 	Define SYSV_SYSTEM_DIR to use the V.3 getdents/readir
+ *	library functions.  Almost, but not quite the same as
+ *	the 4.2 functions
+ */
+/* #define SYSV_SYSTEM_DIR */
+
+/* Define this symbol if your system has the functions bcopy, etc. */
+
+#define BSTRING
+
+/* subprocesses should be defined if you want to
+ have code for asynchronous subprocesses
+ (as used in M-x compile and M-x shell).
+ This is supposed to work now on system V release 2.  */
+
+#define subprocesses
+
+/* If your system uses COFF (Common Object File Format) then define the
+   preprocessor symbol "COFF". */
+
+/* #define COFF */
+
+/* define MAIL_USE_FLOCK if the mailer uses flock
+   to interlock access to /usr/spool/mail/$USER.
+   The alternative is that a lock file named
+   /usr/spool/mail/$USER.lock.  */
+
+/* #define MAIL_USE_FLOCK */
+
+/* Define CLASH_DETECTION if you want lock files to be written
+   so that Emacs can tell instantly when you try to modify
+   a file that someone else has modified in his Emacs.  */
+
+/* #define CLASH_DETECTION */
+
+
+/* Text or Binary file translation is done by Emacs. */
+/* #define FILE_TRANSLATION_MODE */
+
+
+/* Special hacks needed to make Emacs run on this system.  */
+
+/*
+ *	Make the sigsetmask function go away.  Don't know what the
+ *	ramifications of this are, but doesn't seem possible to
+ *	emulate it properly anyway at this point.
+ */
+
+#define sigsetmask(mask)	/* Null expansion */
+
+/* setjmp and longjmp can safely replace _setjmp and _longjmp,
+   but they will run slower.  */
+
+#define _setjmp setjmp
+#define _longjmp longjmp
+
+/* Some variants have TIOCGETC, but the structures to go with it
+   are not declared.  */
+
+#define BROKEN_TIOCGETC
+
+#define USE_UTIME
+
+
+#define	PENDING_OUTPUT_COUNT(FILE) ((FILE)->ptr - (FILE)->buffer)
+#define SYSTEM_MALLOC
+#define CANNOT_UNEXEC
+#define SYMS_SYSTEM    syms_of_os2()
+#define OBJECTS_SYSTEM os2.o
diff -urP /mule-1.1/src/sysdep.c ./src/sysdep.c
--- /mule-1.1/src/sysdep.c	Mon Jul 26 14:55:34 1993
+++ ./src/sysdep.c	Thu Mar 17 12:32:16 1994
@@ -62,6 +62,10 @@
 #include "lisp.h"
 #undef NULL
 
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+#include <sys/ioctl.h>
+#endif
+
 #define min(x,y) ((x) > (y) ? (y) : (x))
 
 /* In this file, open, read and write refer to the system calls,
@@ -288,7 +292,9 @@
 #endif /* not HAVE_TERMIO */
 
 #ifdef USG
+#ifndef OS2 /* 93.8.20 by O.Sasaki */
 #include <sys/utsname.h>
+#endif
 #include <string.h>
 #ifndef MEMORY_IN_STRING_H
 #include <memory.h>
@@ -832,6 +838,13 @@
 
 sys_suspend ()
 {
+#ifdef OS2 /* 93.8.20, 94.3.17 by O.Sasaki */
+    char *sh ;
+
+    if ((sh = getenv("SHELL")) == 0 )
+	sh = "";
+    system(sh);
+#else
 #ifndef WIN32 /* 93.2.17 by M.Higashida */
 #ifdef VMS
   unsigned long parent_id;
@@ -955,6 +968,7 @@
 #endif /* no SIGTSTP */
 #endif /* not VMS */
 #endif /* not WIN32 */
+#endif /* not OS2 */
 }
 
 save_signal_handlers (saved_handlers)
@@ -1156,6 +1170,10 @@
 #ifdef ISTRIP
       tty.c_iflag &= ~ISTRIP;	/* don't strip 8th bit on input */
 #endif
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+      tty.c_lflag &= ~IDEFAULT; /* Enable termio */
+      tty.c_iflag |= IDELETE;   /* let backspace generate del */
+#endif
       tty.c_lflag &= ~ECHO;	/* Disable echo */
       tty.c_lflag &= ~ICANON;	/* Disable erase/kill processing */
 #ifdef IEXTEN
@@ -1452,6 +1470,11 @@
 #endif /* Sun */
 #endif /* nec_ews_svr2 */
 
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  int sz[2];
+  _scrsize (sz);
+  *widthp = sz[0]; *heightp = sz[1];
+#else
 /* Do it using the 4.3 names if possible.  */
 #ifdef TIOCGWINSZ
   struct winsize size;
@@ -1497,6 +1520,7 @@
 /* end of patch */
 #endif /* system does not know size */
 #endif /* not TIOCGWINSZ */
+#endif /* not OS2 */
 }
 
 reset_sys_modes ()
@@ -1859,6 +1883,8 @@
 #endif /* VMS */
 
 /* Note that VMS compiler won't accept defined (CANNOT_DUMP).  */
+/* 93.8.20 by O.Sasaki */
+#ifndef OS2
 /* 92.11.4 by M.Higashida */
 #if !(defined(MSDOS) && defined(EMX))
 #ifndef CANNOT_DUMP
@@ -1985,6 +2011,7 @@
 
 #endif /* not CANNOT_DUMP */
 #endif /* not MSDOS and EMX */
+#endif /* OS2 */
 /* end if patch */
 
 /* Get_system_name returns as its value
@@ -2008,6 +2035,14 @@
 char *
 get_system_name ()
 {
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+static char system_name_saved[255];
+  char *sp;
+  if ((sp = getenv ("SYSTEMNAME")) == 0)
+    sp = "My-System";
+  strcpy (system_name_saved, sp);
+  return system_name_saved;
+#else /* not OS2 */
 #ifdef USG
 #ifdef HAVE_GETHOSTNAME
   gethostname (get_system_name_name, sizeof (get_system_name_name));
@@ -2039,6 +2074,7 @@
   return system_name_saved;
 #endif /* not USG, not 4.1 */
 #endif /* not USG */
+#endif /* not OS2 */
 }
 
 /* 91.10.16 by S.Hirano, 93.6.1 by M.Higashida */
@@ -2070,10 +2106,28 @@
 #else /* not BSD4_1 */
   signal (SIGALRM, SIG_IGN);
 #endif /* not BSD4_1 */
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+  signal(SIGALRM, SIG_ACK);
+#endif
   if (read_alarm_should_throw)
     longjmp (read_alarm_throw, 1);
 }
 
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+int request_file_io(int fd, char *buf)
+{
+FILE *fp;
+
+   fp = fdopen(fd, "b");
+   if (fp->rcount==0)
+     return -1;
+   else
+     return fp->rcount;  
+
+}
+#endif	/* OS2 */
+/* end of patch */
+
 /* Only rfds are checked.  */
 int
 select (nfds, rfds, wfds, efds, timeout)
@@ -4701,6 +4755,8 @@
 /* end of patch */
 
 
+/* 93.8.20 by O.Sasaki */
+#ifndef OS2
 /* 93.7.26 by K.Handa */
 #ifndef HAVE_CLOCK
 #if defined (USG) || defined (VMS)
@@ -4725,3 +4781,97 @@
   return RUSAGE_TOTAL (&rusage);
 }
 #endif /* not HAVE_CLOCK */
+#endif /* not OS2 */
+
+/*
+ The follwing is entirely for OS/2 93.8.20 by O.Sasaki
+*/
+#ifdef OS2
+
+#include <fcntl.h>
+
+croak (badfunc)
+     char *badfunc;
+{
+  printf ("%s not yet implemented\r\n", badfunc);
+  reset_sys_modes ();
+  exit (1);
+}
+
+long
+random ()
+{
+  /* Arrange to return a range centered on zero.  */
+  return rand () - (1 << 30);
+}
+
+srandom (seed)
+{
+  srand (seed);
+}
+
+ulimit ()
+{}
+
+setpriority ()
+{}
+
+setpgrp ()
+{}
+
+execvp (char *cmd, char **arg)
+{
+  return execve(cmd, arg, NULL);
+}
+/* very poor version */
+execlp (char *cmd, char *arg0, char *arg1)
+{
+char *args[3];
+
+    args[0] = arg0;
+    args[1] = arg1;
+    args[2] = NULL;
+
+    execvp(cmd, args);
+}
+
+request_sigio ()
+{
+  croak ("request_sigio");
+}
+
+unrequest_sigio ()
+{
+  croak ("unrequest_sigio");
+}
+
+pause(void)
+{}    
+
+vfork( void )
+{
+    return fork();
+}
+
+/*
+   Make Emacs always think, he's the subprocess now.
+   Hoping he will always call child_setup().
+*/
+fork( void )
+{
+    return 0;
+}
+
+char *
+dostounix_filename (p)
+     register char *p;
+{
+  char *ret = p;
+  while (p && *p) {
+    if (*p == '\\')
+      *p = '/';
+    p++;
+  }
+  return ret;
+}
+#endif /* OS2 */
diff -urP /mule-1.1/src/termcap.c ./src/termcap.c
--- /mule-1.1/src/termcap.c	Fri Jul 23 14:12:32 1993
+++ ./src/termcap.c	Tue Mar 15 05:13:06 1994
@@ -303,6 +303,9 @@
 #include <fcntl.h>
 #define O_TEXT _O_TEXT
 #endif
+#ifdef OS2 /* 93.8.20 by O.Sasaki */
+#include <fcntl.h>
+#endif
 /* end of patch */
 
 #ifdef VMS
@@ -360,8 +363,8 @@
 #ifdef VMS
   filep = tem && legal_filename_p (tem);
 #else
-/* 91.10.20, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.20, 93.2.17 by M.Higashida, 93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   if (tem != 0 && (*tem == '\\' || *tem == '/' || tem[1] == ':')) {
     dostounix_filename (tem);
   }
@@ -407,8 +410,8 @@
 
   /* Here we know we must search a file and tem has its name.  */
 
-/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida */
-#if defined(MSDOS) || defined(WIN32)
+/* 91.10.16 by S.Hirano, 93.2.17 by M.Higashida,93.8.20 by O.Sasaki */
+#if defined(MSDOS) || defined(WIN32) || defined(OS2)
   fd = open (tem, O_TEXT, 0);
 #else
   fd = open (tem, 0, 0);
