#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/utime.h>

typedef unsigned char UCHAR ;
typedef UCHAR *PUCHAR ;

typedef short SHORT ;
typedef SHORT *PSHORT ;

typedef unsigned short USHORT ;
typedef USHORT *PUSHORT ;

typedef struct {
    char *name ;
    char **value ;
} CONFIGDATA ;

#define isKANJI(c) \
    ((UCHAR)(c) & 0x80 && ((UCHAR)(c) < 0xA0 || (UCHAR)(c) >= 0xE0))
#define BODYNAME	"body.dat"
#define BUFFER_SIZE 256

char	*UupcConfDir = NULL ;	/* UUPCRtBOfBNg[		*/
char	*UupcNewsDir = NULL ;	/* UUPCj[XfBNg[		*/

CONFIGDATA	Conf[] = {
    { "confdir",	&UupcConfDir		} ,
    { "newsdir",	&UupcNewsDir		} ,
    { NULL, NULL }
} ;

char	NowLogGenData[256] ;
FILE	*in, *out, *msgbody ;

UCHAR	buf[2048] ;		/* bZ[W̓obt@		*/
UCHAR	wbuf[256] ;		/* ėpobt@				*/

UCHAR	dir[256] ;		/* bZ[WO[v			*/
long	number ;		/* bZ[Wԍ			*/
UCHAR	name[256] ;		/* MҖ				*/
long	MsgSize ;		/* bZ[W			*/
UCHAR	youbi[8] ;		/* Mj				*/
UCHAR	tuki[8] ;		/* M				*/
int	day ;			/* M				*/
UCHAR	jikan[16] ;		/* M				*/
int	year ;			/* MN				*/
int	re_num ;		/* vCbZ[Wԍ		*/

UCHAR	messageid[256] ;	/* MbZ[Whcf[^		*/
UCHAR	subject[256] ;		/* Wf[^				*/

UCHAR	OutDir[256] ;		/* vCf[^QƃfBNg[	*/

UCHAR	OutMsgBuf[512] ;	/* JISR[ho̓obt@		*/

long	lines ;			/* bZ[WC			*/
long	endnumber ;		/* bZ[WO[vIԍ		*/

UCHAR	ActiveFile[256] ;	/* NEWSANeBuwt@C		*/
int	ActiveMode ;		/* bZ[Wt@Cۑ̗L		*/
int	ExecMode ;		/* vOs[h			*/

/* Tu[`vg^Cv錾 */
void ReadHeader( void ) ;
void CreateDir( char *dir ) ;
void WriteHeader( void ) ;
void DataWrite( const char *fmt, ... ) ;
USHORT SJIStoJIS( UCHAR byte1, UCHAR byte2 ) ;
void UpdateMessage( void ) ;
void UpdateActive( void ) ;
void CheckActive( void ) ;
void GetConfigData( char *rcname ) ;
void FreeUupcValue( ) ;


/************************************************/
/*						*/
/*						*/
/*						*/
/************************************************/
int main( int argc, char **argv )
{
    UCHAR	*tmp ;
    long	now ;

    if ( strcmp( argv[1], "-c" ) == 0 ) {
	ExecMode = 0 ;		/* check mode */
	++argv ;
	--argc ;
    } else
	ExecMode = 1 ;		/* convert mode */

    if ( argc != 2 ) {
	printf( "usage: %s [-c] logfile\n" ) ;
	printf( "  -c Check log file format\n" ) ;
	exit( 1 ) ;
    }
    if ( ( in = fopen( argv[1], "r" ) ) == NULL ) {
	fprintf( stderr, "%s ݂܂B\n", argv[1] ) ;
    	exit( 1 ) ;
    }

    /* UUPC荞 */
    GetConfigData( "UUPCSYSRC" ) ;
    GetConfigData( "UUPCUSRRC" ) ;

    strcpy( ActiveFile, UupcConfDir ) ;
    strcat( ActiveFile, "/active" ) ;
    if ( ExecMode ) {
	sprintf( wbuf, "copy %s %s.bak > nul", ActiveFile, ActiveFile ) ;
	system( wbuf ) ;

	*NowLogGenData = '\0' ;

	out = fopen( "dummy", "wb" ) ;
	msgbody = fopen( BODYNAME, "w" ) ;
	ActiveMode = 0 ;
    }
    now = 0L ;

    while ( fgets( buf, 2048, in ) != NULL ) {
	if ( ( tmp = strstr( buf, "==========================\n" ) ) != 0 &&
	    tmp == buf ) {
	    if ( ExecMode ) {
		/* Of[^̃CƖ{̃bZ[W */
		UpdateMessage( ) ;
		endnumber = number ;
		msgbody = fopen( BODYNAME, "w" ) ;
	    }
	    /* wb_[f[^ & o */
	    ReadHeader( ) ;

	    if ( ExecMode ) {
		/* ڃO[vI`FbN */
		if ( strcmp( dir, NowLogGenData ) != 0 ) {
		    /* ACTIVEt@CXV */
		    UpdateActive( ) ;

		    /* VO[v\ */
		    fprintf( stderr, "\n%s", dir ) ;
		    strcpy( NowLogGenData, dir ) ;

		}
		if ( ActiveMode )
		    fputc( '.', stderr ) ;
		else
		    fputc( '*', stderr ) ;
	    } else {
		printf( "%-28s No.%-6ld %d-%s-%2d %s %s =%-6ld M: %-10s"
		       , &dir[4], number
		       , year, tuki, day, youbi, jikan
		       , MsgSize, name
		       ) ;
		if ( re_num != 0 )
		    printf( " rep: %-6d", re_num ) ;
		else
		    printf( "            " ) ;
		printf( " W: %s\n", subject ) ;
	    }
	    now = 0L;
	}

	now += ( long )strlen( buf ) ;

	if ( ExecMode && ActiveMode ) {
	    /* bZ[Wf[^{ */
	    if ( now <= MsgSize ) {
		if ( *buf != 0xff ) {
		    fputs( buf, msgbody ) ;
		    ++lines ;
		}
	    }
	}
    }
    if ( ExecMode && ActiveMode ) {
	/* Ō̃f[^̃CƖ{̃bZ[W */
	UpdateMessage( ) ;

	/* ŏIbZ[WO[vACTIVEXV */
	UpdateActive( ) ;
    }
    /* e|[t@CQ폜 */
    unlink( "dummy" ) ;
    unlink( BODYNAME ) ;
    return 0 ;
}

/************************************************/
/*						*/
/*						*/
/*						*/
/************************************************/
void ReadHeader( void )
{
    UCHAR	*tmp ;
    UCHAR	cnumber[128] ;

    /* wb_[͕ǂݍ */
    if ( fgets( buf, 2048, in ) == NULL )
	exit( 1 ) ;

/*
  TvF
  ibm.hardware/main 48, tal , 430 , Fri Jun  4 00:40:16 1993
 */
    sscanf( buf, "%s %s %s %s %d %s %s %s %d %s %d"
	   , dir, cnumber, name, wbuf, &MsgSize
	   , wbuf, youbi, tuki, &day, jikan, &year
	   ) ;
    number = atol( cnumber ) ;

    /* O[v */
    for ( tmp = dir ; *tmp; ++tmp )
	if ( *tmp == '/' )
	    *tmp = '.' ;
    strcpy( wbuf, "mix." ) ;
    strcat( wbuf, dir ) ;
    strcpy( dir, wbuf ) ;

    /* o̓t@CfBNg[ */
    for ( tmp = wbuf ; *tmp; ++tmp )
	if ( *tmp == '.' )
	    *tmp = '/' ;
    sprintf( OutDir, "%s/%s", UupcNewsDir, wbuf ) ;

    /* VO[v̓ǂݍݎw`GbN */
    CheckActive( ) ;

    if ( ExecMode && ActiveMode ) {
	CreateDir( OutDir ) ;

	/* bZ[Wo̓t@CI[v */
	sprintf( wbuf, "%s/%d",OutDir, number ) ;
	out = fopen( wbuf, "wb" ) ;
    }

    /* vCbZ[Wԍ */
    if ( fgets( buf, 2048, in ) == NULL )
	exit( 1 ) ;

    /* TvF  56 ւ̃RgłB*/
    if ( strstr( buf, "" ) != 0 )
	sscanf( buf, "%s %d", wbuf, &re_num ) ;
    else
	re_num = 0 ;

    /* wb_[f[^XLbv */
    do {
	if ( ( tmp = strstr( buf, "--------------------------" ) ) != 0
	    && tmp == buf )
	    break ;
    } while ( fgets( buf, 2048, in ) != NULL ) ;
    fgets( buf, 2048, in ) ;

    /* TuWFNg */
    if ( strncmp( buf, "WF", 6 ) == 0 ) {
	for ( tmp = &buf[6] ; isspace( *tmp ) ; ++tmp ) ;
	for ( ; strncmp( tmp, "@", 2 ) == 0; tmp += 2 ) ;
	strcpy( subject, tmp ) ;
	subject[ strlen(subject) -1] = 0 ;
	*buf = 0xff ;
    } else {
	strcpy( subject, "`" ) ;
    }

    if ( ExecMode && ActiveMode )
	WriteHeader( ) ;
    lines = 0L ;
}

/************************************************/
/*						*/
/*						*/
/*						*/
/************************************************/
void CreateDir( char *dir )
{
    UCHAR	tmpbuf[256] ;
    int		len, pos ;

    if ( access( dir, 0 ) ) {
	len = strlen( dir ) ;
	pos = 0 ;
	strcpy( tmpbuf, dir ) ;
	while ( pos < len ) {
	    while ( tmpbuf[pos] != '/' && tmpbuf[pos] != 0 )
		++pos ;
	    if ( tmpbuf[pos] ) {
		tmpbuf[pos] = 0 ;
		mkdir( tmpbuf, 0L ) ;
		tmpbuf[pos] = '/' ;
		++pos ;
	    }
	}
	mkdir( tmpbuf, 0L ) ;
    }
}

/************************************************/
/*						*/
/*						*/
/*						*/
/************************************************/
void WriteHeader( void )
{
    UCHAR	*tmp, *tmp2 ;
    int		findrep ;
    FILE	*rep ;
    UCHAR	reptmp[256] ;

/*
  Tv:
  From: uchida@yrd.suzuki.co.jp (Uchida Hitoshi)
  Newsgroups: fj.editor.mule,fj.sys.hp
  Subject: Mule and Canna on HP-UX
  Message-ID: <UCHIDA.94Jan27165350@yrd-gw.yrd.suzuki.co.jp>
  References: <NTAKAHAS.94Feb2212941@etlnao.etl.go.jp>
  Date: 27 Jan 94 07:53:50 GMT
  Lines: 20
  */
    /* bZ[Whc */
    for ( tmp = wbuf, tmp2 = name; *tmp2; ++tmp, ++tmp2 )
	*tmp = toupper( *tmp2 ) ;
    *tmp = 0 ;
    sprintf( messageid, "<%s.%d%s%02d%s@mix.or.jp>",
	    wbuf, year-1900, tuki, day, jikan ) ;
    /* ԃe[^":"폜 */
    for( tmp = tmp2 = messageid; *tmp2; ++tmp, ++tmp2 ) {
	if ( *tmp2 == ':' )
	    ++tmp2 ;
	*tmp = *tmp2 ;
    }
    *tmp = 0 ;

    /* vCLꍇ̓TuWFNgύX */
    if ( re_num ) {
	findrep = 0 ;
	sprintf( wbuf, "%s/%d", OutDir, re_num ) ;
	if ( ( rep = fopen( wbuf, "r" ) ) ) {
	    fgets( wbuf, 256, rep ) ; /* skip Newsgroups: */
	    fgets( wbuf, 256, rep ) ; /* skip From: */

	    /* Subjectǂݍ */
	    fgets( wbuf, 256, rep ) ;
	    strcpy( reptmp, &wbuf[9] ) ;
	    if ( strncmp( reptmp, "Re: ", 4 ) )
		sprintf( subject, "%Re: %s", reptmp ) ;
	    else
		strcpy( subject, reptmp ) ;
	    subject[ strlen( subject ) -1 ] = 0 ;

	    /* t@XpbZ[WIDݒ */
	    fgets( wbuf, 256, rep ) ;
	    strcpy( reptmp, &wbuf[12] ) ;
	    reptmp[ strlen( reptmp ) -1 ] = 0 ;

	    findrep = 1 ;
	    fclose( rep ) ;
	}
    }

    /* wb_[o */
    DataWrite( "Newsgroups: %s\n", dir ) ;
    DataWrite( "From: %s@mix.or.jp <%s>\n", name, name ) ;
    DataWrite( "Subject: %s\n", subject ) ;
    DataWrite( "Message-ID: %s\n", messageid ) ;
    if ( re_num ) {
	if ( findrep )
	    DataWrite( "References: %s\n", reptmp ) ;
	else
	    DataWrite( "References: <%d̃bZ[W>\n", re_num ) ;
    }
    DataWrite( "Date: %2d %s %d %s\n", day, tuki, year, jikan ) ;
}

/************************************************/
/*						*/
/*						*/
/*						*/
/************************************************/
void DataWrite( const char *fmt, ... )
{
    va_list	ap;
    int		kanjimode ;
    UCHAR	tmpbuf[256], *pos, *data, hi, low ;
    USHORT	jiskanji ;

    va_start( ap, fmt ) ;
    vsprintf( tmpbuf, fmt, ap ) ;
    va_end( ap ) ;

    kanjimode = 0 ;
    pos = OutMsgBuf ;
    data = tmpbuf ;
    while ( *data ) {
	if ( isKANJI( *data ) ) {
	    if ( !kanjimode ) {
		/* hmo */
		*pos++ = 0x1b ; *pos++ = '$' ; *pos++ = 'B' ;
		kanjimode = 1 ;
	    }
	    hi = *data++ ;
	    low = *data++ ;
	    jiskanji = SJIStoJIS( hi, low ) ;
	    *pos++ = (UCHAR)( jiskanji >> 8 ) ;
	    *pos++ = (UCHAR)( jiskanji & 0xff ) ;
	} else {
	    if ( kanjimode ) {
		/* ntso */
		*pos++ = 0x1b ;	*pos++ = '(' ;	*pos++ = 'B' ;
		kanjimode = 0 ;
	    }
	    *pos++ = *data++ ;
	}
    }
    *pos = 0 ;
    fputs( OutMsgBuf, out ) ;
}

/************************************************/
/*						*/
/*						*/
/*						*/
/************************************************/
USHORT SJIStoJIS( UCHAR byte1, UCHAR byte2 )
{
    USHORT	c;
    USHORT	byte_1, byte_2 ;

    byte_1 = ( USHORT )byte1 ;
    byte_2 = ( USHORT )byte2 ;

    byte_1 -= (byte_1 >= 0xa0) ? 0xc1 : 0x81 ;
    if (byte_2 >= 0x9f) {
	c = (byte_1 << 9) + 0x2200 ;
	c |= byte_2 - 0x7e ;
    } else {
	c = (byte_1 << 9) + 0x2100 ;
	c |= byte_2 - ((byte_2 <= 0x7e) ? 0x1f : 0x20) ;
    }
    return ( c ) ;
}

/************************************************/
/*						*/
/*						*/
/*						*/
/************************************************/
void UpdateMessage( void )
{
    struct utimbuf	otime ;
    struct tm		otm ;
    time_t		oOrgTime ;
    UCHAR		mondata[] = "JanFebMarAprMayJunJulAugSepOctNovDec" ;
    UCHAR		*pos ;

    DataWrite( "Lines: %d\n\n", lines ) ;
    fclose( msgbody ) ;
    msgbody = fopen( BODYNAME, "r" ) ;
    while ( fgets( buf, 2048, msgbody ) != NULL )
	DataWrite( "%s", buf ) ;
    fclose( out ) ;
    fclose( msgbody ) ;
    if ( ( pos = strstr( mondata, tuki ) ) == NULL )
	return ;
    sscanf( jikan, "%d:%d:%d", &otm.tm_hour, &otm.tm_min, &otm.tm_sec ) ;
    otm.tm_mday = day ;
    otm.tm_mon = ( int )( pos - mondata ) / 3 ;
    otm.tm_year = year - 1900 ;
    otm.tm_isdst = 0 ;
    oOrgTime = mktime( &otm ) ;
    otime.actime = oOrgTime ;
    otime.modtime = oOrgTime ;
    sprintf( wbuf, "%s/%d", OutDir,number ) ;
    utime( wbuf, &otime ) ;
}

/************************************************/
/*						*/
/*						*/
/*						*/
/************************************************/
void UpdateActive( void )
{
    FILE	*old, *new ;
    UCHAR	grp[128] ;
    long	str, end ;
    UCHAR	mode[4] ;
    UCHAR	tmp[256] ;

    strcpy( wbuf, ActiveFile ) ;
    strcat( wbuf, ".old" ) ;
    rename( ActiveFile, wbuf ) ;

    old = fopen( wbuf, "r" ) ;
    new = fopen( ActiveFile, "wb" ) ;
    while ( fgets( tmp, 256, old ) != NULL ) {
	/* Tv: mix.system.news.main 1016 1008 y */
	sscanf( tmp, "%s %ld %ld %s", grp, &end, &str, mode ) ;
	if ( strcmp( grp, NowLogGenData ) == 0 && end < endnumber )
	    sprintf( tmp, "%s %ld %ld %s\n", grp, endnumber, str, mode ) ;
	fputs( tmp, new ) ;
    }
    fclose( old ) ;
    fclose( new ) ;
    unlink( wbuf ) ;
}

/************************************************/
/*						*/
/*						*/
/*						*/
/************************************************/
void CheckActive( void )
{
    FILE	*active ;
    UCHAR	grp[128] ;
    long	str, end ;
    UCHAR	mode[4] ;
    UCHAR	tmp[256] ;

    ActiveMode = 0 ;
    active = fopen( ActiveFile, "r" ) ;
    while ( fgets( tmp, 256, active ) != NULL ) {
	/* Tv: mix.system.news.main 1016 1008 y */
	sscanf( tmp, "%s %ld %ld %s", grp, &end, &str, mode ) ;
	if ( !strcmp( grp, dir ) ) {
	    if ( !strcmp( mode, "y" ) || !strcmp( mode, "m" ) )
		ActiveMode = 1 ;
	    break ;
	}
    }
    fclose( active ) ;
}

/********************************************************/
/*							*/
/*	UUPCݒǂݎ菈			*/
/*							*/
/*	KvȐݒ荀ڂǂݍ݊eϐɕۑ	*/
/*							*/
/********************************************************/
void GetConfigData( char *rcname )
{
    char	*fname, *pos ;
    FILE	*fp ;
    int		lp, find ;
    char	tmp[BUFFER_SIZE] ;

    fname = getenv( rcname ) ;
    fp = fopen( fname, "r" ) ;
    while ( fgets( tmp, BUFFER_SIZE, fp ) != NULL ) {
	/* Rgs̓XLbv */
	if ( *tmp == '#' )
	    continue ;

	/* 擪̋󔒂AsȂXLbv */
	pos = tmp ;
	while ( isspace( *pos ) ) ++pos ;
	if ( *pos == '\0' )
	    continue ;
	strcpy( wbuf, pos ) ;

	/* I̋󔒂폜 */
	pos = strstr( wbuf, "\n" ) ;
	while ( isspace( *pos ) ) --pos ;
	*(++pos) = '\0' ;

	/* RtBOʎq؂o */
	strcpy( tmp, wbuf ) ;
	if ( ( pos = strstr( tmp, "=" ) ) == NULL )
	    continue ;
	*pos = '\0' ;
	strcpy( wbuf, wbuf + ( pos - tmp ) + 1 ) ;

	/* RtBOʎq */
	for ( pos = tmp ; *pos ; ++pos )
	    *pos = ( char )tolower( *pos ) ;

	lp = find = 0 ;
	while ( Conf[lp].name != NULL ) {
	    if ( strstr( tmp, Conf[lp].name ) == tmp ) {
		find = lp + 1 ;
		break ;
	    }
	    ++lp ;
	}
	if ( !find )
	    continue ;
	--find ;

	if ( *Conf[find].value == NULL ) {
	    *Conf[find].value = malloc( strlen( wbuf ) + 1 ) ;
	} else {
	    *Conf[find].value = realloc( *Conf[find].value,
					strlen( wbuf ) + 1 ) ;
	}
	strcpy( Conf[find].value[0], wbuf ) ;
    }
}

/********************************************************/
/*							*/
/*	UUPCRtBOt@Cpϐ̊J		*/
/*							*/
/********************************************************/
void FreeUupcValue( )
{
    int		lp ;

    lp = 0 ;
    while ( Conf[lp].name != NULL ) {
	if ( *Conf[lp].value != NULL ) {
	    free( *Conf[lp].value ) ;
	}
	++lp ;
    }
}
