/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998, 1999  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    PMB # 181
    11900 Metric Blvd Ste. J
    Austin Tx 78758-3117
    pelliott@io.com
*/
#include "search.hpp"

#include "listpm.h"

SearchInfo::SearchInfo(IWindow & owner , IHelpWindow & help) :
// set up the parts.
IFrameWindow( DLG_SEARCHFORTEXT , &owner, IFrameWindow::tryDialogResource  ),
search_text_field( ENT_TEXT ,this ),
exact_box( BOX_CASE ,this ),
forward( BUT_FORWARD, this ) ,
reverse( BUT_REVERSE, this ) ,
acc( DLG_SEARCHFORTEXT, this),
fcshand(*this)
{
    // provide help for search dialog.
    help.setAssociatedWindow( this );

     // set the focus to entry field.
     search_text_field.setFocus();

     // select forward direction.
     forward.select(true); reverse.select(false);

     forward.select();
     forward.enableGroup();
     forward.enableTabStop();

     reverse.enableTabStop();

     // disable this hidden dialog till it is requested.
     disable();
                                               // do not destroy on close.
     setDestroyOnClose(false);                 // use dialog over and over.

};

Boolean SearchInfo::Exact(void)
{                                              // exact case wanted
     return exact_box.isSelected();
};
Boolean SearchInfo::DirectionForward(void)
{                                              // forward direction selected.
     return forward.isSelected();
};
SearchInfo::operator IString()
{                                              // returns entry field text.
     return search_text_field.text();
};

// called when we get focus.
bool SearchInfo::FocusHand::gotFocus( IControlEvent& ce )
{

   // if the search field already has focus, skip.
   if ( si.search_text_field.hasFocus() ) return IFocusHandler::gotFocus( ce );

   // when we get focus we post GOTFOCUS message.
   si.postEvent( control, GOTFOCUS );

   return IFocusHandler::gotFocus( ce );
};

// scans for ICommandEvent s
bool SearchInfo::FocusHand::command( ICommandEvent& ce )
{
   switch ( ce.commandId() )
   {
      // when we set a GOT FOCUS command.
      case GOTFOCUS:
      // if the search_text_field does not already have focus,,,
      if ( ! si.search_text_field.hasFocus() )
      {
         // select the range
         si.search_text_field.selectRange();
         // set the focus of the search_text_field.
         si.search_text_field.setFocus();
      };
      break;
   };
   return ICommandHandler::command( ce );
};
IString SearchInfo::GetToBeSearched(void)      // display the dialog.
{
     // highlight all the current content of entry field
     search_text_field.selectRange();

     // endable the dialog.
     enable();

     // set focus to entry field.
     search_text_field.setFocus();

     // simulate getting focus
     postEvent( command, GOTFOCUS );

     // show dialog modally.
     showModally();

     // hide and disable dialog again.
     hide();
     disable();

     return *this;
};
