/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998, 1999  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    PMB # 181
    11900 Metric Blvd Ste. J
    Austin Tx 78758-3117
    pelliott@io.com
*/
#ifndef LISTMAIN
#define LISTMAIN
#include <ithread.hpp>
#include <istring.hpp>


// List file thread.
// list.cpp defines ListThreadFn::run()
// this thread displays a file on its frame window using DisplayFile
// as defined in listrun.cpp
class ListThreadFn: public IThreadFn
{
   private:
        IString file;                          // save name of current file.
   public:
        virtual void run( void )               // runtime code does Displayfile.
        { DisplayFile(file); return;};

        // Null constructor, stores null file.
        ListThreadFn () : file() {};

        // constructor saving filename.
        ListThreadFn( IString const fn ) : file(fn) {};
};
#endif //LISTMAIN
