/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    11900 Metric Blvd #J-181
    Austin Tx 78758-3117
*/
#include "winthr.hpp"

#include <icritsec.hpp>

Boolean WindowThread::ICom::command( ICommandEvent& event )
{

     // if the event id matches
     if  ( ( event.commandId() == win_thread.eventid ) &&
           ( event.controlWindow() == &win_thread.window  ) )
     {
        // have we been notified??
        Boolean notified;
        {
          ICritSec lock;                   // lock befor checking notifing
          notified = win_thread.notifing;  // we are being notified.

          win_thread.notifing = false;     // have been notified, no more.

        };
        // if this thread is / has beeen notified.
        if (notified)
        {

          // call the finish code.
          win_thread.finish() ;    // finish processing

         };
     };
     return false;
};

// This thread code runs the window thread run code.
void WindowThread::WinThrFn::run ()
{
     wt.run();
};
      // constructor remembers IWindow and eveint id #
WindowThread::WindowThread(IWindow& window,const long eventid) :
     eventid(eventid), window(window), thread_hand( *this), notifing(false)
{

};
// start thread user call.
void WindowThread::win_th_start( Boolean auto_init )
{
    // first call begin on current thread.
    begin();


    // run thread to run thread code.
    IThread doit( new WinThrFn(*this) , auto_init );
    doit.adjustPriority(-17);
};
void WindowThread::run()
{

    // call the thread code.
    thread();

    // we are now notifing the original thread thru a command event.
    {
      ICritSec lock;
      notifing = true;
    };

    // post to declare completion.
    window.postEvent( IWindow::command, eventid );
};
