/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    11900 Metric Blvd #J-181
    Austin Tx 78758-3117
    pelliott@io.com
*/
// timshow.hpp

#ifndef TIMESHOW
#define TIMESHOW

#include <iframe.hpp>
#include <itimer.hpp>

// This class shows a window modally for a time, then closes it
// and returns after timer expires or user closes it.

// shows a window for a specified time.

class TimShow
{
    private:
        IFrameWindow&     window;       // remember window to show.
        ITimer       timer;             // timer to use.

        // closes the window when called by timer.
        void expire( unsigned long interval )
        {
             window.close();
        };

        // Allow timer system access to expire.
        friend class ITimerMemberFn<TimShow>;

    public:
        // cnsturct a TimShow
        TimShow( IFrameWindow& window):
        window(window),                // save the window.
        timer()                        // save the timer.
        {};

        ~TimShow() { timer.stop(); };  //  stop timer when destroyed.

        // show the window.
        virtual IFrameWindow& show( const unsigned long interval)
        {
             // start the timer.
             timer.start( new ITimerMemberFn<TimShow>(*this,TimShow::expire),
                          interval );

             // display the window.
             window.showModally();

             // stop the timer.
             timer.stop();

             return window;            // allow next call
        };

        // construct then start.
        TimShow( IFrameWindow& window,const unsigned long interval):
        window(window),
        timer()
        {
           show(interval);
        };
};
#endif // timeshow
