/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    11900 Metric Blvd #J-181
    Austin Tx 78758-3117
    pelliott@io.com
*/
#ifndef SEARCH
#define SEARCH
#include <iframe.hpp>

#include <ientryfd.hpp>
#include <icheckbx.hpp>
#include <iradiobt.hpp>
#include <istring.hpp>
#include <iaccel.hpp>
#include <ihelp.hpp>
#include <ihelphdr.hpp>

/*
 * this is a dialog which gets text to search for,
 * direction of search =( forward or reverse )
 * and exact case search.
 */
class SearchInfo : public IFrameWindow
{
      private:

                  // search text entry field.
                  IEntryField      search_text_field;

                  // check box specifies exact case.
                  ICheckBox        exact_box;

                  // forward,reverse radio buttons.
                  IRadioButton     forward,reverse;

                  // key board accelerator.
                  IAccelerator     acc;

      public:

                  // construct from owner. and its help window.
                  SearchInfo(IWindow & owner , IHelpWindow& help);

                  // returns exact case requested.
                  Boolean Exact(void);

                  // true if foward direction wanted.
                  Boolean DirectionForward(void);

                  // returns string to searched for.
                  operator IString();

                  // run dialog till user closes.
                  IString GetToBeSearched(void);

};
#endif // SEARCH
