/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    11900 Metric Blvd #J-181
    Austin Tx 78758-3117
    pelliott@io.com
*/
#include "search.hpp"

#include "listpm.h"

SearchInfo::SearchInfo(IWindow & owner , IHelpWindow & help) :
// set up the parts.
IFrameWindow( DLG_SEARCHFORTEXT , &owner,IFrameWindow::tryDialogResource ),
search_text_field( ENT_TEXT ,this ),
exact_box( BOX_CASE ,this ),
forward( BUT_FORWARD, this ) ,
reverse( BUT_REVERSE, this ) ,
acc( DLG_SEARCHFORTEXT, this)
{
    // provide help for search dialog.
    help.setAssociatedWindow( this );

     // set the focus to entry field.
     search_text_field.setFocus();

     // select forward direction.
     forward.select(true); reverse.select(false);

     forward.select();
     forward.enableGroup();
     forward.enableTabStop();

     reverse.enableTabStop();

     // disable this hidden dialog till it is requested.
     disable();
                                               // do not destroy on close.
     setDestroyOnClose(false);                 // use dialog over and over.

};

Boolean SearchInfo::Exact(void)
{                                              // exact case wanted
     return exact_box.isSelected();
};
Boolean SearchInfo::DirectionForward(void)
{                                              // forward direction selected.
     return forward.isSelected();
};
SearchInfo::operator IString()
{                                              // returns entry field text.
     return search_text_field.text();
};
IString SearchInfo::GetToBeSearched(void)      // display the dialog.
{
     // highlight all the current content of entry field
     search_text_field.selectRange();

     // endable the dialog.
     enable();

     // set focus to entry field.
     search_text_field.setFocus();

     // show dialog modally.
     showModally();

     // hide and disable dialog again.
     hide();
     disable();

     return *this;
};
