/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    11900 Metric Blvd #J-181
    Austin Tx 78758-3117
    pelliott@io.com
*/
// define main thread class.
// define format of work thread started by appmain.cpp
#include "appmain.hpp"
// info shared with list.cpp which runs a frame window.
#include "listrun.hpp"
#include "listthrd.hpp"       // define list threads.

#include <iapp.hpp>           // define applications stuff
#include <iexcbase.hpp>       // exception.

// define run code for main thread
// this work thread is run by appmain.cpp
// does the main work of this program, but can exit without
// killing other threads that may be started.
void MainThreadFn::run(void)
{

    // get current application
    ICurrentApplication & current = IApplication:: current();

    // link in dynamic resource library. This will allow someone
    // to configure program for other language by simply
    // compile, link and bind in another resource library dll
    // with strings in other language.
    try
    {
       current.setUserResourceLibrary("listpm");
    }
    // If we can not load resources from dynamic link library, then
    // load the resources built into the application, and user
    // will be stuck with English.
    catch (IException& exc)
    {
       current.setUserResourceLibrary( 0 );
    };

    // if no arguements, display empty file on this threads.
    if (current.argc() <2) DisplayFile();
    // else there are some arguements (files) to display.
    else
    {
       // Display all args except the last on other threads
       for ( int i =1; i < current.argc() -1 ; i++ )
       {
           // do somthing with current.argv(i) which is an IString.
           IThread list ( new ListThreadFn ( current.argv(i) ) );
           // display last file on current thread

       };
       // display last arg on current thread.
       DisplayFile( current.argv(current.argc() - 1 ) );
    };
}
