/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    11900 Metric Blvd #J-181
    Austin Tx 78758-3117
    pelliott@io.com
*/
#ifndef LIST
#define LIST

#include "listrun.hpp"         // parameters of the interface with our caller,
                               // listmain.
#include "search.hpp"          // search dialog.
#include "winthr.hpp"          // window thread processing.

                               // all open class libarary needed include files.
#include <ithread.hpp>         // uses threads.
#include <iframe.hpp>          // frame window
#include <icmdhdr.hpp>         // command handler
#include <iclipbrd.hpp>        // clipboard.
#include <imle.hpp>            // multiline edit.
#include <imsgbox.hpp>         // message box.
#include <iexcbase.hpp>        // exceptions.
#include <iinfoa.hpp>          // info area.
#include <iaccel.hpp>          // keyboard accelerator.
#include <ifiledlg.hpp>        // file dialog.
#include <ifilehdr.hpp>        // file dialog handler.
#include <imenuhdr.hpp>        // menu handler.
#include <isubmenu.hpp>        // submenus.
#include <ititle.hpp>          // title bar.
#include <ifont.hpp>           // font
#include <ifontdlg.hpp>        // font dialog.
#include <isizehdr.hpp>        // Resize handler.
#include <isizeevt.hpp>        // resize events.
#include <ihelp.hpp>           // help Window.
#include <ihelphdr.hpp>        // help window handler.
#include <i0string.hpp>        // i0string.

#include <stdlib.h>            // define calls to C libarary
#include <io.h>

/*
 * This program is not an object oriented program,
 * but a procedural one. Inheritance is used only as required to
 * define callbacks required by the interface to open class libaray.
 *
 * This program displays a window in which the listing of a file can be
 *  displayed.
 * the user can switch displayed files, display a new file in a new window
 * on another thread, control word wrap, and cut selected text to the system
 * clippboard.
 */

class ListWindowThread : public WindowThread
{
     private:

        // disable, declare but no define.
        ListWindowThread(const ListWindowThread&);
        ListWindowThread& operator=(const ListWindowThread&);

        // all varriables shared between the various search routines


        // get text to search for
        IString search_string;

        // get exact case match parameter.
        Boolean exact;

        // get direction of search.
        Boolean forward;

        IString looked_for;              // looking for this string.

        // direction sign is +- 1. direction mult is 0 or 1.
        int direction_sign,direction_mult;

        unsigned long limit;              // last line to look at.

        // search member function forward or reverse?
        // dir_search is a pointer to memeber which will be
        // setup to do the search in the correct direction
        // depending on direction. indexOf for forward.
        // last indexOf for reverse.
        unsigned (I0String::*dir_search)
           (const IString& astring , unsigned startPos ) const;

        // default value 2nd par in above depends on direction!
        unsigned start_pos;

        unsigned long current_line_no;

        unsigned long current_pos;

        unsigned long current_bol;

        unsigned offset_within_current_line;

        I0String current_line;

        // offset of cursor within 1st line.
        unsigned offset;

        I0String line;

        unsigned long line_no;

        IString saved_text;


        IInfoArea&   info;                  // info area status block

        IMultiLineEdit& mle;                // multiline editor cleint window.



     protected:
       // optional call back to user before running thread.
       virtual void begin();

       // code to run on other thread.
       virtual void thread();

       // optional call back to user after running thread.
       virtual void finish();


     public:

      // construct a windows threader to search for text.
      // save info area, mle, window, and command id to use later.
      ListWindowThread(IWindow& window,const long eventid ,
                       IMultiLineEdit& mle,
                       IInfoArea&   info)


      : mle(mle), info(info),
        WindowThread(window,eventid)
      {};
      virtual ~ListWindowThread() {};

      // initialize threaded searcher and start
      // initialize search parameters and start the thread.
      void init_and_start(
             IString& search_string_r, Boolean exact_v, Boolean forward_v)
      {
         // save the search parameters.
         search_string = search_string_r;
         exact = exact_v;
         forward = forward_v;

         // and start the thread.
         win_th_start( true );
      };
};


// Define the main frame window for the program.
// It has attacthed almost all control and call back structures attached.
class ListFrame : public IFrameWindow ,
                  // following protected handlers define call backs
                  // required by Open class library.

                  protected ICommandHandler,
                  protected IMenuHandler,
                  protected IResizeHandler,
                  protected IHelpHandler
{
   private:

      IString file_displayed;            // remember file we are dispalying

      IInfoArea   info;                  // info area status block

      IMultiLineEdit mle;                // multiline editor cleint window.

      IAccelerator acc;                   // key board accelerator,
                                          // works with menu
                                          // resources defined by URE.

      ITitle title;                       // Title for our window.

      IHelpWindow  help;                  // is there help for us?


      SearchInfo         search_dialog;   // dialog to get search information.

      // starts threads for searching.
      ListWindowThread   win_thread;       // window thread caller.


      // disable default constructor, assignment op.
      ListFrame(const ListFrame&);
      ListFrame& operator=(const ListFrame&);

      unsigned long import( const char * file);
                                            // import after checking format.
      void setTaskList( const IString& myFile );
                                            // set task list

   public:


      // return currently  displayed file.
      IString file(void) const { return file_displayed; };

      ListFrame(const IString file);      // construct ourselves from filename.
      virtual ~ListFrame()
      {
//        close();
      };

   protected:

      // command handler, handles all ICommandEvents for our window.
      // called when user selects an item or accelerator command.

      virtual Boolean command( ICommandEvent& event );


      // This menu handler gets control when Word wrap submenu is activated.
      // inusres right option is checked.

      virtual Boolean menuShowing ( IMenuEvent& event,ISubmenu& submenu);


      // resize event handler, catches user resizeing frame window,
      // storing new size.

      virtual Boolean windowResize(IResizeEvent& evt);

      // returns panel id.
      virtual Boolean keysHelpId(IEvent& evt);

};
#endif   //LIST
