/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    11900 Metric Blvd #J-181
    Austin Tx 78758-3117
    pelliott@io.com
*/
#include "isdir.hpp"
#include <sys\types.h>
#include <sys\stat.h>

// returns true if indicated file is determined to be a directory.
Boolean IsDir(const IString& str)
{
     struct stat our_stat;
     if ( stat( str, &our_stat) ) return false;

     return ( ( our_stat.st_mode & S_IFDIR) ? true : false );
};
