/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    11900 Metric Blvd #J-181
    Austin Tx 78758-3117
    pelliott@io.com
*/
#ifndef GLBFONT
#define GLBFONT
#include <ifont.hpp>

#include "AProfile.hpp"

// This object saves and restores IFonts.
// could not use the Template tecnique for light weight
// persistance because face name is varriable lengh.
// do it the simple way using profiles.

class ExternalFont
{
    private:
          AProfile profile;               // profile to save get profiles.

          // character strings.
          static const char * const face_name;//        =         "faceName";
          static const char * const point_size;//       =         "pointSize";
          static const char * const use_fixed_font;//   =         "useFixedFont";
          static const char * const use_vector_font;//  =         "useVectorFont";
    public:


       // construct from another profile or from a file id in user profile.
       ExternalFont(const AProfile& old_profile) : profile(old_profile) {};
       ExternalFont() : profile("listpm","application_ini") {};

       // returns if the font is stored in the profile.
       Boolean FontExistsExternally(void)
       {
            return
               profile.containsKeyName(face_name)         &&
               profile.containsKeyName(point_size)        &&
               profile.containsKeyName(use_fixed_font)    &&
               profile.containsKeyName(use_vector_font)   ;
       };

       // construct a font from the info stored in the profile.
       operator IFont() const
       {
            IString face   = profile.elementWithKey(face_name);
            long    point  = profile.integerWithKey(point_size);
            long    fixed  = profile.integerWithKey(use_fixed_font);
            long    vector = profile.integerWithKey(use_vector_font);

            return IFont( face, point, Boolean(fixed), Boolean(vector) );
       };

       // store the font info to the profile.
       ExternalFont& operator<<(const IFont& font)
       {
            profile.addOrReplaceElementWithKey(face_name,font.name() );
            profile.addOrReplaceElementWithKey(point_size,font.pointSize() );
            profile.addOrReplaceElementWithKey(use_fixed_font,font.isFixed() );
            profile.addOrReplaceElementWithKey(use_vector_font,font.isVectorOnly() );

            return *this;
       };
};
#endif // GLBFONT
