/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    11900 Metric Blvd #J-181
    Austin Tx 78758-3117
    pelliott@io.com
*/
#ifndef APROFILE
#define APROFILE
#include <istring.hpp>
#include <iprofile.hpp>

// an application profile is a regular profile which
// is found (constructed) via the user profile.
// constructor specifies the application name and a file key
// which are used to find the application profile file using
// the system wide user profile.
class AProfile : public IProfile
{
    private:

        // private static gets the filename of the application profile
        // from the 2 parameters.
        static IString ApplicationProfileName(const IString& app_name,
                                              const IString& profile_name_key);
    public:
        // same constructors as IProfile.
        AProfile(const IProfile& profile) : IProfile(profile) {};
        AProfile(const AProfile& profile) : IProfile(profile) {};
        AProfile(const char * pname) : IProfile( pname ) {};


        // construct an application profile from an application name,
        // and key application file name.
        AProfile(const IString& app_name,const IString& profile_name_key);
};

#endif // APROFILE
