/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1998  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    11900 Metric Blvd #J-181
    Austin Tx 78758-3117
    pelliott@io.com
*/
#include <io.h>
#include <iapp.hpp>
#include "AProfile.hpp"

// get file spec of an application file name.
// We try to get location of the user profile from the OS/2
// user profile using the indicated profile_name_key.
// If the key does not exist we create the profile in
// the directory that the application exists in as indicated
// by argv.
IString AProfile::ApplicationProfileName(const IString& app_name,
                                              const IString& profile_name_key)
{
    // reserve space for answer.
    IString appl_profile;
    {
        // ger user profile.
        IProfile user=IProfile::userProfile();

        // set the application name.
        user.setDefaultApplicationName(app_name);

        // if the application file name key exists.....
        if ( user.containsKeyName(profile_name_key) &&
            (  access( user.elementWithKey(profile_name_key) , 04) == 00 )
           )
        {
            // then use that data stored in user profile.
            appl_profile = user.elementWithKey(profile_name_key);
        }
        else            // if not in application profile, make up a file name.
        {
            // place to store full name.
            char full[_MAX_PATH];

            // full name of application name =argv[0].
            _fullpath(full,IApplication::current().argv(0),sizeof(full) );

            // split application name into parts.
            char drive[_MAX_DRIVE],dir[_MAX_DIR],fname[_MAX_FNAME],ext[_MAX_EXT];
            _splitpath(full,drive,dir,fname,ext);

            // and put it back together  with extension = ".ini"
            char ini_name[_MAX_PATH];
            _makepath(ini_name,drive,dir,fname,".ini");

            // this is the profile name.
            appl_profile = ini_name;


            // store it in user profile.
            user.addOrReplaceElementWithKey(profile_name_key,appl_profile);
        };
    };
    return appl_profile;          // return application profile file spec.
};

// construct the application profile from the filename specified above.
AProfile::AProfile(const IString& app_name,const IString& profile_name_key)  :
IProfile(AProfile::ApplicationProfileName(app_name,profile_name_key) )
{
    // set the application name in the opened profile.
    setDefaultApplicationName(app_name);
};
