/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1996  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    3987 South Gessner #224
    Houston Tx 77063
    Paul.Elliott@Hrnowl.LoneStar.Org
*/
#include "search.hpp"

#include "listpm.h"


SearchInfo::SearchInfo(IWindow & owner) :
IFrameWindow( DLG_SEARCHFORTEXT , &owner,IFrameWindow::tryDialogResource ),
canvas(CAN_MAIN,this,this),
search_text_field( ENT_TEXT ,&canvas , &canvas ),
horz_canvas( CAN_HOR ,&canvas,&canvas),
exact_box( BOX_CASE ,&horz_canvas, &horz_canvas),
vert_canvas( CAN_VERT, &horz_canvas, &horz_canvas ),
forward( BUT_FORWARD, &vert_canvas, &vert_canvas) ,
reverse( BUT_REVERSE, &vert_canvas, &vert_canvas )
{
     cmd_hand.handleEventsFor(this);
     setClient(&canvas);
     canvas.setDeckOrientation(ISetCanvas::vertical);

     search_text_field.setFocus();

     search_text_field.setText(STR_ENTRYTITLE);

     horz_canvas.setDeckOrientation(ISetCanvas::horizontal);

     vert_canvas.setDeckOrientation( ISetCanvas::vertical );

     forward.select(true); reverse.select(false);

     exact_box.setText(STR_EXACTCASE);
     forward.setText(STR_FORWARD);
     reverse.setText(STR_REVERSE);

     disable();
                                               // do not destroy on close.
     setDestroyOnClose(false);                 // use dialog over and over.

};
Boolean SearchInfo::Exact(void)
{
     return exact_box.isSelected();
};
Boolean SearchInfo::DirectionForward(void)
{
     return forward.isSelected();
};
SearchInfo::operator IString()
{
     return search_text_field.text();
};
IString SearchInfo::GetToBeSearched(void)
{
     search_text_field.selectRange();
     enable();
     showModally();
     hide();
     disable();

     return *this;
};
Boolean SearchInfo::SearchCommand::command(ICommandEvent& event)
{
     if ( event.eventId() ==  ENT_TEXT )
        ( (IFrameWindow*) event.dispatchingWindow()) -> dismiss();
     return false;
};
