/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1996  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    3987 South Gessner #224
    Houston Tx 77063
    Paul.Elliott@Hrnowl.LoneStar.Org
*/
#ifndef ONEOF
#define ONEOF


// class template to allocate One of a given object, which must have
// default constructor which is used to allocate.
// the one object is created when the first reference is
// gotten. Destroyed when the template class is destroyed.
// this class should be used when you want 1 object, but it
// can not be constructed at initialization time( by being a global or
// static object) , because proper context is not set up yet or initialization
// order problems.
template <class object>
class OneOf
// One of this object.
{
     private:
         // pointer to the one object.
         object *     pointer;
     public:
         // the one object must be destroyed once.
         // C++ says delete 0 is OK!
         ~OneOf() { delete pointer; pointer =0; };
         // not initialized immeadiately.
         OneOf() : pointer(0) {};

         // return a reference to the one object
         // construct if first.
         operator object& ()
         {
               if ( pointer == 0) pointer = new object;

               return *pointer;
         };
};
#endif   // ONEOF
