/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1996  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    3987 South Gessner #224
    Houston Tx 77063
    Paul.Elliott@Hrnowl.LoneStar.Org
*/
#ifndef SEARCH
#define SEARCH
#include <iframe.hpp>
#include <isetcv.hpp>
#include <ientryfd.hpp>
#include <icheckbx.hpp>
#include <iradiobt.hpp>
#include <istring.hpp>
#include <icmdhdr.hpp>


class SearchInfo : public IFrameWindow
{
      private:
                  ISetCanvas       canvas;
                  IEntryField      search_text_field;
                  ISetCanvas       horz_canvas;
                  ICheckBox        exact_box;
                  ISetCanvas       vert_canvas;
                  IRadioButton     forward,reverse;
      public:

                  SearchInfo(IWindow & owner);
                  Boolean Exact(void);
                  Boolean DirectionForward(void);

                  operator IString();

                  IString GetToBeSearched(void);

                  class SearchCommand : public ICommandHandler
                  {
                     virtual Boolean command(ICommandEvent& evt);
                  } cmd_hand;

};
#endif // SEARCH
