/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1996  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    3987 South Gessner #224
    Houston Tx 77063
    Paul.Elliott@Hrnowl.LoneStar.Org
*/
#ifndef LTPER
#define LTPER
// This Abstract Base Class define a mechinism to
// move raw memory to and from some sort of abstract
// external memory store.

class ToStorage
{
  public:
     virtual void read ( char * buf,int count) = 0;
     virtual void write (const char * buf,int count) = 0;
     virtual Boolean isInStorage(void) = 0;
     virtual ~ToStorage() {};
};

// In order for an "object" to be light weight persistant,
// it must be mapable to "essance" of just plain data. That is something
// that can be copied bytewise (without loosing underlying meaning
// if any) and having no pointers (including vtbl pointers from
// virtual members) or other connection to the world outside.


// In what follows, it must be possible to construct "object"
// from its essance (Just Plain Data). Also, "object" must
// return a reference to its essance.

template<class object,class essance>
class ExternalExistance
{
     private:
        // reference to raw storage interface.
        ToStorage& storage;

        // returns a essance read form external.
        operator essance()
        {
            essance essance_instance;

            char * str = (char*) &essance_instance;
            storage.read( str, sizeof(essance_instance) );
            return essance_instance;
        };

     public:
        // true if indicated object exists externally.
        Boolean ExistsExternally()
        {
            return storage.isInStorage();
        };

        // construct self from a ToStorage
        ExternalExistance(ToStorage& stor) : storage(stor)
        {};

        // destructor.
        virtual ~ExternalExistance() {};

        // write the indicated object to external storage.
        ExternalExistance<object,essance> &
                     operator<<(const object& obj_instance)
        {
            // get the essance of the object.
            const essance& essance_instance = (const essance&)obj_instance;

            // convert the essance to bytes.
            const char * str = (const char*) &essance_instance;

            // write the essance bytes to external.
            storage.write(str,sizeof(essance) );

            // done.
            return *this;
        };

        // The class Created is identical to object except it can be
        // created from external storage. Works because object
        // can be created from essance.
        class Created : public object
        {
          public:
            // constructor. Create essance from external store.
            // create object=Created from essance.
            Created(ExternalExistance<object,essance> & exist)  :
               object( essance(exist) )
            {};
        };
        // Created constructor can use ExternalStorage to construct
        // an essance.
        friend Created::Created(ExternalExistance<object,essance> & exist);
};

// In the above template object must be a class.
// otherwise compile error. To get around this for builtin types
// such as int or char, we provide the following template.
// which creates a class=struct really which embodies a builtin
// type for the purpose of ExternalExistance.
template <class X>
struct BuiltIn
{
      X   built_in;
      operator X() const { return built_in; };
      BuiltIn(const X& built_in) : built_in(built_in) {};
};


#endif // LTPER
