/*
    listPM list files under Presentation Manager. Uses Open Class Libarary.
    Copyright (C) 1996  Paul Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Paul Elliott
    3987 South Gessner #224
    Houston Tx 77063
    Paul.Elliott@Hrnowl.LoneStar.Org
*/
#ifndef GLBWRAP
#define GLBWRAP

#include <ibase.hpp>

#include "Ltper.hpp"
#include "LtProf.hpp"

// make int into a trivial class for External Existance.
typedef BuiltIn<int> CBoolean;

// External Existance which holds Booleans indicating word wrapping.
typedef ExternalExistance<CBoolean,Boolean> ExternalBoolean;

class ExternalWrap

{
      private:
                 ProfStorage         storage;
                 ExternalBoolean     wrap_existance;
      public:
                 // construct source of external storage
                 ExternalWrap() :
                     storage("listpm","application_ini","word_wrap"),
                     wrap_existance(storage)
                 {
                 };
                 virtual ~ExternalWrap() {};              // destructor

                 // returns true when key exists in profile.
                 Boolean wrapExternal(void)
                 { return wrap_existance.ExistsExternally(); };

                 // get WW option stored externally.
                 operator Boolean()
                 {
                    ExternalBoolean::Created created(wrap_existance);
                    CBoolean& it = created;
                    return it;

                 };

                 // Store Boolean in profile.
                 ExternalWrap& operator<<(const Boolean& size)
                 {
                    CBoolean wsize(size);
                    wrap_existance << wsize;
                    return *this;
                 };


};
#endif // GLBWRAP
