.* This file converted from BookMaster using BM2IPF version 2.4.1.
.* File for IPF version 1.0.
.* File for code page 850.
:userdoc.
:docprof toc=123456 .
:title.IPFC Preprocessor
.***
:h1 id=BM1.Changes
:p.
.***
:h2 id=BM2.Version 2.1
:p.
All changes for release 2.0 are marked with a 'B'.
:ul.
:li.Change documentation and code for external release.
:li.Increased the size of initial symbol text from 120 to 250.
:li.Changed it so that #define values that are a single value do not convert
from hex to decimal or from octal to decimal, but rather leave the expression
as it is.
:eul.
.***
:h2 id=BM3.Version 2.0
:p.
All changes for release 2.0 are marked with a 'A'.
:ul.
:li.Fixed a bug where macros were case sensitive and aliasing did not work.
Macro names are now case insensitive.
:li.Fixed a bug in nested config sections. Two nested configuration sections
in a row were not working. The second section was being deleted if the first
section was deleted. It now works properly.
:li.Added support for #ifdef and #ifndef. #if and #elif are ignored.
:li.Added a message for recursive macro and symbol expansion to eliminate the
stack overflow problem.
:eul.
.***
:h2 id=BM4.Version 1.9
:p.
All changes for release 1.9 are marked with a '9'.
:ul.
:li.Fixed a bug where periods in symbols strings were considered end of symbol
or macro they were imbedded in.
:eul.
.***
:h2 id=BM5.Version 1.8
:p.
All changes for release 1.8 are marked with a '8'.
:ul.
:li.Added support for nested include files
:li.Added support for not including system include files (/S)
:li.Added support for strings within string like "The string 'string'"
:li.Fixed a bug where comments on C include files caused errors.
:eul.
.***
:h2 id=BM6.Version 1.7
:p.
All changes for release 1.7 are marked with a '7'.
:ul.
:li.Added expression evaluation support for C .H files.
:eul.
.***
:h2 id=BM7.Version 1.6
:p.
All changes for release 1.6 are marked with a '6'.
:ul.
:li.Added /N switch to NOT resolve bitmap paths.
:li.Allowed for simple recursive symbols in C files.
:eul.
.***
:h2 id=BM8.Version 1.5
:p.
All changes for release 1.5 are marked with a '5'.
:ul.
:li.Partially resolved nested symbols leave partial result instead
of original symbol.
:li.All output goes to stdout instead of stderr.
:eul.
.***
:h2 id=BM9.Version 1.4
:p.
All changes for release 1.4 are marked with a '4'.
:ul.
:li.Added /V option to display lines as they are read in
:li.Fixed nested symbol infinite loop.
:eul.
.***
:h2 id=BM10.Version 1.3
:p.
All changes for release 1.3 are marked with a '3'.
:ul.
:li.Allowed nested symbols (symbols within symbols).
:li.Allowed positional parameters on macros.
:li.Strip double quotes off of C #define symbols so they can be used
as normal substitution variables.
:li.Resolve bitmap file paths so that bitmaps can be in a seperate
directory pointed to by the INCLUDE environment variable.
:eul.
.***
:h2 id=BM11.Version 1.2
:p.
All changes for release 1.2 are marked with a '2'.
:ul.
:li.Allowed script tags for macro definitions so that the IPFCPREP macros
will print under Bookie.
:eul.
.***
:h2 id=BM12.Version 1.1
:p.
All changes for release 1.1 are marked with a '1'.
:ul.
:li.Added /W &amp. -W to allow warning messages (default is now NO warning msgs)
:li.Added ability to use /D along with -D
:li.Fixed problem with command line definitions.
:li.Fixed a bug with large number of files (I forgot to close files when I
was finished with them).
:eul.
.***
:h1 id=OV.Overview
:p.
.***
:h2 id=BM14.What IPFCPREP does for you.
:ul.
:li.Allows you to have IPFC script files in different subdirectories.
:p.The IPFCPREP program will look at the INCLUDE environment variable as it
processes the imbed (&period.im) tags so that it can search more than the
current
subdirectory for script files.
:li.Allows you to define symbols.
:p.The IPFCPREP program allows the use of BookMaster .nameit tags with the
symbol= and text= parameters.
:li.Allows you to use C language header files to define symbols.
:p.The IPFCPREP program will read in C language header files and use the
#define statements as BookMaster .nameit tags.
:li.Allows you to have conditional compile sections
:p.The IPFCPREP program supports BookMaster Vanilla conditional compiles.
:li.Allows you to have simple substitution macros.
:p.The IPFCPREP will support the .dm tag to define simple macros that are
used for text replacement only.
Either keyword or positional parameters may be used.
:li.Resolves bitmap file names to fully qualified path name.
:p.Currently IPF requires the bitmap files be in the current directory.
If multiple versions of a file are produced in different subdirectories,
the bitmaps must be copied into every subdirectory. IPFCPREP will resolve
the bitmap file's position using the INCLUDE environment variable and
replace the bitmap file's name with a fully qualified path name in the
artwork tag. It will also resolve the artwork linkfile's name.
:eul.
.***
:h2 id=BM15.Running IPFCPREP
:p.To run the IPFC preprocessor, type on the command line
:xmp.
IPFCPREP input_file_name output_file_name &lbracket.-V&rbracket. &lbracket.-W&rbracket. &lbracket.-D symbolname&lbracket.=symbol_text&rbracket.&rbracket.
:exmp.
:dl compact tsize=20.
:HP2.
:dthd.Name
:ddhd.Definition
:EHP2.
:dt.input_file_name
:dd.Input script file
:dt.output_file_name
:dd.Output script file
:dt./V, -V, /v, or -v
:dd.Flag to indicate you want lines printed out as they are read in
:dt./W, -W, /w, or -w
:dd.Flag to indicate you want additional warning messages.
:dt./D, -D, /d, or -d
:dd.Flag to indicate a symbol definition
:dt./N, -N, /n, or -n
:dd.Flag to indicate a symbol definition
:dt./S, -S, /s, or -s
:dd.Flag to indicate not to include system include files, i.e. files that
are enclosed by '<' &amp. '>'.
:dt.symbolname
:dd.Name of symbol to be defined
:dt.symbol_text
:dd.Text of defined symbol.
:p.This is optional. If no symbol_text is defined, the symbol is put in the
symbol table with no text (ex&colon. for use on conditional compiles). If text is
defined, it can either be a single word or multiple words inclosed in
single quotes.
:edl.
.***
:h3 id=BM16.Examples
:p.The following will preprocess the test.scr file into the test.ipf file.
:xmp.
ipfcprep test.scr test.ipf
:exmp.
:p.The following will preprocess the test.scr file into the test.ipf file
and define one symbol called HOST.
:xmp.
ipfcprep test.scr test.ipf -D HOST
:exmp.
:p.The following will preprocess the test.scr file into the test.ipf file
and define one symbol called HOST with the text Mainframe.
:xmp.
ipfcprep test.scr test.ipf -D HOST=MainFrame
:exmp.
:p.The following will preprocess the test.scr file into the test.ipf file
and define one symbol called HOST with the text IBM Mainframe.
:xmp.
ipfcprep test.scr test.ipf -D HOST='IBM MainFrame'
:exmp.
:p.The following will preprocess the test.scr file into the test.ipf file,
define one symbol called HOST with the text IBM Mainframe, and define a
symbol called PC
:xmp.
ipfcprep test.scr test.ipf -D HOST='IBM MainFrame' -D PC
:exmp.
:p.The following will preprocess the test.scr file into the test.ipf file,
define one symbol called HOST with the text IBM Mainframe, define a
symbol called PC and turn on those annoying warning messages.
:xmp.
ipfcprep test.scr test.ipf -D HOST='IBM MainFrame' /D PC /W
:exmp.
.***
:h1 id=BM17.Reference
:p.
.***
:h2 id=BM18.Imbedding Files from Other Subdirectories
:p.
To have the IPFC preprocessor pull in imbedded files from other
subdirectories, set up the INCLUDE environment variable with the path(s) to
search.
:p.IPFCPREP will also resolve the bitmap name or linkfile name in an artwork
tag using the INCLUDE environment variable.
This can be turned off using the /N switch on the command line.
.***
:h3 id=BM19.Example
:p.After the include environment variable is set as shown by the following
command,
the IPFCPREP will search the C&colon.\HELPDIR1 &amp. C&colon.\HELPDIR2 subdirectories after
checking the current subdirectory for an imbed file.
:xmp.
SET INCLUDE=C&colon.\HELPDIR1;C&colon.\HELPDIR2;
:exmp.
:p.For artwork tags, resolving will make a artwork tag that looks like
:xmp.
&colon.artwork name='IPFCPREP.BMP' linkfile='IPFCPREP.LNK'.
:exmp.
:p.
into a tag that looks like
:xmp.
&colon.artwork name='C&colon.\HELPDIR1\IPFCPREP.BMP' linkfile='C&colon.\HELPDIR1\IPFCPREP.LNK'.
:exmp.
.***
:h2 id=BM20.Defining Symbols
:p.
To define symbols, use the same method as in BookMaster with .nameit tags.
IPFCPREP does not allow the GMLTYPE or SIZE parameters however. If you want
those, you must create a simple macro described later.
:p.
To use the symbol in the file, put an ampersand (&amp.) before the symbol
and a period (&period.) after it. The period after the symbol is required.
:p.
Symbols may be within symbols (nested symbols). The innermost symbol will
be resolved first and then the resulting text will be used to search for the
remaining symbol.
:p.
Currently, the maximum symbol size after everything is resolved is about
250 character bytes.
.***
:h3 id=BM21.Examples
:p.
The following line will create a symbol called goofy and a symbol called
MM with the text for the first being 'Goofy' and the second being 'Mickey
Mouse'.
:xmp.
&period.nameit symbol=goofy text='Goofy'
&period.nameit symbol=MM text='Mickey Mouse'
:exmp.
:p.Now if those are used in the following sentences
:xmp.
I went to Disney World and saw &amp.goofy. and &amp.MM..
:exmp.
:p.The text will come out like
:xmp.
I went to Disney World and saw Goofy and Mickey Mouse.
:exmp.
:p.
The following demonstrates the use of nested symbols.
:xmp.
&period.nameit symbol=mightm text='Mighty Mouse'
&period.nameit symbol=mickm text='Mickey Mouse'
:exmp.
:p.Now if those are used in the following sentence
:xmp.
I went to Disney World and saw  &amp.&amp.mouse_name.m..
:exmp.
:p.The text will come out like
:xmp.
I went to Disney World and saw Mickey Mouse.
:exmp.
:p.
when &amp.mouse_name. is set to 'mick', or it will come out like
:xmp.
I went to Disney World and saw Mighty Mouse.
:exmp.
:p.
when &amp.mouse_name. is set to 'might'.
.***
:h2 id=BM22.Using C Language define files
:p.
To use symbols in a C language header files, you must use the .imd tag to
imbed the header file. Then all defines of the form
:xmp.
#define symbol_name integer_value
:exmp.
or
:xmp.
#define symbol_name "string"
:exmp.
or
:xmp.
#define symbol_name2 symbol_name1
:exmp.
or
:xmp.
#define symbol_name expression
:exmp.
:p.
will be put into the symbol table.
:p.The integer version is mainly used in defining the resource id on a
&colon.h1&period. tag so that you can have one file define your panel
resource IDs.
:p.The string version is used to define text symbols similar to .namemit
tags. Wherever symbol_name is used the string (without the double quotes)
will be substituted. This is useful in using the same string that is in
a .MRI file in the text for a help panel to eliminate differences.
:p.The symbol set to another symbol is a method to assign the same value
to two different symbol names. If the value after a symbol name matches any
previously defined symbol name (whether it be C #defines or .nameit tags)
the value of the previously defined symbol will be used.
:p.The symbol set to an expression is commonly used in C header files to base
all symbols off of one with an offset such as the following&colon.
:xmp.
#define START   1000
#define PANEL_1 (START + 1)
#define PANEL_2 (START + 2)
:exmp.
:p.
IPFCPREP will allow the +, -, *, and / operators. It will evaluate expressions
from left to right without regard to operator precedence. If you want
precedence, you can use parentheses.
:p.This will also search all subdirectories defined by the INCLUDE
environment variable after searching the current directory for the
specified file.
:p.An include file can include other include files defined by the #include
compiler directive. You can disable the including of system include files
by using the :HP2./S:EHP2. command line option. This will not include
any #include file that is enclosed in '< >'.
:p.Currently, the maximum symbol size after everything is resolved is about
120 character bytes.
:p.IPFCPREP now supports some compiler directives, namely, #ifdef and #ifndef.
IPFCPREP will determine if the symbol referenced by these lines exists or not
and process or not process the lines that follow. #else used with #ifdefs or
#ifndefs is also allowed.
:p.IPFCPREP does not handle the #if or #elif lines currently due to IPFCPREP's
lack of logical expression evaluation. #else used with #if or #elif is
ignored also.
.***
:h3 id=BM23.Example
:p.To include the 'test.h' C language define file in the document use the
following line in the script file
:xmp.
&period.imd test.h
:exmp.
:p.Now if the C header file had the statement
:xmp.
#define HELP_PANEL_1 100
:exmp.
:p.And the script file contained the line
:xmp.
&colon.h1 res=&amp.HELP_PANEL_1&period..
:exmp.
:p.The preprocessor will resolve it to
:xmp.
&colon.h1 res=100.
:exmp.
.***
:h2 id=BM24.Using Bookmaster 2.0 Vanilla conditional compiles
:p.The best reference for this is the BookMaster document, but I will put a
short exerpt here.
:p.The conditional compiles use two main tags, the &period.CONFIG &amp. &period.WHEN tags.
&period.CONFIG tags start and end conditional compile sections and the &period.WHEN tags
instruct the preprocessor to insert or delete lines based on a conditions.
:p.The &period.CONFIG tag looks like
:xmp.
&period.CONFIG config_name ON ! OFF
:exmp.
:p.
The config_name is used to match the ON and OFF statements. Nested config
statements are allowed.
:p.The &period.WHEN tag looks like
:xmp.
&period.WHEN 'condition-expression' INSERT ! DELETE
:exmp.
:p.
The condition-expression is a symbol or group of symbols that are defined
or not defined to determine if the expression is TRUE. This may take the
form of
:xmp.
'symbol1 symbol2 ... symboln'
:exmp.
:p.
which will AND the symbols together or
:xmp.
'symbol1 or symbol2 or ... or symboln'
:exmp.
:p.
which will OR the symbols together. Symbols may also be negated such as
:xmp.
'not symbol1 or symbol2'
:exmp.
:p.When the condition is TRUE, the lines following the .WHEN line are
either inserted or deleted depending on the INSERT or DELETE following the
conditional expression. If the conditional-expression is FALSE, the
opposite operation is performed, i.e. lines will be deleted if INSERT is
specified and lines will be inserted if DELETE is specified.
.***
:h3 id=BM25.Example
:p.For example, the conditional compile
:xmp.
&period.config section1 on
&period.when 'PC' insert
This is processed on a PC.
&period.when 'HOST' insert
This is processed on the big iron.
&period.config section1 off
:exmp.
:p.
will produce 'This is processed on a PC.' when IPFCPREP is
invoked like
:xmp.
ipfcprep in.scr out.ipf -D PC
:exmp.
:p.
and will produce 'This is processed on the big iron.' when IPFCPREP is
invoked like
:xmp.
ipfcprep in.scr out.ipf -D HOST
:exmp.
.***
:h2 id=BM26.Using Simple Macros
:p.Macros in the IPFCPREP is a simple way to substitute lines of text
for a single tag. This does not do any math or fancy macro stuff, just
simple text substitution.
:p.Macros start with a '.dm macro-name on' tag and end with a '.dm off'
tag. All text between the those two lines is part of the macro.
:p.The macro is invoked by specifying a colon (&colon.), the macro name,
any parameters, and finally a period (&period.). The period at the end of
the macro is required.
.***
:h3 id=BM27.Example
:p.For example, the macro
:xmp.
&period.dm testmac on
This macro prints out &amp.text. when invoked
&period.dm off
:exmp.
:p.
will produce
:xmp.
This macro prints out garbage when invoked.
:exmp.
:p.
when it is called like
:xmp.
&colon.testmac text=garbage.
:exmp.
:p.
It will also produce
:xmp.
This macro prints out tons of garbage when invoked.
:exmp.
:p.
when it is called like
:xmp.
&colon.testmac text='tons of garbage'.
:exmp.
:p.
Another example, the macro
:xmp.
&period.dm user_resp on
&colon.hp1.&amp.resp.&colon.ehp1.
&period.dm off
:exmp.
:p.
will produce
:xmp.
The user response is &colon.hp1.Quit&colon.ehp1..
:exmp.
:p.
when it is called like
:xmp.
The user response is &colon.user_resp resp=Quit..
:exmp.
.***
:h2 id=BM28.Using Simple Macros that can be used in BookMaster
:p.To make these macros work under BookMaster, you must structure the macro
slightly different. You must
:ul.
:li.Add a '.gs attval parm_keyname_1 parm_keyname2 ...' line after the
'.dm macro_name' line so that the values are assigned in BookMaster.
:li.Add a '.aa tag_name start_macro_name end_macro_name' after the
'.dm off' line so that you can reference the macros start_macro_name
and end_macro_name by &colon.tag_name. &amp. &colon.etag_name.
:li.Make sure all substitution variables on the tag line are used
in uppercase.
:eul.
.***
:h3 id=BM29.Example
:p.For example, the macro
:xmp.
&period.dm testmac on
&period.gs attval text
This macro prints out &amp.TEXT. when invoked
&period.dm off
&period.aa test testmac
:exmp.
:p.
will produce
:xmp.
This macro prints out garbage when invoked.
:exmp.
:p.
when it is called like
:xmp.
&colon.test text=garbage.
:exmp.
:p.
It will also produce
:xmp.
This macro prints out tons of garbage when invoked.
:exmp.
:p.
when it is called like
:xmp.
&colon.test text='tons of garbage'.
:exmp.
:p.
Another example, the macro
:xmp.
&period.dm strtlist on
&colon.ul.
&period.dm off

&period.dm endlist on
&colon.eul.
&period.dm off

&period.aa list strtlist endlist

&period.dm listitem on
&colon.li.
&period.dm off

&period.aa item listitem

:exmp.
will produce
:xmp.
&colon.ul.
&colon.li.Text
&colon.eul.
:exmp.
:p.
when it is called like
:xmp.
&colon.list.
&colon.item.Text
&colon.elist.
:exmp.
.***
:h2 id=BM30.Using Positional Parameters on Macros
:p.Positional parameters *, and *1 throught *n may be used in macros instead
of keyword parameters.
.***
:h3 id=BM31.Example
:p.For example, the macro
:xmp.
&period.dm posmac on
All parms are &colon.*..
This is the first parm = &amp.*1..
This is the second parm = &amp.*2..
This is the third parm = &amp.*3..
This is the fourth parm = &amp.*4..
&period. off
:exmp.
:p.
will produce
:xmp.
All parms are Mickey Mouse loves Minnie.
This is the first parm = Mickey.
This is the second parm = Mouse.
This is the third parm = loves.
This is the fourth parm = Minnie.
:exmp.
:p.
when it is called like
:xmp.
&colon.posmac Mickey Mouse loves Minnie.
:exmp.
:p.
It will also produce
:xmp.
All parms are Mickey Mouse loves nobody.
This is the first parm = Mickey.
This is the second parm = Mouse.
This is the third parm = loves.
This is the fourth parm = nobody.
:exmp.
:p.
when it is called like
:xmp.
&colon.posmac Mickey Mouse loves nobody.
:exmp.
:euserdoc.
