COMPILE IF NOT DEFINED (HTMLKEYS_INCLUDED)
define HTMLKEYS_INCLUDED = ''  -- prevents problems from multible inclusions
include 'htmlconst.e'



 compile if not defined (INCLUDING_WEBOPTIONS)
include 'weboptions.e'
 compile endif
include 'stdconst.e'
const										-- These are the defaults
 compile if not defined(HTML_URL_KLUDGE)
	HTML_URL_KLUDGE=1
 compile endif
 compile if not defined(HTML_IF_ARG_BLANK)
	HTML_IF_ARG_BLANK='exit'
 compile endif
 compile if not defined(JAVA_HTML_BROWSER)
	JAVA_HTML_BROWSER='explore -q'
 compile endif
 compile if not defined(NEWLINE_AFTER_BR)
	NEWLINE_AFTER_BR=1
 compile endif
HTML_EXTENSIONS='HTM HTML htm html xtml XTML'


defload
	universal load_ext, kase
	if wordpos(load_ext, HTML_EXTENSIONS) then	-- Determine if it is an HTML file
		kase=1
		tArrName=translate(.filename, '__-', '\:.')
		do_array 1, arrayID, tArrName
		.userstring=arrayID
		uPath=.filename
		uPath=translate(uPath, '/', '\')
		uPath=leftstr(uPath, lastPos('/', Upath))
		setFileArrEl('U_PATH', uPath)
		keys HTML_KEYS					-- Load HTML keys
		call addHTMLmenu()
		'loadFileArr'
	endif
	if wordpos(load_ext, 'XTML xtml') then
		'toggle_parse 1 epmkwds.htm'
	endif

defkeys HTML_KEYS OVERLAY					-- Define HTML keys
	def '!'-'~'    =
		if lastkey(2) = 0 then
			return
		else
			if check_mark_on_screen() then
				deletemark
			endif
		keyin lastkey()
		endif
	def C_TAB	=call tabber()
	def S_TAB	=call back_tabber()
	def F2 =
		'Address_tags'
	def F3 =
		'Blockquote_tags'
	def F4 =
		'Center_tags'
	def F5 =
		'Div_tags'
	def F6 =
		'Rule_tags'
	def F7 =
		'Paragraph_tags'
	def F8 =
		'Preform_tags'
	def C_F1
		'Citation_Tags'
	def C_F2
		'Code_Tags'
	def C_F3
		'Definition_Tags'
	def C_F4
		'Emphasis_tags'
	def C_F5
		'Keyboard_tags'
	def C_F6
		'Sample_Tags'
	def C_F7
		'Strong_Tags'
	def C_F8
		'Variable_tags'
	def S_F2 =
		'Bold_Tags'
	def S_F3 =
		'Big_Tags'
	def S_F4 =
		'Font_Tags'
	def S_F5 =
		'Italics_Tags'
	def S_F6 =
		'Small_Tags'
	def S_F7 =
		'Strike_tags'
	def S_F8 =
		'Subscript_Tags'
	def S_F9 =
		'Superscript_Tags'
	def S_F11 =
		'Typewriter_Tags'
	def S_F12 =
		'Underline_Tags'
	def A_1 =
		'H1_Tags'
	def A_2 =
		'H2_Tags'
	def A_3 =
		'H3_Tags'
	def A_4 =
		'H4_Tags'
	def A_5 =
		'H5_Tags'
	def A_6 =
		'H6_Tags'
	def C_A =
		'Anchor_Tags'
	def C_B =
		'Basefont_Tags'
	def C_C =
		'Caption_Tags'
	def C_D =
		'DictionaryList_Tags'
	def C_E =
		'TableEntry_Tags'
	def C_F =
		'Form_Tags'
	def C_H =
		'TableHeading_Tags'
	def C_I =
		'Image_Tags'
	def C_J =
		'Applet_Tags'
	def C_L =
		'ListItem_Tags'
	def C_M =
		'Map_Tags'
	def C_N =
		'NewPage_Tags'
	def C_O =
		'OrderedList_Tags'
	def C_R =
		'TableNewRow_Tags'
	def C_S =
		'Script_Tags'
	def C_T =
		'Table_Tags'
	def C_U =
		'UnorderedList_Tags'
	def C_Y =
		'Directory_Tags'
	def A_L =
		'Link_Tags'
	def A_M =
		'Meta_Tags'
	def A_Y =
		'Style_Tags'
	def A_T =
		'DeeTee_Tags'
	def A_D =
		'DeeDee_Tags'
	def A_M =
		'Menu_Tags'
	def A_P =
		'Parameter_Tags'
	def A_I =
		'Input_Tags'
	def A_S =
		'Select_Tags'
	def A_O =
		'Option_Tags'
	def A_X =
		'Textarea_Tags'
	def A_A =
		'Area_Tags'
	def A_Z
		'Last_Tag'
	def C_ENTER =
		'Linebreak_Tags'
	def ''-'' =
		keyin '&#'asc(lastkey())';'

;-----------------------------TAG Defcs
defc Address_tags =
	universal LastDone
	lastDone='Address_tags'
	noArgTags('ADDRESS')

defc Anchor_tags =
	universal LastDone
	lastDone='Anchor_tags'
	theLink=GetFileArrEl('A_LINK')
	theName=''
	theText=''
	theLink=entrybox('<A> Enter the link','/Enter/Cancel/Abort',theLink,,255)
	if (upcase(theLink)=='3') then
		return
	endif
	if theLink='' then
		theName=entrybox('<A> Enter the name','/Enter/Cancel/Abort','',,255)
		if (theName=='3') then
			return
		endif
	endif
	do while (theLink=='')&(theName=='')
 compile if HTML_IF_ARG_BLANK='exit'
		if (theLink=='')&(theName=='') then
			return
		endif
 compile endif
		theLink=entrybox('<A> Enter the link','/Enter/Cancel/Abort',theLink,,255)
			if (upcase(theLink)=='3') then
				return
			endif
			if theLink='' then
				theName=entrybox('<A> Enter the name','/Enter/Cancel/Abort','',,255)
				if (upcase(theName)=='3') then
					return
				endif
			endif	
	enddo
	Anchor_all(theLink, theName, '')

defc Applet_tags =
	universal LastDone
	lastDone='Applet_tags'
	theCode=GetFileArrEl('APPLET_CODE')
	theCodeBase=GetFileArrEl('APPLET_CODEBASE')
	theName=GetFileArrEl('APPLET_NAME')
	theAlt=GetFileArrEl('APPLET_ALT')
	theVspace=GetFileArrEl('APPLET_VSPACE')
	theHspace=GetFileArrEl('APPLET_HSPACE')
	theWidth=''
	theHeight=''
	theAlign=GetFileArrEl('APPLET_ALIGN')
	if theAlign='' then
		theAlign='/LEFT/RIGHT/TOP/BOTTOM/MIDDLE'
		setFileArrEl('APPLET_ALIGN', theAlign)
	endif
	do while upcase(rightstr(theCode, 5))/=='CLASS'
		theCode=entrybox('<APPLET> Enter the class','/Enter/Cancel/Abort',theCode,,255)
		if (upcase(theCode)=='3') then
			return
		endif
 compile if HTML_IF_ARG_BLANK='exit'
		if upcase(theCode)=='' then
			return
		endif
 compile endif
	enddo
	do while Valid_Number2(theWidth)=FALSE
		theWidth=entrybox('<APPLET> Enter the Width', '/Enter/Cancel/Abort', theWidth, , 255)
		if (theWidth='3') then
			return
		endif
	enddo
	do while Valid_Number2(theHeight)=FALSE
		theHeight=entrybox('<APPLET> Enter the Height', '/Enter/Cancel/Abort', theHeight, , 255)
		if (theHeight='3') then
			return
		endif
	enddo
	if upcase(leftstr(theCodebase, 5)) == 'AUTO_'then
		theCodebase=rightstr(theCodebase, length(theCodebase)-5)
	else
		theCodebase=entrybox('<APPLET> Enter the Codebase', '/Enter/Cancel/Abort', theCodebase, , 255)
		if (upcase(theCodebase)='3') then
			return
		endif
	endif
	if upcase(leftstr(theName, 5)) == 'AUTO_'then
		theName=rightstr(theName, length(theName)-5)
	else
		theName=entrybox('<APPLET> Enter the Name', '/Enter/Cancel/Abort', theName, , 255)
	endif
	if (upcase(theName)='3') then
		return
	endif
	if upcase(leftstr(theAlt, 5)) == 'AUTO_'then
		theAlt=rightstr(theAlt, length(theAlt)-5)
	else
		theAlt=entrybox('<APPLET> Enter the Alternate Text', '/Enter/Cancel/Abort', theAlt, , 255)
	endif
	if (upcase(theAlt)='3') then
		return
	endif
	if upcase(leftstr(theVspace, 5)) == 'AUTO_'then
		theVspace=rightstr(theVspace, length(theVspace)-5)
	else
		theVspace=entrybox('<APPLET> Enter the Vertical spacing', '', theVspace, , 255)
		if upcase(theVspace)='#OOPS' then
			return
		endif
	endif
	do while valid_number(theVspace)=FALSE
		theVspace=entrybox('<APPLET> Enter the Vertical spacing', '', theVspace, , 255)
		if upcase(theVspace)='#OOPS' then
			return
		endif
	enddo
	if upcase(leftstr(theHspace, 5)) == 'AUTO_'then
		theHspace=rightstr(theHspace, length(theHspace)-5)
	else
		theHspace=entrybox('<APPLET> Enter the Horizontal spacing', '', theHspace, , 255)
		if upcase(theHspace)='#OOPS' then
			return
		endif
	endif
	do while valid_number(theHspace)=FALSE
		theHspace=entrybox('<APPLET> Enter the Horizontal spacing', '', theHspace, , 255)
		if upcase(theHspace)='#OOPS' then
			return
		endif
	enddo
	if upcase(leftstr(theAlign, 5)) = 'AUTO_' then
		theAlign= rightstr(theAlign, length(theAlign)-5)
	else
		parse value listbox('<APPLET> Enter the Alignment', upcase(theAlign), '/Enter/None/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theAlign \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theAlign=''
		endif
	endif
	keyin Currentcase('<APPLET CODE="')theCode||Currentcase('" WIDTH=')theWidth||Currentcase(' HEIGHT=')theHeight
	if theCodebase /=='' then
		keyin currentcase(' CODEBASE="')theCodeBase'"'
	endif
	if theName /=='' then
		keyin currentcase(' NAME="')theName'"'
	endif
	if theAlt /=='' then
		keyin currentcase(' ALT="')theAlt'"'
	endif
	if theVspace /=='' then
		keyin currentcase(' VSPACE=')theVspace
	endif
	if theHspace /=='' then
		keyin currentcase(' HSPACE=')theHspace
	endif
	if theAlign /=='' then
		keyin currentcase(' ALIGN=')theAlign
	endif
	keyin '>'
	insertline '', .line+1
	insertline Currentcase('</APPLET>'), .line+2
	.line=.line+1
	.col=1

defc Area_tags =
	universal LastDone
	lastDone='Area_tags'
	theShape=getFileArrEl('AREA_SHAPE')
	theHref=getFileArrEl('AREA_HREF')
	theAlt=getFileArrEl('AREA_ALT')
	if theShape='' then
		theShape='/RECT/CIRCLE/POLY/DEFAULT'
		setFileArrEl('AREA_SHAPE', theShape)
	endif
	if upcase(leftstr(theShape, 5)) == 'AUTO_' then
		theShape=rightstr(theShape, length(theShape)-5)
	else
		parse value listbox('<AREA> Choose the Shape', theShape, '/Enter/Abort', 0,0,4,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theShape \0
		if (button=\0)|(button=\2) then
			return
		endif
	endif
	if upcase(theShape) == 'RECT' then
		tx=0
		bx=0
		ly=0
		ry=0
		do while tx >= bx
			tx=entrybox('<AREA SHAPE=RECT Enter the top edge','',tx,,255)
			do while Valid_number2(tx)=FALSE
				tx=entrybox('<AREA SHAPE=RECT Enter the top edge','',tx,,255)
			enddo
			bx=entrybox('<AREA SHAPE=RECT Enter the bottom edge','',bx,,255)
			do while Valid_number2(bx)=FALSE
				bx=entrybox('<AREA SHAPE=RECT Enter the bottom edge','',bx,,255)
			enddo
		enddo
		do while ly >= ry
			ly=entrybox('<AREA SHAPE=RECT Enter the left edge','',ly,,255)
			do while Valid_number2(ly)=FALSE
				ly=entrybox('<AREA SHAPE=RECT Enter the left edge','',ly,,255)
			enddo
			ry=entrybox('<AREA SHAPE=RECT Enter the right edge','',ry,,255)
			do while Valid_number2(ry)=FALSE
				ry=entrybox('<AREA SHAPE=RECT Enter the right edge','',ry,,255)
			enddo
		enddo
		theCoords=tx', 'ly', 'bx', 'ry
	elseif upcase(theShape) == 'CIRCLE' then
		xCen=''
		yCen=''
		radius=''
		do while valid_number2(xCen)=FALSE
			xCen=entrybox('<AREA SHAPE=CIRCLE Enter the center xCoordinate','',xCen,,255)
		enddo
		do while valid_number2(yCen)=FALSE
			yCen=entrybox('<AREA SHAPE=CIRCLE Enter the center yCoordinate','',yCen,,255)
		enddo
		do while valid_number2(radius)=FALSE
			radius=entrybox('<AREA SHAPE=CIRCLE Enter the Radius','',radius,,255)
		enddo
		theCoords=xCen', 'yCen', 'radius
	elseif upcase(theShape) == 'POLY' then
		theCoords=''
		xc='df'
		yc='fdsa'
		do while (xc/=='')&(yc/=='')
			xc=entrybox('<AREA SHAPE=POLY enter the x coordinate (blank to exit)','','',,255)
			if xc /=='' then
				yc=entrybox('<AREA SHAPE=POLY enter the y coordinate (blank to exit)','','',,255)
			endif
			if (xc/=='')&(yc/=='') then
				theCoords=theCoords||','xc||','yc
			endif
		enddo
		theCoords=rightstr(theCoords, length(theCoords)-1)
	else
		theCoords=''
	endif
	if upcase(leftstr(theHref, 5))=='AUTO_' then
		theHref=rightstr(theHref, length(theHref)-5)
	else
		theHref=entrybox('<AREA> Enter the HREF','',theHref,,255)
	endif
	if upcase(leftstr(theAlt, 5))=='AUTO_' then
		theAlt=rightstr(theAlt, length(theAlt)-5)
	else
		theAlt=entrybox('<AREA> Enter the Alternate text','',theAlt,,255)
	endif
	keyin currentcase('<AREA SHAPE='theShape)
	if upcase(theShape)/=='DEFAULT' then
		keyin currentcase(' COORDS="'theCoords'"')
	endif
	if theHref/=='' then
		keyin currentcase(' HREF="')theHref'"'
	else
		keyin currentcase(' NOHREF')
	endif
	if theAlt/=='' then
		keyin currentcase(' ALT="')theAlt'"'
	endif
	keyin '>'

defc BaseFont_tags =
	universal LastDone
	lastDone='BaseFont_tags'
	theSize=getFileArrEl('BASEFONT_SIZE')
	if upcase(leftstr(theSize,5))== 'AUTO_' then
		theSize=rightstr(theSize, length(theSize)-5)
	else
		do while Valid_Number2(theSize)=FALSE
			theSize=entrybox('<BASEFONT> Enter the Size','',theSize,,255)
		enddo
	endif
	keyin currentcase('<BASEFONT SIZE='theSize'>')

defc Big_tags =
	universal LastDone
	lastDone='Big_tags'
	noArgTags('BIG')

defc Blockquote_tags =
	universal LastDone
	lastDone='Blockquote_tags'
	noArgTags('BLOCKQUOTE')

defc Bold_tags =
	universal LastDone
	lastDone='Bold_tags'
	noArgTags('B')

defc Caption_tags =
	universal LastDone
	lastDone='Caption_tags'
	theAlign=GetFileArrEl('CAPTION_ALIGN')
	if theAlign='' then
		theAlign='/TOP/BOTTOM'
		setFileArrEl('CAPTION_ALIGN', theAlign)
	endif
	if check_mark_on_screen() then
		pbegin_mark()
	endif
	if upcase(leftstr(theAlign, 5)) == 'AUTO_' then
		theAlign=rightstr(theAlign, length(theAlign)-5)
	else
		parse value listbox('<CAPTION> Choose an alignment',Currentcase(theAlign), '/Enter/None/Abort', 0,0,2,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theAlign \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theAlign=''
		endif
	endif
	keyin Currentcase('<CAPTION')
	if theAlign /== '' then
		keyin Currentcase(' ALIGN='theAlign)
	endif
	keyin'>'
	if check_mark_on_screen() then
		pend_mark()
		oldCol=.col
		left
		if .col=oldCol then
			.line=.line-1
			endline
		else
			right
			right
		endif
	endif
	keyin Currentcase('</CAPTION>')
	if check_mark_on_screen() then
		unmark
	else
		.col=.col-10
	endif

defc Center_tags =
	universal LastDone
	lastDone='Center_tags'
	noArgTags('CENTER')

defc Citation_tags =
	universal LastDone
	lastDone='Citation_tags'
	noArgTags('CITE')

defc Code_tags =
	universal LastDone
	lastDone='Code_tags'
	noArgTags('CODE')

defc DeeDee_tags =
	universal LastDone
	lastDone='DeeDee_tags'
	keyin Currentcase('<DD>')

defc DeeTee_tags =
	universal LastDone
	lastDone='DeeTee_tags'
	keyin Currentcase('<DT>')

defc Definition_tags =
	universal LastDone
	lastDone='Definition_tags'
	noArgTags('DFN')

defc DictionaryList_tags =
	universal LastDone
	lastDone='DictionaryList_tags'
	Multiline_tags('DL')

defc Directory_tags =
	universal LastDone
	lastDone='Directory_tags'
	Multiline_tags('DIR')

defc Div_tags =
	universal LastDone
	lastDone='Div_tags'
	theAlign=GetFileArrEl('DIV_ALIGN')
	if theAlign='' then
		theAlign='/LEFT/RIGHT/CENTER'
		setFileArrEl('DIV_ALIGN', theAlign)
	endif
	if upcase(leftstr(theAlign, 5)) == 'AUTO_' then
		theAlign=rightstr(theAlign, length(theAlign)-5)
	else
		parse value listbox('<DIV> Choose an Alignment', Currentcase(theAlign), '/Enter/None/Abort', 0,0,3,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theAlign \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theAlign=''
		endif
	endif
	keyin currentCase('<DIV')
	if (theAlign /== '')&(upcase(theAlign)/=='LEFT') then
		keyin currentCase(' ALIGN="')theAlign'"'
	endif
	keyin '>'
	insertline '</DIV>', .line+2
	.line=.line+1
	.col=1

defc Emphasis_tags =
	universal LastDone
	lastDone='Emphasis_tags'
	noArgTags('EM')

defc Example_tags =
	universal LastDone
	lastDone='Example_tags'
	noArgTags('XMP')

defc Font_tags =
	universal LastDone
	lastDone='Font_tags'
	theSize=GetFileArrEl('FONT_SIZE')
	theColor=GetFileArrEl('FONT_COLOR')
	if upcase(leftstr(theSize, 5)) == 'AUTO_' then
		theSize=rightstr(theSize, length(theSize)-5)
	else
		theSize=entrybox('<FONT> Enter the size', '', theSize, , 255)
		if upcase(theSize)=='#OOPS' then
			return
		endif
	endif
	do while Valid_Number3(theSize)=FALSE
		theSize=entrybox('<FONT> Enter the size', '', theSize, , 255)
		if upcase(theSize)=='#OOPS' then
			return
		endif
	enddo
	if upcase(leftstr(theColor, 5)) == 'AUTO_' then
		theColor=rightstr(theColor, length(theColor)-5)
	else
		theColor=entrybox('<FONT> Enter the color', '/Enter/Cancel/Abort', theColor, , 255)
		if upcase(theColor)=='3' then
			return
		endif
	endif
	do while Valid_Color(theColor)=FALSE
		theColor=entrybox('<FONT> Enter the color', '/Enter/Cancel/Abort', theColor, , 255)
		if upcase(theColor)=='3' then
			return
		endif
	enddo
	do while (theSize=='')&(theColor=='')
 compile if HTML_IF_ARG_BLANK='exit'
		if(theSize=='')&(theColor=='') then
			return
		endif
 compile endif
		theSize=entrybox('<FONT> Enter the size', '', theSize, , 255)
		if upcase(theSize)=='#OOPS' then
			return
		endif
		theColor=entrybox('<FONT> Enter the color', '/Enter/Cancel/Abort', theColor, , 255)
		if upcase(theColor)=='3' then
			return
		endif
	enddo
	if check_mark_on_screen() then
		pbegin_mark()
	endif
	keyin Currentcase('<FONT')
	if theSize /== '' then
		keyin Currentcase(' SIZE=')theSize
	endif
	if theColor /== '' then
		keyin Currentcase(' COLOR=#')theColor
	endif
	keyin'>'
	if check_mark_on_screen() then
		pend_mark()
		oldCol=.col
		left
		if .col=oldCol then
			.line=.line-1
			endline
		else
			right
			right
		endif
	endif
	keyin Currentcase('</FONT>')
	if check_mark_on_screen() then
		unmark
	else
		.col=.col-7
	endif

defc Form_tags =
	universal LastDone
	lastDone='Form_tags'
	theAction=GetFileArrEl('FORM_ACTION')
	theMethod=GetFileArrEl('FORM_METHOD')
	theEncType=GetFileArrEl('FORM_ENCTYPE')
	if theMethod='' then
		theMethod='/GET/POST'
		setFileArrEl('FORM_METHOD', theMethod)
	endif
	theAction=entrybox('<FORM> Enter the action','',theAction,,255)
	do while theAction=''
 compile if HTML_IF_ARG_BLANK='exit'
		if theAction=='' then
			return
		endif
 compile endif
		theAction=entrybox('<FORM> Enter the action','/Enter/Cancel/Abort',theAction,,255)
	enddo
	if upcase(theAction)=='3' then
		return
	endif
	if upcase(leftstr(theMethod,5))=='AUTO_' then
		theMethod=Currentcase(rightstr(theMethod, length(theMethod)-5))
	else
		do while (upcase(theMethod)/=='POST')&(upcase(theMethod)/=='GET')
			parse value listbox('<FORM> Choose the method', Currentcase(getFileArrEl('FORM_METHOD')),'/Enter/Abort', 0,0,2,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theMethod \0
			if (button=\0)|(button=\2) then
				return
			endif
		enddo
	endif
	theEncType=entrybox('<FORM> Enter the ENCTYPE','',theEncType,,255)
	keyin Currentcase('<FORM ACTION="')theAction||Currentcase('" METHOD='theMethod)'>'
	insertline '', .line+1
		insertline Currentcase('</FORM>'), .line+2
	.line=.line+1
	.col=1

defc H1_tags =
	universal LastDone
	lastDone='H1_tags'
	alignArgTags('H1')

defc H2_tags =
	universal LastDone
	lastDone='H2_tags'
	alignArgTags('H2')

defc H3_tags =
	universal LastDone
	lastDone='H3_tags'
	alignArgTags('H3')

defc H4_tags =
	universal LastDone
	lastDone='H4_tags'
	alignArgTags('H4')

defc H5_tags =
	universal LastDone
	lastDone='H5_tags'
	alignArgTags('H5')

defc H6_tags =
	universal LastDone
	lastDone='H6_tags'
	alignArgTags('H6')


defc Image_tags =
	universal LastDone
	lastDone='Image_tags'
	theSource=GetFileArrEl('IMG_SOURCE')
	theSource=entrybox('<IMG> Enter the source','/Enter/Cancel/Abort',theSource,,255)
 compile if HTML_IF_ARG_BLANK='exit'
	if upcase(theSource)=='' then
		return
	endif
 compile else
	do while theSource=''
		theSource=entrybox('<IMG> Enter the source','/Enter/Cancel/Abort',theSource,,255)
	enddo
	if upcase(theSource)=='3' then
		return
	endif
 compile endif
	Image_all(theSource)

defc Input_tags =
	universal LastDone
	lastDone='Input_tags'
	theName=''
	theValue=''
	theAlign=''
	theSize=''
	theMaxlength=''
	theChecked=''
	theRChecked=''
	theSource=GetFileArrEl('INPUT_IMAGE_SOURCE')
	theType=GetFileArrEl('INPUT_TYPE')
	if theType='' then
		theType='/CHECKBOX/HIDDEN/IMAGE/PASSWORD/RADIO/RESET/SUBMIT/TEXT'
		setFileArrEl('INPUT_TYPE', theType)
	endif
	if upcase(leftstr(theType, 5)) == 'AUTO_' then
		theType=rightstr(theType, length(theType)-5)
	else
		parse value listbox('<INPUT> Choose a type',Currentcase(theType), '/Enter/Abort', 0,0,8,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theType \0
		if (button=\0)|(button=\2) then
			return
		endif
	endif

	if (upcase(theType)/=='RESET')&(upcase(theType)/=='SUBMIT') then
		do while theName ==''
			theName=entrybox('<INPUT TYPE='theType'> Enter the name','/Enter/Cancel/Abort', theName,,255)
			if upcase(theName)=='3' then
				return
			endif
 compile if HTML_IF_ARG_BLANK='esit'
			if theName='' then
				return
			endif
 compile endif
		enddo
	endif

	if (upcase(theType)/=='CHECKBOX')&(upcase(theType)/=='FILE')&(upcase(theType)/=='IMAGE') then
		theValue=getFileArrEl('INPUT_'theType'_VALUE')
		if (upcase(theType)=='RADIO')|(upcase(theType)=='RADIO') then
			do while theValue=''
				theValue=entrybox('<INPUT TYPE='theType'> Enter the value','/Enter/Cancel',theValue,,255)
				if upcase(theValue)=='#OOPS' then
					return
				endif
 compile if HTML_IF_ARG_BLANK='exit'
				if theValue='' then
					return
				endif
 compile endif
			enddo
		else
			theValue=entrybox('<INPUT TYPE='theType'> Enter the value','/Enter/Cancel',theValue,,255)
			if upcase(theValue)=='#OOPS' then
				return
			endif
		endif
	endif


	if (upcase(theType)=='PASSWORD')|(upcase(theType)=='TEXT') then
		theSize=getFileArrEl('INPUT_'theType'_SIZE')
		if upcase(leftstr(theSize, 5))=='AUTO_' then
			theSize=leftstr(theSize, length(theSize)-5)
		else
			theSize=entrybox('<INPUT TYPE='theType'> Enter the size','/Enter/Cancel/Abort',theSize,,255)
			if upcase(theSize)=='3' then
				return
			endif
		endif
		theMaxlength=getFileArrEl('INPUT_'theType'_MAXLENGTH')
		if upcase(leftstr(theMaxlength, 5))=='AUTO_' then
			theMaxlength=leftstr(theMaxlength, length(theMaxlength)-5)
		else
			theMaxlength=entrybox('<INPUT TYPE='theType'> Enter the size','/Enter/Cancel/Abort',theMaxlength,,255)
			if upcase(theMaxlength)=='3' then
				return
			endif
		endif
	endif

	if upcase(theType)=='IMAGE' then
		theSource=getFileArrEl('INPUT_IMAGE_SOURCE')
		if upcase(leftstr(theSource, 5))='AUTO_' then
			theSource=rightstr(theSource, length(theSource)-5)
		else
			do while theSource=''
				theSource=entrybox('<INPUT TYPE=IMAGE> Enter the source', '/Enter/Cancel/Abort', theSource,.255)
				if theSource='3' then
					return
				endif
 compile if HTML_IF_ARG_BLANK='exit'
				if theSource='' then
					return
				endif
 compile endif
			enddo
		endif
		theAlign=getFileArrEl('INPUT_IMAGE_ALIGN')
		if theAlign='' then
			theAlign='/LEFT/RIGHT/TOP/MIDDLE/BOTTOM'
			setFileArrEl('INPUT_IMAGE_ALIGN', theAlign)
		endif
		if upcase(leftstr(theAlign, 5))=='AUTO_' then
			theAlign=rightstr(theAlign, length(theAlign)-5)
		else
			parse value listbox('<INPUT TYPE=IMAGE Enter the Alignment', upcase(theAlign), '/Enter/None/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theAlign \0
			if (button=\0)|(button=\3) then
				return
			endif
			if button=\2 then
				theAlign=''
			endif
		endif
	endif

	if (upcase(theType)=='CHECKBOX')|(upcase(theType)=='RADIO') then
		theChecked=getFileArrEl('INPUT_'theType'_CHECKED')
		if upcase(theChecked)=='AUTO_YES' then
			theChecked=MBID_YES
		elseif upcase(theChecked)=='AUTO_NO' then
			theChecked=MBID_NO
		elseif upcase(theChecked)=='YES' then
			theChecked=winmessagebox('<INPUT TYPE='theType'>', 'Is this one checked?', MB_YESNOCANCEL+MB_DEFBUTTON1)
		else
			theChecked=winmessagebox('<INPUT TYPE='theType'>', 'Is this one checked?', MB_YESNOCANCEL+MB_DEFBUTTON2)
		endif
		if theChecked=MBID_CANCEL then
			return
		endif
	endif



	if theSize=0 then
		theSize=''
	endif
	if theMaxlength=0 then
		theMaxlength=''
	endif
	keyin Currentcase('<INPUT TYPE='theType)
	if theName /== '' then
		keyin Currentcase(' NAME="')theName'"'
	endif
	if theValue /== '' then
		keyin Currentcase(' VALUE="')theValue'"'
	endif
	if theSource /== '' then
		keyin Currentcase(' SRC="')theSource'"'
	endif
	if theAlign /== '' then
		keyin Currentcase(' ALIGN=')theAlign
	endif
	if theSize /== '' then
		keyin Currentcase(' SIZE=')theSize
	endif
	if theMaxlength /== '' then
		keyin Currentcase(' MAXLENGTH=')theMaxlength
	endif
	if theChecked=MBID_YES then
		keyin Currentcase(' CHECKED')
	endif
	keyin '>'

defc Italics_Tags =
	universal LastDone
	lastDone='Italics_Tags'
	noArgTags('I')

defc Keyboard_tags =
	universal LastDone
	lastDone='Keyboard_tags'
	noArgTags('KBD')

defc LineBreak_tags =
	universal LastDone
	lastDone='LineBreak_tags'
	theClear=getFileArrEl('BR_CLEAR')
	if theClear=''then
		theClear='/ALL/LEFT/RIGHT/NONE'
		setFileArrEl('BR_CLEAR', theClear)
	endif
	if upcase(leftstr(theClear, 5))=='AUTO_' then
		theClear=rightstr(theClear, length(theClear)-5)
	else
		parse value listbox('<BR> Clears which way', currentcase(theClear), '/Enter/None/Abort', 0,0,4,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theClear \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theClear=''
		endif
	endif
	keyin Currentcase('<BR')
	if theClear/=='' then
		keyin currentcase(' CLEAR='theClear)
	endif
	keyin '>'

defc Listing_tags =
	universal LastDone
	lastDone='Listing_tags'
	noArgTags('LISTING')

defc Link_tags =
	universal LastDone
	lastDone='Link_tags'
	theURL=GetFileArrEl('LINK_LINK')
	theRel=GetFileArrEl('LINK_REL')
	theRev=GetFileArrEl('LINK_REV')
	theTitle=GetFileArrEl('LINK_TITLE')
	do while theURL==''
		theURL=entrybox('<LINK> Enter the HREF','/Enter/Cancel/Abort',theURL,,255)
		if upcase(theURL)=='3' then
			return
		endif
 compile if HTML_IF_ARG_BLANK='exit'
		if theURL=='' then
			return
		endif
 compile endif
	enddo
	if upcase(leftstr(theRel,5)) == 'AUTO_' then
		theRel=rightstr(theRel, length(theRel)-5)
	else
		theRel=entrybox('<LINK> Enter the Rel', '/Enter/Cancel/Abort',theRel,,255)
		if upcase(theRel)=='3' then
			return
		endif
	endif
	if upcase(leftstr(theRev,5)) == 'AUTO_' then
		theRev=rightstr(theRev, length(theRev)-5)
	else
		theRev=entrybox('<LINK> Enter the Rev', '/Enter/Cancel/Abort',theRev,,255)
		if upcase(theRev)=='3' then
			return
		endif
	endif
	if upcase(leftstr(theTitle,5)) == 'AUTO_' then
		theTitle=rightstr(theTitle, length(theTitle)-5)
	else
		theTitle=entrybox('<LINK> Enter the Title', '/Enter/Cancel/Abort',theTitle,,255)
		if upcase(theTitle)=='3' then
			return
		endif
	endif
	keyin Currentcase('<LINK HREF="')theURL'"'
	if theRel /== '' then
		keyin Currentcase(' REL="')theRel'"'
	endif
	if theRev /== '' then
		keyin Currentcase(' REV="')theRev'"'
	endif
	if theTitle /== '' then
		keyin Currentcase(' TITLE="')theTitle'"'
	endif
	keyin ('>')

defc ListItem_tags =
	universal LastDone
	lastDone='ListItem_tags'
	keyin Currentcase('<LI>')

defc Map_Tags =
	universal LastDone
	lastDone='Map_Tags'
	theName=getFileArrEl('MAP_NAME')
	if upcase(leftstr(theName, 5)) ='AUTO_' then
		theName=rightstr(theName, length(theName)-5)
	else
		theName=entrybox('<MAP> Enter the Name','',theName,,255)
	endif
	keyin currentcase('<MAP')
	if theName/=='' then
		keyin currentcase(' NAME="')theName'"'
	endif
	keyin '>'
	insertline '', .line+1
	insertline currentcase('</MAP>'), .line+2
	.line=.line+1
	beginline

defc Menu_tags =
	universal LastDone
	lastDone='Menu_tags'
	Multiline_tags('MENU')

defc Meta_Tags =
	universal LastDone
	lastDone='Meta_Tags'
	theEquiv=''
	theName=''
	theContent=''
	theEquiv=entrybox('<META> Enter the HTTP_EQUIV','/Enter/Cancel/Abort','', ,255)
	if upcase(theEquiv)=='3' then
		return
	endif
	if theEquiv=='' then
		theName=entrybox('<META> Enter the name','/Enter/Cancel/Abort','',,255)
		if upcase(theName)=='3' then
			return
		endif
	endif
 compile if HTML_IF_ARG_BLANK='exit'
	if (theEquiv=='')&(theName=='') then
		return
	endif
 compile else do while (theEquiv=='')&(theName=='')
		theEquiv=entrybox('<META> Enter the HTTP_EQUIV','/Enter/Cancel/Abort','', ,255)
		if upcase(theEquiv)=='3' then
			return
		endif
		if theEquiv=='' then
			theName=entrybox('<META> Enter the name','/Enter/Cancel/Abort','',,255)
			if upcase(theName)=='3' then
				return
			endif
		endif
	enddo
 compile endif
	do while theContent==''
		theContent=entrybox('<META> Enter the content','/Enter/Cancel/Abort','',,255)
		if theContent='3' then
			return
		endif
	enddo
	keyin Currentcase('<META')
	if theEquiv/=='' then
		keyin Currentcase(' HTTP-EQUIV="')theEquiv'"'
	endif
	if theName /=='' then
		keyin Currentcase(' NAME="')theName'"'
	endif
	keyin Currentcase(' CONTENT="')theContent'"'
	keyin '>'

defc NewPage_tags =
	universal LastDone, load_ext
	if wordpos(load_ext, 'xtml XTML') then
		sayerror 'This is an XTML file'
		return
	endif
	lastDone=''
	theBase=getFileArrEl('BASE')
	theVersion=getFileArrEl('HTML_VERSION')
	theBackground=GetFileArrEl('BODY_BACKGROUND')
	theBackgroundcolor=GetFileArrEl('BODY_BGCOLOR')
	theText=GetFileArrEl('BODY_TEXT')
	theLink=GetFileArrEl('BODY_LINK')
	theIdxPrompt=GetFileArrEl('INDEX_PROMPT')
	theHitlink=GetFileArrEl('BODY_VLINK')
	theAlink=GetFileArrEl('BODY_ALINK')
	theIndex=GetFileArrEl('IS_INDEX')
	theTitle=entrybox('[New File] Enter the title','/Enter/Cancel/Abort','',,255)
	if theTitle='3' then
		return
	endif
	if upcase(leftstr(theVersion,5)) == 'AUTO_' then
		theVersion=rightstr(theVersion, length(theVersion)-5)
	else
		theVersion=entrybox('[New File] Enter the version', '/Enter/Cancel/Abort', theVersion, ,255)
		if theVersion='3' then
			return
		endif
	endif
	if upcase(leftstr(theBackground,5)) == 'AUTO_' then
		theBackground=rightstr(theBackground, length(theBackground)-5)
	else
		theBackground=entrybox('[New File] Enter the background','/Enter/Cancel/Abort',theBackground,,255)
	endif
	if upcase(theBackground)=='3' then
		return
	endif
	if upcase(leftstr(theBackgroundcolor,5)) == 'AUTO_' then
		theBackgroundcolor=rightstr(theBackgroundcolor, length(theBackgroundcolor)-5)
	else
		theBackgroundcolor=entrybox('[New File] Enter the background color','/Enter/Cancel/Abort',theBackgroundcolor,,255)
		if upcase(theBackgroundcolor)=='3' then
			return
		endif
	endif
	do while Valid_Color(theBackgroundcolor)=FALSE
		theBackgroundcolor=entrybox('[New File] Enter the background color','/Enter/Cancel/Abort',theBackgroundcolor,,255)
		if upcase(theBackgroundcolor)=='3' then
			return
		endif
	enddo
	if upcase(leftstr(theText,5)) == 'AUTO_' then
		theText=rightstr(theText, length(theText)-5)
	else
		theText=entrybox('[New File] Enter the text color','/Enter/Cancel/Abort',theText,,255)
		if upcase(theText)=='3' then
			return
		endif
	endif
	do while Valid_Color(theText)=FALSE
		theText=entrybox('[New File] Enter the text color','/Enter/Cancel/Abort',theText,,255)
		if upcase(theText)=='3' then
			return
		endif
	enddo
	if upcase(leftstr(theLink,5)) == 'AUTO_' then
		theLink=rightstr(theLink, length(theLink)-5)
	else
		theLink=entrybox('[New File] Enter the link color','/Enter/Cancel/Abort',theLink,,255)
		if upcase(theLink)=='3' then
			return
		endif
	endif
	do while Valid_Color(theLink)=FALSE
		theLink=entrybox('[New File] Enter the link color','/Enter/Cancel/Abort',theLink,,255)
		if upcase(theLink)=='3' then
			return
		endif
	enddo
	if upcase(leftstr(theHitlink,5)) == 'AUTO_' then
		theHitlink=rightstr(theHitlink, length(theHitlink)-5)
	else
		theHitlink=entrybox('[New File] Enter the hit link color','/Enter/Cancel/Abort',theHitlink,,255)
		if upcase(theHitlink)=='3' then
			return
		endif
	endif
	do while Valid_Color(theHitlink)=FALSE
		theHitlink=entrybox('[New File] Enter the hit link color','/Enter/Cancel/Abort',theHitlink,,255)
		if upcase(theHitlink)=='3' then
			return
		endif
	enddo
	if upcase(leftstr(theAlink,5)) == 'AUTO_' then
		theAlink=rightstr(theAlink, length(theAlink)-5)
	else
		theAlink=entrybox('[New File] Enter the active link color','/Enter/Cancel/Abort',theAlink,,255)
		if upcase(theAlink)=='3' then
			return
		endif
	endif
	do while Valid_Color(theAlink)=FALSE
		theAlink=entrybox('[New File] Enter the active link color','/Enter/Cancel/Abort',theAlink,,255)
		if upcase(theAlink)=='3' then
			return
		endif
	enddo
	if upcase(theIndex)=='AUTO_YES' then
		theIndex=MBID_YES
	elseif upcase(theIndex)='AUTO_NO' then
		theIndex=MBID_NO
	else
		if upcase(theIndex)='YES' then
		theIndex=winmessagebox('INDEX?', 'Is this an index?', MB_YESNOCANCEL + MB_DEFBUTTON1)
		else
		theIndex=winmessagebox('INDEX?', 'Is this an index?', MB_YESNOCANCEL + MB_DEFBUTTON2)
		endif
	endif
	if theIndex=MBID_CANCEL then
		return
	endif
		if theIndex=MBID_YES then
			if upcase(leftstr(theIdxPrompt,5 )) == 'AUTO_' then
				theIdxPrompt=rightstr(theIdxPrompt, length(theIdxPrompt)-5)
			else
				theIdxPrompt=entrybox('[New File] Enter the Index Prompt','',theIdxPrompt,,255)
			endif
		endif
	if upcase(leftstr(theBase,5))== 'AUTO_' then
		theBase=rightstr(theBase, length(theBase)-5)
	else
		theBase=entrybox('[New File] Enter the base','/Enter/Cancel/Abort',theBase,,255)
		if upcase(theBase)=='3' then
			return
		endif
	endif
	keyin Currentcase('<HTML')
	if theVersion/=='' then
		keyin currentcase(' VERSION="')
		keyin theVersion
		keyin('"')
	endif
	keyin currentcase('>')
	insertline Currentcase('<HEAD>'), .line+1
	insertline Currentcase('<TITLE>')theTitle||Currentcase('</TITLE>'), .line+2
	if theIndex=MBID_YES then
		if theIdxPrompt == '' then
		insertline Currentcase('<ISINDEX>'), .line+3
		else
			eLine=currentcase('<ISINDEX PROMPT="')theIdxPrompt'">'
			insertline eLine, .line+3
		endif
		.line=.line+1
	endif
	if theBase /=='' then
		insertline Currentcase('<BASE HREF="')theBase'">', .line+3
		.line=.line+1
	endif
	insertline Currentcase('</HEAD>'), .line+3
	insertline Currentcase('<BODY>'), .line+4
	insertline '', .line+5
	insertline Currentcase('</BODY>'), .line+6
	insertline Currentcase('</HTML>'), .line+7
	.line=.line+4
	.col=6
	if theBackground /=='' then
		keyin Currentcase(' BACKGROUND="'theBackground'"')
	endif
	if theBackgroundcolor /=='' then
		keyin Currentcase(' BGCOLOR=#'theBackgroundcolor)
	endif
	if theText /=='' then
		keyin Currentcase(' TEXT=#'theText)
	endif
	if theLink /=='' then
		keyin Currentcase(' LINK=#'theLink)
	endif
	if theHitlink /=='' then
		keyin Currentcase(' VLINK=#'theHitlink)
	endif
	if theAlink /=='' then
		keyin Currentcase(' ALINK=#'theAlink)
	endif
	.line=.line+1
	.col=1

defc Option_tags =
	universal LastDone
	lastDone='Option_tags'
	theValue=''
	do while theValue ==''
		theValue=entrybox('<OPTION> Enter the value','', theValue,,255)
	enddo
	keyin Currentcase('<OPTION VALUE="')theValue'">'

defc OrderedList_tags =
	universal LastDone
	lastDone='OrderedList_tags'
	theType=getFileArrEl('OL_TYPE')
	theStart=getFileArrEl('OL_START')
	theCompact=getFileArrEl('OL_COMPACT')
	if theType ='' then
		theType='/1/a/A/i/I'
		setFileArrEl('OL_TYPE', theType)
	endif
	if upcase(leftstr(theType, 5))=='AUTO_'then
		theType=rightstr(theType, length(theType)-5)
	else
		parse value listbox('<OL> Choose the Type', theType, '/Enter/None/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theType \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theType=''
		endif
	endif
	if upcase(leftstr(theStart,5))=='AUTO_'then
		theStart=rightstr(theStart, length(theStart)-5)
	else
		theStart=entrybox('<OL> Enter the start index','',theStart,,255)
		do while Valid_Number(theStart)=False
			theStart=entrybox('<OL> Enter the start index','',theStart,,255)
		enddo
	endif
	if upcase(theCompact)=='AUTO_YES' then
		theCompact=MBID_YES
	elseif upcase(theCompact)=='AUTO_NO' then
		theCompact=MBID_NO
	else
		if upcase(theCompact)='YES' then
		theCompact=winmessagebox('COMPACT?', 'Is this a Compact list?', MB_YESNO + MB_DEFBUTTON1)
		else
		theCompact=winmessagebox('COMPACT?', 'Is this a Compact list?', MB_YESNO + MB_DEFBUTTON2)
		endif
	endif
	keyin currentcase('<OL')
	if theType/=='' then
		keyin currentcase(' TYPE=')theType
	endif
	if theStart/=='' then
		keyin currentCase(' START=')theStart
	endif
	if theCompact==MBID_YES then
		keyin currentCase(' COMPACT')
	endif
	keyin '>'
	insertline '', .line+1
	insertline currentcase('</OL>'), .line+2
	.line=.line+1
	beginline

defc Paragraph_tags =
	universal LastDone
	lastDone='Paragraph_tags'
	alignArgTags('P')

defc Parameter_tags =
	universal LastDone
	lastDone='Parameter_tags'
	theName=''
	theValue=''
	theName=entrybox('<PARAMETER> Enter the name','/Enter/Cancel/Abort', theName,,255)
	if upcase(theName)=='3' then
		return
	endif
 compile if HTML_IF_ARG_BLANK = 'exit'
	if theName =='' then
		return
	endif
 compile else
	do while theName ==''
		theName=entrybox('<PARAMETER> Enter the name','/Enter/Cancel/Abort', theName,,255)
		if upcase(theName)=='3' then
			return
		endif
	enddo
 compile endif
	theValue=entrybox('<PARAMETER> Enter the value','', theValue,,255)
 compile if HTML_IF_ARG_BLANK = 'exit'
	if theValue =='' then
		return
	endif
 compile else
	do while theValue ==''
		theValue=entrybox('<PARAMETER> Enter the value','', theValue,,255)
	enddo
 compile endif
	if upcase(theValue)=='#OOPS' then
		return
	endif
	keyin Currentcase('<PARAM NAME="')theName||Currentcase('" VALUE="')theValue'">'

defc Preform_tags =
	universal LastDone
	lastDone='Preform_tags'
	theWidth=GetFileArrEl('PRE_WIDTH')
	if upcase(leftstr(theWidth, 5))=='AUTO_' then
		theWidth=rightstr(theWidth, length(theWidth)-5)
	else
		theWidth=entrybox('<PRE> Enter the width','',theWidth,,255)
	endif
	do while Valid_Number(theWidth)=FALSE
		theWidth=entrybox('<PRE> Enter the width','/Enter/Cancel/Abort',theWidth,,255)
	enddo
	if upcase(theWidth)=='3' then
		return
	endif
	if check_mark_on_screen() then
		pbegin_mark()
	endif
	keyin Currentcase('<PRE')
	if theWidth/=='' then
		keyin Currentcase(' WIDTH=')theWidth
	endif
	keyin '>'
	if check_mark_on_screen() then
		pend_mark()
		oldCol=.col
		left
		if .col=oldCol then
			.line=.line-1
			endline
		else
			right
			right
		endif
	endif
		keyin Currentcase('</PRE>')
	if check_mark_on_screen() then
		unmark
	else
		.col=.col-6
	endif

defc Rule_tags =
	universal LastDone
	lastDone='Rule_tags'
	theSize=GetFileArrEl('HR_SIZE')
	theWidth=GetFileArrEl('HR_WIDTH')
	theAlign=GetFileArrEl('HR_ALIGN')
	if theAlign='' then
		theAlign='/CENTER/LEFT/RIGHT'
		setFileArrEl('HR_ALIGN', theAlign)
	endif
	if upcase(leftstr(theSize, 5)) == 'AUTO_' then
		theSize=rightstr(theSize, length(theSize)-5)
	else
		theSize=entrybox('<HR> Enter the size','',theSize,,255)
	endif
	do while Valid_Number(theSize)=FALSE
		theSize=entrybox('<HR> Enter the size', '', theSize, , 255)
	enddo
	if upcase(theSize)=='#OOPS' then
		return
	endif
	if upcase(leftstr(theWidth, 5)) == 'AUTO_' then
		theWidth=rightstr(theWidth, length(theWidth)-5)
	else
		theWidth=entrybox('<HR> Enter the width','/Enter/Cancel/Abort',theWidth,,255)
		if upcase(theWidth)=='3' then
			return
		endif
	endif
	do while (Valid_Number(theWidth)=FALSE)|(theWidth>100)
		theWidth=entrybox('<HR> Enter the width', '/Enter/Cancel/Abort', theWidth, , 255)
		if upcase(theWidth)=='3' then
			return
		endif
	enddo
	if upcase(leftstr(theAlign, 5)) == 'AUTO_' then
		theAlign=rightstr(theAlign, length(theAlign)-5)
	else
		parse value listbox('<HR> Choose an alignment', upcase(theAlign), '/Enter/None/Abort', 0,0,3,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theAlign \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theAlign=''
		endif
	endif
	keyin Currentcase('<HR')
	if (theSize /== '') then
		keyin Currentcase(' SIZE='theSize)
	endif
	if theWidth/=='' then
		keyin Currentcase(' WIDTH='theWidth'%')
	endif
	if (theAlign /== '') then
		keyin Currentcase(' ALIGN='theAlign)
	endif
	keyin '>'

defc Sample_tags =
	universal LastDone
	lastDone='Sample_tags'
	noArgTags('SAMP')

defc Script_tags =
	universal LastDone
	lastDone='Script_tags'
	Multiline_tags('SCRIPT')

defc Select_tags =
	universal LastDone
	lastDone='Select_tags'
	theName=''
	theSize=GetFileArrEl('SELECT_SIZE')
	do while theName ==''
		theName=entrybox('<SELECT> Enter the name','/Enter/Cancel/Abort', theName,,255)
	if upcase(theName)=='3' then
		return
	endif
	enddo
	if upcase(leftstr(theSize,5))=='AUTO_' then
		theSize = rightstr(theSize, length(theSize)-5)
	else
		theSize=entrybox('<SELECT> Enter the size','',Currentcase(theSize),,255)
	endif
	do while Valid_Number(theSize)=FALSE
		theSize=entrybox('<SELECT> Enter the size','', theSize,,255)
	enddo
	if upcase(theSize)=='#OOPS' then
		return
	endif
	keyin Currentcase('<SELECT NAME="')theName'"'
	if theSize /== '' then
		keyin Currentcase(' SIZE=')theSize
	endif
	keyin '>'
	insertline '', .line+1
	insertline Currentcase('<SELECT>'), .line+2
	.line=.line+1
	.col=1

defc Small_tags =
	universal LastDone
	lastDone='Small_tags'
	noArgTags('SMALL')

defc Strike_tags =
	universal LastDone
	lastDone='Strike_tags'
	noArgTags('STRIKE')

defc Strong_tags =
	universal LastDone
	lastDone='Strong_tag'
	noArgTags('STRONG')

defc Style_tags =
	universal LastDone
	lastDone='Style_tags'
	theType=GetFileArrEl('STYLE_TYPE')
	if upcase(leftstr(theType, 5)) == 'AUTO_' then
		theType=rightstr(theType, length(theType)-5)
	else
		theType=entrybox('<STYLE> enter the Type','',theType,,255)
	endif
	keyin currentCase('<STYLE')
	if theType /== '' then
		keyin currentCase(' TYPE="')theType'"'
	endif
	keyin '>'
	insertline '</STYLE>', .line+2
	.line=.line+1
	.col=1

defc Subscript_tags =
	universal LastDone
	lastDone='Subscript_tags'
	noArgTags('SUB')

defc Superscript_tags =
	universal LastDone
	lastDone='Superscript_tags'
	noArgTags('SUP')

defc Table_tags =
	universal LastDone
	lastDone='Table_tags'
	theBorder=GetFileArrEl('TABLE_BORDER')
	theCellpading=GetFileArrEl('TABLE_CELLPADDING')
	theCellspacing=GetFileArrEl('TABLE_CELLSPACING')
	if upcase(leftstr(theBorder, 5))=='AUTO_' then
		theBorder=rightstr(theBorder, length(theBorder)-5)
	else
		theBorder=entrybox('<TABLE> Enter the border width','',theBorder,,255)
	endif
	do while Valid_Number(theBorder)=FALSE
		theBorder=entrybox('<TABLE> Enter the border width','', theBorder,,255)
	enddo
	if upcase(theBorder)=='#OOPS' then
		return
	endif
	if upcase(leftstr(theCellpading,5))=='AUTO_' then
		theCellpading=rightstr(theCellpading, length(theCellpading)-5)
	else
		theCellpading=entrybox('<TABLE> Enter the cell pading', '', theCellpading,, 255)
	endif
	do while Valid_Number(theCellpading)=FALSE
		theCellpading=entrybox('<TABLE> Enter the cell pading', '', theCellpading,, 255)
	enddo
	if upcase(theCellpading)=='#OOPS' then
		return
	endif
	if upcase(leftstr(theCellspacing,5))=='AUTO_' then
		theCellspacing=rightstr(theCellspacing, length(theCellspacing)-5)
	else
		theCellspacing=entrybox('<TABLE> Enter the cell spacing', '', theCellspacing,, 255)
	endif
	do while Valid_Number(theCellspacing)=FALSE
		theCellspacing=entrybox('<TABLE> Enter the cell spacing', '', theCellspacing,, 255)
	enddo
	if upcase(theCellspacing)=='#OOPS' then
		return
	endif
	keyin Currentcase('<TABLE')
	if theBorder /=='' then
		keyin Currentcase(' BORDER='theBorder)
	endif
	if theCellspacing /== '' then
		keyin Currentcase(' CELLSPACING=')theCellspacing
	endif
	if theCellpading /=='' then
		keyin Currentcase(' CELLPADING=')theCellpading
	endif
	if theBorder < 1 then
		theBorder=''
	endif
	keyin '>'
	insertline '', .line+1
	insertline Currentcase('</TABLE>'), .line+2
	.line=.line+1
	.col=1

defc TableEntry_tags =
	universal LastDone
	lastDone='TableEntry_tags'
	Table_XX(CurrentCase('TD'))

defc TableHeading_tags =
	universal LastDone
	lastDone='TableHeading_tags'
	Table_XX(CurrentCase('TH'))

defc TableNewRow_tags =
	universal LastDone
	lastDone='TableNewRow_tags'
	theAlign=GetFileArrEl('TR_ALIGN')
	theValign=GetFileArrEl('TR_VALIGN')
	if theAlign='' then
		theAlign='/LEFT/RIGHT/CENTER'
		setFileArrEl('TR_ALIGN', theAlign)
	endif
	if theValign='' then
		theValign='/MIDDLE/TOP/BOTTOM'
		setFileArrEl('TR_VALIGN', theValign)
	endif
	if upcase(leftstr(theAlign, 5))=='AUTO_' then
		theAlign=rightstr(theAlign, length(theAlign)-5)
	else
		parse value listbox('<TR> Choose the horizontal alignment', upcase(theAlign), '/Enter/None/Abort', 0,0,3,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theAlign \0
		if (button=\0)|(button=\3)then
			return
		endif
		if button=\2
			then theAlign=''
		endif
	endif
	if upcase(leftstr(theValign, 5))=='AUTO_' then
		theValign=rightstr(theValign, length(theValign)-5)
	else
		parse value listbox('<TR> Choose the vertical alignment', upcase(theValign), '/Enter/None/Abort', 0,0,3,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theValign \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theValign=''
		endif
	endif
	keyin Currentcase('<TR')
	if theAlign/=='' then
		keyin Currentcase(' ALIGN=')theAlign
	endif
	if theValign/=='' then
		keyin Currentcase(' VALIGN=')theValign
	endif
	keyin ('>')

defc Textarea_tags =
	universal LastDone
	lastDone='Textarea_tags'
	theName=''
	theCols=GetFileArrEl('TEXTAREA_COLS')
	theRows=GetFileArrEl('TEXTAREA_ROWS')
	do while theName ==''
		theName=entrybox('<TEXTAREA> Enter the name','/Enter/Cancel/Abort', theName,,255)
		if upcase(theName)=='3' then
			return
		endif
	enddo
	if upcase(leftstr(theCols, 5)) == 'AUTO_' then
		theCols=rightstr(theCols, length(theCols)-5)
	else
		theCols=entrybox('<TEXTAREA> Enter the number of columns','/Enter/Cancel/Abort',Currentcase(theCols),,255)
		if upcase(theCols)=='3' then
			return
		endif
	endif
	do while Valid_Number(theCols)=FALSE
		theCols=entrybox('<TEXTAREA> Enter the number oc columns','/Enter/Cancel/Abort', theCols,,255)
		if upcase(theCols)=='3' then
			return
		endif
	enddo
	if upcase(leftstr(theRows, 5)) == 'AUTO_' then
		theRows=rightstr(theRows, length(theRows)-5)
	else
		theRows=entrybox('<TEXTAREA> Enter the number of rows','',Currentcase(theRows),,255)
	endif
	do while Valid_Number(theRows)=FALSE
		theRows=entrybox('<TEXTAREA> Enter the number of rows','', theRows,,255)
	enddo
	if upcase(theRows)=='#OOPS' then
		return
	endif
	if check_mark_on_screen() then
		pbegin_mark()
	endif
	keyin Currentcase('<TEXTAREA NAME="')theName'"'
	if theCols /=='' then
		keyin Currentcase(' COLS='theCols)
	endif
	if theRows /=='' then
		keyin Currentcase(' ROWS='theRows)
	endif
	keyin '>'
	if check_mark_on_screen() then
		pend_mark()
		oldCol=.col
		left
		if .col=oldCol then
			.line=.line-1
			endline
		else
			right
			right
		endif
	endif
	keyin Currentcase('</TEXTAREA>')
	if check_mark_on_screen() then
		unmark
	else
		.col=.col-11
	endif

defc Teletype_tags =
	universal LastDone
	lastDone='Typewriter_tags'
	noArgTags('TT')

defc Underline_tags =
	universal LastDone
	lastDone='Underline_tags'
	noArgTags('U')

defc UnorderedList_tags =
	universal LastDone
	lastDone='UnorderedList_tags'
	theType=getFileArrEl('UL_TYPE')
	theCompact=getFileArrEl('UL_COMPACT')
	if theType ='' then
		theType='/DISC/SQUARE/CIRCLE'
		setFileArrEl('UL_TYPE', theType)
	endif
	if upcase(leftstr(theType, 5))=='AUTO_'then
		theType=rightstr(theType, length(theType)-5)
	else
		parse value listbox('<UL> Choose the Type', upcase(theType), '/Enter/None/Abort', 0,0,3,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theType \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theType=''
		endif
	endif
	if upcase(theCompact)=='AUTO_YES' then
		theCompact=MBID_YES
	elseif upcase(theCompact)=='AUTO_NO' then
		theCompact=MBID_NO
	else
		if upcase(theCompact)='YES' then
		theCompact=winmessagebox('COMPACT?', 'Is this a Compact list?', MB_YESNO + MB_DEFBUTTON1)
		else
		theCompact=winmessagebox('COMPACT?', 'Is this a Compact list?', MB_YESNO + MB_DEFBUTTON2)
		endif
	endif
	keyin currentcase('<UL')
	if theType/=='' then
		keyin currentcase(' TYPE=')theType
	endif
	if theCompact==MBID_YES then
		keyin currentCase(' COMPACT')
	endif
	keyin '>'
	insertline '', .line+1
	insertline currentcase('</UL>'), .line+2
	.line=.line+1
	beginline

defc Variable_tags =
	universal LastDone
	lastDone='Variable_tags'
	noArgTags('VAR')

;----------------------------------Finishing Procs-----------------------------------------
defproc alignArgtags(tag)
	theAlign=getFileArrEl(tag'_ALIGN')
	if theAlign='' then
		theAlign='/LEFT/RIGHT/CENTER'
		setFileArrEl(tag'_ALIGN', theAlign)
	endif
	if upcase(leftstr(theAlign, 5)) == 'AUTO_' then
		theAlign=rightstr(theAlign, length(theAlign)-5)
	else
		parse value listbox('<'tag'> choose the alignment', upcase(theAlign), '/Enter/None/Abort', 0,0,3,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theAlign \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theAlign=''
		endif
	endif
	if check_mark_on_screen() then
		pbegin_mark()
	endif
	keyin currentcase('<'tag)
	if theAlign /== '' then
		keyin currentcase(' ALIGN="'theAlign'"')
	endif
	keyin '>'
	if check_mark_on_screen() then
		pend_mark()
		oldCol=.col
		left
		if .col=oldCol then
			.line=.line-1
			endline
		else
			right
			right
		endif
	endif
	keyin currentcase('</'tag'>')
	if check_mark_on_screen() then
		unmark
	else
		.col=.col-5
	endif



defproc Anchor_all(theLink, theName, theText)
	theRel=GetFileArrEl('A_REV')
	theRev=GetFileArrEl('A_REL')
	theTitle=getFileArrEl('A_TITLE')
	do while (theLink=='')&(theName=='')
 compile if HTML_IF_ARG_BLANK='exit'
		if (theLink=='')&(theName=='') then
			return
		endif
 compile endif
		theLink=entrybox('<A> Enter the link','/Enter/Cancel/Abort',theLink,,255)
		if theLink='' then
			return
		endif
		if theLink=='' then
			theName=entrybox('<A> Enter the name','/Enter/Cancel/Abort','',,255)
			if theName='3' then
				return
			endif
		else
			theName=''
		endif
	enddo
	if upcase(leftstr(theTitle, 5)) == 'AUTO_' then
		theTitle=rightstr(theTitle, length(theTitle)-5)
	else
		theTitle=entrybox('<A> enter the Title','',theTitle,,255)
		if theTitle = '3' then
			return
		endif
	endif
	if theText='' then
		if not check_mark_on_screen() then
			theText=entrybox('<A> Enter the text','/Enter/Cancel/Abort','',,255)
			if theText='' then
				return
			endif
		else
			theText=''
		endif
	else
		unmark
	endif
	if upcase(leftstr(theRev, 5))=='AUTO_' then
		theRev=rightstr(theRev, length(theRev)-5)
	else
		theRev=entrybox('<A> enter the "rev"','/Enter/Cancel/Abort',theRev,,255)
		if theRev='3' then
			return
		endif
	endif
	if upcase(leftstr(theRel, 5))=='AUTO_' then
		theRel=rightstr(theRel, length(theRel)-5)
	else
		theRel=entrybox('<A> enter the "rel"','/Enter/Cancel/Abort',theRel,,255)
		if theRel='3' then
			return
		endif
	endif
	if check_mark_on_screen() then
		pbegin_mark()
	endif
	keyin Currentcase('<A')
	if theLink /== '' then
		keyin Currentcase(' HREF="')theLink'"'
	endif
	if theName /== '' then
		keyin Currentcase(' NAME="')theName'"'
	endif
	if theRev/=='' then
		keyin Currentcase(' REV="')theRev'"'
	endif
	if theRel/=='' then
		keyin Currentcase(' REL="')theRel'"'
	endif
	if theTitle/=='' then
		keyin currentcase(' TITLE="')theTitle'"'
	endif
	keyin Currentcase('>')
	keyin theText
	if check_mark_on_screen() then
		pend_mark()
		oldCol=.col
		left
		if .col=oldCol then
			.line=.line-1
			endline
		else
			right
			right
		endif
	endif
	keyin Currentcase('</A>')
	if check_mark_on_screen() then
		unmark
	else
		if theText='' then
			.col=.col-4
		endif
	endif

defproc Image_all(src)
	theAlternate=GetFileArrEl('IMG_ALT')
	theAlign=GetFileArrEl('IMG_ALIGN')
	theHeight=GetFileArrEl('IMG_HEIGHT')
	theWidth=GetFileArrEl('IMG_WIDTH')
	theBorder=GetFileArrEl('IMG_BORDER')
	theHspace=GetFileArrEl('IMG_HSPACE')
	theVspace=GetFileArrEl('IMG_VSPACE')
	theIsmap=GetFileArrEl('IMG_ISMAP')
	theLowsrc=GetFileArrEl('IMG_LOWSRC')
	theUsemap=GetFileArrEl('IMG_USEMAP')
	theSource=src
	if theAlign='' then
		theAlign='/LEFT/RIGHT/TOP/MIDDLE/BOTTOM'
		setFileArrEl('IMG_ALIGN', theAlign)
	endif
	if upcase(leftstr(theAlternate, 5))=='AUTO_' then
		theAlternate=rightstr(theAlternate, length(theAlternate)-5)
	else
		theAlternate=entrybox('<IMG> Enter the alternate text','/Enter/Cancel/Abort',theAlternate,,255)
	endif
	if upcase(theAlternate)=='3' then
		return
	endif
	if upcase(leftstr(theHeight, 5))=='AUTO_' then
		theHeight=rightstr(theHeight, length(theHeight)-5)
	else
		theHeight=entrybox('<IMG> Enter the height','/Enter/Cancel/Abort',theHeight,,255)
		if upcase(theHeight)=='3' then
			return
		endif
	endif
	do while Valid_Number(theHeight)=FALSE
		theHeight=entrybox('<IMG> Enter the height', '/Enter/Cancel/Abort',theHeight , , 255)
		if upcase(theHeight)=='3' then
			return
		endif
	enddo
	if upcase(leftstr(theWidth, 5))=='AUTO_' then
		theWidth=rightstr(theWidth, length(theWidth)-5)
	else
		theWidth=entrybox('<IMG> Enter the width','/Enter/Cancel/Abort',theWidth,,255)
		if upcase(theWidth)=='3' then
			return
		endif
	endif
	do while Valid_Number(theWidth)=FALSE
		theWidth=entrybox('<IMG> Enter the width', '/Enter/Cancel/Abort', theWidth, , 255)
		if upcase(theWidth)=='3' then
			return
		endif
	enddo
	if upcase(leftstr(theAlign, 5))=='AUTO_' then
		theAlign=rightstr(theAlign, length(theAlign)-5)
	else
		parse value listbox('<IMG> Enter the Alignment', upcase(theAlign), '/Enter/None/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theAlign \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theAlign=''
		endif
	endif
	if upcase(leftstr(theBorder, 5)) == 'AUTO_' then
		theBorder=rightstr(theBorder, length(theBorder)-5)
	else
		theBorder=entrybox('<IMG> Enter the border', '', theBorder,,255)
	endif
	do while Valid_Number(theBorder)=FALSE
		theBorder=entrybox('<IMG> Enter the border', '', theBorder,,255)
	enddo
	if upcase(theBorder)=='#OOPS' then
		return
	endif
	if upcase(leftstr(theHspace, 5)) == 'AUTO_' then
		theHspace=rightstr(theHspace, length(theHspace)-5)
	else
		theHspace=entrybox('<IMG> Enter the horizontal spacing', '', theHspace,,255)
	endif
	do while Valid_Number(theHspace)=FALSE
		theHspace=entrybox('<IMG> Enter the horizontal spacing', '', theHspace,,255)
	enddo
	if upcase(theHspace)=='#OOPS' then
		return
	endif
	if upcase(leftstr(theVspace, 5)) == 'AUTO_' then
		theVspace=rightstr(theVspace, length(theVspace)-5)
	else
		theVspace=entrybox('<IMG> Enter the vertical spacing', '', theVspace,,255)
	endif
	do while Valid_Number(theVspace)=FALSE
		theVspace=entrybox('<IMG> Enter the vertical spacing', '', theVspace,,255)
	enddo
	if upcase(theVspace)=='#OOPS' then
		return
	endif
	if upcase(leftstr(theLowsrc, 5))=='AUTO_' then
		theLowsrc=rightstr(theLowsrc, length(theLowsrc)-5)
	else
		theLowsrc=entrybox('<IMG> Enter the low resolution soruce', '/Enter/Cancel/Abort', theLowsrc, 70,255)
	endif
	if upcase(theLowsrc)=='3' then
		return
	endif
	if upcase(theIsmap)=='AUTO_YES' then
		theIsmap=MBID_YES
	elseif upcase(theIsmap)=='AUTO_NO' then
		theIsmap=MBID_NO
	else
		if upcase(theIsmap)='YES' then
		theIsmap= winmessagebox('ISMAP?', 'Is this image a map?', MB_YESNOCANCEL + MB_DEFBUTTON1)
		else
		theIsmap= winmessagebox('ISMAP?', 'Is this image a map?', MB_YESNOCANCEL + MB_DEFBUTTON2)
		endif
	endif
	if theIsmap=MBID_CANCEL then
		return
	endif
	if theIsmap=MBID_NO then
		if upcase(leftstr(theUsemap, 5)) =='AUTO_' then
			theUsemap=rightstr(theUsemap, length(theUsemap)-5)
		else
			theUsemap=entrybox('<IMG> Enter the map to use','/Enter/Cancel/Abort',theUsemap,,255)
			if theUsemap='3' then
				return
			endif
		endif
	else
		theUsemap=''
	endif
	keyin Currentcase('<IMG SRC="')theSource'"'
	if theAlternate /== '' then
		keyin Currentcase(' ALT="')theAlternate'"'
	endif
	if theAlign /=='' then
		keyin Currentcase(' ALIGN=')theAlign
	endif
	if theHeight /== '' then
		keyin Currentcase(' HEIGHT=')theHeight
	endif
	if theWidth /== '' then
		keyin Currentcase(' WIDTH=')theWidth
	endif
	if theBorder /== '' then
		keyin ' BORDER='theBorder
	endif
	if theHspace /== '' then
		keyin ' HSPACE='theHspace
	endif
	if theVspace /== '' then
		keyin ' VSPACE='theVspace
	endif
	if theLowsrc /== '' then
		keyin ' LOWSRC="'theLowsrc'"'
	endif
	if theIsmap=MBID_YES then
		keyin ' ISMAP'
	endif
	if theUsemap /== '' then
		keyin ' USEMAP="'theUsemap'"'
	endif
	keyin '>'

defproc Multiline_tags(tag)
	keyin Currentcase('<'tag'>')
	insertline '', .line+1
	insertline Currentcase('</'tag'>'), .line+2
	.line=.line+1
	.col=1

defproc noArgTags(tag)
	if check_mark_on_screen() then
		pbegin_mark()
	endif
		keyin Currentcase('<'tag'>')
	if check_mark_on_screen() then
		pend_mark()
		oldCol=.col
		left
		if .col=oldCol then
			.line=.line-1
			endline
		else
			right
			right
		endif
	endif
			keyin Currentcase('</'tag'>')
	if check_mark_on_screen() then
		unmark
	else
		.col=.col-(length(tag)+3)
	endif

defproc Table_XX(tag)
	theColspan=GetFileArrEl(tag'_COLSPAN')
	theRowspan=GetFileArrEl(tag'_ROWSPAN')
	theAlign=GetFileArrEl(tag'_ALIGN')
	theValign=GetFileArrEl(tag'_VALIGN')
	theWrap=GetFileArrEl(tag'_WRAPING')
	theWidth=GetFileArrEl(tag'_WIDTH')
	theHeight=GetFileArrEl(tag'_HEIGHT')
	if theAlign='' then
		theAlign='/CENTER/LEFT/RIGHT'
		setFileArrEl(tag'_ALIGN', theAlign)
	endif
	if theValign='' then
		theValign='/MIDDLE/TOP/BOTTOM'
		setFileArrEl(tag'_VALIGN', theValign)
	endif
	if upcase(leftstr(theColspan, 5))=='AUTO_' then
		theColspan=rightstr(theColspan, length(theColspan)-5)
	else
		theColspan=entrybox('<'tag'> Enter the Colspan','',Currentcase(theColspan),30,255)
	endif
	do while Valid_Number(theColspan)=FALSE
		theColspan=entrybox('<'tag'> Enter the Colspan','', theColspan,30,255)
	enddo
	if upcase(theColspan)=='#OOPS' then
		return
	endif
	if upcase(leftstr(theRowspan, 5))=='AUTO_' then
		theRowspan=rightstr(theRowspan, length(theRowspan)-5)
	else
		theRowspan=entrybox('<'tag'> Enter the Rowspan', '',Currentcase(theRowspan),30,255)
	endif
	do while Valid_Number(theRowspan)=FALSE
		theRowspan=entrybox('<'tag'> Enter the Rowspan','', theRowspan,30,255)
	enddo
	if upcase(theRowspan)=='#OOPS' then
		return
	endif
	if upcase(leftstr(theWidth, 5))=='AUTO_' then
		theWidth=rightstr(theWidth, length(theWidth)-5)
	else
		theWidth=entrybox('<'tag'> Enter the Width', '/Enter/Cancel/Abort',Currentcase(theWidth),30,255)
		if upcase(theWidth)=='3' then
			return
		endif
	endif
	do while Valid_Number(theWidth)=FALSE
		theWidth=entrybox('<'tag'> Enter the Width','/Enter/Cancel/Abort', theWidth,30,255)
		if upcase(theWidth)=='3' then
			return
		endif
	enddo
	if upcase(leftstr(TheHeight, 5))=='AUTO_' then
		TheHeight=rightstr(TheHeight, length(TheHeight)-5)
	else
		TheHeight=entrybox('<'tag'> Enter the Width', '/Enter/Cancel/Abort',Currentcase(TheHeight),30,255)
		if upcase(TheHeight)=='3' then
			return
		endif
	endif
	do while Valid_Number(TheHeight)=FALSE
		TheHeight=entrybox('<'tag'> Enter the Width','/Enter/Cancel/Abort', TheHeight,30,255)
		if upcase(TheHeight)=='3' then
			return
		endif
	enddo
	if upcase(leftstr(theAlign, 5))=='AUTO_' then
		theAlign=rightstr(theAlign, length(theAlign)-5)
	else
		parse value listbox('<'tag'> Choose the horizontal alignment',upcase(theAlign), '/Enter/None/Abort', 0,0,3,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theAlign \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theAlign=''
		endif
	endif
	if upcase(leftstr(theValign, 5))=='AUTO_' then
		theValign=rightstr(theValign, length(theValign)-5)
	else
		parse value listbox('<'tag'> Choose the vertical alignment', upcase(theVAlign), '/Enter/None/Abort', 0,0,3,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 theValign \0
		if (button=\0)|(button=\3) then
			return
		endif
		if button=\2 then
			theValign=''
		endif
	endif
	if upcase(theWrap)=='AUTO_YES' then
		theWrap=MBID_YES
	elseif upcase(theWrap)=='AUTO_NO' then
		theWrap=MBID_NO
	else
		if upcase(theWrap)='NO' then
		theWrap= winmessagebox('Wraping?', 'Do you want to allow wraping within cells?', MB_YESNOCANCEL+MB_DEFBUTTON2)
		else
		theWrap= winmessagebox('Wraping?', 'Do you want to allow wraping within cells?', MB_YESNOCANCEL+MB_DEFBUTTON1)
		endif
	endif
	if theWrap=MBID_CANCEL then
		return
	endif
	if check_mark_on_screen() then
		pbegin_mark()
	endif
	keyin Currentcase('<'tag)
	if theColspan /=='' then
		keyin Currentcase(' COLSPAN='theColspan)
	endif
	if theRowspan /== '' then
		keyin Currentcase(' ROWSPAN='theRowspan)
	endif
	if theAlign /== '' then
		keyin Currentcase(' ALIGN='theAlign)
	endif
	if theValign /== '' then
		keyin Currentcase(' VALIGN='theValign)
	endif
	if theWidth /=='' then
		keyin Currentcase(' WIDTH='theWidth)
	endif
	if theHeight /=='' then
		keyin Currentcase(' HEIGHT='theHeight)
	endif
	if theWrap=MBID_NO then
		keyin Currentcase(' NOWRAP')
	endif
	keyin '>'
	if check_mark_on_screen() then
		pend_mark()
		oldCol=.col
		left
		if .col=oldCol then
			.line=.line-1
			endline
		else
			right
			right
		endif
	endif
		keyin Currentcase('</'tag'>')
	if check_mark_on_screen() then
		unmark
	else
		.col=.col-5
	endif

;                                    Interface stuff----------
defc case_toggle
	universal kase
	if kase=0 then
		kase=1
		sayerror 'Upper case'
		return
		
	else
		kase=0
		sayerror 'Lower case'
		return
	endif

defproc Currentcase(theString)
	universal kase
	if kase=1 then
		return upcase(theString)
	else
		return lowcase(theString)
	endif

defc ClearDefaultArgs =
	arrayID=.userstring
	val=''
	argsLine=translate(TagsListAll, ' ', '/')
	x=1
	elName=word(argsLine, x)
	do while elName/==''
		x=x+1
		do_array 2, arrayID, elName, val
		elName=word(argsLine, x)
	enddo
	sayerror 'Defaults cleared'


defproc getFileArrEl(stem)
	arrayID=.userstring
	do_array 7, arrayID, stem, val
	return val

defc Last_Tag
	universal lastDone
	lastDone

defproc loadFileArrEl(elName)
	arrayID=.userstring
	val=get_EAT_ASCII_value(elName)
	do_array 2, arrayID, elName, val

defc loadFileArr
	argsLine=translate(TagsListAll, ' ', '/')
	x=1
	elName=word(argsLine, x)
	do while elName/==''
		LoadFileArrEl(elName)
		x=x+1
		elName=word(argsLine, x)
	enddo
	sayerror 'Defaults loaded'


defc saveFileArr
	argsLine=translate(TagsListAll, ' ', '/')
	x=1
	elName=word(argsLine, x)
	do while elName/==''
		SaveFileArrEl(elName)
		x=x+1
		elName=word(argsLine, x)
	enddo
	sayerror 'Defaults saved'

defproc saveFileArrEl(elName)
	arrayID=.userstring
	do_array 7, arrayID, elName, val
	OldVal=get_EAT_ASCII_VALUE(elName)
	if (val/==Oldval) then
		delete_ea(elName)
		'rx updateea F_FILE='.filename' EL_NAME='elName' EL_VAL='val'_END'
		'add_ea 'elName' 'val
	elseif (length(val)=0)&(length(oldval)>0) then
		winmessagebox('', 'Oldval='oldval' val='val, MB_OK)
	endif

defc SetDefaultArgs =
	parse value listbox('Chose the tag arguement do default', TagsListAll, '/Enter/Abort', 0,0,10,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_to_set \0
	if (button=\0)|(button=\2) then
		return
	endif
	oldValue=GetFileArrEl(EA_to_set)
	if EA_to_set == 'CAPTION_ALIGN' then
		parse value listbox('Choose the default <CAPTION> alignment', '/TOP/BOTTOM/AUTO_TOP/AUTO_BOTOM/AUTO_', '/Enter/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if EA_value == 'BOTTOM' then
			setFileArrEl(EA_to_set,' /BOTOM/TOP')
			return
		elseif EA_value == 'AUTO_TOP' then
			setFileArrEl(EA_to_set, 'AUTO_TOP')
			return
		elseif EA_value == 'AUTO_BOTOM' then
			setFileArrEl(EA_to_set, 'AUTO_BOTOM')
			return
		elseif EA_value == 'AUTO_' then
			setFileArrEl(EA_to_set, 'AUTO_')
			return
		else
			setFileArrEl(EA_to_set, '/TOP/BOTOM')
			return
		endif
	elseif EA_to_set == 'UL_TYPE' then
		parse value listbox('<OL> Choose the type' ,'/DISC/SQUARE/CIRCLE/AUTO_DISC/AUTO_SQUARE/AUTO_CIRCLE/AUTO_', '/Enter/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if upcase(leftstr(EA_value,5))=='AUTO_' then
			setFileArrEl(EA_to_set, EA_value)
		elseif EA_value=='SQUARE' then
			setFileArrEl(EA_to_set, '/SQUARE/CIRCLE/DISC')
		elseif EA_value=='CIRCLE' then
			setFileArrEl(EA_to_set, '/CIRCLE/DISC/SQUARE')
		else
			setFileArrEl(EA_to_set, '/DISC/SQUARE/CIRCLE')
		endif
	elseif EA_to_set == 'OL_TYPE' then
		parse value listbox('<OL> Choose the type' ,'/1/a/A/i/I/AUTO_1/AUTO_a/AUTO_A/AUTO_i/AUTO_I/AUTO_/', '/Enter/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if upcase(leftstr(EA_value,5))=='AUTO_' then
			setFileArrEl(EA_to_set, EA_value)
		elseif EA_value=='a' then
			setFileArrEl(EA_to_set, '/a/A/i/I/1')
		elseif EA_value=='A' then
			setFileArrEl(EA_to_set, '/A/i/I/1/a')
		elseif EA_value=='i' then
			setFileArrEl(EA_to_set, '/i/I/1/a/A')
		elseif EA_value=='I' then
			setFileArrEl(EA_to_set, '/I/1/a/A/i')
		else
			setFileArrEl(EA_to_set, '/1/a/A/i/I')
		endif
	elseif EA_to_set == 'BR_CLEAR' then
		parse value listbox('Choose the default <BR> CLEAR' ,'/LEFT/RIGHT/ALL/NONE/AUTO_LEFT/AUTO_RIGHT/AUTO_ALL/AUTO_NONE/AUTO_', '/Enter/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if upcase(leftstr(EA_value, 5)) == 'AUTO_' then
			setFileArrEl(EA_to_set, EA_value)
		elseif EA_value == 'RIGHT' then
			setFileArrEl(EA_to_set, '/RIGHT/ALL/NONE/LEFT')
		elseif EA_value == 'ALL' then
			setFileArrEl(EA_to_set, '/ALL/NONE/LEFT/RIGHT')
		elseif EA_value == 'NONE' then
			setFileArrEl(EA_to_set, '/NONE/LEFT/RIGHT/ALL')
		else
			setFileArrEl(EA_to_set, '/LEFT/RIGHT/ALL/NONE')
		endif
	elseif EA_to_set == 'APPLET_ALIGN' then
		parse value listbox('Choose the default <APPLET> alignment', '/LEFT/RIGHT/TOP/BOTTOM/MIDDLE/AUTO_LEFT/AUTO_RIGHT/AUTO_TOP/AUTO_BOTTOM/AUTO_MIDDLE', '/Enter/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if EA_value == 'RIGHT' then
			setFileArrEl(EA_to_set, '/RIGHT/TOP/BOTTOM/MIDDLE/LEFT')
		elseif EA_value == 'TOP' then
			setFileArrEl(EA_to_set, '/TOP/BOTTOM/MIDDLE/LEFT/RIGHT')
		elseif EA_value == 'BOTTOM' then
			setFileArrEl(EA_to_set, '/BOTTOM/MIDDLE/LEFT/RIGHT/TOP')
		elseif EA_value == 'MIDDLE' then
			setFileArrEl(EA_to_set, '/MIDDLE/LEFT/RIGHT/TOP/BOTTOM')
		elseif upcase(leftstr(EA_value, 5)) =='AUTO_' then
			setFileArrEl(EA_to_set, EA_value)
		else
			setFileArrEl(EA_to_set, '/LEFT/RIGHT/TOP/BOTTOM/MIDDLE')
		endif
	elseif EA_to_set == 'AREA_SHAPE' then
		parse value listbox('Choose the default <AREA> shape', '/RECT/CIRCLE/POLY/DEFAULT/AUTO_RECT/AUTO_CIRCLE/AUTO_POLY/AUTO_DEFAULT', '/Enter/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if EA_value == 'CIRCLE' then
			setFileArrEl(EA_to_set, '/CIRCLE/POLY/DEFAULT/RECT')
		elseif EA_value == 'POLY' then
			setFileArrEl(EA_to_set, '/POLY/DEFAULT/RECT/CIRCLE')
		elseif EA_value == 'DEFAULT' then
			setFileArrEl(EA_to_set, '/DEFAULT/RECT/CIRCLE/POLY')
		elseif upcase(leftstr(EA_value, 5)) =='AUTO_' then
			setFileArrEl(EA_to_set, EA_value)
		else
			setFileArrEl(EA_to_set, '/RECT/CIRCLE/POLY/DEFAULT')
		endif
	elseif EA_to_set == 'DEFAULT_PATH' then
		EA_value=entrybox('Enter the default path','','',,255)
		if EA_value /== '' then
			if GetFileArrEl('A_REV') == '' then
				setFileArrEl('A_REL', EA_value)
			endif
			if GetFileArrEl('A_REV') == '' then
				setFileArrEl('A_REL', EA_value)
			endif
			if GetFileArrEl('A_LINK') == '' then
				setFileArrEl('A_LINK', EA_value)
			endif
			if GetFileArrEl('APPLET_CODE') == '' then
				setFileArrEl('APPLET_CODE', EA_value)
			endif
			if GetFileArrEl('FORM_ACTION') == '' then
				setFileArrEl('FORM_ACTION', EA_value)
			endif
			if GetFileArrEl('IMG_SOURCE') == '' then
				setFileArrEl('IMG_SOURCE', EA_value)
			endif
			if GetFileArrEl('LINK_LINK') == '' then
				setFileArrEl('LINK_LINK', EA_value)
			endif
			if GetFileArrEl('INPUT_IMAGE_SOURCE') == '' then
				setFileArrEl('INPUT_IMAGE_SOURCE', EA_value)
			endif
			if GetFileArrEl('FRAME_SOURCE') == '' then
				setFileArrEl('FRAME_SOURCE', EA_value)
			endif
		endif
	elseif EA_to_set == 'FORM_METHOD' then
		parse value listbox('Choose the default <FORM> method', '/GET/POST/AUTO_GET/AUTO_POST', '/Enter/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if upcase(leftstr(EA_value, 5)) == 'AUTO_' then
			setFileArrEl(EA_to_set, EA_value)
			return
		elseif EA_value =='POST' then
			setFileArrEl(EA_to_set, '/POST/GET')
			return
		else
			setFileArrEl(EA_to_set, '/GET/POST')
			return
		endif
	elseif EA_to_set == 'FRAME_SCROLLING' then
		parse value listbox('<FRAME_SCROLLING>','/YES/NO/AUTO/AUTO_YES/AUTO_NO/AUTO_AUTO/AUTO_', '/Enter/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if EA_value=='NO' then
			setFileArrEl(EA_to_set'/NO/AUTO/YES')
			return
		elseif EA_value=='AUTO' then
			setFileArrEl(EA_to_set'/AUTO/YES/NO')
			return
		elseif EA_value =='YES' then
			setFileArrEl(EA_to_set'/YES/NO/AUTO')
			return
		else
			setFileArrEl(EA_to_set, EA_value)
			return
		endif
	elseif (EA_to_set == 'IMG_ALIGN')|(EA_to_set == 'INPUT_IMAGE_ALIGN') then
		parse value listbox('Choose the default <IMG> alignment', '/TOP/MIDDLE/BOTTOM/LEFT/RIGHT/AUTO_TOP/AUTO_MIDDLE/AUTO_BOTTOM/AUTO_LEFT/AUTO_RIGHT/AUTO_', '/Enter/Abort', 0,0,11,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if upcase(leftstr(EA_Value, 5))=='AUTO_' then
			setFileArrEl(EA_to_set, EA_value)
		elseif EA_value == 'MIDDLE' then
			setFileArrEl(EA_to_set, '/MIDDLE/BOTTOM/LEFT/RIGHT/TOP')
			return
		elseif EA_value == 'BOTTOM' then
			setFileArrEl(EA_to_set, '/BOTTOM/LEFT/RIGHT/TOP/MIDDLE')
			return
		elseif EA_value == 'LEFT' then
			setFileArrEl(EA_to_set, '/LEFT/RIGHT/TOP/MIDDLE/BOTTOM')
			return
		elseif EA_value == 'RIGHT' then
			setFileArrEl(EA_to_set, '/RIGHT/TOP/MIDDLE/BOTTOM/LEFT')
			return
		else
			setFileArrEl(EA_to_set, '/TOP/MIDDLE/BOTTOM/LEFT/RIGHT')
			return
		endif
	elseif wordpos(EA_to_set, 'IMG_ISMAP IS_INDEX INPUT_CHECKBOX_CHECKED INPUT_RADIO_CHECKED FRAME_NORESIZE OL_COMPACT OL_COMPACT TD_WRAPING TH_WRAPING') then
		parse value listbox('Choose the default 'EA_to_set' value', '/YES/NO/AUTO_YES/AUTO_NO', '/Enter/Abort', 0,0,4,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		setFileArrEl(EA_to_set, EA_value)
	elseif EA_to_set == 'INPUT_TYPE' then
		parse value listbox('Choose the default input type', '/CHECKBOX/HIDDEN/IMAGE/PASSWORD/RADIO/RESET/SUBMIT/TEXT/AUTO_CHECKBOX/AUTO_HIDDEN/AUTO_IMAGE/AUTO_PASSWORD/AUTO_RADIO/AUTO_RESET/AUTO_SUBMIT/AUTO_TEXT', '/Enter/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if upcase(leftstr(EA_value, 5)) = 'AUTO_' then
			setFileArrEl(EA_to_set, EA_value)
		elseif EA_value == 'HIDDEN' then
			setFileArrEl(EA_to_set, '/HIDDEN/IMAGE/PASSWORD/RADIO/RESET/SUBMIT/TEXT/CHECKBOX')
			return
		elseif EA_value == 'IMAGE' then
			setFileArrEl(EA_to_set, '/IMAGE/PASSWORD/RADIO/RESET/SUBMIT/TEXT/CHECKBOX/HIDDEN')
			return
		elseif EA_value == 'PASSWORD' then
			setFileArrEl(EA_to_set, '/PASSWORD/RADIO/RESET/SUBMIT/TEXT/CHECKBOX/HIDDEN/IMAGE')
			return
		elseif EA_value == 'RADIO' then
			setFileArrEl(EA_to_set, '/RADIO/RESET/SUBMIT/TEXT/CHECKBOX/HIDDEN/IMAGE/PASSWORD')
			return
		elseif EA_value == 'RESET' then
			setFileArrEl(EA_to_set, '/RESET/SUBMIT/TEXT/CHECKBOX/HIDDEN/IMAGE/PASSWORD/RADIO')
			return
		elseif EA_value == 'SUBMIT' then
			setFileArrEl(EA_to_set, '/SUBMIT/TEXT/CHECKBOX/HIDDEN/IMAGE/PASSWORD/RADIO/RESET')
			return
		elseif EA_value == 'TEXT' then
			setFileArrEl(EA_to_set, '/TEXT/CHECKBOX/HIDDEN/IMAGE/PASSWORD/RADIO/RESET/SUBMIT')
		else
			setFileArrEl(EA_to_set, '/CHECKBOX/HIDDEN/IMAGE/PASSWORD/RADIO/RESET/SUBMIT/TEXT')
			return
		endif
	elseif wordpos(EA_to_set, 'P_ALIGN TD_ALIGN TR_ALIGN TH_ALIGN HR_ALIGN DIV_ALIGN H1_ALIGN H2_ALIGN H3_ALIGN H4_ALIGN H5_ALIGN H6_ALIGN') then
		parse value listbox('Choose the default 'EA_to_set' alignment', '/LEFT/RIGHT/CENTER/AUTO_LEFT/AUTO_RIGHT/AUTO_CENTER/AUTO_', '/Enter/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if EA_value == 'RIGHT' then
			setFileArrEl(EA_to_set, '/RIGHT/CENTER/LEFT')
			return
		elseif EA_value == 'CENTER' then
			setFileArrEl(EA_to_set, '/CENTER/LEFT/RIGHT')
			return
		elseif EA_value == 'AUTO_LEFT' then
			setFileArrEl(EA_to_set, 'AUTO_LEFT')
			return
		elseif EA_value == 'AUTO_RIGHT' then
			setFileArrEl(EA_to_set, 'AUTO_RIGHT')
			return
		elseif EA_value == 'AUTO_CENTER' then
			setFileArrEl(EA_to_set, 'AUTO_CENTER')
			return
		elseif EA_value == 'AUTO_' then
			setFileArrEl(EA_to_set, 'AUTO_')
			return
		else
			setFileArrEl(EA_to_set, '/LEFT/RIGHT/CENTER')
			return
		endif
	elseif (EA_to_set == 'TR_VALIGN')|(EA_to_set == 'TD_VALIGN')|(EA_to_set == 'TH_VALIGN') then
		parse value listbox('Choose the default 'EA_to_set' vertical alignment', '/TOP/MIDDLE/BOTTOM/AUTO_TOP/AUTO_MIDDLE/AUTO_BOTTOM/AUTO_', '/Enter/Abort', 0,0,5,,atoi(0)||atoi(1)||atoi(1)||atoi(0)) with button 2 EA_Value \0
		if (button=\0)|(button=\2) then
			return
		endif
		if EA_value == 'AUTO_' then
			setFileArrEl(EA_to_set, 'AUTO_')
			return
		elseif EA_value == 'MIDDLE' then
			setFileArrEl(EA_to_set, '/MIDDLE/BOTTOM/TOP')
			return
		elseif EA_value == 'BOTTOM' then
			setFileArrEl(EA_to_set, '/BOTTOM/TOP/MIDDLE')
			return
		elseif EA_value == 'AUTO_TOP' then
			setFileArrEl(EA_to_set, EA_value)
			return
		elseif EA_value == 'AUTO_MIDDLE' then
			setFileArrEl(EA_to_set, EA_value)
			return
		elseif EA_value == 'AUTO_BOTTOM' then
			setFileArrEl(EA_to_set, EA_value)
		else
			setFileArrEl(EA_to_set, '/TOP/MIDDLE/BOTTOM')
			return
		endif
	else
		EA_value=entrybox('Enter the default value for 'EA_to_set,'',oldValue,,255)
		if EA_value /== '#OOPS' then
			setFileArrEl(EA_to_set, EA_value)
		endif
		return
	endif

defproc setFileArrEl(stem, val)
	arrayID=.userstring
	do_array 2, arrayID, stem, val

;                                Drag & Drop
defc DRAGDROP_CLASS
	universal kase
	FullFile=arg(1)
	srcLine=translate(FullFile, '/', '\')
	uPath=getFileArrEl('U_PATH')
	uLen=length(uPath)
	if uPath==leftstr(srcLine, uLen) then
		theSource=rightstr(srcLine, length(srcLine)-uLen)
	else
		theSource=rightstr(srcLine, length(srcLine)-lastPos('/', srcLine))
	endif
	'rx AddApplet 'kase' 'FullFile' 'theSource

defc DRAGDROP_GIF
	universal kase
	if wordpos(filetype(), HTML_EXTENSIONS) then
		fpath=arg(1)
		srcLine=translate(fPath, '/', '\')
		uPath=getFileArrEl('U_PATH')
		uLen=length(uPath)
		if uPath==leftstr(srcLine, uLen) then
			theSource=rightstr(srcLine, length(srcLine)-uLen)
		else
			theSource=rightstr(srcLine, length(srcLine)-lastPos('/', srcLine))
		endif
		getline theLine
		'rx AddGif 'kase' '.col' F_FILE='fpath'F_TEXT='theSource'_LINE='theLine
	endif

defc DRAGDROP_JPG
	universal kase
	if wordpos(filetype(), HTML_EXTENSIONS) then
		fpath=arg(1)
		srcLine=translate(fPath, '/', '\')
		uPath=getFileArrEl('U_PATH')
		uLen=length(uPath)
		if uPath==leftstr(srcLine, uLen) then
			theSource=rightstr(srcLine, length(srcLine)-uLen)
		else
			theSource=rightstr(srcLine, length(srcLine)-lastPos('/', srcLine))
		endif
		getline theLine
		'rx AddJpg 'kase' '.col' F_FILE='fpath'F_TEXT='theSource'_LINE='theLine
	endif

defc DRAGDROP_XTML =
	universal kase
	if wordpos(filetype(), HTML_EXTENSIONS) then
		if winmessagebox('XTML File', 'Do you want to import (yes) this?', MB_YESNO) = MBID_YES then
			'get 'arg(1)
		else
			'e 'arg(1)
		endif
	else
		'e 'arg(1)
	endif

defc DRAGDROP_HTM, DRAGDROP_HTML, DRGDRPTYP_HTML =
	universal kase
	if wordpos(filetype(), HTML_EXTENSIONS) then
		HToption=''
		fString=arg(1)
		HToption=listbox('What to do with this file', Currentcase('/Load/Link'))
		if HToption=='' then
			return
		elseif HToption=='LOAD' then
			'e 'fString
		else
			uPath=translate(getFileArrEl('U_PATH'),'/','\')
			uString=translate(fstring,'/','\')
			if leftstr(uString, length(uPath))==uPath then
				uString=rightstr(uString, length(uString)-length(uPath))
			else
				uString=rightstr(uString, length(uSTring)-lastpos('/', uString))
			endif
		getline theLine
		'rx addhtml 'kase' '.col' F_FILE='fString'F_TEXT='uString'_LINE='theLine
		endif
	else
		'e 'arg(1)
	endif

defc DRGDRPTYP_URL, DRGDRPTYP_WEBEXPLORER_URL, DRGDRPTYP_UNIFORMRESOURCELOCATOR =
	universal kase
	if wordpos(filetype(), HTML_EXTENSIONS) then
		srcLine=arg(1)
		getline theLine
		'rx addURl 'kase' '.col' F_FILE='srcLine'_LINE='theLine
endif
;                                Misc

defproc tabber
	newcol=.col
	getline line
	.line=.line+1
	getline nextline
	.line=.line-1
	if .col=length(line)+1 then
		.line=.line+1
		.col=1
		return
	endif
	line=rightstr(line ,length(line)-.col+1)
	do while length(line)>0
		linefrag=leftstr(line, 2)
		newcol=newcol+1
		if (linefrag=='><')or(linefrag=='=>')or(linefrag=='=%')or(linefrag=='""')or(linefrag=='= ')or(linefrag=='# ')or(linefrag=='#>') then
			.col=newcol
			return
		endif
		line=rightstr(line, length(line)-1)
	enddo
	endline

defproc back_tabber
	newcol=.col
	getline line
	.line=.line+1
	getline nextline
	.line=.line-1
	if .col=1 then
		.line=.line-1
		endline
		return
	endif
	line=leftstr(line ,.col-1)
	do while length(line)>0
		linefrag=rightstr(line, 2)
		newcol=newcol-1
		if (linefrag=='><')or(linefrag=='=>')or(linefrag=='=%')or(linefrag=='""')or(linefrag=='= ')or(linefrag=='# ')or(linefrag=='#>') then
			.col=newcol
			return
		endif
		line=leftstr(line, length(line)-1)
	enddo
	beginline

defproc Valid_Color(theString)
	if length(theString)=0 then
		return TRUE
	endif
	if length(theString) <> 6 then
		return FALSE
	endif
	testString=upcase(theString)
	do while length(testString) > 0
		testchar=leftstr(testString, 1)
		if	(testchar /== '0')&(testchar /== '1')&(testchar /== '2')&
			(testchar /== '3')&(testchar /== '4')&(testchar /== '5')&
			(testchar /== '6')&(testchar /== '7')&(testchar /== '8')&
			(testchar /== '9')&(testchar /== 'A')&(testchar /== 'B')&
			(testchar /== 'C')&(testchar /== 'D')&(testchar /== 'E')&
			(testchar /== 'F') then
			return FALSE
		endif
		if length(testString)=1 then
			return TRUE
		endif
		testString=rightstr(testString, length(testString)-1)
	enddo
	return TRUE

defproc Valid_Number(theString)
	if upcase(theString)=='#OOPS' then
		return TRUE
	endif
	if length(theString)=0 then
		return TRUE
	endif
	testString=theString
	do while length(testString) > 0
		testchar=leftstr(testString, 1)
		if	(testchar /== '0')&(testchar /== '1')&(testchar /== '2')&
			(testchar /== '3')&(testchar /== '4')&(testchar /== '5')&
			(testchar /== '6')&(testchar /== '7')&(testchar /== '8')&
			(testchar /== '9') then
			return FALSE
		endif
		if length(testString)=1 then
			return TRUE
		endif
		testString=rightstr(testString, length(testString)-1)
	enddo
	return TRUE

defproc Valid_Number2(theString)
	if upcase(theString)=='#OOPS' then
		return TRUE
	endif
	if length(theString)=0 then
		return FALSE
	endif
	testString=theString
	do while length(testString) > 0
		testchar=leftstr(testString, 1)
		if	(testchar /== '0')&(testchar /== '1')&(testchar /== '2')&
			(testchar /== '3')&(testchar /== '4')&(testchar /== '5')&
			(testchar /== '6')&(testchar /== '7')&(testchar /== '8')&
			(testchar /== '9') then
			return FALSE
		endif
		if length(testString)=1 then
			return TRUE
		endif
		testString=rightstr(testString, length(testString)-1)
	enddo
	return TRUE

defproc Valid_Number3(theString)
	if upcase(theString)=='#OOPS' then
		return TRUE
	endif
	if length(theString)>2 then
		return FALSE
	endif
	testString=theString
	do while length(testString) > 0
		testchar=leftstr(testString, 1)
		if	(testchar /== '0')&(testchar /== '1')&(testchar /== '2')&
			(testchar /== '3')&(testchar /== '4')&(testchar /== '5')&
			(testchar /== '6')&(testchar /== '7')&(testchar /== '8')&
			(testchar /== '9')&(testchar /== '+')&(testchar /== '-') then
			return FALSE
		endif
		if length(testString)=1 then
			return TRUE
		endif
		testString=rightstr(testString, length(testString)-1)
	enddo
	return TRUE

defproc Valid_Number4(theString)
	if upcase(theString)=='#OOPS' then
		return TRUE
	endif
	if length(theString)=0 then
		return FALSE
	endif
	testString=theString
	do while length(testString) > 0
		testchar=leftstr(testString, 1)
		if	(testchar /== '0')&(testchar /== '1')&(testchar /== '2')&
			(testchar /== '3')&(testchar /== '4')&(testchar /== '5')&
			(testchar /== '6')&(testchar /== '7')&(testchar /== '8')&
			(testchar /== '9')&(testchar /== '*')&(testchar /== ',')&
			(testchar /== '%')&(testchar /== ' ') then
			return FALSE
		endif
		if length(testString)=1 then
			return TRUE
		endif
		testString=rightstr(testString, length(testString)-1)
	enddo
	return TRUE

 compile if HTML_URL_KLUDGE=1
defc check_if_url
	universal URLline, kase
	if .last >1  then
		return
	else
		URLline=textline(1)
		URLtitle=.filename
		if URLcheck(URLline) then
			'quit'
		getline theLine
		'rx addUrl 'kase' '.col' F_FILE='URLtitle'_LINE='theLine
		endif
	endif


defselect
	'check_if_url'

defproc URLCheck(cString)
	if upcase(leftstr(cString, 7))=='HTTP://' then
		return true
	elseif upcase(leftstr(cString, 6))=='FTP://' then
		return true
	elseif upcase(leftstr(cString, 7))=='WAIS://' then
		return true
	elseif upcase(leftstr(cString, 9))=='GOPHER://' then
		return true
	elseif upcase(leftstr(cString, 9))=='TELNET://' then
		return true
	elseif upcase(leftstr(cString, 5))=='NEWS:' then
		return true
	elseif upcase(leftstr(cString, 7))=='MAILTO:' then
		return true
	else
		return false
	endif
 compile endif

defproc addHTMLmenu
	universal defaultmenu
	deletemenu defaultmenu, 6, 0, 0  -- delete the existing Help menu (we want it to stay at the right)
	buildsubmenu defaultmenu, 900, 'HTML', '',0,0
	buildmenuitem defaultmenu, 900, 40001, NEW_FILE_TAGS_MENU_MSG\9NEW_FILE_TAGS_KEY_MSG, NEW_FILE_TAGS_ACTION\1NEW_FILE_TAGS_BAR_MSG ,0, 0
	buildmenuitem defaultmenu, 900, 40002, NEWPAGE_TAGS_MENU_MSG\9NEWPAGE_TAGS_KEY_MSG, NEWPAGE_TAGS_ACTION\1NEWPAGE_TAGS_BAR_MSG ,0, 0
	buildmenuitem defaultmenu, 900, 41000, HEAD_SUB_MENU_MSG\9HEAD_SUB_KEY_MSG, HEAD_SUB_ACTION\1HEAD_SUB_BAR_MSG, 17, 0
		buildmenuitem defaultmenu, 900, 41001, LINK_TAGS_MENU_MSG\9LINK_TAGS_KEY_MSG, LINK_TAGS_ACTION\1LINK_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 41002, META_TAGS_MENU_MSG\9META_TAGS_KEY_MSG, META_TAGS_ACTION\1META_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 41003, STYLE_TAGS_MENU_MSG\9STYLE_TAGS_KEY_MSG, STYLE_TAGS_ACTION\1STYLE_TAGS_BAR_MSG,32769,0
	buildmenuitem defaultmenu, 900, 42000, FORMATING_SUB_MENU_MSG\9FORMATING_SUB_KEY_MSG, FORMATING_SUB_ACTION\1FORMATING_SUB_BAR_MSG,17,0
		buildmenuitem defaultmenu, 900, 42100, BLOCKLEVEL_TAGS_MENU_MSG\9BLOCKLEVEL_TAGS_KEY_MSG, BLOCKLEVEL_TAGS_ACTION\1BLOCKLEVEL_TAGS_BAR_MSG,17,0
			buildmenuitem defaultmenu, 900, 42101, ADDRESS_TAGS_MENU_MSG\9ADDRESS_TAGS_KEY_MSG, ADDRESS_TAGS_ACTION\1ADDRESS_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 42102, BLOCKQUOTE_TAGS_MENU_MSG\9BLOCKQUOTE_TAGS_KEY_MSG, BLOCKQUOTE_TAGS_ACTION\1BLOCKQUOTE_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 42103, CENTER_TAGS_MENU_MSG\9CENTER_TAGS_KEY_MSG, CENTER_TAGS_ACTION\1CENTER_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 42104, DIVISION_TAGS_MENU_MSG\9DIVISION_TAGS_KEY_MSG, DIVISION_TAGS_ACTION\1DIVISION_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 42105, H1_TAGS_MENU_MSG\9H1_TAGS_KEY_MSG, H1_TAGS_ACTION\1H1_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 42106, H2_TAGS_MENU_MSG\9H2_TAGS_KEY_MSG, H2_TAGS_ACTION\1H2_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 42107, H3_TAGS_MENU_MSG\9H3_TAGS_KEY_MSG, H3_TAGS_ACTION\1H3_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 42108, H4_TAGS_MENU_MSG\9H4_TAGS_KEY_MSG, H4_TAGS_ACTION\1H4_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 42109, H5_TAGS_MENU_MSG\9H5_TAGS_KEY_MSG, H5_TAGS_ACTION\1H5_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 52100, H6_TAGS_MENU_MSG\9H6_TAGS_KEY_MSG, H6_TAGS_ACTION\1H6_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 52101, RULE_TAGS_MENU_MSG\9RULE_TAGS_KEY_MSG, RULE_TAGS_ACTION\1RULE_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 52102, PARAGRAPH_TAGS_MENU_MSG\9PARAGRAPH_TAGS_KEY_MSG, PARAGRAPH_TAGS_ACTION\1PARAGRAPH_TAGS_BAR_MSG,0,0
			buildmenuitem defaultmenu, 900, 52103, PREFORMATED_TAGS_MENU_MSG\9PREFORMATED_TAGS_KEY_MSG, PREFORMATED_TAGS_ACTION\1PREFORMATED_TAGS_BAR_MSG,32769,0
		buildmenuitem defaultmenu, 900, 42200, TEXTLEVEL_SUB_MENU_MSG\9TEXTLEVEL_SUB_KEY_MSG, TEXTLEVEL_SUB_ACTION\1TEXTLEVEL_SUB_BAR_MSG,17,0
			buildmenuitem defaultmenu, 900, 42210, LOGICAL_SUB_MENU_MSG\9LOGICAL_SUB_KEY_MSG, LOGICAL_SUB_ACTION\1LOGICAL_SUB_BAR_MSG,17,0
				buildmenuitem defaultmenu, 900, 42211, CITATION_TAGS_MENU_MSG\9CITATION_TAGS_KEY_MSG, CITATION_TAGS_ACTION\1CITATION_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42212, CODE_TAGS_MENU_MSG\9CODE_TAGS_KEY_MSG, CODE_TAGS_ACTION\1CODE_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42213, DEFINITION_TAGS_MENU_MSG\9DEFINITION_TAGS_KEY_MSG, DEFINITION_TAGS_ACTION\1DEFINITION_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42214, EMPHASIZED_TAGS_MENU_MSG\9EMPHASIZED_TAGS_KEY_MSG, EMPHASIZED_TAGS_ACTION\1EMPHASIZED_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42215, KEYBOAED_TAGS_MENU_MSG\9KEYBOAED_TAGS_KEY_MSG, KEYBOAED_TAGS_ACTION\1KEYBOAED_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42216, SAMPLE_TAGS_MENU_MSG\9SAMPLE_TAGS_KEY_MSG, SAMPLE_TAGS_ACTION\1SAMPLE_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42217, STRONG_TAGS_MENU_MSG\9STRONG_TAGS_KEY_MSG, STRONG_TAGS_ACTION\1STRONG_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42218, VARIABLE_TAGS_MENU_MSG\9VARIABLE_TAGS_KEY_MSG, VARIABLE_TAGS_ACTION\1VARIABLE_TAGS_BAR_MSG,32769,0
			buildmenuitem defaultmenu, 900, 42220, PHYSICAL_SUB_MENU_MSG\9PHYSICAL_SUB_KEY_MSG, PHYSICAL_SUB_ACTION\1PHYSICAL_SUB_BAR_MSG,17,0
				buildmenuitem defaultmenu, 900, 42221, BOLD_TAGS_MENU_MSG\9BOLD_TAGS_KEY_MSG, BOLD_TAGS_ACTION\1BOLD_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42222, BIG_TAGS_MENU_MSG\9BIG_TAGS_KEY_MSG, BIG_TAGS_ACTION\1BIG_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42223, FONT_TAGS_MENU_MSG\9FONT_TAGS_KEY_MSG, FONT_TAGS_ACTION\1FONT_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42224, ITALICS_TAGS_MENU_MSG\9ITALICS_TAGS_KEY_MSG, ITALICS_TAGS_ACTION\1ITALICS_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42225, SMALL_TAGS_MENU_MSG\9SMALL_TAGS_KEY_MSG, SMALL_TAGS_ACTION\1SMALL_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42226, STRIKEOUT_TAGS_MENU_MSG\9STRIKEOUT_TAGS_KEY_MSG, STRIKEOUT_TAGS_ACTION\1STRIKEOUT_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42227, SUBSCTIPT_TAGS_MENU_MSG\9SUBSCTIPT_TAGS_KEY_MSG, SUBSCTIPT_TAGS_ACTION\1SUBSCTIPT_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42228, SUPERSCRIPT_TAGS_MENU_MSG\9SUPERSCRIPT_TAGS_KEY_MSG, SUPERSCRIPT_TAGS_ACTION\1SUPERSCRIPT_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 42229, TELETYPE_TAGS_MENU_MSG\9TELETYPE_TAGS_KEY_MSG, TELETYPE_TAGS_ACTION\1TELETYPE_TAGS_BAR_MSG,0,0
				buildmenuitem defaultmenu, 900, 52220, UNDERLINE_TAGS_MENU_MSG\9UNDERLINE_TAGS_KEY_MSG, UNDERLINE_TAGS_ACTION\1UNDERLINE_TAGS_BAR_MSG,32769,0
			buildmenuitem defaultmenu, 900, 42201, '', '',32769,0
		buildmenuitem defaultmenu, 900, 42001, BASEFONT_TAGS_MENU_MSG\9BASEFONT_TAGS_KEY_MSG, BASEFONT_TAGS_ACTION\1BASEFONT_TAGS_BAR_MSG,32769,0
	buildmenuitem defaultmenu, 900, 43000, TABLES_SUB_MENU_MSG\9TABLES_SUB_KEY_MSG, TABLES_SUB_ACTION\1TABLES_SUB_BAR_MSG,17,0
		buildmenuitem defaultmenu, 900, 43001, NEWTABLE_TAGS_MENU_MSG\9NEWTABLE_TAGS_KEY_MSG, NEWTABLE_TAGS_ACTION\1NEWTABLE_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 43002, THEADING_TAGS_MENU_MSG\9THEADING_TAGS_KEY_MSG, THEADING_TAGS_ACTION\1THEADING_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 43003, TROW_TAGS_MENU_MSG\9TROW_TAGS_KEY_MSG, TROW_TAGS_ACTION\1TROW_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 43004, TENTRY_TAGS_MENU_MSG\9TENTRY_TAGS_KEY_MSG, TENTRY_TAGS_ACTION\1TENTRY_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 43005, TCAPTION_TAGS_MENU_MSG\9TCAPTION_TAGS_KEY_MSG, TCAPTION_TAGS_ACTION\1TCAPTION_TAGS_BAR_MSG,32769,0
	buildmenuitem defaultmenu, 900, 44000, LISTS_SUB_MENU_MSG\9LISTS_SUB_KEY_MSG, LISTS_SUB_ACTION\1LISTS_SUB_BAR_MSG,17,0
		buildmenuitem defaultmenu, 900, 44001, DICTIONARY_TAGS_MENU_MSG\9DICTIONARY_TAGS_KEY_MSG, DICTIONARY_TAGS_ACTION\1DICTIONARY_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 44002, DICTTERM_TAGS_MENU_MSG\9DICTTERM_TAGS_KEY_MSG, DICTTERM_TAGS_ACTION\1DICTTERM_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 44003, DICTDEF_TAGS_MENU_MSG\9DICTDEF_TAGS_KEY_MSG, DICTDEF_TAGS_ACTION\1DICTDEF_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 44004, DIRECTORY_TAGS_MENU_MSG\9DIRECTORY_TAGS_KEY_MSG, DIRECTORY_TAGS_ACTION\1DIRECTORY_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 44005, MENU_TAGS_MENU_MSG\9MENU_TAGS_KEY_MSG, MENU_TAGS_ACTION\1MENU_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 44006, ORDEREDLIST_TAGS_MENU_MSG\9ORDEREDLIST_TAGS_KEY_MSG, ORDEREDLIST_TAGS_ACTION\1ORDEREDLIST_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 44007, UNORDEREDLIST_TAGS_MENU_MSG\9UNORDEREDLIST_TAGS_KEY_MSG, UNORDEREDLIST_TAGS_ACTION\1UNORDEREDLIST_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 44008, LISTITEM_TAGS_MENU_MSG\9LISTITEM_TAGS_KEY_MSG, LISTITEM_TAGS_ACTION\1LISTITEM_TAGS_BAR_MSG,32769,0
	buildmenuitem defaultmenu, 900, 45000, JAVA_SUB_MENU_MSG\9JAVA_SUB_KEY_MSG, JAVA_SUB_ACTION\1JAVA_SUB_BAR_MSG, 17 ,0
		buildmenuitem defaultmenu, 900, 45001, APPLET_TAGS_MENU_MSG\9APPLET_TAGS_KEY_MSG, APPLET_TAGS_ACTION\1APPLET_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 45002, PARAMETER_TAGS_MENU_MSG\9PARAMETER_TAGS_KEY_MSG, PARAMETER_TAGS_ACTION\1PARAMETER_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 45003, SCRIPT_TAGS_MENU_MSG\9SCRIPT_TAGS_KEY_MSG, SCRIPT_TAGS_ACTION\1SCRIPT_TAGS_BAR_MSG,32769,0
	buildmenuitem defaultmenu, 900, 46000, FORMS_SUB_MENU_MSG\9FORMS_SUB_KEY_MSG, FORMS_SUB_ACTION\1FORMS_SUB_BAR_MSG,17,0
		buildmenuitem defaultmenu, 900, 46001, FORM_TAGS_MENU_MSG\9FORM_TAGS_KEY_MSG, FORM_TAGS_ACTION\1FORM_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 46002, INPUT_TAGS_MENU_MSG\9INPUT_TAGS_KEY_MSG, INPUT_TAGS_ACTION\1INPUT_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 46003, SELECT_TAGS_MENU_MSG\9SELECT_TAGS_KEY_MSG, SELECT_TAGS_ACTION\1SELECT_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 46004, OPTION_TAGS_MENU_MSG\9OPTION_TAGS_KEY_MSG, OPTION_TAGS_ACTION\1OPTION_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 46005, TEXTAREA_TAGS_MENU_MSG\9TEXTAREA_TAGS_KEY_MSG, TEXTAREA_TAGS_ACTION\1TEXTAREA_TAGS_BAR_MSG,32769,0
	buildmenuitem defaultmenu, 900, 47000, IMAGES_SUB_MENU_MSG\9IMAGES_SUB_KEY_MSG, IMAGES_SUB_ACTION\1IMAGES_SUB_BAR_MSG,17,0
		buildmenuitem defaultmenu, 900, 47001, IMAGE_TAGS_MENU_MSG\9IMAGE_TAGS_KEY_MSG, IMAGE_TAGS_ACTION\1IMAGE_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 47002, MAP_TAGS_MENU_MSG\9MAP_TAGS_KEY_MSG, MAP_TAGS_ACTION\1MAP_TAGS_BAR_MSG,0,0
		buildmenuitem defaultmenu, 900, 47003, AREA_TAGS_MENU_MSG\9AREA_TAGS_KEY_MSG, AREA_TAGS_ACTION\1AREA_TAGS_BAR_MSG,32769,0
	buildmenuitem defaultmenu, 900, 48000, SPECIAL_SUB_MENU_MSG, \1SPECIAL_SUB_BAR_MSG, 17,0
		buildmenuitem defaultmenu, 900, 48100, MATH_SUB_MENU_MSG, \1MATH_SUB_BAR_MSG, 17, 0
			buildmenuitem defaultmenu, 900, 48101, LESS_THAN_MENU_MSG\9LESS_THAN_KEY_MSG , LESS_THAN_ACTION\1LESS_THAN_BAR_MSG ,0,0
			buildmenuitem defaultmenu, 900, 48102, GREATER_THAN_MENU_MSG\9GREATER_THAN_KEY_MSG , GREATER_THAN_ACTION\1GREATER_THAN_BAR_MSG ,0,0
			buildmenuitem defaultmenu, 900, 48103, NOT_MENU_MSG\9NOT_KEY_MSG , NOT_ACTION\1NOT_BAR_MSG ,0,0
			buildmenuitem defaultmenu, 900, 48104, DEGREE_MENU_MSG\9DEGREE_KEY_MSG , DEGREE_ACTION\1DEGREE_BAR_MSG ,0,0
			buildmenuitem defaultmenu, 900, 48105, PLUSMIN_MENU_MSG\9PLUSMIN_KEY_MSG , PLUSMIN_ACTION\1PLUSMIN_BAR_MSG ,0,0
			buildmenuitem defaultmenu, 900, 48106, MICRO_MENU_MSG\9MICRO_KEY_MSG , MICRO_ACTION\1MICRO_BAR_MSG ,0,0
			buildmenuitem defaultmenu, 900, 48107, MIDDLEDOT_MENU_MSG\9MIDDLEDOT_KEY_MSG , MIDDLEDOT_ACTION\1MIDDLEDOT_BAR_MSG ,0,0
			buildmenuitem defaultmenu, 900, 48108, FOURTH_MENU_MSG\9FOURTH_KEY_MSG , FOURTH_ACTION\1FOURTH_BAR_MSG ,0,0
			buildmenuitem defaultmenu, 900, 48109, HALF_MENU_MSG\9HALF_KEY_MSG , HALF_ACTION\1HALF_BAR_MSG ,0,0
			buildmenuitem defaultmenu, 900, 48110, THRFOURTH_MENU_MSG\9THRFOURTH_KEY_MSG , THRFOURTH_ACTION\1THRFOURTH_BAR_MSG ,0,0
			buildmenuitem defaultmenu, 900, 48111, MULT_MENU_MSG\9MULT_KEY_MSG , MULT_ACTION\1MULT_BAR_MSG ,0,0
			buildmenuitem defaultmenu, 900, 48112, DIVIDE_MENU_MSG\9DIVIDE_KEY_MSG , DIVIDE_ACTION\1DIVIDE_BAR_MSG ,32769,0
		buildmenuitem defaultmenu, 900, 48200, LETTERS_SUB_MENU_MSG, \1LETTERS_SUB_BAR_MSG, 17,0
			buildmenuitem defaultmenu, 900, 48210, AS_SUB_MENU_MSG, \1AS_SUB_BAR_MSG, 17,0
				buildmenuitem defaultmenu, 900, 48211, AELIG_U_MEN_MSG\9AELIG_U_KEY_MSG  , AELIG_U_ACTION\1AELIG_U_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 48212, AACUTE_U_MEN_MSG\9AACUTE_U_KEY_MSG  , AACUTE_U_ACTION\1AACUTE_U_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 48213, ACIRC_U_MEN_MSG\9ACIRC_U_KEY_MSG  , ACIRC_U_ACTION\1ACIRC_U_BAR_MSG ,0,0
				buildmenuitem defaultmenu, 900, 48214, AGRAVE_U_MEN_MSG\9AGRAVE_U_KEY_MSG , AGRAVE_U_ACTION\1AGRAVE_U_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 48215, ARING_U_MEN_MSG\9ARING_U_KEY_MSG  , ARING_U_ACTION\1ARING_U_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 48216, ATILDE_U_MEN_MSG\9ATILDE_U_KEY_MSG  , ATILDE_U_ACTION\1ATILDE_U_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 48217, AUML_U_MEN_MSG\9AUML_U_KEY_MSG  , AUML_U_ACTION\1AUML_U_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 48218, AELIG_L_MEN_MSG\9AELIG_L_KEY_MSG  , AELIG_L_ACTION\1AELIG_L_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 48219, AACUTE_L_MEN_MSG\9AACUTE_L_KEY_MSG  , AACUTE_L_ACTION\1AACUTE_L_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 58210, ACIRC_L_MEN_MSG\9ACIRC_L_KEY_MSG  , ACIRC_L_ACTION\1ACIRC_L_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 58211, AGRAVE_L_MEN_MSG\9AGRAVE_L_KEY_MSG  , AGRAVE_L_ACTION\1AGRAVE_L_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 58212, ARING_L_MEN_MSG\9ARING_L_KEY_MSG  , ARING_L_ACTION\1ARING_L_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 58213, ATILDE_L_MEN_MSG\9ATILDE_L_KEY_MSG  , ATILDE_L_ACTION\1ATILDE_L_BAR_MSG  ,0,0
				buildmenuitem defaultmenu, 900, 58214, AUML_L_MEN_MSG\9AUML_L_KEY_MSG  , AUML_L_ACTION\1AUML_L_BAR_MSG  ,32769,0
			buildmenuitem defaultmenu, 900, 48220, ES_SUB_MENU_MSG, \1ES_SUB_BAR_MSG, 17,0
				buildmenuitem defaultmenu, 900, 48221, EACUTE_U_MEN_MSG\9EACUTE_U_KEY_MSG ,EACUTE_U_ACTION\1EACUTE_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48222, ECIRC_U_MEN_MSG\9ECIRC_U_KEY_MSG , ECIRC_U_ACTION\1ECIRC_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48223, EGRAVE_U_MEN_MSG\9EGRAVE_U_KEY_MSG , EGRAVE_U_ACTION\1EGRAVE_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48224, EUML_U_MEN_MSG\9EUML_U_KEY_MSG , EUML_U_ACTION\1EUML_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48225, EACUTE_L_MEN_MSG\9EACUTE_L_KEY_MSG , EACUTE_L_ACTION\1EACUTE_L_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48226, ECIRC_L_MEN_MSG\9ECIRC_L_KEY_MSG , ECIRC_L_ACTION\1ECIRC_L_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48227, EGRAVE_L_MEN_MSG\9EGRAVE_L_KEY_MSG , EGRAVE_L_ACTION\1EGRAVE_L_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48228, EUML_L_MEN_MSG\9EUML_L_KEY_MSG , EUML_L_ACTION\1EUML_L_BAR_MSG , 32769, 0
			buildmenuitem defaultmenu, 900, 48230, IS_SUB_MENU_MSG, \1IS_SUB_BAR_MSG, 17,0
				buildmenuitem defaultmenu, 900, 48231, IACUTE_U_MEN_MSG\9IACUTE_U_KEY_MSG , IACUTE_U_ACTION\1IACUTE_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48232, ICIRC_U_MEN_MSG\9ICIRC_U_KEY_MSG , ICIRC_U_ACTION\1ICIRC_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48233, IGRAVE_U_MEN_MSG\9IGRAVE_U_KEY_MSG , IGRAVE_U_ACTION\1IGRAVE_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48234, IUML_U_MEN_MSG\9IUML_U_KEY_MSG , IUML_U_ACTION\1IUML_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48235, IACUTE_L_MEN_MSG\9IACUTE_L_KEY_MSG , IACUTE_L_ACTION\1IACUTE_L_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48236, ICIRC_L_MEN_MSG\9ICIRC_L_KEY_MSG , ICIRC_L_ACTION\1ICIRC_L_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48237, IGRAVE_L_MEN_MSG\9IGRAVE_L_KEY_MSG , IGRAVE_L_ACTION\1IGRAVE_L_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48238, IUML_L_MEN_MSG\9IUML_L_KEY_MSG , IUML_L_ACTION\1IUML_L_BAR_MSG , 32769, 0
			buildmenuitem defaultmenu, 900, 48240, OS_SUB_MENU_MSG, \1OS_SUB_BAR_MSG, 17,0
				buildmenuitem defaultmenu, 900, 48241, OACUTE_U_MEN_MSG\9OACUTE_U_KEY_MSG, OACUTE_U_ACTION\1OACUTE_U_BAR_MSG, 0, 0
				buildmenuitem defaultmenu, 900, 48242, OCIRC_U_MEN_MSG\9OCIRC_U_KEY_MSG, OCIRC_U_ACTION\1OCIRC_U_BAR_MSG, 0, 0
				buildmenuitem defaultmenu, 900, 48244, OGRAVE_U_MEN_MSG\9OGRAVE_U_KEY_MSG, OGRAVE_U_ACTION\1OGRAVE_U_BAR_MSG, 0, 0
				buildmenuitem defaultmenu, 900, 48245, OSLASH_U_MEN_MSG\9OSLASH_U_KEY_MSG, OSLASH_U_ACTION\1OSLASH_U_BAR_MSG, 0, 0
				buildmenuitem defaultmenu, 900, 48246, OTILDE_U_MEN_MSG\9OTILDE_U_KEY_MSG, OTILDE_U_ACTION\1OTILDE_U_BAR_MSG, 0, 0
				buildmenuitem defaultmenu, 900, 48247, OUML_U_MEN_MSG\9OUML_U_KEY_MSG, OUML_U_ACTION\1OUML_U_BAR_MSG, 0, 0
				buildmenuitem defaultmenu, 900, 48248, OACUTE_L_MEN_MSG\9OACUTE_L_KEY_MSG, OACUTE_L_ACTION\1OACUTE_L_BAR_MSG, 0, 0
				buildmenuitem defaultmenu, 900, 48249, OCIRC_L_MEN_MSG\9OCIRC_L_KEY_MSG, OCIRC_L_ACTION\1OCIRC_L_BAR_MSG, 0, 0
				buildmenuitem defaultmenu, 900, 58250, OGRAVE_L_MEN_MSG\9OGRAVE_L_KEY_MSG, OGRAVE_L_ACTION\1OGRAVE_L_BAR_MSG, 0, 0
				buildmenuitem defaultmenu, 900, 58251, OSLASH_L_MEN_MSG\9OSLASH_L_KEY_MSG, OSLASH_L_ACTION\1OSLASH_L_BAR_MSG, 0, 0
				buildmenuitem defaultmenu, 900, 58252, OTILDE_L_MEN_MSG\9OTILDE_L_KEY_MSG, OTILDE_L_ACTION\1OTILDE_L_BAR_MSG, 0, 0
				buildmenuitem defaultmenu, 900, 58253, OUML_L_MEN_MSG\9OUML_L_KEY_MSG, OUML_L_ACTION\1OUML_L_BAR_MSG, 32769, 0
			buildmenuitem defaultmenu, 900, 48250, US_SUB_MENU_MSG, \1US_SUB_BAR_MSG, 17,0
				buildmenuitem defaultmenu, 900, 48251, UACUTE_U_MEN_MSG\9UACUTE_U_KEY_MSG , UACUTE_U_ACTION\1UACUTE_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48252, UCIRC_U_MEN_MSG\9UCIRC_U_KEY_MSG , UCIRC_U_ACTION\1UCIRC_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48253, UGRAVE_U_MEN_MSG\9UGRAVE_U_KEY_MSG , UGRAVE_U_ACTION\1UGRAVE_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48254, UUML_U_MEN_MSG\9UUML_U_KEY_MSG , UUML_U_ACTION\1UUML_U_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48255, UACUTE_L_MEN_MSG\9UACUTE_L_KEY_MSG , UACUTE_L_ACTION\1UACUTE_L_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48256, UCIRC_L_MEN_MSG\9UCIRC_L_KEY_MSG , UCIRC_L_ACTION\1UCIRC_L_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48257, UGRAVE_L_MEN_MSG\9UGRAVE_L_KEY_MSG , UGRAVE_L_ACTION\1UGRAVE_L_BAR_MSG , 0, 0
				buildmenuitem defaultmenu, 900, 48258, UUML_L_MEN_MSG\9UUML_L_KEY_MSG , UUML_L_ACTION\1UUML_L_BAR_MSG , 32769, 0
			buildmenuitem defaultmenu, 900, 48201, CCEDIL_U_MEN_MSG\9CCEDIL_U_KEY_MSG , CCEDIL_U_ACTION\1CCEDIL_U_BAR_MSG , 0, 0
			buildmenuitem defaultmenu, 900, 48202, ETH_U_MEN_MSG\9ETH_U_KEY_MSG , ETH_U_ACTION\1ETH_U_BAR_MSG , 0, 0
			buildmenuitem defaultmenu, 900, 48203, NTILDE_U_MEN_MSG\9NTILDE_U_KEY_MSG , NTILDE_U_ACTION\1NTILDE_U_BAR_MSG , 0, 0
			buildmenuitem defaultmenu, 900, 48204, THORN_U_MEN_MSG\9THORN_U_KEY_MSG , THORN_U_ACTION\1THORN_U_BAR_MSG , 0, 0
			buildmenuitem defaultmenu, 900, 48205, YACUTE_U_MEN_MSG\9YACUTE_U_KEY_MSG , YACUTE_U_ACTION\1YACUTE_U_BAR_MSG , 0, 0
			buildmenuitem defaultmenu, 900, 48206, CCEDIL_L_MEN_MSG\9CCEDIL_L_KEY_MSG , CCEDIL_L_ACTION\1CCEDIL_L_BAR_MSG , 0, 0
			buildmenuitem defaultmenu, 900, 48207, ETH_L_MEN_MSG\9ETH_L_KEY_MSG , ETH_L_ACTION\1ETH_L_BAR_MSG , 0, 0
			buildmenuitem defaultmenu, 900, 48208, NTILDE_L_MEN_MSG\9NTILDE_L_KEY_MSG , NTILDE_L_ACTION\1NTILDE_L_BAR_MSG , 0, 0
			buildmenuitem defaultmenu, 900, 48209, THORN_L_MEN_MSG\9THORN_L_KEY_MSG , THORN_L_ACTION\1THORN_L_BAR_MSG , 0, 0
			buildmenuitem defaultmenu, 900, 68210, YACUTE_L_MEN_MSG\9YACUTE_L_KEY_MSG , YACUTE_L_ACTION\1YACUTE_L_BAR_MSG , 0, 0
			buildmenuitem defaultmenu, 900, 68211, YUML_L_MEN_MSG\9YUML_L_KEY_MSG , YUML_L_ACTION\1YUML_L_BAR_MSG , 0, 0
			buildmenuitem defaultmenu, 900, 68212, SZLIG_MEN_MSG\9SZLIG_KEY_MSG , SZLIG_ACTION\1SZLIG_BAR_MSG , 32769, 0
			buildmenuitem defaultmenu, 900, 48300, CURRENCY_SUB_MENU_MSG, \1CURRENCY_SUB_BAR_MSG, 17, 0
				buildmenuitem defaultmenu, 900, 48301, CENT_MENU_MSG\9CENT_KEY_MSG , CENT_ACTION\1CENT_BAR_MSG ,0 ,0
				buildmenuitem defaultmenu, 900, 48302, POUND_MENU_MSG\9POUND_KEY_MSG , POUND_ACTION\1POUND_BAR_MSG ,0 ,0
				buildmenuitem defaultmenu, 900, 48303, GENCUR_MENU_MSG\9GENCUR_KEY_MSG , GENCUR_ACTION\1GENCUR_BAR_MSG ,0 ,0
				buildmenuitem defaultmenu, 900, 48304, YEN_MENU_MSG\9YEN_KEY_MSG , YEN_ACTION\1YEN_BAR_MSG ,32769 ,0
			buildmenuitem defaultmenu, 900, 48001, INVERT_EX_MENU_MSG\9INVERT_EX_KEY_MSG , INVERT_EX_ACTION\1INVERT_EX_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48002, BVBAR_MENU_MSG\9BVBAR_KEY_MSG , BVBAR_ACTION\1BVBAR_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48003, SECTION_MENU_MSG\9SECTION_KEY_MSG , SECTION_ACTION\1SECTION_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48004, UMLAUT_MENU_MSG\9UMLAUT_KEY_MSG , UMLAUT_ACTION\1UMLAUT_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48005, COPYRIGHT_MENU_MSG\9COPYRIGHT_KEY_MSG , COPYRIGHT_ACTION\1COPYRIGHT_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48006, FEMININE_MENU_MSG\9FEMININE_KEY_MSG , FEMININE_ACTION\1FEMININE_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48007, MASCULINE_MENU_MSG\9MASCULINE_KEY_MSG , MASCULINE_ACTION\1MASCULINE_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48008, LGUI_MENU_MSG\9LGUI_KEY_MSG , LGUI_ACTION\1LGUI_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48009, RGUI_MENU_MSG\9RGUI_KEY_MSG , RGUI_ACTION\1RGUI_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48010, SUPONE_MENU_MSG\9SUPONE_KEY_MSG , SUPONE_ACTION\1SUPONE_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48011, SUPTWO_MENU_MSG\9SUPTWO_KEY_MSG , SUPTWO_ACTION\1SUPTWO_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48012, SUPTHREE_MENU_MSG\9SUPTHREE_KEY_MSG , SUPTHREE_ACTION\1SUPTHREE_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48013, SOFTHYPHEN_MENU_MSG\9SOFTHYPHEN_KEY_MSG , SOFTHYPHEN_ACTION\1SOFTHYPHEN_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48014, RTM_MENU_MSG\9RTM_KEY_MSG , RTM_ACTION\1RTM_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48015, MACRON_MENU_MSG\9MACRON_KEY_MSG , MACRON_ACTION\1MACRON_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48016, ACUTE_MENU_MSG\9ACUTE_KEY_MSG , ACUTE_ACTION\1ACUTE_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48017, PARAGRAPHCHAR_MENU_MSG\9PARAGRAPHCHAR_KEY_MSG , PARAGRAPHCHAR_ACTION\1PARAGRAPHCHAR_BAR_MSG ,0 ,0
			buildmenuitem defaultmenu, 900, 48018, INVQUESTION_MENU_MSG\9INVQUESTION_KEY_MSG , INVQUESTION_ACTION\1INVQUESTION_BAR_MSG ,32769 ,0
	buildmenuitem defaultmenu, 900, 40005, ANCHOR_TAGS_MENU_MSG\9ANCHOR_TAGS_KEY_MSG, ANCHOR_TAGS_ACTION\1ANCHOR_TAGS_BAR_MSG, 0, 0
	buildmenuitem defaultmenu, 900, 40006, LINEBREAK_TAGS_MENU_MSG\9LINEBREAK_TAGS_KEY_MSG, LINEBREAK_TAGS_ACTION\1LINEBREAK_TAGS_BAR_MSG, 0, 0
	buildmenuitem defaultmenu, 900, 40007, REPEATLAST_TAGS_MENU_MSG\9REPEATLAST_TAGS_KEY_MSG, REPEATLAST_TAGS_ACTION\1REPEATLAST_TAGS_BAR_MSG, 0, 0
	buildmenuitem defaultmenu, 900, 40008, TEMP_VIEW_CTRL_MENU_MSG\9TEMP_VIEW_CTRL_KEY_MSG, TEMP_VIEW_CTRL_ACTION\1TEMP_VIEW_CTRL_BAR_MSG, 0, 0
	buildmenuitem defaultmenu, 900, 40009, \0, '', 4, 0
	buildmenuitem defaultmenu, 900, 49000, INTERFACE_SUB_MENU_MSG\9INTERFACE_SUB_KEY_MSG, INTERFACE_SUB_ACTION\1INTERFACE_SUB_BAR_MSG, 17,0
		buildmenuitem defaultmenu, 900, 49001, SETDEFAULTS_CTRL_MENU_MSG\9SETDEFAULTS_CTRL_KEY_MSG, SETDEFAULTS_CTRL_ACTION\1SETDEFAULTS_CTRL_BAR_MSG, 0,0
		buildmenuitem defaultmenu, 900, 49002, LOADDEFAULTS_CTRL_MENU_MSG\9LOADDEFAULTS_CTRL_KEY_MSG, LOADDEFAULTS_CTRL_ACTION\1LOADDEFAULTS_CTRL_BAR_MSG, 0,0
		buildmenuitem defaultmenu, 900, 49003, SAVEDEFAULTS_CTRL_MENU_MSG\9SAVEDEFAULTS_CTRL_KEY_MSG, SAVEDEFAULTS_CTRL_ACTION\1SAVEDEFAULTS_CTRL_BAR_MSG, 0,0
		buildmenuitem defaultmenu, 900, 49004, CLEARDEFAULTS_CTRL_MENU_MSG\9CLEARDEFAULTS_CTRL_KEY_MSG, CLEARDEFAULTS_CTRL_ACTION\1CLEARDEFAULTS_CTRL_BAR_MSG, 0,0
		buildmenuitem defaultmenu, 900, 49005, TOGGLECASE_CTRL_MENU_MSG\9TOGGLECASE_CTRL_KEY_MSG, TOGGLECASE_CTRL_ACTION\1TOGGLECASE_CTRL_BAR_MSG, 32769,0
		call readd_help_menu()
	buildmenuitem defaultmenu, 6, 40090, \0, '', 4, 0
	buildmenuitem defaultmenu, 6, 49991, 'XTML Docs ', 'HTML Docs',17, 0
		buildmenuitem defaultmenu, 6, 49992, 'HTML Docs ', 'view wilbur',0, 0
		buildmenuitem defaultmenu, 6, 49993, 'Current Word ', 'viewword wilbur',0, 0
call maybe_show_menu()
showmenu defaultmenu

defc New_Html
	x=1
	do while already_in_ring('new'x'.html', someID)
	x=x+1
	enddo
	'e new'x'.html'


defc Temp_View
	delete_ea('.LONGNAME')
	's =htmlkeystemp'
	filepath=getFileArrEl('U_PATH')'htmlkeystemp'
	sayerror filepath
	'start 'JAVA_HTML_BROWSER' 'filepath
COMPILE ENDIF
