compile if not defined(SMALL)  -- If SMALL not defined, then being separately compiled
 define INCLUDING_FILE = 'HTMLTAGS.E'
const
   tryinclude 'MYCNF.E'        -- the user's configuration customizations.   
 compile if not defined(SITE_CONFIG)
    const SITE_CONFIG = 'SITECNF.E'
 compile endif
 compile if SITE_CONFIG
    tryinclude SITE_CONFIG
 compile endif
compile endif


const
compile if not defined(WANT_DYNAMIC_PROMPTS)
   WANT_DYNAMIC_PROMPTS = 1
compile endif
compile if EVERSION < '5.21'
   TILDE_CHAR = ''
compile else
   TILDE_CHAR = '~'
compile endif
   AF_CHAR        =   1   -- key style constants (from STDCONST.E)
   AF_ALT         =  32


const  -- Text defined separately, for easier NLS translation
   HTMLVERSION=      '0.95'
   HTMLTAGS_BAR__MSG =      TILDE_CHAR'HTML '
   TITLE_MENU_MSG =          '~Title'
   CENTER_MENU_MSG =          '~Center'
   SEPARATORS_MENU_MSG =     '~Separators'
   PARAGRAPH_MENU__MSG =      '~Paragraph'
   FORCEDLINE_MENU_MSG =      '~Forced Line Break'
   HORIZONTALRULE_MENU_MSG =  '~Horizontal rule'
   ANCHOR_MENU_MSG =          'Lin~k to'
   IMAGE_MENU_MSG =          '~Image Inline'
   TARGET_MENU_MSG=         '~Target'
   HEADINGS_MENU__MSG =      '~Headings'
   HEAD1_MENU__MSG =           'Heading ~1'
   HEAD2_MENU__MSG =           'Heading ~2'
   HEAD3_MENU__MSG =           'Heading ~3'
   HEAD4_MENU__MSG =           'Heading ~4'
   HEAD5_MENU__MSG =           'Heading ~5'
   HEAD6_MENU__MSG =           'Heading ~6'
   STYLES_MENU_MSG =          '~Styles'
   LOGICAL_MENU_MSG =          '~Logical Styles'
   EM_MENU__MSG =               '~Emphasize'
   STRONG_MENU_MSG =            '~Strong emphasize'
   PREFORMAT_MENU_MSG =         '~Preformated Text'
   PHYSICAL_MENU__MSG =        '~Physical styles'
   UNDERLINE_MENU__MSG =        '~Underline'
   ITALIC_MENU__MSG =           '~Italic'
   BOLD_MENU__MSG =             '~Bold'
   TYPEWRITER_MENU__MSG =       '~Typewriter'
   LISTS_MENU_MSG =            '~Lists'
   LIST_ITEM_MENU__MSG =         'List ~Item'
   OLIST_MENU__MSG =            '~Ordered list'
   ULIST_MENU__MSG =            '~Unordered list'
   SLIST_MENU__MSG =            '~Menu list'
   DLIST_MENU__MSG =             'Definition ~List'
   DLISTTERM_MENU_MSG =          'Definition List ~Term'
   DLISTDEF_MENU_MSG =           'Definition List ~Definition'
   SPECIAL_MENU_MSG =           'Speci~al Characters'
   LEFTANGLE_MENU_MSG =          '~<'
   RIGHTANGLE_MENU_MSG =         '~>'
   A_ACUTE_MENU_MSG =            '    - C_A'
   E_ACUTE_MENU_MSG =            '    - C_E'
   I_ACUTE_MENU_MSG =            '    - C_I'
   O_ACUTE_MENU_MSG =            '    - C_O'
   U_ACUTE_MENU_MSG =            '    - C_U'
   AMPERSAND_MENU_MSG =          'Am~persand'
   QUOTES_MENU_MSG =             '~Quotes'
   TILDE_MENU_MSG  =             '~Tilde'
   ACCENT_MENU_MSG =             '~Acute accent'
   FORMS_MENU_MSG =             '~Forms'
   DEFFORMS_MENU_MSG =         '~Define Form'
   INPUTFIELD_MENU_MSG =       '~Input field'
   SELECTFIELD_MENU_MSG =      '~Select field'
   SELECTOPTION_MENU_MSG =    'Select ~Option'
   TEXTAREA_MENU_MSG =        '~Text area'
   DOC_MENU__MSG =              'Docu~ments'
   HTMLDOC_MENU__MSG =          '~Basic HTML doc'
   ABOUT_MENU_MSG =             '~About...'

compile if WANT_DYNAMIC_PROMPTS
   HTMLTAGS_BARP__MSG = \1'Create HTLM tags'
   TITLE_MENUP_MSG = \1'Insert Title TAG '
   CENTER_MENUP_MSG = \1'Center the text'
   SEPARATORS_MENUP_MSG = \1'Paragraphs, Line Breaks & Rules'
   PARAGRAPH_MENUP__MSG = \1'Insert a Paragraph tag'
   FORCEDLINE_MENUP_MSG = \1'Insert a Forced Line Break'
   HORIZONTALRULE_MENUP_MSG = \1'Insert an horizontal rule'
   ANCHOR_MENUP_MSG = \1'Create a link'
   IMAGE_MENUP_MSG = \1'Insert an image'
   TARGET_MENUP_MSG = \1'Define a target location in the page'
   HEADINGS_MENUP__MSG = \1'Select size of a heading'
   HEAD1_MENUP__MSG = \1'Select heading size 1'
   HEAD2_MENUP__MSG = \1'Select heading size 2'
   HEAD3_MENUP__MSG = \1'Select heading size 3'
   HEAD4_MENUP__MSG = \1'Select heading size 4'
   HEAD5_MENUP__MSG = \1'Select heading size 5'
   HEAD6_MENUP__MSG = \1'Select heading size 6'
   STYLES_MENUP_MSG = \1'Select the text style '
   LOGICAL_MENUP_MSG = \1'Select between logical styles'
   EM_MENUP__MSG = \1'Set emphasized style for selected text'
   STRONG_MENUP_MSG = \1'Set strong emphasized style for selected text'
   PREFORMAT_MENUP_MSG = \1'Let the selected text "as it is"'
   PHYSICAL_MENUP__MSG = \1'Select physical style'
   UNDERLINE_MENUP__MSG =\1'Set underline style for the selected text'
   ITALIC_MENUP__MSG = \1'Set italic style for the selected text'
   BOLD_MENUP__MSG = \1'Select bold style for the selected text'
   TYPEWRITER_MENUP__MSG = \1'Select typewriter style for the selected text'
   LISTS_MENUP_MSG = \1'Lists related tags'
   LIST_ITEM_MENUP__MSG = \1'Create a list item'
   OLIST_MENUP__MSG = \1'Create an ordered list'
   ULIST_MENUP__MSG = \1'Create an unordered list'
   SLIST_MENUP__MSG = \1'Create a menu list'
   DLIST_MENUP__MSG = \1'Create a definition list'
   DLISTTERM_MENUP_MSG = \1'Insert a definition list term tag'
   DLISTDEF_MENUP_MSG = \1'Insert a definition list definition tag'
   SPECIAL_MENUP_MSG = \1'Insert Special Characters'
   LEFTANGLE_MENUP_MSG = \1'Insert a left angle sign'
   RIGHTANGLE_MENUP_MSG = \1'Insert a right angle sign'
   AMPERSAND_MENUP_MSG = \1 'Insert the Ampersand sign'
   QUOTES_MENUP_MSG = \1'Insert a double Quotes sign'
   TILDE_MENUP_MSG  =    \1'Tilde'
   ACCENT_MENUP_MSG = \1'Acute accent'    
   FORMS_MENUP_MSG = \1'HTML Forms Interface'
   DEFFORMS_MENUP_MSG = \1'Define a Form'
   INPUTFIELD_MENUP_MSG = \1'Define an Input field'
   SELECTFIELD_MENUP_MSG = \1'Define a Select field'
   SELECTOPTION_MENUP_MSG = \1'Define a Select field Option'
   TEXTAREA_MENUP_MSG = \1'Define a Text Area'
     
   DOC_MENUP__MSG = \1'Creating HTML Documents'
   HTMLDOC_MENUP__MSG = \1'Create a Basic HTML Doc'
compile else
   HTMLTAGS_BARP__MSG = ''
   TITLE_MENUP_MSG = '' 
   SEPARATORS_MENUP_MSG = '' 
   PARAGRAPH_MENUP__MSG = '' 
   FORCEDLINE_MENUP_MSG = '' 
   HORIZONTALRULE_MENUP_MSG = '' 
   ANCHOR_MENUP_MSG = '' 
   IMAGE_MENUP_MSG = ''
   TARGET_MENUP_MSG= "
   HEADINGS_MENUP__MSG = '' 
   HEAD1_MENUP__MSG = '' 
   HEAD2_MENUP__MSG = '' 
   HEAD3_MENUP__MSG = '' 
   HEAD4_MENUP__MSG = '' 
   HEAD5_MENUP__MSG = '' 
   HEAD6_MENUP__MSG = '' 
   STYLES_MENUP_MSG = '' 
   LOGICAL_MENUP_MSG = '' 
   EM_MENUP__MSG = '' 
   STRONG_MENUP_MSG = '' 
   PREFORMAT_MENUP_MSG = '' 
   PHYSICAL_MENUP__MSG = '' 
   UNDERLINE_MENUP__MSG = ''
   ITALIC_MENUP__MSG = '' 
   BOLD_MENUP__MSG = '' 
   TYPEWRITER_MENUP__MSG = '' 
   LISTS_MENUP_MSG = '' 
   LIST_ITEM_MENUP__MSG = '' 
   OLIST_MENUP__MSG = '' 
   ULIST_MENUP__MSG = '' 
   SLIST_MENUP__MSG = '' 
   DLIST_MENUP__MSG = '' 
   DLISTTERM_MENUP_MSG = '' 
   DLISTDEF_MENUP_MSG = '' 
   SPECIAL_MENUP_MSG = '' 
   LEFTANGLE_MENUP_MSG = '' 
   RIGHTANGLE_MENUP_MSG = '' 
   AMPERSAND_MENUP_MSG = '' 
   QUOTES_MENUP_MSG = '' 
   TILDE_MENUP_MSG  = 
   ACCENT_MENUP_MSG = '' 
   FORMS_MENUP_MSG = ""
   DEFFORMS_MENUP_MSG = ""
   INPUTFIELD_MENUP_MSG = ""
   SELECTFIELD_MENUP_MSG =  ""
   SELECTOPTION_MENUP_MSG =  ""
   TEXTAREA_MENU_MSG =  ""
   DOC_MENUP__MSG = '' 
   HTMLDOC_MENUP__MSG = '' 
compile endif


definit
   universal defaultmenu, activemenu
   universal activeaccel
   universal HTML_tags_menu_flag
   deletemenu defaultmenu, 6, 0, 0  -- delete the existing Help menu (we want it to stay at the right)

   buildsubmenu defaultmenu, 80, HTMLTAGS_BAR__MSG, ' ', 0, 0
     buildmenuitem defaultmenu, 80, 8000,TITLE_MENU_MSG,'HTML_EM TITLE'TITLE_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8001,CENTER_MENU_MSG,'HTML_EM CENTER'CENTER_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8002,\0,'',4,0
     buildmenuitem defaultmenu, 80, 8003,SEPARATORS_MENU_MSG,SEPARATORS_MENUP_MSG,17,0
     buildmenuitem defaultmenu, 80, 8004,PARAGRAPH_MENU__MSG,'HTML_INL <P>'PARAGRAPH_MENUP__MSG,0,0
     buildmenuitem defaultmenu, 80, 8005,FORCEDLINE_MENU_MSG,'HTML_INL <BR>'FORCEDLINE_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8006,HORIZONTALRULE_MENU_MSG,'HTML_INL <HR>'HORIZONTALRULE_MENUp_MSG,32769,0
     buildmenuitem defaultmenu, 80, 8007,\0,'',4,0
 
     buildmenuitem defaultmenu, 80, 8008,ANCHOR_MENU_MSG,'HTML_ANCHOR'ANCHOR_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8009,IMAGE_MENU_MSG,'HTML_IMAGE'IMAGE_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 80010,TARGET_MENU_MSG,'HTML_TARGET'TARGET_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8019,\0,'',4,0

     buildmenuitem defaultmenu, 80, 8020, HEADINGS_MENU__MSG, HEADINGS_MENUP__MSG, 17, 0
     buildmenuitem defaultmenu, 80, 8021, HEAD1_MENU__MSG, 'HTML_EM H1'HEAD1_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8022, HEAD2_MENU__MSG, 'HTML_EM H2'HEAD2_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8023, HEAD3_MENU__MSG, 'HTML_EM H3'HEAD3_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8024, HEAD4_MENU__MSG, 'HTML_EM H4'HEAD4_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8025, HEAD5_MENU__MSG, 'HTML_EM H5'HEAD5_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8026, HEAD6_MENU__MSG, 'HTML_EM H6'HEAD6_MENUP__MSG, 32769, 0

     buildmenuitem defaultmenu, 80, 8031, LOGICAL_MENU_MSG, LOGICAL_MENUP_MSG,17,0
     buildmenuitem defaultmenu, 80, 8032, EM_MENU__MSG,'HTML_EM EM'EM_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8033, STRONG_MENU_MSG, 'HTML_EM STRONG'STRONG_MENUP_MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8034, PREFORMAT_MENU_MSG,'HTML_EM PRE'PREFORMAT_MENUP_MSG, 32769,0
     buildmenuitem defaultmenu, 80, 8035, PHYSICAL_MENU__MSG,PHYSICAL_MENUP__MSG, 17, 0
     buildmenuitem defaultmenu, 80, 8036, UNDERLINE_MENU__MSG, 'HTML_EM U'UNDERLINE_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8037, ITALIC_MENU__MSG, 'HTML_EM I'ITALIC_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8038, BOLD_MENU__MSG, 'HTML_EM B'BOLD_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8039, TYPEWRITER_MENU__MSG, 'HTML_EM TT'TYPEWRITER_MENUP__MSG, 32769, 0

     buildmenuitem defaultmenu, 80, 8040, LISTS_MENU_MSG, LISTS_MENUP_MSG,17,0
     buildmenuitem defaultmenu, 80, 8041, LIST_ITEM_MENU__MSG, 'HTML_I <LI>'LIST_ITEM_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8042, OLIST_MENU__MSG, 'HTML_EM OL'OLIST_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8043, ULIST_MENU__MSG, 'HTML_EM UL'ULIST_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8044, SLIST_MENU__MSG, 'HTML_EM MENU'SLIST_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8045, DLIST_MENU__MSG, 'HTML_EM DL'DLIST_MENUP__MSG, 0, 0
     buildmenuitem defaultmenu, 80, 8046, DLISTTERM_MENU_MSG,'HTML_I  <DT>'DLISTTERM_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8047, DLISTDEF_MENU_MSG,'HTML_I   <DD>'DLISTDEF_MENUp_MSG,32769,0
     buildmenuitem defaultmenu, 80, 8049, \0,'',4, 0

     buildmenuitem defaultmenu, 80, 8050,SPECIAL_MENU_MSG,SPECIAL_MENUP_MSG,17,0
     buildmenuitem defaultmenu, 80, 8051,LEFTANGLE_MENU_MSG,'HTML_I &lt;'LEFTANGLE_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8052,RIGHTANGLE_MENU_MSG,'HTML_I &gt;'RIGHTANGLE_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8053,AMPERSAND_MENU_MSG,'HTML_I &amp;'AMPERSAND_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8054,QUOTES_MENU_MSG,'HTML_I &quot;'QUOTES_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8055,TILDE_MENU_MSG,'HTML_ACC tilde;'TILDE_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8056,ACCENT_MENU_MSG,'HTML_ACC acute'ACCENT_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8057,A_ACUTE_MENU_MSG,'HTML_I &aacute;',0,0
     buildmenuitem defaultmenu, 80, 8058,E_ACUTE_MENU_MSG,'HTML_I &eacute;',0,0
     buildmenuitem defaultmenu, 80, 8059,I_ACUTE_MENU_MSG,'HTML_I &iacute;',0,0
     buildmenuitem defaultmenu, 80, 8060,O_ACUTE_MENU_MSG,'HTML_I &oacute;',0,0
     buildmenuitem defaultmenu, 80, 8061,U_ACUTE_MENU_MSG,'HTML_I &uacute;',32769,0
     buildmenuitem defaultmenu, 80, 8069,\0,'',4,0

     buildmenuitem defaultmenu, 80, 8070, FORMS_MENU_MSG,FORMS_MENUP_MSG,17,0
     buildmenuitem defaultmenu, 80, 8071, DEFFORMS_MENU_MSG,'HTML_FORM'DEFFORMS_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8072, INPUTFIELD_MENU_MSG,'HTML_INPUT'INPUTFIELD_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8073, SELECTFIELD_MENU_MSG,'HTML_SELECT'SELECTFIELD_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8074, SELECTOPTION_MENU_MSG, 'HTML_OPTION'SELECTOPTION_MENUP_MSG,0,0
     buildmenuitem defaultmenu, 80, 8075, TEXTAREA_MENU_MSG, 'HTML_TEXTAREA'TEXTAREA_MENUP_MSG, 32769,0
     buildmenuitem defaultmenu, 80, 8089,\0,'',4,0

     buildmenuitem defaultmenu, 80, 8090, DOC_MENU__MSG,DOC_MENUP__MSG, 17, 0
     buildmenuitem defaultmenu, 80, 8091, HTMLDOC_MENU__MSG, 'HTML_HTMLDOC'HTMLDOC_MENUP__MSG, 32769, 0
     buildmenuitem defaultmenu, 80, 8095,\0,'',4,0
     buildmenuitem defaultmenu, 80, 8099,ABOUT_MENU_MSG,'HTML_ABOUT',0,0
   call readd_help_menu()
   HTML_tags_menu_flag = 1
   call register_mousehandler(1,'2 CLICK 0','POPUP_MENU')


defexit
   universal defaultmenu, activemenu
   deletemenu defaultmenu,80,0,0
   call maybe_show_menu()
   HTML_tags_menu_flag = 0
   
defc HTML_I
   keyin arg(1)

defc HTML_INL
   keyin arg(1)
   insert
   .col = 0

defc HTML_IML = -- Insert Many Lines
   parse value strip(arg(1),'L') with delim 2 rest
   nextline = .line+1
   do while rest <> ''
      parse value rest with line (delim) rest
      insertline line, nextline
      nextline = nextline + 1
   enddo
   '+2'
   end_line
   .line=.line-1
   
defc HTML_em
   tag = arg(1)
   if marktype() then
    call HTML_insert_tags('<'tag'>', '</'tag'>')
    .col=.col+length(tag)+2
   else
    keyin ('<'tag'></'tag'>')
    .col=.col - length(tag) - 3
   endif
  
defproc HTML_insert_tags(start_tag, end_tag)
   mt = marktype()
   if pos(leftstr(mt,1), 'BC') then  -- Block or Character mark
      getfileid fid
      getmark firstline,lastline,firstcol,lastcol,fileid
      if fid<>fileid then
         sayerror 'Wrong file - check mark'
         return
      endif
   else
      firstline = .line; lastline = .line;
      call pend_word(); lastcol = .col
      call pbegin_word(); firstcol = .col
   endif
   .col=lastcol+1
   lastline
   i_s = insert_state()
   if not i_s then insert_toggle; endif
   keyin end_tag
   firstline
   .col=firstcol
   keyin start_tag
   if pos(leftstr(mt,1), 'BC') then  -- Block or Character mark
      l = length(start_tag)
      call pset_mark(firstline, lastline, firstcol+l, lastcol+(l*(lastline=firstline)), mt, fileid)
   endif
   if not i_s then insert_toggle; endif
   

defc HTML_HTMLDOC
   start_line = .line
   'HTML_IML |<HTML>|<HEAD>|<TITLE></TITLE>|</HEAD>| |<BODY>|</BODY>|</HTML>'
   '+2'
   .col = 8 


defc HTML_ANCHOR
   linktype = listbox("Select Link to ...","/target in this page/local file/target in local file/http/gopher/ftp/news",,,,7)
   if linktype == '' then
      return
   endif
   if linktype == 'target in local file' then
      filename = entrybox('Type Filename')
      targetname = entrybox('Type Target name')
      linktype = filename'#'targetname
      usertxt = ""
   else if linktype == 'local file'  then
      linktype = ''
      usertxt = entrybox('Type Name of Link')
   else if linktype == 'target in this page' then
      linktype = "#"
       usertxt = entrybox('Type target name')
   else  
       linktype = linktype'://'
       usertxt = entrybox('Type Name of Link')
   endif endif
      if usertxt == '' then
         return
      endif
   endif
        
   start_tag = '<A HREF="'||linktype||usertxt||'">'
   end_tag = '</A>'
   if marktype() then
     call HTML_insert_tags(start_tag,end_tag)
   else
     keyin start_tag
     keyin end_tag
   endif
 
defc HTML_TARGET
   usertxt = entrybox('Type Target name')
   if usertxt =="" then
     return
   endif
   start_tag = '<A NAME="'usertxt'">'
   end_tag = '</A>'
   if marktype() then
     call HTML_insert_tags(start_tag,end_tag)
   else
     keyin start_tag
     keyin end_tag
   endif
  
defc HTML_IMAGE
   usertxt = entrybox('Type Image Name')
   if usertxt == '' then
      return
   endif
   alttext = entrybox("Alternative text for non graphics display")
   imag_pos = listbox("Image Alignment","/Top/Middle/Bottom")
   if imag_pos == '' then
      return
   else
      keyin '<IMG SRC='usertxt' ALIGN='imag_pos 'ALT="'alttext'">'
   endif

 
defc HTML_ACC
   mcol = .col
   letter = get_char()
   if pos(letter,'AEIOUaeiou') then
      keyin '&'
      .col = .col + 1
      keyin arg(1)';'
   else  if pos(letter,'Nn') then
            keyin '&'
            .col=.col+1
            keyin arg(1)
         else
            sayerror("Invalid Character for accent in HTML")
            return
         endif
   endif

defproc get_char
   universal linepos,colpos,target
   colpos=.col
   linepos=.line
   getline target
   return substr(target,.col,1)

defc HTML_FORM
   action = entrybox('URL of form processor')
   method = listbox("Method of Exchange","/post/get/")
   tag_1 = '<FORM action="'||action||'" method="'method'">'
   tag_2='</FORM>'
   call HTML_insert_tags(tag_1,tag_2)

defc HTML_INPUT
   type=listbox("Type of Input Field","/text/password/checkbox/radio/submit/reset",,,,6)
   if type=="" then
      return
   endif
   if type=='radio' then
      'HTML_radio'
   else  if type=='checkbox' then
            'HTML_checkbox'
   else  if type=='submit' or type=='reset' then
            valor = entrybox("Text of the Button")
            tag ='<INPUT TYPE="'type'" VALUE="'valor'">'
   else
            name = entrybox('Name of Variable ?')
            valor = entrybox("Default Value")
            size = entrybox("Maximum number of characters")
            tag='<INPUT TYPE="'type'" NAME="'name'" '
            if valor<>"" then
               tag=tag' VALUE="'valor'" '
            endif
            tag=tag' SIZE='size' MAXLENGTH='size'>'
    endif
    keyin tag
    endif  endif

defc HTML_checkbox
   name = entrybox("Name of the input variable?")
   valor = entrybox("Value to return when checked")
   if name == "" or valor == "" then
      return
   endif
   chktxt = entrybox("Text of the button")
   tag = '<INPUT TYPE="CHECKBOX" NAME="'name'" VALUE="'valor'" '
   defchk = listbox("Checked by default ?","/Yes/No/")
   if defchk == "Yes" then
      tag = tag' CHECKED>'
   else
      tag =tag'>'
   endif
   keyin tag || chktxt

defc HTML_radio
      universal option_Array, cadena
      options=''
      rad_name = entrybox('Name of Radio Variable?')
      rad_num = listbox('Number of Radio Buttons',"/1/2/3/4/5",,,,5)
      dispo = listbox("Button disposition","/Row/Column/")
      if dispo = "Row" then
         separator = " "
      else
         separator = "<BR>"
      endif

      do_array 1, opt_id, option_array
      for i =1  to rad_num
         opt = entrybox('Text of Button 'i)
         rad_value = entrybox('Value returned when checked')
         option_str = '<INPUT TYPE=RADIO NAME="'rad_name'" VALUE="'rad_value'">'opt||separator
         do_array 2, opt_id, i, option_Str
      endfor

     for i = 1 to rad_num
        do_array 3, opt_id, i, cadena
        insertline cadena
     endfor


defc HTML_SELECT
   multiselect = 0
   NotMoreChecks = 0

   name = entrybox('Name of select variable')
   if name == "" then
      return
   endif
   sel_num = entrybox("Options number?")
   if not isnum(sel_num) then
      WinMessageBox('HTMLEPM 'HTMLVERSION, 'ERROR: Must be a number',16384)
      return
   endif
   size = entrybox('Number of visible options ?')
   if size == "" then
      return
   endif
   if not isnum(size) then
      WinMessageBox('HTMLEPM 'HTMLVERSION,'ERROR: Must be a number',16384)
      return
   endif
   
   multi = listbox('Multiple selection?',"/single/multiple/")
   if multi=='' then
      return
   else
      if multi=="multiple" then
         multiselect=1
      else
         multi=""
      endif
   endif
   tag_ini= '<SELECT NAME="'name'" SIZE='size || multi'>'
   tag_end = '</SELECT>'
   
   insertline tag_ini
   for i = 1 to sel_num
     valor = entrybox('Text of Option 'i)
     if  NotMoreChecks then
         select = ""
     else
        select = listbox('Selected by default?',"/No/Yes/")
     endif
     tag_1 = '<OPTION'
     if select=='Yes' then
         tag_1 = tag_1 || ' SELECTED'
         if not multiselect then
            NotMoreChecks=1
         endif
     endif
     tag_1 = tag_1 '>'valor
     insertline tag_1
   endfor
   insertline tag_end

defc HTML_OPTION
   valor = entrybox('Option text')
   select = listbox('Selected by default?',"/No/Yes/")
   tag_1 = '<OPTION'
   if select=='Yes' then
      tag_1 = tag_1 || ' SELECTED'
   endif
   tag_1 = tag_1 '>'valor
   keyin tag_1


defc HTML_TEXTAREA
   name = entrybox("Name of variable")
   rows = entrybox("Number of rows")
   cols  = entrybox("Number of columns")
   default = listbox("Default Text ?","/No/Yes/")
   if default == "Yes" then
      defText = entrybox("Type the Default Text")
   else
      defText = ""
   endif
   keyin '<TEXTAREA NAME='name' ROWS='rows' COLS='cols'>'defText'</TEXTAREA>'


defc POPUP_MENU
   colum = .cursorx
   linea = .cursory 
   if linea <1 then
      linea = 1
   endif
   if (.windowheight-linea) <15 then
      linea = .windowheight-15
   endif
   elige = listbox("Select Tag Type",
                   "/Link/Image/Target/Form/Input Field/Select/Option/Text Area/",
                   "/OK/Cancel",linea,colum,8,20)
    if elige="" then return
    else if elige='Link'         then 'HTML_ANCHOR'
    else if elige='Image'        then 'HTML_IMAGE'
    else if elige='Target'       then 'HTML_TARGET'
    else if elige='Form'         then 'HTML_FORM'
    else if elige='Input Field'   then 'HTML_INPUT'
    else if elige='Select'        then 'HTML_SELECT'
    else if elige='Option'       then 'HTML_OPTION'
    else if elige='Text Area'    then 'HTML_TEXTAREA'
    endif endif endif endif endif endif endif endif endif

defc HTML_ABOUT
    linea=.line
    acol = .col
    WinMessageBox('HTML Extensions for EPM',
                     '     Version 'HTMLVERSION ||chr(10)'     (c) E.Areitio 1995', 16384)
    .line = linea
    .col = acol
