/* REXX *********************************************/
/*                                                  */
/* Program name: RSTRFNC                            */
/* Function    : Restore Backup after the failing   */
/*               installation                       */
/*               example for the post-install-      */
/*               failure exit                       */
/*                                                  */
/* Syntax      : Call from the INSTALL.DAT via:     */
/*         START_REXX_IF_FAILURE=RESTOREP dest_path */
/*                                                  */
/* Changes     :                                    */
/*                                                  */
/* Made use of GREED.  21 May 1996 / 21:22:36   JRK */
/****************************************************/
Parse Source envir callType procName
Parse Arg destPath
/*-------------(Write lines into file)--------------*/
filename = destPath'\install.log'
rc = LineOut( filename, 'Destination Directory:' destPath)

/*==============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

/*==========(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

Queue Queue Date( S ) Time() 'Start'  procName
Call SaveFNCFiles destPath
Call DfltFNCFiles destPath
Call SetGrayBColor destPath
Call DelGreedXInfo
Call DelIniAppl 'Sizes and Positions'
Call DelIniKey 'GreedSaveOptions'
Call DelIniKey 'GreedXOptions', 'GreedX'
Queue procName 'completed'

/*================( complete )================*/
Return

CLEARUP:
Return

/*==============( P R O C E D U R E S )==============*/


/*=============( Save current FNC File )=============*/
SaveFNCFiles: Procedure
procName = 'SaveFNCFiles'
Arg destPath
 
Queue Queue Date( S ) Time() 'Start'  procName
/*--------------(Save directory)---------------*/
directory = destPath||'\SAVEPREV'
/*-----------(Find file/Set attributes)-------------*/
rc = SysFileTree( directory||'\*.FNC', fileList, 'FO' )
Do i = 1 To fileList.0
  name  = FileSpec( "Name", fileList.i )   /* FILENAME.EXT */
  delRC = SysFileDelete( destPath'\'name )
  a = "Delete: " destPath'\'name || ", RC="delRC
  Queue Date( S ) Time() a 
  /*------------------(copy file)-------------------*/
  "unpack" fileList.i destPath||"\ >>NUL"
  /* If rc = 0 Then delRC = SysFileDelete( fileList.i ) */
  a = "unpack" fileList.i destPath||"\" || ", RC="rc
  Queue Date( S ) Time() 'Restore:' a
End /* If ... */

Return
/* End SaveFNCFiles */


/*==========( Set Default Gray Background )==========*/
SetGrayBColor: Procedure
procName = 'SetGrayBColor'
Arg destPath

Queue Queue Date( S ) Time() 'Start'  procName
/*---------------(Set key value data)---------------*/
inifile = destPath'\GREED.INI'   /* USER SYSTEM BOTH Pathname */
Queue Date( S ) Time() 'INI file:' inifile
appl    = 'GREEDX'               /* Application name          */
key     = 'Cnr_BColor'           /* Key name                  */
value = SysIni( inifile, appl, key )
If value = '13160392' Then Do
  value   = '13487565'     /* Key value data            */
  result = SysIni( inifile, appl, key, value )
End

Return
/* End SetGrayBColor */



/*============( Delete GreedX info object )============*/
DelGreedXInfo: Procedure
procName = 'DelGreedXInfo'

Queue Queue Date( S ) Time() 'Start'  procName
/*-------------(Destroy a workplace object)------------*/
objectName = '<DEL_GREEDX_INF>' /* ObjectID | Filename */
result = SysDestroyObject( objectName )

Return
/* End DelGreedXInfo */


/*============(Delete Selected INI Key)============*/
DelIniKey: Procedure Expose destPath
procName = 'DelIniKey'
Parse Arg keyName, applName, iniFile

Queue Queue Date( S ) Time() 'Start'  procName
If keyName = '' Then Return -1
/*-------------------(Delete a key)--------------------*/
If iniFile = '' Then
  iniFile = destPath'\GREED.INI'   /* Greed initialization file */
If applName = '' Then
  applName = 'Greed'       /* Application name          */
Queue Date( S ) Time() 'INI file...:' inifile
Queue Date( S ) Time() 'Application:' applName
Queue Date( S ) Time() 'Key........:' keyName

result = SysIni( iniFile, applName, keyName, 'DELETE:')
If result = 'ERROR:' Then
  Return -2
Return 0
/* End DelIniKey */

 

/*============(Delete Selected INI Key)============*/
DelIniAppl: Procedure Expose destPath
procName = 'DelIniAppl'
Parse Arg applName, iniFile

Queue Queue Date( S ) Time() 'Start'  procName
If applName = '' Then Return -1
/*-------------------(Delete a key)--------------------*/
If iniFile = '' Then
  iniFile = destPath'\GREED.INI'   /* Greed initialization file */

Queue Date( S ) Time() 'INI file...:' inifile
Queue Date( S ) Time() 'Application:' applName

result = SysIni( iniFile, applName, 'DELETE:')
If result = 'ERROR:' Then
  Return -2

Return 0
/* End DelIniKey */
 

/*================( Default FNC files )================*/
DfltFNCFiles: Procedure
procName = 'DfltFNCFiles'
Arg destPath
 
Queue Queue Date( S ) Time() 'Start'  procName
Queue Date( S ) Time() 'Create Default FNC Directory'
/*-----------(Find file/Set attributes)-------------*/
rc = SysFileTree( '*.FN@', fileList, 'FO' )
If fileList.0 > 0 Then Do
  Do i = 1 To fileList.0
    /*------------------(copy file)-------------------*/
    "unpack" fileList.i destPath||"\DfltFNCs\ >>NUL"
    a = "unpack" fileList.i destPath||"\DfltFNCs\" || ", RC="rc
    Queue Date( S ) Time() 'Default FNC:' a
  End /* Do ... */

  text = 'This is the directory with default FNC files delivered with GREED.'d2c(13)
  text = text || 'The installation routine will not overwrite your private FNC files.'d2c(13)
  text = text || 'You can also look here at default FNC files, copy the new functions from'd2c(13)
  text = text || 'their into your private FNCs (only necessary if you have made private'd2c(13)
  text = text || 'changes) or replace your files or functions by default.'d2c(13) 
  text = text || ' 'd2c(13) 
  text = text || 'Hint: Use Template Editor to make changes in your FNC files!'d2c(13) 

  filename = destPath||"\DfltFNCs\read.me"
  delRC = SysFileDelete( filename )
  rc = LineOut( filename, text )
  status = Stream( filename, 'C', 'Close' )

End /* If ... */
Else 
  Queue Date( S ) Time() 'Create Default FNC Directory Error. RC='rc

Return
/* End DfltFNCFiles */