/*
 *      Created 1993  IBM Corp.                                            *
 *                                                                         *
 *      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is        *
 *      sample code created by IBM Corporation. This sample code is not    *
 *      part of any standard or IBM product and is provided to you solely  *
 *      for  the purpose of assisting you in the development of your       *    *
 *      applications.  The code is provided "AS IS", without               *
 *      warranty of any kind.  IBM shall not be liable for any damages     *
 *      arising out of your use of the sample code, even if they have been *
 *      advised of the possibility of such damages.                        *                               *
 */
/***************************************************************
 * header file of GDSTEST4 module
 ***************************************************************
 */
/*************************
 * TYPES
 *************************
 */
/* The following structure is used to pass parms from the function which
 * calls the GDSencode routine to the user exit function. The data type
 * depends on the application. In this case, the only parm is a pointer
 * to the current environment. Note that the GDSencode routine passes
 * the pointer to this structure to the decoding user-exit without
 * use it.
 */

struct usrpstruct {             /* parms to pass to encode user-exit */
 struct environment *env;
};

/*************************
 * PROTOTYPES
 *************************
 */
/* the following is the prototype of the user writing routine */
unsigned long mywrite(char *buf, unsigned long buflen, void *usrparms);

/* the following is the prototype of the user reading routine */
unsigned long myread(char *buf, unsigned long buflen, void *usrparms);

/* the following is the prototype of the user-exit for encoding MIU type */
int  encMIU(struct encinh ia,    /* inherited attrs (see enc.h) */
           struct encinhsyn *sa, /* inherited/synthesized attrs */
           enum tagclass cls,    /* class of the item to be encoded */
           long id,              /* identifier of item to be encoded */
           enum frm form,        /* form (primitive/constructed) */
           char *encsubs);       /* indicator for encoding sub-pdus */

/*
 * encALH encoding user exit, for ALH type
 */
int
encALH(struct encinh ia,           /* inherited attrs */
       struct encinhsyn *sa,       /* synthesized and inherited attrs */
       enum tagclass cls,          /* class of item to encode */
       long id,                    /* id of class to encode */
       enum frm form,              /* form (prim or constr) of data to encode */
       char *encsubs               /* set to !0 to encode contained types */
       );

/*
 * encRSH encoding user exit, for RSH type
 */
int
encRSH(struct encinh ia,           /* inherited attrs */
       struct encinhsyn *sa,       /* synthesized and inherited attrs */
       enum tagclass cls,          /* class of item to encode */
       long id,                    /* id of class to encode */
       enum frm form,              /* form (prim or constr) of data to encode */
       char *encsubs               /* set to !0 to encode contained types */
       );

/*
 * encAGD encoding user exit, for AGD
 */
int
encAGD(struct encinh ia,           /* inherited attrs */
       struct encinhsyn *sa,       /* synthesized and inherited attrs */
       enum tagclass cls,          /* class of item to encode */
       long id,                    /* id of class to encode */
       enum frm form,              /* form (prim or constr) of data to encode */
       char *encsubs               /* set to !0 to encode contained types */
       );

/*
 * encMSGCLASS encoding user exit, for MSGCLASS
 */
int
encMSGCLASS(struct encinh ia,         /* inherited attrs */
            struct encinhsyn *sa,     /* synthesized and inherited attrs */
            enum tagclass cls,        /* class of item to encode */
            long id,                  /* id of class to encode */
            enum frm form,            /* form (prim or constr) of data to encode */
            char *encsubs             /* set to !0 to encode contained types */
            );

/*
 * encDESTNAPS encoding user exit, for DESTNAPS
 */
int
encDESTNAPS(struct encinh ia,         /* inherited attrs */
        struct encinhsyn *sa,     /* synthesized and inherited attrs */
        enum tagclass cls,        /* class of item to encode */
        long id,                  /* id of class to encode */
        enum frm form,            /* form (prim or constr) of data to encode */
        char *encsubs             /* set to !0 to encode contained types */
        );

/*
 * encNODENAME encoding user exit, for NODENAME
 */
int
encNODENAME(struct encinh ia,    /* inherited attrs */
       struct encinhsyn *sa,     /* synthesized and inherited attrs */
       enum tagclass cls,        /* class of item to encode */
       long id,                  /* id of class to encode */
       enum frm form,            /* form (prim or constr) of data to encode */
       char *encsubs             /* set to !0 to encode contained types */
       );

/*
 * encAGENTNAME encoding user exit, for AGENTNAME
 */
int
encAGENTNAME(struct encinh ia,         /* inherited attrs */
       struct encinhsyn *sa,     /* synthesized and inherited attrs */
       enum tagclass cls,        /* class of item to encode */
       long id,                  /* id of class to encode */
       enum frm form,            /* form (prim or constr) of data to encode */
       char *encsubs             /* set to !0 to encode contained types */
       );

/*
 * encNAME64 encoding user exit, for NAME64
 */
int
encNAME64(struct encinh ia,        /* inherited attrs */
       struct encinhsyn *sa,     /* synthesized and inherited attrs */
       enum tagclass cls,        /* class of item to encode */
       long id,                  /* id of class to encode */
       enum frm form,            /* form (prim or constr) of data to encode */
       char *encsubs             /* set to !0 to encode contained types */
       );


/* the following are the prototypes of the user-exits for the passing of the
 * content */
int agentdata_cont (char **buff, unsigned long *buflen, enum lastflag *lastf);

/******************
 * MACROS
 ******************
 */
#define NEW(t)          ((t *) mallocate((unsigned) sizeof(t)))
#define NEW2(n, t)      ((t *) mallocate((unsigned) ((n) * sizeof(t))))
